/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.storagetransfer.v1.model;

/**
 * Specifies the metadata options for running a transfer.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Storage Transfer API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class MetadataOptions extends com.google.api.client.json.GenericJson {

  /**
   * Specifies how each object's ACLs should be preserved for transfers between Google Cloud Storage
   * buckets. If unspecified, the default behavior is the same as ACL_DESTINATION_BUCKET_DEFAULT.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String acl;

  /**
   * Specifies how each file's POSIX group ID (GID) attribute should be handled by the transfer. By
   * default, GID is not preserved. Only applicable to transfers involving POSIX file systems, and
   * ignored for other transfers.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String gid;

  /**
   * Specifies how each object's Cloud KMS customer-managed encryption key (CMEK) is preserved for
   * transfers between Google Cloud Storage buckets. If unspecified, the default behavior is the
   * same as KMS_KEY_DESTINATION_BUCKET_DEFAULT.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kmsKey;

  /**
   * Specifies how each file's mode attribute should be handled by the transfer. By default, mode is
   * not preserved. Only applicable to transfers involving POSIX file systems, and ignored for other
   * transfers.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String mode;

  /**
   * Specifies the storage class to set on objects being transferred to Google Cloud Storage
   * buckets. If unspecified, the default behavior is the same as
   * STORAGE_CLASS_DESTINATION_BUCKET_DEFAULT.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String storageClass;

  /**
   * Specifies how symlinks should be handled by the transfer. By default, symlinks are not
   * preserved. Only applicable to transfers involving POSIX file systems, and ignored for other
   * transfers.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String symlink;

  /**
   * Specifies how each object's temporary hold status should be preserved for transfers between
   * Google Cloud Storage buckets. If unspecified, the default behavior is the same as
   * TEMPORARY_HOLD_PRESERVE.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String temporaryHold;

  /**
   * Specifies how each object's `timeCreated` metadata is preserved for transfers. If unspecified,
   * the default behavior is the same as TIME_CREATED_SKIP. This behavior is supported for transfers
   * to Cloud Storage buckets from Cloud Storage, Amazon S3, S3-compatible storage, and Azure
   * sources.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String timeCreated;

  /**
   * Specifies how each file's POSIX user ID (UID) attribute should be handled by the transfer. By
   * default, UID is not preserved. Only applicable to transfers involving POSIX file systems, and
   * ignored for other transfers.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String uid;

  /**
   * Specifies how each object's ACLs should be preserved for transfers between Google Cloud Storage
   * buckets. If unspecified, the default behavior is the same as ACL_DESTINATION_BUCKET_DEFAULT.
   * @return value or {@code null} for none
   */
  public java.lang.String getAcl() {
    return acl;
  }

  /**
   * Specifies how each object's ACLs should be preserved for transfers between Google Cloud Storage
   * buckets. If unspecified, the default behavior is the same as ACL_DESTINATION_BUCKET_DEFAULT.
   * @param acl acl or {@code null} for none
   */
  public MetadataOptions setAcl(java.lang.String acl) {
    this.acl = acl;
    return this;
  }

  /**
   * Specifies how each file's POSIX group ID (GID) attribute should be handled by the transfer. By
   * default, GID is not preserved. Only applicable to transfers involving POSIX file systems, and
   * ignored for other transfers.
   * @return value or {@code null} for none
   */
  public java.lang.String getGid() {
    return gid;
  }

  /**
   * Specifies how each file's POSIX group ID (GID) attribute should be handled by the transfer. By
   * default, GID is not preserved. Only applicable to transfers involving POSIX file systems, and
   * ignored for other transfers.
   * @param gid gid or {@code null} for none
   */
  public MetadataOptions setGid(java.lang.String gid) {
    this.gid = gid;
    return this;
  }

  /**
   * Specifies how each object's Cloud KMS customer-managed encryption key (CMEK) is preserved for
   * transfers between Google Cloud Storage buckets. If unspecified, the default behavior is the
   * same as KMS_KEY_DESTINATION_BUCKET_DEFAULT.
   * @return value or {@code null} for none
   */
  public java.lang.String getKmsKey() {
    return kmsKey;
  }

  /**
   * Specifies how each object's Cloud KMS customer-managed encryption key (CMEK) is preserved for
   * transfers between Google Cloud Storage buckets. If unspecified, the default behavior is the
   * same as KMS_KEY_DESTINATION_BUCKET_DEFAULT.
   * @param kmsKey kmsKey or {@code null} for none
   */
  public MetadataOptions setKmsKey(java.lang.String kmsKey) {
    this.kmsKey = kmsKey;
    return this;
  }

  /**
   * Specifies how each file's mode attribute should be handled by the transfer. By default, mode is
   * not preserved. Only applicable to transfers involving POSIX file systems, and ignored for other
   * transfers.
   * @return value or {@code null} for none
   */
  public java.lang.String getMode() {
    return mode;
  }

  /**
   * Specifies how each file's mode attribute should be handled by the transfer. By default, mode is
   * not preserved. Only applicable to transfers involving POSIX file systems, and ignored for other
   * transfers.
   * @param mode mode or {@code null} for none
   */
  public MetadataOptions setMode(java.lang.String mode) {
    this.mode = mode;
    return this;
  }

  /**
   * Specifies the storage class to set on objects being transferred to Google Cloud Storage
   * buckets. If unspecified, the default behavior is the same as
   * STORAGE_CLASS_DESTINATION_BUCKET_DEFAULT.
   * @return value or {@code null} for none
   */
  public java.lang.String getStorageClass() {
    return storageClass;
  }

  /**
   * Specifies the storage class to set on objects being transferred to Google Cloud Storage
   * buckets. If unspecified, the default behavior is the same as
   * STORAGE_CLASS_DESTINATION_BUCKET_DEFAULT.
   * @param storageClass storageClass or {@code null} for none
   */
  public MetadataOptions setStorageClass(java.lang.String storageClass) {
    this.storageClass = storageClass;
    return this;
  }

  /**
   * Specifies how symlinks should be handled by the transfer. By default, symlinks are not
   * preserved. Only applicable to transfers involving POSIX file systems, and ignored for other
   * transfers.
   * @return value or {@code null} for none
   */
  public java.lang.String getSymlink() {
    return symlink;
  }

  /**
   * Specifies how symlinks should be handled by the transfer. By default, symlinks are not
   * preserved. Only applicable to transfers involving POSIX file systems, and ignored for other
   * transfers.
   * @param symlink symlink or {@code null} for none
   */
  public MetadataOptions setSymlink(java.lang.String symlink) {
    this.symlink = symlink;
    return this;
  }

  /**
   * Specifies how each object's temporary hold status should be preserved for transfers between
   * Google Cloud Storage buckets. If unspecified, the default behavior is the same as
   * TEMPORARY_HOLD_PRESERVE.
   * @return value or {@code null} for none
   */
  public java.lang.String getTemporaryHold() {
    return temporaryHold;
  }

  /**
   * Specifies how each object's temporary hold status should be preserved for transfers between
   * Google Cloud Storage buckets. If unspecified, the default behavior is the same as
   * TEMPORARY_HOLD_PRESERVE.
   * @param temporaryHold temporaryHold or {@code null} for none
   */
  public MetadataOptions setTemporaryHold(java.lang.String temporaryHold) {
    this.temporaryHold = temporaryHold;
    return this;
  }

  /**
   * Specifies how each object's `timeCreated` metadata is preserved for transfers. If unspecified,
   * the default behavior is the same as TIME_CREATED_SKIP. This behavior is supported for transfers
   * to Cloud Storage buckets from Cloud Storage, Amazon S3, S3-compatible storage, and Azure
   * sources.
   * @return value or {@code null} for none
   */
  public java.lang.String getTimeCreated() {
    return timeCreated;
  }

  /**
   * Specifies how each object's `timeCreated` metadata is preserved for transfers. If unspecified,
   * the default behavior is the same as TIME_CREATED_SKIP. This behavior is supported for transfers
   * to Cloud Storage buckets from Cloud Storage, Amazon S3, S3-compatible storage, and Azure
   * sources.
   * @param timeCreated timeCreated or {@code null} for none
   */
  public MetadataOptions setTimeCreated(java.lang.String timeCreated) {
    this.timeCreated = timeCreated;
    return this;
  }

  /**
   * Specifies how each file's POSIX user ID (UID) attribute should be handled by the transfer. By
   * default, UID is not preserved. Only applicable to transfers involving POSIX file systems, and
   * ignored for other transfers.
   * @return value or {@code null} for none
   */
  public java.lang.String getUid() {
    return uid;
  }

  /**
   * Specifies how each file's POSIX user ID (UID) attribute should be handled by the transfer. By
   * default, UID is not preserved. Only applicable to transfers involving POSIX file systems, and
   * ignored for other transfers.
   * @param uid uid or {@code null} for none
   */
  public MetadataOptions setUid(java.lang.String uid) {
    this.uid = uid;
    return this;
  }

  @Override
  public MetadataOptions set(String fieldName, Object value) {
    return (MetadataOptions) super.set(fieldName, value);
  }

  @Override
  public MetadataOptions clone() {
    return (MetadataOptions) super.clone();
  }

}
