/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.storagetransfer.v1.model;

/**
 * Specification to configure notifications published to Pub/Sub. Notifications are published to the
 * customer-provided topic using the following `PubsubMessage.attributes`: * `"eventType"`: one of
 * the EventType values * `"payloadFormat"`: one of the PayloadFormat values * `"projectId"`: the
 * project_id of the `TransferOperation` * `"transferJobName"`: the transfer_job_name of the
 * `TransferOperation` * `"transferOperationName"`: the name of the `TransferOperation` The
 * `PubsubMessage.data` contains a TransferOperation resource formatted according to the specified
 * `PayloadFormat`.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Storage Transfer API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class NotificationConfig extends com.google.api.client.json.GenericJson {

  /**
   * Event types for which a notification is desired. If empty, send notifications for all event
   * types.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> eventTypes;

  /**
   * Required. The desired format of the notification message payloads.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String payloadFormat;

  /**
   * Required. The `Topic.name` of the Pub/Sub topic to which to publish notifications. Must be of
   * the format: `projects/{project}/topics/{topic}`. Not matching this format results in an
   * INVALID_ARGUMENT error.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String pubsubTopic;

  /**
   * Event types for which a notification is desired. If empty, send notifications for all event
   * types.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getEventTypes() {
    return eventTypes;
  }

  /**
   * Event types for which a notification is desired. If empty, send notifications for all event
   * types.
   * @param eventTypes eventTypes or {@code null} for none
   */
  public NotificationConfig setEventTypes(java.util.List<java.lang.String> eventTypes) {
    this.eventTypes = eventTypes;
    return this;
  }

  /**
   * Required. The desired format of the notification message payloads.
   * @return value or {@code null} for none
   */
  public java.lang.String getPayloadFormat() {
    return payloadFormat;
  }

  /**
   * Required. The desired format of the notification message payloads.
   * @param payloadFormat payloadFormat or {@code null} for none
   */
  public NotificationConfig setPayloadFormat(java.lang.String payloadFormat) {
    this.payloadFormat = payloadFormat;
    return this;
  }

  /**
   * Required. The `Topic.name` of the Pub/Sub topic to which to publish notifications. Must be of
   * the format: `projects/{project}/topics/{topic}`. Not matching this format results in an
   * INVALID_ARGUMENT error.
   * @return value or {@code null} for none
   */
  public java.lang.String getPubsubTopic() {
    return pubsubTopic;
  }

  /**
   * Required. The `Topic.name` of the Pub/Sub topic to which to publish notifications. Must be of
   * the format: `projects/{project}/topics/{topic}`. Not matching this format results in an
   * INVALID_ARGUMENT error.
   * @param pubsubTopic pubsubTopic or {@code null} for none
   */
  public NotificationConfig setPubsubTopic(java.lang.String pubsubTopic) {
    this.pubsubTopic = pubsubTopic;
    return this;
  }

  @Override
  public NotificationConfig set(String fieldName, Object value) {
    return (NotificationConfig) super.set(fieldName, value);
  }

  @Override
  public NotificationConfig clone() {
    return (NotificationConfig) super.clone();
  }

}
