/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.storagetransfer.v1.model;

/**
 * Specifies the configuration for running a replication job.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Storage Transfer API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ReplicationSpec extends com.google.api.client.json.GenericJson {

  /**
   * Specifies cloud Storage data sink.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GcsData gcsDataSink;

  /**
   * Specifies cloud Storage data source.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GcsData gcsDataSource;

  /**
   * Specifies the object conditions to only include objects that satisfy these conditions in the
   * set of data source objects. Object conditions based on objects' "last modification time" do not
   * exclude objects in a data sink.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ObjectConditions objectConditions;

  /**
   * Specifies the actions to be performed on the object during replication. Delete options are not
   * supported for replication and when specified, the request fails with an INVALID_ARGUMENT error.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TransferOptions transferOptions;

  /**
   * Specifies cloud Storage data sink.
   * @return value or {@code null} for none
   */
  public GcsData getGcsDataSink() {
    return gcsDataSink;
  }

  /**
   * Specifies cloud Storage data sink.
   * @param gcsDataSink gcsDataSink or {@code null} for none
   */
  public ReplicationSpec setGcsDataSink(GcsData gcsDataSink) {
    this.gcsDataSink = gcsDataSink;
    return this;
  }

  /**
   * Specifies cloud Storage data source.
   * @return value or {@code null} for none
   */
  public GcsData getGcsDataSource() {
    return gcsDataSource;
  }

  /**
   * Specifies cloud Storage data source.
   * @param gcsDataSource gcsDataSource or {@code null} for none
   */
  public ReplicationSpec setGcsDataSource(GcsData gcsDataSource) {
    this.gcsDataSource = gcsDataSource;
    return this;
  }

  /**
   * Specifies the object conditions to only include objects that satisfy these conditions in the
   * set of data source objects. Object conditions based on objects' "last modification time" do not
   * exclude objects in a data sink.
   * @return value or {@code null} for none
   */
  public ObjectConditions getObjectConditions() {
    return objectConditions;
  }

  /**
   * Specifies the object conditions to only include objects that satisfy these conditions in the
   * set of data source objects. Object conditions based on objects' "last modification time" do not
   * exclude objects in a data sink.
   * @param objectConditions objectConditions or {@code null} for none
   */
  public ReplicationSpec setObjectConditions(ObjectConditions objectConditions) {
    this.objectConditions = objectConditions;
    return this;
  }

  /**
   * Specifies the actions to be performed on the object during replication. Delete options are not
   * supported for replication and when specified, the request fails with an INVALID_ARGUMENT error.
   * @return value or {@code null} for none
   */
  public TransferOptions getTransferOptions() {
    return transferOptions;
  }

  /**
   * Specifies the actions to be performed on the object during replication. Delete options are not
   * supported for replication and when specified, the request fails with an INVALID_ARGUMENT error.
   * @param transferOptions transferOptions or {@code null} for none
   */
  public ReplicationSpec setTransferOptions(TransferOptions transferOptions) {
    this.transferOptions = transferOptions;
    return this;
  }

  @Override
  public ReplicationSpec set(String fieldName, Object value) {
    return (ReplicationSpec) super.set(fieldName, value);
  }

  @Override
  public ReplicationSpec clone() {
    return (ReplicationSpec) super.clone();
  }

}
