/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.storagetransfer.v1.model;

/**
 * Transfers can be scheduled to recur or to run just once.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Storage Transfer API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Schedule extends com.google.api.client.json.GenericJson {

  /**
   * The time in UTC that no further transfer operations are scheduled. Combined with
   * schedule_end_date, `end_time_of_day` specifies the end date and time for starting new transfer
   * operations. This field must be greater than or equal to the timestamp corresponding to the
   * combintation of schedule_start_date and start_time_of_day, and is subject to the following: *
   * If `end_time_of_day` is not set and `schedule_end_date` is set, then a default value of
   * `23:59:59` is used for `end_time_of_day`. * If `end_time_of_day` is set and `schedule_end_date`
   * is not set, then INVALID_ARGUMENT is returned.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TimeOfDay endTimeOfDay;

  /**
   * Interval between the start of each scheduled TransferOperation. If unspecified, the default
   * value is 24 hours. This value may not be less than 1 hour.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String repeatInterval;

  /**
   * The last day a transfer runs. Date boundaries are determined relative to UTC time. A job runs
   * once per 24 hours within the following guidelines: * If `schedule_end_date` and
   * schedule_start_date are the same and in the future relative to UTC, the transfer is executed
   * only one time. * If `schedule_end_date` is later than `schedule_start_date` and
   * `schedule_end_date` is in the future relative to UTC, the job runs each day at
   * start_time_of_day through `schedule_end_date`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Date scheduleEndDate;

  /**
   * Required. The start date of a transfer. Date boundaries are determined relative to UTC time. If
   * `schedule_start_date` and start_time_of_day are in the past relative to the job's creation
   * time, the transfer starts the day after you schedule the transfer request. **Note:** When
   * starting jobs at or near midnight UTC it is possible that a job starts later than expected. For
   * example, if you send an outbound request on June 1 one millisecond prior to midnight UTC and
   * the Storage Transfer Service server receives the request on June 2, then it creates a
   * TransferJob with `schedule_start_date` set to June 2 and a `start_time_of_day` set to midnight
   * UTC. The first scheduled TransferOperation takes place on June 3 at midnight UTC.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Date scheduleStartDate;

  /**
   * The time in UTC that a transfer job is scheduled to run. Transfers may start later than this
   * time. If `start_time_of_day` is not specified: * One-time transfers run immediately. *
   * Recurring transfers run immediately, and each day at midnight UTC, through schedule_end_date.
   * If `start_time_of_day` is specified: * One-time transfers run at the specified time. *
   * Recurring transfers run at the specified time each day, through `schedule_end_date`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TimeOfDay startTimeOfDay;

  /**
   * The time in UTC that no further transfer operations are scheduled. Combined with
   * schedule_end_date, `end_time_of_day` specifies the end date and time for starting new transfer
   * operations. This field must be greater than or equal to the timestamp corresponding to the
   * combintation of schedule_start_date and start_time_of_day, and is subject to the following: *
   * If `end_time_of_day` is not set and `schedule_end_date` is set, then a default value of
   * `23:59:59` is used for `end_time_of_day`. * If `end_time_of_day` is set and `schedule_end_date`
   * is not set, then INVALID_ARGUMENT is returned.
   * @return value or {@code null} for none
   */
  public TimeOfDay getEndTimeOfDay() {
    return endTimeOfDay;
  }

  /**
   * The time in UTC that no further transfer operations are scheduled. Combined with
   * schedule_end_date, `end_time_of_day` specifies the end date and time for starting new transfer
   * operations. This field must be greater than or equal to the timestamp corresponding to the
   * combintation of schedule_start_date and start_time_of_day, and is subject to the following: *
   * If `end_time_of_day` is not set and `schedule_end_date` is set, then a default value of
   * `23:59:59` is used for `end_time_of_day`. * If `end_time_of_day` is set and `schedule_end_date`
   * is not set, then INVALID_ARGUMENT is returned.
   * @param endTimeOfDay endTimeOfDay or {@code null} for none
   */
  public Schedule setEndTimeOfDay(TimeOfDay endTimeOfDay) {
    this.endTimeOfDay = endTimeOfDay;
    return this;
  }

  /**
   * Interval between the start of each scheduled TransferOperation. If unspecified, the default
   * value is 24 hours. This value may not be less than 1 hour.
   * @return value or {@code null} for none
   */
  public String getRepeatInterval() {
    return repeatInterval;
  }

  /**
   * Interval between the start of each scheduled TransferOperation. If unspecified, the default
   * value is 24 hours. This value may not be less than 1 hour.
   * @param repeatInterval repeatInterval or {@code null} for none
   */
  public Schedule setRepeatInterval(String repeatInterval) {
    this.repeatInterval = repeatInterval;
    return this;
  }

  /**
   * The last day a transfer runs. Date boundaries are determined relative to UTC time. A job runs
   * once per 24 hours within the following guidelines: * If `schedule_end_date` and
   * schedule_start_date are the same and in the future relative to UTC, the transfer is executed
   * only one time. * If `schedule_end_date` is later than `schedule_start_date` and
   * `schedule_end_date` is in the future relative to UTC, the job runs each day at
   * start_time_of_day through `schedule_end_date`.
   * @return value or {@code null} for none
   */
  public Date getScheduleEndDate() {
    return scheduleEndDate;
  }

  /**
   * The last day a transfer runs. Date boundaries are determined relative to UTC time. A job runs
   * once per 24 hours within the following guidelines: * If `schedule_end_date` and
   * schedule_start_date are the same and in the future relative to UTC, the transfer is executed
   * only one time. * If `schedule_end_date` is later than `schedule_start_date` and
   * `schedule_end_date` is in the future relative to UTC, the job runs each day at
   * start_time_of_day through `schedule_end_date`.
   * @param scheduleEndDate scheduleEndDate or {@code null} for none
   */
  public Schedule setScheduleEndDate(Date scheduleEndDate) {
    this.scheduleEndDate = scheduleEndDate;
    return this;
  }

  /**
   * Required. The start date of a transfer. Date boundaries are determined relative to UTC time. If
   * `schedule_start_date` and start_time_of_day are in the past relative to the job's creation
   * time, the transfer starts the day after you schedule the transfer request. **Note:** When
   * starting jobs at or near midnight UTC it is possible that a job starts later than expected. For
   * example, if you send an outbound request on June 1 one millisecond prior to midnight UTC and
   * the Storage Transfer Service server receives the request on June 2, then it creates a
   * TransferJob with `schedule_start_date` set to June 2 and a `start_time_of_day` set to midnight
   * UTC. The first scheduled TransferOperation takes place on June 3 at midnight UTC.
   * @return value or {@code null} for none
   */
  public Date getScheduleStartDate() {
    return scheduleStartDate;
  }

  /**
   * Required. The start date of a transfer. Date boundaries are determined relative to UTC time. If
   * `schedule_start_date` and start_time_of_day are in the past relative to the job's creation
   * time, the transfer starts the day after you schedule the transfer request. **Note:** When
   * starting jobs at or near midnight UTC it is possible that a job starts later than expected. For
   * example, if you send an outbound request on June 1 one millisecond prior to midnight UTC and
   * the Storage Transfer Service server receives the request on June 2, then it creates a
   * TransferJob with `schedule_start_date` set to June 2 and a `start_time_of_day` set to midnight
   * UTC. The first scheduled TransferOperation takes place on June 3 at midnight UTC.
   * @param scheduleStartDate scheduleStartDate or {@code null} for none
   */
  public Schedule setScheduleStartDate(Date scheduleStartDate) {
    this.scheduleStartDate = scheduleStartDate;
    return this;
  }

  /**
   * The time in UTC that a transfer job is scheduled to run. Transfers may start later than this
   * time. If `start_time_of_day` is not specified: * One-time transfers run immediately. *
   * Recurring transfers run immediately, and each day at midnight UTC, through schedule_end_date.
   * If `start_time_of_day` is specified: * One-time transfers run at the specified time. *
   * Recurring transfers run at the specified time each day, through `schedule_end_date`.
   * @return value or {@code null} for none
   */
  public TimeOfDay getStartTimeOfDay() {
    return startTimeOfDay;
  }

  /**
   * The time in UTC that a transfer job is scheduled to run. Transfers may start later than this
   * time. If `start_time_of_day` is not specified: * One-time transfers run immediately. *
   * Recurring transfers run immediately, and each day at midnight UTC, through schedule_end_date.
   * If `start_time_of_day` is specified: * One-time transfers run at the specified time. *
   * Recurring transfers run at the specified time each day, through `schedule_end_date`.
   * @param startTimeOfDay startTimeOfDay or {@code null} for none
   */
  public Schedule setStartTimeOfDay(TimeOfDay startTimeOfDay) {
    this.startTimeOfDay = startTimeOfDay;
    return this;
  }

  @Override
  public Schedule set(String fieldName, Object value) {
    return (Schedule) super.set(fieldName, value);
  }

  @Override
  public Schedule clone() {
    return (Schedule) super.clone();
  }

}
