/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.storagetransfer.v1.model;

/**
 * This resource represents the configuration of a transfer job that runs periodically.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Storage Transfer API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TransferJob extends com.google.api.client.json.GenericJson {

  /**
   * Output only. The time that the transfer job was created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String creationTime;

  /**
   * Output only. The time that the transfer job was deleted.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String deletionTime;

  /**
   * A description provided by the user for the job. Its max length is 1024 bytes when Unicode-
   * encoded.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Specifies the event stream for the transfer job for event-driven transfers. When EventStream is
   * specified, the Schedule fields are ignored.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private EventStream eventStream;

  /**
   * Output only. The time that the transfer job was last modified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String lastModificationTime;

  /**
   * The name of the most recently started TransferOperation of this JobConfig. Present if a
   * TransferOperation has been created for this JobConfig.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String latestOperationName;

  /**
   * Logging configuration.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LoggingConfig loggingConfig;

  /**
   * A unique name (within the transfer project) assigned when the job is created. If this field is
   * empty in a CreateTransferJobRequest, Storage Transfer Service assigns a unique name. Otherwise,
   * the specified name is used as the unique name for this job. If the specified name is in use by
   * a job, the creation request fails with an ALREADY_EXISTS error. This name must start with
   * `"transferJobs/"` prefix and end with a letter or a number, and should be no more than 128
   * characters. For transfers involving PosixFilesystem, this name must start with
   * `transferJobs/OPI` specifically. For all other transfer types, this name must not start with
   * `transferJobs/OPI`. Non-PosixFilesystem example:
   * `"transferJobs/^(?!OPI)[A-Za-z0-9-._~]*[A-Za-z0-9]$"` PosixFilesystem example:
   * `"transferJobs/OPI^[A-Za-z0-9-._~]*[A-Za-z0-9]$"` Applications must not rely on the enforcement
   * of naming requirements involving OPI. Invalid job names fail with an INVALID_ARGUMENT error.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Notification configuration.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private NotificationConfig notificationConfig;

  /**
   * The ID of the Google Cloud project that owns the job.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String projectId;

  /**
   * Replication specification.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ReplicationSpec replicationSpec;

  /**
   * Specifies schedule for the transfer job. This is an optional field. When the field is not set,
   * the job never executes a transfer, unless you invoke RunTransferJob or update the job to have a
   * non-empty schedule.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Schedule schedule;

  /**
   * Status of the job. This value MUST be specified for `CreateTransferJobRequests`. **Note:** The
   * effect of the new job status takes place during a subsequent job run. For example, if you
   * change the job status from ENABLED to DISABLED, and an operation spawned by the transfer is
   * running, the status change would not affect the current operation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String status;

  /**
   * Transfer specification.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TransferSpec transferSpec;

  /**
   * Output only. The time that the transfer job was created.
   * @return value or {@code null} for none
   */
  public String getCreationTime() {
    return creationTime;
  }

  /**
   * Output only. The time that the transfer job was created.
   * @param creationTime creationTime or {@code null} for none
   */
  public TransferJob setCreationTime(String creationTime) {
    this.creationTime = creationTime;
    return this;
  }

  /**
   * Output only. The time that the transfer job was deleted.
   * @return value or {@code null} for none
   */
  public String getDeletionTime() {
    return deletionTime;
  }

  /**
   * Output only. The time that the transfer job was deleted.
   * @param deletionTime deletionTime or {@code null} for none
   */
  public TransferJob setDeletionTime(String deletionTime) {
    this.deletionTime = deletionTime;
    return this;
  }

  /**
   * A description provided by the user for the job. Its max length is 1024 bytes when Unicode-
   * encoded.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * A description provided by the user for the job. Its max length is 1024 bytes when Unicode-
   * encoded.
   * @param description description or {@code null} for none
   */
  public TransferJob setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Specifies the event stream for the transfer job for event-driven transfers. When EventStream is
   * specified, the Schedule fields are ignored.
   * @return value or {@code null} for none
   */
  public EventStream getEventStream() {
    return eventStream;
  }

  /**
   * Specifies the event stream for the transfer job for event-driven transfers. When EventStream is
   * specified, the Schedule fields are ignored.
   * @param eventStream eventStream or {@code null} for none
   */
  public TransferJob setEventStream(EventStream eventStream) {
    this.eventStream = eventStream;
    return this;
  }

  /**
   * Output only. The time that the transfer job was last modified.
   * @return value or {@code null} for none
   */
  public String getLastModificationTime() {
    return lastModificationTime;
  }

  /**
   * Output only. The time that the transfer job was last modified.
   * @param lastModificationTime lastModificationTime or {@code null} for none
   */
  public TransferJob setLastModificationTime(String lastModificationTime) {
    this.lastModificationTime = lastModificationTime;
    return this;
  }

  /**
   * The name of the most recently started TransferOperation of this JobConfig. Present if a
   * TransferOperation has been created for this JobConfig.
   * @return value or {@code null} for none
   */
  public java.lang.String getLatestOperationName() {
    return latestOperationName;
  }

  /**
   * The name of the most recently started TransferOperation of this JobConfig. Present if a
   * TransferOperation has been created for this JobConfig.
   * @param latestOperationName latestOperationName or {@code null} for none
   */
  public TransferJob setLatestOperationName(java.lang.String latestOperationName) {
    this.latestOperationName = latestOperationName;
    return this;
  }

  /**
   * Logging configuration.
   * @return value or {@code null} for none
   */
  public LoggingConfig getLoggingConfig() {
    return loggingConfig;
  }

  /**
   * Logging configuration.
   * @param loggingConfig loggingConfig or {@code null} for none
   */
  public TransferJob setLoggingConfig(LoggingConfig loggingConfig) {
    this.loggingConfig = loggingConfig;
    return this;
  }

  /**
   * A unique name (within the transfer project) assigned when the job is created. If this field is
   * empty in a CreateTransferJobRequest, Storage Transfer Service assigns a unique name. Otherwise,
   * the specified name is used as the unique name for this job. If the specified name is in use by
   * a job, the creation request fails with an ALREADY_EXISTS error. This name must start with
   * `"transferJobs/"` prefix and end with a letter or a number, and should be no more than 128
   * characters. For transfers involving PosixFilesystem, this name must start with
   * `transferJobs/OPI` specifically. For all other transfer types, this name must not start with
   * `transferJobs/OPI`. Non-PosixFilesystem example:
   * `"transferJobs/^(?!OPI)[A-Za-z0-9-._~]*[A-Za-z0-9]$"` PosixFilesystem example:
   * `"transferJobs/OPI^[A-Za-z0-9-._~]*[A-Za-z0-9]$"` Applications must not rely on the enforcement
   * of naming requirements involving OPI. Invalid job names fail with an INVALID_ARGUMENT error.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * A unique name (within the transfer project) assigned when the job is created. If this field is
   * empty in a CreateTransferJobRequest, Storage Transfer Service assigns a unique name. Otherwise,
   * the specified name is used as the unique name for this job. If the specified name is in use by
   * a job, the creation request fails with an ALREADY_EXISTS error. This name must start with
   * `"transferJobs/"` prefix and end with a letter or a number, and should be no more than 128
   * characters. For transfers involving PosixFilesystem, this name must start with
   * `transferJobs/OPI` specifically. For all other transfer types, this name must not start with
   * `transferJobs/OPI`. Non-PosixFilesystem example:
   * `"transferJobs/^(?!OPI)[A-Za-z0-9-._~]*[A-Za-z0-9]$"` PosixFilesystem example:
   * `"transferJobs/OPI^[A-Za-z0-9-._~]*[A-Za-z0-9]$"` Applications must not rely on the enforcement
   * of naming requirements involving OPI. Invalid job names fail with an INVALID_ARGUMENT error.
   * @param name name or {@code null} for none
   */
  public TransferJob setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Notification configuration.
   * @return value or {@code null} for none
   */
  public NotificationConfig getNotificationConfig() {
    return notificationConfig;
  }

  /**
   * Notification configuration.
   * @param notificationConfig notificationConfig or {@code null} for none
   */
  public TransferJob setNotificationConfig(NotificationConfig notificationConfig) {
    this.notificationConfig = notificationConfig;
    return this;
  }

  /**
   * The ID of the Google Cloud project that owns the job.
   * @return value or {@code null} for none
   */
  public java.lang.String getProjectId() {
    return projectId;
  }

  /**
   * The ID of the Google Cloud project that owns the job.
   * @param projectId projectId or {@code null} for none
   */
  public TransferJob setProjectId(java.lang.String projectId) {
    this.projectId = projectId;
    return this;
  }

  /**
   * Replication specification.
   * @return value or {@code null} for none
   */
  public ReplicationSpec getReplicationSpec() {
    return replicationSpec;
  }

  /**
   * Replication specification.
   * @param replicationSpec replicationSpec or {@code null} for none
   */
  public TransferJob setReplicationSpec(ReplicationSpec replicationSpec) {
    this.replicationSpec = replicationSpec;
    return this;
  }

  /**
   * Specifies schedule for the transfer job. This is an optional field. When the field is not set,
   * the job never executes a transfer, unless you invoke RunTransferJob or update the job to have a
   * non-empty schedule.
   * @return value or {@code null} for none
   */
  public Schedule getSchedule() {
    return schedule;
  }

  /**
   * Specifies schedule for the transfer job. This is an optional field. When the field is not set,
   * the job never executes a transfer, unless you invoke RunTransferJob or update the job to have a
   * non-empty schedule.
   * @param schedule schedule or {@code null} for none
   */
  public TransferJob setSchedule(Schedule schedule) {
    this.schedule = schedule;
    return this;
  }

  /**
   * Status of the job. This value MUST be specified for `CreateTransferJobRequests`. **Note:** The
   * effect of the new job status takes place during a subsequent job run. For example, if you
   * change the job status from ENABLED to DISABLED, and an operation spawned by the transfer is
   * running, the status change would not affect the current operation.
   * @return value or {@code null} for none
   */
  public java.lang.String getStatus() {
    return status;
  }

  /**
   * Status of the job. This value MUST be specified for `CreateTransferJobRequests`. **Note:** The
   * effect of the new job status takes place during a subsequent job run. For example, if you
   * change the job status from ENABLED to DISABLED, and an operation spawned by the transfer is
   * running, the status change would not affect the current operation.
   * @param status status or {@code null} for none
   */
  public TransferJob setStatus(java.lang.String status) {
    this.status = status;
    return this;
  }

  /**
   * Transfer specification.
   * @return value or {@code null} for none
   */
  public TransferSpec getTransferSpec() {
    return transferSpec;
  }

  /**
   * Transfer specification.
   * @param transferSpec transferSpec or {@code null} for none
   */
  public TransferJob setTransferSpec(TransferSpec transferSpec) {
    this.transferSpec = transferSpec;
    return this;
  }

  @Override
  public TransferJob set(String fieldName, Object value) {
    return (TransferJob) super.set(fieldName, value);
  }

  @Override
  public TransferJob clone() {
    return (TransferJob) super.clone();
  }

}
