/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.storagetransfer.v1.model;

/**
 * A description of the execution of a transfer.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Storage Transfer API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TransferOperation extends com.google.api.client.json.GenericJson {

  /**
   * Information about the progress of the transfer operation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TransferCounters counters;

  /**
   * End time of this transfer execution.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String endTime;

  /**
   * Summarizes errors encountered with sample error log entries.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ErrorSummary> errorBreakdowns;

  static {
    // hack to force ProGuard to consider ErrorSummary used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(ErrorSummary.class);
  }

  /**
   * Cloud Logging configuration.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LoggingConfig loggingConfig;

  /**
   * A globally unique ID assigned by the system.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Notification configuration.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private NotificationConfig notificationConfig;

  /**
   * The ID of the Google Cloud project that owns the operation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String projectId;

  /**
   * Start time of this transfer execution.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String startTime;

  /**
   * Status of the transfer operation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String status;

  /**
   * The name of the transfer job that triggers this transfer operation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String transferJobName;

  /**
   * Transfer specification.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TransferSpec transferSpec;

  /**
   * Information about the progress of the transfer operation.
   * @return value or {@code null} for none
   */
  public TransferCounters getCounters() {
    return counters;
  }

  /**
   * Information about the progress of the transfer operation.
   * @param counters counters or {@code null} for none
   */
  public TransferOperation setCounters(TransferCounters counters) {
    this.counters = counters;
    return this;
  }

  /**
   * End time of this transfer execution.
   * @return value or {@code null} for none
   */
  public String getEndTime() {
    return endTime;
  }

  /**
   * End time of this transfer execution.
   * @param endTime endTime or {@code null} for none
   */
  public TransferOperation setEndTime(String endTime) {
    this.endTime = endTime;
    return this;
  }

  /**
   * Summarizes errors encountered with sample error log entries.
   * @return value or {@code null} for none
   */
  public java.util.List<ErrorSummary> getErrorBreakdowns() {
    return errorBreakdowns;
  }

  /**
   * Summarizes errors encountered with sample error log entries.
   * @param errorBreakdowns errorBreakdowns or {@code null} for none
   */
  public TransferOperation setErrorBreakdowns(java.util.List<ErrorSummary> errorBreakdowns) {
    this.errorBreakdowns = errorBreakdowns;
    return this;
  }

  /**
   * Cloud Logging configuration.
   * @return value or {@code null} for none
   */
  public LoggingConfig getLoggingConfig() {
    return loggingConfig;
  }

  /**
   * Cloud Logging configuration.
   * @param loggingConfig loggingConfig or {@code null} for none
   */
  public TransferOperation setLoggingConfig(LoggingConfig loggingConfig) {
    this.loggingConfig = loggingConfig;
    return this;
  }

  /**
   * A globally unique ID assigned by the system.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * A globally unique ID assigned by the system.
   * @param name name or {@code null} for none
   */
  public TransferOperation setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Notification configuration.
   * @return value or {@code null} for none
   */
  public NotificationConfig getNotificationConfig() {
    return notificationConfig;
  }

  /**
   * Notification configuration.
   * @param notificationConfig notificationConfig or {@code null} for none
   */
  public TransferOperation setNotificationConfig(NotificationConfig notificationConfig) {
    this.notificationConfig = notificationConfig;
    return this;
  }

  /**
   * The ID of the Google Cloud project that owns the operation.
   * @return value or {@code null} for none
   */
  public java.lang.String getProjectId() {
    return projectId;
  }

  /**
   * The ID of the Google Cloud project that owns the operation.
   * @param projectId projectId or {@code null} for none
   */
  public TransferOperation setProjectId(java.lang.String projectId) {
    this.projectId = projectId;
    return this;
  }

  /**
   * Start time of this transfer execution.
   * @return value or {@code null} for none
   */
  public String getStartTime() {
    return startTime;
  }

  /**
   * Start time of this transfer execution.
   * @param startTime startTime or {@code null} for none
   */
  public TransferOperation setStartTime(String startTime) {
    this.startTime = startTime;
    return this;
  }

  /**
   * Status of the transfer operation.
   * @return value or {@code null} for none
   */
  public java.lang.String getStatus() {
    return status;
  }

  /**
   * Status of the transfer operation.
   * @param status status or {@code null} for none
   */
  public TransferOperation setStatus(java.lang.String status) {
    this.status = status;
    return this;
  }

  /**
   * The name of the transfer job that triggers this transfer operation.
   * @return value or {@code null} for none
   */
  public java.lang.String getTransferJobName() {
    return transferJobName;
  }

  /**
   * The name of the transfer job that triggers this transfer operation.
   * @param transferJobName transferJobName or {@code null} for none
   */
  public TransferOperation setTransferJobName(java.lang.String transferJobName) {
    this.transferJobName = transferJobName;
    return this;
  }

  /**
   * Transfer specification.
   * @return value or {@code null} for none
   */
  public TransferSpec getTransferSpec() {
    return transferSpec;
  }

  /**
   * Transfer specification.
   * @param transferSpec transferSpec or {@code null} for none
   */
  public TransferOperation setTransferSpec(TransferSpec transferSpec) {
    this.transferSpec = transferSpec;
    return this;
  }

  @Override
  public TransferOperation set(String fieldName, Object value) {
    return (TransferOperation) super.set(fieldName, value);
  }

  @Override
  public TransferOperation clone() {
    return (TransferOperation) super.clone();
  }

}
