/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.storagetransfer.v1.model;

/**
 * Configuration for running a transfer.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Storage Transfer API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TransferSpec extends com.google.api.client.json.GenericJson {

  /**
   * An AWS S3 compatible data source.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AwsS3CompatibleData awsS3CompatibleDataSource;

  /**
   * An AWS S3 data source.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AwsS3Data awsS3DataSource;

  /**
   * An Azure Blob Storage data source.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AzureBlobStorageData azureBlobStorageDataSource;

  /**
   * A Cloud Storage data sink.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GcsData gcsDataSink;

  /**
   * A Cloud Storage data source.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GcsData gcsDataSource;

  /**
   * For transfers between file systems, specifies a Cloud Storage bucket to be used as an
   * intermediate location through which to transfer data. See [Transfer data between file
   * systems](https://cloud.google.com/storage-transfer/docs/file-to-file) for more information.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GcsData gcsIntermediateDataLocation;

  /**
   * An HDFS cluster data source.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private HdfsData hdfsDataSource;

  /**
   * An HTTP URL data source.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private HttpData httpDataSource;

  /**
   * Only objects that satisfy these object conditions are included in the set of data source and
   * data sink objects. Object conditions based on objects' "last modification time" do not exclude
   * objects in a data sink.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ObjectConditions objectConditions;

  /**
   * A POSIX Filesystem data sink.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PosixFilesystem posixDataSink;

  /**
   * A POSIX Filesystem data source.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PosixFilesystem posixDataSource;

  /**
   * Specifies the agent pool name associated with the posix data sink. When unspecified, the
   * default name is used.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sinkAgentPoolName;

  /**
   * Specifies the agent pool name associated with the posix data source. When unspecified, the
   * default name is used.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sourceAgentPoolName;

  /**
   * A manifest file provides a list of objects to be transferred from the data source. This field
   * points to the location of the manifest file. Otherwise, the entire source bucket is used.
   * ObjectConditions still apply.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TransferManifest transferManifest;

  /**
   * If the option delete_objects_unique_in_sink is `true` and time-based object conditions such as
   * 'last modification time' are specified, the request fails with an INVALID_ARGUMENT error.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TransferOptions transferOptions;

  /**
   * An AWS S3 compatible data source.
   * @return value or {@code null} for none
   */
  public AwsS3CompatibleData getAwsS3CompatibleDataSource() {
    return awsS3CompatibleDataSource;
  }

  /**
   * An AWS S3 compatible data source.
   * @param awsS3CompatibleDataSource awsS3CompatibleDataSource or {@code null} for none
   */
  public TransferSpec setAwsS3CompatibleDataSource(AwsS3CompatibleData awsS3CompatibleDataSource) {
    this.awsS3CompatibleDataSource = awsS3CompatibleDataSource;
    return this;
  }

  /**
   * An AWS S3 data source.
   * @return value or {@code null} for none
   */
  public AwsS3Data getAwsS3DataSource() {
    return awsS3DataSource;
  }

  /**
   * An AWS S3 data source.
   * @param awsS3DataSource awsS3DataSource or {@code null} for none
   */
  public TransferSpec setAwsS3DataSource(AwsS3Data awsS3DataSource) {
    this.awsS3DataSource = awsS3DataSource;
    return this;
  }

  /**
   * An Azure Blob Storage data source.
   * @return value or {@code null} for none
   */
  public AzureBlobStorageData getAzureBlobStorageDataSource() {
    return azureBlobStorageDataSource;
  }

  /**
   * An Azure Blob Storage data source.
   * @param azureBlobStorageDataSource azureBlobStorageDataSource or {@code null} for none
   */
  public TransferSpec setAzureBlobStorageDataSource(AzureBlobStorageData azureBlobStorageDataSource) {
    this.azureBlobStorageDataSource = azureBlobStorageDataSource;
    return this;
  }

  /**
   * A Cloud Storage data sink.
   * @return value or {@code null} for none
   */
  public GcsData getGcsDataSink() {
    return gcsDataSink;
  }

  /**
   * A Cloud Storage data sink.
   * @param gcsDataSink gcsDataSink or {@code null} for none
   */
  public TransferSpec setGcsDataSink(GcsData gcsDataSink) {
    this.gcsDataSink = gcsDataSink;
    return this;
  }

  /**
   * A Cloud Storage data source.
   * @return value or {@code null} for none
   */
  public GcsData getGcsDataSource() {
    return gcsDataSource;
  }

  /**
   * A Cloud Storage data source.
   * @param gcsDataSource gcsDataSource or {@code null} for none
   */
  public TransferSpec setGcsDataSource(GcsData gcsDataSource) {
    this.gcsDataSource = gcsDataSource;
    return this;
  }

  /**
   * For transfers between file systems, specifies a Cloud Storage bucket to be used as an
   * intermediate location through which to transfer data. See [Transfer data between file
   * systems](https://cloud.google.com/storage-transfer/docs/file-to-file) for more information.
   * @return value or {@code null} for none
   */
  public GcsData getGcsIntermediateDataLocation() {
    return gcsIntermediateDataLocation;
  }

  /**
   * For transfers between file systems, specifies a Cloud Storage bucket to be used as an
   * intermediate location through which to transfer data. See [Transfer data between file
   * systems](https://cloud.google.com/storage-transfer/docs/file-to-file) for more information.
   * @param gcsIntermediateDataLocation gcsIntermediateDataLocation or {@code null} for none
   */
  public TransferSpec setGcsIntermediateDataLocation(GcsData gcsIntermediateDataLocation) {
    this.gcsIntermediateDataLocation = gcsIntermediateDataLocation;
    return this;
  }

  /**
   * An HDFS cluster data source.
   * @return value or {@code null} for none
   */
  public HdfsData getHdfsDataSource() {
    return hdfsDataSource;
  }

  /**
   * An HDFS cluster data source.
   * @param hdfsDataSource hdfsDataSource or {@code null} for none
   */
  public TransferSpec setHdfsDataSource(HdfsData hdfsDataSource) {
    this.hdfsDataSource = hdfsDataSource;
    return this;
  }

  /**
   * An HTTP URL data source.
   * @return value or {@code null} for none
   */
  public HttpData getHttpDataSource() {
    return httpDataSource;
  }

  /**
   * An HTTP URL data source.
   * @param httpDataSource httpDataSource or {@code null} for none
   */
  public TransferSpec setHttpDataSource(HttpData httpDataSource) {
    this.httpDataSource = httpDataSource;
    return this;
  }

  /**
   * Only objects that satisfy these object conditions are included in the set of data source and
   * data sink objects. Object conditions based on objects' "last modification time" do not exclude
   * objects in a data sink.
   * @return value or {@code null} for none
   */
  public ObjectConditions getObjectConditions() {
    return objectConditions;
  }

  /**
   * Only objects that satisfy these object conditions are included in the set of data source and
   * data sink objects. Object conditions based on objects' "last modification time" do not exclude
   * objects in a data sink.
   * @param objectConditions objectConditions or {@code null} for none
   */
  public TransferSpec setObjectConditions(ObjectConditions objectConditions) {
    this.objectConditions = objectConditions;
    return this;
  }

  /**
   * A POSIX Filesystem data sink.
   * @return value or {@code null} for none
   */
  public PosixFilesystem getPosixDataSink() {
    return posixDataSink;
  }

  /**
   * A POSIX Filesystem data sink.
   * @param posixDataSink posixDataSink or {@code null} for none
   */
  public TransferSpec setPosixDataSink(PosixFilesystem posixDataSink) {
    this.posixDataSink = posixDataSink;
    return this;
  }

  /**
   * A POSIX Filesystem data source.
   * @return value or {@code null} for none
   */
  public PosixFilesystem getPosixDataSource() {
    return posixDataSource;
  }

  /**
   * A POSIX Filesystem data source.
   * @param posixDataSource posixDataSource or {@code null} for none
   */
  public TransferSpec setPosixDataSource(PosixFilesystem posixDataSource) {
    this.posixDataSource = posixDataSource;
    return this;
  }

  /**
   * Specifies the agent pool name associated with the posix data sink. When unspecified, the
   * default name is used.
   * @return value or {@code null} for none
   */
  public java.lang.String getSinkAgentPoolName() {
    return sinkAgentPoolName;
  }

  /**
   * Specifies the agent pool name associated with the posix data sink. When unspecified, the
   * default name is used.
   * @param sinkAgentPoolName sinkAgentPoolName or {@code null} for none
   */
  public TransferSpec setSinkAgentPoolName(java.lang.String sinkAgentPoolName) {
    this.sinkAgentPoolName = sinkAgentPoolName;
    return this;
  }

  /**
   * Specifies the agent pool name associated with the posix data source. When unspecified, the
   * default name is used.
   * @return value or {@code null} for none
   */
  public java.lang.String getSourceAgentPoolName() {
    return sourceAgentPoolName;
  }

  /**
   * Specifies the agent pool name associated with the posix data source. When unspecified, the
   * default name is used.
   * @param sourceAgentPoolName sourceAgentPoolName or {@code null} for none
   */
  public TransferSpec setSourceAgentPoolName(java.lang.String sourceAgentPoolName) {
    this.sourceAgentPoolName = sourceAgentPoolName;
    return this;
  }

  /**
   * A manifest file provides a list of objects to be transferred from the data source. This field
   * points to the location of the manifest file. Otherwise, the entire source bucket is used.
   * ObjectConditions still apply.
   * @return value or {@code null} for none
   */
  public TransferManifest getTransferManifest() {
    return transferManifest;
  }

  /**
   * A manifest file provides a list of objects to be transferred from the data source. This field
   * points to the location of the manifest file. Otherwise, the entire source bucket is used.
   * ObjectConditions still apply.
   * @param transferManifest transferManifest or {@code null} for none
   */
  public TransferSpec setTransferManifest(TransferManifest transferManifest) {
    this.transferManifest = transferManifest;
    return this;
  }

  /**
   * If the option delete_objects_unique_in_sink is `true` and time-based object conditions such as
   * 'last modification time' are specified, the request fails with an INVALID_ARGUMENT error.
   * @return value or {@code null} for none
   */
  public TransferOptions getTransferOptions() {
    return transferOptions;
  }

  /**
   * If the option delete_objects_unique_in_sink is `true` and time-based object conditions such as
   * 'last modification time' are specified, the request fails with an INVALID_ARGUMENT error.
   * @param transferOptions transferOptions or {@code null} for none
   */
  public TransferSpec setTransferOptions(TransferOptions transferOptions) {
    this.transferOptions = transferOptions;
    return this;
  }

  @Override
  public TransferSpec set(String fieldName, Object value) {
    return (TransferSpec) super.set(fieldName, value);
  }

  @Override
  public TransferSpec clone() {
    return (TransferSpec) super.clone();
  }

}
