/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.storagetransfer.v1.model;

/**
 * Request passed to UpdateTransferJob.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Storage Transfer API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UpdateTransferJobRequest extends com.google.api.client.json.GenericJson {

  /**
   * Required. The ID of the Google Cloud project that owns the job.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String projectId;

  /**
   * Required. The job to update. `transferJob` is expected to specify one or more of five fields:
   * description, transfer_spec, notification_config, logging_config, and status. An
   * `UpdateTransferJobRequest` that specifies other fields are rejected with the error
   * INVALID_ARGUMENT. Updating a job status to DELETED requires `storagetransfer.jobs.delete`
   * permission.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TransferJob transferJob;

  /**
   * The field mask of the fields in `transferJob` that are to be updated in this request. Fields in
   * `transferJob` that can be updated are: description, transfer_spec, notification_config,
   * logging_config, and status. To update the `transfer_spec` of the job, a complete transfer
   * specification must be provided. An incomplete specification missing any required fields is
   * rejected with the error INVALID_ARGUMENT.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String updateTransferJobFieldMask;

  /**
   * Required. The ID of the Google Cloud project that owns the job.
   * @return value or {@code null} for none
   */
  public java.lang.String getProjectId() {
    return projectId;
  }

  /**
   * Required. The ID of the Google Cloud project that owns the job.
   * @param projectId projectId or {@code null} for none
   */
  public UpdateTransferJobRequest setProjectId(java.lang.String projectId) {
    this.projectId = projectId;
    return this;
  }

  /**
   * Required. The job to update. `transferJob` is expected to specify one or more of five fields:
   * description, transfer_spec, notification_config, logging_config, and status. An
   * `UpdateTransferJobRequest` that specifies other fields are rejected with the error
   * INVALID_ARGUMENT. Updating a job status to DELETED requires `storagetransfer.jobs.delete`
   * permission.
   * @return value or {@code null} for none
   */
  public TransferJob getTransferJob() {
    return transferJob;
  }

  /**
   * Required. The job to update. `transferJob` is expected to specify one or more of five fields:
   * description, transfer_spec, notification_config, logging_config, and status. An
   * `UpdateTransferJobRequest` that specifies other fields are rejected with the error
   * INVALID_ARGUMENT. Updating a job status to DELETED requires `storagetransfer.jobs.delete`
   * permission.
   * @param transferJob transferJob or {@code null} for none
   */
  public UpdateTransferJobRequest setTransferJob(TransferJob transferJob) {
    this.transferJob = transferJob;
    return this;
  }

  /**
   * The field mask of the fields in `transferJob` that are to be updated in this request. Fields in
   * `transferJob` that can be updated are: description, transfer_spec, notification_config,
   * logging_config, and status. To update the `transfer_spec` of the job, a complete transfer
   * specification must be provided. An incomplete specification missing any required fields is
   * rejected with the error INVALID_ARGUMENT.
   * @return value or {@code null} for none
   */
  public String getUpdateTransferJobFieldMask() {
    return updateTransferJobFieldMask;
  }

  /**
   * The field mask of the fields in `transferJob` that are to be updated in this request. Fields in
   * `transferJob` that can be updated are: description, transfer_spec, notification_config,
   * logging_config, and status. To update the `transfer_spec` of the job, a complete transfer
   * specification must be provided. An incomplete specification missing any required fields is
   * rejected with the error INVALID_ARGUMENT.
   * @param updateTransferJobFieldMask updateTransferJobFieldMask or {@code null} for none
   */
  public UpdateTransferJobRequest setUpdateTransferJobFieldMask(String updateTransferJobFieldMask) {
    this.updateTransferJobFieldMask = updateTransferJobFieldMask;
    return this;
  }

  @Override
  public UpdateTransferJobRequest set(String fieldName, Object value) {
    return (UpdateTransferJobRequest) super.set(fieldName, value);
  }

  @Override
  public UpdateTransferJobRequest clone() {
    return (UpdateTransferJobRequest) super.clone();
  }

}
