/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.storagetransfer.v1;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.storagetransfer.v1.StoragetransferRequest;
import com.google.api.services.storagetransfer.v1.StoragetransferRequestInitializer;
import com.google.api.services.storagetransfer.v1.model.AgentPool;
import com.google.api.services.storagetransfer.v1.model.CancelOperationRequest;
import com.google.api.services.storagetransfer.v1.model.Empty;
import com.google.api.services.storagetransfer.v1.model.GoogleServiceAccount;
import com.google.api.services.storagetransfer.v1.model.ListAgentPoolsResponse;
import com.google.api.services.storagetransfer.v1.model.ListOperationsResponse;
import com.google.api.services.storagetransfer.v1.model.ListTransferJobsResponse;
import com.google.api.services.storagetransfer.v1.model.Operation;
import com.google.api.services.storagetransfer.v1.model.PauseTransferOperationRequest;
import com.google.api.services.storagetransfer.v1.model.ResumeTransferOperationRequest;
import com.google.api.services.storagetransfer.v1.model.RunTransferJobRequest;
import com.google.api.services.storagetransfer.v1.model.TransferJob;
import com.google.api.services.storagetransfer.v1.model.UpdateTransferJobRequest;
import java.io.IOException;
import java.util.regex.Pattern;

public class Storagetransfer
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://storagetransfer.googleapis.com/";
    public static final String DEFAULT_MTLS_ROOT_URL = "https://storagetransfer.mtls.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://storagetransfer.googleapis.com/";

    public Storagetransfer(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    Storagetransfer(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public GoogleServiceAccounts googleServiceAccounts() {
        return new GoogleServiceAccounts();
    }

    public Projects projects() {
        return new Projects();
    }

    public TransferJobs transferJobs() {
        return new TransferJobs();
    }

    public TransferOperations transferOperations() {
        return new TransferOperations();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && (GoogleUtils.MINOR_VERSION >= 32 || GoogleUtils.MINOR_VERSION == 31 && GoogleUtils.BUGFIX_VERSION >= 1) || GoogleUtils.MAJOR_VERSION >= 2 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.31.1 of google-api-client to run version 2.0.0 of the Storage Transfer API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        private static String chooseEndpoint(HttpTransport transport) {
            String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
            String string = useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
            if ("always".equals(useMtlsEndpoint) || "auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls()) {
                return Storagetransfer.DEFAULT_MTLS_ROOT_URL;
            }
            return "https://storagetransfer.googleapis.com/";
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Builder.chooseEndpoint(transport), Storagetransfer.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Storagetransfer.DEFAULT_BATCH_PATH);
        }

        public Storagetransfer build() {
            return new Storagetransfer(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setStoragetransferRequestInitializer(StoragetransferRequestInitializer storagetransferRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)storagetransferRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }

        public Builder setUniverseDomain(String universeDomain) {
            return (Builder)super.setUniverseDomain(universeDomain);
        }
    }

    public class TransferOperations {
        public Cancel cancel(String name, CancelOperationRequest content) throws IOException {
            Cancel result = new Cancel(name, content);
            Storagetransfer.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String name) throws IOException {
            Get result = new Get(name);
            Storagetransfer.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String name, String filter) throws IOException {
            List result = new List(name, filter);
            Storagetransfer.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Pause pause(String name, PauseTransferOperationRequest content) throws IOException {
            Pause result = new Pause(name, content);
            Storagetransfer.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Resume resume(String name, ResumeTransferOperationRequest content) throws IOException {
            Resume result = new Resume(name, content);
            Storagetransfer.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Resume
        extends StoragetransferRequest<Empty> {
            private static final String REST_PATH = "v1/{+name}:resume";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Resume(String name, ResumeTransferOperationRequest content) {
                super(Storagetransfer.this, "POST", REST_PATH, (Object)content, Empty.class);
                this.NAME_PATTERN = Pattern.compile("^transferOperations/.*$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!Storagetransfer.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^transferOperations/.*$");
                }
            }

            public Resume set$Xgafv(String $Xgafv) {
                return (Resume)super.set$Xgafv($Xgafv);
            }

            public Resume setAccessToken(String accessToken) {
                return (Resume)super.setAccessToken(accessToken);
            }

            public Resume setAlt(String alt) {
                return (Resume)super.setAlt(alt);
            }

            public Resume setCallback(String callback) {
                return (Resume)super.setCallback(callback);
            }

            public Resume setFields(String fields) {
                return (Resume)super.setFields(fields);
            }

            public Resume setKey(String key) {
                return (Resume)super.setKey(key);
            }

            public Resume setOauthToken(String oauthToken) {
                return (Resume)super.setOauthToken(oauthToken);
            }

            public Resume setPrettyPrint(Boolean prettyPrint) {
                return (Resume)super.setPrettyPrint(prettyPrint);
            }

            public Resume setQuotaUser(String quotaUser) {
                return (Resume)super.setQuotaUser(quotaUser);
            }

            public Resume setUploadType(String uploadType) {
                return (Resume)super.setUploadType(uploadType);
            }

            public Resume setUploadProtocol(String uploadProtocol) {
                return (Resume)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Resume setName(String name) {
                if (!Storagetransfer.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^transferOperations/.*$");
                }
                this.name = name;
                return this;
            }

            @Override
            public Resume set(String parameterName, Object value) {
                return (Resume)super.set(parameterName, value);
            }
        }

        public class Pause
        extends StoragetransferRequest<Empty> {
            private static final String REST_PATH = "v1/{+name}:pause";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Pause(String name, PauseTransferOperationRequest content) {
                super(Storagetransfer.this, "POST", REST_PATH, (Object)content, Empty.class);
                this.NAME_PATTERN = Pattern.compile("^transferOperations/.*$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!Storagetransfer.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^transferOperations/.*$");
                }
            }

            public Pause set$Xgafv(String $Xgafv) {
                return (Pause)super.set$Xgafv($Xgafv);
            }

            public Pause setAccessToken(String accessToken) {
                return (Pause)super.setAccessToken(accessToken);
            }

            public Pause setAlt(String alt) {
                return (Pause)super.setAlt(alt);
            }

            public Pause setCallback(String callback) {
                return (Pause)super.setCallback(callback);
            }

            public Pause setFields(String fields) {
                return (Pause)super.setFields(fields);
            }

            public Pause setKey(String key) {
                return (Pause)super.setKey(key);
            }

            public Pause setOauthToken(String oauthToken) {
                return (Pause)super.setOauthToken(oauthToken);
            }

            public Pause setPrettyPrint(Boolean prettyPrint) {
                return (Pause)super.setPrettyPrint(prettyPrint);
            }

            public Pause setQuotaUser(String quotaUser) {
                return (Pause)super.setQuotaUser(quotaUser);
            }

            public Pause setUploadType(String uploadType) {
                return (Pause)super.setUploadType(uploadType);
            }

            public Pause setUploadProtocol(String uploadProtocol) {
                return (Pause)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Pause setName(String name) {
                if (!Storagetransfer.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^transferOperations/.*$");
                }
                this.name = name;
                return this;
            }

            @Override
            public Pause set(String parameterName, Object value) {
                return (Pause)super.set(parameterName, value);
            }
        }

        public class List
        extends StoragetransferRequest<ListOperationsResponse> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;
            @Key
            private String filter;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;

            protected List(String name, String filter) {
                super(Storagetransfer.this, "GET", REST_PATH, null, ListOperationsResponse.class);
                this.NAME_PATTERN = Pattern.compile("^transferOperations$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!Storagetransfer.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^transferOperations$");
                }
                this.filter = (String)Preconditions.checkNotNull((Object)filter, (Object)"Required parameter filter must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public List setName(String name) {
                if (!Storagetransfer.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^transferOperations$");
                }
                this.name = name;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends StoragetransferRequest<Operation> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Get(String name) {
                super(Storagetransfer.this, "GET", REST_PATH, null, Operation.class);
                this.NAME_PATTERN = Pattern.compile("^transferOperations/.*$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!Storagetransfer.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^transferOperations/.*$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Get setName(String name) {
                if (!Storagetransfer.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^transferOperations/.*$");
                }
                this.name = name;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Cancel
        extends StoragetransferRequest<Empty> {
            private static final String REST_PATH = "v1/{+name}:cancel";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Cancel(String name, CancelOperationRequest content) {
                super(Storagetransfer.this, "POST", REST_PATH, (Object)content, Empty.class);
                this.NAME_PATTERN = Pattern.compile("^transferOperations/.*$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!Storagetransfer.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^transferOperations/.*$");
                }
            }

            public Cancel set$Xgafv(String $Xgafv) {
                return (Cancel)super.set$Xgafv($Xgafv);
            }

            public Cancel setAccessToken(String accessToken) {
                return (Cancel)super.setAccessToken(accessToken);
            }

            public Cancel setAlt(String alt) {
                return (Cancel)super.setAlt(alt);
            }

            public Cancel setCallback(String callback) {
                return (Cancel)super.setCallback(callback);
            }

            public Cancel setFields(String fields) {
                return (Cancel)super.setFields(fields);
            }

            public Cancel setKey(String key) {
                return (Cancel)super.setKey(key);
            }

            public Cancel setOauthToken(String oauthToken) {
                return (Cancel)super.setOauthToken(oauthToken);
            }

            public Cancel setPrettyPrint(Boolean prettyPrint) {
                return (Cancel)super.setPrettyPrint(prettyPrint);
            }

            public Cancel setQuotaUser(String quotaUser) {
                return (Cancel)super.setQuotaUser(quotaUser);
            }

            public Cancel setUploadType(String uploadType) {
                return (Cancel)super.setUploadType(uploadType);
            }

            public Cancel setUploadProtocol(String uploadProtocol) {
                return (Cancel)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Cancel setName(String name) {
                if (!Storagetransfer.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^transferOperations/.*$");
                }
                this.name = name;
                return this;
            }

            @Override
            public Cancel set(String parameterName, Object value) {
                return (Cancel)super.set(parameterName, value);
            }
        }
    }

    public class TransferJobs {
        public Create create(TransferJob content) throws IOException {
            Create result = new Create(content);
            Storagetransfer.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(String jobName, String projectId) throws IOException {
            Delete result = new Delete(jobName, projectId);
            Storagetransfer.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String jobName, String projectId) throws IOException {
            Get result = new Get(jobName, projectId);
            Storagetransfer.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String filter) throws IOException {
            List result = new List(filter);
            Storagetransfer.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(String jobName, UpdateTransferJobRequest content) throws IOException {
            Patch result = new Patch(jobName, content);
            Storagetransfer.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Run run(String jobName, RunTransferJobRequest content) throws IOException {
            Run result = new Run(jobName, content);
            Storagetransfer.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Run
        extends StoragetransferRequest<Operation> {
            private static final String REST_PATH = "v1/{+jobName}:run";
            private final Pattern JOB_NAME_PATTERN;
            @Key
            private String jobName;

            protected Run(String jobName, RunTransferJobRequest content) {
                super(Storagetransfer.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.JOB_NAME_PATTERN = Pattern.compile("^transferJobs/.*$");
                this.jobName = (String)Preconditions.checkNotNull((Object)jobName, (Object)"Required parameter jobName must be specified.");
                if (!Storagetransfer.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.JOB_NAME_PATTERN.matcher(jobName).matches(), (Object)"Parameter jobName must conform to the pattern ^transferJobs/.*$");
                }
            }

            public Run set$Xgafv(String $Xgafv) {
                return (Run)super.set$Xgafv($Xgafv);
            }

            public Run setAccessToken(String accessToken) {
                return (Run)super.setAccessToken(accessToken);
            }

            public Run setAlt(String alt) {
                return (Run)super.setAlt(alt);
            }

            public Run setCallback(String callback) {
                return (Run)super.setCallback(callback);
            }

            public Run setFields(String fields) {
                return (Run)super.setFields(fields);
            }

            public Run setKey(String key) {
                return (Run)super.setKey(key);
            }

            public Run setOauthToken(String oauthToken) {
                return (Run)super.setOauthToken(oauthToken);
            }

            public Run setPrettyPrint(Boolean prettyPrint) {
                return (Run)super.setPrettyPrint(prettyPrint);
            }

            public Run setQuotaUser(String quotaUser) {
                return (Run)super.setQuotaUser(quotaUser);
            }

            public Run setUploadType(String uploadType) {
                return (Run)super.setUploadType(uploadType);
            }

            public Run setUploadProtocol(String uploadProtocol) {
                return (Run)super.setUploadProtocol(uploadProtocol);
            }

            public String getJobName() {
                return this.jobName;
            }

            public Run setJobName(String jobName) {
                if (!Storagetransfer.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.JOB_NAME_PATTERN.matcher(jobName).matches(), (Object)"Parameter jobName must conform to the pattern ^transferJobs/.*$");
                }
                this.jobName = jobName;
                return this;
            }

            @Override
            public Run set(String parameterName, Object value) {
                return (Run)super.set(parameterName, value);
            }
        }

        public class Patch
        extends StoragetransferRequest<TransferJob> {
            private static final String REST_PATH = "v1/{+jobName}";
            private final Pattern JOB_NAME_PATTERN;
            @Key
            private String jobName;

            protected Patch(String jobName, UpdateTransferJobRequest content) {
                super(Storagetransfer.this, "PATCH", REST_PATH, (Object)content, TransferJob.class);
                this.JOB_NAME_PATTERN = Pattern.compile("^transferJobs/.*$");
                this.jobName = (String)Preconditions.checkNotNull((Object)jobName, (Object)"Required parameter jobName must be specified.");
                if (!Storagetransfer.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.JOB_NAME_PATTERN.matcher(jobName).matches(), (Object)"Parameter jobName must conform to the pattern ^transferJobs/.*$");
                }
            }

            public Patch set$Xgafv(String $Xgafv) {
                return (Patch)super.set$Xgafv($Xgafv);
            }

            public Patch setAccessToken(String accessToken) {
                return (Patch)super.setAccessToken(accessToken);
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setCallback(String callback) {
                return (Patch)super.setCallback(callback);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUploadType(String uploadType) {
                return (Patch)super.setUploadType(uploadType);
            }

            public Patch setUploadProtocol(String uploadProtocol) {
                return (Patch)super.setUploadProtocol(uploadProtocol);
            }

            public String getJobName() {
                return this.jobName;
            }

            public Patch setJobName(String jobName) {
                if (!Storagetransfer.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.JOB_NAME_PATTERN.matcher(jobName).matches(), (Object)"Parameter jobName must conform to the pattern ^transferJobs/.*$");
                }
                this.jobName = jobName;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class List
        extends StoragetransferRequest<ListTransferJobsResponse> {
            private static final String REST_PATH = "v1/transferJobs";
            @Key
            private String filter;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;

            protected List(String filter) {
                super(Storagetransfer.this, "GET", REST_PATH, null, ListTransferJobsResponse.class);
                this.filter = (String)Preconditions.checkNotNull((Object)filter, (Object)"Required parameter filter must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends StoragetransferRequest<TransferJob> {
            private static final String REST_PATH = "v1/{+jobName}";
            private final Pattern JOB_NAME_PATTERN;
            @Key
            private String jobName;
            @Key
            private String projectId;

            protected Get(String jobName, String projectId) {
                super(Storagetransfer.this, "GET", REST_PATH, null, TransferJob.class);
                this.JOB_NAME_PATTERN = Pattern.compile("^transferJobs/.*$");
                this.jobName = (String)Preconditions.checkNotNull((Object)jobName, (Object)"Required parameter jobName must be specified.");
                if (!Storagetransfer.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.JOB_NAME_PATTERN.matcher(jobName).matches(), (Object)"Parameter jobName must conform to the pattern ^transferJobs/.*$");
                }
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getJobName() {
                return this.jobName;
            }

            public Get setJobName(String jobName) {
                if (!Storagetransfer.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.JOB_NAME_PATTERN.matcher(jobName).matches(), (Object)"Parameter jobName must conform to the pattern ^transferJobs/.*$");
                }
                this.jobName = jobName;
                return this;
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Get setProjectId(String projectId) {
                this.projectId = projectId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends StoragetransferRequest<Empty> {
            private static final String REST_PATH = "v1/{+jobName}";
            private final Pattern JOB_NAME_PATTERN;
            @Key
            private String jobName;
            @Key
            private String projectId;

            protected Delete(String jobName, String projectId) {
                super(Storagetransfer.this, "DELETE", REST_PATH, null, Empty.class);
                this.JOB_NAME_PATTERN = Pattern.compile("^transferJobs/.*$");
                this.jobName = (String)Preconditions.checkNotNull((Object)jobName, (Object)"Required parameter jobName must be specified.");
                if (!Storagetransfer.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.JOB_NAME_PATTERN.matcher(jobName).matches(), (Object)"Parameter jobName must conform to the pattern ^transferJobs/.*$");
                }
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getJobName() {
                return this.jobName;
            }

            public Delete setJobName(String jobName) {
                if (!Storagetransfer.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.JOB_NAME_PATTERN.matcher(jobName).matches(), (Object)"Parameter jobName must conform to the pattern ^transferJobs/.*$");
                }
                this.jobName = jobName;
                return this;
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Delete setProjectId(String projectId) {
                this.projectId = projectId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Create
        extends StoragetransferRequest<TransferJob> {
            private static final String REST_PATH = "v1/transferJobs";

            protected Create(TransferJob content) {
                super(Storagetransfer.this, "POST", REST_PATH, (Object)content, TransferJob.class);
            }

            public Create set$Xgafv(String $Xgafv) {
                return (Create)super.set$Xgafv($Xgafv);
            }

            public Create setAccessToken(String accessToken) {
                return (Create)super.setAccessToken(accessToken);
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setCallback(String callback) {
                return (Create)super.setCallback(callback);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUploadType(String uploadType) {
                return (Create)super.setUploadType(uploadType);
            }

            public Create setUploadProtocol(String uploadProtocol) {
                return (Create)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }
    }

    public class Projects {
        public AgentPools agentPools() {
            return new AgentPools();
        }

        public class AgentPools {
            public Create create(String projectId, AgentPool content) throws IOException {
                Create result = new Create(projectId, content);
                Storagetransfer.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delete delete(String name) throws IOException {
                Delete result = new Delete(name);
                Storagetransfer.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String name) throws IOException {
                Get result = new Get(name);
                Storagetransfer.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String projectId) throws IOException {
                List result = new List(projectId);
                Storagetransfer.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(String name, AgentPool content) throws IOException {
                Patch result = new Patch(name, content);
                Storagetransfer.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Patch
            extends StoragetransferRequest<AgentPool> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String updateMask;

                protected Patch(String name, AgentPool content) {
                    super(Storagetransfer.this, "PATCH", REST_PATH, (Object)content, AgentPool.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/agentPools/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Storagetransfer.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/agentPools/[^/]+$");
                    }
                }

                public Patch set$Xgafv(String $Xgafv) {
                    return (Patch)super.set$Xgafv($Xgafv);
                }

                public Patch setAccessToken(String accessToken) {
                    return (Patch)super.setAccessToken(accessToken);
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setCallback(String callback) {
                    return (Patch)super.setCallback(callback);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUploadType(String uploadType) {
                    return (Patch)super.setUploadType(uploadType);
                }

                public Patch setUploadProtocol(String uploadProtocol) {
                    return (Patch)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Patch setName(String name) {
                    if (!Storagetransfer.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/agentPools/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public String getUpdateMask() {
                    return this.updateMask;
                }

                public Patch setUpdateMask(String updateMask) {
                    this.updateMask = updateMask;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class List
            extends StoragetransferRequest<ListAgentPoolsResponse> {
                private static final String REST_PATH = "v1/projects/{+projectId}/agentPools";
                private final Pattern PROJECT_ID_PATTERN;
                @Key
                private String projectId;
                @Key
                private String filter;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String projectId) {
                    super(Storagetransfer.this, "GET", REST_PATH, null, ListAgentPoolsResponse.class);
                    this.PROJECT_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                    if (!Storagetransfer.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getProjectId() {
                    return this.projectId;
                }

                public List setProjectId(String projectId) {
                    if (!Storagetransfer.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                    }
                    this.projectId = projectId;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String filter) {
                    this.filter = filter;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends StoragetransferRequest<AgentPool> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String name) {
                    super(Storagetransfer.this, "GET", REST_PATH, null, AgentPool.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/agentPools/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Storagetransfer.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/agentPools/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String name) {
                    if (!Storagetransfer.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/agentPools/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends StoragetransferRequest<Empty> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Delete(String name) {
                    super(Storagetransfer.this, "DELETE", REST_PATH, null, Empty.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/agentPools/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Storagetransfer.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/agentPools/[^/]+$");
                    }
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Delete setName(String name) {
                    if (!Storagetransfer.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/agentPools/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }

            public class Create
            extends StoragetransferRequest<AgentPool> {
                private static final String REST_PATH = "v1/projects/{+projectId}/agentPools";
                private final Pattern PROJECT_ID_PATTERN;
                @Key
                private String projectId;
                @Key
                private String agentPoolId;

                protected Create(String projectId, AgentPool content) {
                    super(Storagetransfer.this, "POST", REST_PATH, (Object)content, AgentPool.class);
                    this.PROJECT_ID_PATTERN = Pattern.compile("^[^/]+$");
                    this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                    if (!Storagetransfer.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                    }
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getProjectId() {
                    return this.projectId;
                }

                public Create setProjectId(String projectId) {
                    if (!Storagetransfer.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                    }
                    this.projectId = projectId;
                    return this;
                }

                public String getAgentPoolId() {
                    return this.agentPoolId;
                }

                public Create setAgentPoolId(String agentPoolId) {
                    this.agentPoolId = agentPoolId;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }
    }

    public class GoogleServiceAccounts {
        public Get get(String projectId) throws IOException {
            Get result = new Get(projectId);
            Storagetransfer.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Get
        extends StoragetransferRequest<GoogleServiceAccount> {
            private static final String REST_PATH = "v1/googleServiceAccounts/{projectId}";
            @Key
            private String projectId;

            protected Get(String projectId) {
                super(Storagetransfer.this, "GET", REST_PATH, null, GoogleServiceAccount.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Get setProjectId(String projectId) {
                this.projectId = projectId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }
}

