/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2014-11-17 18:43:33 UTC)
 * on 2015-01-05 at 18:03:42 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.tasks.model;

/**
 * Model definition for Task.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Tasks API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Task extends com.google.api.client.json.GenericJson {

  /**
   * Completion date of the task (as a RFC 3339 timestamp). This field is omitted if the task has
   * not been completed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime completed;

  /**
   * Flag indicating whether the task has been deleted. The default if False.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean deleted;

  /**
   * Due date of the task (as a RFC 3339 timestamp). Optional.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime due;

  /**
   * ETag of the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String etag;

  /**
   * Flag indicating whether the task is hidden. This is the case if the task had been marked
   * completed when the task list was last cleared. The default is False. This field is read-only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean hidden;

  /**
   * Task identifier.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * Type of the resource. This is always "tasks#task".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Collection of links. This collection is read-only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Links> links;

  static {
    // hack to force ProGuard to consider Links used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(Links.class);
  }

  /**
   * Notes describing the task. Optional.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String notes;

  /**
   * Parent task identifier. This field is omitted if it is a top-level task. This field is read-
   * only. Use the "move" method to move the task under a different parent or to the top level.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String parent;

  /**
   * String indicating the position of the task among its sibling tasks under the same parent task
   * or at the top level. If this string is greater than another task's corresponding position
   * string according to lexicographical ordering, the task is positioned after the other task under
   * the same parent task (or at the top level). This field is read-only. Use the "move" method to
   * move the task to another position.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String position;

  /**
   * URL pointing to this task. Used to retrieve, update, or delete this task.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * Status of the task. This is either "needsAction" or "completed".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String status;

  /**
   * Title of the task.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String title;

  /**
   * Last modification time of the task (as a RFC 3339 timestamp).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime updated;

  /**
   * Completion date of the task (as a RFC 3339 timestamp). This field is omitted if the task has
   * not been completed.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getCompleted() {
    return completed;
  }

  /**
   * Completion date of the task (as a RFC 3339 timestamp). This field is omitted if the task has
   * not been completed.
   * @param completed completed or {@code null} for none
   */
  public Task setCompleted(com.google.api.client.util.DateTime completed) {
    this.completed = completed;
    return this;
  }

  /**
   * Flag indicating whether the task has been deleted. The default if False.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getDeleted() {
    return deleted;
  }

  /**
   * Flag indicating whether the task has been deleted. The default if False.
   * @param deleted deleted or {@code null} for none
   */
  public Task setDeleted(java.lang.Boolean deleted) {
    this.deleted = deleted;
    return this;
  }

  /**
   * Due date of the task (as a RFC 3339 timestamp). Optional.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getDue() {
    return due;
  }

  /**
   * Due date of the task (as a RFC 3339 timestamp). Optional.
   * @param due due or {@code null} for none
   */
  public Task setDue(com.google.api.client.util.DateTime due) {
    this.due = due;
    return this;
  }

  /**
   * ETag of the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getEtag() {
    return etag;
  }

  /**
   * ETag of the resource.
   * @param etag etag or {@code null} for none
   */
  public Task setEtag(java.lang.String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * Flag indicating whether the task is hidden. This is the case if the task had been marked
   * completed when the task list was last cleared. The default is False. This field is read-only.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getHidden() {
    return hidden;
  }

  /**
   * Flag indicating whether the task is hidden. This is the case if the task had been marked
   * completed when the task list was last cleared. The default is False. This field is read-only.
   * @param hidden hidden or {@code null} for none
   */
  public Task setHidden(java.lang.Boolean hidden) {
    this.hidden = hidden;
    return this;
  }

  /**
   * Task identifier.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * Task identifier.
   * @param id id or {@code null} for none
   */
  public Task setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * Type of the resource. This is always "tasks#task".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Type of the resource. This is always "tasks#task".
   * @param kind kind or {@code null} for none
   */
  public Task setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Collection of links. This collection is read-only.
   * @return value or {@code null} for none
   */
  public java.util.List<Links> getLinks() {
    return links;
  }

  /**
   * Collection of links. This collection is read-only.
   * @param links links or {@code null} for none
   */
  public Task setLinks(java.util.List<Links> links) {
    this.links = links;
    return this;
  }

  /**
   * Notes describing the task. Optional.
   * @return value or {@code null} for none
   */
  public java.lang.String getNotes() {
    return notes;
  }

  /**
   * Notes describing the task. Optional.
   * @param notes notes or {@code null} for none
   */
  public Task setNotes(java.lang.String notes) {
    this.notes = notes;
    return this;
  }

  /**
   * Parent task identifier. This field is omitted if it is a top-level task. This field is read-
   * only. Use the "move" method to move the task under a different parent or to the top level.
   * @return value or {@code null} for none
   */
  public java.lang.String getParent() {
    return parent;
  }

  /**
   * Parent task identifier. This field is omitted if it is a top-level task. This field is read-
   * only. Use the "move" method to move the task under a different parent or to the top level.
   * @param parent parent or {@code null} for none
   */
  public Task setParent(java.lang.String parent) {
    this.parent = parent;
    return this;
  }

  /**
   * String indicating the position of the task among its sibling tasks under the same parent task
   * or at the top level. If this string is greater than another task's corresponding position
   * string according to lexicographical ordering, the task is positioned after the other task under
   * the same parent task (or at the top level). This field is read-only. Use the "move" method to
   * move the task to another position.
   * @return value or {@code null} for none
   */
  public java.lang.String getPosition() {
    return position;
  }

  /**
   * String indicating the position of the task among its sibling tasks under the same parent task
   * or at the top level. If this string is greater than another task's corresponding position
   * string according to lexicographical ordering, the task is positioned after the other task under
   * the same parent task (or at the top level). This field is read-only. Use the "move" method to
   * move the task to another position.
   * @param position position or {@code null} for none
   */
  public Task setPosition(java.lang.String position) {
    this.position = position;
    return this;
  }

  /**
   * URL pointing to this task. Used to retrieve, update, or delete this task.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * URL pointing to this task. Used to retrieve, update, or delete this task.
   * @param selfLink selfLink or {@code null} for none
   */
  public Task setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * Status of the task. This is either "needsAction" or "completed".
   * @return value or {@code null} for none
   */
  public java.lang.String getStatus() {
    return status;
  }

  /**
   * Status of the task. This is either "needsAction" or "completed".
   * @param status status or {@code null} for none
   */
  public Task setStatus(java.lang.String status) {
    this.status = status;
    return this;
  }

  /**
   * Title of the task.
   * @return value or {@code null} for none
   */
  public java.lang.String getTitle() {
    return title;
  }

  /**
   * Title of the task.
   * @param title title or {@code null} for none
   */
  public Task setTitle(java.lang.String title) {
    this.title = title;
    return this;
  }

  /**
   * Last modification time of the task (as a RFC 3339 timestamp).
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getUpdated() {
    return updated;
  }

  /**
   * Last modification time of the task (as a RFC 3339 timestamp).
   * @param updated updated or {@code null} for none
   */
  public Task setUpdated(com.google.api.client.util.DateTime updated) {
    this.updated = updated;
    return this;
  }

  @Override
  public Task set(String fieldName, Object value) {
    return (Task) super.set(fieldName, value);
  }

  @Override
  public Task clone() {
    return (Task) super.clone();
  }

  /**
   * Model definition for TaskLinks.
   */
  public static final class Links extends com.google.api.client.json.GenericJson {

    /**
     * The description. In HTML speak: Everything between  and .
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String description;

    /**
     * The URL.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String link;

    /**
     * Type of the link, e.g. "email".
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String type;

    /**
     * The description. In HTML speak: Everything between  and .
     * @return value or {@code null} for none
     */
    public java.lang.String getDescription() {
      return description;
    }

    /**
     * The description. In HTML speak: Everything between  and .
     * @param description description or {@code null} for none
     */
    public Links setDescription(java.lang.String description) {
      this.description = description;
      return this;
    }

    /**
     * The URL.
     * @return value or {@code null} for none
     */
    public java.lang.String getLink() {
      return link;
    }

    /**
     * The URL.
     * @param link link or {@code null} for none
     */
    public Links setLink(java.lang.String link) {
      this.link = link;
      return this;
    }

    /**
     * Type of the link, e.g. "email".
     * @return value or {@code null} for none
     */
    public java.lang.String getType() {
      return type;
    }

    /**
     * Type of the link, e.g. "email".
     * @param type type or {@code null} for none
     */
    public Links setType(java.lang.String type) {
      this.type = type;
      return this;
    }

    @Override
    public Links set(String fieldName, Object value) {
      return (Links) super.set(fieldName, value);
    }

    @Override
    public Links clone() {
      return (Links) super.clone();
    }

  }

}
