/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2014-11-17 18:43:33 UTC)
 * on 2015-01-05 at 18:03:42 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.tasks.model;

/**
 * Model definition for TaskLists.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Tasks API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TaskLists extends com.google.api.client.json.GenericJson {

  /**
   * ETag of the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String etag;

  /**
   * Collection of task lists.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<TaskList> items;

  static {
    // hack to force ProGuard to consider TaskList used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(TaskList.class);
  }

  /**
   * Type of the resource. This is always "tasks#taskLists".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Token that can be used to request the next page of this result.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * ETag of the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getEtag() {
    return etag;
  }

  /**
   * ETag of the resource.
   * @param etag etag or {@code null} for none
   */
  public TaskLists setEtag(java.lang.String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * Collection of task lists.
   * @return value or {@code null} for none
   */
  public java.util.List<TaskList> getItems() {
    return items;
  }

  /**
   * Collection of task lists.
   * @param items items or {@code null} for none
   */
  public TaskLists setItems(java.util.List<TaskList> items) {
    this.items = items;
    return this;
  }

  /**
   * Type of the resource. This is always "tasks#taskLists".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Type of the resource. This is always "tasks#taskLists".
   * @param kind kind or {@code null} for none
   */
  public TaskLists setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Token that can be used to request the next page of this result.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * Token that can be used to request the next page of this result.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public TaskLists setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  @Override
  public TaskLists set(String fieldName, Object value) {
    return (TaskLists) super.set(fieldName, value);
  }

  @Override
  public TaskLists clone() {
    return (TaskLists) super.clone();
  }

}
