/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-09-26 19:19:48 UTC)
 * on 2017-09-29 at 19:04:55 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.tasks.model;

/**
 * Model definition for TaskLists.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Tasks API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TaskLists extends com.google.api.client.json.GenericJson {

  /**
   * ETag of the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String etag;

  /**
   * Collection of task lists.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<TaskList> items;

  static {
    // hack to force ProGuard to consider TaskList used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(TaskList.class);
  }

  /**
   * Type of the resource. This is always "tasks#taskLists".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Token that can be used to request the next page of this result.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * ETag of the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getEtag() {
    return etag;
  }

  /**
   * ETag of the resource.
   * @param etag etag or {@code null} for none
   */
  public TaskLists setEtag(java.lang.String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * Collection of task lists.
   * @return value or {@code null} for none
   */
  public java.util.List<TaskList> getItems() {
    return items;
  }

  /**
   * Collection of task lists.
   * @param items items or {@code null} for none
   */
  public TaskLists setItems(java.util.List<TaskList> items) {
    this.items = items;
    return this;
  }

  /**
   * Type of the resource. This is always "tasks#taskLists".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Type of the resource. This is always "tasks#taskLists".
   * @param kind kind or {@code null} for none
   */
  public TaskLists setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Token that can be used to request the next page of this result.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * Token that can be used to request the next page of this result.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public TaskLists setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  @Override
  public TaskLists set(String fieldName, Object value) {
    return (TaskLists) super.set(fieldName, value);
  }

  @Override
  public TaskLists clone() {
    return (TaskLists) super.clone();
  }

}
