/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.tasks;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.tasks.TasksRequest;
import com.google.api.services.tasks.TasksRequestInitializer;
import com.google.api.services.tasks.model.Task;
import com.google.api.services.tasks.model.TaskList;
import com.google.api.services.tasks.model.TaskLists;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tasks
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "tasks/v1/";
    public static final String DEFAULT_BATCH_PATH = "batch/tasks/v1";
    public static final String DEFAULT_BASE_URL = "https://www.googleapis.com/tasks/v1/";

    public Tasks(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    Tasks(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public Tasklists tasklists() {
        return new Tasklists();
    }

    public TasksOperations tasks() {
        return new TasksOperations();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.23.0 of the Tasks API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, Tasks.DEFAULT_ROOT_URL, Tasks.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Tasks.DEFAULT_BATCH_PATH);
        }

        public Tasks build() {
            return new Tasks(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setBatchPath(String string) {
            return (Builder)super.setBatchPath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setTasksRequestInitializer(TasksRequestInitializer tasksRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)tasksRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class TasksOperations {
        public Clear clear(String string) throws IOException {
            Clear clear = new Clear(string);
            Tasks.this.initialize((AbstractGoogleClientRequest<?>)clear);
            return clear;
        }

        public Delete delete(String string, String string2) throws IOException {
            Delete delete = new Delete(string, string2);
            Tasks.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Tasks.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(String string, Task task) throws IOException {
            Insert insert = new Insert(string, task);
            Tasks.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Tasks.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Move move(String string, String string2) throws IOException {
            Move move = new Move(string, string2);
            Tasks.this.initialize((AbstractGoogleClientRequest<?>)move);
            return move;
        }

        public Patch patch(String string, String string2, Task task) throws IOException {
            Patch patch = new Patch(string, string2, task);
            Tasks.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        public Update update(String string, String string2, Task task) throws IOException {
            Update update = new Update(string, string2, task);
            Tasks.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends TasksRequest<Task> {
            private static final String REST_PATH = "lists/{tasklist}/tasks/{task}";
            @Key
            private String tasklist;
            @Key
            private String task;

            protected Update(String string, String string2, Task task) {
                super(Tasks.this, "PUT", REST_PATH, (Object)task, Task.class);
                this.tasklist = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter tasklist must be specified.");
                this.task = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter task must be specified.");
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getTasklist() {
                return this.tasklist;
            }

            public Update setTasklist(String string) {
                this.tasklist = string;
                return this;
            }

            public String getTask() {
                return this.task;
            }

            public Update setTask(String string) {
                this.task = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends TasksRequest<Task> {
            private static final String REST_PATH = "lists/{tasklist}/tasks/{task}";
            @Key
            private String tasklist;
            @Key
            private String task;

            protected Patch(String string, String string2, Task task) {
                super(Tasks.this, "PATCH", REST_PATH, (Object)task, Task.class);
                this.tasklist = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter tasklist must be specified.");
                this.task = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter task must be specified.");
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public String getTasklist() {
                return this.tasklist;
            }

            public Patch setTasklist(String string) {
                this.tasklist = string;
                return this;
            }

            public String getTask() {
                return this.task;
            }

            public Patch setTask(String string) {
                this.task = string;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Move
        extends TasksRequest<Task> {
            private static final String REST_PATH = "lists/{tasklist}/tasks/{task}/move";
            @Key
            private String tasklist;
            @Key
            private String task;
            @Key
            private String parent;
            @Key
            private String previous;

            protected Move(String string, String string2) {
                super(Tasks.this, "POST", REST_PATH, null, Task.class);
                this.tasklist = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter tasklist must be specified.");
                this.task = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter task must be specified.");
            }

            public Move setAlt(String string) {
                return (Move)super.setAlt(string);
            }

            public Move setFields(String string) {
                return (Move)super.setFields(string);
            }

            public Move setKey(String string) {
                return (Move)super.setKey(string);
            }

            public Move setOauthToken(String string) {
                return (Move)super.setOauthToken(string);
            }

            public Move setPrettyPrint(Boolean bl) {
                return (Move)super.setPrettyPrint(bl);
            }

            public Move setQuotaUser(String string) {
                return (Move)super.setQuotaUser(string);
            }

            public Move setUserIp(String string) {
                return (Move)super.setUserIp(string);
            }

            public String getTasklist() {
                return this.tasklist;
            }

            public Move setTasklist(String string) {
                this.tasklist = string;
                return this;
            }

            public String getTask() {
                return this.task;
            }

            public Move setTask(String string) {
                this.task = string;
                return this;
            }

            public String getParent() {
                return this.parent;
            }

            public Move setParent(String string) {
                this.parent = string;
                return this;
            }

            public String getPrevious() {
                return this.previous;
            }

            public Move setPrevious(String string) {
                this.previous = string;
                return this;
            }

            @Override
            public Move set(String string, Object object) {
                return (Move)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends TasksRequest<com.google.api.services.tasks.model.Tasks> {
            private static final String REST_PATH = "lists/{tasklist}/tasks";
            @Key
            private String tasklist;
            @Key
            private String completedMax;
            @Key
            private String completedMin;
            @Key
            private String dueMax;
            @Key
            private String dueMin;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;
            @Key
            private Boolean showCompleted;
            @Key
            private Boolean showDeleted;
            @Key
            private Boolean showHidden;
            @Key
            private String updatedMin;

            protected List(String string) {
                super(Tasks.this, "GET", REST_PATH, null, com.google.api.services.tasks.model.Tasks.class);
                this.tasklist = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter tasklist must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getTasklist() {
                return this.tasklist;
            }

            public List setTasklist(String string) {
                this.tasklist = string;
                return this;
            }

            public String getCompletedMax() {
                return this.completedMax;
            }

            public List setCompletedMax(String string) {
                this.completedMax = string;
                return this;
            }

            public String getCompletedMin() {
                return this.completedMin;
            }

            public List setCompletedMin(String string) {
                this.completedMin = string;
                return this;
            }

            public String getDueMax() {
                return this.dueMax;
            }

            public List setDueMax(String string) {
                this.dueMax = string;
                return this;
            }

            public String getDueMin() {
                return this.dueMin;
            }

            public List setDueMin(String string) {
                this.dueMin = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Boolean getShowCompleted() {
                return this.showCompleted;
            }

            public List setShowCompleted(Boolean bl) {
                this.showCompleted = bl;
                return this;
            }

            public Boolean getShowDeleted() {
                return this.showDeleted;
            }

            public List setShowDeleted(Boolean bl) {
                this.showDeleted = bl;
                return this;
            }

            public Boolean getShowHidden() {
                return this.showHidden;
            }

            public List setShowHidden(Boolean bl) {
                this.showHidden = bl;
                return this;
            }

            public String getUpdatedMin() {
                return this.updatedMin;
            }

            public List setUpdatedMin(String string) {
                this.updatedMin = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends TasksRequest<Task> {
            private static final String REST_PATH = "lists/{tasklist}/tasks";
            @Key
            private String tasklist;
            @Key
            private String parent;
            @Key
            private String previous;

            protected Insert(String string, Task task) {
                super(Tasks.this, "POST", REST_PATH, (Object)task, Task.class);
                this.tasklist = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter tasklist must be specified.");
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getTasklist() {
                return this.tasklist;
            }

            public Insert setTasklist(String string) {
                this.tasklist = string;
                return this;
            }

            public String getParent() {
                return this.parent;
            }

            public Insert setParent(String string) {
                this.parent = string;
                return this;
            }

            public String getPrevious() {
                return this.previous;
            }

            public Insert setPrevious(String string) {
                this.previous = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends TasksRequest<Task> {
            private static final String REST_PATH = "lists/{tasklist}/tasks/{task}";
            @Key
            private String tasklist;
            @Key
            private String task;

            protected Get(String string, String string2) {
                super(Tasks.this, "GET", REST_PATH, null, Task.class);
                this.tasklist = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter tasklist must be specified.");
                this.task = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter task must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getTasklist() {
                return this.tasklist;
            }

            public Get setTasklist(String string) {
                this.tasklist = string;
                return this;
            }

            public String getTask() {
                return this.task;
            }

            public Get setTask(String string) {
                this.task = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends TasksRequest<Void> {
            private static final String REST_PATH = "lists/{tasklist}/tasks/{task}";
            @Key
            private String tasklist;
            @Key
            private String task;

            protected Delete(String string, String string2) {
                super(Tasks.this, "DELETE", REST_PATH, null, Void.class);
                this.tasklist = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter tasklist must be specified.");
                this.task = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter task must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getTasklist() {
                return this.tasklist;
            }

            public Delete setTasklist(String string) {
                this.tasklist = string;
                return this;
            }

            public String getTask() {
                return this.task;
            }

            public Delete setTask(String string) {
                this.task = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Clear
        extends TasksRequest<Void> {
            private static final String REST_PATH = "lists/{tasklist}/clear";
            @Key
            private String tasklist;

            protected Clear(String string) {
                super(Tasks.this, "POST", REST_PATH, null, Void.class);
                this.tasklist = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter tasklist must be specified.");
            }

            public Clear setAlt(String string) {
                return (Clear)super.setAlt(string);
            }

            public Clear setFields(String string) {
                return (Clear)super.setFields(string);
            }

            public Clear setKey(String string) {
                return (Clear)super.setKey(string);
            }

            public Clear setOauthToken(String string) {
                return (Clear)super.setOauthToken(string);
            }

            public Clear setPrettyPrint(Boolean bl) {
                return (Clear)super.setPrettyPrint(bl);
            }

            public Clear setQuotaUser(String string) {
                return (Clear)super.setQuotaUser(string);
            }

            public Clear setUserIp(String string) {
                return (Clear)super.setUserIp(string);
            }

            public String getTasklist() {
                return this.tasklist;
            }

            public Clear setTasklist(String string) {
                this.tasklist = string;
                return this;
            }

            @Override
            public Clear set(String string, Object object) {
                return (Clear)super.set(string, object);
            }
        }
    }

    public class Tasklists {
        public Delete delete(String string) throws IOException {
            Delete delete = new Delete(string);
            Tasks.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string) throws IOException {
            Get get = new Get(string);
            Tasks.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(TaskList taskList) throws IOException {
            Insert insert = new Insert(taskList);
            Tasks.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list() throws IOException {
            List list = new List();
            Tasks.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Patch patch(String string, TaskList taskList) throws IOException {
            Patch patch = new Patch(string, taskList);
            Tasks.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        public Update update(String string, TaskList taskList) throws IOException {
            Update update = new Update(string, taskList);
            Tasks.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends TasksRequest<TaskList> {
            private static final String REST_PATH = "users/@me/lists/{tasklist}";
            @Key
            private String tasklist;

            protected Update(String string, TaskList taskList) {
                super(Tasks.this, "PUT", REST_PATH, (Object)taskList, TaskList.class);
                this.tasklist = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter tasklist must be specified.");
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getTasklist() {
                return this.tasklist;
            }

            public Update setTasklist(String string) {
                this.tasklist = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends TasksRequest<TaskList> {
            private static final String REST_PATH = "users/@me/lists/{tasklist}";
            @Key
            private String tasklist;

            protected Patch(String string, TaskList taskList) {
                super(Tasks.this, "PATCH", REST_PATH, (Object)taskList, TaskList.class);
                this.tasklist = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter tasklist must be specified.");
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public String getTasklist() {
                return this.tasklist;
            }

            public Patch setTasklist(String string) {
                this.tasklist = string;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends TasksRequest<TaskLists> {
            private static final String REST_PATH = "users/@me/lists";
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List() {
                super(Tasks.this, "GET", REST_PATH, null, TaskLists.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends TasksRequest<TaskList> {
            private static final String REST_PATH = "users/@me/lists";

            protected Insert(TaskList taskList) {
                super(Tasks.this, "POST", REST_PATH, (Object)taskList, TaskList.class);
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends TasksRequest<TaskList> {
            private static final String REST_PATH = "users/@me/lists/{tasklist}";
            @Key
            private String tasklist;

            protected Get(String string) {
                super(Tasks.this, "GET", REST_PATH, null, TaskList.class);
                this.tasklist = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter tasklist must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getTasklist() {
                return this.tasklist;
            }

            public Get setTasklist(String string) {
                this.tasklist = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends TasksRequest<Void> {
            private static final String REST_PATH = "users/@me/lists/{tasklist}";
            @Key
            private String tasklist;

            protected Delete(String string) {
                super(Tasks.this, "DELETE", REST_PATH, null, Void.class);
                this.tasklist = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter tasklist must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getTasklist() {
                return this.tasklist;
            }

            public Delete setTasklist(String string) {
                this.tasklist = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }
}

