/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2016-01-08 17:48:37 UTC)
 * on 2016-02-19 at 02:01:04 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.translate;

/**
 * Service definition for Translate (v2).
 *
 * <p>
 * Lets you translate text from one language to another
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://developers.google.com/translate/v2/using_rest" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link TranslateRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class Translate extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 15,
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.15 of google-api-client to run version " +
        "1.21.0 of the Translate API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "language/translate/";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public Translate(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  Translate(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the Detections collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Translate translate = new Translate(...);}
   *   {@code Translate.Detections.List request = translate.detections().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Detections detections() {
    return new Detections();
  }

  /**
   * The "detections" collection of methods.
   */
  public class Detections {

    /**
     * Detect the language of text.
     *
     * Create a request for the method "detections.list".
     *
     * This request holds the parameters needed by the translate server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param q The text to detect
     * @return the request
     */
    public List list(java.util.List<java.lang.String> q) throws java.io.IOException {
      List result = new List(q);
      initialize(result);
      return result;
    }

    public class List extends TranslateRequest<com.google.api.services.translate.model.DetectionsListResponse> {

      private static final String REST_PATH = "v2/detect";

      /**
       * Detect the language of text.
       *
       * Create a request for the method "detections.list".
       *
       * This request holds the parameters needed by the the translate server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
       * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param q The text to detect
       * @since 1.13
       */
      protected List(java.util.List<java.lang.String> q) {
        super(Translate.this, "GET", REST_PATH, null, com.google.api.services.translate.model.DetectionsListResponse.class);
        this.q = com.google.api.client.util.Preconditions.checkNotNull(q, "Required parameter q must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** The text to detect */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> q;

      /** The text to detect
       */
      public java.util.List<java.lang.String> getQ() {
        return q;
      }

      /** The text to detect */
      public List setQ(java.util.List<java.lang.String> q) {
        this.q = q;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Languages collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Translate translate = new Translate(...);}
   *   {@code Translate.Languages.List request = translate.languages().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Languages languages() {
    return new Languages();
  }

  /**
   * The "languages" collection of methods.
   */
  public class Languages {

    /**
     * List the source/target languages supported by the API
     *
     * Create a request for the method "languages.list".
     *
     * This request holds the parameters needed by the translate server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public List list() throws java.io.IOException {
      List result = new List();
      initialize(result);
      return result;
    }

    public class List extends TranslateRequest<com.google.api.services.translate.model.LanguagesListResponse> {

      private static final String REST_PATH = "v2/languages";

      /**
       * List the source/target languages supported by the API
       *
       * Create a request for the method "languages.list".
       *
       * This request holds the parameters needed by the the translate server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
       * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected List() {
        super(Translate.this, "GET", REST_PATH, null, com.google.api.services.translate.model.LanguagesListResponse.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** the language and collation in which the localized results should be returned */
      @com.google.api.client.util.Key
      private java.lang.String target;

      /** the language and collation in which the localized results should be returned
       */
      public java.lang.String getTarget() {
        return target;
      }

      /** the language and collation in which the localized results should be returned */
      public List setTarget(java.lang.String target) {
        this.target = target;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Translations collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Translate translate = new Translate(...);}
   *   {@code Translate.Translations.List request = translate.translations().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Translations translations() {
    return new Translations();
  }

  /**
   * The "translations" collection of methods.
   */
  public class Translations {

    /**
     * Returns text translations from one language to another.
     *
     * Create a request for the method "translations.list".
     *
     * This request holds the parameters needed by the translate server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param q The text to translate
     * @param target The target language into which the text should be translated
     * @return the request
     */
    public List list(java.util.List<java.lang.String> q, java.lang.String target) throws java.io.IOException {
      List result = new List(q, target);
      initialize(result);
      return result;
    }

    public class List extends TranslateRequest<com.google.api.services.translate.model.TranslationsListResponse> {

      private static final String REST_PATH = "v2";

      /**
       * Returns text translations from one language to another.
       *
       * Create a request for the method "translations.list".
       *
       * This request holds the parameters needed by the the translate server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
       * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param q The text to translate
       * @param target The target language into which the text should be translated
       * @since 1.13
       */
      protected List(java.util.List<java.lang.String> q, java.lang.String target) {
        super(Translate.this, "GET", REST_PATH, null, com.google.api.services.translate.model.TranslationsListResponse.class);
        this.q = com.google.api.client.util.Preconditions.checkNotNull(q, "Required parameter q must be specified.");
        this.target = com.google.api.client.util.Preconditions.checkNotNull(target, "Required parameter target must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** The text to translate */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> q;

      /** The text to translate
       */
      public java.util.List<java.lang.String> getQ() {
        return q;
      }

      /** The text to translate */
      public List setQ(java.util.List<java.lang.String> q) {
        this.q = q;
        return this;
      }

      /** The target language into which the text should be translated */
      @com.google.api.client.util.Key
      private java.lang.String target;

      /** The target language into which the text should be translated
       */
      public java.lang.String getTarget() {
        return target;
      }

      /** The target language into which the text should be translated */
      public List setTarget(java.lang.String target) {
        this.target = target;
        return this;
      }

      /** The source language of the text */
      @com.google.api.client.util.Key
      private java.lang.String source;

      /** The source language of the text
       */
      public java.lang.String getSource() {
        return source;
      }

      /** The source language of the text */
      public List setSource(java.lang.String source) {
        this.source = source;
        return this;
      }

      /** The format of the text */
      @com.google.api.client.util.Key
      private java.lang.String format;

      /** The format of the text
       */
      public java.lang.String getFormat() {
        return format;
      }

      /** The format of the text */
      public List setFormat(java.lang.String format) {
        this.format = format;
        return this;
      }

      /** The customization id for translate */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> cid;

      /** The customization id for translate
       */
      public java.util.List<java.lang.String> getCid() {
        return cid;
      }

      /** The customization id for translate */
      public List setCid(java.util.List<java.lang.String> cid) {
        this.cid = cid;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * Builder for {@link Translate}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient.Builder {

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport, which should normally be:
     *        <ul>
     *        <li>Google App Engine:
     *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
     *        <li>Android: {@code newCompatibleTransport} from
     *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
     *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
     *        </li>
     *        </ul>
     * @param jsonFactory JSON factory, which may be:
     *        <ul>
     *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
     *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
     *        <li>Android Honeycomb or higher:
     *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
     *        </ul>
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          DEFAULT_ROOT_URL,
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          true);
    }

    /** Builds a new instance of {@link Translate}. */
    @Override
    public Translate build() {
      return new Translate(this);
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setHttpRequestInitializer(com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    @Override
    public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
      return (Builder) super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
    }

    @Override
    public Builder setSuppressAllChecks(boolean suppressAllChecks) {
      return (Builder) super.setSuppressAllChecks(suppressAllChecks);
    }

    /**
     * Set the {@link TranslateRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setTranslateRequestInitializer(
        TranslateRequestInitializer translateRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(translateRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        com.google.api.client.googleapis.services.GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
