/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2016-01-08 17:48:37 UTC)
 * on 2016-02-19 at 02:01:04 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.translate.model;

/**
 * Model definition for LanguagesListResponse.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Translate API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class LanguagesListResponse extends com.google.api.client.json.GenericJson {

  /**
   * List of source/target languages supported by the translation API. If target parameter is
   * unspecified, the list is sorted by the ASCII code point order of the language code. If target
   * parameter is specified, the list is sorted by the collation order of the language name in the
   * target language.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<LanguagesResource> languages;

  /**
   * List of source/target languages supported by the translation API. If target parameter is
   * unspecified, the list is sorted by the ASCII code point order of the language code. If target
   * parameter is specified, the list is sorted by the collation order of the language name in the
   * target language.
   * @return value or {@code null} for none
   */
  public java.util.List<LanguagesResource> getLanguages() {
    return languages;
  }

  /**
   * List of source/target languages supported by the translation API. If target parameter is
   * unspecified, the list is sorted by the ASCII code point order of the language code. If target
   * parameter is specified, the list is sorted by the collation order of the language name in the
   * target language.
   * @param languages languages or {@code null} for none
   */
  public LanguagesListResponse setLanguages(java.util.List<LanguagesResource> languages) {
    this.languages = languages;
    return this;
  }

  @Override
  public LanguagesListResponse set(String fieldName, Object value) {
    return (LanguagesListResponse) super.set(fieldName, value);
  }

  @Override
  public LanguagesListResponse clone() {
    return (LanguagesListResponse) super.clone();
  }

}
