/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.translate.v3;

/**
 * Service definition for Translate (v3).
 *
 * <p>
 * Integrates text translation into your website or application.
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://cloud.google.com/translate/docs/quickstarts" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link TranslateRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class Translate extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        (com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        (com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 32 ||
        (com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION == 31 &&
        com.google.api.client.googleapis.GoogleUtils.BUGFIX_VERSION >= 1))) ||
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION >= 2,
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.31.1 of google-api-client to run version " +
        "2.0.0 of the Cloud Translation API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://translation.googleapis.com/";

  /**
   * The default encoded mTLS root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.31
   */
  public static final String DEFAULT_MTLS_ROOT_URL = "https://translation.mtls.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "";

  /**
   * The default encoded batch path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.23
   */
  public static final String DEFAULT_BATCH_PATH = "batch";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public Translate(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  Translate(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the Projects collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Translate translate = new Translate(...);}
   *   {@code Translate.Projects.List request = translate.projects().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Projects projects() {
    return new Projects();
  }

  /**
   * The "projects" collection of methods.
   */
  public class Projects {

    /**
     * Detects the language of text within a request.
     *
     * Create a request for the method "projects.detectLanguage".
     *
     * This request holds the parameters needed by the translate server.  After setting any optional
     * parameters, call the {@link DetectLanguage#execute()} method to invoke the remote operation.
     *
     * @param parent Required. Project or location to make a call. Must refer to a caller's project. Format: `projects
     *        /{project-number-or-id}/locations/{location-id}` or `projects/{project-number-or-id}`. For
     *        global calls, use `projects/{project-number-or-id}/locations/global` or `projects
     *        /{project-number-or-id}`. Only models within the same region (has same location-id) can be
     *        used. Otherwise an INVALID_ARGUMENT (400) error is returned.
     * @param content the {@link com.google.api.services.translate.v3.model.DetectLanguageRequest}
     * @return the request
     */
    public DetectLanguage detectLanguage(java.lang.String parent, com.google.api.services.translate.v3.model.DetectLanguageRequest content) throws java.io.IOException {
      DetectLanguage result = new DetectLanguage(parent, content);
      initialize(result);
      return result;
    }

    public class DetectLanguage extends TranslateRequest<com.google.api.services.translate.v3.model.DetectLanguageResponse> {

      private static final String REST_PATH = "v3/{+parent}:detectLanguage";

      private final java.util.regex.Pattern PARENT_PATTERN =
          java.util.regex.Pattern.compile("^projects/[^/]+$");

      /**
       * Detects the language of text within a request.
       *
       * Create a request for the method "projects.detectLanguage".
       *
       * This request holds the parameters needed by the the translate server.  After setting any
       * optional parameters, call the {@link DetectLanguage#execute()} method to invoke the remote
       * operation. <p> {@link DetectLanguage#initialize(com.google.api.client.googleapis.services.Abstr
       * actGoogleClientRequest)} must be called to initialize this instance immediately after invoking
       * the constructor. </p>
       *
       * @param parent Required. Project or location to make a call. Must refer to a caller's project. Format: `projects
     *        /{project-number-or-id}/locations/{location-id}` or `projects/{project-number-or-id}`. For
     *        global calls, use `projects/{project-number-or-id}/locations/global` or `projects
     *        /{project-number-or-id}`. Only models within the same region (has same location-id) can be
     *        used. Otherwise an INVALID_ARGUMENT (400) error is returned.
       * @param content the {@link com.google.api.services.translate.v3.model.DetectLanguageRequest}
       * @since 1.13
       */
      protected DetectLanguage(java.lang.String parent, com.google.api.services.translate.v3.model.DetectLanguageRequest content) {
        super(Translate.this, "POST", REST_PATH, content, com.google.api.services.translate.v3.model.DetectLanguageResponse.class);
        this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
              "Parameter parent must conform to the pattern " +
              "^projects/[^/]+$");
        }
      }

      @Override
      public DetectLanguage set$Xgafv(java.lang.String $Xgafv) {
        return (DetectLanguage) super.set$Xgafv($Xgafv);
      }

      @Override
      public DetectLanguage setAccessToken(java.lang.String accessToken) {
        return (DetectLanguage) super.setAccessToken(accessToken);
      }

      @Override
      public DetectLanguage setAlt(java.lang.String alt) {
        return (DetectLanguage) super.setAlt(alt);
      }

      @Override
      public DetectLanguage setCallback(java.lang.String callback) {
        return (DetectLanguage) super.setCallback(callback);
      }

      @Override
      public DetectLanguage setFields(java.lang.String fields) {
        return (DetectLanguage) super.setFields(fields);
      }

      @Override
      public DetectLanguage setKey(java.lang.String key) {
        return (DetectLanguage) super.setKey(key);
      }

      @Override
      public DetectLanguage setOauthToken(java.lang.String oauthToken) {
        return (DetectLanguage) super.setOauthToken(oauthToken);
      }

      @Override
      public DetectLanguage setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (DetectLanguage) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public DetectLanguage setQuotaUser(java.lang.String quotaUser) {
        return (DetectLanguage) super.setQuotaUser(quotaUser);
      }

      @Override
      public DetectLanguage setUploadType(java.lang.String uploadType) {
        return (DetectLanguage) super.setUploadType(uploadType);
      }

      @Override
      public DetectLanguage setUploadProtocol(java.lang.String uploadProtocol) {
        return (DetectLanguage) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * Required. Project or location to make a call. Must refer to a caller's project. Format:
       * `projects/{project-number-or-id}/locations/{location-id}` or `projects/{project-number-or-
       * id}`. For global calls, use `projects/{project-number-or-id}/locations/global` or `projects
       * /{project-number-or-id}`. Only models within the same region (has same location-id) can be
       * used. Otherwise an INVALID_ARGUMENT (400) error is returned.
       */
      @com.google.api.client.util.Key
      private java.lang.String parent;

      /** Required. Project or location to make a call. Must refer to a caller's project. Format: `projects
     /{project-number-or-id}/locations/{location-id}` or `projects/{project-number-or-id}`. For global
     calls, use `projects/{project-number-or-id}/locations/global` or `projects/{project-number-or-id}`.
     Only models within the same region (has same location-id) can be used. Otherwise an
     INVALID_ARGUMENT (400) error is returned.
       */
      public java.lang.String getParent() {
        return parent;
      }

      /**
       * Required. Project or location to make a call. Must refer to a caller's project. Format:
       * `projects/{project-number-or-id}/locations/{location-id}` or `projects/{project-number-or-
       * id}`. For global calls, use `projects/{project-number-or-id}/locations/global` or `projects
       * /{project-number-or-id}`. Only models within the same region (has same location-id) can be
       * used. Otherwise an INVALID_ARGUMENT (400) error is returned.
       */
      public DetectLanguage setParent(java.lang.String parent) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
              "Parameter parent must conform to the pattern " +
              "^projects/[^/]+$");
        }
        this.parent = parent;
        return this;
      }

      @Override
      public DetectLanguage set(String parameterName, Object value) {
        return (DetectLanguage) super.set(parameterName, value);
      }
    }
    /**
     * Returns a list of supported languages for translation.
     *
     * Create a request for the method "projects.getSupportedLanguages".
     *
     * This request holds the parameters needed by the translate server.  After setting any optional
     * parameters, call the {@link GetSupportedLanguages#execute()} method to invoke the remote
     * operation.
     *
     * @param parent Required. Project or location to make a call. Must refer to a caller's project. Format: `projects
     *        /{project-number-or-id}` or `projects/{project-number-or-id}/locations/{location-id}`. For
     *        global calls, use `projects/{project-number-or-id}/locations/global` or `projects
     *        /{project-number-or-id}`. Non-global location is required for AutoML models. Only models
     *        within the same region (have same location-id) can be used, otherwise an INVALID_ARGUMENT
     *        (400) error is returned.
     * @return the request
     */
    public GetSupportedLanguages getSupportedLanguages(java.lang.String parent) throws java.io.IOException {
      GetSupportedLanguages result = new GetSupportedLanguages(parent);
      initialize(result);
      return result;
    }

    public class GetSupportedLanguages extends TranslateRequest<com.google.api.services.translate.v3.model.SupportedLanguages> {

      private static final String REST_PATH = "v3/{+parent}/supportedLanguages";

      private final java.util.regex.Pattern PARENT_PATTERN =
          java.util.regex.Pattern.compile("^projects/[^/]+$");

      /**
       * Returns a list of supported languages for translation.
       *
       * Create a request for the method "projects.getSupportedLanguages".
       *
       * This request holds the parameters needed by the the translate server.  After setting any
       * optional parameters, call the {@link GetSupportedLanguages#execute()} method to invoke the
       * remote operation. <p> {@link GetSupportedLanguages#initialize(com.google.api.client.googleapis.
       * services.AbstractGoogleClientRequest)} must be called to initialize this instance immediately
       * after invoking the constructor. </p>
       *
       * @param parent Required. Project or location to make a call. Must refer to a caller's project. Format: `projects
     *        /{project-number-or-id}` or `projects/{project-number-or-id}/locations/{location-id}`. For
     *        global calls, use `projects/{project-number-or-id}/locations/global` or `projects
     *        /{project-number-or-id}`. Non-global location is required for AutoML models. Only models
     *        within the same region (have same location-id) can be used, otherwise an INVALID_ARGUMENT
     *        (400) error is returned.
       * @since 1.13
       */
      protected GetSupportedLanguages(java.lang.String parent) {
        super(Translate.this, "GET", REST_PATH, null, com.google.api.services.translate.v3.model.SupportedLanguages.class);
        this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
              "Parameter parent must conform to the pattern " +
              "^projects/[^/]+$");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public GetSupportedLanguages set$Xgafv(java.lang.String $Xgafv) {
        return (GetSupportedLanguages) super.set$Xgafv($Xgafv);
      }

      @Override
      public GetSupportedLanguages setAccessToken(java.lang.String accessToken) {
        return (GetSupportedLanguages) super.setAccessToken(accessToken);
      }

      @Override
      public GetSupportedLanguages setAlt(java.lang.String alt) {
        return (GetSupportedLanguages) super.setAlt(alt);
      }

      @Override
      public GetSupportedLanguages setCallback(java.lang.String callback) {
        return (GetSupportedLanguages) super.setCallback(callback);
      }

      @Override
      public GetSupportedLanguages setFields(java.lang.String fields) {
        return (GetSupportedLanguages) super.setFields(fields);
      }

      @Override
      public GetSupportedLanguages setKey(java.lang.String key) {
        return (GetSupportedLanguages) super.setKey(key);
      }

      @Override
      public GetSupportedLanguages setOauthToken(java.lang.String oauthToken) {
        return (GetSupportedLanguages) super.setOauthToken(oauthToken);
      }

      @Override
      public GetSupportedLanguages setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (GetSupportedLanguages) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public GetSupportedLanguages setQuotaUser(java.lang.String quotaUser) {
        return (GetSupportedLanguages) super.setQuotaUser(quotaUser);
      }

      @Override
      public GetSupportedLanguages setUploadType(java.lang.String uploadType) {
        return (GetSupportedLanguages) super.setUploadType(uploadType);
      }

      @Override
      public GetSupportedLanguages setUploadProtocol(java.lang.String uploadProtocol) {
        return (GetSupportedLanguages) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * Required. Project or location to make a call. Must refer to a caller's project. Format:
       * `projects/{project-number-or-id}` or `projects/{project-number-or-id}/locations/{location-
       * id}`. For global calls, use `projects/{project-number-or-id}/locations/global` or `projects
       * /{project-number-or-id}`. Non-global location is required for AutoML models. Only models
       * within the same region (have same location-id) can be used, otherwise an INVALID_ARGUMENT
       * (400) error is returned.
       */
      @com.google.api.client.util.Key
      private java.lang.String parent;

      /** Required. Project or location to make a call. Must refer to a caller's project. Format: `projects
     /{project-number-or-id}` or `projects/{project-number-or-id}/locations/{location-id}`. For global
     calls, use `projects/{project-number-or-id}/locations/global` or `projects/{project-number-or-id}`.
     Non-global location is required for AutoML models. Only models within the same region (have same
     location-id) can be used, otherwise an INVALID_ARGUMENT (400) error is returned.
       */
      public java.lang.String getParent() {
        return parent;
      }

      /**
       * Required. Project or location to make a call. Must refer to a caller's project. Format:
       * `projects/{project-number-or-id}` or `projects/{project-number-or-id}/locations/{location-
       * id}`. For global calls, use `projects/{project-number-or-id}/locations/global` or `projects
       * /{project-number-or-id}`. Non-global location is required for AutoML models. Only models
       * within the same region (have same location-id) can be used, otherwise an INVALID_ARGUMENT
       * (400) error is returned.
       */
      public GetSupportedLanguages setParent(java.lang.String parent) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
              "Parameter parent must conform to the pattern " +
              "^projects/[^/]+$");
        }
        this.parent = parent;
        return this;
      }

      /**
       * Optional. The language to use to return localized, human readable names of supported
       * languages. If missing, then display names are not returned in a response.
       */
      @com.google.api.client.util.Key
      private java.lang.String displayLanguageCode;

      /** Optional. The language to use to return localized, human readable names of supported languages. If
     missing, then display names are not returned in a response.
       */
      public java.lang.String getDisplayLanguageCode() {
        return displayLanguageCode;
      }

      /**
       * Optional. The language to use to return localized, human readable names of supported
       * languages. If missing, then display names are not returned in a response.
       */
      public GetSupportedLanguages setDisplayLanguageCode(java.lang.String displayLanguageCode) {
        this.displayLanguageCode = displayLanguageCode;
        return this;
      }

      /**
       * Optional. Get supported languages of this model. The format depends on model type: - AutoML
       * Translation models: `projects/{project-number-or-id}/locations/{location-id}/models/{model-
       * id}` - General (built-in) models: `projects/{project-number-or-id}/locations/{location-
       * id}/models/general/nmt`, Returns languages supported by the specified model. If missing, we
       * get supported languages of Google general NMT model.
       */
      @com.google.api.client.util.Key
      private java.lang.String model;

      /** Optional. Get supported languages of this model. The format depends on model type: - AutoML
     Translation models: `projects/{project-number-or-id}/locations/{location-id}/models/{model-id}` -
     General (built-in) models: `projects/{project-number-or-id}/locations/{location-
     id}/models/general/nmt`, Returns languages supported by the specified model. If missing, we get
     supported languages of Google general NMT model.
       */
      public java.lang.String getModel() {
        return model;
      }

      /**
       * Optional. Get supported languages of this model. The format depends on model type: - AutoML
       * Translation models: `projects/{project-number-or-id}/locations/{location-id}/models/{model-
       * id}` - General (built-in) models: `projects/{project-number-or-id}/locations/{location-
       * id}/models/general/nmt`, Returns languages supported by the specified model. If missing, we
       * get supported languages of Google general NMT model.
       */
      public GetSupportedLanguages setModel(java.lang.String model) {
        this.model = model;
        return this;
      }

      @Override
      public GetSupportedLanguages set(String parameterName, Object value) {
        return (GetSupportedLanguages) super.set(parameterName, value);
      }
    }
    /**
     * Romanize input text written in non-Latin scripts to Latin text.
     *
     * Create a request for the method "projects.romanizeText".
     *
     * This request holds the parameters needed by the translate server.  After setting any optional
     * parameters, call the {@link RomanizeText#execute()} method to invoke the remote operation.
     *
     * @param parent Required. Project or location to make a call. Must refer to a caller's project. Format: `projects
     *        /{project-number-or-id}/locations/{location-id}` or `projects/{project-number-or-id}`. For
     *        global calls, use `projects/{project-number-or-id}/locations/global` or `projects
     *        /{project-number-or-id}`.
     * @param content the {@link com.google.api.services.translate.v3.model.RomanizeTextRequest}
     * @return the request
     */
    public RomanizeText romanizeText(java.lang.String parent, com.google.api.services.translate.v3.model.RomanizeTextRequest content) throws java.io.IOException {
      RomanizeText result = new RomanizeText(parent, content);
      initialize(result);
      return result;
    }

    public class RomanizeText extends TranslateRequest<com.google.api.services.translate.v3.model.RomanizeTextResponse> {

      private static final String REST_PATH = "v3/{+parent}:romanizeText";

      private final java.util.regex.Pattern PARENT_PATTERN =
          java.util.regex.Pattern.compile("^projects/[^/]+$");

      /**
       * Romanize input text written in non-Latin scripts to Latin text.
       *
       * Create a request for the method "projects.romanizeText".
       *
       * This request holds the parameters needed by the the translate server.  After setting any
       * optional parameters, call the {@link RomanizeText#execute()} method to invoke the remote
       * operation. <p> {@link
       * RomanizeText#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param parent Required. Project or location to make a call. Must refer to a caller's project. Format: `projects
     *        /{project-number-or-id}/locations/{location-id}` or `projects/{project-number-or-id}`. For
     *        global calls, use `projects/{project-number-or-id}/locations/global` or `projects
     *        /{project-number-or-id}`.
       * @param content the {@link com.google.api.services.translate.v3.model.RomanizeTextRequest}
       * @since 1.13
       */
      protected RomanizeText(java.lang.String parent, com.google.api.services.translate.v3.model.RomanizeTextRequest content) {
        super(Translate.this, "POST", REST_PATH, content, com.google.api.services.translate.v3.model.RomanizeTextResponse.class);
        this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
              "Parameter parent must conform to the pattern " +
              "^projects/[^/]+$");
        }
      }

      @Override
      public RomanizeText set$Xgafv(java.lang.String $Xgafv) {
        return (RomanizeText) super.set$Xgafv($Xgafv);
      }

      @Override
      public RomanizeText setAccessToken(java.lang.String accessToken) {
        return (RomanizeText) super.setAccessToken(accessToken);
      }

      @Override
      public RomanizeText setAlt(java.lang.String alt) {
        return (RomanizeText) super.setAlt(alt);
      }

      @Override
      public RomanizeText setCallback(java.lang.String callback) {
        return (RomanizeText) super.setCallback(callback);
      }

      @Override
      public RomanizeText setFields(java.lang.String fields) {
        return (RomanizeText) super.setFields(fields);
      }

      @Override
      public RomanizeText setKey(java.lang.String key) {
        return (RomanizeText) super.setKey(key);
      }

      @Override
      public RomanizeText setOauthToken(java.lang.String oauthToken) {
        return (RomanizeText) super.setOauthToken(oauthToken);
      }

      @Override
      public RomanizeText setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (RomanizeText) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public RomanizeText setQuotaUser(java.lang.String quotaUser) {
        return (RomanizeText) super.setQuotaUser(quotaUser);
      }

      @Override
      public RomanizeText setUploadType(java.lang.String uploadType) {
        return (RomanizeText) super.setUploadType(uploadType);
      }

      @Override
      public RomanizeText setUploadProtocol(java.lang.String uploadProtocol) {
        return (RomanizeText) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * Required. Project or location to make a call. Must refer to a caller's project. Format:
       * `projects/{project-number-or-id}/locations/{location-id}` or `projects/{project-number-or-
       * id}`. For global calls, use `projects/{project-number-or-id}/locations/global` or `projects
       * /{project-number-or-id}`.
       */
      @com.google.api.client.util.Key
      private java.lang.String parent;

      /** Required. Project or location to make a call. Must refer to a caller's project. Format: `projects
     /{project-number-or-id}/locations/{location-id}` or `projects/{project-number-or-id}`. For global
     calls, use `projects/{project-number-or-id}/locations/global` or `projects/{project-number-or-id}`.
       */
      public java.lang.String getParent() {
        return parent;
      }

      /**
       * Required. Project or location to make a call. Must refer to a caller's project. Format:
       * `projects/{project-number-or-id}/locations/{location-id}` or `projects/{project-number-or-
       * id}`. For global calls, use `projects/{project-number-or-id}/locations/global` or `projects
       * /{project-number-or-id}`.
       */
      public RomanizeText setParent(java.lang.String parent) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
              "Parameter parent must conform to the pattern " +
              "^projects/[^/]+$");
        }
        this.parent = parent;
        return this;
      }

      @Override
      public RomanizeText set(String parameterName, Object value) {
        return (RomanizeText) super.set(parameterName, value);
      }
    }
    /**
     * Translates input text and returns translated text.
     *
     * Create a request for the method "projects.translateText".
     *
     * This request holds the parameters needed by the translate server.  After setting any optional
     * parameters, call the {@link TranslateText#execute()} method to invoke the remote operation.
     *
     * @param parent Required. Project or location to make a call. Must refer to a caller's project. Format: `projects
     *        /{project-number-or-id}` or `projects/{project-number-or-id}/locations/{location-id}`. For
     *        global calls, use `projects/{project-number-or-id}/locations/global` or `projects
     *        /{project-number-or-id}`. Non-global location is required for requests using AutoML models
     *        or custom glossaries. Models and glossaries must be within the same region (have same
     *        location-id), otherwise an INVALID_ARGUMENT (400) error is returned.
     * @param content the {@link com.google.api.services.translate.v3.model.TranslateTextRequest}
     * @return the request
     */
    public TranslateText translateText(java.lang.String parent, com.google.api.services.translate.v3.model.TranslateTextRequest content) throws java.io.IOException {
      TranslateText result = new TranslateText(parent, content);
      initialize(result);
      return result;
    }

    public class TranslateText extends TranslateRequest<com.google.api.services.translate.v3.model.TranslateTextResponse> {

      private static final String REST_PATH = "v3/{+parent}:translateText";

      private final java.util.regex.Pattern PARENT_PATTERN =
          java.util.regex.Pattern.compile("^projects/[^/]+$");

      /**
       * Translates input text and returns translated text.
       *
       * Create a request for the method "projects.translateText".
       *
       * This request holds the parameters needed by the the translate server.  After setting any
       * optional parameters, call the {@link TranslateText#execute()} method to invoke the remote
       * operation. <p> {@link TranslateText#initialize(com.google.api.client.googleapis.services.Abstra
       * ctGoogleClientRequest)} must be called to initialize this instance immediately after invoking
       * the constructor. </p>
       *
       * @param parent Required. Project or location to make a call. Must refer to a caller's project. Format: `projects
     *        /{project-number-or-id}` or `projects/{project-number-or-id}/locations/{location-id}`. For
     *        global calls, use `projects/{project-number-or-id}/locations/global` or `projects
     *        /{project-number-or-id}`. Non-global location is required for requests using AutoML models
     *        or custom glossaries. Models and glossaries must be within the same region (have same
     *        location-id), otherwise an INVALID_ARGUMENT (400) error is returned.
       * @param content the {@link com.google.api.services.translate.v3.model.TranslateTextRequest}
       * @since 1.13
       */
      protected TranslateText(java.lang.String parent, com.google.api.services.translate.v3.model.TranslateTextRequest content) {
        super(Translate.this, "POST", REST_PATH, content, com.google.api.services.translate.v3.model.TranslateTextResponse.class);
        this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
              "Parameter parent must conform to the pattern " +
              "^projects/[^/]+$");
        }
      }

      @Override
      public TranslateText set$Xgafv(java.lang.String $Xgafv) {
        return (TranslateText) super.set$Xgafv($Xgafv);
      }

      @Override
      public TranslateText setAccessToken(java.lang.String accessToken) {
        return (TranslateText) super.setAccessToken(accessToken);
      }

      @Override
      public TranslateText setAlt(java.lang.String alt) {
        return (TranslateText) super.setAlt(alt);
      }

      @Override
      public TranslateText setCallback(java.lang.String callback) {
        return (TranslateText) super.setCallback(callback);
      }

      @Override
      public TranslateText setFields(java.lang.String fields) {
        return (TranslateText) super.setFields(fields);
      }

      @Override
      public TranslateText setKey(java.lang.String key) {
        return (TranslateText) super.setKey(key);
      }

      @Override
      public TranslateText setOauthToken(java.lang.String oauthToken) {
        return (TranslateText) super.setOauthToken(oauthToken);
      }

      @Override
      public TranslateText setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (TranslateText) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public TranslateText setQuotaUser(java.lang.String quotaUser) {
        return (TranslateText) super.setQuotaUser(quotaUser);
      }

      @Override
      public TranslateText setUploadType(java.lang.String uploadType) {
        return (TranslateText) super.setUploadType(uploadType);
      }

      @Override
      public TranslateText setUploadProtocol(java.lang.String uploadProtocol) {
        return (TranslateText) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * Required. Project or location to make a call. Must refer to a caller's project. Format:
       * `projects/{project-number-or-id}` or `projects/{project-number-or-id}/locations/{location-
       * id}`. For global calls, use `projects/{project-number-or-id}/locations/global` or `projects
       * /{project-number-or-id}`. Non-global location is required for requests using AutoML models
       * or custom glossaries. Models and glossaries must be within the same region (have same
       * location-id), otherwise an INVALID_ARGUMENT (400) error is returned.
       */
      @com.google.api.client.util.Key
      private java.lang.String parent;

      /** Required. Project or location to make a call. Must refer to a caller's project. Format: `projects
     /{project-number-or-id}` or `projects/{project-number-or-id}/locations/{location-id}`. For global
     calls, use `projects/{project-number-or-id}/locations/global` or `projects/{project-number-or-id}`.
     Non-global location is required for requests using AutoML models or custom glossaries. Models and
     glossaries must be within the same region (have same location-id), otherwise an INVALID_ARGUMENT
     (400) error is returned.
       */
      public java.lang.String getParent() {
        return parent;
      }

      /**
       * Required. Project or location to make a call. Must refer to a caller's project. Format:
       * `projects/{project-number-or-id}` or `projects/{project-number-or-id}/locations/{location-
       * id}`. For global calls, use `projects/{project-number-or-id}/locations/global` or `projects
       * /{project-number-or-id}`. Non-global location is required for requests using AutoML models
       * or custom glossaries. Models and glossaries must be within the same region (have same
       * location-id), otherwise an INVALID_ARGUMENT (400) error is returned.
       */
      public TranslateText setParent(java.lang.String parent) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
              "Parameter parent must conform to the pattern " +
              "^projects/[^/]+$");
        }
        this.parent = parent;
        return this;
      }

      @Override
      public TranslateText set(String parameterName, Object value) {
        return (TranslateText) super.set(parameterName, value);
      }
    }

    /**
     * An accessor for creating requests from the Locations collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Translate translate = new Translate(...);}
     *   {@code Translate.Locations.List request = translate.locations().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Locations locations() {
      return new Locations();
    }

    /**
     * The "locations" collection of methods.
     */
    public class Locations {

      /**
       * Translate text using Adaptive MT.
       *
       * Create a request for the method "locations.adaptiveMtTranslate".
       *
       * This request holds the parameters needed by the translate server.  After setting any optional
       * parameters, call the {@link AdaptiveMtTranslate#execute()} method to invoke the remote operation.
       *
       * @param parent Required. Location to make a regional call. Format: `projects/{project-number-or-id}/locations
       *        /{location-id}`.
       * @param content the {@link com.google.api.services.translate.v3.model.AdaptiveMtTranslateRequest}
       * @return the request
       */
      public AdaptiveMtTranslate adaptiveMtTranslate(java.lang.String parent, com.google.api.services.translate.v3.model.AdaptiveMtTranslateRequest content) throws java.io.IOException {
        AdaptiveMtTranslate result = new AdaptiveMtTranslate(parent, content);
        initialize(result);
        return result;
      }

      public class AdaptiveMtTranslate extends TranslateRequest<com.google.api.services.translate.v3.model.AdaptiveMtTranslateResponse> {

        private static final String REST_PATH = "v3/{+parent}:adaptiveMtTranslate";

        private final java.util.regex.Pattern PARENT_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+$");

        /**
         * Translate text using Adaptive MT.
         *
         * Create a request for the method "locations.adaptiveMtTranslate".
         *
         * This request holds the parameters needed by the the translate server.  After setting any
         * optional parameters, call the {@link AdaptiveMtTranslate#execute()} method to invoke the remote
         * operation. <p> {@link AdaptiveMtTranslate#initialize(com.google.api.client.googleapis.services.
         * AbstractGoogleClientRequest)} must be called to initialize this instance immediately after
         * invoking the constructor. </p>
         *
         * @param parent Required. Location to make a regional call. Format: `projects/{project-number-or-id}/locations
       *        /{location-id}`.
         * @param content the {@link com.google.api.services.translate.v3.model.AdaptiveMtTranslateRequest}
         * @since 1.13
         */
        protected AdaptiveMtTranslate(java.lang.String parent, com.google.api.services.translate.v3.model.AdaptiveMtTranslateRequest content) {
          super(Translate.this, "POST", REST_PATH, content, com.google.api.services.translate.v3.model.AdaptiveMtTranslateResponse.class);
          this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^projects/[^/]+/locations/[^/]+$");
          }
        }

        @Override
        public AdaptiveMtTranslate set$Xgafv(java.lang.String $Xgafv) {
          return (AdaptiveMtTranslate) super.set$Xgafv($Xgafv);
        }

        @Override
        public AdaptiveMtTranslate setAccessToken(java.lang.String accessToken) {
          return (AdaptiveMtTranslate) super.setAccessToken(accessToken);
        }

        @Override
        public AdaptiveMtTranslate setAlt(java.lang.String alt) {
          return (AdaptiveMtTranslate) super.setAlt(alt);
        }

        @Override
        public AdaptiveMtTranslate setCallback(java.lang.String callback) {
          return (AdaptiveMtTranslate) super.setCallback(callback);
        }

        @Override
        public AdaptiveMtTranslate setFields(java.lang.String fields) {
          return (AdaptiveMtTranslate) super.setFields(fields);
        }

        @Override
        public AdaptiveMtTranslate setKey(java.lang.String key) {
          return (AdaptiveMtTranslate) super.setKey(key);
        }

        @Override
        public AdaptiveMtTranslate setOauthToken(java.lang.String oauthToken) {
          return (AdaptiveMtTranslate) super.setOauthToken(oauthToken);
        }

        @Override
        public AdaptiveMtTranslate setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (AdaptiveMtTranslate) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public AdaptiveMtTranslate setQuotaUser(java.lang.String quotaUser) {
          return (AdaptiveMtTranslate) super.setQuotaUser(quotaUser);
        }

        @Override
        public AdaptiveMtTranslate setUploadType(java.lang.String uploadType) {
          return (AdaptiveMtTranslate) super.setUploadType(uploadType);
        }

        @Override
        public AdaptiveMtTranslate setUploadProtocol(java.lang.String uploadProtocol) {
          return (AdaptiveMtTranslate) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. Location to make a regional call. Format: `projects/{project-number-or-
         * id}/locations/{location-id}`.
         */
        @com.google.api.client.util.Key
        private java.lang.String parent;

        /** Required. Location to make a regional call. Format: `projects/{project-number-or-id}/locations
       /{location-id}`.
         */
        public java.lang.String getParent() {
          return parent;
        }

        /**
         * Required. Location to make a regional call. Format: `projects/{project-number-or-
         * id}/locations/{location-id}`.
         */
        public AdaptiveMtTranslate setParent(java.lang.String parent) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^projects/[^/]+/locations/[^/]+$");
          }
          this.parent = parent;
          return this;
        }

        @Override
        public AdaptiveMtTranslate set(String parameterName, Object value) {
          return (AdaptiveMtTranslate) super.set(parameterName, value);
        }
      }
      /**
       * Translates a large volume of document in asynchronous batch mode. This function provides real-
       * time output as the inputs are being processed. If caller cancels a request, the partial results
       * (for an input file, it's all or nothing) may still be available on the specified output location.
       * This call returns immediately and you can use google.longrunning.Operation.name to poll the
       * status of the call.
       *
       * Create a request for the method "locations.batchTranslateDocument".
       *
       * This request holds the parameters needed by the translate server.  After setting any optional
       * parameters, call the {@link BatchTranslateDocument#execute()} method to invoke the remote
       * operation.
       *
       * @param parent Required. Location to make a regional call. Format: `projects/{project-number-or-id}/locations
       *        /{location-id}`. The `global` location is not supported for batch translation. Only AutoML
       *        Translation models or glossaries within the same region (have the same location-id) can be
       *        used, otherwise an INVALID_ARGUMENT (400) error is returned.
       * @param content the {@link com.google.api.services.translate.v3.model.BatchTranslateDocumentRequest}
       * @return the request
       */
      public BatchTranslateDocument batchTranslateDocument(java.lang.String parent, com.google.api.services.translate.v3.model.BatchTranslateDocumentRequest content) throws java.io.IOException {
        BatchTranslateDocument result = new BatchTranslateDocument(parent, content);
        initialize(result);
        return result;
      }

      public class BatchTranslateDocument extends TranslateRequest<com.google.api.services.translate.v3.model.Operation> {

        private static final String REST_PATH = "v3/{+parent}:batchTranslateDocument";

        private final java.util.regex.Pattern PARENT_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+$");

        /**
         * Translates a large volume of document in asynchronous batch mode. This function provides real-
         * time output as the inputs are being processed. If caller cancels a request, the partial results
         * (for an input file, it's all or nothing) may still be available on the specified output
         * location. This call returns immediately and you can use google.longrunning.Operation.name to
         * poll the status of the call.
         *
         * Create a request for the method "locations.batchTranslateDocument".
         *
         * This request holds the parameters needed by the the translate server.  After setting any
         * optional parameters, call the {@link BatchTranslateDocument#execute()} method to invoke the
         * remote operation. <p> {@link BatchTranslateDocument#initialize(com.google.api.client.googleapis
         * .services.AbstractGoogleClientRequest)} must be called to initialize this instance immediately
         * after invoking the constructor. </p>
         *
         * @param parent Required. Location to make a regional call. Format: `projects/{project-number-or-id}/locations
       *        /{location-id}`. The `global` location is not supported for batch translation. Only AutoML
       *        Translation models or glossaries within the same region (have the same location-id) can be
       *        used, otherwise an INVALID_ARGUMENT (400) error is returned.
         * @param content the {@link com.google.api.services.translate.v3.model.BatchTranslateDocumentRequest}
         * @since 1.13
         */
        protected BatchTranslateDocument(java.lang.String parent, com.google.api.services.translate.v3.model.BatchTranslateDocumentRequest content) {
          super(Translate.this, "POST", REST_PATH, content, com.google.api.services.translate.v3.model.Operation.class);
          this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^projects/[^/]+/locations/[^/]+$");
          }
        }

        @Override
        public BatchTranslateDocument set$Xgafv(java.lang.String $Xgafv) {
          return (BatchTranslateDocument) super.set$Xgafv($Xgafv);
        }

        @Override
        public BatchTranslateDocument setAccessToken(java.lang.String accessToken) {
          return (BatchTranslateDocument) super.setAccessToken(accessToken);
        }

        @Override
        public BatchTranslateDocument setAlt(java.lang.String alt) {
          return (BatchTranslateDocument) super.setAlt(alt);
        }

        @Override
        public BatchTranslateDocument setCallback(java.lang.String callback) {
          return (BatchTranslateDocument) super.setCallback(callback);
        }

        @Override
        public BatchTranslateDocument setFields(java.lang.String fields) {
          return (BatchTranslateDocument) super.setFields(fields);
        }

        @Override
        public BatchTranslateDocument setKey(java.lang.String key) {
          return (BatchTranslateDocument) super.setKey(key);
        }

        @Override
        public BatchTranslateDocument setOauthToken(java.lang.String oauthToken) {
          return (BatchTranslateDocument) super.setOauthToken(oauthToken);
        }

        @Override
        public BatchTranslateDocument setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (BatchTranslateDocument) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public BatchTranslateDocument setQuotaUser(java.lang.String quotaUser) {
          return (BatchTranslateDocument) super.setQuotaUser(quotaUser);
        }

        @Override
        public BatchTranslateDocument setUploadType(java.lang.String uploadType) {
          return (BatchTranslateDocument) super.setUploadType(uploadType);
        }

        @Override
        public BatchTranslateDocument setUploadProtocol(java.lang.String uploadProtocol) {
          return (BatchTranslateDocument) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. Location to make a regional call. Format: `projects/{project-number-or-
         * id}/locations/{location-id}`. The `global` location is not supported for batch
         * translation. Only AutoML Translation models or glossaries within the same region (have
         * the same location-id) can be used, otherwise an INVALID_ARGUMENT (400) error is returned.
         */
        @com.google.api.client.util.Key
        private java.lang.String parent;

        /** Required. Location to make a regional call. Format: `projects/{project-number-or-id}/locations
       /{location-id}`. The `global` location is not supported for batch translation. Only AutoML
       Translation models or glossaries within the same region (have the same location-id) can be used,
       otherwise an INVALID_ARGUMENT (400) error is returned.
         */
        public java.lang.String getParent() {
          return parent;
        }

        /**
         * Required. Location to make a regional call. Format: `projects/{project-number-or-
         * id}/locations/{location-id}`. The `global` location is not supported for batch
         * translation. Only AutoML Translation models or glossaries within the same region (have
         * the same location-id) can be used, otherwise an INVALID_ARGUMENT (400) error is returned.
         */
        public BatchTranslateDocument setParent(java.lang.String parent) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^projects/[^/]+/locations/[^/]+$");
          }
          this.parent = parent;
          return this;
        }

        @Override
        public BatchTranslateDocument set(String parameterName, Object value) {
          return (BatchTranslateDocument) super.set(parameterName, value);
        }
      }
      /**
       * Translates a large volume of text in asynchronous batch mode. This function provides real-time
       * output as the inputs are being processed. If caller cancels a request, the partial results (for
       * an input file, it's all or nothing) may still be available on the specified output location. This
       * call returns immediately and you can use google.longrunning.Operation.name to poll the status of
       * the call.
       *
       * Create a request for the method "locations.batchTranslateText".
       *
       * This request holds the parameters needed by the translate server.  After setting any optional
       * parameters, call the {@link BatchTranslateText#execute()} method to invoke the remote operation.
       *
       * @param parent Required. Location to make a call. Must refer to a caller's project. Format: `projects/{project-
       *        number-or-id}/locations/{location-id}`. The `global` location is not supported for batch
       *        translation. Only AutoML Translation models or glossaries within the same region (have the
       *        same location-id) can be used, otherwise an INVALID_ARGUMENT (400) error is returned.
       * @param content the {@link com.google.api.services.translate.v3.model.BatchTranslateTextRequest}
       * @return the request
       */
      public BatchTranslateText batchTranslateText(java.lang.String parent, com.google.api.services.translate.v3.model.BatchTranslateTextRequest content) throws java.io.IOException {
        BatchTranslateText result = new BatchTranslateText(parent, content);
        initialize(result);
        return result;
      }

      public class BatchTranslateText extends TranslateRequest<com.google.api.services.translate.v3.model.Operation> {

        private static final String REST_PATH = "v3/{+parent}:batchTranslateText";

        private final java.util.regex.Pattern PARENT_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+$");

        /**
         * Translates a large volume of text in asynchronous batch mode. This function provides real-time
         * output as the inputs are being processed. If caller cancels a request, the partial results (for
         * an input file, it's all or nothing) may still be available on the specified output location.
         * This call returns immediately and you can use google.longrunning.Operation.name to poll the
         * status of the call.
         *
         * Create a request for the method "locations.batchTranslateText".
         *
         * This request holds the parameters needed by the the translate server.  After setting any
         * optional parameters, call the {@link BatchTranslateText#execute()} method to invoke the remote
         * operation. <p> {@link BatchTranslateText#initialize(com.google.api.client.googleapis.services.A
         * bstractGoogleClientRequest)} must be called to initialize this instance immediately after
         * invoking the constructor. </p>
         *
         * @param parent Required. Location to make a call. Must refer to a caller's project. Format: `projects/{project-
       *        number-or-id}/locations/{location-id}`. The `global` location is not supported for batch
       *        translation. Only AutoML Translation models or glossaries within the same region (have the
       *        same location-id) can be used, otherwise an INVALID_ARGUMENT (400) error is returned.
         * @param content the {@link com.google.api.services.translate.v3.model.BatchTranslateTextRequest}
         * @since 1.13
         */
        protected BatchTranslateText(java.lang.String parent, com.google.api.services.translate.v3.model.BatchTranslateTextRequest content) {
          super(Translate.this, "POST", REST_PATH, content, com.google.api.services.translate.v3.model.Operation.class);
          this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^projects/[^/]+/locations/[^/]+$");
          }
        }

        @Override
        public BatchTranslateText set$Xgafv(java.lang.String $Xgafv) {
          return (BatchTranslateText) super.set$Xgafv($Xgafv);
        }

        @Override
        public BatchTranslateText setAccessToken(java.lang.String accessToken) {
          return (BatchTranslateText) super.setAccessToken(accessToken);
        }

        @Override
        public BatchTranslateText setAlt(java.lang.String alt) {
          return (BatchTranslateText) super.setAlt(alt);
        }

        @Override
        public BatchTranslateText setCallback(java.lang.String callback) {
          return (BatchTranslateText) super.setCallback(callback);
        }

        @Override
        public BatchTranslateText setFields(java.lang.String fields) {
          return (BatchTranslateText) super.setFields(fields);
        }

        @Override
        public BatchTranslateText setKey(java.lang.String key) {
          return (BatchTranslateText) super.setKey(key);
        }

        @Override
        public BatchTranslateText setOauthToken(java.lang.String oauthToken) {
          return (BatchTranslateText) super.setOauthToken(oauthToken);
        }

        @Override
        public BatchTranslateText setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (BatchTranslateText) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public BatchTranslateText setQuotaUser(java.lang.String quotaUser) {
          return (BatchTranslateText) super.setQuotaUser(quotaUser);
        }

        @Override
        public BatchTranslateText setUploadType(java.lang.String uploadType) {
          return (BatchTranslateText) super.setUploadType(uploadType);
        }

        @Override
        public BatchTranslateText setUploadProtocol(java.lang.String uploadProtocol) {
          return (BatchTranslateText) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. Location to make a call. Must refer to a caller's project. Format: `projects
         * /{project-number-or-id}/locations/{location-id}`. The `global` location is not supported
         * for batch translation. Only AutoML Translation models or glossaries within the same
         * region (have the same location-id) can be used, otherwise an INVALID_ARGUMENT (400) error
         * is returned.
         */
        @com.google.api.client.util.Key
        private java.lang.String parent;

        /** Required. Location to make a call. Must refer to a caller's project. Format: `projects/{project-
       number-or-id}/locations/{location-id}`. The `global` location is not supported for batch
       translation. Only AutoML Translation models or glossaries within the same region (have the same
       location-id) can be used, otherwise an INVALID_ARGUMENT (400) error is returned.
         */
        public java.lang.String getParent() {
          return parent;
        }

        /**
         * Required. Location to make a call. Must refer to a caller's project. Format: `projects
         * /{project-number-or-id}/locations/{location-id}`. The `global` location is not supported
         * for batch translation. Only AutoML Translation models or glossaries within the same
         * region (have the same location-id) can be used, otherwise an INVALID_ARGUMENT (400) error
         * is returned.
         */
        public BatchTranslateText setParent(java.lang.String parent) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^projects/[^/]+/locations/[^/]+$");
          }
          this.parent = parent;
          return this;
        }

        @Override
        public BatchTranslateText set(String parameterName, Object value) {
          return (BatchTranslateText) super.set(parameterName, value);
        }
      }
      /**
       * Detects the language of text within a request.
       *
       * Create a request for the method "locations.detectLanguage".
       *
       * This request holds the parameters needed by the translate server.  After setting any optional
       * parameters, call the {@link DetectLanguage#execute()} method to invoke the remote operation.
       *
       * @param parent Required. Project or location to make a call. Must refer to a caller's project. Format: `projects
       *        /{project-number-or-id}/locations/{location-id}` or `projects/{project-number-or-id}`. For
       *        global calls, use `projects/{project-number-or-id}/locations/global` or `projects
       *        /{project-number-or-id}`. Only models within the same region (has same location-id) can be
       *        used. Otherwise an INVALID_ARGUMENT (400) error is returned.
       * @param content the {@link com.google.api.services.translate.v3.model.DetectLanguageRequest}
       * @return the request
       */
      public DetectLanguage detectLanguage(java.lang.String parent, com.google.api.services.translate.v3.model.DetectLanguageRequest content) throws java.io.IOException {
        DetectLanguage result = new DetectLanguage(parent, content);
        initialize(result);
        return result;
      }

      public class DetectLanguage extends TranslateRequest<com.google.api.services.translate.v3.model.DetectLanguageResponse> {

        private static final String REST_PATH = "v3/{+parent}:detectLanguage";

        private final java.util.regex.Pattern PARENT_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+$");

        /**
         * Detects the language of text within a request.
         *
         * Create a request for the method "locations.detectLanguage".
         *
         * This request holds the parameters needed by the the translate server.  After setting any
         * optional parameters, call the {@link DetectLanguage#execute()} method to invoke the remote
         * operation. <p> {@link DetectLanguage#initialize(com.google.api.client.googleapis.services.Abstr
         * actGoogleClientRequest)} must be called to initialize this instance immediately after invoking
         * the constructor. </p>
         *
         * @param parent Required. Project or location to make a call. Must refer to a caller's project. Format: `projects
       *        /{project-number-or-id}/locations/{location-id}` or `projects/{project-number-or-id}`. For
       *        global calls, use `projects/{project-number-or-id}/locations/global` or `projects
       *        /{project-number-or-id}`. Only models within the same region (has same location-id) can be
       *        used. Otherwise an INVALID_ARGUMENT (400) error is returned.
         * @param content the {@link com.google.api.services.translate.v3.model.DetectLanguageRequest}
         * @since 1.13
         */
        protected DetectLanguage(java.lang.String parent, com.google.api.services.translate.v3.model.DetectLanguageRequest content) {
          super(Translate.this, "POST", REST_PATH, content, com.google.api.services.translate.v3.model.DetectLanguageResponse.class);
          this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^projects/[^/]+/locations/[^/]+$");
          }
        }

        @Override
        public DetectLanguage set$Xgafv(java.lang.String $Xgafv) {
          return (DetectLanguage) super.set$Xgafv($Xgafv);
        }

        @Override
        public DetectLanguage setAccessToken(java.lang.String accessToken) {
          return (DetectLanguage) super.setAccessToken(accessToken);
        }

        @Override
        public DetectLanguage setAlt(java.lang.String alt) {
          return (DetectLanguage) super.setAlt(alt);
        }

        @Override
        public DetectLanguage setCallback(java.lang.String callback) {
          return (DetectLanguage) super.setCallback(callback);
        }

        @Override
        public DetectLanguage setFields(java.lang.String fields) {
          return (DetectLanguage) super.setFields(fields);
        }

        @Override
        public DetectLanguage setKey(java.lang.String key) {
          return (DetectLanguage) super.setKey(key);
        }

        @Override
        public DetectLanguage setOauthToken(java.lang.String oauthToken) {
          return (DetectLanguage) super.setOauthToken(oauthToken);
        }

        @Override
        public DetectLanguage setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (DetectLanguage) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public DetectLanguage setQuotaUser(java.lang.String quotaUser) {
          return (DetectLanguage) super.setQuotaUser(quotaUser);
        }

        @Override
        public DetectLanguage setUploadType(java.lang.String uploadType) {
          return (DetectLanguage) super.setUploadType(uploadType);
        }

        @Override
        public DetectLanguage setUploadProtocol(java.lang.String uploadProtocol) {
          return (DetectLanguage) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. Project or location to make a call. Must refer to a caller's project. Format:
         * `projects/{project-number-or-id}/locations/{location-id}` or `projects/{project-number-
         * or-id}`. For global calls, use `projects/{project-number-or-id}/locations/global` or
         * `projects/{project-number-or-id}`. Only models within the same region (has same location-
         * id) can be used. Otherwise an INVALID_ARGUMENT (400) error is returned.
         */
        @com.google.api.client.util.Key
        private java.lang.String parent;

        /** Required. Project or location to make a call. Must refer to a caller's project. Format: `projects
       /{project-number-or-id}/locations/{location-id}` or `projects/{project-number-or-id}`. For global
       calls, use `projects/{project-number-or-id}/locations/global` or `projects/{project-number-or-id}`.
       Only models within the same region (has same location-id) can be used. Otherwise an
       INVALID_ARGUMENT (400) error is returned.
         */
        public java.lang.String getParent() {
          return parent;
        }

        /**
         * Required. Project or location to make a call. Must refer to a caller's project. Format:
         * `projects/{project-number-or-id}/locations/{location-id}` or `projects/{project-number-
         * or-id}`. For global calls, use `projects/{project-number-or-id}/locations/global` or
         * `projects/{project-number-or-id}`. Only models within the same region (has same location-
         * id) can be used. Otherwise an INVALID_ARGUMENT (400) error is returned.
         */
        public DetectLanguage setParent(java.lang.String parent) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^projects/[^/]+/locations/[^/]+$");
          }
          this.parent = parent;
          return this;
        }

        @Override
        public DetectLanguage set(String parameterName, Object value) {
          return (DetectLanguage) super.set(parameterName, value);
        }
      }
      /**
       * Gets information about a location.
       *
       * Create a request for the method "locations.get".
       *
       * This request holds the parameters needed by the translate server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param name Resource name for the location.
       * @return the request
       */
      public Get get(java.lang.String name) throws java.io.IOException {
        Get result = new Get(name);
        initialize(result);
        return result;
      }

      public class Get extends TranslateRequest<com.google.api.services.translate.v3.model.Location> {

        private static final String REST_PATH = "v3/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+$");

        /**
         * Gets information about a location.
         *
         * Create a request for the method "locations.get".
         *
         * This request holds the parameters needed by the the translate server.  After setting any
         * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
         * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Resource name for the location.
         * @since 1.13
         */
        protected Get(java.lang.String name) {
          super(Translate.this, "GET", REST_PATH, null, com.google.api.services.translate.v3.model.Location.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/locations/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get set$Xgafv(java.lang.String $Xgafv) {
          return (Get) super.set$Xgafv($Xgafv);
        }

        @Override
        public Get setAccessToken(java.lang.String accessToken) {
          return (Get) super.setAccessToken(accessToken);
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setCallback(java.lang.String callback) {
          return (Get) super.setCallback(callback);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUploadType(java.lang.String uploadType) {
          return (Get) super.setUploadType(uploadType);
        }

        @Override
        public Get setUploadProtocol(java.lang.String uploadProtocol) {
          return (Get) super.setUploadProtocol(uploadProtocol);
        }

        /** Resource name for the location. */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Resource name for the location.
         */
        public java.lang.String getName() {
          return name;
        }

        /** Resource name for the location. */
        public Get setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/locations/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Returns a list of supported languages for translation.
       *
       * Create a request for the method "locations.getSupportedLanguages".
       *
       * This request holds the parameters needed by the translate server.  After setting any optional
       * parameters, call the {@link GetSupportedLanguages#execute()} method to invoke the remote
       * operation.
       *
       * @param parent Required. Project or location to make a call. Must refer to a caller's project. Format: `projects
       *        /{project-number-or-id}` or `projects/{project-number-or-id}/locations/{location-id}`. For
       *        global calls, use `projects/{project-number-or-id}/locations/global` or `projects
       *        /{project-number-or-id}`. Non-global location is required for AutoML models. Only models
       *        within the same region (have same location-id) can be used, otherwise an INVALID_ARGUMENT
       *        (400) error is returned.
       * @return the request
       */
      public GetSupportedLanguages getSupportedLanguages(java.lang.String parent) throws java.io.IOException {
        GetSupportedLanguages result = new GetSupportedLanguages(parent);
        initialize(result);
        return result;
      }

      public class GetSupportedLanguages extends TranslateRequest<com.google.api.services.translate.v3.model.SupportedLanguages> {

        private static final String REST_PATH = "v3/{+parent}/supportedLanguages";

        private final java.util.regex.Pattern PARENT_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+$");

        /**
         * Returns a list of supported languages for translation.
         *
         * Create a request for the method "locations.getSupportedLanguages".
         *
         * This request holds the parameters needed by the the translate server.  After setting any
         * optional parameters, call the {@link GetSupportedLanguages#execute()} method to invoke the
         * remote operation. <p> {@link GetSupportedLanguages#initialize(com.google.api.client.googleapis.
         * services.AbstractGoogleClientRequest)} must be called to initialize this instance immediately
         * after invoking the constructor. </p>
         *
         * @param parent Required. Project or location to make a call. Must refer to a caller's project. Format: `projects
       *        /{project-number-or-id}` or `projects/{project-number-or-id}/locations/{location-id}`. For
       *        global calls, use `projects/{project-number-or-id}/locations/global` or `projects
       *        /{project-number-or-id}`. Non-global location is required for AutoML models. Only models
       *        within the same region (have same location-id) can be used, otherwise an INVALID_ARGUMENT
       *        (400) error is returned.
         * @since 1.13
         */
        protected GetSupportedLanguages(java.lang.String parent) {
          super(Translate.this, "GET", REST_PATH, null, com.google.api.services.translate.v3.model.SupportedLanguages.class);
          this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^projects/[^/]+/locations/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public GetSupportedLanguages set$Xgafv(java.lang.String $Xgafv) {
          return (GetSupportedLanguages) super.set$Xgafv($Xgafv);
        }

        @Override
        public GetSupportedLanguages setAccessToken(java.lang.String accessToken) {
          return (GetSupportedLanguages) super.setAccessToken(accessToken);
        }

        @Override
        public GetSupportedLanguages setAlt(java.lang.String alt) {
          return (GetSupportedLanguages) super.setAlt(alt);
        }

        @Override
        public GetSupportedLanguages setCallback(java.lang.String callback) {
          return (GetSupportedLanguages) super.setCallback(callback);
        }

        @Override
        public GetSupportedLanguages setFields(java.lang.String fields) {
          return (GetSupportedLanguages) super.setFields(fields);
        }

        @Override
        public GetSupportedLanguages setKey(java.lang.String key) {
          return (GetSupportedLanguages) super.setKey(key);
        }

        @Override
        public GetSupportedLanguages setOauthToken(java.lang.String oauthToken) {
          return (GetSupportedLanguages) super.setOauthToken(oauthToken);
        }

        @Override
        public GetSupportedLanguages setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (GetSupportedLanguages) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public GetSupportedLanguages setQuotaUser(java.lang.String quotaUser) {
          return (GetSupportedLanguages) super.setQuotaUser(quotaUser);
        }

        @Override
        public GetSupportedLanguages setUploadType(java.lang.String uploadType) {
          return (GetSupportedLanguages) super.setUploadType(uploadType);
        }

        @Override
        public GetSupportedLanguages setUploadProtocol(java.lang.String uploadProtocol) {
          return (GetSupportedLanguages) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. Project or location to make a call. Must refer to a caller's project. Format:
         * `projects/{project-number-or-id}` or `projects/{project-number-or-id}/locations
         * /{location-id}`. For global calls, use `projects/{project-number-or-id}/locations/global`
         * or `projects/{project-number-or-id}`. Non-global location is required for AutoML models.
         * Only models within the same region (have same location-id) can be used, otherwise an
         * INVALID_ARGUMENT (400) error is returned.
         */
        @com.google.api.client.util.Key
        private java.lang.String parent;

        /** Required. Project or location to make a call. Must refer to a caller's project. Format: `projects
       /{project-number-or-id}` or `projects/{project-number-or-id}/locations/{location-id}`. For global
       calls, use `projects/{project-number-or-id}/locations/global` or `projects/{project-number-or-id}`.
       Non-global location is required for AutoML models. Only models within the same region (have same
       location-id) can be used, otherwise an INVALID_ARGUMENT (400) error is returned.
         */
        public java.lang.String getParent() {
          return parent;
        }

        /**
         * Required. Project or location to make a call. Must refer to a caller's project. Format:
         * `projects/{project-number-or-id}` or `projects/{project-number-or-id}/locations
         * /{location-id}`. For global calls, use `projects/{project-number-or-id}/locations/global`
         * or `projects/{project-number-or-id}`. Non-global location is required for AutoML models.
         * Only models within the same region (have same location-id) can be used, otherwise an
         * INVALID_ARGUMENT (400) error is returned.
         */
        public GetSupportedLanguages setParent(java.lang.String parent) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^projects/[^/]+/locations/[^/]+$");
          }
          this.parent = parent;
          return this;
        }

        /**
         * Optional. The language to use to return localized, human readable names of supported
         * languages. If missing, then display names are not returned in a response.
         */
        @com.google.api.client.util.Key
        private java.lang.String displayLanguageCode;

        /** Optional. The language to use to return localized, human readable names of supported languages. If
       missing, then display names are not returned in a response.
         */
        public java.lang.String getDisplayLanguageCode() {
          return displayLanguageCode;
        }

        /**
         * Optional. The language to use to return localized, human readable names of supported
         * languages. If missing, then display names are not returned in a response.
         */
        public GetSupportedLanguages setDisplayLanguageCode(java.lang.String displayLanguageCode) {
          this.displayLanguageCode = displayLanguageCode;
          return this;
        }

        /**
         * Optional. Get supported languages of this model. The format depends on model type: -
         * AutoML Translation models: `projects/{project-number-or-id}/locations/{location-
         * id}/models/{model-id}` - General (built-in) models: `projects/{project-number-or-
         * id}/locations/{location-id}/models/general/nmt`, Returns languages supported by the
         * specified model. If missing, we get supported languages of Google general NMT model.
         */
        @com.google.api.client.util.Key
        private java.lang.String model;

        /** Optional. Get supported languages of this model. The format depends on model type: - AutoML
       Translation models: `projects/{project-number-or-id}/locations/{location-id}/models/{model-id}` -
       General (built-in) models: `projects/{project-number-or-id}/locations/{location-
       id}/models/general/nmt`, Returns languages supported by the specified model. If missing, we get
       supported languages of Google general NMT model.
         */
        public java.lang.String getModel() {
          return model;
        }

        /**
         * Optional. Get supported languages of this model. The format depends on model type: -
         * AutoML Translation models: `projects/{project-number-or-id}/locations/{location-
         * id}/models/{model-id}` - General (built-in) models: `projects/{project-number-or-
         * id}/locations/{location-id}/models/general/nmt`, Returns languages supported by the
         * specified model. If missing, we get supported languages of Google general NMT model.
         */
        public GetSupportedLanguages setModel(java.lang.String model) {
          this.model = model;
          return this;
        }

        @Override
        public GetSupportedLanguages set(String parameterName, Object value) {
          return (GetSupportedLanguages) super.set(parameterName, value);
        }
      }
      /**
       * Lists information about the supported locations for this service.
       *
       * Create a request for the method "locations.list".
       *
       * This request holds the parameters needed by the translate server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param name The resource that owns the locations collection, if applicable.
       * @return the request
       */
      public List list(java.lang.String name) throws java.io.IOException {
        List result = new List(name);
        initialize(result);
        return result;
      }

      public class List extends TranslateRequest<com.google.api.services.translate.v3.model.ListLocationsResponse> {

        private static final String REST_PATH = "v3/{+name}/locations";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+$");

        /**
         * Lists information about the supported locations for this service.
         *
         * Create a request for the method "locations.list".
         *
         * This request holds the parameters needed by the the translate server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name The resource that owns the locations collection, if applicable.
         * @since 1.13
         */
        protected List(java.lang.String name) {
          super(Translate.this, "GET", REST_PATH, null, com.google.api.services.translate.v3.model.ListLocationsResponse.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List set$Xgafv(java.lang.String $Xgafv) {
          return (List) super.set$Xgafv($Xgafv);
        }

        @Override
        public List setAccessToken(java.lang.String accessToken) {
          return (List) super.setAccessToken(accessToken);
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setCallback(java.lang.String callback) {
          return (List) super.setCallback(callback);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUploadType(java.lang.String uploadType) {
          return (List) super.setUploadType(uploadType);
        }

        @Override
        public List setUploadProtocol(java.lang.String uploadProtocol) {
          return (List) super.setUploadProtocol(uploadProtocol);
        }

        /** The resource that owns the locations collection, if applicable. */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The resource that owns the locations collection, if applicable.
         */
        public java.lang.String getName() {
          return name;
        }

        /** The resource that owns the locations collection, if applicable. */
        public List setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+$");
          }
          this.name = name;
          return this;
        }

        /**
         * A filter to narrow down results to a preferred subset. The filtering language accepts
         * strings like `"displayName=tokyo"`, and is documented in more detail in
         * [AIP-160](https://google.aip.dev/160).
         */
        @com.google.api.client.util.Key
        private java.lang.String filter;

        /** A filter to narrow down results to a preferred subset. The filtering language accepts strings like
       `"displayName=tokyo"`, and is documented in more detail in [AIP-160](https://google.aip.dev/160).
         */
        public java.lang.String getFilter() {
          return filter;
        }

        /**
         * A filter to narrow down results to a preferred subset. The filtering language accepts
         * strings like `"displayName=tokyo"`, and is documented in more detail in
         * [AIP-160](https://google.aip.dev/160).
         */
        public List setFilter(java.lang.String filter) {
          this.filter = filter;
          return this;
        }

        /** The maximum number of results to return. If not set, the service selects a default. */
        @com.google.api.client.util.Key
        private java.lang.Integer pageSize;

        /** The maximum number of results to return. If not set, the service selects a default.
         */
        public java.lang.Integer getPageSize() {
          return pageSize;
        }

        /** The maximum number of results to return. If not set, the service selects a default. */
        public List setPageSize(java.lang.Integer pageSize) {
          this.pageSize = pageSize;
          return this;
        }

        /**
         * A page token received from the `next_page_token` field in the response. Send that page
         * token to receive the subsequent page.
         */
        @com.google.api.client.util.Key
        private java.lang.String pageToken;

        /** A page token received from the `next_page_token` field in the response. Send that page token to
       receive the subsequent page.
         */
        public java.lang.String getPageToken() {
          return pageToken;
        }

        /**
         * A page token received from the `next_page_token` field in the response. Send that page
         * token to receive the subsequent page.
         */
        public List setPageToken(java.lang.String pageToken) {
          this.pageToken = pageToken;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }
      /**
       * Romanize input text written in non-Latin scripts to Latin text.
       *
       * Create a request for the method "locations.romanizeText".
       *
       * This request holds the parameters needed by the translate server.  After setting any optional
       * parameters, call the {@link RomanizeText#execute()} method to invoke the remote operation.
       *
       * @param parent Required. Project or location to make a call. Must refer to a caller's project. Format: `projects
       *        /{project-number-or-id}/locations/{location-id}` or `projects/{project-number-or-id}`. For
       *        global calls, use `projects/{project-number-or-id}/locations/global` or `projects
       *        /{project-number-or-id}`.
       * @param content the {@link com.google.api.services.translate.v3.model.RomanizeTextRequest}
       * @return the request
       */
      public RomanizeText romanizeText(java.lang.String parent, com.google.api.services.translate.v3.model.RomanizeTextRequest content) throws java.io.IOException {
        RomanizeText result = new RomanizeText(parent, content);
        initialize(result);
        return result;
      }

      public class RomanizeText extends TranslateRequest<com.google.api.services.translate.v3.model.RomanizeTextResponse> {

        private static final String REST_PATH = "v3/{+parent}:romanizeText";

        private final java.util.regex.Pattern PARENT_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+$");

        /**
         * Romanize input text written in non-Latin scripts to Latin text.
         *
         * Create a request for the method "locations.romanizeText".
         *
         * This request holds the parameters needed by the the translate server.  After setting any
         * optional parameters, call the {@link RomanizeText#execute()} method to invoke the remote
         * operation. <p> {@link
         * RomanizeText#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param parent Required. Project or location to make a call. Must refer to a caller's project. Format: `projects
       *        /{project-number-or-id}/locations/{location-id}` or `projects/{project-number-or-id}`. For
       *        global calls, use `projects/{project-number-or-id}/locations/global` or `projects
       *        /{project-number-or-id}`.
         * @param content the {@link com.google.api.services.translate.v3.model.RomanizeTextRequest}
         * @since 1.13
         */
        protected RomanizeText(java.lang.String parent, com.google.api.services.translate.v3.model.RomanizeTextRequest content) {
          super(Translate.this, "POST", REST_PATH, content, com.google.api.services.translate.v3.model.RomanizeTextResponse.class);
          this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^projects/[^/]+/locations/[^/]+$");
          }
        }

        @Override
        public RomanizeText set$Xgafv(java.lang.String $Xgafv) {
          return (RomanizeText) super.set$Xgafv($Xgafv);
        }

        @Override
        public RomanizeText setAccessToken(java.lang.String accessToken) {
          return (RomanizeText) super.setAccessToken(accessToken);
        }

        @Override
        public RomanizeText setAlt(java.lang.String alt) {
          return (RomanizeText) super.setAlt(alt);
        }

        @Override
        public RomanizeText setCallback(java.lang.String callback) {
          return (RomanizeText) super.setCallback(callback);
        }

        @Override
        public RomanizeText setFields(java.lang.String fields) {
          return (RomanizeText) super.setFields(fields);
        }

        @Override
        public RomanizeText setKey(java.lang.String key) {
          return (RomanizeText) super.setKey(key);
        }

        @Override
        public RomanizeText setOauthToken(java.lang.String oauthToken) {
          return (RomanizeText) super.setOauthToken(oauthToken);
        }

        @Override
        public RomanizeText setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (RomanizeText) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public RomanizeText setQuotaUser(java.lang.String quotaUser) {
          return (RomanizeText) super.setQuotaUser(quotaUser);
        }

        @Override
        public RomanizeText setUploadType(java.lang.String uploadType) {
          return (RomanizeText) super.setUploadType(uploadType);
        }

        @Override
        public RomanizeText setUploadProtocol(java.lang.String uploadProtocol) {
          return (RomanizeText) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. Project or location to make a call. Must refer to a caller's project. Format:
         * `projects/{project-number-or-id}/locations/{location-id}` or `projects/{project-number-
         * or-id}`. For global calls, use `projects/{project-number-or-id}/locations/global` or
         * `projects/{project-number-or-id}`.
         */
        @com.google.api.client.util.Key
        private java.lang.String parent;

        /** Required. Project or location to make a call. Must refer to a caller's project. Format: `projects
       /{project-number-or-id}/locations/{location-id}` or `projects/{project-number-or-id}`. For global
       calls, use `projects/{project-number-or-id}/locations/global` or `projects/{project-number-or-id}`.
         */
        public java.lang.String getParent() {
          return parent;
        }

        /**
         * Required. Project or location to make a call. Must refer to a caller's project. Format:
         * `projects/{project-number-or-id}/locations/{location-id}` or `projects/{project-number-
         * or-id}`. For global calls, use `projects/{project-number-or-id}/locations/global` or
         * `projects/{project-number-or-id}`.
         */
        public RomanizeText setParent(java.lang.String parent) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^projects/[^/]+/locations/[^/]+$");
          }
          this.parent = parent;
          return this;
        }

        @Override
        public RomanizeText set(String parameterName, Object value) {
          return (RomanizeText) super.set(parameterName, value);
        }
      }
      /**
       * Translates documents in synchronous mode.
       *
       * Create a request for the method "locations.translateDocument".
       *
       * This request holds the parameters needed by the translate server.  After setting any optional
       * parameters, call the {@link TranslateDocument#execute()} method to invoke the remote operation.
       *
       * @param parent Required. Location to make a regional call. Format: `projects/{project-number-or-id}/locations
       *        /{location-id}`. For global calls, use `projects/{project-number-or-id}/locations/global`
       *        or `projects/{project-number-or-id}`. Non-global location is required for requests using
       *        AutoML models or custom glossaries. Models and glossaries must be within the same region
       *        (have the same location-id), otherwise an INVALID_ARGUMENT (400) error is returned.
       * @param content the {@link com.google.api.services.translate.v3.model.TranslateDocumentRequest}
       * @return the request
       */
      public TranslateDocument translateDocument(java.lang.String parent, com.google.api.services.translate.v3.model.TranslateDocumentRequest content) throws java.io.IOException {
        TranslateDocument result = new TranslateDocument(parent, content);
        initialize(result);
        return result;
      }

      public class TranslateDocument extends TranslateRequest<com.google.api.services.translate.v3.model.TranslateDocumentResponse> {

        private static final String REST_PATH = "v3/{+parent}:translateDocument";

        private final java.util.regex.Pattern PARENT_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+$");

        /**
         * Translates documents in synchronous mode.
         *
         * Create a request for the method "locations.translateDocument".
         *
         * This request holds the parameters needed by the the translate server.  After setting any
         * optional parameters, call the {@link TranslateDocument#execute()} method to invoke the remote
         * operation. <p> {@link TranslateDocument#initialize(com.google.api.client.googleapis.services.Ab
         * stractGoogleClientRequest)} must be called to initialize this instance immediately after
         * invoking the constructor. </p>
         *
         * @param parent Required. Location to make a regional call. Format: `projects/{project-number-or-id}/locations
       *        /{location-id}`. For global calls, use `projects/{project-number-or-id}/locations/global`
       *        or `projects/{project-number-or-id}`. Non-global location is required for requests using
       *        AutoML models or custom glossaries. Models and glossaries must be within the same region
       *        (have the same location-id), otherwise an INVALID_ARGUMENT (400) error is returned.
         * @param content the {@link com.google.api.services.translate.v3.model.TranslateDocumentRequest}
         * @since 1.13
         */
        protected TranslateDocument(java.lang.String parent, com.google.api.services.translate.v3.model.TranslateDocumentRequest content) {
          super(Translate.this, "POST", REST_PATH, content, com.google.api.services.translate.v3.model.TranslateDocumentResponse.class);
          this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^projects/[^/]+/locations/[^/]+$");
          }
        }

        @Override
        public TranslateDocument set$Xgafv(java.lang.String $Xgafv) {
          return (TranslateDocument) super.set$Xgafv($Xgafv);
        }

        @Override
        public TranslateDocument setAccessToken(java.lang.String accessToken) {
          return (TranslateDocument) super.setAccessToken(accessToken);
        }

        @Override
        public TranslateDocument setAlt(java.lang.String alt) {
          return (TranslateDocument) super.setAlt(alt);
        }

        @Override
        public TranslateDocument setCallback(java.lang.String callback) {
          return (TranslateDocument) super.setCallback(callback);
        }

        @Override
        public TranslateDocument setFields(java.lang.String fields) {
          return (TranslateDocument) super.setFields(fields);
        }

        @Override
        public TranslateDocument setKey(java.lang.String key) {
          return (TranslateDocument) super.setKey(key);
        }

        @Override
        public TranslateDocument setOauthToken(java.lang.String oauthToken) {
          return (TranslateDocument) super.setOauthToken(oauthToken);
        }

        @Override
        public TranslateDocument setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (TranslateDocument) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public TranslateDocument setQuotaUser(java.lang.String quotaUser) {
          return (TranslateDocument) super.setQuotaUser(quotaUser);
        }

        @Override
        public TranslateDocument setUploadType(java.lang.String uploadType) {
          return (TranslateDocument) super.setUploadType(uploadType);
        }

        @Override
        public TranslateDocument setUploadProtocol(java.lang.String uploadProtocol) {
          return (TranslateDocument) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. Location to make a regional call. Format: `projects/{project-number-or-
         * id}/locations/{location-id}`. For global calls, use `projects/{project-number-or-
         * id}/locations/global` or `projects/{project-number-or-id}`. Non-global location is
         * required for requests using AutoML models or custom glossaries. Models and glossaries
         * must be within the same region (have the same location-id), otherwise an INVALID_ARGUMENT
         * (400) error is returned.
         */
        @com.google.api.client.util.Key
        private java.lang.String parent;

        /** Required. Location to make a regional call. Format: `projects/{project-number-or-id}/locations
       /{location-id}`. For global calls, use `projects/{project-number-or-id}/locations/global` or
       `projects/{project-number-or-id}`. Non-global location is required for requests using AutoML models
       or custom glossaries. Models and glossaries must be within the same region (have the same location-
       id), otherwise an INVALID_ARGUMENT (400) error is returned.
         */
        public java.lang.String getParent() {
          return parent;
        }

        /**
         * Required. Location to make a regional call. Format: `projects/{project-number-or-
         * id}/locations/{location-id}`. For global calls, use `projects/{project-number-or-
         * id}/locations/global` or `projects/{project-number-or-id}`. Non-global location is
         * required for requests using AutoML models or custom glossaries. Models and glossaries
         * must be within the same region (have the same location-id), otherwise an INVALID_ARGUMENT
         * (400) error is returned.
         */
        public TranslateDocument setParent(java.lang.String parent) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^projects/[^/]+/locations/[^/]+$");
          }
          this.parent = parent;
          return this;
        }

        @Override
        public TranslateDocument set(String parameterName, Object value) {
          return (TranslateDocument) super.set(parameterName, value);
        }
      }
      /**
       * Translates input text and returns translated text.
       *
       * Create a request for the method "locations.translateText".
       *
       * This request holds the parameters needed by the translate server.  After setting any optional
       * parameters, call the {@link TranslateText#execute()} method to invoke the remote operation.
       *
       * @param parent Required. Project or location to make a call. Must refer to a caller's project. Format: `projects
       *        /{project-number-or-id}` or `projects/{project-number-or-id}/locations/{location-id}`. For
       *        global calls, use `projects/{project-number-or-id}/locations/global` or `projects
       *        /{project-number-or-id}`. Non-global location is required for requests using AutoML models
       *        or custom glossaries. Models and glossaries must be within the same region (have same
       *        location-id), otherwise an INVALID_ARGUMENT (400) error is returned.
       * @param content the {@link com.google.api.services.translate.v3.model.TranslateTextRequest}
       * @return the request
       */
      public TranslateText translateText(java.lang.String parent, com.google.api.services.translate.v3.model.TranslateTextRequest content) throws java.io.IOException {
        TranslateText result = new TranslateText(parent, content);
        initialize(result);
        return result;
      }

      public class TranslateText extends TranslateRequest<com.google.api.services.translate.v3.model.TranslateTextResponse> {

        private static final String REST_PATH = "v3/{+parent}:translateText";

        private final java.util.regex.Pattern PARENT_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+$");

        /**
         * Translates input text and returns translated text.
         *
         * Create a request for the method "locations.translateText".
         *
         * This request holds the parameters needed by the the translate server.  After setting any
         * optional parameters, call the {@link TranslateText#execute()} method to invoke the remote
         * operation. <p> {@link TranslateText#initialize(com.google.api.client.googleapis.services.Abstra
         * ctGoogleClientRequest)} must be called to initialize this instance immediately after invoking
         * the constructor. </p>
         *
         * @param parent Required. Project or location to make a call. Must refer to a caller's project. Format: `projects
       *        /{project-number-or-id}` or `projects/{project-number-or-id}/locations/{location-id}`. For
       *        global calls, use `projects/{project-number-or-id}/locations/global` or `projects
       *        /{project-number-or-id}`. Non-global location is required for requests using AutoML models
       *        or custom glossaries. Models and glossaries must be within the same region (have same
       *        location-id), otherwise an INVALID_ARGUMENT (400) error is returned.
         * @param content the {@link com.google.api.services.translate.v3.model.TranslateTextRequest}
         * @since 1.13
         */
        protected TranslateText(java.lang.String parent, com.google.api.services.translate.v3.model.TranslateTextRequest content) {
          super(Translate.this, "POST", REST_PATH, content, com.google.api.services.translate.v3.model.TranslateTextResponse.class);
          this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^projects/[^/]+/locations/[^/]+$");
          }
        }

        @Override
        public TranslateText set$Xgafv(java.lang.String $Xgafv) {
          return (TranslateText) super.set$Xgafv($Xgafv);
        }

        @Override
        public TranslateText setAccessToken(java.lang.String accessToken) {
          return (TranslateText) super.setAccessToken(accessToken);
        }

        @Override
        public TranslateText setAlt(java.lang.String alt) {
          return (TranslateText) super.setAlt(alt);
        }

        @Override
        public TranslateText setCallback(java.lang.String callback) {
          return (TranslateText) super.setCallback(callback);
        }

        @Override
        public TranslateText setFields(java.lang.String fields) {
          return (TranslateText) super.setFields(fields);
        }

        @Override
        public TranslateText setKey(java.lang.String key) {
          return (TranslateText) super.setKey(key);
        }

        @Override
        public TranslateText setOauthToken(java.lang.String oauthToken) {
          return (TranslateText) super.setOauthToken(oauthToken);
        }

        @Override
        public TranslateText setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (TranslateText) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public TranslateText setQuotaUser(java.lang.String quotaUser) {
          return (TranslateText) super.setQuotaUser(quotaUser);
        }

        @Override
        public TranslateText setUploadType(java.lang.String uploadType) {
          return (TranslateText) super.setUploadType(uploadType);
        }

        @Override
        public TranslateText setUploadProtocol(java.lang.String uploadProtocol) {
          return (TranslateText) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. Project or location to make a call. Must refer to a caller's project. Format:
         * `projects/{project-number-or-id}` or `projects/{project-number-or-id}/locations
         * /{location-id}`. For global calls, use `projects/{project-number-or-id}/locations/global`
         * or `projects/{project-number-or-id}`. Non-global location is required for requests using
         * AutoML models or custom glossaries. Models and glossaries must be within the same region
         * (have same location-id), otherwise an INVALID_ARGUMENT (400) error is returned.
         */
        @com.google.api.client.util.Key
        private java.lang.String parent;

        /** Required. Project or location to make a call. Must refer to a caller's project. Format: `projects
       /{project-number-or-id}` or `projects/{project-number-or-id}/locations/{location-id}`. For global
       calls, use `projects/{project-number-or-id}/locations/global` or `projects/{project-number-or-id}`.
       Non-global location is required for requests using AutoML models or custom glossaries. Models and
       glossaries must be within the same region (have same location-id), otherwise an INVALID_ARGUMENT
       (400) error is returned.
         */
        public java.lang.String getParent() {
          return parent;
        }

        /**
         * Required. Project or location to make a call. Must refer to a caller's project. Format:
         * `projects/{project-number-or-id}` or `projects/{project-number-or-id}/locations
         * /{location-id}`. For global calls, use `projects/{project-number-or-id}/locations/global`
         * or `projects/{project-number-or-id}`. Non-global location is required for requests using
         * AutoML models or custom glossaries. Models and glossaries must be within the same region
         * (have same location-id), otherwise an INVALID_ARGUMENT (400) error is returned.
         */
        public TranslateText setParent(java.lang.String parent) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^projects/[^/]+/locations/[^/]+$");
          }
          this.parent = parent;
          return this;
        }

        @Override
        public TranslateText set(String parameterName, Object value) {
          return (TranslateText) super.set(parameterName, value);
        }
      }

      /**
       * An accessor for creating requests from the AdaptiveMtDatasets collection.
       *
       * <p>The typical use is:</p>
       * <pre>
       *   {@code Translate translate = new Translate(...);}
       *   {@code Translate.AdaptiveMtDatasets.List request = translate.adaptiveMtDatasets().list(parameters ...)}
       * </pre>
       *
       * @return the resource collection
       */
      public AdaptiveMtDatasets adaptiveMtDatasets() {
        return new AdaptiveMtDatasets();
      }

      /**
       * The "adaptiveMtDatasets" collection of methods.
       */
      public class AdaptiveMtDatasets {

        /**
         * Creates an Adaptive MT dataset.
         *
         * Create a request for the method "adaptiveMtDatasets.create".
         *
         * This request holds the parameters needed by the translate server.  After setting any optional
         * parameters, call the {@link Create#execute()} method to invoke the remote operation.
         *
         * @param parent Required. Name of the parent project. In form of `projects/{project-number-or-id}/locations
         *        /{location-id}`
         * @param content the {@link com.google.api.services.translate.v3.model.AdaptiveMtDataset}
         * @return the request
         */
        public Create create(java.lang.String parent, com.google.api.services.translate.v3.model.AdaptiveMtDataset content) throws java.io.IOException {
          Create result = new Create(parent, content);
          initialize(result);
          return result;
        }

        public class Create extends TranslateRequest<com.google.api.services.translate.v3.model.AdaptiveMtDataset> {

          private static final String REST_PATH = "v3/{+parent}/adaptiveMtDatasets";

          private final java.util.regex.Pattern PARENT_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+$");

          /**
           * Creates an Adaptive MT dataset.
           *
           * Create a request for the method "adaptiveMtDatasets.create".
           *
           * This request holds the parameters needed by the the translate server.  After setting any
           * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
           * <p> {@link
           * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param parent Required. Name of the parent project. In form of `projects/{project-number-or-id}/locations
         *        /{location-id}`
           * @param content the {@link com.google.api.services.translate.v3.model.AdaptiveMtDataset}
           * @since 1.13
           */
          protected Create(java.lang.String parent, com.google.api.services.translate.v3.model.AdaptiveMtDataset content) {
            super(Translate.this, "POST", REST_PATH, content, com.google.api.services.translate.v3.model.AdaptiveMtDataset.class);
            this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
          }

          @Override
          public Create set$Xgafv(java.lang.String $Xgafv) {
            return (Create) super.set$Xgafv($Xgafv);
          }

          @Override
          public Create setAccessToken(java.lang.String accessToken) {
            return (Create) super.setAccessToken(accessToken);
          }

          @Override
          public Create setAlt(java.lang.String alt) {
            return (Create) super.setAlt(alt);
          }

          @Override
          public Create setCallback(java.lang.String callback) {
            return (Create) super.setCallback(callback);
          }

          @Override
          public Create setFields(java.lang.String fields) {
            return (Create) super.setFields(fields);
          }

          @Override
          public Create setKey(java.lang.String key) {
            return (Create) super.setKey(key);
          }

          @Override
          public Create setOauthToken(java.lang.String oauthToken) {
            return (Create) super.setOauthToken(oauthToken);
          }

          @Override
          public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Create) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Create setQuotaUser(java.lang.String quotaUser) {
            return (Create) super.setQuotaUser(quotaUser);
          }

          @Override
          public Create setUploadType(java.lang.String uploadType) {
            return (Create) super.setUploadType(uploadType);
          }

          @Override
          public Create setUploadProtocol(java.lang.String uploadProtocol) {
            return (Create) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. Name of the parent project. In form of `projects/{project-number-or-
           * id}/locations/{location-id}`
           */
          @com.google.api.client.util.Key
          private java.lang.String parent;

          /** Required. Name of the parent project. In form of `projects/{project-number-or-id}/locations
         /{location-id}`
           */
          public java.lang.String getParent() {
            return parent;
          }

          /**
           * Required. Name of the parent project. In form of `projects/{project-number-or-
           * id}/locations/{location-id}`
           */
          public Create setParent(java.lang.String parent) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
            this.parent = parent;
            return this;
          }

          @Override
          public Create set(String parameterName, Object value) {
            return (Create) super.set(parameterName, value);
          }
        }
        /**
         * Deletes an Adaptive MT dataset, including all its entries and associated metadata.
         *
         * Create a request for the method "adaptiveMtDatasets.delete".
         *
         * This request holds the parameters needed by the translate server.  After setting any optional
         * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
         *
         * @param name Required. Name of the dataset. In the form of `projects/{project-number-or-id}/locations/{location-
         *        id}/adaptiveMtDatasets/{adaptive-mt-dataset-id}`
         * @return the request
         */
        public Delete delete(java.lang.String name) throws java.io.IOException {
          Delete result = new Delete(name);
          initialize(result);
          return result;
        }

        public class Delete extends TranslateRequest<com.google.api.services.translate.v3.model.Empty> {

          private static final String REST_PATH = "v3/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/adaptiveMtDatasets/[^/]+$");

          /**
           * Deletes an Adaptive MT dataset, including all its entries and associated metadata.
           *
           * Create a request for the method "adaptiveMtDatasets.delete".
           *
           * This request holds the parameters needed by the the translate server.  After setting any
           * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
           * <p> {@link
           * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name Required. Name of the dataset. In the form of `projects/{project-number-or-id}/locations/{location-
         *        id}/adaptiveMtDatasets/{adaptive-mt-dataset-id}`
           * @since 1.13
           */
          protected Delete(java.lang.String name) {
            super(Translate.this, "DELETE", REST_PATH, null, com.google.api.services.translate.v3.model.Empty.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/adaptiveMtDatasets/[^/]+$");
            }
          }

          @Override
          public Delete set$Xgafv(java.lang.String $Xgafv) {
            return (Delete) super.set$Xgafv($Xgafv);
          }

          @Override
          public Delete setAccessToken(java.lang.String accessToken) {
            return (Delete) super.setAccessToken(accessToken);
          }

          @Override
          public Delete setAlt(java.lang.String alt) {
            return (Delete) super.setAlt(alt);
          }

          @Override
          public Delete setCallback(java.lang.String callback) {
            return (Delete) super.setCallback(callback);
          }

          @Override
          public Delete setFields(java.lang.String fields) {
            return (Delete) super.setFields(fields);
          }

          @Override
          public Delete setKey(java.lang.String key) {
            return (Delete) super.setKey(key);
          }

          @Override
          public Delete setOauthToken(java.lang.String oauthToken) {
            return (Delete) super.setOauthToken(oauthToken);
          }

          @Override
          public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Delete) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Delete setQuotaUser(java.lang.String quotaUser) {
            return (Delete) super.setQuotaUser(quotaUser);
          }

          @Override
          public Delete setUploadType(java.lang.String uploadType) {
            return (Delete) super.setUploadType(uploadType);
          }

          @Override
          public Delete setUploadProtocol(java.lang.String uploadProtocol) {
            return (Delete) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. Name of the dataset. In the form of `projects/{project-number-or-
           * id}/locations/{location-id}/adaptiveMtDatasets/{adaptive-mt-dataset-id}`
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Required. Name of the dataset. In the form of `projects/{project-number-or-id}/locations/{location-
         id}/adaptiveMtDatasets/{adaptive-mt-dataset-id}`
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * Required. Name of the dataset. In the form of `projects/{project-number-or-
           * id}/locations/{location-id}/adaptiveMtDatasets/{adaptive-mt-dataset-id}`
           */
          public Delete setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/adaptiveMtDatasets/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Delete set(String parameterName, Object value) {
            return (Delete) super.set(parameterName, value);
          }
        }
        /**
         * Gets the Adaptive MT dataset.
         *
         * Create a request for the method "adaptiveMtDatasets.get".
         *
         * This request holds the parameters needed by the translate server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation.
         *
         * @param name Required. Name of the dataset. In the form of `projects/{project-number-or-id}/locations/{location-
         *        id}/adaptiveMtDatasets/{adaptive-mt-dataset-id}`
         * @return the request
         */
        public Get get(java.lang.String name) throws java.io.IOException {
          Get result = new Get(name);
          initialize(result);
          return result;
        }

        public class Get extends TranslateRequest<com.google.api.services.translate.v3.model.AdaptiveMtDataset> {

          private static final String REST_PATH = "v3/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/adaptiveMtDatasets/[^/]+$");

          /**
           * Gets the Adaptive MT dataset.
           *
           * Create a request for the method "adaptiveMtDatasets.get".
           *
           * This request holds the parameters needed by the the translate server.  After setting any
           * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
           * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name Required. Name of the dataset. In the form of `projects/{project-number-or-id}/locations/{location-
         *        id}/adaptiveMtDatasets/{adaptive-mt-dataset-id}`
           * @since 1.13
           */
          protected Get(java.lang.String name) {
            super(Translate.this, "GET", REST_PATH, null, com.google.api.services.translate.v3.model.AdaptiveMtDataset.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/adaptiveMtDatasets/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public Get set$Xgafv(java.lang.String $Xgafv) {
            return (Get) super.set$Xgafv($Xgafv);
          }

          @Override
          public Get setAccessToken(java.lang.String accessToken) {
            return (Get) super.setAccessToken(accessToken);
          }

          @Override
          public Get setAlt(java.lang.String alt) {
            return (Get) super.setAlt(alt);
          }

          @Override
          public Get setCallback(java.lang.String callback) {
            return (Get) super.setCallback(callback);
          }

          @Override
          public Get setFields(java.lang.String fields) {
            return (Get) super.setFields(fields);
          }

          @Override
          public Get setKey(java.lang.String key) {
            return (Get) super.setKey(key);
          }

          @Override
          public Get setOauthToken(java.lang.String oauthToken) {
            return (Get) super.setOauthToken(oauthToken);
          }

          @Override
          public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Get) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Get setQuotaUser(java.lang.String quotaUser) {
            return (Get) super.setQuotaUser(quotaUser);
          }

          @Override
          public Get setUploadType(java.lang.String uploadType) {
            return (Get) super.setUploadType(uploadType);
          }

          @Override
          public Get setUploadProtocol(java.lang.String uploadProtocol) {
            return (Get) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. Name of the dataset. In the form of `projects/{project-number-or-
           * id}/locations/{location-id}/adaptiveMtDatasets/{adaptive-mt-dataset-id}`
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Required. Name of the dataset. In the form of `projects/{project-number-or-id}/locations/{location-
         id}/adaptiveMtDatasets/{adaptive-mt-dataset-id}`
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * Required. Name of the dataset. In the form of `projects/{project-number-or-
           * id}/locations/{location-id}/adaptiveMtDatasets/{adaptive-mt-dataset-id}`
           */
          public Get setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/adaptiveMtDatasets/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Get set(String parameterName, Object value) {
            return (Get) super.set(parameterName, value);
          }
        }
        /**
         * Imports an AdaptiveMtFile and adds all of its sentences into the AdaptiveMtDataset.
         *
         * Create a request for the method "adaptiveMtDatasets.importAdaptiveMtFile".
         *
         * This request holds the parameters needed by the translate server.  After setting any optional
         * parameters, call the {@link ImportAdaptiveMtFile#execute()} method to invoke the remote
         * operation.
         *
         * @param parent Required. The resource name of the file, in form of `projects/{project-number-or-
         *        id}/locations/{location_id}/adaptiveMtDatasets/{dataset}`
         * @param content the {@link com.google.api.services.translate.v3.model.ImportAdaptiveMtFileRequest}
         * @return the request
         */
        public ImportAdaptiveMtFile importAdaptiveMtFile(java.lang.String parent, com.google.api.services.translate.v3.model.ImportAdaptiveMtFileRequest content) throws java.io.IOException {
          ImportAdaptiveMtFile result = new ImportAdaptiveMtFile(parent, content);
          initialize(result);
          return result;
        }

        public class ImportAdaptiveMtFile extends TranslateRequest<com.google.api.services.translate.v3.model.ImportAdaptiveMtFileResponse> {

          private static final String REST_PATH = "v3/{+parent}:importAdaptiveMtFile";

          private final java.util.regex.Pattern PARENT_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/adaptiveMtDatasets/[^/]+$");

          /**
           * Imports an AdaptiveMtFile and adds all of its sentences into the AdaptiveMtDataset.
           *
           * Create a request for the method "adaptiveMtDatasets.importAdaptiveMtFile".
           *
           * This request holds the parameters needed by the the translate server.  After setting any
           * optional parameters, call the {@link ImportAdaptiveMtFile#execute()} method to invoke the
           * remote operation. <p> {@link ImportAdaptiveMtFile#initialize(com.google.api.client.googleapis.s
           * ervices.AbstractGoogleClientRequest)} must be called to initialize this instance immediately
           * after invoking the constructor. </p>
           *
           * @param parent Required. The resource name of the file, in form of `projects/{project-number-or-
         *        id}/locations/{location_id}/adaptiveMtDatasets/{dataset}`
           * @param content the {@link com.google.api.services.translate.v3.model.ImportAdaptiveMtFileRequest}
           * @since 1.13
           */
          protected ImportAdaptiveMtFile(java.lang.String parent, com.google.api.services.translate.v3.model.ImportAdaptiveMtFileRequest content) {
            super(Translate.this, "POST", REST_PATH, content, com.google.api.services.translate.v3.model.ImportAdaptiveMtFileResponse.class);
            this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/adaptiveMtDatasets/[^/]+$");
            }
          }

          @Override
          public ImportAdaptiveMtFile set$Xgafv(java.lang.String $Xgafv) {
            return (ImportAdaptiveMtFile) super.set$Xgafv($Xgafv);
          }

          @Override
          public ImportAdaptiveMtFile setAccessToken(java.lang.String accessToken) {
            return (ImportAdaptiveMtFile) super.setAccessToken(accessToken);
          }

          @Override
          public ImportAdaptiveMtFile setAlt(java.lang.String alt) {
            return (ImportAdaptiveMtFile) super.setAlt(alt);
          }

          @Override
          public ImportAdaptiveMtFile setCallback(java.lang.String callback) {
            return (ImportAdaptiveMtFile) super.setCallback(callback);
          }

          @Override
          public ImportAdaptiveMtFile setFields(java.lang.String fields) {
            return (ImportAdaptiveMtFile) super.setFields(fields);
          }

          @Override
          public ImportAdaptiveMtFile setKey(java.lang.String key) {
            return (ImportAdaptiveMtFile) super.setKey(key);
          }

          @Override
          public ImportAdaptiveMtFile setOauthToken(java.lang.String oauthToken) {
            return (ImportAdaptiveMtFile) super.setOauthToken(oauthToken);
          }

          @Override
          public ImportAdaptiveMtFile setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (ImportAdaptiveMtFile) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public ImportAdaptiveMtFile setQuotaUser(java.lang.String quotaUser) {
            return (ImportAdaptiveMtFile) super.setQuotaUser(quotaUser);
          }

          @Override
          public ImportAdaptiveMtFile setUploadType(java.lang.String uploadType) {
            return (ImportAdaptiveMtFile) super.setUploadType(uploadType);
          }

          @Override
          public ImportAdaptiveMtFile setUploadProtocol(java.lang.String uploadProtocol) {
            return (ImportAdaptiveMtFile) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. The resource name of the file, in form of `projects/{project-number-or-
           * id}/locations/{location_id}/adaptiveMtDatasets/{dataset}`
           */
          @com.google.api.client.util.Key
          private java.lang.String parent;

          /** Required. The resource name of the file, in form of `projects/{project-number-or-
         id}/locations/{location_id}/adaptiveMtDatasets/{dataset}`
           */
          public java.lang.String getParent() {
            return parent;
          }

          /**
           * Required. The resource name of the file, in form of `projects/{project-number-or-
           * id}/locations/{location_id}/adaptiveMtDatasets/{dataset}`
           */
          public ImportAdaptiveMtFile setParent(java.lang.String parent) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/adaptiveMtDatasets/[^/]+$");
            }
            this.parent = parent;
            return this;
          }

          @Override
          public ImportAdaptiveMtFile set(String parameterName, Object value) {
            return (ImportAdaptiveMtFile) super.set(parameterName, value);
          }
        }
        /**
         * Lists all Adaptive MT datasets for which the caller has read permission.
         *
         * Create a request for the method "adaptiveMtDatasets.list".
         *
         * This request holds the parameters needed by the translate server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation.
         *
         * @param parent Required. The resource name of the project from which to list the Adaptive MT datasets. `projects
         *        /{project-number-or-id}/locations/{location-id}`
         * @return the request
         */
        public List list(java.lang.String parent) throws java.io.IOException {
          List result = new List(parent);
          initialize(result);
          return result;
        }

        public class List extends TranslateRequest<com.google.api.services.translate.v3.model.ListAdaptiveMtDatasetsResponse> {

          private static final String REST_PATH = "v3/{+parent}/adaptiveMtDatasets";

          private final java.util.regex.Pattern PARENT_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+$");

          /**
           * Lists all Adaptive MT datasets for which the caller has read permission.
           *
           * Create a request for the method "adaptiveMtDatasets.list".
           *
           * This request holds the parameters needed by the the translate server.  After setting any
           * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
           * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param parent Required. The resource name of the project from which to list the Adaptive MT datasets. `projects
         *        /{project-number-or-id}/locations/{location-id}`
           * @since 1.13
           */
          protected List(java.lang.String parent) {
            super(Translate.this, "GET", REST_PATH, null, com.google.api.services.translate.v3.model.ListAdaptiveMtDatasetsResponse.class);
            this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public List set$Xgafv(java.lang.String $Xgafv) {
            return (List) super.set$Xgafv($Xgafv);
          }

          @Override
          public List setAccessToken(java.lang.String accessToken) {
            return (List) super.setAccessToken(accessToken);
          }

          @Override
          public List setAlt(java.lang.String alt) {
            return (List) super.setAlt(alt);
          }

          @Override
          public List setCallback(java.lang.String callback) {
            return (List) super.setCallback(callback);
          }

          @Override
          public List setFields(java.lang.String fields) {
            return (List) super.setFields(fields);
          }

          @Override
          public List setKey(java.lang.String key) {
            return (List) super.setKey(key);
          }

          @Override
          public List setOauthToken(java.lang.String oauthToken) {
            return (List) super.setOauthToken(oauthToken);
          }

          @Override
          public List setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (List) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public List setQuotaUser(java.lang.String quotaUser) {
            return (List) super.setQuotaUser(quotaUser);
          }

          @Override
          public List setUploadType(java.lang.String uploadType) {
            return (List) super.setUploadType(uploadType);
          }

          @Override
          public List setUploadProtocol(java.lang.String uploadProtocol) {
            return (List) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. The resource name of the project from which to list the Adaptive MT datasets.
           * `projects/{project-number-or-id}/locations/{location-id}`
           */
          @com.google.api.client.util.Key
          private java.lang.String parent;

          /** Required. The resource name of the project from which to list the Adaptive MT datasets. `projects
         /{project-number-or-id}/locations/{location-id}`
           */
          public java.lang.String getParent() {
            return parent;
          }

          /**
           * Required. The resource name of the project from which to list the Adaptive MT datasets.
           * `projects/{project-number-or-id}/locations/{location-id}`
           */
          public List setParent(java.lang.String parent) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
            this.parent = parent;
            return this;
          }

          /**
           * Optional. An expression for filtering the results of the request. Filter is not
           * supported yet.
           */
          @com.google.api.client.util.Key
          private java.lang.String filter;

          /** Optional. An expression for filtering the results of the request. Filter is not supported yet.
           */
          public java.lang.String getFilter() {
            return filter;
          }

          /**
           * Optional. An expression for filtering the results of the request. Filter is not
           * supported yet.
           */
          public List setFilter(java.lang.String filter) {
            this.filter = filter;
            return this;
          }

          /**
           * Optional. Requested page size. The server may return fewer results than requested. If
           * unspecified, the server picks an appropriate default.
           */
          @com.google.api.client.util.Key
          private java.lang.Integer pageSize;

          /** Optional. Requested page size. The server may return fewer results than requested. If unspecified,
         the server picks an appropriate default.
           */
          public java.lang.Integer getPageSize() {
            return pageSize;
          }

          /**
           * Optional. Requested page size. The server may return fewer results than requested. If
           * unspecified, the server picks an appropriate default.
           */
          public List setPageSize(java.lang.Integer pageSize) {
            this.pageSize = pageSize;
            return this;
          }

          /**
           * Optional. A token identifying a page of results the server should return. Typically,
           * this is the value of ListAdaptiveMtDatasetsResponse.next_page_token returned from the
           * previous call to `ListAdaptiveMtDatasets` method. The first page is returned if
           * `page_token`is empty or missing.
           */
          @com.google.api.client.util.Key
          private java.lang.String pageToken;

          /** Optional. A token identifying a page of results the server should return. Typically, this is the
         value of ListAdaptiveMtDatasetsResponse.next_page_token returned from the previous call to
         `ListAdaptiveMtDatasets` method. The first page is returned if `page_token`is empty or missing.
           */
          public java.lang.String getPageToken() {
            return pageToken;
          }

          /**
           * Optional. A token identifying a page of results the server should return. Typically,
           * this is the value of ListAdaptiveMtDatasetsResponse.next_page_token returned from the
           * previous call to `ListAdaptiveMtDatasets` method. The first page is returned if
           * `page_token`is empty or missing.
           */
          public List setPageToken(java.lang.String pageToken) {
            this.pageToken = pageToken;
            return this;
          }

          @Override
          public List set(String parameterName, Object value) {
            return (List) super.set(parameterName, value);
          }
        }

        /**
         * An accessor for creating requests from the AdaptiveMtFiles collection.
         *
         * <p>The typical use is:</p>
         * <pre>
         *   {@code Translate translate = new Translate(...);}
         *   {@code Translate.AdaptiveMtFiles.List request = translate.adaptiveMtFiles().list(parameters ...)}
         * </pre>
         *
         * @return the resource collection
         */
        public AdaptiveMtFiles adaptiveMtFiles() {
          return new AdaptiveMtFiles();
        }

        /**
         * The "adaptiveMtFiles" collection of methods.
         */
        public class AdaptiveMtFiles {

          /**
           * Deletes an AdaptiveMtFile along with its sentences.
           *
           * Create a request for the method "adaptiveMtFiles.delete".
           *
           * This request holds the parameters needed by the translate server.  After setting any optional
           * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
           *
           * @param name Required. The resource name of the file to delete, in form of `projects/{project-number-or-
           *        id}/locations/{location_id}/adaptiveMtDatasets/{dataset}/files/{file}`
           * @return the request
           */
          public Delete delete(java.lang.String name) throws java.io.IOException {
            Delete result = new Delete(name);
            initialize(result);
            return result;
          }

          public class Delete extends TranslateRequest<com.google.api.services.translate.v3.model.Empty> {

            private static final String REST_PATH = "v3/{+name}";

            private final java.util.regex.Pattern NAME_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/adaptiveMtDatasets/[^/]+/adaptiveMtFiles/[^/]+$");

            /**
             * Deletes an AdaptiveMtFile along with its sentences.
             *
             * Create a request for the method "adaptiveMtFiles.delete".
             *
             * This request holds the parameters needed by the the translate server.  After setting any
             * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
             * <p> {@link
             * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
             * be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param name Required. The resource name of the file to delete, in form of `projects/{project-number-or-
           *        id}/locations/{location_id}/adaptiveMtDatasets/{dataset}/files/{file}`
             * @since 1.13
             */
            protected Delete(java.lang.String name) {
              super(Translate.this, "DELETE", REST_PATH, null, com.google.api.services.translate.v3.model.Empty.class);
              this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/adaptiveMtDatasets/[^/]+/adaptiveMtFiles/[^/]+$");
              }
            }

            @Override
            public Delete set$Xgafv(java.lang.String $Xgafv) {
              return (Delete) super.set$Xgafv($Xgafv);
            }

            @Override
            public Delete setAccessToken(java.lang.String accessToken) {
              return (Delete) super.setAccessToken(accessToken);
            }

            @Override
            public Delete setAlt(java.lang.String alt) {
              return (Delete) super.setAlt(alt);
            }

            @Override
            public Delete setCallback(java.lang.String callback) {
              return (Delete) super.setCallback(callback);
            }

            @Override
            public Delete setFields(java.lang.String fields) {
              return (Delete) super.setFields(fields);
            }

            @Override
            public Delete setKey(java.lang.String key) {
              return (Delete) super.setKey(key);
            }

            @Override
            public Delete setOauthToken(java.lang.String oauthToken) {
              return (Delete) super.setOauthToken(oauthToken);
            }

            @Override
            public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (Delete) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public Delete setQuotaUser(java.lang.String quotaUser) {
              return (Delete) super.setQuotaUser(quotaUser);
            }

            @Override
            public Delete setUploadType(java.lang.String uploadType) {
              return (Delete) super.setUploadType(uploadType);
            }

            @Override
            public Delete setUploadProtocol(java.lang.String uploadProtocol) {
              return (Delete) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * Required. The resource name of the file to delete, in form of `projects/{project-
             * number-or-id}/locations/{location_id}/adaptiveMtDatasets/{dataset}/files/{file}`
             */
            @com.google.api.client.util.Key
            private java.lang.String name;

            /** Required. The resource name of the file to delete, in form of `projects/{project-number-or-
           id}/locations/{location_id}/adaptiveMtDatasets/{dataset}/files/{file}`
             */
            public java.lang.String getName() {
              return name;
            }

            /**
             * Required. The resource name of the file to delete, in form of `projects/{project-
             * number-or-id}/locations/{location_id}/adaptiveMtDatasets/{dataset}/files/{file}`
             */
            public Delete setName(java.lang.String name) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/adaptiveMtDatasets/[^/]+/adaptiveMtFiles/[^/]+$");
              }
              this.name = name;
              return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
              return (Delete) super.set(parameterName, value);
            }
          }
          /**
           * Gets and AdaptiveMtFile
           *
           * Create a request for the method "adaptiveMtFiles.get".
           *
           * This request holds the parameters needed by the translate server.  After setting any optional
           * parameters, call the {@link Get#execute()} method to invoke the remote operation.
           *
           * @param name Required. The resource name of the file, in form of `projects/{project-number-or-
           *        id}/locations/{location_id}/adaptiveMtDatasets/{dataset}/files/{file}`
           * @return the request
           */
          public Get get(java.lang.String name) throws java.io.IOException {
            Get result = new Get(name);
            initialize(result);
            return result;
          }

          public class Get extends TranslateRequest<com.google.api.services.translate.v3.model.AdaptiveMtFile> {

            private static final String REST_PATH = "v3/{+name}";

            private final java.util.regex.Pattern NAME_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/adaptiveMtDatasets/[^/]+/adaptiveMtFiles/[^/]+$");

            /**
             * Gets and AdaptiveMtFile
             *
             * Create a request for the method "adaptiveMtFiles.get".
             *
             * This request holds the parameters needed by the the translate server.  After setting any
             * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
             * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
             * must be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param name Required. The resource name of the file, in form of `projects/{project-number-or-
           *        id}/locations/{location_id}/adaptiveMtDatasets/{dataset}/files/{file}`
             * @since 1.13
             */
            protected Get(java.lang.String name) {
              super(Translate.this, "GET", REST_PATH, null, com.google.api.services.translate.v3.model.AdaptiveMtFile.class);
              this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/adaptiveMtDatasets/[^/]+/adaptiveMtFiles/[^/]+$");
              }
            }

            @Override
            public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
              return super.executeUsingHead();
            }

            @Override
            public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
              return super.buildHttpRequestUsingHead();
            }

            @Override
            public Get set$Xgafv(java.lang.String $Xgafv) {
              return (Get) super.set$Xgafv($Xgafv);
            }

            @Override
            public Get setAccessToken(java.lang.String accessToken) {
              return (Get) super.setAccessToken(accessToken);
            }

            @Override
            public Get setAlt(java.lang.String alt) {
              return (Get) super.setAlt(alt);
            }

            @Override
            public Get setCallback(java.lang.String callback) {
              return (Get) super.setCallback(callback);
            }

            @Override
            public Get setFields(java.lang.String fields) {
              return (Get) super.setFields(fields);
            }

            @Override
            public Get setKey(java.lang.String key) {
              return (Get) super.setKey(key);
            }

            @Override
            public Get setOauthToken(java.lang.String oauthToken) {
              return (Get) super.setOauthToken(oauthToken);
            }

            @Override
            public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (Get) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public Get setQuotaUser(java.lang.String quotaUser) {
              return (Get) super.setQuotaUser(quotaUser);
            }

            @Override
            public Get setUploadType(java.lang.String uploadType) {
              return (Get) super.setUploadType(uploadType);
            }

            @Override
            public Get setUploadProtocol(java.lang.String uploadProtocol) {
              return (Get) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * Required. The resource name of the file, in form of `projects/{project-number-or-
             * id}/locations/{location_id}/adaptiveMtDatasets/{dataset}/files/{file}`
             */
            @com.google.api.client.util.Key
            private java.lang.String name;

            /** Required. The resource name of the file, in form of `projects/{project-number-or-
           id}/locations/{location_id}/adaptiveMtDatasets/{dataset}/files/{file}`
             */
            public java.lang.String getName() {
              return name;
            }

            /**
             * Required. The resource name of the file, in form of `projects/{project-number-or-
             * id}/locations/{location_id}/adaptiveMtDatasets/{dataset}/files/{file}`
             */
            public Get setName(java.lang.String name) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/adaptiveMtDatasets/[^/]+/adaptiveMtFiles/[^/]+$");
              }
              this.name = name;
              return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
              return (Get) super.set(parameterName, value);
            }
          }
          /**
           * Lists all AdaptiveMtFiles associated to an AdaptiveMtDataset.
           *
           * Create a request for the method "adaptiveMtFiles.list".
           *
           * This request holds the parameters needed by the translate server.  After setting any optional
           * parameters, call the {@link List#execute()} method to invoke the remote operation.
           *
           * @param parent Required. The resource name of the project from which to list the Adaptive MT files.
           *        `projects/{project}/locations/{location}/adaptiveMtDatasets/{dataset}`
           * @return the request
           */
          public List list(java.lang.String parent) throws java.io.IOException {
            List result = new List(parent);
            initialize(result);
            return result;
          }

          public class List extends TranslateRequest<com.google.api.services.translate.v3.model.ListAdaptiveMtFilesResponse> {

            private static final String REST_PATH = "v3/{+parent}/adaptiveMtFiles";

            private final java.util.regex.Pattern PARENT_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/adaptiveMtDatasets/[^/]+$");

            /**
             * Lists all AdaptiveMtFiles associated to an AdaptiveMtDataset.
             *
             * Create a request for the method "adaptiveMtFiles.list".
             *
             * This request holds the parameters needed by the the translate server.  After setting any
             * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
             * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
             * must be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param parent Required. The resource name of the project from which to list the Adaptive MT files.
           *        `projects/{project}/locations/{location}/adaptiveMtDatasets/{dataset}`
             * @since 1.13
             */
            protected List(java.lang.String parent) {
              super(Translate.this, "GET", REST_PATH, null, com.google.api.services.translate.v3.model.ListAdaptiveMtFilesResponse.class);
              this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                    "Parameter parent must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/adaptiveMtDatasets/[^/]+$");
              }
            }

            @Override
            public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
              return super.executeUsingHead();
            }

            @Override
            public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
              return super.buildHttpRequestUsingHead();
            }

            @Override
            public List set$Xgafv(java.lang.String $Xgafv) {
              return (List) super.set$Xgafv($Xgafv);
            }

            @Override
            public List setAccessToken(java.lang.String accessToken) {
              return (List) super.setAccessToken(accessToken);
            }

            @Override
            public List setAlt(java.lang.String alt) {
              return (List) super.setAlt(alt);
            }

            @Override
            public List setCallback(java.lang.String callback) {
              return (List) super.setCallback(callback);
            }

            @Override
            public List setFields(java.lang.String fields) {
              return (List) super.setFields(fields);
            }

            @Override
            public List setKey(java.lang.String key) {
              return (List) super.setKey(key);
            }

            @Override
            public List setOauthToken(java.lang.String oauthToken) {
              return (List) super.setOauthToken(oauthToken);
            }

            @Override
            public List setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (List) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public List setQuotaUser(java.lang.String quotaUser) {
              return (List) super.setQuotaUser(quotaUser);
            }

            @Override
            public List setUploadType(java.lang.String uploadType) {
              return (List) super.setUploadType(uploadType);
            }

            @Override
            public List setUploadProtocol(java.lang.String uploadProtocol) {
              return (List) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * Required. The resource name of the project from which to list the Adaptive MT files.
             * `projects/{project}/locations/{location}/adaptiveMtDatasets/{dataset}`
             */
            @com.google.api.client.util.Key
            private java.lang.String parent;

            /** Required. The resource name of the project from which to list the Adaptive MT files.
           `projects/{project}/locations/{location}/adaptiveMtDatasets/{dataset}`
             */
            public java.lang.String getParent() {
              return parent;
            }

            /**
             * Required. The resource name of the project from which to list the Adaptive MT files.
             * `projects/{project}/locations/{location}/adaptiveMtDatasets/{dataset}`
             */
            public List setParent(java.lang.String parent) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                    "Parameter parent must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/adaptiveMtDatasets/[^/]+$");
              }
              this.parent = parent;
              return this;
            }

            /** Optional.  */
            @com.google.api.client.util.Key
            private java.lang.Integer pageSize;

            /** Optional.
             */
            public java.lang.Integer getPageSize() {
              return pageSize;
            }

            /** Optional.  */
            public List setPageSize(java.lang.Integer pageSize) {
              this.pageSize = pageSize;
              return this;
            }

            /**
             * Optional. A token identifying a page of results the server should return. Typically,
             * this is the value of ListAdaptiveMtFilesResponse.next_page_token returned from the
             * previous call to `ListAdaptiveMtFiles` method. The first page is returned if
             * `page_token`is empty or missing.
             */
            @com.google.api.client.util.Key
            private java.lang.String pageToken;

            /** Optional. A token identifying a page of results the server should return. Typically, this is the
           value of ListAdaptiveMtFilesResponse.next_page_token returned from the previous call to
           `ListAdaptiveMtFiles` method. The first page is returned if `page_token`is empty or missing.
             */
            public java.lang.String getPageToken() {
              return pageToken;
            }

            /**
             * Optional. A token identifying a page of results the server should return. Typically,
             * this is the value of ListAdaptiveMtFilesResponse.next_page_token returned from the
             * previous call to `ListAdaptiveMtFiles` method. The first page is returned if
             * `page_token`is empty or missing.
             */
            public List setPageToken(java.lang.String pageToken) {
              this.pageToken = pageToken;
              return this;
            }

            @Override
            public List set(String parameterName, Object value) {
              return (List) super.set(parameterName, value);
            }
          }

          /**
           * An accessor for creating requests from the AdaptiveMtSentences collection.
           *
           * <p>The typical use is:</p>
           * <pre>
           *   {@code Translate translate = new Translate(...);}
           *   {@code Translate.AdaptiveMtSentences.List request = translate.adaptiveMtSentences().list(parameters ...)}
           * </pre>
           *
           * @return the resource collection
           */
          public AdaptiveMtSentences adaptiveMtSentences() {
            return new AdaptiveMtSentences();
          }

          /**
           * The "adaptiveMtSentences" collection of methods.
           */
          public class AdaptiveMtSentences {

            /**
             * Lists all AdaptiveMtSentences under a given file/dataset.
             *
             * Create a request for the method "adaptiveMtSentences.list".
             *
             * This request holds the parameters needed by the translate server.  After setting any optional
             * parameters, call the {@link List#execute()} method to invoke the remote operation.
             *
             * @param parent Required. The resource name of the project from which to list the Adaptive MT files. The following
             *        format lists all sentences under a file. `projects/{project}/locations/{location}/adaptive
             *        MtDatasets/{dataset}/adaptiveMtFiles/{file}` The following format lists all sentences
             *        within a dataset. `projects/{project}/locations/{location}/adaptiveMtDatasets/{dataset}`
             * @return the request
             */
            public List list(java.lang.String parent) throws java.io.IOException {
              List result = new List(parent);
              initialize(result);
              return result;
            }

            public class List extends TranslateRequest<com.google.api.services.translate.v3.model.ListAdaptiveMtSentencesResponse> {

              private static final String REST_PATH = "v3/{+parent}/adaptiveMtSentences";

              private final java.util.regex.Pattern PARENT_PATTERN =
                  java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/adaptiveMtDatasets/[^/]+/adaptiveMtFiles/[^/]+$");

              /**
               * Lists all AdaptiveMtSentences under a given file/dataset.
               *
               * Create a request for the method "adaptiveMtSentences.list".
               *
               * This request holds the parameters needed by the the translate server.  After setting any
               * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
               * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
               * must be called to initialize this instance immediately after invoking the constructor. </p>
               *
               * @param parent Required. The resource name of the project from which to list the Adaptive MT files. The following
             *        format lists all sentences under a file. `projects/{project}/locations/{location}/adaptive
             *        MtDatasets/{dataset}/adaptiveMtFiles/{file}` The following format lists all sentences
             *        within a dataset. `projects/{project}/locations/{location}/adaptiveMtDatasets/{dataset}`
               * @since 1.13
               */
              protected List(java.lang.String parent) {
                super(Translate.this, "GET", REST_PATH, null, com.google.api.services.translate.v3.model.ListAdaptiveMtSentencesResponse.class);
                this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                      "Parameter parent must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/adaptiveMtDatasets/[^/]+/adaptiveMtFiles/[^/]+$");
                }
              }

              @Override
              public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
                return super.executeUsingHead();
              }

              @Override
              public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
                return super.buildHttpRequestUsingHead();
              }

              @Override
              public List set$Xgafv(java.lang.String $Xgafv) {
                return (List) super.set$Xgafv($Xgafv);
              }

              @Override
              public List setAccessToken(java.lang.String accessToken) {
                return (List) super.setAccessToken(accessToken);
              }

              @Override
              public List setAlt(java.lang.String alt) {
                return (List) super.setAlt(alt);
              }

              @Override
              public List setCallback(java.lang.String callback) {
                return (List) super.setCallback(callback);
              }

              @Override
              public List setFields(java.lang.String fields) {
                return (List) super.setFields(fields);
              }

              @Override
              public List setKey(java.lang.String key) {
                return (List) super.setKey(key);
              }

              @Override
              public List setOauthToken(java.lang.String oauthToken) {
                return (List) super.setOauthToken(oauthToken);
              }

              @Override
              public List setPrettyPrint(java.lang.Boolean prettyPrint) {
                return (List) super.setPrettyPrint(prettyPrint);
              }

              @Override
              public List setQuotaUser(java.lang.String quotaUser) {
                return (List) super.setQuotaUser(quotaUser);
              }

              @Override
              public List setUploadType(java.lang.String uploadType) {
                return (List) super.setUploadType(uploadType);
              }

              @Override
              public List setUploadProtocol(java.lang.String uploadProtocol) {
                return (List) super.setUploadProtocol(uploadProtocol);
              }

              /**
               * Required. The resource name of the project from which to list the Adaptive MT
               * files. The following format lists all sentences under a file. `projects/{project}/l
               * ocations/{location}/adaptiveMtDatasets/{dataset}/adaptiveMtFiles/{file}` The
               * following format lists all sentences within a dataset.
               * `projects/{project}/locations/{location}/adaptiveMtDatasets/{dataset}`
               */
              @com.google.api.client.util.Key
              private java.lang.String parent;

              /** Required. The resource name of the project from which to list the Adaptive MT files. The following
             format lists all sentences under a file.
             `projects/{project}/locations/{location}/adaptiveMtDatasets/{dataset}/adaptiveMtFiles/{file}` The
             following format lists all sentences within a dataset.
             `projects/{project}/locations/{location}/adaptiveMtDatasets/{dataset}`
               */
              public java.lang.String getParent() {
                return parent;
              }

              /**
               * Required. The resource name of the project from which to list the Adaptive MT
               * files. The following format lists all sentences under a file. `projects/{project}/l
               * ocations/{location}/adaptiveMtDatasets/{dataset}/adaptiveMtFiles/{file}` The
               * following format lists all sentences within a dataset.
               * `projects/{project}/locations/{location}/adaptiveMtDatasets/{dataset}`
               */
              public List setParent(java.lang.String parent) {
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                      "Parameter parent must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/adaptiveMtDatasets/[^/]+/adaptiveMtFiles/[^/]+$");
                }
                this.parent = parent;
                return this;
              }

              @com.google.api.client.util.Key
              private java.lang.Integer pageSize;

              /**

               */
              public java.lang.Integer getPageSize() {
                return pageSize;
              }

              public List setPageSize(java.lang.Integer pageSize) {
                this.pageSize = pageSize;
                return this;
              }

              /**
               * A token identifying a page of results the server should return. Typically, this is
               * the value of ListAdaptiveMtSentencesRequest.next_page_token returned from the
               * previous call to `ListTranslationMemories` method. The first page is returned if
               * `page_token` is empty or missing.
               */
              @com.google.api.client.util.Key
              private java.lang.String pageToken;

              /** A token identifying a page of results the server should return. Typically, this is the value of
             ListAdaptiveMtSentencesRequest.next_page_token returned from the previous call to
             `ListTranslationMemories` method. The first page is returned if `page_token` is empty or missing.
               */
              public java.lang.String getPageToken() {
                return pageToken;
              }

              /**
               * A token identifying a page of results the server should return. Typically, this is
               * the value of ListAdaptiveMtSentencesRequest.next_page_token returned from the
               * previous call to `ListTranslationMemories` method. The first page is returned if
               * `page_token` is empty or missing.
               */
              public List setPageToken(java.lang.String pageToken) {
                this.pageToken = pageToken;
                return this;
              }

              @Override
              public List set(String parameterName, Object value) {
                return (List) super.set(parameterName, value);
              }
            }

          }
        }
        /**
         * An accessor for creating requests from the AdaptiveMtSentences collection.
         *
         * <p>The typical use is:</p>
         * <pre>
         *   {@code Translate translate = new Translate(...);}
         *   {@code Translate.AdaptiveMtSentences.List request = translate.adaptiveMtSentences().list(parameters ...)}
         * </pre>
         *
         * @return the resource collection
         */
        public AdaptiveMtSentences adaptiveMtSentences() {
          return new AdaptiveMtSentences();
        }

        /**
         * The "adaptiveMtSentences" collection of methods.
         */
        public class AdaptiveMtSentences {

          /**
           * Lists all AdaptiveMtSentences under a given file/dataset.
           *
           * Create a request for the method "adaptiveMtSentences.list".
           *
           * This request holds the parameters needed by the translate server.  After setting any optional
           * parameters, call the {@link List#execute()} method to invoke the remote operation.
           *
           * @param parent Required. The resource name of the project from which to list the Adaptive MT files. The following
           *        format lists all sentences under a file. `projects/{project}/locations/{location}/adaptive
           *        MtDatasets/{dataset}/adaptiveMtFiles/{file}` The following format lists all sentences
           *        within a dataset. `projects/{project}/locations/{location}/adaptiveMtDatasets/{dataset}`
           * @return the request
           */
          public List list(java.lang.String parent) throws java.io.IOException {
            List result = new List(parent);
            initialize(result);
            return result;
          }

          public class List extends TranslateRequest<com.google.api.services.translate.v3.model.ListAdaptiveMtSentencesResponse> {

            private static final String REST_PATH = "v3/{+parent}/adaptiveMtSentences";

            private final java.util.regex.Pattern PARENT_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/adaptiveMtDatasets/[^/]+$");

            /**
             * Lists all AdaptiveMtSentences under a given file/dataset.
             *
             * Create a request for the method "adaptiveMtSentences.list".
             *
             * This request holds the parameters needed by the the translate server.  After setting any
             * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
             * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
             * must be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param parent Required. The resource name of the project from which to list the Adaptive MT files. The following
           *        format lists all sentences under a file. `projects/{project}/locations/{location}/adaptive
           *        MtDatasets/{dataset}/adaptiveMtFiles/{file}` The following format lists all sentences
           *        within a dataset. `projects/{project}/locations/{location}/adaptiveMtDatasets/{dataset}`
             * @since 1.13
             */
            protected List(java.lang.String parent) {
              super(Translate.this, "GET", REST_PATH, null, com.google.api.services.translate.v3.model.ListAdaptiveMtSentencesResponse.class);
              this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                    "Parameter parent must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/adaptiveMtDatasets/[^/]+$");
              }
            }

            @Override
            public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
              return super.executeUsingHead();
            }

            @Override
            public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
              return super.buildHttpRequestUsingHead();
            }

            @Override
            public List set$Xgafv(java.lang.String $Xgafv) {
              return (List) super.set$Xgafv($Xgafv);
            }

            @Override
            public List setAccessToken(java.lang.String accessToken) {
              return (List) super.setAccessToken(accessToken);
            }

            @Override
            public List setAlt(java.lang.String alt) {
              return (List) super.setAlt(alt);
            }

            @Override
            public List setCallback(java.lang.String callback) {
              return (List) super.setCallback(callback);
            }

            @Override
            public List setFields(java.lang.String fields) {
              return (List) super.setFields(fields);
            }

            @Override
            public List setKey(java.lang.String key) {
              return (List) super.setKey(key);
            }

            @Override
            public List setOauthToken(java.lang.String oauthToken) {
              return (List) super.setOauthToken(oauthToken);
            }

            @Override
            public List setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (List) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public List setQuotaUser(java.lang.String quotaUser) {
              return (List) super.setQuotaUser(quotaUser);
            }

            @Override
            public List setUploadType(java.lang.String uploadType) {
              return (List) super.setUploadType(uploadType);
            }

            @Override
            public List setUploadProtocol(java.lang.String uploadProtocol) {
              return (List) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * Required. The resource name of the project from which to list the Adaptive MT files.
             * The following format lists all sentences under a file. `projects/{project}/locations/
             * {location}/adaptiveMtDatasets/{dataset}/adaptiveMtFiles/{file}` The following format
             * lists all sentences within a dataset.
             * `projects/{project}/locations/{location}/adaptiveMtDatasets/{dataset}`
             */
            @com.google.api.client.util.Key
            private java.lang.String parent;

            /** Required. The resource name of the project from which to list the Adaptive MT files. The following
           format lists all sentences under a file.
           `projects/{project}/locations/{location}/adaptiveMtDatasets/{dataset}/adaptiveMtFiles/{file}` The
           following format lists all sentences within a dataset.
           `projects/{project}/locations/{location}/adaptiveMtDatasets/{dataset}`
             */
            public java.lang.String getParent() {
              return parent;
            }

            /**
             * Required. The resource name of the project from which to list the Adaptive MT files.
             * The following format lists all sentences under a file. `projects/{project}/locations/
             * {location}/adaptiveMtDatasets/{dataset}/adaptiveMtFiles/{file}` The following format
             * lists all sentences within a dataset.
             * `projects/{project}/locations/{location}/adaptiveMtDatasets/{dataset}`
             */
            public List setParent(java.lang.String parent) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                    "Parameter parent must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/adaptiveMtDatasets/[^/]+$");
              }
              this.parent = parent;
              return this;
            }

            @com.google.api.client.util.Key
            private java.lang.Integer pageSize;

            /**

             */
            public java.lang.Integer getPageSize() {
              return pageSize;
            }

            public List setPageSize(java.lang.Integer pageSize) {
              this.pageSize = pageSize;
              return this;
            }

            /**
             * A token identifying a page of results the server should return. Typically, this is
             * the value of ListAdaptiveMtSentencesRequest.next_page_token returned from the
             * previous call to `ListTranslationMemories` method. The first page is returned if
             * `page_token` is empty or missing.
             */
            @com.google.api.client.util.Key
            private java.lang.String pageToken;

            /** A token identifying a page of results the server should return. Typically, this is the value of
           ListAdaptiveMtSentencesRequest.next_page_token returned from the previous call to
           `ListTranslationMemories` method. The first page is returned if `page_token` is empty or missing.
             */
            public java.lang.String getPageToken() {
              return pageToken;
            }

            /**
             * A token identifying a page of results the server should return. Typically, this is
             * the value of ListAdaptiveMtSentencesRequest.next_page_token returned from the
             * previous call to `ListTranslationMemories` method. The first page is returned if
             * `page_token` is empty or missing.
             */
            public List setPageToken(java.lang.String pageToken) {
              this.pageToken = pageToken;
              return this;
            }

            @Override
            public List set(String parameterName, Object value) {
              return (List) super.set(parameterName, value);
            }
          }

        }
      }
      /**
       * An accessor for creating requests from the Datasets collection.
       *
       * <p>The typical use is:</p>
       * <pre>
       *   {@code Translate translate = new Translate(...);}
       *   {@code Translate.Datasets.List request = translate.datasets().list(parameters ...)}
       * </pre>
       *
       * @return the resource collection
       */
      public Datasets datasets() {
        return new Datasets();
      }

      /**
       * The "datasets" collection of methods.
       */
      public class Datasets {

        /**
         * Creates a Dataset.
         *
         * Create a request for the method "datasets.create".
         *
         * This request holds the parameters needed by the translate server.  After setting any optional
         * parameters, call the {@link Create#execute()} method to invoke the remote operation.
         *
         * @param parent Required. The project name.
         * @param content the {@link com.google.api.services.translate.v3.model.Dataset}
         * @return the request
         */
        public Create create(java.lang.String parent, com.google.api.services.translate.v3.model.Dataset content) throws java.io.IOException {
          Create result = new Create(parent, content);
          initialize(result);
          return result;
        }

        public class Create extends TranslateRequest<com.google.api.services.translate.v3.model.Operation> {

          private static final String REST_PATH = "v3/{+parent}/datasets";

          private final java.util.regex.Pattern PARENT_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+$");

          /**
           * Creates a Dataset.
           *
           * Create a request for the method "datasets.create".
           *
           * This request holds the parameters needed by the the translate server.  After setting any
           * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
           * <p> {@link
           * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param parent Required. The project name.
           * @param content the {@link com.google.api.services.translate.v3.model.Dataset}
           * @since 1.13
           */
          protected Create(java.lang.String parent, com.google.api.services.translate.v3.model.Dataset content) {
            super(Translate.this, "POST", REST_PATH, content, com.google.api.services.translate.v3.model.Operation.class);
            this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
          }

          @Override
          public Create set$Xgafv(java.lang.String $Xgafv) {
            return (Create) super.set$Xgafv($Xgafv);
          }

          @Override
          public Create setAccessToken(java.lang.String accessToken) {
            return (Create) super.setAccessToken(accessToken);
          }

          @Override
          public Create setAlt(java.lang.String alt) {
            return (Create) super.setAlt(alt);
          }

          @Override
          public Create setCallback(java.lang.String callback) {
            return (Create) super.setCallback(callback);
          }

          @Override
          public Create setFields(java.lang.String fields) {
            return (Create) super.setFields(fields);
          }

          @Override
          public Create setKey(java.lang.String key) {
            return (Create) super.setKey(key);
          }

          @Override
          public Create setOauthToken(java.lang.String oauthToken) {
            return (Create) super.setOauthToken(oauthToken);
          }

          @Override
          public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Create) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Create setQuotaUser(java.lang.String quotaUser) {
            return (Create) super.setQuotaUser(quotaUser);
          }

          @Override
          public Create setUploadType(java.lang.String uploadType) {
            return (Create) super.setUploadType(uploadType);
          }

          @Override
          public Create setUploadProtocol(java.lang.String uploadProtocol) {
            return (Create) super.setUploadProtocol(uploadProtocol);
          }

          /** Required. The project name. */
          @com.google.api.client.util.Key
          private java.lang.String parent;

          /** Required. The project name.
           */
          public java.lang.String getParent() {
            return parent;
          }

          /** Required. The project name. */
          public Create setParent(java.lang.String parent) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
            this.parent = parent;
            return this;
          }

          @Override
          public Create set(String parameterName, Object value) {
            return (Create) super.set(parameterName, value);
          }
        }
        /**
         * Deletes a dataset and all of its contents.
         *
         * Create a request for the method "datasets.delete".
         *
         * This request holds the parameters needed by the translate server.  After setting any optional
         * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
         *
         * @param name Required. The name of the dataset to delete.
         * @return the request
         */
        public Delete delete(java.lang.String name) throws java.io.IOException {
          Delete result = new Delete(name);
          initialize(result);
          return result;
        }

        public class Delete extends TranslateRequest<com.google.api.services.translate.v3.model.Operation> {

          private static final String REST_PATH = "v3/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");

          /**
           * Deletes a dataset and all of its contents.
           *
           * Create a request for the method "datasets.delete".
           *
           * This request holds the parameters needed by the the translate server.  After setting any
           * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
           * <p> {@link
           * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name Required. The name of the dataset to delete.
           * @since 1.13
           */
          protected Delete(java.lang.String name) {
            super(Translate.this, "DELETE", REST_PATH, null, com.google.api.services.translate.v3.model.Operation.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
            }
          }

          @Override
          public Delete set$Xgafv(java.lang.String $Xgafv) {
            return (Delete) super.set$Xgafv($Xgafv);
          }

          @Override
          public Delete setAccessToken(java.lang.String accessToken) {
            return (Delete) super.setAccessToken(accessToken);
          }

          @Override
          public Delete setAlt(java.lang.String alt) {
            return (Delete) super.setAlt(alt);
          }

          @Override
          public Delete setCallback(java.lang.String callback) {
            return (Delete) super.setCallback(callback);
          }

          @Override
          public Delete setFields(java.lang.String fields) {
            return (Delete) super.setFields(fields);
          }

          @Override
          public Delete setKey(java.lang.String key) {
            return (Delete) super.setKey(key);
          }

          @Override
          public Delete setOauthToken(java.lang.String oauthToken) {
            return (Delete) super.setOauthToken(oauthToken);
          }

          @Override
          public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Delete) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Delete setQuotaUser(java.lang.String quotaUser) {
            return (Delete) super.setQuotaUser(quotaUser);
          }

          @Override
          public Delete setUploadType(java.lang.String uploadType) {
            return (Delete) super.setUploadType(uploadType);
          }

          @Override
          public Delete setUploadProtocol(java.lang.String uploadProtocol) {
            return (Delete) super.setUploadProtocol(uploadProtocol);
          }

          /** Required. The name of the dataset to delete. */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Required. The name of the dataset to delete.
           */
          public java.lang.String getName() {
            return name;
          }

          /** Required. The name of the dataset to delete. */
          public Delete setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Delete set(String parameterName, Object value) {
            return (Delete) super.set(parameterName, value);
          }
        }
        /**
         * Exports dataset's data to the provided output location.
         *
         * Create a request for the method "datasets.exportData".
         *
         * This request holds the parameters needed by the translate server.  After setting any optional
         * parameters, call the {@link ExportData#execute()} method to invoke the remote operation.
         *
         * @param dataset Required. Name of the dataset. In form of `projects/{project-number-or-id}/locations/{location-
         *        id}/datasets/{dataset-id}`
         * @param content the {@link com.google.api.services.translate.v3.model.ExportDataRequest}
         * @return the request
         */
        public ExportData exportData(java.lang.String dataset, com.google.api.services.translate.v3.model.ExportDataRequest content) throws java.io.IOException {
          ExportData result = new ExportData(dataset, content);
          initialize(result);
          return result;
        }

        public class ExportData extends TranslateRequest<com.google.api.services.translate.v3.model.Operation> {

          private static final String REST_PATH = "v3/{+dataset}:exportData";

          private final java.util.regex.Pattern DATASET_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");

          /**
           * Exports dataset's data to the provided output location.
           *
           * Create a request for the method "datasets.exportData".
           *
           * This request holds the parameters needed by the the translate server.  After setting any
           * optional parameters, call the {@link ExportData#execute()} method to invoke the remote
           * operation. <p> {@link
           * ExportData#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param dataset Required. Name of the dataset. In form of `projects/{project-number-or-id}/locations/{location-
         *        id}/datasets/{dataset-id}`
           * @param content the {@link com.google.api.services.translate.v3.model.ExportDataRequest}
           * @since 1.13
           */
          protected ExportData(java.lang.String dataset, com.google.api.services.translate.v3.model.ExportDataRequest content) {
            super(Translate.this, "POST", REST_PATH, content, com.google.api.services.translate.v3.model.Operation.class);
            this.dataset = com.google.api.client.util.Preconditions.checkNotNull(dataset, "Required parameter dataset must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(DATASET_PATTERN.matcher(dataset).matches(),
                  "Parameter dataset must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
            }
          }

          @Override
          public ExportData set$Xgafv(java.lang.String $Xgafv) {
            return (ExportData) super.set$Xgafv($Xgafv);
          }

          @Override
          public ExportData setAccessToken(java.lang.String accessToken) {
            return (ExportData) super.setAccessToken(accessToken);
          }

          @Override
          public ExportData setAlt(java.lang.String alt) {
            return (ExportData) super.setAlt(alt);
          }

          @Override
          public ExportData setCallback(java.lang.String callback) {
            return (ExportData) super.setCallback(callback);
          }

          @Override
          public ExportData setFields(java.lang.String fields) {
            return (ExportData) super.setFields(fields);
          }

          @Override
          public ExportData setKey(java.lang.String key) {
            return (ExportData) super.setKey(key);
          }

          @Override
          public ExportData setOauthToken(java.lang.String oauthToken) {
            return (ExportData) super.setOauthToken(oauthToken);
          }

          @Override
          public ExportData setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (ExportData) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public ExportData setQuotaUser(java.lang.String quotaUser) {
            return (ExportData) super.setQuotaUser(quotaUser);
          }

          @Override
          public ExportData setUploadType(java.lang.String uploadType) {
            return (ExportData) super.setUploadType(uploadType);
          }

          @Override
          public ExportData setUploadProtocol(java.lang.String uploadProtocol) {
            return (ExportData) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. Name of the dataset. In form of `projects/{project-number-or-id}/locations
           * /{location-id}/datasets/{dataset-id}`
           */
          @com.google.api.client.util.Key
          private java.lang.String dataset;

          /** Required. Name of the dataset. In form of `projects/{project-number-or-id}/locations/{location-
         id}/datasets/{dataset-id}`
           */
          public java.lang.String getDataset() {
            return dataset;
          }

          /**
           * Required. Name of the dataset. In form of `projects/{project-number-or-id}/locations
           * /{location-id}/datasets/{dataset-id}`
           */
          public ExportData setDataset(java.lang.String dataset) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(DATASET_PATTERN.matcher(dataset).matches(),
                  "Parameter dataset must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
            }
            this.dataset = dataset;
            return this;
          }

          @Override
          public ExportData set(String parameterName, Object value) {
            return (ExportData) super.set(parameterName, value);
          }
        }
        /**
         * Gets a Dataset.
         *
         * Create a request for the method "datasets.get".
         *
         * This request holds the parameters needed by the translate server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation.
         *
         * @param name Required. The resource name of the dataset to retrieve.
         * @return the request
         */
        public Get get(java.lang.String name) throws java.io.IOException {
          Get result = new Get(name);
          initialize(result);
          return result;
        }

        public class Get extends TranslateRequest<com.google.api.services.translate.v3.model.Dataset> {

          private static final String REST_PATH = "v3/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");

          /**
           * Gets a Dataset.
           *
           * Create a request for the method "datasets.get".
           *
           * This request holds the parameters needed by the the translate server.  After setting any
           * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
           * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name Required. The resource name of the dataset to retrieve.
           * @since 1.13
           */
          protected Get(java.lang.String name) {
            super(Translate.this, "GET", REST_PATH, null, com.google.api.services.translate.v3.model.Dataset.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public Get set$Xgafv(java.lang.String $Xgafv) {
            return (Get) super.set$Xgafv($Xgafv);
          }

          @Override
          public Get setAccessToken(java.lang.String accessToken) {
            return (Get) super.setAccessToken(accessToken);
          }

          @Override
          public Get setAlt(java.lang.String alt) {
            return (Get) super.setAlt(alt);
          }

          @Override
          public Get setCallback(java.lang.String callback) {
            return (Get) super.setCallback(callback);
          }

          @Override
          public Get setFields(java.lang.String fields) {
            return (Get) super.setFields(fields);
          }

          @Override
          public Get setKey(java.lang.String key) {
            return (Get) super.setKey(key);
          }

          @Override
          public Get setOauthToken(java.lang.String oauthToken) {
            return (Get) super.setOauthToken(oauthToken);
          }

          @Override
          public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Get) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Get setQuotaUser(java.lang.String quotaUser) {
            return (Get) super.setQuotaUser(quotaUser);
          }

          @Override
          public Get setUploadType(java.lang.String uploadType) {
            return (Get) super.setUploadType(uploadType);
          }

          @Override
          public Get setUploadProtocol(java.lang.String uploadProtocol) {
            return (Get) super.setUploadProtocol(uploadProtocol);
          }

          /** Required. The resource name of the dataset to retrieve. */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Required. The resource name of the dataset to retrieve.
           */
          public java.lang.String getName() {
            return name;
          }

          /** Required. The resource name of the dataset to retrieve. */
          public Get setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Get set(String parameterName, Object value) {
            return (Get) super.set(parameterName, value);
          }
        }
        /**
         * Import sentence pairs into translation Dataset.
         *
         * Create a request for the method "datasets.importData".
         *
         * This request holds the parameters needed by the translate server.  After setting any optional
         * parameters, call the {@link ImportData#execute()} method to invoke the remote operation.
         *
         * @param dataset Required. Name of the dataset. In form of `projects/{project-number-or-id}/locations/{location-
         *        id}/datasets/{dataset-id}`
         * @param content the {@link com.google.api.services.translate.v3.model.ImportDataRequest}
         * @return the request
         */
        public ImportData importData(java.lang.String dataset, com.google.api.services.translate.v3.model.ImportDataRequest content) throws java.io.IOException {
          ImportData result = new ImportData(dataset, content);
          initialize(result);
          return result;
        }

        public class ImportData extends TranslateRequest<com.google.api.services.translate.v3.model.Operation> {

          private static final String REST_PATH = "v3/{+dataset}:importData";

          private final java.util.regex.Pattern DATASET_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");

          /**
           * Import sentence pairs into translation Dataset.
           *
           * Create a request for the method "datasets.importData".
           *
           * This request holds the parameters needed by the the translate server.  After setting any
           * optional parameters, call the {@link ImportData#execute()} method to invoke the remote
           * operation. <p> {@link
           * ImportData#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param dataset Required. Name of the dataset. In form of `projects/{project-number-or-id}/locations/{location-
         *        id}/datasets/{dataset-id}`
           * @param content the {@link com.google.api.services.translate.v3.model.ImportDataRequest}
           * @since 1.13
           */
          protected ImportData(java.lang.String dataset, com.google.api.services.translate.v3.model.ImportDataRequest content) {
            super(Translate.this, "POST", REST_PATH, content, com.google.api.services.translate.v3.model.Operation.class);
            this.dataset = com.google.api.client.util.Preconditions.checkNotNull(dataset, "Required parameter dataset must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(DATASET_PATTERN.matcher(dataset).matches(),
                  "Parameter dataset must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
            }
          }

          @Override
          public ImportData set$Xgafv(java.lang.String $Xgafv) {
            return (ImportData) super.set$Xgafv($Xgafv);
          }

          @Override
          public ImportData setAccessToken(java.lang.String accessToken) {
            return (ImportData) super.setAccessToken(accessToken);
          }

          @Override
          public ImportData setAlt(java.lang.String alt) {
            return (ImportData) super.setAlt(alt);
          }

          @Override
          public ImportData setCallback(java.lang.String callback) {
            return (ImportData) super.setCallback(callback);
          }

          @Override
          public ImportData setFields(java.lang.String fields) {
            return (ImportData) super.setFields(fields);
          }

          @Override
          public ImportData setKey(java.lang.String key) {
            return (ImportData) super.setKey(key);
          }

          @Override
          public ImportData setOauthToken(java.lang.String oauthToken) {
            return (ImportData) super.setOauthToken(oauthToken);
          }

          @Override
          public ImportData setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (ImportData) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public ImportData setQuotaUser(java.lang.String quotaUser) {
            return (ImportData) super.setQuotaUser(quotaUser);
          }

          @Override
          public ImportData setUploadType(java.lang.String uploadType) {
            return (ImportData) super.setUploadType(uploadType);
          }

          @Override
          public ImportData setUploadProtocol(java.lang.String uploadProtocol) {
            return (ImportData) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. Name of the dataset. In form of `projects/{project-number-or-id}/locations
           * /{location-id}/datasets/{dataset-id}`
           */
          @com.google.api.client.util.Key
          private java.lang.String dataset;

          /** Required. Name of the dataset. In form of `projects/{project-number-or-id}/locations/{location-
         id}/datasets/{dataset-id}`
           */
          public java.lang.String getDataset() {
            return dataset;
          }

          /**
           * Required. Name of the dataset. In form of `projects/{project-number-or-id}/locations
           * /{location-id}/datasets/{dataset-id}`
           */
          public ImportData setDataset(java.lang.String dataset) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(DATASET_PATTERN.matcher(dataset).matches(),
                  "Parameter dataset must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
            }
            this.dataset = dataset;
            return this;
          }

          @Override
          public ImportData set(String parameterName, Object value) {
            return (ImportData) super.set(parameterName, value);
          }
        }
        /**
         * Lists datasets.
         *
         * Create a request for the method "datasets.list".
         *
         * This request holds the parameters needed by the translate server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation.
         *
         * @param parent Required. Name of the parent project. In form of `projects/{project-number-or-id}/locations
         *        /{location-id}`
         * @return the request
         */
        public List list(java.lang.String parent) throws java.io.IOException {
          List result = new List(parent);
          initialize(result);
          return result;
        }

        public class List extends TranslateRequest<com.google.api.services.translate.v3.model.ListDatasetsResponse> {

          private static final String REST_PATH = "v3/{+parent}/datasets";

          private final java.util.regex.Pattern PARENT_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+$");

          /**
           * Lists datasets.
           *
           * Create a request for the method "datasets.list".
           *
           * This request holds the parameters needed by the the translate server.  After setting any
           * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
           * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param parent Required. Name of the parent project. In form of `projects/{project-number-or-id}/locations
         *        /{location-id}`
           * @since 1.13
           */
          protected List(java.lang.String parent) {
            super(Translate.this, "GET", REST_PATH, null, com.google.api.services.translate.v3.model.ListDatasetsResponse.class);
            this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public List set$Xgafv(java.lang.String $Xgafv) {
            return (List) super.set$Xgafv($Xgafv);
          }

          @Override
          public List setAccessToken(java.lang.String accessToken) {
            return (List) super.setAccessToken(accessToken);
          }

          @Override
          public List setAlt(java.lang.String alt) {
            return (List) super.setAlt(alt);
          }

          @Override
          public List setCallback(java.lang.String callback) {
            return (List) super.setCallback(callback);
          }

          @Override
          public List setFields(java.lang.String fields) {
            return (List) super.setFields(fields);
          }

          @Override
          public List setKey(java.lang.String key) {
            return (List) super.setKey(key);
          }

          @Override
          public List setOauthToken(java.lang.String oauthToken) {
            return (List) super.setOauthToken(oauthToken);
          }

          @Override
          public List setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (List) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public List setQuotaUser(java.lang.String quotaUser) {
            return (List) super.setQuotaUser(quotaUser);
          }

          @Override
          public List setUploadType(java.lang.String uploadType) {
            return (List) super.setUploadType(uploadType);
          }

          @Override
          public List setUploadProtocol(java.lang.String uploadProtocol) {
            return (List) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. Name of the parent project. In form of `projects/{project-number-or-
           * id}/locations/{location-id}`
           */
          @com.google.api.client.util.Key
          private java.lang.String parent;

          /** Required. Name of the parent project. In form of `projects/{project-number-or-id}/locations
         /{location-id}`
           */
          public java.lang.String getParent() {
            return parent;
          }

          /**
           * Required. Name of the parent project. In form of `projects/{project-number-or-
           * id}/locations/{location-id}`
           */
          public List setParent(java.lang.String parent) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
            this.parent = parent;
            return this;
          }

          /** Optional. Requested page size. The server can return fewer results than requested. */
          @com.google.api.client.util.Key
          private java.lang.Integer pageSize;

          /** Optional. Requested page size. The server can return fewer results than requested.
           */
          public java.lang.Integer getPageSize() {
            return pageSize;
          }

          /** Optional. Requested page size. The server can return fewer results than requested. */
          public List setPageSize(java.lang.Integer pageSize) {
            this.pageSize = pageSize;
            return this;
          }

          /**
           * Optional. A token identifying a page of results for the server to return. Typically
           * obtained from next_page_token field in the response of a ListDatasets call.
           */
          @com.google.api.client.util.Key
          private java.lang.String pageToken;

          /** Optional. A token identifying a page of results for the server to return. Typically obtained from
         next_page_token field in the response of a ListDatasets call.
           */
          public java.lang.String getPageToken() {
            return pageToken;
          }

          /**
           * Optional. A token identifying a page of results for the server to return. Typically
           * obtained from next_page_token field in the response of a ListDatasets call.
           */
          public List setPageToken(java.lang.String pageToken) {
            this.pageToken = pageToken;
            return this;
          }

          @Override
          public List set(String parameterName, Object value) {
            return (List) super.set(parameterName, value);
          }
        }

        /**
         * An accessor for creating requests from the Examples collection.
         *
         * <p>The typical use is:</p>
         * <pre>
         *   {@code Translate translate = new Translate(...);}
         *   {@code Translate.Examples.List request = translate.examples().list(parameters ...)}
         * </pre>
         *
         * @return the resource collection
         */
        public Examples examples() {
          return new Examples();
        }

        /**
         * The "examples" collection of methods.
         */
        public class Examples {

          /**
           * Lists sentence pairs in the dataset.
           *
           * Create a request for the method "examples.list".
           *
           * This request holds the parameters needed by the translate server.  After setting any optional
           * parameters, call the {@link List#execute()} method to invoke the remote operation.
           *
           * @param parent Required. Name of the parent dataset. In form of `projects/{project-number-or-id}/locations
           *        /{location-id}/datasets/{dataset-id}`
           * @return the request
           */
          public List list(java.lang.String parent) throws java.io.IOException {
            List result = new List(parent);
            initialize(result);
            return result;
          }

          public class List extends TranslateRequest<com.google.api.services.translate.v3.model.ListExamplesResponse> {

            private static final String REST_PATH = "v3/{+parent}/examples";

            private final java.util.regex.Pattern PARENT_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");

            /**
             * Lists sentence pairs in the dataset.
             *
             * Create a request for the method "examples.list".
             *
             * This request holds the parameters needed by the the translate server.  After setting any
             * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
             * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
             * must be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param parent Required. Name of the parent dataset. In form of `projects/{project-number-or-id}/locations
           *        /{location-id}/datasets/{dataset-id}`
             * @since 1.13
             */
            protected List(java.lang.String parent) {
              super(Translate.this, "GET", REST_PATH, null, com.google.api.services.translate.v3.model.ListExamplesResponse.class);
              this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                    "Parameter parent must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
              }
            }

            @Override
            public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
              return super.executeUsingHead();
            }

            @Override
            public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
              return super.buildHttpRequestUsingHead();
            }

            @Override
            public List set$Xgafv(java.lang.String $Xgafv) {
              return (List) super.set$Xgafv($Xgafv);
            }

            @Override
            public List setAccessToken(java.lang.String accessToken) {
              return (List) super.setAccessToken(accessToken);
            }

            @Override
            public List setAlt(java.lang.String alt) {
              return (List) super.setAlt(alt);
            }

            @Override
            public List setCallback(java.lang.String callback) {
              return (List) super.setCallback(callback);
            }

            @Override
            public List setFields(java.lang.String fields) {
              return (List) super.setFields(fields);
            }

            @Override
            public List setKey(java.lang.String key) {
              return (List) super.setKey(key);
            }

            @Override
            public List setOauthToken(java.lang.String oauthToken) {
              return (List) super.setOauthToken(oauthToken);
            }

            @Override
            public List setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (List) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public List setQuotaUser(java.lang.String quotaUser) {
              return (List) super.setQuotaUser(quotaUser);
            }

            @Override
            public List setUploadType(java.lang.String uploadType) {
              return (List) super.setUploadType(uploadType);
            }

            @Override
            public List setUploadProtocol(java.lang.String uploadProtocol) {
              return (List) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * Required. Name of the parent dataset. In form of `projects/{project-number-or-
             * id}/locations/{location-id}/datasets/{dataset-id}`
             */
            @com.google.api.client.util.Key
            private java.lang.String parent;

            /** Required. Name of the parent dataset. In form of `projects/{project-number-or-id}/locations
           /{location-id}/datasets/{dataset-id}`
             */
            public java.lang.String getParent() {
              return parent;
            }

            /**
             * Required. Name of the parent dataset. In form of `projects/{project-number-or-
             * id}/locations/{location-id}/datasets/{dataset-id}`
             */
            public List setParent(java.lang.String parent) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                    "Parameter parent must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
              }
              this.parent = parent;
              return this;
            }

            /**
             * Optional. An expression for filtering the examples that will be returned. Example
             * filter: * `usage=TRAIN`
             */
            @com.google.api.client.util.Key
            private java.lang.String filter;

            /** Optional. An expression for filtering the examples that will be returned. Example filter: *
           `usage=TRAIN`
             */
            public java.lang.String getFilter() {
              return filter;
            }

            /**
             * Optional. An expression for filtering the examples that will be returned. Example
             * filter: * `usage=TRAIN`
             */
            public List setFilter(java.lang.String filter) {
              this.filter = filter;
              return this;
            }

            /**
             * Optional. Requested page size. The server can return fewer results than requested.
             */
            @com.google.api.client.util.Key
            private java.lang.Integer pageSize;

            /** Optional. Requested page size. The server can return fewer results than requested.
             */
            public java.lang.Integer getPageSize() {
              return pageSize;
            }

            /**
             * Optional. Requested page size. The server can return fewer results than requested.
             */
            public List setPageSize(java.lang.Integer pageSize) {
              this.pageSize = pageSize;
              return this;
            }

            /**
             * Optional. A token identifying a page of results for the server to return. Typically
             * obtained from next_page_token field in the response of a ListExamples call.
             */
            @com.google.api.client.util.Key
            private java.lang.String pageToken;

            /** Optional. A token identifying a page of results for the server to return. Typically obtained from
           next_page_token field in the response of a ListExamples call.
             */
            public java.lang.String getPageToken() {
              return pageToken;
            }

            /**
             * Optional. A token identifying a page of results for the server to return. Typically
             * obtained from next_page_token field in the response of a ListExamples call.
             */
            public List setPageToken(java.lang.String pageToken) {
              this.pageToken = pageToken;
              return this;
            }

            @Override
            public List set(String parameterName, Object value) {
              return (List) super.set(parameterName, value);
            }
          }

        }
      }
      /**
       * An accessor for creating requests from the Glossaries collection.
       *
       * <p>The typical use is:</p>
       * <pre>
       *   {@code Translate translate = new Translate(...);}
       *   {@code Translate.Glossaries.List request = translate.glossaries().list(parameters ...)}
       * </pre>
       *
       * @return the resource collection
       */
      public Glossaries glossaries() {
        return new Glossaries();
      }

      /**
       * The "glossaries" collection of methods.
       */
      public class Glossaries {

        /**
         * Creates a glossary and returns the long-running operation. Returns NOT_FOUND, if the project
         * doesn't exist.
         *
         * Create a request for the method "glossaries.create".
         *
         * This request holds the parameters needed by the translate server.  After setting any optional
         * parameters, call the {@link Create#execute()} method to invoke the remote operation.
         *
         * @param parent Required. The project name.
         * @param content the {@link com.google.api.services.translate.v3.model.Glossary}
         * @return the request
         */
        public Create create(java.lang.String parent, com.google.api.services.translate.v3.model.Glossary content) throws java.io.IOException {
          Create result = new Create(parent, content);
          initialize(result);
          return result;
        }

        public class Create extends TranslateRequest<com.google.api.services.translate.v3.model.Operation> {

          private static final String REST_PATH = "v3/{+parent}/glossaries";

          private final java.util.regex.Pattern PARENT_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+$");

          /**
           * Creates a glossary and returns the long-running operation. Returns NOT_FOUND, if the project
           * doesn't exist.
           *
           * Create a request for the method "glossaries.create".
           *
           * This request holds the parameters needed by the the translate server.  After setting any
           * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
           * <p> {@link
           * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param parent Required. The project name.
           * @param content the {@link com.google.api.services.translate.v3.model.Glossary}
           * @since 1.13
           */
          protected Create(java.lang.String parent, com.google.api.services.translate.v3.model.Glossary content) {
            super(Translate.this, "POST", REST_PATH, content, com.google.api.services.translate.v3.model.Operation.class);
            this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
          }

          @Override
          public Create set$Xgafv(java.lang.String $Xgafv) {
            return (Create) super.set$Xgafv($Xgafv);
          }

          @Override
          public Create setAccessToken(java.lang.String accessToken) {
            return (Create) super.setAccessToken(accessToken);
          }

          @Override
          public Create setAlt(java.lang.String alt) {
            return (Create) super.setAlt(alt);
          }

          @Override
          public Create setCallback(java.lang.String callback) {
            return (Create) super.setCallback(callback);
          }

          @Override
          public Create setFields(java.lang.String fields) {
            return (Create) super.setFields(fields);
          }

          @Override
          public Create setKey(java.lang.String key) {
            return (Create) super.setKey(key);
          }

          @Override
          public Create setOauthToken(java.lang.String oauthToken) {
            return (Create) super.setOauthToken(oauthToken);
          }

          @Override
          public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Create) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Create setQuotaUser(java.lang.String quotaUser) {
            return (Create) super.setQuotaUser(quotaUser);
          }

          @Override
          public Create setUploadType(java.lang.String uploadType) {
            return (Create) super.setUploadType(uploadType);
          }

          @Override
          public Create setUploadProtocol(java.lang.String uploadProtocol) {
            return (Create) super.setUploadProtocol(uploadProtocol);
          }

          /** Required. The project name. */
          @com.google.api.client.util.Key
          private java.lang.String parent;

          /** Required. The project name.
           */
          public java.lang.String getParent() {
            return parent;
          }

          /** Required. The project name. */
          public Create setParent(java.lang.String parent) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
            this.parent = parent;
            return this;
          }

          @Override
          public Create set(String parameterName, Object value) {
            return (Create) super.set(parameterName, value);
          }
        }
        /**
         * Deletes a glossary, or cancels glossary construction if the glossary isn't created yet. Returns
         * NOT_FOUND, if the glossary doesn't exist.
         *
         * Create a request for the method "glossaries.delete".
         *
         * This request holds the parameters needed by the translate server.  After setting any optional
         * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
         *
         * @param name Required. The name of the glossary to delete.
         * @return the request
         */
        public Delete delete(java.lang.String name) throws java.io.IOException {
          Delete result = new Delete(name);
          initialize(result);
          return result;
        }

        public class Delete extends TranslateRequest<com.google.api.services.translate.v3.model.Operation> {

          private static final String REST_PATH = "v3/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/glossaries/[^/]+$");

          /**
           * Deletes a glossary, or cancels glossary construction if the glossary isn't created yet. Returns
           * NOT_FOUND, if the glossary doesn't exist.
           *
           * Create a request for the method "glossaries.delete".
           *
           * This request holds the parameters needed by the the translate server.  After setting any
           * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
           * <p> {@link
           * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name Required. The name of the glossary to delete.
           * @since 1.13
           */
          protected Delete(java.lang.String name) {
            super(Translate.this, "DELETE", REST_PATH, null, com.google.api.services.translate.v3.model.Operation.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/glossaries/[^/]+$");
            }
          }

          @Override
          public Delete set$Xgafv(java.lang.String $Xgafv) {
            return (Delete) super.set$Xgafv($Xgafv);
          }

          @Override
          public Delete setAccessToken(java.lang.String accessToken) {
            return (Delete) super.setAccessToken(accessToken);
          }

          @Override
          public Delete setAlt(java.lang.String alt) {
            return (Delete) super.setAlt(alt);
          }

          @Override
          public Delete setCallback(java.lang.String callback) {
            return (Delete) super.setCallback(callback);
          }

          @Override
          public Delete setFields(java.lang.String fields) {
            return (Delete) super.setFields(fields);
          }

          @Override
          public Delete setKey(java.lang.String key) {
            return (Delete) super.setKey(key);
          }

          @Override
          public Delete setOauthToken(java.lang.String oauthToken) {
            return (Delete) super.setOauthToken(oauthToken);
          }

          @Override
          public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Delete) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Delete setQuotaUser(java.lang.String quotaUser) {
            return (Delete) super.setQuotaUser(quotaUser);
          }

          @Override
          public Delete setUploadType(java.lang.String uploadType) {
            return (Delete) super.setUploadType(uploadType);
          }

          @Override
          public Delete setUploadProtocol(java.lang.String uploadProtocol) {
            return (Delete) super.setUploadProtocol(uploadProtocol);
          }

          /** Required. The name of the glossary to delete. */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Required. The name of the glossary to delete.
           */
          public java.lang.String getName() {
            return name;
          }

          /** Required. The name of the glossary to delete. */
          public Delete setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/glossaries/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Delete set(String parameterName, Object value) {
            return (Delete) super.set(parameterName, value);
          }
        }
        /**
         * Gets a glossary. Returns NOT_FOUND, if the glossary doesn't exist.
         *
         * Create a request for the method "glossaries.get".
         *
         * This request holds the parameters needed by the translate server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation.
         *
         * @param name Required. The name of the glossary to retrieve.
         * @return the request
         */
        public Get get(java.lang.String name) throws java.io.IOException {
          Get result = new Get(name);
          initialize(result);
          return result;
        }

        public class Get extends TranslateRequest<com.google.api.services.translate.v3.model.Glossary> {

          private static final String REST_PATH = "v3/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/glossaries/[^/]+$");

          /**
           * Gets a glossary. Returns NOT_FOUND, if the glossary doesn't exist.
           *
           * Create a request for the method "glossaries.get".
           *
           * This request holds the parameters needed by the the translate server.  After setting any
           * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
           * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name Required. The name of the glossary to retrieve.
           * @since 1.13
           */
          protected Get(java.lang.String name) {
            super(Translate.this, "GET", REST_PATH, null, com.google.api.services.translate.v3.model.Glossary.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/glossaries/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public Get set$Xgafv(java.lang.String $Xgafv) {
            return (Get) super.set$Xgafv($Xgafv);
          }

          @Override
          public Get setAccessToken(java.lang.String accessToken) {
            return (Get) super.setAccessToken(accessToken);
          }

          @Override
          public Get setAlt(java.lang.String alt) {
            return (Get) super.setAlt(alt);
          }

          @Override
          public Get setCallback(java.lang.String callback) {
            return (Get) super.setCallback(callback);
          }

          @Override
          public Get setFields(java.lang.String fields) {
            return (Get) super.setFields(fields);
          }

          @Override
          public Get setKey(java.lang.String key) {
            return (Get) super.setKey(key);
          }

          @Override
          public Get setOauthToken(java.lang.String oauthToken) {
            return (Get) super.setOauthToken(oauthToken);
          }

          @Override
          public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Get) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Get setQuotaUser(java.lang.String quotaUser) {
            return (Get) super.setQuotaUser(quotaUser);
          }

          @Override
          public Get setUploadType(java.lang.String uploadType) {
            return (Get) super.setUploadType(uploadType);
          }

          @Override
          public Get setUploadProtocol(java.lang.String uploadProtocol) {
            return (Get) super.setUploadProtocol(uploadProtocol);
          }

          /** Required. The name of the glossary to retrieve. */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Required. The name of the glossary to retrieve.
           */
          public java.lang.String getName() {
            return name;
          }

          /** Required. The name of the glossary to retrieve. */
          public Get setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/glossaries/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Get set(String parameterName, Object value) {
            return (Get) super.set(parameterName, value);
          }
        }
        /**
         * Lists glossaries in a project. Returns NOT_FOUND, if the project doesn't exist.
         *
         * Create a request for the method "glossaries.list".
         *
         * This request holds the parameters needed by the translate server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation.
         *
         * @param parent Required. The name of the project from which to list all of the glossaries.
         * @return the request
         */
        public List list(java.lang.String parent) throws java.io.IOException {
          List result = new List(parent);
          initialize(result);
          return result;
        }

        public class List extends TranslateRequest<com.google.api.services.translate.v3.model.ListGlossariesResponse> {

          private static final String REST_PATH = "v3/{+parent}/glossaries";

          private final java.util.regex.Pattern PARENT_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+$");

          /**
           * Lists glossaries in a project. Returns NOT_FOUND, if the project doesn't exist.
           *
           * Create a request for the method "glossaries.list".
           *
           * This request holds the parameters needed by the the translate server.  After setting any
           * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
           * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param parent Required. The name of the project from which to list all of the glossaries.
           * @since 1.13
           */
          protected List(java.lang.String parent) {
            super(Translate.this, "GET", REST_PATH, null, com.google.api.services.translate.v3.model.ListGlossariesResponse.class);
            this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public List set$Xgafv(java.lang.String $Xgafv) {
            return (List) super.set$Xgafv($Xgafv);
          }

          @Override
          public List setAccessToken(java.lang.String accessToken) {
            return (List) super.setAccessToken(accessToken);
          }

          @Override
          public List setAlt(java.lang.String alt) {
            return (List) super.setAlt(alt);
          }

          @Override
          public List setCallback(java.lang.String callback) {
            return (List) super.setCallback(callback);
          }

          @Override
          public List setFields(java.lang.String fields) {
            return (List) super.setFields(fields);
          }

          @Override
          public List setKey(java.lang.String key) {
            return (List) super.setKey(key);
          }

          @Override
          public List setOauthToken(java.lang.String oauthToken) {
            return (List) super.setOauthToken(oauthToken);
          }

          @Override
          public List setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (List) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public List setQuotaUser(java.lang.String quotaUser) {
            return (List) super.setQuotaUser(quotaUser);
          }

          @Override
          public List setUploadType(java.lang.String uploadType) {
            return (List) super.setUploadType(uploadType);
          }

          @Override
          public List setUploadProtocol(java.lang.String uploadProtocol) {
            return (List) super.setUploadProtocol(uploadProtocol);
          }

          /** Required. The name of the project from which to list all of the glossaries. */
          @com.google.api.client.util.Key
          private java.lang.String parent;

          /** Required. The name of the project from which to list all of the glossaries.
           */
          public java.lang.String getParent() {
            return parent;
          }

          /** Required. The name of the project from which to list all of the glossaries. */
          public List setParent(java.lang.String parent) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
            this.parent = parent;
            return this;
          }

          /**
           * Optional. Filter specifying constraints of a list operation. Specify the constraint by
           * the format of "key=value", where key must be "src" or "tgt", and the value must be a
           * valid language code. For multiple restrictions, concatenate them by "AND" (uppercase
           * only), such as: "src=en-US AND tgt=zh-CN". Notice that the exact match is used here,
           * which means using 'en-US' and 'en' can lead to different results, which depends on the
           * language code you used when you create the glossary. For the unidirectional glossaries,
           * the "src" and "tgt" add restrictions on the source and target language code separately.
           * For the equivalent term set glossaries, the "src" and/or "tgt" add restrictions on the
           * term set. For example: "src=en-US AND tgt=zh-CN" will only pick the unidirectional
           * glossaries which exactly match the source language code as "en-US" and the target
           * language code "zh-CN", but all equivalent term set glossaries which contain "en-US" and
           * "zh-CN" in their language set will be picked. If missing, no filtering is performed.
           */
          @com.google.api.client.util.Key
          private java.lang.String filter;

          /** Optional. Filter specifying constraints of a list operation. Specify the constraint by the format
         of "key=value", where key must be "src" or "tgt", and the value must be a valid language code. For
         multiple restrictions, concatenate them by "AND" (uppercase only), such as: "src=en-US AND tgt=zh-
         CN". Notice that the exact match is used here, which means using 'en-US' and 'en' can lead to
         different results, which depends on the language code you used when you create the glossary. For
         the unidirectional glossaries, the "src" and "tgt" add restrictions on the source and target
         language code separately. For the equivalent term set glossaries, the "src" and/or "tgt" add
         restrictions on the term set. For example: "src=en-US AND tgt=zh-CN" will only pick the
         unidirectional glossaries which exactly match the source language code as "en-US" and the target
         language code "zh-CN", but all equivalent term set glossaries which contain "en-US" and "zh-CN" in
         their language set will be picked. If missing, no filtering is performed.
           */
          public java.lang.String getFilter() {
            return filter;
          }

          /**
           * Optional. Filter specifying constraints of a list operation. Specify the constraint by
           * the format of "key=value", where key must be "src" or "tgt", and the value must be a
           * valid language code. For multiple restrictions, concatenate them by "AND" (uppercase
           * only), such as: "src=en-US AND tgt=zh-CN". Notice that the exact match is used here,
           * which means using 'en-US' and 'en' can lead to different results, which depends on the
           * language code you used when you create the glossary. For the unidirectional glossaries,
           * the "src" and "tgt" add restrictions on the source and target language code separately.
           * For the equivalent term set glossaries, the "src" and/or "tgt" add restrictions on the
           * term set. For example: "src=en-US AND tgt=zh-CN" will only pick the unidirectional
           * glossaries which exactly match the source language code as "en-US" and the target
           * language code "zh-CN", but all equivalent term set glossaries which contain "en-US" and
           * "zh-CN" in their language set will be picked. If missing, no filtering is performed.
           */
          public List setFilter(java.lang.String filter) {
            this.filter = filter;
            return this;
          }

          /**
           * Optional. Requested page size. The server may return fewer glossaries than requested.
           * If unspecified, the server picks an appropriate default.
           */
          @com.google.api.client.util.Key
          private java.lang.Integer pageSize;

          /** Optional. Requested page size. The server may return fewer glossaries than requested. If
         unspecified, the server picks an appropriate default.
           */
          public java.lang.Integer getPageSize() {
            return pageSize;
          }

          /**
           * Optional. Requested page size. The server may return fewer glossaries than requested.
           * If unspecified, the server picks an appropriate default.
           */
          public List setPageSize(java.lang.Integer pageSize) {
            this.pageSize = pageSize;
            return this;
          }

          /**
           * Optional. A token identifying a page of results the server should return. Typically,
           * this is the value of [ListGlossariesResponse.next_page_token] returned from the
           * previous call to `ListGlossaries` method. The first page is returned if `page_token`is
           * empty or missing.
           */
          @com.google.api.client.util.Key
          private java.lang.String pageToken;

          /** Optional. A token identifying a page of results the server should return. Typically, this is the
         value of [ListGlossariesResponse.next_page_token] returned from the previous call to
         `ListGlossaries` method. The first page is returned if `page_token`is empty or missing.
           */
          public java.lang.String getPageToken() {
            return pageToken;
          }

          /**
           * Optional. A token identifying a page of results the server should return. Typically,
           * this is the value of [ListGlossariesResponse.next_page_token] returned from the
           * previous call to `ListGlossaries` method. The first page is returned if `page_token`is
           * empty or missing.
           */
          public List setPageToken(java.lang.String pageToken) {
            this.pageToken = pageToken;
            return this;
          }

          @Override
          public List set(String parameterName, Object value) {
            return (List) super.set(parameterName, value);
          }
        }
        /**
         * Updates a glossary. A LRO is used since the update can be async if the glossary's entry file is
         * updated.
         *
         * Create a request for the method "glossaries.patch".
         *
         * This request holds the parameters needed by the translate server.  After setting any optional
         * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
         *
         * @param name Required. The resource name of the glossary. Glossary names have the form `projects/{project-number-
         *        or-id}/locations/{location-id}/glossaries/{glossary-id}`.
         * @param content the {@link com.google.api.services.translate.v3.model.Glossary}
         * @return the request
         */
        public Patch patch(java.lang.String name, com.google.api.services.translate.v3.model.Glossary content) throws java.io.IOException {
          Patch result = new Patch(name, content);
          initialize(result);
          return result;
        }

        public class Patch extends TranslateRequest<com.google.api.services.translate.v3.model.Operation> {

          private static final String REST_PATH = "v3/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/glossaries/[^/]+$");

          /**
           * Updates a glossary. A LRO is used since the update can be async if the glossary's entry file is
           * updated.
           *
           * Create a request for the method "glossaries.patch".
           *
           * This request holds the parameters needed by the the translate server.  After setting any
           * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
           * <p> {@link
           * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name Required. The resource name of the glossary. Glossary names have the form `projects/{project-number-
         *        or-id}/locations/{location-id}/glossaries/{glossary-id}`.
           * @param content the {@link com.google.api.services.translate.v3.model.Glossary}
           * @since 1.13
           */
          protected Patch(java.lang.String name, com.google.api.services.translate.v3.model.Glossary content) {
            super(Translate.this, "PATCH", REST_PATH, content, com.google.api.services.translate.v3.model.Operation.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/glossaries/[^/]+$");
            }
          }

          @Override
          public Patch set$Xgafv(java.lang.String $Xgafv) {
            return (Patch) super.set$Xgafv($Xgafv);
          }

          @Override
          public Patch setAccessToken(java.lang.String accessToken) {
            return (Patch) super.setAccessToken(accessToken);
          }

          @Override
          public Patch setAlt(java.lang.String alt) {
            return (Patch) super.setAlt(alt);
          }

          @Override
          public Patch setCallback(java.lang.String callback) {
            return (Patch) super.setCallback(callback);
          }

          @Override
          public Patch setFields(java.lang.String fields) {
            return (Patch) super.setFields(fields);
          }

          @Override
          public Patch setKey(java.lang.String key) {
            return (Patch) super.setKey(key);
          }

          @Override
          public Patch setOauthToken(java.lang.String oauthToken) {
            return (Patch) super.setOauthToken(oauthToken);
          }

          @Override
          public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Patch) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Patch setQuotaUser(java.lang.String quotaUser) {
            return (Patch) super.setQuotaUser(quotaUser);
          }

          @Override
          public Patch setUploadType(java.lang.String uploadType) {
            return (Patch) super.setUploadType(uploadType);
          }

          @Override
          public Patch setUploadProtocol(java.lang.String uploadProtocol) {
            return (Patch) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. The resource name of the glossary. Glossary names have the form `projects
           * /{project-number-or-id}/locations/{location-id}/glossaries/{glossary-id}`.
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Required. The resource name of the glossary. Glossary names have the form `projects/{project-
         number-or-id}/locations/{location-id}/glossaries/{glossary-id}`.
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * Required. The resource name of the glossary. Glossary names have the form `projects
           * /{project-number-or-id}/locations/{location-id}/glossaries/{glossary-id}`.
           */
          public Patch setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/glossaries/[^/]+$");
            }
            this.name = name;
            return this;
          }

          /** The list of fields to be updated. Currently only `display_name` and 'input_config' */
          @com.google.api.client.util.Key
          private String updateMask;

          /** The list of fields to be updated. Currently only `display_name` and 'input_config'
           */
          public String getUpdateMask() {
            return updateMask;
          }

          /** The list of fields to be updated. Currently only `display_name` and 'input_config' */
          public Patch setUpdateMask(String updateMask) {
            this.updateMask = updateMask;
            return this;
          }

          @Override
          public Patch set(String parameterName, Object value) {
            return (Patch) super.set(parameterName, value);
          }
        }

        /**
         * An accessor for creating requests from the GlossaryEntries collection.
         *
         * <p>The typical use is:</p>
         * <pre>
         *   {@code Translate translate = new Translate(...);}
         *   {@code Translate.GlossaryEntries.List request = translate.glossaryEntries().list(parameters ...)}
         * </pre>
         *
         * @return the resource collection
         */
        public GlossaryEntries glossaryEntries() {
          return new GlossaryEntries();
        }

        /**
         * The "glossaryEntries" collection of methods.
         */
        public class GlossaryEntries {

          /**
           * Creates a glossary entry.
           *
           * Create a request for the method "glossaryEntries.create".
           *
           * This request holds the parameters needed by the translate server.  After setting any optional
           * parameters, call the {@link Create#execute()} method to invoke the remote operation.
           *
           * @param parent Required. The resource name of the glossary to create the entry under.
           * @param content the {@link com.google.api.services.translate.v3.model.GlossaryEntry}
           * @return the request
           */
          public Create create(java.lang.String parent, com.google.api.services.translate.v3.model.GlossaryEntry content) throws java.io.IOException {
            Create result = new Create(parent, content);
            initialize(result);
            return result;
          }

          public class Create extends TranslateRequest<com.google.api.services.translate.v3.model.GlossaryEntry> {

            private static final String REST_PATH = "v3/{+parent}/glossaryEntries";

            private final java.util.regex.Pattern PARENT_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/glossaries/[^/]+$");

            /**
             * Creates a glossary entry.
             *
             * Create a request for the method "glossaryEntries.create".
             *
             * This request holds the parameters needed by the the translate server.  After setting any
             * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
             * <p> {@link
             * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
             * be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param parent Required. The resource name of the glossary to create the entry under.
             * @param content the {@link com.google.api.services.translate.v3.model.GlossaryEntry}
             * @since 1.13
             */
            protected Create(java.lang.String parent, com.google.api.services.translate.v3.model.GlossaryEntry content) {
              super(Translate.this, "POST", REST_PATH, content, com.google.api.services.translate.v3.model.GlossaryEntry.class);
              this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                    "Parameter parent must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/glossaries/[^/]+$");
              }
            }

            @Override
            public Create set$Xgafv(java.lang.String $Xgafv) {
              return (Create) super.set$Xgafv($Xgafv);
            }

            @Override
            public Create setAccessToken(java.lang.String accessToken) {
              return (Create) super.setAccessToken(accessToken);
            }

            @Override
            public Create setAlt(java.lang.String alt) {
              return (Create) super.setAlt(alt);
            }

            @Override
            public Create setCallback(java.lang.String callback) {
              return (Create) super.setCallback(callback);
            }

            @Override
            public Create setFields(java.lang.String fields) {
              return (Create) super.setFields(fields);
            }

            @Override
            public Create setKey(java.lang.String key) {
              return (Create) super.setKey(key);
            }

            @Override
            public Create setOauthToken(java.lang.String oauthToken) {
              return (Create) super.setOauthToken(oauthToken);
            }

            @Override
            public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (Create) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public Create setQuotaUser(java.lang.String quotaUser) {
              return (Create) super.setQuotaUser(quotaUser);
            }

            @Override
            public Create setUploadType(java.lang.String uploadType) {
              return (Create) super.setUploadType(uploadType);
            }

            @Override
            public Create setUploadProtocol(java.lang.String uploadProtocol) {
              return (Create) super.setUploadProtocol(uploadProtocol);
            }

            /** Required. The resource name of the glossary to create the entry under. */
            @com.google.api.client.util.Key
            private java.lang.String parent;

            /** Required. The resource name of the glossary to create the entry under.
             */
            public java.lang.String getParent() {
              return parent;
            }

            /** Required. The resource name of the glossary to create the entry under. */
            public Create setParent(java.lang.String parent) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                    "Parameter parent must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/glossaries/[^/]+$");
              }
              this.parent = parent;
              return this;
            }

            @Override
            public Create set(String parameterName, Object value) {
              return (Create) super.set(parameterName, value);
            }
          }
          /**
           * Deletes a single entry from the glossary
           *
           * Create a request for the method "glossaryEntries.delete".
           *
           * This request holds the parameters needed by the translate server.  After setting any optional
           * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
           *
           * @param name Required. The resource name of the glossary entry to delete
           * @return the request
           */
          public Delete delete(java.lang.String name) throws java.io.IOException {
            Delete result = new Delete(name);
            initialize(result);
            return result;
          }

          public class Delete extends TranslateRequest<com.google.api.services.translate.v3.model.Empty> {

            private static final String REST_PATH = "v3/{+name}";

            private final java.util.regex.Pattern NAME_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/glossaries/[^/]+/glossaryEntries/[^/]+$");

            /**
             * Deletes a single entry from the glossary
             *
             * Create a request for the method "glossaryEntries.delete".
             *
             * This request holds the parameters needed by the the translate server.  After setting any
             * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
             * <p> {@link
             * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
             * be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param name Required. The resource name of the glossary entry to delete
             * @since 1.13
             */
            protected Delete(java.lang.String name) {
              super(Translate.this, "DELETE", REST_PATH, null, com.google.api.services.translate.v3.model.Empty.class);
              this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/glossaries/[^/]+/glossaryEntries/[^/]+$");
              }
            }

            @Override
            public Delete set$Xgafv(java.lang.String $Xgafv) {
              return (Delete) super.set$Xgafv($Xgafv);
            }

            @Override
            public Delete setAccessToken(java.lang.String accessToken) {
              return (Delete) super.setAccessToken(accessToken);
            }

            @Override
            public Delete setAlt(java.lang.String alt) {
              return (Delete) super.setAlt(alt);
            }

            @Override
            public Delete setCallback(java.lang.String callback) {
              return (Delete) super.setCallback(callback);
            }

            @Override
            public Delete setFields(java.lang.String fields) {
              return (Delete) super.setFields(fields);
            }

            @Override
            public Delete setKey(java.lang.String key) {
              return (Delete) super.setKey(key);
            }

            @Override
            public Delete setOauthToken(java.lang.String oauthToken) {
              return (Delete) super.setOauthToken(oauthToken);
            }

            @Override
            public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (Delete) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public Delete setQuotaUser(java.lang.String quotaUser) {
              return (Delete) super.setQuotaUser(quotaUser);
            }

            @Override
            public Delete setUploadType(java.lang.String uploadType) {
              return (Delete) super.setUploadType(uploadType);
            }

            @Override
            public Delete setUploadProtocol(java.lang.String uploadProtocol) {
              return (Delete) super.setUploadProtocol(uploadProtocol);
            }

            /** Required. The resource name of the glossary entry to delete */
            @com.google.api.client.util.Key
            private java.lang.String name;

            /** Required. The resource name of the glossary entry to delete
             */
            public java.lang.String getName() {
              return name;
            }

            /** Required. The resource name of the glossary entry to delete */
            public Delete setName(java.lang.String name) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/glossaries/[^/]+/glossaryEntries/[^/]+$");
              }
              this.name = name;
              return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
              return (Delete) super.set(parameterName, value);
            }
          }
          /**
           * Gets a single glossary entry by the given id.
           *
           * Create a request for the method "glossaryEntries.get".
           *
           * This request holds the parameters needed by the translate server.  After setting any optional
           * parameters, call the {@link Get#execute()} method to invoke the remote operation.
           *
           * @param name Required. The resource name of the glossary entry to get
           * @return the request
           */
          public Get get(java.lang.String name) throws java.io.IOException {
            Get result = new Get(name);
            initialize(result);
            return result;
          }

          public class Get extends TranslateRequest<com.google.api.services.translate.v3.model.GlossaryEntry> {

            private static final String REST_PATH = "v3/{+name}";

            private final java.util.regex.Pattern NAME_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/glossaries/[^/]+/glossaryEntries/[^/]+$");

            /**
             * Gets a single glossary entry by the given id.
             *
             * Create a request for the method "glossaryEntries.get".
             *
             * This request holds the parameters needed by the the translate server.  After setting any
             * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
             * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
             * must be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param name Required. The resource name of the glossary entry to get
             * @since 1.13
             */
            protected Get(java.lang.String name) {
              super(Translate.this, "GET", REST_PATH, null, com.google.api.services.translate.v3.model.GlossaryEntry.class);
              this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/glossaries/[^/]+/glossaryEntries/[^/]+$");
              }
            }

            @Override
            public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
              return super.executeUsingHead();
            }

            @Override
            public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
              return super.buildHttpRequestUsingHead();
            }

            @Override
            public Get set$Xgafv(java.lang.String $Xgafv) {
              return (Get) super.set$Xgafv($Xgafv);
            }

            @Override
            public Get setAccessToken(java.lang.String accessToken) {
              return (Get) super.setAccessToken(accessToken);
            }

            @Override
            public Get setAlt(java.lang.String alt) {
              return (Get) super.setAlt(alt);
            }

            @Override
            public Get setCallback(java.lang.String callback) {
              return (Get) super.setCallback(callback);
            }

            @Override
            public Get setFields(java.lang.String fields) {
              return (Get) super.setFields(fields);
            }

            @Override
            public Get setKey(java.lang.String key) {
              return (Get) super.setKey(key);
            }

            @Override
            public Get setOauthToken(java.lang.String oauthToken) {
              return (Get) super.setOauthToken(oauthToken);
            }

            @Override
            public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (Get) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public Get setQuotaUser(java.lang.String quotaUser) {
              return (Get) super.setQuotaUser(quotaUser);
            }

            @Override
            public Get setUploadType(java.lang.String uploadType) {
              return (Get) super.setUploadType(uploadType);
            }

            @Override
            public Get setUploadProtocol(java.lang.String uploadProtocol) {
              return (Get) super.setUploadProtocol(uploadProtocol);
            }

            /** Required. The resource name of the glossary entry to get */
            @com.google.api.client.util.Key
            private java.lang.String name;

            /** Required. The resource name of the glossary entry to get
             */
            public java.lang.String getName() {
              return name;
            }

            /** Required. The resource name of the glossary entry to get */
            public Get setName(java.lang.String name) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/glossaries/[^/]+/glossaryEntries/[^/]+$");
              }
              this.name = name;
              return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
              return (Get) super.set(parameterName, value);
            }
          }
          /**
           * List the entries for the glossary.
           *
           * Create a request for the method "glossaryEntries.list".
           *
           * This request holds the parameters needed by the translate server.  After setting any optional
           * parameters, call the {@link List#execute()} method to invoke the remote operation.
           *
           * @param parent Required. The parent glossary resource name for listing the glossary's entries.
           * @return the request
           */
          public List list(java.lang.String parent) throws java.io.IOException {
            List result = new List(parent);
            initialize(result);
            return result;
          }

          public class List extends TranslateRequest<com.google.api.services.translate.v3.model.ListGlossaryEntriesResponse> {

            private static final String REST_PATH = "v3/{+parent}/glossaryEntries";

            private final java.util.regex.Pattern PARENT_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/glossaries/[^/]+$");

            /**
             * List the entries for the glossary.
             *
             * Create a request for the method "glossaryEntries.list".
             *
             * This request holds the parameters needed by the the translate server.  After setting any
             * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
             * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
             * must be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param parent Required. The parent glossary resource name for listing the glossary's entries.
             * @since 1.13
             */
            protected List(java.lang.String parent) {
              super(Translate.this, "GET", REST_PATH, null, com.google.api.services.translate.v3.model.ListGlossaryEntriesResponse.class);
              this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                    "Parameter parent must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/glossaries/[^/]+$");
              }
            }

            @Override
            public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
              return super.executeUsingHead();
            }

            @Override
            public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
              return super.buildHttpRequestUsingHead();
            }

            @Override
            public List set$Xgafv(java.lang.String $Xgafv) {
              return (List) super.set$Xgafv($Xgafv);
            }

            @Override
            public List setAccessToken(java.lang.String accessToken) {
              return (List) super.setAccessToken(accessToken);
            }

            @Override
            public List setAlt(java.lang.String alt) {
              return (List) super.setAlt(alt);
            }

            @Override
            public List setCallback(java.lang.String callback) {
              return (List) super.setCallback(callback);
            }

            @Override
            public List setFields(java.lang.String fields) {
              return (List) super.setFields(fields);
            }

            @Override
            public List setKey(java.lang.String key) {
              return (List) super.setKey(key);
            }

            @Override
            public List setOauthToken(java.lang.String oauthToken) {
              return (List) super.setOauthToken(oauthToken);
            }

            @Override
            public List setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (List) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public List setQuotaUser(java.lang.String quotaUser) {
              return (List) super.setQuotaUser(quotaUser);
            }

            @Override
            public List setUploadType(java.lang.String uploadType) {
              return (List) super.setUploadType(uploadType);
            }

            @Override
            public List setUploadProtocol(java.lang.String uploadProtocol) {
              return (List) super.setUploadProtocol(uploadProtocol);
            }

            /** Required. The parent glossary resource name for listing the glossary's entries. */
            @com.google.api.client.util.Key
            private java.lang.String parent;

            /** Required. The parent glossary resource name for listing the glossary's entries.
             */
            public java.lang.String getParent() {
              return parent;
            }

            /** Required. The parent glossary resource name for listing the glossary's entries. */
            public List setParent(java.lang.String parent) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                    "Parameter parent must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/glossaries/[^/]+$");
              }
              this.parent = parent;
              return this;
            }

            /**
             * Optional. Requested page size. The server may return fewer glossary entries than
             * requested. If unspecified, the server picks an appropriate default.
             */
            @com.google.api.client.util.Key
            private java.lang.Integer pageSize;

            /** Optional. Requested page size. The server may return fewer glossary entries than requested. If
           unspecified, the server picks an appropriate default.
             */
            public java.lang.Integer getPageSize() {
              return pageSize;
            }

            /**
             * Optional. Requested page size. The server may return fewer glossary entries than
             * requested. If unspecified, the server picks an appropriate default.
             */
            public List setPageSize(java.lang.Integer pageSize) {
              this.pageSize = pageSize;
              return this;
            }

            /**
             * Optional. A token identifying a page of results the server should return. Typically,
             * this is the value of [ListGlossaryEntriesResponse.next_page_token] returned from the
             * previous call. The first page is returned if `page_token`is empty or missing.
             */
            @com.google.api.client.util.Key
            private java.lang.String pageToken;

            /** Optional. A token identifying a page of results the server should return. Typically, this is the
           value of [ListGlossaryEntriesResponse.next_page_token] returned from the previous call. The first
           page is returned if `page_token`is empty or missing.
             */
            public java.lang.String getPageToken() {
              return pageToken;
            }

            /**
             * Optional. A token identifying a page of results the server should return. Typically,
             * this is the value of [ListGlossaryEntriesResponse.next_page_token] returned from the
             * previous call. The first page is returned if `page_token`is empty or missing.
             */
            public List setPageToken(java.lang.String pageToken) {
              this.pageToken = pageToken;
              return this;
            }

            @Override
            public List set(String parameterName, Object value) {
              return (List) super.set(parameterName, value);
            }
          }
          /**
           * Updates a glossary entry.
           *
           * Create a request for the method "glossaryEntries.patch".
           *
           * This request holds the parameters needed by the translate server.  After setting any optional
           * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
           *
           * @param name Required. The resource name of the entry. Format: "projects/locations/glossaries/glossaryEntries"
           * @param content the {@link com.google.api.services.translate.v3.model.GlossaryEntry}
           * @return the request
           */
          public Patch patch(java.lang.String name, com.google.api.services.translate.v3.model.GlossaryEntry content) throws java.io.IOException {
            Patch result = new Patch(name, content);
            initialize(result);
            return result;
          }

          public class Patch extends TranslateRequest<com.google.api.services.translate.v3.model.GlossaryEntry> {

            private static final String REST_PATH = "v3/{+name}";

            private final java.util.regex.Pattern NAME_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/glossaries/[^/]+/glossaryEntries/[^/]+$");

            /**
             * Updates a glossary entry.
             *
             * Create a request for the method "glossaryEntries.patch".
             *
             * This request holds the parameters needed by the the translate server.  After setting any
             * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
             * <p> {@link
             * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
             * be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param name Required. The resource name of the entry. Format: "projects/locations/glossaries/glossaryEntries"
             * @param content the {@link com.google.api.services.translate.v3.model.GlossaryEntry}
             * @since 1.13
             */
            protected Patch(java.lang.String name, com.google.api.services.translate.v3.model.GlossaryEntry content) {
              super(Translate.this, "PATCH", REST_PATH, content, com.google.api.services.translate.v3.model.GlossaryEntry.class);
              this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/glossaries/[^/]+/glossaryEntries/[^/]+$");
              }
            }

            @Override
            public Patch set$Xgafv(java.lang.String $Xgafv) {
              return (Patch) super.set$Xgafv($Xgafv);
            }

            @Override
            public Patch setAccessToken(java.lang.String accessToken) {
              return (Patch) super.setAccessToken(accessToken);
            }

            @Override
            public Patch setAlt(java.lang.String alt) {
              return (Patch) super.setAlt(alt);
            }

            @Override
            public Patch setCallback(java.lang.String callback) {
              return (Patch) super.setCallback(callback);
            }

            @Override
            public Patch setFields(java.lang.String fields) {
              return (Patch) super.setFields(fields);
            }

            @Override
            public Patch setKey(java.lang.String key) {
              return (Patch) super.setKey(key);
            }

            @Override
            public Patch setOauthToken(java.lang.String oauthToken) {
              return (Patch) super.setOauthToken(oauthToken);
            }

            @Override
            public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (Patch) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public Patch setQuotaUser(java.lang.String quotaUser) {
              return (Patch) super.setQuotaUser(quotaUser);
            }

            @Override
            public Patch setUploadType(java.lang.String uploadType) {
              return (Patch) super.setUploadType(uploadType);
            }

            @Override
            public Patch setUploadProtocol(java.lang.String uploadProtocol) {
              return (Patch) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * Required. The resource name of the entry. Format:
             * "projects/locations/glossaries/glossaryEntries"
             */
            @com.google.api.client.util.Key
            private java.lang.String name;

            /** Required. The resource name of the entry. Format: "projects/locations/glossaries/glossaryEntries"
             */
            public java.lang.String getName() {
              return name;
            }

            /**
             * Required. The resource name of the entry. Format:
             * "projects/locations/glossaries/glossaryEntries"
             */
            public Patch setName(java.lang.String name) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/glossaries/[^/]+/glossaryEntries/[^/]+$");
              }
              this.name = name;
              return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
              return (Patch) super.set(parameterName, value);
            }
          }

        }
      }
      /**
       * An accessor for creating requests from the Models collection.
       *
       * <p>The typical use is:</p>
       * <pre>
       *   {@code Translate translate = new Translate(...);}
       *   {@code Translate.Models.List request = translate.models().list(parameters ...)}
       * </pre>
       *
       * @return the resource collection
       */
      public Models models() {
        return new Models();
      }

      /**
       * The "models" collection of methods.
       */
      public class Models {

        /**
         * Creates a Model.
         *
         * Create a request for the method "models.create".
         *
         * This request holds the parameters needed by the translate server.  After setting any optional
         * parameters, call the {@link Create#execute()} method to invoke the remote operation.
         *
         * @param parent Required. The project name, in form of `projects/{project}/locations/{location}`
         * @param content the {@link com.google.api.services.translate.v3.model.Model}
         * @return the request
         */
        public Create create(java.lang.String parent, com.google.api.services.translate.v3.model.Model content) throws java.io.IOException {
          Create result = new Create(parent, content);
          initialize(result);
          return result;
        }

        public class Create extends TranslateRequest<com.google.api.services.translate.v3.model.Operation> {

          private static final String REST_PATH = "v3/{+parent}/models";

          private final java.util.regex.Pattern PARENT_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+$");

          /**
           * Creates a Model.
           *
           * Create a request for the method "models.create".
           *
           * This request holds the parameters needed by the the translate server.  After setting any
           * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
           * <p> {@link
           * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param parent Required. The project name, in form of `projects/{project}/locations/{location}`
           * @param content the {@link com.google.api.services.translate.v3.model.Model}
           * @since 1.13
           */
          protected Create(java.lang.String parent, com.google.api.services.translate.v3.model.Model content) {
            super(Translate.this, "POST", REST_PATH, content, com.google.api.services.translate.v3.model.Operation.class);
            this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
          }

          @Override
          public Create set$Xgafv(java.lang.String $Xgafv) {
            return (Create) super.set$Xgafv($Xgafv);
          }

          @Override
          public Create setAccessToken(java.lang.String accessToken) {
            return (Create) super.setAccessToken(accessToken);
          }

          @Override
          public Create setAlt(java.lang.String alt) {
            return (Create) super.setAlt(alt);
          }

          @Override
          public Create setCallback(java.lang.String callback) {
            return (Create) super.setCallback(callback);
          }

          @Override
          public Create setFields(java.lang.String fields) {
            return (Create) super.setFields(fields);
          }

          @Override
          public Create setKey(java.lang.String key) {
            return (Create) super.setKey(key);
          }

          @Override
          public Create setOauthToken(java.lang.String oauthToken) {
            return (Create) super.setOauthToken(oauthToken);
          }

          @Override
          public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Create) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Create setQuotaUser(java.lang.String quotaUser) {
            return (Create) super.setQuotaUser(quotaUser);
          }

          @Override
          public Create setUploadType(java.lang.String uploadType) {
            return (Create) super.setUploadType(uploadType);
          }

          @Override
          public Create setUploadProtocol(java.lang.String uploadProtocol) {
            return (Create) super.setUploadProtocol(uploadProtocol);
          }

          /** Required. The project name, in form of `projects/{project}/locations/{location}` */
          @com.google.api.client.util.Key
          private java.lang.String parent;

          /** Required. The project name, in form of `projects/{project}/locations/{location}`
           */
          public java.lang.String getParent() {
            return parent;
          }

          /** Required. The project name, in form of `projects/{project}/locations/{location}` */
          public Create setParent(java.lang.String parent) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
            this.parent = parent;
            return this;
          }

          @Override
          public Create set(String parameterName, Object value) {
            return (Create) super.set(parameterName, value);
          }
        }
        /**
         * Deletes a model.
         *
         * Create a request for the method "models.delete".
         *
         * This request holds the parameters needed by the translate server.  After setting any optional
         * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
         *
         * @param name Required. The name of the model to delete.
         * @return the request
         */
        public Delete delete(java.lang.String name) throws java.io.IOException {
          Delete result = new Delete(name);
          initialize(result);
          return result;
        }

        public class Delete extends TranslateRequest<com.google.api.services.translate.v3.model.Operation> {

          private static final String REST_PATH = "v3/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/models/[^/]+$");

          /**
           * Deletes a model.
           *
           * Create a request for the method "models.delete".
           *
           * This request holds the parameters needed by the the translate server.  After setting any
           * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
           * <p> {@link
           * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name Required. The name of the model to delete.
           * @since 1.13
           */
          protected Delete(java.lang.String name) {
            super(Translate.this, "DELETE", REST_PATH, null, com.google.api.services.translate.v3.model.Operation.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/models/[^/]+$");
            }
          }

          @Override
          public Delete set$Xgafv(java.lang.String $Xgafv) {
            return (Delete) super.set$Xgafv($Xgafv);
          }

          @Override
          public Delete setAccessToken(java.lang.String accessToken) {
            return (Delete) super.setAccessToken(accessToken);
          }

          @Override
          public Delete setAlt(java.lang.String alt) {
            return (Delete) super.setAlt(alt);
          }

          @Override
          public Delete setCallback(java.lang.String callback) {
            return (Delete) super.setCallback(callback);
          }

          @Override
          public Delete setFields(java.lang.String fields) {
            return (Delete) super.setFields(fields);
          }

          @Override
          public Delete setKey(java.lang.String key) {
            return (Delete) super.setKey(key);
          }

          @Override
          public Delete setOauthToken(java.lang.String oauthToken) {
            return (Delete) super.setOauthToken(oauthToken);
          }

          @Override
          public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Delete) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Delete setQuotaUser(java.lang.String quotaUser) {
            return (Delete) super.setQuotaUser(quotaUser);
          }

          @Override
          public Delete setUploadType(java.lang.String uploadType) {
            return (Delete) super.setUploadType(uploadType);
          }

          @Override
          public Delete setUploadProtocol(java.lang.String uploadProtocol) {
            return (Delete) super.setUploadProtocol(uploadProtocol);
          }

          /** Required. The name of the model to delete. */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Required. The name of the model to delete.
           */
          public java.lang.String getName() {
            return name;
          }

          /** Required. The name of the model to delete. */
          public Delete setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/models/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Delete set(String parameterName, Object value) {
            return (Delete) super.set(parameterName, value);
          }
        }
        /**
         * Gets a model.
         *
         * Create a request for the method "models.get".
         *
         * This request holds the parameters needed by the translate server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation.
         *
         * @param name Required. The resource name of the model to retrieve.
         * @return the request
         */
        public Get get(java.lang.String name) throws java.io.IOException {
          Get result = new Get(name);
          initialize(result);
          return result;
        }

        public class Get extends TranslateRequest<com.google.api.services.translate.v3.model.Model> {

          private static final String REST_PATH = "v3/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/models/[^/]+$");

          /**
           * Gets a model.
           *
           * Create a request for the method "models.get".
           *
           * This request holds the parameters needed by the the translate server.  After setting any
           * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
           * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name Required. The resource name of the model to retrieve.
           * @since 1.13
           */
          protected Get(java.lang.String name) {
            super(Translate.this, "GET", REST_PATH, null, com.google.api.services.translate.v3.model.Model.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/models/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public Get set$Xgafv(java.lang.String $Xgafv) {
            return (Get) super.set$Xgafv($Xgafv);
          }

          @Override
          public Get setAccessToken(java.lang.String accessToken) {
            return (Get) super.setAccessToken(accessToken);
          }

          @Override
          public Get setAlt(java.lang.String alt) {
            return (Get) super.setAlt(alt);
          }

          @Override
          public Get setCallback(java.lang.String callback) {
            return (Get) super.setCallback(callback);
          }

          @Override
          public Get setFields(java.lang.String fields) {
            return (Get) super.setFields(fields);
          }

          @Override
          public Get setKey(java.lang.String key) {
            return (Get) super.setKey(key);
          }

          @Override
          public Get setOauthToken(java.lang.String oauthToken) {
            return (Get) super.setOauthToken(oauthToken);
          }

          @Override
          public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Get) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Get setQuotaUser(java.lang.String quotaUser) {
            return (Get) super.setQuotaUser(quotaUser);
          }

          @Override
          public Get setUploadType(java.lang.String uploadType) {
            return (Get) super.setUploadType(uploadType);
          }

          @Override
          public Get setUploadProtocol(java.lang.String uploadProtocol) {
            return (Get) super.setUploadProtocol(uploadProtocol);
          }

          /** Required. The resource name of the model to retrieve. */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Required. The resource name of the model to retrieve.
           */
          public java.lang.String getName() {
            return name;
          }

          /** Required. The resource name of the model to retrieve. */
          public Get setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/models/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Get set(String parameterName, Object value) {
            return (Get) super.set(parameterName, value);
          }
        }
        /**
         * Lists models.
         *
         * Create a request for the method "models.list".
         *
         * This request holds the parameters needed by the translate server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation.
         *
         * @param parent Required. Name of the parent project. In form of `projects/{project-number-or-id}/locations
         *        /{location-id}`
         * @return the request
         */
        public List list(java.lang.String parent) throws java.io.IOException {
          List result = new List(parent);
          initialize(result);
          return result;
        }

        public class List extends TranslateRequest<com.google.api.services.translate.v3.model.ListModelsResponse> {

          private static final String REST_PATH = "v3/{+parent}/models";

          private final java.util.regex.Pattern PARENT_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+$");

          /**
           * Lists models.
           *
           * Create a request for the method "models.list".
           *
           * This request holds the parameters needed by the the translate server.  After setting any
           * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
           * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param parent Required. Name of the parent project. In form of `projects/{project-number-or-id}/locations
         *        /{location-id}`
           * @since 1.13
           */
          protected List(java.lang.String parent) {
            super(Translate.this, "GET", REST_PATH, null, com.google.api.services.translate.v3.model.ListModelsResponse.class);
            this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public List set$Xgafv(java.lang.String $Xgafv) {
            return (List) super.set$Xgafv($Xgafv);
          }

          @Override
          public List setAccessToken(java.lang.String accessToken) {
            return (List) super.setAccessToken(accessToken);
          }

          @Override
          public List setAlt(java.lang.String alt) {
            return (List) super.setAlt(alt);
          }

          @Override
          public List setCallback(java.lang.String callback) {
            return (List) super.setCallback(callback);
          }

          @Override
          public List setFields(java.lang.String fields) {
            return (List) super.setFields(fields);
          }

          @Override
          public List setKey(java.lang.String key) {
            return (List) super.setKey(key);
          }

          @Override
          public List setOauthToken(java.lang.String oauthToken) {
            return (List) super.setOauthToken(oauthToken);
          }

          @Override
          public List setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (List) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public List setQuotaUser(java.lang.String quotaUser) {
            return (List) super.setQuotaUser(quotaUser);
          }

          @Override
          public List setUploadType(java.lang.String uploadType) {
            return (List) super.setUploadType(uploadType);
          }

          @Override
          public List setUploadProtocol(java.lang.String uploadProtocol) {
            return (List) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. Name of the parent project. In form of `projects/{project-number-or-
           * id}/locations/{location-id}`
           */
          @com.google.api.client.util.Key
          private java.lang.String parent;

          /** Required. Name of the parent project. In form of `projects/{project-number-or-id}/locations
         /{location-id}`
           */
          public java.lang.String getParent() {
            return parent;
          }

          /**
           * Required. Name of the parent project. In form of `projects/{project-number-or-
           * id}/locations/{location-id}`
           */
          public List setParent(java.lang.String parent) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
            this.parent = parent;
            return this;
          }

          /**
           * Optional. An expression for filtering the models that will be returned. Supported
           * filter: `dataset_id=${dataset_id}`
           */
          @com.google.api.client.util.Key
          private java.lang.String filter;

          /** Optional. An expression for filtering the models that will be returned. Supported filter:
         `dataset_id=${dataset_id}`
           */
          public java.lang.String getFilter() {
            return filter;
          }

          /**
           * Optional. An expression for filtering the models that will be returned. Supported
           * filter: `dataset_id=${dataset_id}`
           */
          public List setFilter(java.lang.String filter) {
            this.filter = filter;
            return this;
          }

          /** Optional. Requested page size. The server can return fewer results than requested. */
          @com.google.api.client.util.Key
          private java.lang.Integer pageSize;

          /** Optional. Requested page size. The server can return fewer results than requested.
           */
          public java.lang.Integer getPageSize() {
            return pageSize;
          }

          /** Optional. Requested page size. The server can return fewer results than requested. */
          public List setPageSize(java.lang.Integer pageSize) {
            this.pageSize = pageSize;
            return this;
          }

          /**
           * Optional. A token identifying a page of results for the server to return. Typically
           * obtained from next_page_token field in the response of a ListModels call.
           */
          @com.google.api.client.util.Key
          private java.lang.String pageToken;

          /** Optional. A token identifying a page of results for the server to return. Typically obtained from
         next_page_token field in the response of a ListModels call.
           */
          public java.lang.String getPageToken() {
            return pageToken;
          }

          /**
           * Optional. A token identifying a page of results for the server to return. Typically
           * obtained from next_page_token field in the response of a ListModels call.
           */
          public List setPageToken(java.lang.String pageToken) {
            this.pageToken = pageToken;
            return this;
          }

          @Override
          public List set(String parameterName, Object value) {
            return (List) super.set(parameterName, value);
          }
        }

      }
      /**
       * An accessor for creating requests from the Operations collection.
       *
       * <p>The typical use is:</p>
       * <pre>
       *   {@code Translate translate = new Translate(...);}
       *   {@code Translate.Operations.List request = translate.operations().list(parameters ...)}
       * </pre>
       *
       * @return the resource collection
       */
      public Operations operations() {
        return new Operations();
      }

      /**
       * The "operations" collection of methods.
       */
      public class Operations {

        /**
         * Starts asynchronous cancellation on a long-running operation. The server makes a best effort to
         * cancel the operation, but success is not guaranteed. If the server doesn't support this method,
         * it returns `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation or other
         * methods to check whether the cancellation succeeded or whether the operation completed despite
         * cancellation. On successful cancellation, the operation is not deleted; instead, it becomes an
         * operation with an Operation.error value with a google.rpc.Status.code of 1, corresponding to
         * `Code.CANCELLED`.
         *
         * Create a request for the method "operations.cancel".
         *
         * This request holds the parameters needed by the translate server.  After setting any optional
         * parameters, call the {@link Cancel#execute()} method to invoke the remote operation.
         *
         * @param name The name of the operation resource to be cancelled.
         * @param content the {@link com.google.api.services.translate.v3.model.CancelOperationRequest}
         * @return the request
         */
        public Cancel cancel(java.lang.String name, com.google.api.services.translate.v3.model.CancelOperationRequest content) throws java.io.IOException {
          Cancel result = new Cancel(name, content);
          initialize(result);
          return result;
        }

        public class Cancel extends TranslateRequest<com.google.api.services.translate.v3.model.Empty> {

          private static final String REST_PATH = "v3/{+name}:cancel";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/operations/[^/]+$");

          /**
           * Starts asynchronous cancellation on a long-running operation. The server makes a best effort to
           * cancel the operation, but success is not guaranteed. If the server doesn't support this method,
           * it returns `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation or other
           * methods to check whether the cancellation succeeded or whether the operation completed despite
           * cancellation. On successful cancellation, the operation is not deleted; instead, it becomes an
           * operation with an Operation.error value with a google.rpc.Status.code of 1, corresponding to
           * `Code.CANCELLED`.
           *
           * Create a request for the method "operations.cancel".
           *
           * This request holds the parameters needed by the the translate server.  After setting any
           * optional parameters, call the {@link Cancel#execute()} method to invoke the remote operation.
           * <p> {@link
           * Cancel#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name The name of the operation resource to be cancelled.
           * @param content the {@link com.google.api.services.translate.v3.model.CancelOperationRequest}
           * @since 1.13
           */
          protected Cancel(java.lang.String name, com.google.api.services.translate.v3.model.CancelOperationRequest content) {
            super(Translate.this, "POST", REST_PATH, content, com.google.api.services.translate.v3.model.Empty.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
            }
          }

          @Override
          public Cancel set$Xgafv(java.lang.String $Xgafv) {
            return (Cancel) super.set$Xgafv($Xgafv);
          }

          @Override
          public Cancel setAccessToken(java.lang.String accessToken) {
            return (Cancel) super.setAccessToken(accessToken);
          }

          @Override
          public Cancel setAlt(java.lang.String alt) {
            return (Cancel) super.setAlt(alt);
          }

          @Override
          public Cancel setCallback(java.lang.String callback) {
            return (Cancel) super.setCallback(callback);
          }

          @Override
          public Cancel setFields(java.lang.String fields) {
            return (Cancel) super.setFields(fields);
          }

          @Override
          public Cancel setKey(java.lang.String key) {
            return (Cancel) super.setKey(key);
          }

          @Override
          public Cancel setOauthToken(java.lang.String oauthToken) {
            return (Cancel) super.setOauthToken(oauthToken);
          }

          @Override
          public Cancel setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Cancel) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Cancel setQuotaUser(java.lang.String quotaUser) {
            return (Cancel) super.setQuotaUser(quotaUser);
          }

          @Override
          public Cancel setUploadType(java.lang.String uploadType) {
            return (Cancel) super.setUploadType(uploadType);
          }

          @Override
          public Cancel setUploadProtocol(java.lang.String uploadProtocol) {
            return (Cancel) super.setUploadProtocol(uploadProtocol);
          }

          /** The name of the operation resource to be cancelled. */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** The name of the operation resource to be cancelled.
           */
          public java.lang.String getName() {
            return name;
          }

          /** The name of the operation resource to be cancelled. */
          public Cancel setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Cancel set(String parameterName, Object value) {
            return (Cancel) super.set(parameterName, value);
          }
        }
        /**
         * Deletes a long-running operation. This method indicates that the client is no longer interested
         * in the operation result. It does not cancel the operation. If the server doesn't support this
         * method, it returns `google.rpc.Code.UNIMPLEMENTED`.
         *
         * Create a request for the method "operations.delete".
         *
         * This request holds the parameters needed by the translate server.  After setting any optional
         * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
         *
         * @param name The name of the operation resource to be deleted.
         * @return the request
         */
        public Delete delete(java.lang.String name) throws java.io.IOException {
          Delete result = new Delete(name);
          initialize(result);
          return result;
        }

        public class Delete extends TranslateRequest<com.google.api.services.translate.v3.model.Empty> {

          private static final String REST_PATH = "v3/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/operations/[^/]+$");

          /**
           * Deletes a long-running operation. This method indicates that the client is no longer interested
           * in the operation result. It does not cancel the operation. If the server doesn't support this
           * method, it returns `google.rpc.Code.UNIMPLEMENTED`.
           *
           * Create a request for the method "operations.delete".
           *
           * This request holds the parameters needed by the the translate server.  After setting any
           * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
           * <p> {@link
           * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name The name of the operation resource to be deleted.
           * @since 1.13
           */
          protected Delete(java.lang.String name) {
            super(Translate.this, "DELETE", REST_PATH, null, com.google.api.services.translate.v3.model.Empty.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
            }
          }

          @Override
          public Delete set$Xgafv(java.lang.String $Xgafv) {
            return (Delete) super.set$Xgafv($Xgafv);
          }

          @Override
          public Delete setAccessToken(java.lang.String accessToken) {
            return (Delete) super.setAccessToken(accessToken);
          }

          @Override
          public Delete setAlt(java.lang.String alt) {
            return (Delete) super.setAlt(alt);
          }

          @Override
          public Delete setCallback(java.lang.String callback) {
            return (Delete) super.setCallback(callback);
          }

          @Override
          public Delete setFields(java.lang.String fields) {
            return (Delete) super.setFields(fields);
          }

          @Override
          public Delete setKey(java.lang.String key) {
            return (Delete) super.setKey(key);
          }

          @Override
          public Delete setOauthToken(java.lang.String oauthToken) {
            return (Delete) super.setOauthToken(oauthToken);
          }

          @Override
          public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Delete) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Delete setQuotaUser(java.lang.String quotaUser) {
            return (Delete) super.setQuotaUser(quotaUser);
          }

          @Override
          public Delete setUploadType(java.lang.String uploadType) {
            return (Delete) super.setUploadType(uploadType);
          }

          @Override
          public Delete setUploadProtocol(java.lang.String uploadProtocol) {
            return (Delete) super.setUploadProtocol(uploadProtocol);
          }

          /** The name of the operation resource to be deleted. */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** The name of the operation resource to be deleted.
           */
          public java.lang.String getName() {
            return name;
          }

          /** The name of the operation resource to be deleted. */
          public Delete setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Delete set(String parameterName, Object value) {
            return (Delete) super.set(parameterName, value);
          }
        }
        /**
         * Gets the latest state of a long-running operation. Clients can use this method to poll the
         * operation result at intervals as recommended by the API service.
         *
         * Create a request for the method "operations.get".
         *
         * This request holds the parameters needed by the translate server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation.
         *
         * @param name The name of the operation resource.
         * @return the request
         */
        public Get get(java.lang.String name) throws java.io.IOException {
          Get result = new Get(name);
          initialize(result);
          return result;
        }

        public class Get extends TranslateRequest<com.google.api.services.translate.v3.model.Operation> {

          private static final String REST_PATH = "v3/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/operations/[^/]+$");

          /**
           * Gets the latest state of a long-running operation. Clients can use this method to poll the
           * operation result at intervals as recommended by the API service.
           *
           * Create a request for the method "operations.get".
           *
           * This request holds the parameters needed by the the translate server.  After setting any
           * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
           * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name The name of the operation resource.
           * @since 1.13
           */
          protected Get(java.lang.String name) {
            super(Translate.this, "GET", REST_PATH, null, com.google.api.services.translate.v3.model.Operation.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public Get set$Xgafv(java.lang.String $Xgafv) {
            return (Get) super.set$Xgafv($Xgafv);
          }

          @Override
          public Get setAccessToken(java.lang.String accessToken) {
            return (Get) super.setAccessToken(accessToken);
          }

          @Override
          public Get setAlt(java.lang.String alt) {
            return (Get) super.setAlt(alt);
          }

          @Override
          public Get setCallback(java.lang.String callback) {
            return (Get) super.setCallback(callback);
          }

          @Override
          public Get setFields(java.lang.String fields) {
            return (Get) super.setFields(fields);
          }

          @Override
          public Get setKey(java.lang.String key) {
            return (Get) super.setKey(key);
          }

          @Override
          public Get setOauthToken(java.lang.String oauthToken) {
            return (Get) super.setOauthToken(oauthToken);
          }

          @Override
          public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Get) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Get setQuotaUser(java.lang.String quotaUser) {
            return (Get) super.setQuotaUser(quotaUser);
          }

          @Override
          public Get setUploadType(java.lang.String uploadType) {
            return (Get) super.setUploadType(uploadType);
          }

          @Override
          public Get setUploadProtocol(java.lang.String uploadProtocol) {
            return (Get) super.setUploadProtocol(uploadProtocol);
          }

          /** The name of the operation resource. */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** The name of the operation resource.
           */
          public java.lang.String getName() {
            return name;
          }

          /** The name of the operation resource. */
          public Get setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Get set(String parameterName, Object value) {
            return (Get) super.set(parameterName, value);
          }
        }
        /**
         * Lists operations that match the specified filter in the request. If the server doesn't support
         * this method, it returns `UNIMPLEMENTED`.
         *
         * Create a request for the method "operations.list".
         *
         * This request holds the parameters needed by the translate server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation.
         *
         * @param name The name of the operation's parent resource.
         * @return the request
         */
        public List list(java.lang.String name) throws java.io.IOException {
          List result = new List(name);
          initialize(result);
          return result;
        }

        public class List extends TranslateRequest<com.google.api.services.translate.v3.model.ListOperationsResponse> {

          private static final String REST_PATH = "v3/{+name}/operations";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+$");

          /**
           * Lists operations that match the specified filter in the request. If the server doesn't support
           * this method, it returns `UNIMPLEMENTED`.
           *
           * Create a request for the method "operations.list".
           *
           * This request holds the parameters needed by the the translate server.  After setting any
           * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
           * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name The name of the operation's parent resource.
           * @since 1.13
           */
          protected List(java.lang.String name) {
            super(Translate.this, "GET", REST_PATH, null, com.google.api.services.translate.v3.model.ListOperationsResponse.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public List set$Xgafv(java.lang.String $Xgafv) {
            return (List) super.set$Xgafv($Xgafv);
          }

          @Override
          public List setAccessToken(java.lang.String accessToken) {
            return (List) super.setAccessToken(accessToken);
          }

          @Override
          public List setAlt(java.lang.String alt) {
            return (List) super.setAlt(alt);
          }

          @Override
          public List setCallback(java.lang.String callback) {
            return (List) super.setCallback(callback);
          }

          @Override
          public List setFields(java.lang.String fields) {
            return (List) super.setFields(fields);
          }

          @Override
          public List setKey(java.lang.String key) {
            return (List) super.setKey(key);
          }

          @Override
          public List setOauthToken(java.lang.String oauthToken) {
            return (List) super.setOauthToken(oauthToken);
          }

          @Override
          public List setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (List) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public List setQuotaUser(java.lang.String quotaUser) {
            return (List) super.setQuotaUser(quotaUser);
          }

          @Override
          public List setUploadType(java.lang.String uploadType) {
            return (List) super.setUploadType(uploadType);
          }

          @Override
          public List setUploadProtocol(java.lang.String uploadProtocol) {
            return (List) super.setUploadProtocol(uploadProtocol);
          }

          /** The name of the operation's parent resource. */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** The name of the operation's parent resource.
           */
          public java.lang.String getName() {
            return name;
          }

          /** The name of the operation's parent resource. */
          public List setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
            this.name = name;
            return this;
          }

          /** The standard list filter. */
          @com.google.api.client.util.Key
          private java.lang.String filter;

          /** The standard list filter.
           */
          public java.lang.String getFilter() {
            return filter;
          }

          /** The standard list filter. */
          public List setFilter(java.lang.String filter) {
            this.filter = filter;
            return this;
          }

          /** The standard list page size. */
          @com.google.api.client.util.Key
          private java.lang.Integer pageSize;

          /** The standard list page size.
           */
          public java.lang.Integer getPageSize() {
            return pageSize;
          }

          /** The standard list page size. */
          public List setPageSize(java.lang.Integer pageSize) {
            this.pageSize = pageSize;
            return this;
          }

          /** The standard list page token. */
          @com.google.api.client.util.Key
          private java.lang.String pageToken;

          /** The standard list page token.
           */
          public java.lang.String getPageToken() {
            return pageToken;
          }

          /** The standard list page token. */
          public List setPageToken(java.lang.String pageToken) {
            this.pageToken = pageToken;
            return this;
          }

          @Override
          public List set(String parameterName, Object value) {
            return (List) super.set(parameterName, value);
          }
        }
        /**
         * Waits until the specified long-running operation is done or reaches at most a specified timeout,
         * returning the latest state. If the operation is already done, the latest state is immediately
         * returned. If the timeout specified is greater than the default HTTP/RPC timeout, the HTTP/RPC
         * timeout is used. If the server does not support this method, it returns
         * `google.rpc.Code.UNIMPLEMENTED`. Note that this method is on a best-effort basis. It may return
         * the latest state before the specified timeout (including immediately), meaning even an immediate
         * response is no guarantee that the operation is done.
         *
         * Create a request for the method "operations.wait".
         *
         * This request holds the parameters needed by the translate server.  After setting any optional
         * parameters, call the {@link Wait#execute()} method to invoke the remote operation.
         *
         * @param name The name of the operation resource to wait on.
         * @param content the {@link com.google.api.services.translate.v3.model.WaitOperationRequest}
         * @return the request
         */
        public Wait wait(java.lang.String name, com.google.api.services.translate.v3.model.WaitOperationRequest content) throws java.io.IOException {
          Wait result = new Wait(name, content);
          initialize(result);
          return result;
        }

        public class Wait extends TranslateRequest<com.google.api.services.translate.v3.model.Operation> {

          private static final String REST_PATH = "v3/{+name}:wait";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/operations/[^/]+$");

          /**
           * Waits until the specified long-running operation is done or reaches at most a specified
           * timeout, returning the latest state. If the operation is already done, the latest state is
           * immediately returned. If the timeout specified is greater than the default HTTP/RPC timeout,
           * the HTTP/RPC timeout is used. If the server does not support this method, it returns
           * `google.rpc.Code.UNIMPLEMENTED`. Note that this method is on a best-effort basis. It may return
           * the latest state before the specified timeout (including immediately), meaning even an
           * immediate response is no guarantee that the operation is done.
           *
           * Create a request for the method "operations.wait".
           *
           * This request holds the parameters needed by the the translate server.  After setting any
           * optional parameters, call the {@link Wait#execute()} method to invoke the remote operation. <p>
           * {@link Wait#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name The name of the operation resource to wait on.
           * @param content the {@link com.google.api.services.translate.v3.model.WaitOperationRequest}
           * @since 1.13
           */
          protected Wait(java.lang.String name, com.google.api.services.translate.v3.model.WaitOperationRequest content) {
            super(Translate.this, "POST", REST_PATH, content, com.google.api.services.translate.v3.model.Operation.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
            }
          }

          @Override
          public Wait set$Xgafv(java.lang.String $Xgafv) {
            return (Wait) super.set$Xgafv($Xgafv);
          }

          @Override
          public Wait setAccessToken(java.lang.String accessToken) {
            return (Wait) super.setAccessToken(accessToken);
          }

          @Override
          public Wait setAlt(java.lang.String alt) {
            return (Wait) super.setAlt(alt);
          }

          @Override
          public Wait setCallback(java.lang.String callback) {
            return (Wait) super.setCallback(callback);
          }

          @Override
          public Wait setFields(java.lang.String fields) {
            return (Wait) super.setFields(fields);
          }

          @Override
          public Wait setKey(java.lang.String key) {
            return (Wait) super.setKey(key);
          }

          @Override
          public Wait setOauthToken(java.lang.String oauthToken) {
            return (Wait) super.setOauthToken(oauthToken);
          }

          @Override
          public Wait setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Wait) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Wait setQuotaUser(java.lang.String quotaUser) {
            return (Wait) super.setQuotaUser(quotaUser);
          }

          @Override
          public Wait setUploadType(java.lang.String uploadType) {
            return (Wait) super.setUploadType(uploadType);
          }

          @Override
          public Wait setUploadProtocol(java.lang.String uploadProtocol) {
            return (Wait) super.setUploadProtocol(uploadProtocol);
          }

          /** The name of the operation resource to wait on. */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** The name of the operation resource to wait on.
           */
          public java.lang.String getName() {
            return name;
          }

          /** The name of the operation resource to wait on. */
          public Wait setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Wait set(String parameterName, Object value) {
            return (Wait) super.set(parameterName, value);
          }
        }

      }
    }
  }

  /**
   * Builder for {@link Translate}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient.Builder {

    private static String chooseEndpoint(com.google.api.client.http.HttpTransport transport) {
      // If the GOOGLE_API_USE_MTLS_ENDPOINT environment variable value is "always", use mTLS endpoint.
      // If the env variable is "auto", use mTLS endpoint if and only if the transport is mTLS.
      // Use the regular endpoint for all other cases.
      String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
      useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
      if ("always".equals(useMtlsEndpoint) || ("auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls())) {
        return DEFAULT_MTLS_ROOT_URL;
      }
      return DEFAULT_ROOT_URL;
    }

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport, which should normally be:
     *        <ul>
     *        <li>Google App Engine:
     *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
     *        <li>Android: {@code newCompatibleTransport} from
     *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
     *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
     *        </li>
     *        </ul>
     * @param jsonFactory JSON factory, which may be:
     *        <ul>
     *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
     *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
     *        <li>Android Honeycomb or higher:
     *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
     *        </ul>
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          Builder.chooseEndpoint(transport),
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
      setBatchPath(DEFAULT_BATCH_PATH);
    }

    /** Builds a new instance of {@link Translate}. */
    @Override
    public Translate build() {
      return new Translate(this);
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setBatchPath(String batchPath) {
      return (Builder) super.setBatchPath(batchPath);
    }

    @Override
    public Builder setHttpRequestInitializer(com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    @Override
    public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
      return (Builder) super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
    }

    @Override
    public Builder setSuppressAllChecks(boolean suppressAllChecks) {
      return (Builder) super.setSuppressAllChecks(suppressAllChecks);
    }

    /**
     * Set the {@link TranslateRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setTranslateRequestInitializer(
        TranslateRequestInitializer translateRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(translateRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        com.google.api.client.googleapis.services.GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
