/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.translate.v3.model;

/**
 * An Adaptive MT Dataset.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Translation API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AdaptiveMtDataset extends com.google.api.client.json.GenericJson {

  /**
   * Output only. Timestamp when this dataset was created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String createTime;

  /**
   * The name of the dataset to show in the interface. The name can be up to 32 characters long and
   * can consist only of ASCII Latin letters A-Z and a-z, underscores (_), and ASCII digits 0-9.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String displayName;

  /**
   * The number of examples in the dataset.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer exampleCount;

  /**
   * Required. The resource name of the dataset, in form of `projects/{project-number-or-
   * id}/locations/{location_id}/adaptiveMtDatasets/{dataset_id}`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The BCP-47 language code of the source language.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sourceLanguageCode;

  /**
   * The BCP-47 language code of the target language.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String targetLanguageCode;

  /**
   * Output only. Timestamp when this dataset was last updated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String updateTime;

  /**
   * Output only. Timestamp when this dataset was created.
   * @return value or {@code null} for none
   */
  public String getCreateTime() {
    return createTime;
  }

  /**
   * Output only. Timestamp when this dataset was created.
   * @param createTime createTime or {@code null} for none
   */
  public AdaptiveMtDataset setCreateTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

  /**
   * The name of the dataset to show in the interface. The name can be up to 32 characters long and
   * can consist only of ASCII Latin letters A-Z and a-z, underscores (_), and ASCII digits 0-9.
   * @return value or {@code null} for none
   */
  public java.lang.String getDisplayName() {
    return displayName;
  }

  /**
   * The name of the dataset to show in the interface. The name can be up to 32 characters long and
   * can consist only of ASCII Latin letters A-Z and a-z, underscores (_), and ASCII digits 0-9.
   * @param displayName displayName or {@code null} for none
   */
  public AdaptiveMtDataset setDisplayName(java.lang.String displayName) {
    this.displayName = displayName;
    return this;
  }

  /**
   * The number of examples in the dataset.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getExampleCount() {
    return exampleCount;
  }

  /**
   * The number of examples in the dataset.
   * @param exampleCount exampleCount or {@code null} for none
   */
  public AdaptiveMtDataset setExampleCount(java.lang.Integer exampleCount) {
    this.exampleCount = exampleCount;
    return this;
  }

  /**
   * Required. The resource name of the dataset, in form of `projects/{project-number-or-
   * id}/locations/{location_id}/adaptiveMtDatasets/{dataset_id}`
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Required. The resource name of the dataset, in form of `projects/{project-number-or-
   * id}/locations/{location_id}/adaptiveMtDatasets/{dataset_id}`
   * @param name name or {@code null} for none
   */
  public AdaptiveMtDataset setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The BCP-47 language code of the source language.
   * @return value or {@code null} for none
   */
  public java.lang.String getSourceLanguageCode() {
    return sourceLanguageCode;
  }

  /**
   * The BCP-47 language code of the source language.
   * @param sourceLanguageCode sourceLanguageCode or {@code null} for none
   */
  public AdaptiveMtDataset setSourceLanguageCode(java.lang.String sourceLanguageCode) {
    this.sourceLanguageCode = sourceLanguageCode;
    return this;
  }

  /**
   * The BCP-47 language code of the target language.
   * @return value or {@code null} for none
   */
  public java.lang.String getTargetLanguageCode() {
    return targetLanguageCode;
  }

  /**
   * The BCP-47 language code of the target language.
   * @param targetLanguageCode targetLanguageCode or {@code null} for none
   */
  public AdaptiveMtDataset setTargetLanguageCode(java.lang.String targetLanguageCode) {
    this.targetLanguageCode = targetLanguageCode;
    return this;
  }

  /**
   * Output only. Timestamp when this dataset was last updated.
   * @return value or {@code null} for none
   */
  public String getUpdateTime() {
    return updateTime;
  }

  /**
   * Output only. Timestamp when this dataset was last updated.
   * @param updateTime updateTime or {@code null} for none
   */
  public AdaptiveMtDataset setUpdateTime(String updateTime) {
    this.updateTime = updateTime;
    return this;
  }

  @Override
  public AdaptiveMtDataset set(String fieldName, Object value) {
    return (AdaptiveMtDataset) super.set(fieldName, value);
  }

  @Override
  public AdaptiveMtDataset clone() {
    return (AdaptiveMtDataset) super.clone();
  }

}
