/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.translate.v3.model;

/**
 * An AdaptiveMtFile.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Translation API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AdaptiveMtFile extends com.google.api.client.json.GenericJson {

  /**
   * Output only. Timestamp when this file was created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String createTime;

  /**
   * The file's display name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String displayName;

  /**
   * The number of entries that the file contains.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer entryCount;

  /**
   * Required. The resource name of the file, in form of `projects/{project-number-or-
   * id}/locations/{location_id}/adaptiveMtDatasets/{dataset}/files/{file}`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Output only. Timestamp when this file was last updated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String updateTime;

  /**
   * Output only. Timestamp when this file was created.
   * @return value or {@code null} for none
   */
  public String getCreateTime() {
    return createTime;
  }

  /**
   * Output only. Timestamp when this file was created.
   * @param createTime createTime or {@code null} for none
   */
  public AdaptiveMtFile setCreateTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

  /**
   * The file's display name.
   * @return value or {@code null} for none
   */
  public java.lang.String getDisplayName() {
    return displayName;
  }

  /**
   * The file's display name.
   * @param displayName displayName or {@code null} for none
   */
  public AdaptiveMtFile setDisplayName(java.lang.String displayName) {
    this.displayName = displayName;
    return this;
  }

  /**
   * The number of entries that the file contains.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getEntryCount() {
    return entryCount;
  }

  /**
   * The number of entries that the file contains.
   * @param entryCount entryCount or {@code null} for none
   */
  public AdaptiveMtFile setEntryCount(java.lang.Integer entryCount) {
    this.entryCount = entryCount;
    return this;
  }

  /**
   * Required. The resource name of the file, in form of `projects/{project-number-or-
   * id}/locations/{location_id}/adaptiveMtDatasets/{dataset}/files/{file}`
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Required. The resource name of the file, in form of `projects/{project-number-or-
   * id}/locations/{location_id}/adaptiveMtDatasets/{dataset}/files/{file}`
   * @param name name or {@code null} for none
   */
  public AdaptiveMtFile setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Output only. Timestamp when this file was last updated.
   * @return value or {@code null} for none
   */
  public String getUpdateTime() {
    return updateTime;
  }

  /**
   * Output only. Timestamp when this file was last updated.
   * @param updateTime updateTime or {@code null} for none
   */
  public AdaptiveMtFile setUpdateTime(String updateTime) {
    this.updateTime = updateTime;
    return this;
  }

  @Override
  public AdaptiveMtFile set(String fieldName, Object value) {
    return (AdaptiveMtFile) super.set(fieldName, value);
  }

  @Override
  public AdaptiveMtFile clone() {
    return (AdaptiveMtFile) super.clone();
  }

}
