/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.translate.v3.model;

/**
 * An AdaptiveMt sentence entry.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Translation API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AdaptiveMtSentence extends com.google.api.client.json.GenericJson {

  /**
   * Output only. Timestamp when this sentence was created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String createTime;

  /**
   * Required. The resource name of the file, in form of `projects/{project-number-or-
   * id}/locations/{location_id}/adaptiveMtDatasets/{dataset}/files/{file}/sentences/{sentence}`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Required. The source sentence.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sourceSentence;

  /**
   * Required. The target sentence.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String targetSentence;

  /**
   * Output only. Timestamp when this sentence was last updated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String updateTime;

  /**
   * Output only. Timestamp when this sentence was created.
   * @return value or {@code null} for none
   */
  public String getCreateTime() {
    return createTime;
  }

  /**
   * Output only. Timestamp when this sentence was created.
   * @param createTime createTime or {@code null} for none
   */
  public AdaptiveMtSentence setCreateTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

  /**
   * Required. The resource name of the file, in form of `projects/{project-number-or-
   * id}/locations/{location_id}/adaptiveMtDatasets/{dataset}/files/{file}/sentences/{sentence}`
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Required. The resource name of the file, in form of `projects/{project-number-or-
   * id}/locations/{location_id}/adaptiveMtDatasets/{dataset}/files/{file}/sentences/{sentence}`
   * @param name name or {@code null} for none
   */
  public AdaptiveMtSentence setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Required. The source sentence.
   * @return value or {@code null} for none
   */
  public java.lang.String getSourceSentence() {
    return sourceSentence;
  }

  /**
   * Required. The source sentence.
   * @param sourceSentence sourceSentence or {@code null} for none
   */
  public AdaptiveMtSentence setSourceSentence(java.lang.String sourceSentence) {
    this.sourceSentence = sourceSentence;
    return this;
  }

  /**
   * Required. The target sentence.
   * @return value or {@code null} for none
   */
  public java.lang.String getTargetSentence() {
    return targetSentence;
  }

  /**
   * Required. The target sentence.
   * @param targetSentence targetSentence or {@code null} for none
   */
  public AdaptiveMtSentence setTargetSentence(java.lang.String targetSentence) {
    this.targetSentence = targetSentence;
    return this;
  }

  /**
   * Output only. Timestamp when this sentence was last updated.
   * @return value or {@code null} for none
   */
  public String getUpdateTime() {
    return updateTime;
  }

  /**
   * Output only. Timestamp when this sentence was last updated.
   * @param updateTime updateTime or {@code null} for none
   */
  public AdaptiveMtSentence setUpdateTime(String updateTime) {
    this.updateTime = updateTime;
    return this;
  }

  @Override
  public AdaptiveMtSentence set(String fieldName, Object value) {
    return (AdaptiveMtSentence) super.set(fieldName, value);
  }

  @Override
  public AdaptiveMtSentence clone() {
    return (AdaptiveMtSentence) super.clone();
  }

}
