/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.translate.v3.model;

/**
 * The request for sending an AdaptiveMt translation query.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Translation API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AdaptiveMtTranslateRequest extends com.google.api.client.json.GenericJson {

  /**
   * Required. The content of the input in string format. For now only one sentence per request is
   * supported.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> content;

  /**
   * Required. The resource name for the dataset to use for adaptive MT.
   * `projects/{project}/locations/{location-id}/adaptiveMtDatasets/{dataset}`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String dataset;

  /**
   * Required. The content of the input in string format. For now only one sentence per request is
   * supported.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getContent() {
    return content;
  }

  /**
   * Required. The content of the input in string format. For now only one sentence per request is
   * supported.
   * @param content content or {@code null} for none
   */
  public AdaptiveMtTranslateRequest setContent(java.util.List<java.lang.String> content) {
    this.content = content;
    return this;
  }

  /**
   * Required. The resource name for the dataset to use for adaptive MT.
   * `projects/{project}/locations/{location-id}/adaptiveMtDatasets/{dataset}`
   * @return value or {@code null} for none
   */
  public java.lang.String getDataset() {
    return dataset;
  }

  /**
   * Required. The resource name for the dataset to use for adaptive MT.
   * `projects/{project}/locations/{location-id}/adaptiveMtDatasets/{dataset}`
   * @param dataset dataset or {@code null} for none
   */
  public AdaptiveMtTranslateRequest setDataset(java.lang.String dataset) {
    this.dataset = dataset;
    return this;
  }

  @Override
  public AdaptiveMtTranslateRequest set(String fieldName, Object value) {
    return (AdaptiveMtTranslateRequest) super.set(fieldName, value);
  }

  @Override
  public AdaptiveMtTranslateRequest clone() {
    return (AdaptiveMtTranslateRequest) super.clone();
  }

}
