/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.translate.v3.model;

/**
 * Input configuration for BatchTranslateDocument request.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Translation API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BatchDocumentInputConfig extends com.google.api.client.json.GenericJson {

  /**
   * Google Cloud Storage location for the source input. This can be a single file (for example, `gs
   * ://translation-test/input.docx`) or a wildcard (for example, `gs://translation-test`). File
   * mime type is determined based on extension. Supported mime type includes: - `pdf`,
   * application/pdf - `docx`, application/vnd.openxmlformats-
   * officedocument.wordprocessingml.document - `pptx`, application/vnd.openxmlformats-
   * officedocument.presentationml.presentation - `xlsx`, application/vnd.openxmlformats-
   * officedocument.spreadsheetml.sheet The max file size to support for `.docx`, `.pptx` and
   * `.xlsx` is 100MB. The max file size to support for `.pdf` is 1GB and the max page limit is 1000
   * pages. The max file size to support for all input documents is 1GB.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GcsSource gcsSource;

  /**
   * Google Cloud Storage location for the source input. This can be a single file (for example, `gs
   * ://translation-test/input.docx`) or a wildcard (for example, `gs://translation-test`). File
   * mime type is determined based on extension. Supported mime type includes: - `pdf`,
   * application/pdf - `docx`, application/vnd.openxmlformats-
   * officedocument.wordprocessingml.document - `pptx`, application/vnd.openxmlformats-
   * officedocument.presentationml.presentation - `xlsx`, application/vnd.openxmlformats-
   * officedocument.spreadsheetml.sheet The max file size to support for `.docx`, `.pptx` and
   * `.xlsx` is 100MB. The max file size to support for `.pdf` is 1GB and the max page limit is 1000
   * pages. The max file size to support for all input documents is 1GB.
   * @return value or {@code null} for none
   */
  public GcsSource getGcsSource() {
    return gcsSource;
  }

  /**
   * Google Cloud Storage location for the source input. This can be a single file (for example, `gs
   * ://translation-test/input.docx`) or a wildcard (for example, `gs://translation-test`). File
   * mime type is determined based on extension. Supported mime type includes: - `pdf`,
   * application/pdf - `docx`, application/vnd.openxmlformats-
   * officedocument.wordprocessingml.document - `pptx`, application/vnd.openxmlformats-
   * officedocument.presentationml.presentation - `xlsx`, application/vnd.openxmlformats-
   * officedocument.spreadsheetml.sheet The max file size to support for `.docx`, `.pptx` and
   * `.xlsx` is 100MB. The max file size to support for `.pdf` is 1GB and the max page limit is 1000
   * pages. The max file size to support for all input documents is 1GB.
   * @param gcsSource gcsSource or {@code null} for none
   */
  public BatchDocumentInputConfig setGcsSource(GcsSource gcsSource) {
    this.gcsSource = gcsSource;
    return this;
  }

  @Override
  public BatchDocumentInputConfig set(String fieldName, Object value) {
    return (BatchDocumentInputConfig) super.set(fieldName, value);
  }

  @Override
  public BatchDocumentInputConfig clone() {
    return (BatchDocumentInputConfig) super.clone();
  }

}
