/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.translate.v3.model;

/**
 * The request message for language detection.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Translation API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DetectLanguageRequest extends com.google.api.client.json.GenericJson {

  /**
   * The content of the input stored as a string.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String content;

  /**
   * Optional. The labels with user-defined metadata for the request. Label keys and values can be
   * no longer than 63 characters (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed. Label values are
   * optional. Label keys must start with a letter. See
   * https://cloud.google.com/translate/docs/advanced/labels for more information.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> labels;

  /**
   * Optional. The format of the source text, for example, "text/html", "text/plain". If left blank,
   * the MIME type defaults to "text/html".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String mimeType;

  /**
   * Optional. The language detection model to be used. Format: `projects/{project-number-or-
   * id}/locations/{location-id}/models/language-detection/{model-id}` Only one language detection
   * model is currently supported: `projects/{project-number-or-id}/locations/{location-id}/models
   * /language-detection/default`. If not specified, the default model is used.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String model;

  /**
   * The content of the input stored as a string.
   * @return value or {@code null} for none
   */
  public java.lang.String getContent() {
    return content;
  }

  /**
   * The content of the input stored as a string.
   * @param content content or {@code null} for none
   */
  public DetectLanguageRequest setContent(java.lang.String content) {
    this.content = content;
    return this;
  }

  /**
   * Optional. The labels with user-defined metadata for the request. Label keys and values can be
   * no longer than 63 characters (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed. Label values are
   * optional. Label keys must start with a letter. See
   * https://cloud.google.com/translate/docs/advanced/labels for more information.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getLabels() {
    return labels;
  }

  /**
   * Optional. The labels with user-defined metadata for the request. Label keys and values can be
   * no longer than 63 characters (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed. Label values are
   * optional. Label keys must start with a letter. See
   * https://cloud.google.com/translate/docs/advanced/labels for more information.
   * @param labels labels or {@code null} for none
   */
  public DetectLanguageRequest setLabels(java.util.Map<String, java.lang.String> labels) {
    this.labels = labels;
    return this;
  }

  /**
   * Optional. The format of the source text, for example, "text/html", "text/plain". If left blank,
   * the MIME type defaults to "text/html".
   * @return value or {@code null} for none
   */
  public java.lang.String getMimeType() {
    return mimeType;
  }

  /**
   * Optional. The format of the source text, for example, "text/html", "text/plain". If left blank,
   * the MIME type defaults to "text/html".
   * @param mimeType mimeType or {@code null} for none
   */
  public DetectLanguageRequest setMimeType(java.lang.String mimeType) {
    this.mimeType = mimeType;
    return this;
  }

  /**
   * Optional. The language detection model to be used. Format: `projects/{project-number-or-
   * id}/locations/{location-id}/models/language-detection/{model-id}` Only one language detection
   * model is currently supported: `projects/{project-number-or-id}/locations/{location-id}/models
   * /language-detection/default`. If not specified, the default model is used.
   * @return value or {@code null} for none
   */
  public java.lang.String getModel() {
    return model;
  }

  /**
   * Optional. The language detection model to be used. Format: `projects/{project-number-or-
   * id}/locations/{location-id}/models/language-detection/{model-id}` Only one language detection
   * model is currently supported: `projects/{project-number-or-id}/locations/{location-id}/models
   * /language-detection/default`. If not specified, the default model is used.
   * @param model model or {@code null} for none
   */
  public DetectLanguageRequest setModel(java.lang.String model) {
    this.model = model;
    return this;
  }

  @Override
  public DetectLanguageRequest set(String fieldName, Object value) {
    return (DetectLanguageRequest) super.set(fieldName, value);
  }

  @Override
  public DetectLanguageRequest clone() {
    return (DetectLanguageRequest) super.clone();
  }

}
