/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.translate.v3.model;

/**
 * A translated document message.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Translation API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DocumentTranslation extends com.google.api.client.json.GenericJson {

  /**
   * The array of translated documents. It is expected to be size 1 for now. We may produce multiple
   * translated documents in the future for other type of file formats.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> byteStreamOutputs;

  /**
   * The detected language for the input document. If the user did not provide the source language
   * for the input document, this field will have the language code automatically detected. If the
   * source language was passed, auto-detection of the language does not occur and this field is
   * empty.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String detectedLanguageCode;

  /**
   * The translated document's mime type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String mimeType;

  /**
   * The array of translated documents. It is expected to be size 1 for now. We may produce multiple
   * translated documents in the future for other type of file formats.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getByteStreamOutputs() {
    return byteStreamOutputs;
  }

  /**
   * The array of translated documents. It is expected to be size 1 for now. We may produce multiple
   * translated documents in the future for other type of file formats.
   * @param byteStreamOutputs byteStreamOutputs or {@code null} for none
   */
  public DocumentTranslation setByteStreamOutputs(java.util.List<java.lang.String> byteStreamOutputs) {
    this.byteStreamOutputs = byteStreamOutputs;
    return this;
  }

  /**
   * The detected language for the input document. If the user did not provide the source language
   * for the input document, this field will have the language code automatically detected. If the
   * source language was passed, auto-detection of the language does not occur and this field is
   * empty.
   * @return value or {@code null} for none
   */
  public java.lang.String getDetectedLanguageCode() {
    return detectedLanguageCode;
  }

  /**
   * The detected language for the input document. If the user did not provide the source language
   * for the input document, this field will have the language code automatically detected. If the
   * source language was passed, auto-detection of the language does not occur and this field is
   * empty.
   * @param detectedLanguageCode detectedLanguageCode or {@code null} for none
   */
  public DocumentTranslation setDetectedLanguageCode(java.lang.String detectedLanguageCode) {
    this.detectedLanguageCode = detectedLanguageCode;
    return this;
  }

  /**
   * The translated document's mime type.
   * @return value or {@code null} for none
   */
  public java.lang.String getMimeType() {
    return mimeType;
  }

  /**
   * The translated document's mime type.
   * @param mimeType mimeType or {@code null} for none
   */
  public DocumentTranslation setMimeType(java.lang.String mimeType) {
    this.mimeType = mimeType;
    return this;
  }

  @Override
  public DocumentTranslation set(String fieldName, Object value) {
    return (DocumentTranslation) super.set(fieldName, value);
  }

  @Override
  public DocumentTranslation clone() {
    return (DocumentTranslation) super.clone();
  }

}
