/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.translate.v3.model;

/**
 * A sentence pair.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Translation API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Example extends com.google.api.client.json.GenericJson {

  /**
   * Output only. The resource name of the example, in form of `projects/{project-number-or-
   * id}/locations/{location_id}/datasets/{dataset_id}/examples/{example_id}'
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Sentence in source language.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sourceText;

  /**
   * Sentence in target language.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String targetText;

  /**
   * Output only. Usage of the sentence pair. Options are TRAIN|VALIDATION|TEST.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String usage;

  /**
   * Output only. The resource name of the example, in form of `projects/{project-number-or-
   * id}/locations/{location_id}/datasets/{dataset_id}/examples/{example_id}'
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Output only. The resource name of the example, in form of `projects/{project-number-or-
   * id}/locations/{location_id}/datasets/{dataset_id}/examples/{example_id}'
   * @param name name or {@code null} for none
   */
  public Example setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Sentence in source language.
   * @return value or {@code null} for none
   */
  public java.lang.String getSourceText() {
    return sourceText;
  }

  /**
   * Sentence in source language.
   * @param sourceText sourceText or {@code null} for none
   */
  public Example setSourceText(java.lang.String sourceText) {
    this.sourceText = sourceText;
    return this;
  }

  /**
   * Sentence in target language.
   * @return value or {@code null} for none
   */
  public java.lang.String getTargetText() {
    return targetText;
  }

  /**
   * Sentence in target language.
   * @param targetText targetText or {@code null} for none
   */
  public Example setTargetText(java.lang.String targetText) {
    this.targetText = targetText;
    return this;
  }

  /**
   * Output only. Usage of the sentence pair. Options are TRAIN|VALIDATION|TEST.
   * @return value or {@code null} for none
   */
  public java.lang.String getUsage() {
    return usage;
  }

  /**
   * Output only. Usage of the sentence pair. Options are TRAIN|VALIDATION|TEST.
   * @param usage usage or {@code null} for none
   */
  public Example setUsage(java.lang.String usage) {
    this.usage = usage;
    return this;
  }

  @Override
  public Example set(String fieldName, Object value) {
    return (Example) super.set(fieldName, value);
  }

  @Override
  public Example clone() {
    return (Example) super.clone();
  }

}
