/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.translate.v3.model;

/**
 * Represents a glossary built from user-provided data.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Translation API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Glossary extends com.google.api.client.json.GenericJson {

  /**
   * Optional. The display name of the glossary.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String displayName;

  /**
   * Output only. When the glossary creation was finished.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String endTime;

  /**
   * Output only. The number of entries defined in the glossary.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer entryCount;

  /**
   * Required. Provides examples to build the glossary from. Total glossary must not exceed 10M
   * Unicode codepoints.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GlossaryInputConfig inputConfig;

  /**
   * Used with equivalent term set glossaries.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LanguageCodesSet languageCodesSet;

  /**
   * Used with unidirectional glossaries.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LanguageCodePair languagePair;

  /**
   * Required. The resource name of the glossary. Glossary names have the form `projects/{project-
   * number-or-id}/locations/{location-id}/glossaries/{glossary-id}`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Output only. When CreateGlossary was called.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String submitTime;

  /**
   * Optional. The display name of the glossary.
   * @return value or {@code null} for none
   */
  public java.lang.String getDisplayName() {
    return displayName;
  }

  /**
   * Optional. The display name of the glossary.
   * @param displayName displayName or {@code null} for none
   */
  public Glossary setDisplayName(java.lang.String displayName) {
    this.displayName = displayName;
    return this;
  }

  /**
   * Output only. When the glossary creation was finished.
   * @return value or {@code null} for none
   */
  public String getEndTime() {
    return endTime;
  }

  /**
   * Output only. When the glossary creation was finished.
   * @param endTime endTime or {@code null} for none
   */
  public Glossary setEndTime(String endTime) {
    this.endTime = endTime;
    return this;
  }

  /**
   * Output only. The number of entries defined in the glossary.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getEntryCount() {
    return entryCount;
  }

  /**
   * Output only. The number of entries defined in the glossary.
   * @param entryCount entryCount or {@code null} for none
   */
  public Glossary setEntryCount(java.lang.Integer entryCount) {
    this.entryCount = entryCount;
    return this;
  }

  /**
   * Required. Provides examples to build the glossary from. Total glossary must not exceed 10M
   * Unicode codepoints.
   * @return value or {@code null} for none
   */
  public GlossaryInputConfig getInputConfig() {
    return inputConfig;
  }

  /**
   * Required. Provides examples to build the glossary from. Total glossary must not exceed 10M
   * Unicode codepoints.
   * @param inputConfig inputConfig or {@code null} for none
   */
  public Glossary setInputConfig(GlossaryInputConfig inputConfig) {
    this.inputConfig = inputConfig;
    return this;
  }

  /**
   * Used with equivalent term set glossaries.
   * @return value or {@code null} for none
   */
  public LanguageCodesSet getLanguageCodesSet() {
    return languageCodesSet;
  }

  /**
   * Used with equivalent term set glossaries.
   * @param languageCodesSet languageCodesSet or {@code null} for none
   */
  public Glossary setLanguageCodesSet(LanguageCodesSet languageCodesSet) {
    this.languageCodesSet = languageCodesSet;
    return this;
  }

  /**
   * Used with unidirectional glossaries.
   * @return value or {@code null} for none
   */
  public LanguageCodePair getLanguagePair() {
    return languagePair;
  }

  /**
   * Used with unidirectional glossaries.
   * @param languagePair languagePair or {@code null} for none
   */
  public Glossary setLanguagePair(LanguageCodePair languagePair) {
    this.languagePair = languagePair;
    return this;
  }

  /**
   * Required. The resource name of the glossary. Glossary names have the form `projects/{project-
   * number-or-id}/locations/{location-id}/glossaries/{glossary-id}`.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Required. The resource name of the glossary. Glossary names have the form `projects/{project-
   * number-or-id}/locations/{location-id}/glossaries/{glossary-id}`.
   * @param name name or {@code null} for none
   */
  public Glossary setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Output only. When CreateGlossary was called.
   * @return value or {@code null} for none
   */
  public String getSubmitTime() {
    return submitTime;
  }

  /**
   * Output only. When CreateGlossary was called.
   * @param submitTime submitTime or {@code null} for none
   */
  public Glossary setSubmitTime(String submitTime) {
    this.submitTime = submitTime;
    return this;
  }

  @Override
  public Glossary set(String fieldName, Object value) {
    return (Glossary) super.set(fieldName, value);
  }

  @Override
  public Glossary clone() {
    return (Glossary) super.clone();
  }

}
