/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.translate.v3.model;

/**
 * Represents a single entry in a glossary.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Translation API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GlossaryEntry extends com.google.api.client.json.GenericJson {

  /**
   * Describes the glossary entry.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Required. The resource name of the entry. Format:
   * "projects/locations/glossaries/glossaryEntries"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Used for an unidirectional glossary.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GlossaryTermsPair termsPair;

  /**
   * Used for an equivalent term sets glossary.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GlossaryTermsSet termsSet;

  /**
   * Describes the glossary entry.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * Describes the glossary entry.
   * @param description description or {@code null} for none
   */
  public GlossaryEntry setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Required. The resource name of the entry. Format:
   * "projects/locations/glossaries/glossaryEntries"
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Required. The resource name of the entry. Format:
   * "projects/locations/glossaries/glossaryEntries"
   * @param name name or {@code null} for none
   */
  public GlossaryEntry setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Used for an unidirectional glossary.
   * @return value or {@code null} for none
   */
  public GlossaryTermsPair getTermsPair() {
    return termsPair;
  }

  /**
   * Used for an unidirectional glossary.
   * @param termsPair termsPair or {@code null} for none
   */
  public GlossaryEntry setTermsPair(GlossaryTermsPair termsPair) {
    this.termsPair = termsPair;
    return this;
  }

  /**
   * Used for an equivalent term sets glossary.
   * @return value or {@code null} for none
   */
  public GlossaryTermsSet getTermsSet() {
    return termsSet;
  }

  /**
   * Used for an equivalent term sets glossary.
   * @param termsSet termsSet or {@code null} for none
   */
  public GlossaryEntry setTermsSet(GlossaryTermsSet termsSet) {
    this.termsSet = termsSet;
    return this;
  }

  @Override
  public GlossaryEntry set(String fieldName, Object value) {
    return (GlossaryEntry) super.set(fieldName, value);
  }

  @Override
  public GlossaryEntry clone() {
    return (GlossaryEntry) super.clone();
  }

}
