/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.translate.v3.model;

/**
 * Input configuration for glossaries.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Translation API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GlossaryInputConfig extends com.google.api.client.json.GenericJson {

  /**
   * Required. Google Cloud Storage location of glossary data. File format is determined based on
   * the filename extension. API returns [google.rpc.Code.INVALID_ARGUMENT] for unsupported URI-s
   * and file formats. Wildcards are not allowed. This must be a single file in one of the following
   * formats: For unidirectional glossaries: - TSV/CSV (`.tsv`/`.csv`): Two column file, tab- or
   * comma-separated. The first column is source text. The second column is target text. No headers
   * in this file. The first row contains data and not column names. - TMX (`.tmx`): TMX file with
   * parallel data defining source/target term pairs. For equivalent term sets glossaries: - CSV
   * (`.csv`): Multi-column CSV file defining equivalent glossary terms in multiple languages. See
   * documentation for more information -
   * [glossaries](https://cloud.google.com/translate/docs/advanced/glossary).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GcsSource gcsSource;

  /**
   * Required. Google Cloud Storage location of glossary data. File format is determined based on
   * the filename extension. API returns [google.rpc.Code.INVALID_ARGUMENT] for unsupported URI-s
   * and file formats. Wildcards are not allowed. This must be a single file in one of the following
   * formats: For unidirectional glossaries: - TSV/CSV (`.tsv`/`.csv`): Two column file, tab- or
   * comma-separated. The first column is source text. The second column is target text. No headers
   * in this file. The first row contains data and not column names. - TMX (`.tmx`): TMX file with
   * parallel data defining source/target term pairs. For equivalent term sets glossaries: - CSV
   * (`.csv`): Multi-column CSV file defining equivalent glossary terms in multiple languages. See
   * documentation for more information -
   * [glossaries](https://cloud.google.com/translate/docs/advanced/glossary).
   * @return value or {@code null} for none
   */
  public GcsSource getGcsSource() {
    return gcsSource;
  }

  /**
   * Required. Google Cloud Storage location of glossary data. File format is determined based on
   * the filename extension. API returns [google.rpc.Code.INVALID_ARGUMENT] for unsupported URI-s
   * and file formats. Wildcards are not allowed. This must be a single file in one of the following
   * formats: For unidirectional glossaries: - TSV/CSV (`.tsv`/`.csv`): Two column file, tab- or
   * comma-separated. The first column is source text. The second column is target text. No headers
   * in this file. The first row contains data and not column names. - TMX (`.tmx`): TMX file with
   * parallel data defining source/target term pairs. For equivalent term sets glossaries: - CSV
   * (`.csv`): Multi-column CSV file defining equivalent glossary terms in multiple languages. See
   * documentation for more information -
   * [glossaries](https://cloud.google.com/translate/docs/advanced/glossary).
   * @param gcsSource gcsSource or {@code null} for none
   */
  public GlossaryInputConfig setGcsSource(GcsSource gcsSource) {
    this.gcsSource = gcsSource;
    return this;
  }

  @Override
  public GlossaryInputConfig set(String fieldName, Object value) {
    return (GlossaryInputConfig) super.set(fieldName, value);
  }

  @Override
  public GlossaryInputConfig clone() {
    return (GlossaryInputConfig) super.clone();
  }

}
