/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.translate.v3.model;

/**
 * Represents a single entry for an unidirectional glossary.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Translation API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GlossaryTermsPair extends com.google.api.client.json.GenericJson {

  /**
   * The source term is the term that will get match in the text,
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GlossaryTerm sourceTerm;

  /**
   * The term that will replace the match source term.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GlossaryTerm targetTerm;

  /**
   * The source term is the term that will get match in the text,
   * @return value or {@code null} for none
   */
  public GlossaryTerm getSourceTerm() {
    return sourceTerm;
  }

  /**
   * The source term is the term that will get match in the text,
   * @param sourceTerm sourceTerm or {@code null} for none
   */
  public GlossaryTermsPair setSourceTerm(GlossaryTerm sourceTerm) {
    this.sourceTerm = sourceTerm;
    return this;
  }

  /**
   * The term that will replace the match source term.
   * @return value or {@code null} for none
   */
  public GlossaryTerm getTargetTerm() {
    return targetTerm;
  }

  /**
   * The term that will replace the match source term.
   * @param targetTerm targetTerm or {@code null} for none
   */
  public GlossaryTermsPair setTargetTerm(GlossaryTerm targetTerm) {
    this.targetTerm = targetTerm;
    return this;
  }

  @Override
  public GlossaryTermsPair set(String fieldName, Object value) {
    return (GlossaryTermsPair) super.set(fieldName, value);
  }

  @Override
  public GlossaryTermsPair clone() {
    return (GlossaryTermsPair) super.clone();
  }

}
