/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.translate.v3.model;

/**
 * Represents a single entry for an equivalent term set glossary. This is used for equivalent term
 * sets where each term can be replaced by the other terms in the set.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Translation API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GlossaryTermsSet extends com.google.api.client.json.GenericJson {

  /**
   * Each term in the set represents a term that can be replaced by the other terms.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<GlossaryTerm> terms;

  static {
    // hack to force ProGuard to consider GlossaryTerm used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(GlossaryTerm.class);
  }

  /**
   * Each term in the set represents a term that can be replaced by the other terms.
   * @return value or {@code null} for none
   */
  public java.util.List<GlossaryTerm> getTerms() {
    return terms;
  }

  /**
   * Each term in the set represents a term that can be replaced by the other terms.
   * @param terms terms or {@code null} for none
   */
  public GlossaryTermsSet setTerms(java.util.List<GlossaryTerm> terms) {
    this.terms = terms;
    return this;
  }

  @Override
  public GlossaryTermsSet set(String fieldName, Object value) {
    return (GlossaryTermsSet) super.set(fieldName, value);
  }

  @Override
  public GlossaryTermsSet clone() {
    return (GlossaryTermsSet) super.clone();
  }

}
