/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.translate.v3.model;

/**
 * Input configuration for BatchTranslateText request.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Translation API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InputConfig extends com.google.api.client.json.GenericJson {

  /**
   * Required. Google Cloud Storage location for the source input. This can be a single file (for
   * example, `gs://translation-test/input.tsv`) or a wildcard (for example, `gs://translation-
   * test`). If a file extension is `.tsv`, it can contain either one or two columns. The first
   * column (optional) is the id of the text request. If the first column is missing, we use the row
   * number (0-based) from the input file as the ID in the output file. The second column is the
   * actual text to be translated. We recommend each row be <= 10K Unicode codepoints, otherwise an
   * error might be returned. Note that the input tsv must be RFC 4180 compliant. You could use
   * https://github.com/Clever/csvlint to check potential formatting errors in your tsv file.
   * csvlint --delimiter='\t' your_input_file.tsv The other supported file extensions are `.txt` or
   * `.html`, which is treated as a single large chunk of text.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GcsSource gcsSource;

  /**
   * Optional. Can be "text/plain" or "text/html". For `.tsv`, "text/html" is used if mime_type is
   * missing. For `.html`, this field must be "text/html" or empty. For `.txt`, this field must be
   * "text/plain" or empty.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String mimeType;

  /**
   * Required. Google Cloud Storage location for the source input. This can be a single file (for
   * example, `gs://translation-test/input.tsv`) or a wildcard (for example, `gs://translation-
   * test`). If a file extension is `.tsv`, it can contain either one or two columns. The first
   * column (optional) is the id of the text request. If the first column is missing, we use the row
   * number (0-based) from the input file as the ID in the output file. The second column is the
   * actual text to be translated. We recommend each row be <= 10K Unicode codepoints, otherwise an
   * error might be returned. Note that the input tsv must be RFC 4180 compliant. You could use
   * https://github.com/Clever/csvlint to check potential formatting errors in your tsv file.
   * csvlint --delimiter='\t' your_input_file.tsv The other supported file extensions are `.txt` or
   * `.html`, which is treated as a single large chunk of text.
   * @return value or {@code null} for none
   */
  public GcsSource getGcsSource() {
    return gcsSource;
  }

  /**
   * Required. Google Cloud Storage location for the source input. This can be a single file (for
   * example, `gs://translation-test/input.tsv`) or a wildcard (for example, `gs://translation-
   * test`). If a file extension is `.tsv`, it can contain either one or two columns. The first
   * column (optional) is the id of the text request. If the first column is missing, we use the row
   * number (0-based) from the input file as the ID in the output file. The second column is the
   * actual text to be translated. We recommend each row be <= 10K Unicode codepoints, otherwise an
   * error might be returned. Note that the input tsv must be RFC 4180 compliant. You could use
   * https://github.com/Clever/csvlint to check potential formatting errors in your tsv file.
   * csvlint --delimiter='\t' your_input_file.tsv The other supported file extensions are `.txt` or
   * `.html`, which is treated as a single large chunk of text.
   * @param gcsSource gcsSource or {@code null} for none
   */
  public InputConfig setGcsSource(GcsSource gcsSource) {
    this.gcsSource = gcsSource;
    return this;
  }

  /**
   * Optional. Can be "text/plain" or "text/html". For `.tsv`, "text/html" is used if mime_type is
   * missing. For `.html`, this field must be "text/html" or empty. For `.txt`, this field must be
   * "text/plain" or empty.
   * @return value or {@code null} for none
   */
  public java.lang.String getMimeType() {
    return mimeType;
  }

  /**
   * Optional. Can be "text/plain" or "text/html". For `.tsv`, "text/html" is used if mime_type is
   * missing. For `.html`, this field must be "text/html" or empty. For `.txt`, this field must be
   * "text/plain" or empty.
   * @param mimeType mimeType or {@code null} for none
   */
  public InputConfig setMimeType(java.lang.String mimeType) {
    this.mimeType = mimeType;
    return this;
  }

  @Override
  public InputConfig set(String fieldName, Object value) {
    return (InputConfig) super.set(fieldName, value);
  }

  @Override
  public InputConfig clone() {
    return (InputConfig) super.clone();
  }

}
