/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.translate.v3.model;

/**
 * The response for listing all AdaptiveMt files under a given dataset.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Translation API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ListAdaptiveMtFilesResponse extends com.google.api.client.json.GenericJson {

  /**
   * Output only. The Adaptive MT files.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<AdaptiveMtFile> adaptiveMtFiles;

  static {
    // hack to force ProGuard to consider AdaptiveMtFile used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(AdaptiveMtFile.class);
  }

  /**
   * Optional. A token to retrieve a page of results. Pass this value in the
   * ListAdaptiveMtFilesRequest.page_token field in the subsequent call to `ListAdaptiveMtFiles`
   * method to retrieve the next page of results.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * Output only. The Adaptive MT files.
   * @return value or {@code null} for none
   */
  public java.util.List<AdaptiveMtFile> getAdaptiveMtFiles() {
    return adaptiveMtFiles;
  }

  /**
   * Output only. The Adaptive MT files.
   * @param adaptiveMtFiles adaptiveMtFiles or {@code null} for none
   */
  public ListAdaptiveMtFilesResponse setAdaptiveMtFiles(java.util.List<AdaptiveMtFile> adaptiveMtFiles) {
    this.adaptiveMtFiles = adaptiveMtFiles;
    return this;
  }

  /**
   * Optional. A token to retrieve a page of results. Pass this value in the
   * ListAdaptiveMtFilesRequest.page_token field in the subsequent call to `ListAdaptiveMtFiles`
   * method to retrieve the next page of results.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * Optional. A token to retrieve a page of results. Pass this value in the
   * ListAdaptiveMtFilesRequest.page_token field in the subsequent call to `ListAdaptiveMtFiles`
   * method to retrieve the next page of results.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public ListAdaptiveMtFilesResponse setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  @Override
  public ListAdaptiveMtFilesResponse set(String fieldName, Object value) {
    return (ListAdaptiveMtFilesResponse) super.set(fieldName, value);
  }

  @Override
  public ListAdaptiveMtFilesResponse clone() {
    return (ListAdaptiveMtFilesResponse) super.clone();
  }

}
