/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.translate.v3.model;

/**
 * Response message for ListGlossaryEntries
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Translation API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ListGlossaryEntriesResponse extends com.google.api.client.json.GenericJson {

  /**
   * Optional. The Glossary Entries
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<GlossaryEntry> glossaryEntries;

  static {
    // hack to force ProGuard to consider GlossaryEntry used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(GlossaryEntry.class);
  }

  /**
   * Optional. A token to retrieve a page of results. Pass this value in the
   * [ListGLossaryEntriesRequest.page_token] field in the subsequent calls.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * Optional. The Glossary Entries
   * @return value or {@code null} for none
   */
  public java.util.List<GlossaryEntry> getGlossaryEntries() {
    return glossaryEntries;
  }

  /**
   * Optional. The Glossary Entries
   * @param glossaryEntries glossaryEntries or {@code null} for none
   */
  public ListGlossaryEntriesResponse setGlossaryEntries(java.util.List<GlossaryEntry> glossaryEntries) {
    this.glossaryEntries = glossaryEntries;
    return this;
  }

  /**
   * Optional. A token to retrieve a page of results. Pass this value in the
   * [ListGLossaryEntriesRequest.page_token] field in the subsequent calls.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * Optional. A token to retrieve a page of results. Pass this value in the
   * [ListGLossaryEntriesRequest.page_token] field in the subsequent calls.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public ListGlossaryEntriesResponse setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  @Override
  public ListGlossaryEntriesResponse set(String fieldName, Object value) {
    return (ListGlossaryEntriesResponse) super.set(fieldName, value);
  }

  @Override
  public ListGlossaryEntriesResponse clone() {
    return (ListGlossaryEntriesResponse) super.clone();
  }

}
