/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.translate.v3.model;

/**
 * Response message for ListModels.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Translation API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ListModelsResponse extends com.google.api.client.json.GenericJson {

  /**
   * The models read.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Model> models;

  /**
   * A token to retrieve next page of results. Pass this token to the page_token field in the
   * ListModelsRequest to obtain the corresponding page.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * The models read.
   * @return value or {@code null} for none
   */
  public java.util.List<Model> getModels() {
    return models;
  }

  /**
   * The models read.
   * @param models models or {@code null} for none
   */
  public ListModelsResponse setModels(java.util.List<Model> models) {
    this.models = models;
    return this;
  }

  /**
   * A token to retrieve next page of results. Pass this token to the page_token field in the
   * ListModelsRequest to obtain the corresponding page.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * A token to retrieve next page of results. Pass this token to the page_token field in the
   * ListModelsRequest to obtain the corresponding page.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public ListModelsResponse setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  @Override
  public ListModelsResponse set(String fieldName, Object value) {
    return (ListModelsResponse) super.set(fieldName, value);
  }

  @Override
  public ListModelsResponse clone() {
    return (ListModelsResponse) super.clone();
  }

}
