/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.translate.v3.model;

/**
 * A single romanization response.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Translation API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Romanization extends com.google.api.client.json.GenericJson {

  /**
   * The ISO-639 language code of source text in the initial request, detected automatically, if no
   * source language was passed within the initial request. If the source language was passed, auto-
   * detection of the language does not occur and this field is empty.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String detectedLanguageCode;

  /**
   * Romanized text. If an error occurs during romanization, this field might be excluded from the
   * response.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String romanizedText;

  /**
   * The ISO-639 language code of source text in the initial request, detected automatically, if no
   * source language was passed within the initial request. If the source language was passed, auto-
   * detection of the language does not occur and this field is empty.
   * @return value or {@code null} for none
   */
  public java.lang.String getDetectedLanguageCode() {
    return detectedLanguageCode;
  }

  /**
   * The ISO-639 language code of source text in the initial request, detected automatically, if no
   * source language was passed within the initial request. If the source language was passed, auto-
   * detection of the language does not occur and this field is empty.
   * @param detectedLanguageCode detectedLanguageCode or {@code null} for none
   */
  public Romanization setDetectedLanguageCode(java.lang.String detectedLanguageCode) {
    this.detectedLanguageCode = detectedLanguageCode;
    return this;
  }

  /**
   * Romanized text. If an error occurs during romanization, this field might be excluded from the
   * response.
   * @return value or {@code null} for none
   */
  public java.lang.String getRomanizedText() {
    return romanizedText;
  }

  /**
   * Romanized text. If an error occurs during romanization, this field might be excluded from the
   * response.
   * @param romanizedText romanizedText or {@code null} for none
   */
  public Romanization setRomanizedText(java.lang.String romanizedText) {
    this.romanizedText = romanizedText;
    return this;
  }

  @Override
  public Romanization set(String fieldName, Object value) {
    return (Romanization) super.set(fieldName, value);
  }

  @Override
  public Romanization clone() {
    return (Romanization) super.clone();
  }

}
