/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.translate.v3.model;

/**
 * A single supported language response corresponds to information related to one supported
 * language.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Translation API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SupportedLanguage extends com.google.api.client.json.GenericJson {

  /**
   * Human-readable name of the language localized in the display language specified in the request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String displayName;

  /**
   * Supported language code, generally consisting of its ISO 639-1 identifier, for example, 'en',
   * 'ja'. In certain cases, ISO-639 codes including language and region identifiers are returned
   * (for example, 'zh-TW' and 'zh-CN').
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String languageCode;

  /**
   * Can be used as a source language.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean supportSource;

  /**
   * Can be used as a target language.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean supportTarget;

  /**
   * Human-readable name of the language localized in the display language specified in the request.
   * @return value or {@code null} for none
   */
  public java.lang.String getDisplayName() {
    return displayName;
  }

  /**
   * Human-readable name of the language localized in the display language specified in the request.
   * @param displayName displayName or {@code null} for none
   */
  public SupportedLanguage setDisplayName(java.lang.String displayName) {
    this.displayName = displayName;
    return this;
  }

  /**
   * Supported language code, generally consisting of its ISO 639-1 identifier, for example, 'en',
   * 'ja'. In certain cases, ISO-639 codes including language and region identifiers are returned
   * (for example, 'zh-TW' and 'zh-CN').
   * @return value or {@code null} for none
   */
  public java.lang.String getLanguageCode() {
    return languageCode;
  }

  /**
   * Supported language code, generally consisting of its ISO 639-1 identifier, for example, 'en',
   * 'ja'. In certain cases, ISO-639 codes including language and region identifiers are returned
   * (for example, 'zh-TW' and 'zh-CN').
   * @param languageCode languageCode or {@code null} for none
   */
  public SupportedLanguage setLanguageCode(java.lang.String languageCode) {
    this.languageCode = languageCode;
    return this;
  }

  /**
   * Can be used as a source language.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getSupportSource() {
    return supportSource;
  }

  /**
   * Can be used as a source language.
   * @param supportSource supportSource or {@code null} for none
   */
  public SupportedLanguage setSupportSource(java.lang.Boolean supportSource) {
    this.supportSource = supportSource;
    return this;
  }

  /**
   * Can be used as a target language.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getSupportTarget() {
    return supportTarget;
  }

  /**
   * Can be used as a target language.
   * @param supportTarget supportTarget or {@code null} for none
   */
  public SupportedLanguage setSupportTarget(java.lang.Boolean supportTarget) {
    this.supportTarget = supportTarget;
    return this;
  }

  @Override
  public SupportedLanguage set(String fieldName, Object value) {
    return (SupportedLanguage) super.set(fieldName, value);
  }

  @Override
  public SupportedLanguage clone() {
    return (SupportedLanguage) super.clone();
  }

}
