/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.translate.v3.model;

/**
 * The response message for discovering supported languages.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Translation API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SupportedLanguages extends com.google.api.client.json.GenericJson {

  /**
   * A list of supported language responses. This list contains an entry for each language the
   * Translation API supports.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<SupportedLanguage> languages;

  static {
    // hack to force ProGuard to consider SupportedLanguage used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(SupportedLanguage.class);
  }

  /**
   * A list of supported language responses. This list contains an entry for each language the
   * Translation API supports.
   * @return value or {@code null} for none
   */
  public java.util.List<SupportedLanguage> getLanguages() {
    return languages;
  }

  /**
   * A list of supported language responses. This list contains an entry for each language the
   * Translation API supports.
   * @param languages languages or {@code null} for none
   */
  public SupportedLanguages setLanguages(java.util.List<SupportedLanguage> languages) {
    this.languages = languages;
    return this;
  }

  @Override
  public SupportedLanguages set(String fieldName, Object value) {
    return (SupportedLanguages) super.set(fieldName, value);
  }

  @Override
  public SupportedLanguages clone() {
    return (SupportedLanguages) super.clone();
  }

}
