/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.translate.v3.model;

/**
 * A document translation request.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Translation API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TranslateDocumentRequest extends com.google.api.client.json.GenericJson {

  /**
   * Optional. This flag is to support user customized attribution. If not provided, the default is
   * `Machine Translated by Google`. Customized attribution should follow rules in
   * https://cloud.google.com/translate/attribution#attribution_and_logos
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String customizedAttribution;

  /**
   * Required. Input configurations.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DocumentInputConfig documentInputConfig;

  /**
   * Optional. Output configurations. Defines if the output file should be stored within Cloud
   * Storage as well as the desired output format. If not provided the translated file will only be
   * returned through a byte-stream and its output mime type will be the same as the input file's
   * mime type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DocumentOutputConfig documentOutputConfig;

  /**
   * Optional. If true, enable auto rotation correction in DVS.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean enableRotationCorrection;

  /**
   * Optional. If true, use the text removal server to remove the shadow text on background image
   * for native pdf translation. Shadow removal feature can only be enabled when
   * is_translate_native_pdf_only: false && pdf_native_only: false
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean enableShadowRemovalNativePdf;

  /**
   * Optional. Glossary to be applied. The glossary must be within the same region (have the same
   * location-id) as the model, otherwise an INVALID_ARGUMENT (400) error is returned.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TranslateTextGlossaryConfig glossaryConfig;

  /**
   * Optional. is_translate_native_pdf_only field for external customers. If true, the page limit of
   * online native pdf translation is 300 and only native pdf pages will be translated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean isTranslateNativePdfOnly;

  /**
   * Optional. The labels with user-defined metadata for the request. Label keys and values can be
   * no longer than 63 characters (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed. Label values are
   * optional. Label keys must start with a letter. See
   * https://cloud.google.com/translate/docs/advanced/labels for more information.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> labels;

  /**
   * Optional. The `model` type requested for this translation. The format depends on model type: -
   * AutoML Translation models: `projects/{project-number-or-id}/locations/{location-id}/models
   * /{model-id}` - General (built-in) models: `projects/{project-number-or-id}/locations/{location-
   * id}/models/general/nmt`, If not provided, the default Google model (NMT) will be used for
   * translation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String model;

  /**
   * Optional. The ISO-639 language code of the input document if known, for example, "en-US" or
   * "sr-Latn". Supported language codes are listed in Language Support. If the source language
   * isn't specified, the API attempts to identify the source language automatically and returns the
   * source language within the response. Source language must be specified if the request contains
   * a glossary or a custom model.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sourceLanguageCode;

  /**
   * Required. The ISO-639 language code to use for translation of the input document, set to one of
   * the language codes listed in Language Support.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String targetLanguageCode;

  /**
   * Optional. This flag is to support user customized attribution. If not provided, the default is
   * `Machine Translated by Google`. Customized attribution should follow rules in
   * https://cloud.google.com/translate/attribution#attribution_and_logos
   * @return value or {@code null} for none
   */
  public java.lang.String getCustomizedAttribution() {
    return customizedAttribution;
  }

  /**
   * Optional. This flag is to support user customized attribution. If not provided, the default is
   * `Machine Translated by Google`. Customized attribution should follow rules in
   * https://cloud.google.com/translate/attribution#attribution_and_logos
   * @param customizedAttribution customizedAttribution or {@code null} for none
   */
  public TranslateDocumentRequest setCustomizedAttribution(java.lang.String customizedAttribution) {
    this.customizedAttribution = customizedAttribution;
    return this;
  }

  /**
   * Required. Input configurations.
   * @return value or {@code null} for none
   */
  public DocumentInputConfig getDocumentInputConfig() {
    return documentInputConfig;
  }

  /**
   * Required. Input configurations.
   * @param documentInputConfig documentInputConfig or {@code null} for none
   */
  public TranslateDocumentRequest setDocumentInputConfig(DocumentInputConfig documentInputConfig) {
    this.documentInputConfig = documentInputConfig;
    return this;
  }

  /**
   * Optional. Output configurations. Defines if the output file should be stored within Cloud
   * Storage as well as the desired output format. If not provided the translated file will only be
   * returned through a byte-stream and its output mime type will be the same as the input file's
   * mime type.
   * @return value or {@code null} for none
   */
  public DocumentOutputConfig getDocumentOutputConfig() {
    return documentOutputConfig;
  }

  /**
   * Optional. Output configurations. Defines if the output file should be stored within Cloud
   * Storage as well as the desired output format. If not provided the translated file will only be
   * returned through a byte-stream and its output mime type will be the same as the input file's
   * mime type.
   * @param documentOutputConfig documentOutputConfig or {@code null} for none
   */
  public TranslateDocumentRequest setDocumentOutputConfig(DocumentOutputConfig documentOutputConfig) {
    this.documentOutputConfig = documentOutputConfig;
    return this;
  }

  /**
   * Optional. If true, enable auto rotation correction in DVS.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getEnableRotationCorrection() {
    return enableRotationCorrection;
  }

  /**
   * Optional. If true, enable auto rotation correction in DVS.
   * @param enableRotationCorrection enableRotationCorrection or {@code null} for none
   */
  public TranslateDocumentRequest setEnableRotationCorrection(java.lang.Boolean enableRotationCorrection) {
    this.enableRotationCorrection = enableRotationCorrection;
    return this;
  }

  /**
   * Optional. If true, use the text removal server to remove the shadow text on background image
   * for native pdf translation. Shadow removal feature can only be enabled when
   * is_translate_native_pdf_only: false && pdf_native_only: false
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getEnableShadowRemovalNativePdf() {
    return enableShadowRemovalNativePdf;
  }

  /**
   * Optional. If true, use the text removal server to remove the shadow text on background image
   * for native pdf translation. Shadow removal feature can only be enabled when
   * is_translate_native_pdf_only: false && pdf_native_only: false
   * @param enableShadowRemovalNativePdf enableShadowRemovalNativePdf or {@code null} for none
   */
  public TranslateDocumentRequest setEnableShadowRemovalNativePdf(java.lang.Boolean enableShadowRemovalNativePdf) {
    this.enableShadowRemovalNativePdf = enableShadowRemovalNativePdf;
    return this;
  }

  /**
   * Optional. Glossary to be applied. The glossary must be within the same region (have the same
   * location-id) as the model, otherwise an INVALID_ARGUMENT (400) error is returned.
   * @return value or {@code null} for none
   */
  public TranslateTextGlossaryConfig getGlossaryConfig() {
    return glossaryConfig;
  }

  /**
   * Optional. Glossary to be applied. The glossary must be within the same region (have the same
   * location-id) as the model, otherwise an INVALID_ARGUMENT (400) error is returned.
   * @param glossaryConfig glossaryConfig or {@code null} for none
   */
  public TranslateDocumentRequest setGlossaryConfig(TranslateTextGlossaryConfig glossaryConfig) {
    this.glossaryConfig = glossaryConfig;
    return this;
  }

  /**
   * Optional. is_translate_native_pdf_only field for external customers. If true, the page limit of
   * online native pdf translation is 300 and only native pdf pages will be translated.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIsTranslateNativePdfOnly() {
    return isTranslateNativePdfOnly;
  }

  /**
   * Optional. is_translate_native_pdf_only field for external customers. If true, the page limit of
   * online native pdf translation is 300 and only native pdf pages will be translated.
   * @param isTranslateNativePdfOnly isTranslateNativePdfOnly or {@code null} for none
   */
  public TranslateDocumentRequest setIsTranslateNativePdfOnly(java.lang.Boolean isTranslateNativePdfOnly) {
    this.isTranslateNativePdfOnly = isTranslateNativePdfOnly;
    return this;
  }

  /**
   * Optional. The labels with user-defined metadata for the request. Label keys and values can be
   * no longer than 63 characters (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed. Label values are
   * optional. Label keys must start with a letter. See
   * https://cloud.google.com/translate/docs/advanced/labels for more information.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getLabels() {
    return labels;
  }

  /**
   * Optional. The labels with user-defined metadata for the request. Label keys and values can be
   * no longer than 63 characters (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed. Label values are
   * optional. Label keys must start with a letter. See
   * https://cloud.google.com/translate/docs/advanced/labels for more information.
   * @param labels labels or {@code null} for none
   */
  public TranslateDocumentRequest setLabels(java.util.Map<String, java.lang.String> labels) {
    this.labels = labels;
    return this;
  }

  /**
   * Optional. The `model` type requested for this translation. The format depends on model type: -
   * AutoML Translation models: `projects/{project-number-or-id}/locations/{location-id}/models
   * /{model-id}` - General (built-in) models: `projects/{project-number-or-id}/locations/{location-
   * id}/models/general/nmt`, If not provided, the default Google model (NMT) will be used for
   * translation.
   * @return value or {@code null} for none
   */
  public java.lang.String getModel() {
    return model;
  }

  /**
   * Optional. The `model` type requested for this translation. The format depends on model type: -
   * AutoML Translation models: `projects/{project-number-or-id}/locations/{location-id}/models
   * /{model-id}` - General (built-in) models: `projects/{project-number-or-id}/locations/{location-
   * id}/models/general/nmt`, If not provided, the default Google model (NMT) will be used for
   * translation.
   * @param model model or {@code null} for none
   */
  public TranslateDocumentRequest setModel(java.lang.String model) {
    this.model = model;
    return this;
  }

  /**
   * Optional. The ISO-639 language code of the input document if known, for example, "en-US" or
   * "sr-Latn". Supported language codes are listed in Language Support. If the source language
   * isn't specified, the API attempts to identify the source language automatically and returns the
   * source language within the response. Source language must be specified if the request contains
   * a glossary or a custom model.
   * @return value or {@code null} for none
   */
  public java.lang.String getSourceLanguageCode() {
    return sourceLanguageCode;
  }

  /**
   * Optional. The ISO-639 language code of the input document if known, for example, "en-US" or
   * "sr-Latn". Supported language codes are listed in Language Support. If the source language
   * isn't specified, the API attempts to identify the source language automatically and returns the
   * source language within the response. Source language must be specified if the request contains
   * a glossary or a custom model.
   * @param sourceLanguageCode sourceLanguageCode or {@code null} for none
   */
  public TranslateDocumentRequest setSourceLanguageCode(java.lang.String sourceLanguageCode) {
    this.sourceLanguageCode = sourceLanguageCode;
    return this;
  }

  /**
   * Required. The ISO-639 language code to use for translation of the input document, set to one of
   * the language codes listed in Language Support.
   * @return value or {@code null} for none
   */
  public java.lang.String getTargetLanguageCode() {
    return targetLanguageCode;
  }

  /**
   * Required. The ISO-639 language code to use for translation of the input document, set to one of
   * the language codes listed in Language Support.
   * @param targetLanguageCode targetLanguageCode or {@code null} for none
   */
  public TranslateDocumentRequest setTargetLanguageCode(java.lang.String targetLanguageCode) {
    this.targetLanguageCode = targetLanguageCode;
    return this;
  }

  @Override
  public TranslateDocumentRequest set(String fieldName, Object value) {
    return (TranslateDocumentRequest) super.set(fieldName, value);
  }

  @Override
  public TranslateDocumentRequest clone() {
    return (TranslateDocumentRequest) super.clone();
  }

}
