/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.translate.v3.model;

/**
 * A translated document response message.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Translation API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TranslateDocumentResponse extends com.google.api.client.json.GenericJson {

  /**
   * Translated document.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DocumentTranslation documentTranslation;

  /**
   * The `glossary_config` used for this translation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TranslateTextGlossaryConfig glossaryConfig;

  /**
   * The document's translation output if a glossary is provided in the request. This can be the
   * same as [TranslateDocumentResponse.document_translation] if no glossary terms apply.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DocumentTranslation glossaryDocumentTranslation;

  /**
   * Only present when 'model' is present in the request. 'model' is normalized to have a project
   * number. For example: If the 'model' field in TranslateDocumentRequest is: `projects/{project-
   * id}/locations/{location-id}/models/general/nmt` then `model` here would be normalized to
   * `projects/{project-number}/locations/{location-id}/models/general/nmt`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String model;

  /**
   * Translated document.
   * @return value or {@code null} for none
   */
  public DocumentTranslation getDocumentTranslation() {
    return documentTranslation;
  }

  /**
   * Translated document.
   * @param documentTranslation documentTranslation or {@code null} for none
   */
  public TranslateDocumentResponse setDocumentTranslation(DocumentTranslation documentTranslation) {
    this.documentTranslation = documentTranslation;
    return this;
  }

  /**
   * The `glossary_config` used for this translation.
   * @return value or {@code null} for none
   */
  public TranslateTextGlossaryConfig getGlossaryConfig() {
    return glossaryConfig;
  }

  /**
   * The `glossary_config` used for this translation.
   * @param glossaryConfig glossaryConfig or {@code null} for none
   */
  public TranslateDocumentResponse setGlossaryConfig(TranslateTextGlossaryConfig glossaryConfig) {
    this.glossaryConfig = glossaryConfig;
    return this;
  }

  /**
   * The document's translation output if a glossary is provided in the request. This can be the
   * same as [TranslateDocumentResponse.document_translation] if no glossary terms apply.
   * @return value or {@code null} for none
   */
  public DocumentTranslation getGlossaryDocumentTranslation() {
    return glossaryDocumentTranslation;
  }

  /**
   * The document's translation output if a glossary is provided in the request. This can be the
   * same as [TranslateDocumentResponse.document_translation] if no glossary terms apply.
   * @param glossaryDocumentTranslation glossaryDocumentTranslation or {@code null} for none
   */
  public TranslateDocumentResponse setGlossaryDocumentTranslation(DocumentTranslation glossaryDocumentTranslation) {
    this.glossaryDocumentTranslation = glossaryDocumentTranslation;
    return this;
  }

  /**
   * Only present when 'model' is present in the request. 'model' is normalized to have a project
   * number. For example: If the 'model' field in TranslateDocumentRequest is: `projects/{project-
   * id}/locations/{location-id}/models/general/nmt` then `model` here would be normalized to
   * `projects/{project-number}/locations/{location-id}/models/general/nmt`.
   * @return value or {@code null} for none
   */
  public java.lang.String getModel() {
    return model;
  }

  /**
   * Only present when 'model' is present in the request. 'model' is normalized to have a project
   * number. For example: If the 'model' field in TranslateDocumentRequest is: `projects/{project-
   * id}/locations/{location-id}/models/general/nmt` then `model` here would be normalized to
   * `projects/{project-number}/locations/{location-id}/models/general/nmt`.
   * @param model model or {@code null} for none
   */
  public TranslateDocumentResponse setModel(java.lang.String model) {
    this.model = model;
    return this;
  }

  @Override
  public TranslateDocumentResponse set(String fieldName, Object value) {
    return (TranslateDocumentResponse) super.set(fieldName, value);
  }

  @Override
  public TranslateDocumentResponse clone() {
    return (TranslateDocumentResponse) super.clone();
  }

}
