/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.translate.v3.model;

/**
 * The request message for synchronous translation.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Translation API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TranslateTextRequest extends com.google.api.client.json.GenericJson {

  /**
   * Required. The content of the input in string format. We recommend the total content be less
   * than 30,000 codepoints. The max length of this field is 1024. Use BatchTranslateText for larger
   * text.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> contents;

  /**
   * Optional. Glossary to be applied. The glossary must be within the same region (have the same
   * location-id) as the model, otherwise an INVALID_ARGUMENT (400) error is returned.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TranslateTextGlossaryConfig glossaryConfig;

  /**
   * Optional. The labels with user-defined metadata for the request. Label keys and values can be
   * no longer than 63 characters (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed. Label values are
   * optional. Label keys must start with a letter. See
   * https://cloud.google.com/translate/docs/advanced/labels for more information.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> labels;

  /**
   * Optional. The format of the source text, for example, "text/html", "text/plain". If left blank,
   * the MIME type defaults to "text/html".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String mimeType;

  /**
   * Optional. The `model` type requested for this translation. The format depends on model type: -
   * AutoML Translation models: `projects/{project-number-or-id}/locations/{location-id}/models
   * /{model-id}` - General (built-in) models: `projects/{project-number-or-id}/locations/{location-
   * id}/models/general/nmt`, For global (non-regionalized) requests, use `location-id` `global`.
   * For example, `projects/{project-number-or-id}/locations/global/models/general/nmt`. If not
   * provided, the default Google model (NMT) will be used
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String model;

  /**
   * Optional. The ISO-639 language code of the input text if known, for example, "en-US" or "sr-
   * Latn". Supported language codes are listed in Language Support. If the source language isn't
   * specified, the API attempts to identify the source language automatically and returns the
   * source language within the response.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sourceLanguageCode;

  /**
   * Required. The ISO-639 language code to use for translation of the input text, set to one of the
   * language codes listed in Language Support.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String targetLanguageCode;

  /**
   * Optional. Transliteration to be applied.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TransliterationConfig transliterationConfig;

  /**
   * Required. The content of the input in string format. We recommend the total content be less
   * than 30,000 codepoints. The max length of this field is 1024. Use BatchTranslateText for larger
   * text.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getContents() {
    return contents;
  }

  /**
   * Required. The content of the input in string format. We recommend the total content be less
   * than 30,000 codepoints. The max length of this field is 1024. Use BatchTranslateText for larger
   * text.
   * @param contents contents or {@code null} for none
   */
  public TranslateTextRequest setContents(java.util.List<java.lang.String> contents) {
    this.contents = contents;
    return this;
  }

  /**
   * Optional. Glossary to be applied. The glossary must be within the same region (have the same
   * location-id) as the model, otherwise an INVALID_ARGUMENT (400) error is returned.
   * @return value or {@code null} for none
   */
  public TranslateTextGlossaryConfig getGlossaryConfig() {
    return glossaryConfig;
  }

  /**
   * Optional. Glossary to be applied. The glossary must be within the same region (have the same
   * location-id) as the model, otherwise an INVALID_ARGUMENT (400) error is returned.
   * @param glossaryConfig glossaryConfig or {@code null} for none
   */
  public TranslateTextRequest setGlossaryConfig(TranslateTextGlossaryConfig glossaryConfig) {
    this.glossaryConfig = glossaryConfig;
    return this;
  }

  /**
   * Optional. The labels with user-defined metadata for the request. Label keys and values can be
   * no longer than 63 characters (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed. Label values are
   * optional. Label keys must start with a letter. See
   * https://cloud.google.com/translate/docs/advanced/labels for more information.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getLabels() {
    return labels;
  }

  /**
   * Optional. The labels with user-defined metadata for the request. Label keys and values can be
   * no longer than 63 characters (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed. Label values are
   * optional. Label keys must start with a letter. See
   * https://cloud.google.com/translate/docs/advanced/labels for more information.
   * @param labels labels or {@code null} for none
   */
  public TranslateTextRequest setLabels(java.util.Map<String, java.lang.String> labels) {
    this.labels = labels;
    return this;
  }

  /**
   * Optional. The format of the source text, for example, "text/html", "text/plain". If left blank,
   * the MIME type defaults to "text/html".
   * @return value or {@code null} for none
   */
  public java.lang.String getMimeType() {
    return mimeType;
  }

  /**
   * Optional. The format of the source text, for example, "text/html", "text/plain". If left blank,
   * the MIME type defaults to "text/html".
   * @param mimeType mimeType or {@code null} for none
   */
  public TranslateTextRequest setMimeType(java.lang.String mimeType) {
    this.mimeType = mimeType;
    return this;
  }

  /**
   * Optional. The `model` type requested for this translation. The format depends on model type: -
   * AutoML Translation models: `projects/{project-number-or-id}/locations/{location-id}/models
   * /{model-id}` - General (built-in) models: `projects/{project-number-or-id}/locations/{location-
   * id}/models/general/nmt`, For global (non-regionalized) requests, use `location-id` `global`.
   * For example, `projects/{project-number-or-id}/locations/global/models/general/nmt`. If not
   * provided, the default Google model (NMT) will be used
   * @return value or {@code null} for none
   */
  public java.lang.String getModel() {
    return model;
  }

  /**
   * Optional. The `model` type requested for this translation. The format depends on model type: -
   * AutoML Translation models: `projects/{project-number-or-id}/locations/{location-id}/models
   * /{model-id}` - General (built-in) models: `projects/{project-number-or-id}/locations/{location-
   * id}/models/general/nmt`, For global (non-regionalized) requests, use `location-id` `global`.
   * For example, `projects/{project-number-or-id}/locations/global/models/general/nmt`. If not
   * provided, the default Google model (NMT) will be used
   * @param model model or {@code null} for none
   */
  public TranslateTextRequest setModel(java.lang.String model) {
    this.model = model;
    return this;
  }

  /**
   * Optional. The ISO-639 language code of the input text if known, for example, "en-US" or "sr-
   * Latn". Supported language codes are listed in Language Support. If the source language isn't
   * specified, the API attempts to identify the source language automatically and returns the
   * source language within the response.
   * @return value or {@code null} for none
   */
  public java.lang.String getSourceLanguageCode() {
    return sourceLanguageCode;
  }

  /**
   * Optional. The ISO-639 language code of the input text if known, for example, "en-US" or "sr-
   * Latn". Supported language codes are listed in Language Support. If the source language isn't
   * specified, the API attempts to identify the source language automatically and returns the
   * source language within the response.
   * @param sourceLanguageCode sourceLanguageCode or {@code null} for none
   */
  public TranslateTextRequest setSourceLanguageCode(java.lang.String sourceLanguageCode) {
    this.sourceLanguageCode = sourceLanguageCode;
    return this;
  }

  /**
   * Required. The ISO-639 language code to use for translation of the input text, set to one of the
   * language codes listed in Language Support.
   * @return value or {@code null} for none
   */
  public java.lang.String getTargetLanguageCode() {
    return targetLanguageCode;
  }

  /**
   * Required. The ISO-639 language code to use for translation of the input text, set to one of the
   * language codes listed in Language Support.
   * @param targetLanguageCode targetLanguageCode or {@code null} for none
   */
  public TranslateTextRequest setTargetLanguageCode(java.lang.String targetLanguageCode) {
    this.targetLanguageCode = targetLanguageCode;
    return this;
  }

  /**
   * Optional. Transliteration to be applied.
   * @return value or {@code null} for none
   */
  public TransliterationConfig getTransliterationConfig() {
    return transliterationConfig;
  }

  /**
   * Optional. Transliteration to be applied.
   * @param transliterationConfig transliterationConfig or {@code null} for none
   */
  public TranslateTextRequest setTransliterationConfig(TransliterationConfig transliterationConfig) {
    this.transliterationConfig = transliterationConfig;
    return this;
  }

  @Override
  public TranslateTextRequest set(String fieldName, Object value) {
    return (TranslateTextRequest) super.set(fieldName, value);
  }

  @Override
  public TranslateTextRequest clone() {
    return (TranslateTextRequest) super.clone();
  }

}
