/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.translate.v3.model;

/**
 * Model definition for TranslateTextResponse.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Translation API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TranslateTextResponse extends com.google.api.client.json.GenericJson {

  /**
   * Text translation responses if a glossary is provided in the request. This can be the same as
   * `translations` if no terms apply. This field has the same length as `contents`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Translation> glossaryTranslations;

  /**
   * Text translation responses with no glossary applied. This field has the same length as
   * `contents`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Translation> translations;

  /**
   * Text translation responses if a glossary is provided in the request. This can be the same as
   * `translations` if no terms apply. This field has the same length as `contents`.
   * @return value or {@code null} for none
   */
  public java.util.List<Translation> getGlossaryTranslations() {
    return glossaryTranslations;
  }

  /**
   * Text translation responses if a glossary is provided in the request. This can be the same as
   * `translations` if no terms apply. This field has the same length as `contents`.
   * @param glossaryTranslations glossaryTranslations or {@code null} for none
   */
  public TranslateTextResponse setGlossaryTranslations(java.util.List<Translation> glossaryTranslations) {
    this.glossaryTranslations = glossaryTranslations;
    return this;
  }

  /**
   * Text translation responses with no glossary applied. This field has the same length as
   * `contents`.
   * @return value or {@code null} for none
   */
  public java.util.List<Translation> getTranslations() {
    return translations;
  }

  /**
   * Text translation responses with no glossary applied. This field has the same length as
   * `contents`.
   * @param translations translations or {@code null} for none
   */
  public TranslateTextResponse setTranslations(java.util.List<Translation> translations) {
    this.translations = translations;
    return this;
  }

  @Override
  public TranslateTextResponse set(String fieldName, Object value) {
    return (TranslateTextResponse) super.set(fieldName, value);
  }

  @Override
  public TranslateTextResponse clone() {
    return (TranslateTextResponse) super.clone();
  }

}
