/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.translate.v3;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.translate.v3.TranslateRequest;
import com.google.api.services.translate.v3.TranslateRequestInitializer;
import com.google.api.services.translate.v3.model.AdaptiveMtDataset;
import com.google.api.services.translate.v3.model.AdaptiveMtFile;
import com.google.api.services.translate.v3.model.AdaptiveMtTranslateRequest;
import com.google.api.services.translate.v3.model.AdaptiveMtTranslateResponse;
import com.google.api.services.translate.v3.model.BatchTranslateDocumentRequest;
import com.google.api.services.translate.v3.model.BatchTranslateTextRequest;
import com.google.api.services.translate.v3.model.CancelOperationRequest;
import com.google.api.services.translate.v3.model.Dataset;
import com.google.api.services.translate.v3.model.DetectLanguageRequest;
import com.google.api.services.translate.v3.model.DetectLanguageResponse;
import com.google.api.services.translate.v3.model.Empty;
import com.google.api.services.translate.v3.model.ExportDataRequest;
import com.google.api.services.translate.v3.model.Glossary;
import com.google.api.services.translate.v3.model.GlossaryEntry;
import com.google.api.services.translate.v3.model.ImportAdaptiveMtFileRequest;
import com.google.api.services.translate.v3.model.ImportAdaptiveMtFileResponse;
import com.google.api.services.translate.v3.model.ImportDataRequest;
import com.google.api.services.translate.v3.model.ListAdaptiveMtDatasetsResponse;
import com.google.api.services.translate.v3.model.ListAdaptiveMtFilesResponse;
import com.google.api.services.translate.v3.model.ListAdaptiveMtSentencesResponse;
import com.google.api.services.translate.v3.model.ListDatasetsResponse;
import com.google.api.services.translate.v3.model.ListExamplesResponse;
import com.google.api.services.translate.v3.model.ListGlossariesResponse;
import com.google.api.services.translate.v3.model.ListGlossaryEntriesResponse;
import com.google.api.services.translate.v3.model.ListLocationsResponse;
import com.google.api.services.translate.v3.model.ListModelsResponse;
import com.google.api.services.translate.v3.model.ListOperationsResponse;
import com.google.api.services.translate.v3.model.Location;
import com.google.api.services.translate.v3.model.Model;
import com.google.api.services.translate.v3.model.Operation;
import com.google.api.services.translate.v3.model.RomanizeTextRequest;
import com.google.api.services.translate.v3.model.RomanizeTextResponse;
import com.google.api.services.translate.v3.model.SupportedLanguages;
import com.google.api.services.translate.v3.model.TranslateDocumentRequest;
import com.google.api.services.translate.v3.model.TranslateDocumentResponse;
import com.google.api.services.translate.v3.model.TranslateTextRequest;
import com.google.api.services.translate.v3.model.TranslateTextResponse;
import com.google.api.services.translate.v3.model.WaitOperationRequest;
import java.io.IOException;
import java.util.regex.Pattern;

public class Translate
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://translation.googleapis.com/";
    public static final String DEFAULT_MTLS_ROOT_URL = "https://translation.mtls.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://translation.googleapis.com/";

    public Translate(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    Translate(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Projects projects() {
        return new Projects();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && (GoogleUtils.MINOR_VERSION >= 32 || GoogleUtils.MINOR_VERSION == 31 && GoogleUtils.BUGFIX_VERSION >= 1) || GoogleUtils.MAJOR_VERSION >= 2 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.31.1 of google-api-client to run version 2.0.0 of the Cloud Translation API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        private static String chooseEndpoint(HttpTransport transport) {
            String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
            String string = useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
            if ("always".equals(useMtlsEndpoint) || "auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls()) {
                return Translate.DEFAULT_MTLS_ROOT_URL;
            }
            return "https://translation.googleapis.com/";
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Builder.chooseEndpoint(transport), Translate.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Translate.DEFAULT_BATCH_PATH);
        }

        public Translate build() {
            return new Translate(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setTranslateRequestInitializer(TranslateRequestInitializer translateRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)translateRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Projects {
        public DetectLanguage detectLanguage(String parent, DetectLanguageRequest content) throws IOException {
            DetectLanguage result = new DetectLanguage(parent, content);
            Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public GetSupportedLanguages getSupportedLanguages(String parent) throws IOException {
            GetSupportedLanguages result = new GetSupportedLanguages(parent);
            Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public RomanizeText romanizeText(String parent, RomanizeTextRequest content) throws IOException {
            RomanizeText result = new RomanizeText(parent, content);
            Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public TranslateText translateText(String parent, TranslateTextRequest content) throws IOException {
            TranslateText result = new TranslateText(parent, content);
            Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Locations locations() {
            return new Locations();
        }

        public class Locations {
            public AdaptiveMtTranslate adaptiveMtTranslate(String parent, AdaptiveMtTranslateRequest content) throws IOException {
                AdaptiveMtTranslate result = new AdaptiveMtTranslate(parent, content);
                Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public BatchTranslateDocument batchTranslateDocument(String parent, BatchTranslateDocumentRequest content) throws IOException {
                BatchTranslateDocument result = new BatchTranslateDocument(parent, content);
                Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public BatchTranslateText batchTranslateText(String parent, BatchTranslateTextRequest content) throws IOException {
                BatchTranslateText result = new BatchTranslateText(parent, content);
                Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public DetectLanguage detectLanguage(String parent, DetectLanguageRequest content) throws IOException {
                DetectLanguage result = new DetectLanguage(parent, content);
                Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String name) throws IOException {
                Get result = new Get(name);
                Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public GetSupportedLanguages getSupportedLanguages(String parent) throws IOException {
                GetSupportedLanguages result = new GetSupportedLanguages(parent);
                Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String name) throws IOException {
                List result = new List(name);
                Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public RomanizeText romanizeText(String parent, RomanizeTextRequest content) throws IOException {
                RomanizeText result = new RomanizeText(parent, content);
                Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public TranslateDocument translateDocument(String parent, TranslateDocumentRequest content) throws IOException {
                TranslateDocument result = new TranslateDocument(parent, content);
                Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public TranslateText translateText(String parent, TranslateTextRequest content) throws IOException {
                TranslateText result = new TranslateText(parent, content);
                Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public AdaptiveMtDatasets adaptiveMtDatasets() {
                return new AdaptiveMtDatasets();
            }

            public Datasets datasets() {
                return new Datasets();
            }

            public Glossaries glossaries() {
                return new Glossaries();
            }

            public Models models() {
                return new Models();
            }

            public Operations operations() {
                return new Operations();
            }

            public class Operations {
                public Cancel cancel(String name, CancelOperationRequest content) throws IOException {
                    Cancel result = new Cancel(name, content);
                    Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Delete delete(String name) throws IOException {
                    Delete result = new Delete(name);
                    Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(String name) throws IOException {
                    Get result = new Get(name);
                    Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String name) throws IOException {
                    List result = new List(name);
                    Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Wait wait(String name, WaitOperationRequest content) throws IOException {
                    Wait result = new Wait(name, content);
                    Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class Wait
                extends TranslateRequest<Operation> {
                    private static final String REST_PATH = "v3/{+name}:wait";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Wait(String name, WaitOperationRequest content) {
                        super(Translate.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                    }

                    public Wait set$Xgafv(String $Xgafv) {
                        return (Wait)super.set$Xgafv($Xgafv);
                    }

                    public Wait setAccessToken(String accessToken) {
                        return (Wait)super.setAccessToken(accessToken);
                    }

                    public Wait setAlt(String alt) {
                        return (Wait)super.setAlt(alt);
                    }

                    public Wait setCallback(String callback) {
                        return (Wait)super.setCallback(callback);
                    }

                    public Wait setFields(String fields) {
                        return (Wait)super.setFields(fields);
                    }

                    public Wait setKey(String key) {
                        return (Wait)super.setKey(key);
                    }

                    public Wait setOauthToken(String oauthToken) {
                        return (Wait)super.setOauthToken(oauthToken);
                    }

                    public Wait setPrettyPrint(Boolean prettyPrint) {
                        return (Wait)super.setPrettyPrint(prettyPrint);
                    }

                    public Wait setQuotaUser(String quotaUser) {
                        return (Wait)super.setQuotaUser(quotaUser);
                    }

                    public Wait setUploadType(String uploadType) {
                        return (Wait)super.setUploadType(uploadType);
                    }

                    public Wait setUploadProtocol(String uploadProtocol) {
                        return (Wait)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Wait setName(String name) {
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Wait set(String parameterName, Object value) {
                        return (Wait)super.set(parameterName, value);
                    }
                }

                public class List
                extends TranslateRequest<ListOperationsResponse> {
                    private static final String REST_PATH = "v3/{+name}/operations";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String filter;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected List(String name) {
                        super(Translate.this, "GET", REST_PATH, null, ListOperationsResponse.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public List setName(String name) {
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    public String getFilter() {
                        return this.filter;
                    }

                    public List setFilter(String filter) {
                        this.filter = filter;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class Get
                extends TranslateRequest<Operation> {
                    private static final String REST_PATH = "v3/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Get(String name) {
                        super(Translate.this, "GET", REST_PATH, null, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String name) {
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class Delete
                extends TranslateRequest<Empty> {
                    private static final String REST_PATH = "v3/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Delete(String name) {
                        super(Translate.this, "DELETE", REST_PATH, null, Empty.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                    }

                    public Delete set$Xgafv(String $Xgafv) {
                        return (Delete)super.set$Xgafv($Xgafv);
                    }

                    public Delete setAccessToken(String accessToken) {
                        return (Delete)super.setAccessToken(accessToken);
                    }

                    public Delete setAlt(String alt) {
                        return (Delete)super.setAlt(alt);
                    }

                    public Delete setCallback(String callback) {
                        return (Delete)super.setCallback(callback);
                    }

                    public Delete setFields(String fields) {
                        return (Delete)super.setFields(fields);
                    }

                    public Delete setKey(String key) {
                        return (Delete)super.setKey(key);
                    }

                    public Delete setOauthToken(String oauthToken) {
                        return (Delete)super.setOauthToken(oauthToken);
                    }

                    public Delete setPrettyPrint(Boolean prettyPrint) {
                        return (Delete)super.setPrettyPrint(prettyPrint);
                    }

                    public Delete setQuotaUser(String quotaUser) {
                        return (Delete)super.setQuotaUser(quotaUser);
                    }

                    public Delete setUploadType(String uploadType) {
                        return (Delete)super.setUploadType(uploadType);
                    }

                    public Delete setUploadProtocol(String uploadProtocol) {
                        return (Delete)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Delete setName(String name) {
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Delete set(String parameterName, Object value) {
                        return (Delete)super.set(parameterName, value);
                    }
                }

                public class Cancel
                extends TranslateRequest<Empty> {
                    private static final String REST_PATH = "v3/{+name}:cancel";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Cancel(String name, CancelOperationRequest content) {
                        super(Translate.this, "POST", REST_PATH, (Object)content, Empty.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                    }

                    public Cancel set$Xgafv(String $Xgafv) {
                        return (Cancel)super.set$Xgafv($Xgafv);
                    }

                    public Cancel setAccessToken(String accessToken) {
                        return (Cancel)super.setAccessToken(accessToken);
                    }

                    public Cancel setAlt(String alt) {
                        return (Cancel)super.setAlt(alt);
                    }

                    public Cancel setCallback(String callback) {
                        return (Cancel)super.setCallback(callback);
                    }

                    public Cancel setFields(String fields) {
                        return (Cancel)super.setFields(fields);
                    }

                    public Cancel setKey(String key) {
                        return (Cancel)super.setKey(key);
                    }

                    public Cancel setOauthToken(String oauthToken) {
                        return (Cancel)super.setOauthToken(oauthToken);
                    }

                    public Cancel setPrettyPrint(Boolean prettyPrint) {
                        return (Cancel)super.setPrettyPrint(prettyPrint);
                    }

                    public Cancel setQuotaUser(String quotaUser) {
                        return (Cancel)super.setQuotaUser(quotaUser);
                    }

                    public Cancel setUploadType(String uploadType) {
                        return (Cancel)super.setUploadType(uploadType);
                    }

                    public Cancel setUploadProtocol(String uploadProtocol) {
                        return (Cancel)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Cancel setName(String name) {
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Cancel set(String parameterName, Object value) {
                        return (Cancel)super.set(parameterName, value);
                    }
                }
            }

            public class Models {
                public Create create(String parent, Model content) throws IOException {
                    Create result = new Create(parent, content);
                    Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Delete delete(String name) throws IOException {
                    Delete result = new Delete(name);
                    Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(String name) throws IOException {
                    Get result = new Get(name);
                    Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String parent) throws IOException {
                    List result = new List(parent);
                    Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class List
                extends TranslateRequest<ListModelsResponse> {
                    private static final String REST_PATH = "v3/{+parent}/models";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String filter;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected List(String parent) {
                        super(Translate.this, "GET", REST_PATH, null, ListModelsResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String parent) {
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public String getFilter() {
                        return this.filter;
                    }

                    public List setFilter(String filter) {
                        this.filter = filter;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class Get
                extends TranslateRequest<Model> {
                    private static final String REST_PATH = "v3/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Get(String name) {
                        super(Translate.this, "GET", REST_PATH, null, Model.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/models/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/models/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String name) {
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/models/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class Delete
                extends TranslateRequest<Operation> {
                    private static final String REST_PATH = "v3/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Delete(String name) {
                        super(Translate.this, "DELETE", REST_PATH, null, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/models/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/models/[^/]+$");
                        }
                    }

                    public Delete set$Xgafv(String $Xgafv) {
                        return (Delete)super.set$Xgafv($Xgafv);
                    }

                    public Delete setAccessToken(String accessToken) {
                        return (Delete)super.setAccessToken(accessToken);
                    }

                    public Delete setAlt(String alt) {
                        return (Delete)super.setAlt(alt);
                    }

                    public Delete setCallback(String callback) {
                        return (Delete)super.setCallback(callback);
                    }

                    public Delete setFields(String fields) {
                        return (Delete)super.setFields(fields);
                    }

                    public Delete setKey(String key) {
                        return (Delete)super.setKey(key);
                    }

                    public Delete setOauthToken(String oauthToken) {
                        return (Delete)super.setOauthToken(oauthToken);
                    }

                    public Delete setPrettyPrint(Boolean prettyPrint) {
                        return (Delete)super.setPrettyPrint(prettyPrint);
                    }

                    public Delete setQuotaUser(String quotaUser) {
                        return (Delete)super.setQuotaUser(quotaUser);
                    }

                    public Delete setUploadType(String uploadType) {
                        return (Delete)super.setUploadType(uploadType);
                    }

                    public Delete setUploadProtocol(String uploadProtocol) {
                        return (Delete)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Delete setName(String name) {
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/models/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Delete set(String parameterName, Object value) {
                        return (Delete)super.set(parameterName, value);
                    }
                }

                public class Create
                extends TranslateRequest<Operation> {
                    private static final String REST_PATH = "v3/{+parent}/models";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;

                    protected Create(String parent, Model content) {
                        super(Translate.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public Create set$Xgafv(String $Xgafv) {
                        return (Create)super.set$Xgafv($Xgafv);
                    }

                    public Create setAccessToken(String accessToken) {
                        return (Create)super.setAccessToken(accessToken);
                    }

                    public Create setAlt(String alt) {
                        return (Create)super.setAlt(alt);
                    }

                    public Create setCallback(String callback) {
                        return (Create)super.setCallback(callback);
                    }

                    public Create setFields(String fields) {
                        return (Create)super.setFields(fields);
                    }

                    public Create setKey(String key) {
                        return (Create)super.setKey(key);
                    }

                    public Create setOauthToken(String oauthToken) {
                        return (Create)super.setOauthToken(oauthToken);
                    }

                    public Create setPrettyPrint(Boolean prettyPrint) {
                        return (Create)super.setPrettyPrint(prettyPrint);
                    }

                    public Create setQuotaUser(String quotaUser) {
                        return (Create)super.setQuotaUser(quotaUser);
                    }

                    public Create setUploadType(String uploadType) {
                        return (Create)super.setUploadType(uploadType);
                    }

                    public Create setUploadProtocol(String uploadProtocol) {
                        return (Create)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public Create setParent(String parent) {
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    @Override
                    public Create set(String parameterName, Object value) {
                        return (Create)super.set(parameterName, value);
                    }
                }
            }

            public class Glossaries {
                public Create create(String parent, Glossary content) throws IOException {
                    Create result = new Create(parent, content);
                    Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Delete delete(String name) throws IOException {
                    Delete result = new Delete(name);
                    Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(String name) throws IOException {
                    Get result = new Get(name);
                    Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String parent) throws IOException {
                    List result = new List(parent);
                    Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Patch patch(String name, Glossary content) throws IOException {
                    Patch result = new Patch(name, content);
                    Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public GlossaryEntries glossaryEntries() {
                    return new GlossaryEntries();
                }

                public class GlossaryEntries {
                    public Create create(String parent, GlossaryEntry content) throws IOException {
                        Create result = new Create(parent, content);
                        Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Delete delete(String name) throws IOException {
                        Delete result = new Delete(name);
                        Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Get get(String name) throws IOException {
                        Get result = new Get(name);
                        Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public List list(String parent) throws IOException {
                        List result = new List(parent);
                        Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Patch patch(String name, GlossaryEntry content) throws IOException {
                        Patch result = new Patch(name, content);
                        Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public class Patch
                    extends TranslateRequest<GlossaryEntry> {
                        private static final String REST_PATH = "v3/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected Patch(String name, GlossaryEntry content) {
                            super(Translate.this, "PATCH", REST_PATH, (Object)content, GlossaryEntry.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/glossaries/[^/]+/glossaryEntries/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!Translate.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/glossaries/[^/]+/glossaryEntries/[^/]+$");
                            }
                        }

                        public Patch set$Xgafv(String $Xgafv) {
                            return (Patch)super.set$Xgafv($Xgafv);
                        }

                        public Patch setAccessToken(String accessToken) {
                            return (Patch)super.setAccessToken(accessToken);
                        }

                        public Patch setAlt(String alt) {
                            return (Patch)super.setAlt(alt);
                        }

                        public Patch setCallback(String callback) {
                            return (Patch)super.setCallback(callback);
                        }

                        public Patch setFields(String fields) {
                            return (Patch)super.setFields(fields);
                        }

                        public Patch setKey(String key) {
                            return (Patch)super.setKey(key);
                        }

                        public Patch setOauthToken(String oauthToken) {
                            return (Patch)super.setOauthToken(oauthToken);
                        }

                        public Patch setPrettyPrint(Boolean prettyPrint) {
                            return (Patch)super.setPrettyPrint(prettyPrint);
                        }

                        public Patch setQuotaUser(String quotaUser) {
                            return (Patch)super.setQuotaUser(quotaUser);
                        }

                        public Patch setUploadType(String uploadType) {
                            return (Patch)super.setUploadType(uploadType);
                        }

                        public Patch setUploadProtocol(String uploadProtocol) {
                            return (Patch)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Patch setName(String name) {
                            if (!Translate.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/glossaries/[^/]+/glossaryEntries/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        @Override
                        public Patch set(String parameterName, Object value) {
                            return (Patch)super.set(parameterName, value);
                        }
                    }

                    public class List
                    extends TranslateRequest<ListGlossaryEntriesResponse> {
                        private static final String REST_PATH = "v3/{+parent}/glossaryEntries";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;
                        @Key
                        private Integer pageSize;
                        @Key
                        private String pageToken;

                        protected List(String parent) {
                            super(Translate.this, "GET", REST_PATH, null, ListGlossaryEntriesResponse.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/glossaries/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                            if (!Translate.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/glossaries/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public List set$Xgafv(String $Xgafv) {
                            return (List)super.set$Xgafv($Xgafv);
                        }

                        public List setAccessToken(String accessToken) {
                            return (List)super.setAccessToken(accessToken);
                        }

                        public List setAlt(String alt) {
                            return (List)super.setAlt(alt);
                        }

                        public List setCallback(String callback) {
                            return (List)super.setCallback(callback);
                        }

                        public List setFields(String fields) {
                            return (List)super.setFields(fields);
                        }

                        public List setKey(String key) {
                            return (List)super.setKey(key);
                        }

                        public List setOauthToken(String oauthToken) {
                            return (List)super.setOauthToken(oauthToken);
                        }

                        public List setPrettyPrint(Boolean prettyPrint) {
                            return (List)super.setPrettyPrint(prettyPrint);
                        }

                        public List setQuotaUser(String quotaUser) {
                            return (List)super.setQuotaUser(quotaUser);
                        }

                        public List setUploadType(String uploadType) {
                            return (List)super.setUploadType(uploadType);
                        }

                        public List setUploadProtocol(String uploadProtocol) {
                            return (List)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public List setParent(String parent) {
                            if (!Translate.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/glossaries/[^/]+$");
                            }
                            this.parent = parent;
                            return this;
                        }

                        public Integer getPageSize() {
                            return this.pageSize;
                        }

                        public List setPageSize(Integer pageSize) {
                            this.pageSize = pageSize;
                            return this;
                        }

                        public String getPageToken() {
                            return this.pageToken;
                        }

                        public List setPageToken(String pageToken) {
                            this.pageToken = pageToken;
                            return this;
                        }

                        @Override
                        public List set(String parameterName, Object value) {
                            return (List)super.set(parameterName, value);
                        }
                    }

                    public class Get
                    extends TranslateRequest<GlossaryEntry> {
                        private static final String REST_PATH = "v3/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected Get(String name) {
                            super(Translate.this, "GET", REST_PATH, null, GlossaryEntry.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/glossaries/[^/]+/glossaryEntries/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!Translate.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/glossaries/[^/]+/glossaryEntries/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public Get set$Xgafv(String $Xgafv) {
                            return (Get)super.set$Xgafv($Xgafv);
                        }

                        public Get setAccessToken(String accessToken) {
                            return (Get)super.setAccessToken(accessToken);
                        }

                        public Get setAlt(String alt) {
                            return (Get)super.setAlt(alt);
                        }

                        public Get setCallback(String callback) {
                            return (Get)super.setCallback(callback);
                        }

                        public Get setFields(String fields) {
                            return (Get)super.setFields(fields);
                        }

                        public Get setKey(String key) {
                            return (Get)super.setKey(key);
                        }

                        public Get setOauthToken(String oauthToken) {
                            return (Get)super.setOauthToken(oauthToken);
                        }

                        public Get setPrettyPrint(Boolean prettyPrint) {
                            return (Get)super.setPrettyPrint(prettyPrint);
                        }

                        public Get setQuotaUser(String quotaUser) {
                            return (Get)super.setQuotaUser(quotaUser);
                        }

                        public Get setUploadType(String uploadType) {
                            return (Get)super.setUploadType(uploadType);
                        }

                        public Get setUploadProtocol(String uploadProtocol) {
                            return (Get)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Get setName(String name) {
                            if (!Translate.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/glossaries/[^/]+/glossaryEntries/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        @Override
                        public Get set(String parameterName, Object value) {
                            return (Get)super.set(parameterName, value);
                        }
                    }

                    public class Delete
                    extends TranslateRequest<Empty> {
                        private static final String REST_PATH = "v3/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected Delete(String name) {
                            super(Translate.this, "DELETE", REST_PATH, null, Empty.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/glossaries/[^/]+/glossaryEntries/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!Translate.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/glossaries/[^/]+/glossaryEntries/[^/]+$");
                            }
                        }

                        public Delete set$Xgafv(String $Xgafv) {
                            return (Delete)super.set$Xgafv($Xgafv);
                        }

                        public Delete setAccessToken(String accessToken) {
                            return (Delete)super.setAccessToken(accessToken);
                        }

                        public Delete setAlt(String alt) {
                            return (Delete)super.setAlt(alt);
                        }

                        public Delete setCallback(String callback) {
                            return (Delete)super.setCallback(callback);
                        }

                        public Delete setFields(String fields) {
                            return (Delete)super.setFields(fields);
                        }

                        public Delete setKey(String key) {
                            return (Delete)super.setKey(key);
                        }

                        public Delete setOauthToken(String oauthToken) {
                            return (Delete)super.setOauthToken(oauthToken);
                        }

                        public Delete setPrettyPrint(Boolean prettyPrint) {
                            return (Delete)super.setPrettyPrint(prettyPrint);
                        }

                        public Delete setQuotaUser(String quotaUser) {
                            return (Delete)super.setQuotaUser(quotaUser);
                        }

                        public Delete setUploadType(String uploadType) {
                            return (Delete)super.setUploadType(uploadType);
                        }

                        public Delete setUploadProtocol(String uploadProtocol) {
                            return (Delete)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Delete setName(String name) {
                            if (!Translate.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/glossaries/[^/]+/glossaryEntries/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        @Override
                        public Delete set(String parameterName, Object value) {
                            return (Delete)super.set(parameterName, value);
                        }
                    }

                    public class Create
                    extends TranslateRequest<GlossaryEntry> {
                        private static final String REST_PATH = "v3/{+parent}/glossaryEntries";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;

                        protected Create(String parent, GlossaryEntry content) {
                            super(Translate.this, "POST", REST_PATH, (Object)content, GlossaryEntry.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/glossaries/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                            if (!Translate.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/glossaries/[^/]+$");
                            }
                        }

                        public Create set$Xgafv(String $Xgafv) {
                            return (Create)super.set$Xgafv($Xgafv);
                        }

                        public Create setAccessToken(String accessToken) {
                            return (Create)super.setAccessToken(accessToken);
                        }

                        public Create setAlt(String alt) {
                            return (Create)super.setAlt(alt);
                        }

                        public Create setCallback(String callback) {
                            return (Create)super.setCallback(callback);
                        }

                        public Create setFields(String fields) {
                            return (Create)super.setFields(fields);
                        }

                        public Create setKey(String key) {
                            return (Create)super.setKey(key);
                        }

                        public Create setOauthToken(String oauthToken) {
                            return (Create)super.setOauthToken(oauthToken);
                        }

                        public Create setPrettyPrint(Boolean prettyPrint) {
                            return (Create)super.setPrettyPrint(prettyPrint);
                        }

                        public Create setQuotaUser(String quotaUser) {
                            return (Create)super.setQuotaUser(quotaUser);
                        }

                        public Create setUploadType(String uploadType) {
                            return (Create)super.setUploadType(uploadType);
                        }

                        public Create setUploadProtocol(String uploadProtocol) {
                            return (Create)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public Create setParent(String parent) {
                            if (!Translate.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/glossaries/[^/]+$");
                            }
                            this.parent = parent;
                            return this;
                        }

                        @Override
                        public Create set(String parameterName, Object value) {
                            return (Create)super.set(parameterName, value);
                        }
                    }
                }

                public class Patch
                extends TranslateRequest<Operation> {
                    private static final String REST_PATH = "v3/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String updateMask;

                    protected Patch(String name, Glossary content) {
                        super(Translate.this, "PATCH", REST_PATH, (Object)content, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/glossaries/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/glossaries/[^/]+$");
                        }
                    }

                    public Patch set$Xgafv(String $Xgafv) {
                        return (Patch)super.set$Xgafv($Xgafv);
                    }

                    public Patch setAccessToken(String accessToken) {
                        return (Patch)super.setAccessToken(accessToken);
                    }

                    public Patch setAlt(String alt) {
                        return (Patch)super.setAlt(alt);
                    }

                    public Patch setCallback(String callback) {
                        return (Patch)super.setCallback(callback);
                    }

                    public Patch setFields(String fields) {
                        return (Patch)super.setFields(fields);
                    }

                    public Patch setKey(String key) {
                        return (Patch)super.setKey(key);
                    }

                    public Patch setOauthToken(String oauthToken) {
                        return (Patch)super.setOauthToken(oauthToken);
                    }

                    public Patch setPrettyPrint(Boolean prettyPrint) {
                        return (Patch)super.setPrettyPrint(prettyPrint);
                    }

                    public Patch setQuotaUser(String quotaUser) {
                        return (Patch)super.setQuotaUser(quotaUser);
                    }

                    public Patch setUploadType(String uploadType) {
                        return (Patch)super.setUploadType(uploadType);
                    }

                    public Patch setUploadProtocol(String uploadProtocol) {
                        return (Patch)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Patch setName(String name) {
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/glossaries/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    public String getUpdateMask() {
                        return this.updateMask;
                    }

                    public Patch setUpdateMask(String updateMask) {
                        this.updateMask = updateMask;
                        return this;
                    }

                    @Override
                    public Patch set(String parameterName, Object value) {
                        return (Patch)super.set(parameterName, value);
                    }
                }

                public class List
                extends TranslateRequest<ListGlossariesResponse> {
                    private static final String REST_PATH = "v3/{+parent}/glossaries";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String filter;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected List(String parent) {
                        super(Translate.this, "GET", REST_PATH, null, ListGlossariesResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String parent) {
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public String getFilter() {
                        return this.filter;
                    }

                    public List setFilter(String filter) {
                        this.filter = filter;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class Get
                extends TranslateRequest<Glossary> {
                    private static final String REST_PATH = "v3/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Get(String name) {
                        super(Translate.this, "GET", REST_PATH, null, Glossary.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/glossaries/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/glossaries/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String name) {
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/glossaries/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class Delete
                extends TranslateRequest<Operation> {
                    private static final String REST_PATH = "v3/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Delete(String name) {
                        super(Translate.this, "DELETE", REST_PATH, null, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/glossaries/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/glossaries/[^/]+$");
                        }
                    }

                    public Delete set$Xgafv(String $Xgafv) {
                        return (Delete)super.set$Xgafv($Xgafv);
                    }

                    public Delete setAccessToken(String accessToken) {
                        return (Delete)super.setAccessToken(accessToken);
                    }

                    public Delete setAlt(String alt) {
                        return (Delete)super.setAlt(alt);
                    }

                    public Delete setCallback(String callback) {
                        return (Delete)super.setCallback(callback);
                    }

                    public Delete setFields(String fields) {
                        return (Delete)super.setFields(fields);
                    }

                    public Delete setKey(String key) {
                        return (Delete)super.setKey(key);
                    }

                    public Delete setOauthToken(String oauthToken) {
                        return (Delete)super.setOauthToken(oauthToken);
                    }

                    public Delete setPrettyPrint(Boolean prettyPrint) {
                        return (Delete)super.setPrettyPrint(prettyPrint);
                    }

                    public Delete setQuotaUser(String quotaUser) {
                        return (Delete)super.setQuotaUser(quotaUser);
                    }

                    public Delete setUploadType(String uploadType) {
                        return (Delete)super.setUploadType(uploadType);
                    }

                    public Delete setUploadProtocol(String uploadProtocol) {
                        return (Delete)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Delete setName(String name) {
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/glossaries/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Delete set(String parameterName, Object value) {
                        return (Delete)super.set(parameterName, value);
                    }
                }

                public class Create
                extends TranslateRequest<Operation> {
                    private static final String REST_PATH = "v3/{+parent}/glossaries";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;

                    protected Create(String parent, Glossary content) {
                        super(Translate.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public Create set$Xgafv(String $Xgafv) {
                        return (Create)super.set$Xgafv($Xgafv);
                    }

                    public Create setAccessToken(String accessToken) {
                        return (Create)super.setAccessToken(accessToken);
                    }

                    public Create setAlt(String alt) {
                        return (Create)super.setAlt(alt);
                    }

                    public Create setCallback(String callback) {
                        return (Create)super.setCallback(callback);
                    }

                    public Create setFields(String fields) {
                        return (Create)super.setFields(fields);
                    }

                    public Create setKey(String key) {
                        return (Create)super.setKey(key);
                    }

                    public Create setOauthToken(String oauthToken) {
                        return (Create)super.setOauthToken(oauthToken);
                    }

                    public Create setPrettyPrint(Boolean prettyPrint) {
                        return (Create)super.setPrettyPrint(prettyPrint);
                    }

                    public Create setQuotaUser(String quotaUser) {
                        return (Create)super.setQuotaUser(quotaUser);
                    }

                    public Create setUploadType(String uploadType) {
                        return (Create)super.setUploadType(uploadType);
                    }

                    public Create setUploadProtocol(String uploadProtocol) {
                        return (Create)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public Create setParent(String parent) {
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    @Override
                    public Create set(String parameterName, Object value) {
                        return (Create)super.set(parameterName, value);
                    }
                }
            }

            public class Datasets {
                public Create create(String parent, Dataset content) throws IOException {
                    Create result = new Create(parent, content);
                    Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Delete delete(String name) throws IOException {
                    Delete result = new Delete(name);
                    Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public ExportData exportData(String dataset, ExportDataRequest content) throws IOException {
                    ExportData result = new ExportData(dataset, content);
                    Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(String name) throws IOException {
                    Get result = new Get(name);
                    Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public ImportData importData(String dataset, ImportDataRequest content) throws IOException {
                    ImportData result = new ImportData(dataset, content);
                    Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String parent) throws IOException {
                    List result = new List(parent);
                    Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Examples examples() {
                    return new Examples();
                }

                public class Examples {
                    public List list(String parent) throws IOException {
                        List result = new List(parent);
                        Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public class List
                    extends TranslateRequest<ListExamplesResponse> {
                        private static final String REST_PATH = "v3/{+parent}/examples";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;
                        @Key
                        private String filter;
                        @Key
                        private Integer pageSize;
                        @Key
                        private String pageToken;

                        protected List(String parent) {
                            super(Translate.this, "GET", REST_PATH, null, ListExamplesResponse.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                            if (!Translate.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public List set$Xgafv(String $Xgafv) {
                            return (List)super.set$Xgafv($Xgafv);
                        }

                        public List setAccessToken(String accessToken) {
                            return (List)super.setAccessToken(accessToken);
                        }

                        public List setAlt(String alt) {
                            return (List)super.setAlt(alt);
                        }

                        public List setCallback(String callback) {
                            return (List)super.setCallback(callback);
                        }

                        public List setFields(String fields) {
                            return (List)super.setFields(fields);
                        }

                        public List setKey(String key) {
                            return (List)super.setKey(key);
                        }

                        public List setOauthToken(String oauthToken) {
                            return (List)super.setOauthToken(oauthToken);
                        }

                        public List setPrettyPrint(Boolean prettyPrint) {
                            return (List)super.setPrettyPrint(prettyPrint);
                        }

                        public List setQuotaUser(String quotaUser) {
                            return (List)super.setQuotaUser(quotaUser);
                        }

                        public List setUploadType(String uploadType) {
                            return (List)super.setUploadType(uploadType);
                        }

                        public List setUploadProtocol(String uploadProtocol) {
                            return (List)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public List setParent(String parent) {
                            if (!Translate.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
                            }
                            this.parent = parent;
                            return this;
                        }

                        public String getFilter() {
                            return this.filter;
                        }

                        public List setFilter(String filter) {
                            this.filter = filter;
                            return this;
                        }

                        public Integer getPageSize() {
                            return this.pageSize;
                        }

                        public List setPageSize(Integer pageSize) {
                            this.pageSize = pageSize;
                            return this;
                        }

                        public String getPageToken() {
                            return this.pageToken;
                        }

                        public List setPageToken(String pageToken) {
                            this.pageToken = pageToken;
                            return this;
                        }

                        @Override
                        public List set(String parameterName, Object value) {
                            return (List)super.set(parameterName, value);
                        }
                    }
                }

                public class List
                extends TranslateRequest<ListDatasetsResponse> {
                    private static final String REST_PATH = "v3/{+parent}/datasets";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected List(String parent) {
                        super(Translate.this, "GET", REST_PATH, null, ListDatasetsResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String parent) {
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class ImportData
                extends TranslateRequest<Operation> {
                    private static final String REST_PATH = "v3/{+dataset}:importData";
                    private final Pattern DATASET_PATTERN;
                    @Key
                    private String dataset;

                    protected ImportData(String dataset, ImportDataRequest content) {
                        super(Translate.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.DATASET_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
                        this.dataset = (String)Preconditions.checkNotNull((Object)dataset, (Object)"Required parameter dataset must be specified.");
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.DATASET_PATTERN.matcher(dataset).matches(), (Object)"Parameter dataset must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
                        }
                    }

                    public ImportData set$Xgafv(String $Xgafv) {
                        return (ImportData)super.set$Xgafv($Xgafv);
                    }

                    public ImportData setAccessToken(String accessToken) {
                        return (ImportData)super.setAccessToken(accessToken);
                    }

                    public ImportData setAlt(String alt) {
                        return (ImportData)super.setAlt(alt);
                    }

                    public ImportData setCallback(String callback) {
                        return (ImportData)super.setCallback(callback);
                    }

                    public ImportData setFields(String fields) {
                        return (ImportData)super.setFields(fields);
                    }

                    public ImportData setKey(String key) {
                        return (ImportData)super.setKey(key);
                    }

                    public ImportData setOauthToken(String oauthToken) {
                        return (ImportData)super.setOauthToken(oauthToken);
                    }

                    public ImportData setPrettyPrint(Boolean prettyPrint) {
                        return (ImportData)super.setPrettyPrint(prettyPrint);
                    }

                    public ImportData setQuotaUser(String quotaUser) {
                        return (ImportData)super.setQuotaUser(quotaUser);
                    }

                    public ImportData setUploadType(String uploadType) {
                        return (ImportData)super.setUploadType(uploadType);
                    }

                    public ImportData setUploadProtocol(String uploadProtocol) {
                        return (ImportData)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getDataset() {
                        return this.dataset;
                    }

                    public ImportData setDataset(String dataset) {
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.DATASET_PATTERN.matcher(dataset).matches(), (Object)"Parameter dataset must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
                        }
                        this.dataset = dataset;
                        return this;
                    }

                    @Override
                    public ImportData set(String parameterName, Object value) {
                        return (ImportData)super.set(parameterName, value);
                    }
                }

                public class Get
                extends TranslateRequest<Dataset> {
                    private static final String REST_PATH = "v3/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Get(String name) {
                        super(Translate.this, "GET", REST_PATH, null, Dataset.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String name) {
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class ExportData
                extends TranslateRequest<Operation> {
                    private static final String REST_PATH = "v3/{+dataset}:exportData";
                    private final Pattern DATASET_PATTERN;
                    @Key
                    private String dataset;

                    protected ExportData(String dataset, ExportDataRequest content) {
                        super(Translate.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.DATASET_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
                        this.dataset = (String)Preconditions.checkNotNull((Object)dataset, (Object)"Required parameter dataset must be specified.");
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.DATASET_PATTERN.matcher(dataset).matches(), (Object)"Parameter dataset must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
                        }
                    }

                    public ExportData set$Xgafv(String $Xgafv) {
                        return (ExportData)super.set$Xgafv($Xgafv);
                    }

                    public ExportData setAccessToken(String accessToken) {
                        return (ExportData)super.setAccessToken(accessToken);
                    }

                    public ExportData setAlt(String alt) {
                        return (ExportData)super.setAlt(alt);
                    }

                    public ExportData setCallback(String callback) {
                        return (ExportData)super.setCallback(callback);
                    }

                    public ExportData setFields(String fields) {
                        return (ExportData)super.setFields(fields);
                    }

                    public ExportData setKey(String key) {
                        return (ExportData)super.setKey(key);
                    }

                    public ExportData setOauthToken(String oauthToken) {
                        return (ExportData)super.setOauthToken(oauthToken);
                    }

                    public ExportData setPrettyPrint(Boolean prettyPrint) {
                        return (ExportData)super.setPrettyPrint(prettyPrint);
                    }

                    public ExportData setQuotaUser(String quotaUser) {
                        return (ExportData)super.setQuotaUser(quotaUser);
                    }

                    public ExportData setUploadType(String uploadType) {
                        return (ExportData)super.setUploadType(uploadType);
                    }

                    public ExportData setUploadProtocol(String uploadProtocol) {
                        return (ExportData)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getDataset() {
                        return this.dataset;
                    }

                    public ExportData setDataset(String dataset) {
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.DATASET_PATTERN.matcher(dataset).matches(), (Object)"Parameter dataset must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
                        }
                        this.dataset = dataset;
                        return this;
                    }

                    @Override
                    public ExportData set(String parameterName, Object value) {
                        return (ExportData)super.set(parameterName, value);
                    }
                }

                public class Delete
                extends TranslateRequest<Operation> {
                    private static final String REST_PATH = "v3/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Delete(String name) {
                        super(Translate.this, "DELETE", REST_PATH, null, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
                        }
                    }

                    public Delete set$Xgafv(String $Xgafv) {
                        return (Delete)super.set$Xgafv($Xgafv);
                    }

                    public Delete setAccessToken(String accessToken) {
                        return (Delete)super.setAccessToken(accessToken);
                    }

                    public Delete setAlt(String alt) {
                        return (Delete)super.setAlt(alt);
                    }

                    public Delete setCallback(String callback) {
                        return (Delete)super.setCallback(callback);
                    }

                    public Delete setFields(String fields) {
                        return (Delete)super.setFields(fields);
                    }

                    public Delete setKey(String key) {
                        return (Delete)super.setKey(key);
                    }

                    public Delete setOauthToken(String oauthToken) {
                        return (Delete)super.setOauthToken(oauthToken);
                    }

                    public Delete setPrettyPrint(Boolean prettyPrint) {
                        return (Delete)super.setPrettyPrint(prettyPrint);
                    }

                    public Delete setQuotaUser(String quotaUser) {
                        return (Delete)super.setQuotaUser(quotaUser);
                    }

                    public Delete setUploadType(String uploadType) {
                        return (Delete)super.setUploadType(uploadType);
                    }

                    public Delete setUploadProtocol(String uploadProtocol) {
                        return (Delete)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Delete setName(String name) {
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Delete set(String parameterName, Object value) {
                        return (Delete)super.set(parameterName, value);
                    }
                }

                public class Create
                extends TranslateRequest<Operation> {
                    private static final String REST_PATH = "v3/{+parent}/datasets";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;

                    protected Create(String parent, Dataset content) {
                        super(Translate.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public Create set$Xgafv(String $Xgafv) {
                        return (Create)super.set$Xgafv($Xgafv);
                    }

                    public Create setAccessToken(String accessToken) {
                        return (Create)super.setAccessToken(accessToken);
                    }

                    public Create setAlt(String alt) {
                        return (Create)super.setAlt(alt);
                    }

                    public Create setCallback(String callback) {
                        return (Create)super.setCallback(callback);
                    }

                    public Create setFields(String fields) {
                        return (Create)super.setFields(fields);
                    }

                    public Create setKey(String key) {
                        return (Create)super.setKey(key);
                    }

                    public Create setOauthToken(String oauthToken) {
                        return (Create)super.setOauthToken(oauthToken);
                    }

                    public Create setPrettyPrint(Boolean prettyPrint) {
                        return (Create)super.setPrettyPrint(prettyPrint);
                    }

                    public Create setQuotaUser(String quotaUser) {
                        return (Create)super.setQuotaUser(quotaUser);
                    }

                    public Create setUploadType(String uploadType) {
                        return (Create)super.setUploadType(uploadType);
                    }

                    public Create setUploadProtocol(String uploadProtocol) {
                        return (Create)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public Create setParent(String parent) {
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    @Override
                    public Create set(String parameterName, Object value) {
                        return (Create)super.set(parameterName, value);
                    }
                }
            }

            public class AdaptiveMtDatasets {
                public Create create(String parent, AdaptiveMtDataset content) throws IOException {
                    Create result = new Create(parent, content);
                    Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Delete delete(String name) throws IOException {
                    Delete result = new Delete(name);
                    Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(String name) throws IOException {
                    Get result = new Get(name);
                    Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public ImportAdaptiveMtFile importAdaptiveMtFile(String parent, ImportAdaptiveMtFileRequest content) throws IOException {
                    ImportAdaptiveMtFile result = new ImportAdaptiveMtFile(parent, content);
                    Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String parent) throws IOException {
                    List result = new List(parent);
                    Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public AdaptiveMtFiles adaptiveMtFiles() {
                    return new AdaptiveMtFiles();
                }

                public AdaptiveMtSentences adaptiveMtSentences() {
                    return new AdaptiveMtSentences();
                }

                public class AdaptiveMtSentences {
                    public List list(String parent) throws IOException {
                        List result = new List(parent);
                        Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public class List
                    extends TranslateRequest<ListAdaptiveMtSentencesResponse> {
                        private static final String REST_PATH = "v3/{+parent}/adaptiveMtSentences";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;
                        @Key
                        private Integer pageSize;
                        @Key
                        private String pageToken;

                        protected List(String parent) {
                            super(Translate.this, "GET", REST_PATH, null, ListAdaptiveMtSentencesResponse.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/adaptiveMtDatasets/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                            if (!Translate.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/adaptiveMtDatasets/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public List set$Xgafv(String $Xgafv) {
                            return (List)super.set$Xgafv($Xgafv);
                        }

                        public List setAccessToken(String accessToken) {
                            return (List)super.setAccessToken(accessToken);
                        }

                        public List setAlt(String alt) {
                            return (List)super.setAlt(alt);
                        }

                        public List setCallback(String callback) {
                            return (List)super.setCallback(callback);
                        }

                        public List setFields(String fields) {
                            return (List)super.setFields(fields);
                        }

                        public List setKey(String key) {
                            return (List)super.setKey(key);
                        }

                        public List setOauthToken(String oauthToken) {
                            return (List)super.setOauthToken(oauthToken);
                        }

                        public List setPrettyPrint(Boolean prettyPrint) {
                            return (List)super.setPrettyPrint(prettyPrint);
                        }

                        public List setQuotaUser(String quotaUser) {
                            return (List)super.setQuotaUser(quotaUser);
                        }

                        public List setUploadType(String uploadType) {
                            return (List)super.setUploadType(uploadType);
                        }

                        public List setUploadProtocol(String uploadProtocol) {
                            return (List)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public List setParent(String parent) {
                            if (!Translate.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/adaptiveMtDatasets/[^/]+$");
                            }
                            this.parent = parent;
                            return this;
                        }

                        public Integer getPageSize() {
                            return this.pageSize;
                        }

                        public List setPageSize(Integer pageSize) {
                            this.pageSize = pageSize;
                            return this;
                        }

                        public String getPageToken() {
                            return this.pageToken;
                        }

                        public List setPageToken(String pageToken) {
                            this.pageToken = pageToken;
                            return this;
                        }

                        @Override
                        public List set(String parameterName, Object value) {
                            return (List)super.set(parameterName, value);
                        }
                    }
                }

                public class AdaptiveMtFiles {
                    public Delete delete(String name) throws IOException {
                        Delete result = new Delete(name);
                        Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Get get(String name) throws IOException {
                        Get result = new Get(name);
                        Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public List list(String parent) throws IOException {
                        List result = new List(parent);
                        Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public AdaptiveMtSentences adaptiveMtSentences() {
                        return new AdaptiveMtSentences();
                    }

                    public class AdaptiveMtSentences {
                        public List list(String parent) throws IOException {
                            List result = new List(parent);
                            Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public class List
                        extends TranslateRequest<ListAdaptiveMtSentencesResponse> {
                            private static final String REST_PATH = "v3/{+parent}/adaptiveMtSentences";
                            private final Pattern PARENT_PATTERN;
                            @Key
                            private String parent;
                            @Key
                            private Integer pageSize;
                            @Key
                            private String pageToken;

                            protected List(String parent) {
                                super(Translate.this, "GET", REST_PATH, null, ListAdaptiveMtSentencesResponse.class);
                                this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/adaptiveMtDatasets/[^/]+/adaptiveMtFiles/[^/]+$");
                                this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                                if (!Translate.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/adaptiveMtDatasets/[^/]+/adaptiveMtFiles/[^/]+$");
                                }
                            }

                            public HttpResponse executeUsingHead() throws IOException {
                                return super.executeUsingHead();
                            }

                            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                                return super.buildHttpRequestUsingHead();
                            }

                            public List set$Xgafv(String $Xgafv) {
                                return (List)super.set$Xgafv($Xgafv);
                            }

                            public List setAccessToken(String accessToken) {
                                return (List)super.setAccessToken(accessToken);
                            }

                            public List setAlt(String alt) {
                                return (List)super.setAlt(alt);
                            }

                            public List setCallback(String callback) {
                                return (List)super.setCallback(callback);
                            }

                            public List setFields(String fields) {
                                return (List)super.setFields(fields);
                            }

                            public List setKey(String key) {
                                return (List)super.setKey(key);
                            }

                            public List setOauthToken(String oauthToken) {
                                return (List)super.setOauthToken(oauthToken);
                            }

                            public List setPrettyPrint(Boolean prettyPrint) {
                                return (List)super.setPrettyPrint(prettyPrint);
                            }

                            public List setQuotaUser(String quotaUser) {
                                return (List)super.setQuotaUser(quotaUser);
                            }

                            public List setUploadType(String uploadType) {
                                return (List)super.setUploadType(uploadType);
                            }

                            public List setUploadProtocol(String uploadProtocol) {
                                return (List)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getParent() {
                                return this.parent;
                            }

                            public List setParent(String parent) {
                                if (!Translate.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/adaptiveMtDatasets/[^/]+/adaptiveMtFiles/[^/]+$");
                                }
                                this.parent = parent;
                                return this;
                            }

                            public Integer getPageSize() {
                                return this.pageSize;
                            }

                            public List setPageSize(Integer pageSize) {
                                this.pageSize = pageSize;
                                return this;
                            }

                            public String getPageToken() {
                                return this.pageToken;
                            }

                            public List setPageToken(String pageToken) {
                                this.pageToken = pageToken;
                                return this;
                            }

                            @Override
                            public List set(String parameterName, Object value) {
                                return (List)super.set(parameterName, value);
                            }
                        }
                    }

                    public class List
                    extends TranslateRequest<ListAdaptiveMtFilesResponse> {
                        private static final String REST_PATH = "v3/{+parent}/adaptiveMtFiles";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;
                        @Key
                        private Integer pageSize;
                        @Key
                        private String pageToken;

                        protected List(String parent) {
                            super(Translate.this, "GET", REST_PATH, null, ListAdaptiveMtFilesResponse.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/adaptiveMtDatasets/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                            if (!Translate.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/adaptiveMtDatasets/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public List set$Xgafv(String $Xgafv) {
                            return (List)super.set$Xgafv($Xgafv);
                        }

                        public List setAccessToken(String accessToken) {
                            return (List)super.setAccessToken(accessToken);
                        }

                        public List setAlt(String alt) {
                            return (List)super.setAlt(alt);
                        }

                        public List setCallback(String callback) {
                            return (List)super.setCallback(callback);
                        }

                        public List setFields(String fields) {
                            return (List)super.setFields(fields);
                        }

                        public List setKey(String key) {
                            return (List)super.setKey(key);
                        }

                        public List setOauthToken(String oauthToken) {
                            return (List)super.setOauthToken(oauthToken);
                        }

                        public List setPrettyPrint(Boolean prettyPrint) {
                            return (List)super.setPrettyPrint(prettyPrint);
                        }

                        public List setQuotaUser(String quotaUser) {
                            return (List)super.setQuotaUser(quotaUser);
                        }

                        public List setUploadType(String uploadType) {
                            return (List)super.setUploadType(uploadType);
                        }

                        public List setUploadProtocol(String uploadProtocol) {
                            return (List)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public List setParent(String parent) {
                            if (!Translate.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/adaptiveMtDatasets/[^/]+$");
                            }
                            this.parent = parent;
                            return this;
                        }

                        public Integer getPageSize() {
                            return this.pageSize;
                        }

                        public List setPageSize(Integer pageSize) {
                            this.pageSize = pageSize;
                            return this;
                        }

                        public String getPageToken() {
                            return this.pageToken;
                        }

                        public List setPageToken(String pageToken) {
                            this.pageToken = pageToken;
                            return this;
                        }

                        @Override
                        public List set(String parameterName, Object value) {
                            return (List)super.set(parameterName, value);
                        }
                    }

                    public class Get
                    extends TranslateRequest<AdaptiveMtFile> {
                        private static final String REST_PATH = "v3/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected Get(String name) {
                            super(Translate.this, "GET", REST_PATH, null, AdaptiveMtFile.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/adaptiveMtDatasets/[^/]+/adaptiveMtFiles/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!Translate.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/adaptiveMtDatasets/[^/]+/adaptiveMtFiles/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public Get set$Xgafv(String $Xgafv) {
                            return (Get)super.set$Xgafv($Xgafv);
                        }

                        public Get setAccessToken(String accessToken) {
                            return (Get)super.setAccessToken(accessToken);
                        }

                        public Get setAlt(String alt) {
                            return (Get)super.setAlt(alt);
                        }

                        public Get setCallback(String callback) {
                            return (Get)super.setCallback(callback);
                        }

                        public Get setFields(String fields) {
                            return (Get)super.setFields(fields);
                        }

                        public Get setKey(String key) {
                            return (Get)super.setKey(key);
                        }

                        public Get setOauthToken(String oauthToken) {
                            return (Get)super.setOauthToken(oauthToken);
                        }

                        public Get setPrettyPrint(Boolean prettyPrint) {
                            return (Get)super.setPrettyPrint(prettyPrint);
                        }

                        public Get setQuotaUser(String quotaUser) {
                            return (Get)super.setQuotaUser(quotaUser);
                        }

                        public Get setUploadType(String uploadType) {
                            return (Get)super.setUploadType(uploadType);
                        }

                        public Get setUploadProtocol(String uploadProtocol) {
                            return (Get)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Get setName(String name) {
                            if (!Translate.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/adaptiveMtDatasets/[^/]+/adaptiveMtFiles/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        @Override
                        public Get set(String parameterName, Object value) {
                            return (Get)super.set(parameterName, value);
                        }
                    }

                    public class Delete
                    extends TranslateRequest<Empty> {
                        private static final String REST_PATH = "v3/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected Delete(String name) {
                            super(Translate.this, "DELETE", REST_PATH, null, Empty.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/adaptiveMtDatasets/[^/]+/adaptiveMtFiles/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!Translate.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/adaptiveMtDatasets/[^/]+/adaptiveMtFiles/[^/]+$");
                            }
                        }

                        public Delete set$Xgafv(String $Xgafv) {
                            return (Delete)super.set$Xgafv($Xgafv);
                        }

                        public Delete setAccessToken(String accessToken) {
                            return (Delete)super.setAccessToken(accessToken);
                        }

                        public Delete setAlt(String alt) {
                            return (Delete)super.setAlt(alt);
                        }

                        public Delete setCallback(String callback) {
                            return (Delete)super.setCallback(callback);
                        }

                        public Delete setFields(String fields) {
                            return (Delete)super.setFields(fields);
                        }

                        public Delete setKey(String key) {
                            return (Delete)super.setKey(key);
                        }

                        public Delete setOauthToken(String oauthToken) {
                            return (Delete)super.setOauthToken(oauthToken);
                        }

                        public Delete setPrettyPrint(Boolean prettyPrint) {
                            return (Delete)super.setPrettyPrint(prettyPrint);
                        }

                        public Delete setQuotaUser(String quotaUser) {
                            return (Delete)super.setQuotaUser(quotaUser);
                        }

                        public Delete setUploadType(String uploadType) {
                            return (Delete)super.setUploadType(uploadType);
                        }

                        public Delete setUploadProtocol(String uploadProtocol) {
                            return (Delete)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Delete setName(String name) {
                            if (!Translate.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/adaptiveMtDatasets/[^/]+/adaptiveMtFiles/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        @Override
                        public Delete set(String parameterName, Object value) {
                            return (Delete)super.set(parameterName, value);
                        }
                    }
                }

                public class List
                extends TranslateRequest<ListAdaptiveMtDatasetsResponse> {
                    private static final String REST_PATH = "v3/{+parent}/adaptiveMtDatasets";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String filter;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected List(String parent) {
                        super(Translate.this, "GET", REST_PATH, null, ListAdaptiveMtDatasetsResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String parent) {
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public String getFilter() {
                        return this.filter;
                    }

                    public List setFilter(String filter) {
                        this.filter = filter;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class ImportAdaptiveMtFile
                extends TranslateRequest<ImportAdaptiveMtFileResponse> {
                    private static final String REST_PATH = "v3/{+parent}:importAdaptiveMtFile";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;

                    protected ImportAdaptiveMtFile(String parent, ImportAdaptiveMtFileRequest content) {
                        super(Translate.this, "POST", REST_PATH, (Object)content, ImportAdaptiveMtFileResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/adaptiveMtDatasets/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/adaptiveMtDatasets/[^/]+$");
                        }
                    }

                    public ImportAdaptiveMtFile set$Xgafv(String $Xgafv) {
                        return (ImportAdaptiveMtFile)super.set$Xgafv($Xgafv);
                    }

                    public ImportAdaptiveMtFile setAccessToken(String accessToken) {
                        return (ImportAdaptiveMtFile)super.setAccessToken(accessToken);
                    }

                    public ImportAdaptiveMtFile setAlt(String alt) {
                        return (ImportAdaptiveMtFile)super.setAlt(alt);
                    }

                    public ImportAdaptiveMtFile setCallback(String callback) {
                        return (ImportAdaptiveMtFile)super.setCallback(callback);
                    }

                    public ImportAdaptiveMtFile setFields(String fields) {
                        return (ImportAdaptiveMtFile)super.setFields(fields);
                    }

                    public ImportAdaptiveMtFile setKey(String key) {
                        return (ImportAdaptiveMtFile)super.setKey(key);
                    }

                    public ImportAdaptiveMtFile setOauthToken(String oauthToken) {
                        return (ImportAdaptiveMtFile)super.setOauthToken(oauthToken);
                    }

                    public ImportAdaptiveMtFile setPrettyPrint(Boolean prettyPrint) {
                        return (ImportAdaptiveMtFile)super.setPrettyPrint(prettyPrint);
                    }

                    public ImportAdaptiveMtFile setQuotaUser(String quotaUser) {
                        return (ImportAdaptiveMtFile)super.setQuotaUser(quotaUser);
                    }

                    public ImportAdaptiveMtFile setUploadType(String uploadType) {
                        return (ImportAdaptiveMtFile)super.setUploadType(uploadType);
                    }

                    public ImportAdaptiveMtFile setUploadProtocol(String uploadProtocol) {
                        return (ImportAdaptiveMtFile)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public ImportAdaptiveMtFile setParent(String parent) {
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/adaptiveMtDatasets/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    @Override
                    public ImportAdaptiveMtFile set(String parameterName, Object value) {
                        return (ImportAdaptiveMtFile)super.set(parameterName, value);
                    }
                }

                public class Get
                extends TranslateRequest<AdaptiveMtDataset> {
                    private static final String REST_PATH = "v3/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Get(String name) {
                        super(Translate.this, "GET", REST_PATH, null, AdaptiveMtDataset.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/adaptiveMtDatasets/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/adaptiveMtDatasets/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String name) {
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/adaptiveMtDatasets/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class Delete
                extends TranslateRequest<Empty> {
                    private static final String REST_PATH = "v3/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Delete(String name) {
                        super(Translate.this, "DELETE", REST_PATH, null, Empty.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/adaptiveMtDatasets/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/adaptiveMtDatasets/[^/]+$");
                        }
                    }

                    public Delete set$Xgafv(String $Xgafv) {
                        return (Delete)super.set$Xgafv($Xgafv);
                    }

                    public Delete setAccessToken(String accessToken) {
                        return (Delete)super.setAccessToken(accessToken);
                    }

                    public Delete setAlt(String alt) {
                        return (Delete)super.setAlt(alt);
                    }

                    public Delete setCallback(String callback) {
                        return (Delete)super.setCallback(callback);
                    }

                    public Delete setFields(String fields) {
                        return (Delete)super.setFields(fields);
                    }

                    public Delete setKey(String key) {
                        return (Delete)super.setKey(key);
                    }

                    public Delete setOauthToken(String oauthToken) {
                        return (Delete)super.setOauthToken(oauthToken);
                    }

                    public Delete setPrettyPrint(Boolean prettyPrint) {
                        return (Delete)super.setPrettyPrint(prettyPrint);
                    }

                    public Delete setQuotaUser(String quotaUser) {
                        return (Delete)super.setQuotaUser(quotaUser);
                    }

                    public Delete setUploadType(String uploadType) {
                        return (Delete)super.setUploadType(uploadType);
                    }

                    public Delete setUploadProtocol(String uploadProtocol) {
                        return (Delete)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Delete setName(String name) {
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/adaptiveMtDatasets/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Delete set(String parameterName, Object value) {
                        return (Delete)super.set(parameterName, value);
                    }
                }

                public class Create
                extends TranslateRequest<AdaptiveMtDataset> {
                    private static final String REST_PATH = "v3/{+parent}/adaptiveMtDatasets";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;

                    protected Create(String parent, AdaptiveMtDataset content) {
                        super(Translate.this, "POST", REST_PATH, (Object)content, AdaptiveMtDataset.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public Create set$Xgafv(String $Xgafv) {
                        return (Create)super.set$Xgafv($Xgafv);
                    }

                    public Create setAccessToken(String accessToken) {
                        return (Create)super.setAccessToken(accessToken);
                    }

                    public Create setAlt(String alt) {
                        return (Create)super.setAlt(alt);
                    }

                    public Create setCallback(String callback) {
                        return (Create)super.setCallback(callback);
                    }

                    public Create setFields(String fields) {
                        return (Create)super.setFields(fields);
                    }

                    public Create setKey(String key) {
                        return (Create)super.setKey(key);
                    }

                    public Create setOauthToken(String oauthToken) {
                        return (Create)super.setOauthToken(oauthToken);
                    }

                    public Create setPrettyPrint(Boolean prettyPrint) {
                        return (Create)super.setPrettyPrint(prettyPrint);
                    }

                    public Create setQuotaUser(String quotaUser) {
                        return (Create)super.setQuotaUser(quotaUser);
                    }

                    public Create setUploadType(String uploadType) {
                        return (Create)super.setUploadType(uploadType);
                    }

                    public Create setUploadProtocol(String uploadProtocol) {
                        return (Create)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public Create setParent(String parent) {
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    @Override
                    public Create set(String parameterName, Object value) {
                        return (Create)super.set(parameterName, value);
                    }
                }
            }

            public class TranslateText
            extends TranslateRequest<TranslateTextResponse> {
                private static final String REST_PATH = "v3/{+parent}:translateText";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected TranslateText(String parent, TranslateTextRequest content) {
                    super(Translate.this, "POST", REST_PATH, (Object)content, TranslateTextResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!Translate.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                    }
                }

                public TranslateText set$Xgafv(String $Xgafv) {
                    return (TranslateText)super.set$Xgafv($Xgafv);
                }

                public TranslateText setAccessToken(String accessToken) {
                    return (TranslateText)super.setAccessToken(accessToken);
                }

                public TranslateText setAlt(String alt) {
                    return (TranslateText)super.setAlt(alt);
                }

                public TranslateText setCallback(String callback) {
                    return (TranslateText)super.setCallback(callback);
                }

                public TranslateText setFields(String fields) {
                    return (TranslateText)super.setFields(fields);
                }

                public TranslateText setKey(String key) {
                    return (TranslateText)super.setKey(key);
                }

                public TranslateText setOauthToken(String oauthToken) {
                    return (TranslateText)super.setOauthToken(oauthToken);
                }

                public TranslateText setPrettyPrint(Boolean prettyPrint) {
                    return (TranslateText)super.setPrettyPrint(prettyPrint);
                }

                public TranslateText setQuotaUser(String quotaUser) {
                    return (TranslateText)super.setQuotaUser(quotaUser);
                }

                public TranslateText setUploadType(String uploadType) {
                    return (TranslateText)super.setUploadType(uploadType);
                }

                public TranslateText setUploadProtocol(String uploadProtocol) {
                    return (TranslateText)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public TranslateText setParent(String parent) {
                    if (!Translate.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                @Override
                public TranslateText set(String parameterName, Object value) {
                    return (TranslateText)super.set(parameterName, value);
                }
            }

            public class TranslateDocument
            extends TranslateRequest<TranslateDocumentResponse> {
                private static final String REST_PATH = "v3/{+parent}:translateDocument";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected TranslateDocument(String parent, TranslateDocumentRequest content) {
                    super(Translate.this, "POST", REST_PATH, (Object)content, TranslateDocumentResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!Translate.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                    }
                }

                public TranslateDocument set$Xgafv(String $Xgafv) {
                    return (TranslateDocument)super.set$Xgafv($Xgafv);
                }

                public TranslateDocument setAccessToken(String accessToken) {
                    return (TranslateDocument)super.setAccessToken(accessToken);
                }

                public TranslateDocument setAlt(String alt) {
                    return (TranslateDocument)super.setAlt(alt);
                }

                public TranslateDocument setCallback(String callback) {
                    return (TranslateDocument)super.setCallback(callback);
                }

                public TranslateDocument setFields(String fields) {
                    return (TranslateDocument)super.setFields(fields);
                }

                public TranslateDocument setKey(String key) {
                    return (TranslateDocument)super.setKey(key);
                }

                public TranslateDocument setOauthToken(String oauthToken) {
                    return (TranslateDocument)super.setOauthToken(oauthToken);
                }

                public TranslateDocument setPrettyPrint(Boolean prettyPrint) {
                    return (TranslateDocument)super.setPrettyPrint(prettyPrint);
                }

                public TranslateDocument setQuotaUser(String quotaUser) {
                    return (TranslateDocument)super.setQuotaUser(quotaUser);
                }

                public TranslateDocument setUploadType(String uploadType) {
                    return (TranslateDocument)super.setUploadType(uploadType);
                }

                public TranslateDocument setUploadProtocol(String uploadProtocol) {
                    return (TranslateDocument)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public TranslateDocument setParent(String parent) {
                    if (!Translate.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                @Override
                public TranslateDocument set(String parameterName, Object value) {
                    return (TranslateDocument)super.set(parameterName, value);
                }
            }

            public class RomanizeText
            extends TranslateRequest<RomanizeTextResponse> {
                private static final String REST_PATH = "v3/{+parent}:romanizeText";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected RomanizeText(String parent, RomanizeTextRequest content) {
                    super(Translate.this, "POST", REST_PATH, (Object)content, RomanizeTextResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!Translate.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                    }
                }

                public RomanizeText set$Xgafv(String $Xgafv) {
                    return (RomanizeText)super.set$Xgafv($Xgafv);
                }

                public RomanizeText setAccessToken(String accessToken) {
                    return (RomanizeText)super.setAccessToken(accessToken);
                }

                public RomanizeText setAlt(String alt) {
                    return (RomanizeText)super.setAlt(alt);
                }

                public RomanizeText setCallback(String callback) {
                    return (RomanizeText)super.setCallback(callback);
                }

                public RomanizeText setFields(String fields) {
                    return (RomanizeText)super.setFields(fields);
                }

                public RomanizeText setKey(String key) {
                    return (RomanizeText)super.setKey(key);
                }

                public RomanizeText setOauthToken(String oauthToken) {
                    return (RomanizeText)super.setOauthToken(oauthToken);
                }

                public RomanizeText setPrettyPrint(Boolean prettyPrint) {
                    return (RomanizeText)super.setPrettyPrint(prettyPrint);
                }

                public RomanizeText setQuotaUser(String quotaUser) {
                    return (RomanizeText)super.setQuotaUser(quotaUser);
                }

                public RomanizeText setUploadType(String uploadType) {
                    return (RomanizeText)super.setUploadType(uploadType);
                }

                public RomanizeText setUploadProtocol(String uploadProtocol) {
                    return (RomanizeText)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public RomanizeText setParent(String parent) {
                    if (!Translate.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                @Override
                public RomanizeText set(String parameterName, Object value) {
                    return (RomanizeText)super.set(parameterName, value);
                }
            }

            public class List
            extends TranslateRequest<ListLocationsResponse> {
                private static final String REST_PATH = "v3/{+name}/locations";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String filter;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String name) {
                    super(Translate.this, "GET", REST_PATH, null, ListLocationsResponse.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Translate.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public List setName(String name) {
                    if (!Translate.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String filter) {
                    this.filter = filter;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class GetSupportedLanguages
            extends TranslateRequest<SupportedLanguages> {
                private static final String REST_PATH = "v3/{+parent}/supportedLanguages";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private String displayLanguageCode;
                @Key
                private String model;

                protected GetSupportedLanguages(String parent) {
                    super(Translate.this, "GET", REST_PATH, null, SupportedLanguages.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!Translate.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public GetSupportedLanguages set$Xgafv(String $Xgafv) {
                    return (GetSupportedLanguages)super.set$Xgafv($Xgafv);
                }

                public GetSupportedLanguages setAccessToken(String accessToken) {
                    return (GetSupportedLanguages)super.setAccessToken(accessToken);
                }

                public GetSupportedLanguages setAlt(String alt) {
                    return (GetSupportedLanguages)super.setAlt(alt);
                }

                public GetSupportedLanguages setCallback(String callback) {
                    return (GetSupportedLanguages)super.setCallback(callback);
                }

                public GetSupportedLanguages setFields(String fields) {
                    return (GetSupportedLanguages)super.setFields(fields);
                }

                public GetSupportedLanguages setKey(String key) {
                    return (GetSupportedLanguages)super.setKey(key);
                }

                public GetSupportedLanguages setOauthToken(String oauthToken) {
                    return (GetSupportedLanguages)super.setOauthToken(oauthToken);
                }

                public GetSupportedLanguages setPrettyPrint(Boolean prettyPrint) {
                    return (GetSupportedLanguages)super.setPrettyPrint(prettyPrint);
                }

                public GetSupportedLanguages setQuotaUser(String quotaUser) {
                    return (GetSupportedLanguages)super.setQuotaUser(quotaUser);
                }

                public GetSupportedLanguages setUploadType(String uploadType) {
                    return (GetSupportedLanguages)super.setUploadType(uploadType);
                }

                public GetSupportedLanguages setUploadProtocol(String uploadProtocol) {
                    return (GetSupportedLanguages)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public GetSupportedLanguages setParent(String parent) {
                    if (!Translate.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public String getDisplayLanguageCode() {
                    return this.displayLanguageCode;
                }

                public GetSupportedLanguages setDisplayLanguageCode(String displayLanguageCode) {
                    this.displayLanguageCode = displayLanguageCode;
                    return this;
                }

                public String getModel() {
                    return this.model;
                }

                public GetSupportedLanguages setModel(String model) {
                    this.model = model;
                    return this;
                }

                @Override
                public GetSupportedLanguages set(String parameterName, Object value) {
                    return (GetSupportedLanguages)super.set(parameterName, value);
                }
            }

            public class Get
            extends TranslateRequest<Location> {
                private static final String REST_PATH = "v3/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String name) {
                    super(Translate.this, "GET", REST_PATH, null, Location.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Translate.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String name) {
                    if (!Translate.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class DetectLanguage
            extends TranslateRequest<DetectLanguageResponse> {
                private static final String REST_PATH = "v3/{+parent}:detectLanguage";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected DetectLanguage(String parent, DetectLanguageRequest content) {
                    super(Translate.this, "POST", REST_PATH, (Object)content, DetectLanguageResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!Translate.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                    }
                }

                public DetectLanguage set$Xgafv(String $Xgafv) {
                    return (DetectLanguage)super.set$Xgafv($Xgafv);
                }

                public DetectLanguage setAccessToken(String accessToken) {
                    return (DetectLanguage)super.setAccessToken(accessToken);
                }

                public DetectLanguage setAlt(String alt) {
                    return (DetectLanguage)super.setAlt(alt);
                }

                public DetectLanguage setCallback(String callback) {
                    return (DetectLanguage)super.setCallback(callback);
                }

                public DetectLanguage setFields(String fields) {
                    return (DetectLanguage)super.setFields(fields);
                }

                public DetectLanguage setKey(String key) {
                    return (DetectLanguage)super.setKey(key);
                }

                public DetectLanguage setOauthToken(String oauthToken) {
                    return (DetectLanguage)super.setOauthToken(oauthToken);
                }

                public DetectLanguage setPrettyPrint(Boolean prettyPrint) {
                    return (DetectLanguage)super.setPrettyPrint(prettyPrint);
                }

                public DetectLanguage setQuotaUser(String quotaUser) {
                    return (DetectLanguage)super.setQuotaUser(quotaUser);
                }

                public DetectLanguage setUploadType(String uploadType) {
                    return (DetectLanguage)super.setUploadType(uploadType);
                }

                public DetectLanguage setUploadProtocol(String uploadProtocol) {
                    return (DetectLanguage)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public DetectLanguage setParent(String parent) {
                    if (!Translate.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                @Override
                public DetectLanguage set(String parameterName, Object value) {
                    return (DetectLanguage)super.set(parameterName, value);
                }
            }

            public class BatchTranslateText
            extends TranslateRequest<Operation> {
                private static final String REST_PATH = "v3/{+parent}:batchTranslateText";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected BatchTranslateText(String parent, BatchTranslateTextRequest content) {
                    super(Translate.this, "POST", REST_PATH, (Object)content, Operation.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!Translate.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                    }
                }

                public BatchTranslateText set$Xgafv(String $Xgafv) {
                    return (BatchTranslateText)super.set$Xgafv($Xgafv);
                }

                public BatchTranslateText setAccessToken(String accessToken) {
                    return (BatchTranslateText)super.setAccessToken(accessToken);
                }

                public BatchTranslateText setAlt(String alt) {
                    return (BatchTranslateText)super.setAlt(alt);
                }

                public BatchTranslateText setCallback(String callback) {
                    return (BatchTranslateText)super.setCallback(callback);
                }

                public BatchTranslateText setFields(String fields) {
                    return (BatchTranslateText)super.setFields(fields);
                }

                public BatchTranslateText setKey(String key) {
                    return (BatchTranslateText)super.setKey(key);
                }

                public BatchTranslateText setOauthToken(String oauthToken) {
                    return (BatchTranslateText)super.setOauthToken(oauthToken);
                }

                public BatchTranslateText setPrettyPrint(Boolean prettyPrint) {
                    return (BatchTranslateText)super.setPrettyPrint(prettyPrint);
                }

                public BatchTranslateText setQuotaUser(String quotaUser) {
                    return (BatchTranslateText)super.setQuotaUser(quotaUser);
                }

                public BatchTranslateText setUploadType(String uploadType) {
                    return (BatchTranslateText)super.setUploadType(uploadType);
                }

                public BatchTranslateText setUploadProtocol(String uploadProtocol) {
                    return (BatchTranslateText)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public BatchTranslateText setParent(String parent) {
                    if (!Translate.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                @Override
                public BatchTranslateText set(String parameterName, Object value) {
                    return (BatchTranslateText)super.set(parameterName, value);
                }
            }

            public class BatchTranslateDocument
            extends TranslateRequest<Operation> {
                private static final String REST_PATH = "v3/{+parent}:batchTranslateDocument";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected BatchTranslateDocument(String parent, BatchTranslateDocumentRequest content) {
                    super(Translate.this, "POST", REST_PATH, (Object)content, Operation.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!Translate.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                    }
                }

                public BatchTranslateDocument set$Xgafv(String $Xgafv) {
                    return (BatchTranslateDocument)super.set$Xgafv($Xgafv);
                }

                public BatchTranslateDocument setAccessToken(String accessToken) {
                    return (BatchTranslateDocument)super.setAccessToken(accessToken);
                }

                public BatchTranslateDocument setAlt(String alt) {
                    return (BatchTranslateDocument)super.setAlt(alt);
                }

                public BatchTranslateDocument setCallback(String callback) {
                    return (BatchTranslateDocument)super.setCallback(callback);
                }

                public BatchTranslateDocument setFields(String fields) {
                    return (BatchTranslateDocument)super.setFields(fields);
                }

                public BatchTranslateDocument setKey(String key) {
                    return (BatchTranslateDocument)super.setKey(key);
                }

                public BatchTranslateDocument setOauthToken(String oauthToken) {
                    return (BatchTranslateDocument)super.setOauthToken(oauthToken);
                }

                public BatchTranslateDocument setPrettyPrint(Boolean prettyPrint) {
                    return (BatchTranslateDocument)super.setPrettyPrint(prettyPrint);
                }

                public BatchTranslateDocument setQuotaUser(String quotaUser) {
                    return (BatchTranslateDocument)super.setQuotaUser(quotaUser);
                }

                public BatchTranslateDocument setUploadType(String uploadType) {
                    return (BatchTranslateDocument)super.setUploadType(uploadType);
                }

                public BatchTranslateDocument setUploadProtocol(String uploadProtocol) {
                    return (BatchTranslateDocument)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public BatchTranslateDocument setParent(String parent) {
                    if (!Translate.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                @Override
                public BatchTranslateDocument set(String parameterName, Object value) {
                    return (BatchTranslateDocument)super.set(parameterName, value);
                }
            }

            public class AdaptiveMtTranslate
            extends TranslateRequest<AdaptiveMtTranslateResponse> {
                private static final String REST_PATH = "v3/{+parent}:adaptiveMtTranslate";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected AdaptiveMtTranslate(String parent, AdaptiveMtTranslateRequest content) {
                    super(Translate.this, "POST", REST_PATH, (Object)content, AdaptiveMtTranslateResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!Translate.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                    }
                }

                public AdaptiveMtTranslate set$Xgafv(String $Xgafv) {
                    return (AdaptiveMtTranslate)super.set$Xgafv($Xgafv);
                }

                public AdaptiveMtTranslate setAccessToken(String accessToken) {
                    return (AdaptiveMtTranslate)super.setAccessToken(accessToken);
                }

                public AdaptiveMtTranslate setAlt(String alt) {
                    return (AdaptiveMtTranslate)super.setAlt(alt);
                }

                public AdaptiveMtTranslate setCallback(String callback) {
                    return (AdaptiveMtTranslate)super.setCallback(callback);
                }

                public AdaptiveMtTranslate setFields(String fields) {
                    return (AdaptiveMtTranslate)super.setFields(fields);
                }

                public AdaptiveMtTranslate setKey(String key) {
                    return (AdaptiveMtTranslate)super.setKey(key);
                }

                public AdaptiveMtTranslate setOauthToken(String oauthToken) {
                    return (AdaptiveMtTranslate)super.setOauthToken(oauthToken);
                }

                public AdaptiveMtTranslate setPrettyPrint(Boolean prettyPrint) {
                    return (AdaptiveMtTranslate)super.setPrettyPrint(prettyPrint);
                }

                public AdaptiveMtTranslate setQuotaUser(String quotaUser) {
                    return (AdaptiveMtTranslate)super.setQuotaUser(quotaUser);
                }

                public AdaptiveMtTranslate setUploadType(String uploadType) {
                    return (AdaptiveMtTranslate)super.setUploadType(uploadType);
                }

                public AdaptiveMtTranslate setUploadProtocol(String uploadProtocol) {
                    return (AdaptiveMtTranslate)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public AdaptiveMtTranslate setParent(String parent) {
                    if (!Translate.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                @Override
                public AdaptiveMtTranslate set(String parameterName, Object value) {
                    return (AdaptiveMtTranslate)super.set(parameterName, value);
                }
            }
        }

        public class TranslateText
        extends TranslateRequest<TranslateTextResponse> {
            private static final String REST_PATH = "v3/{+parent}:translateText";
            private final Pattern PARENT_PATTERN;
            @Key
            private String parent;

            protected TranslateText(String parent, TranslateTextRequest content) {
                super(Translate.this, "POST", REST_PATH, (Object)content, TranslateTextResponse.class);
                this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                if (!Translate.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                }
            }

            public TranslateText set$Xgafv(String $Xgafv) {
                return (TranslateText)super.set$Xgafv($Xgafv);
            }

            public TranslateText setAccessToken(String accessToken) {
                return (TranslateText)super.setAccessToken(accessToken);
            }

            public TranslateText setAlt(String alt) {
                return (TranslateText)super.setAlt(alt);
            }

            public TranslateText setCallback(String callback) {
                return (TranslateText)super.setCallback(callback);
            }

            public TranslateText setFields(String fields) {
                return (TranslateText)super.setFields(fields);
            }

            public TranslateText setKey(String key) {
                return (TranslateText)super.setKey(key);
            }

            public TranslateText setOauthToken(String oauthToken) {
                return (TranslateText)super.setOauthToken(oauthToken);
            }

            public TranslateText setPrettyPrint(Boolean prettyPrint) {
                return (TranslateText)super.setPrettyPrint(prettyPrint);
            }

            public TranslateText setQuotaUser(String quotaUser) {
                return (TranslateText)super.setQuotaUser(quotaUser);
            }

            public TranslateText setUploadType(String uploadType) {
                return (TranslateText)super.setUploadType(uploadType);
            }

            public TranslateText setUploadProtocol(String uploadProtocol) {
                return (TranslateText)super.setUploadProtocol(uploadProtocol);
            }

            public String getParent() {
                return this.parent;
            }

            public TranslateText setParent(String parent) {
                if (!Translate.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                }
                this.parent = parent;
                return this;
            }

            @Override
            public TranslateText set(String parameterName, Object value) {
                return (TranslateText)super.set(parameterName, value);
            }
        }

        public class RomanizeText
        extends TranslateRequest<RomanizeTextResponse> {
            private static final String REST_PATH = "v3/{+parent}:romanizeText";
            private final Pattern PARENT_PATTERN;
            @Key
            private String parent;

            protected RomanizeText(String parent, RomanizeTextRequest content) {
                super(Translate.this, "POST", REST_PATH, (Object)content, RomanizeTextResponse.class);
                this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                if (!Translate.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                }
            }

            public RomanizeText set$Xgafv(String $Xgafv) {
                return (RomanizeText)super.set$Xgafv($Xgafv);
            }

            public RomanizeText setAccessToken(String accessToken) {
                return (RomanizeText)super.setAccessToken(accessToken);
            }

            public RomanizeText setAlt(String alt) {
                return (RomanizeText)super.setAlt(alt);
            }

            public RomanizeText setCallback(String callback) {
                return (RomanizeText)super.setCallback(callback);
            }

            public RomanizeText setFields(String fields) {
                return (RomanizeText)super.setFields(fields);
            }

            public RomanizeText setKey(String key) {
                return (RomanizeText)super.setKey(key);
            }

            public RomanizeText setOauthToken(String oauthToken) {
                return (RomanizeText)super.setOauthToken(oauthToken);
            }

            public RomanizeText setPrettyPrint(Boolean prettyPrint) {
                return (RomanizeText)super.setPrettyPrint(prettyPrint);
            }

            public RomanizeText setQuotaUser(String quotaUser) {
                return (RomanizeText)super.setQuotaUser(quotaUser);
            }

            public RomanizeText setUploadType(String uploadType) {
                return (RomanizeText)super.setUploadType(uploadType);
            }

            public RomanizeText setUploadProtocol(String uploadProtocol) {
                return (RomanizeText)super.setUploadProtocol(uploadProtocol);
            }

            public String getParent() {
                return this.parent;
            }

            public RomanizeText setParent(String parent) {
                if (!Translate.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                }
                this.parent = parent;
                return this;
            }

            @Override
            public RomanizeText set(String parameterName, Object value) {
                return (RomanizeText)super.set(parameterName, value);
            }
        }

        public class GetSupportedLanguages
        extends TranslateRequest<SupportedLanguages> {
            private static final String REST_PATH = "v3/{+parent}/supportedLanguages";
            private final Pattern PARENT_PATTERN;
            @Key
            private String parent;
            @Key
            private String displayLanguageCode;
            @Key
            private String model;

            protected GetSupportedLanguages(String parent) {
                super(Translate.this, "GET", REST_PATH, null, SupportedLanguages.class);
                this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                if (!Translate.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetSupportedLanguages set$Xgafv(String $Xgafv) {
                return (GetSupportedLanguages)super.set$Xgafv($Xgafv);
            }

            public GetSupportedLanguages setAccessToken(String accessToken) {
                return (GetSupportedLanguages)super.setAccessToken(accessToken);
            }

            public GetSupportedLanguages setAlt(String alt) {
                return (GetSupportedLanguages)super.setAlt(alt);
            }

            public GetSupportedLanguages setCallback(String callback) {
                return (GetSupportedLanguages)super.setCallback(callback);
            }

            public GetSupportedLanguages setFields(String fields) {
                return (GetSupportedLanguages)super.setFields(fields);
            }

            public GetSupportedLanguages setKey(String key) {
                return (GetSupportedLanguages)super.setKey(key);
            }

            public GetSupportedLanguages setOauthToken(String oauthToken) {
                return (GetSupportedLanguages)super.setOauthToken(oauthToken);
            }

            public GetSupportedLanguages setPrettyPrint(Boolean prettyPrint) {
                return (GetSupportedLanguages)super.setPrettyPrint(prettyPrint);
            }

            public GetSupportedLanguages setQuotaUser(String quotaUser) {
                return (GetSupportedLanguages)super.setQuotaUser(quotaUser);
            }

            public GetSupportedLanguages setUploadType(String uploadType) {
                return (GetSupportedLanguages)super.setUploadType(uploadType);
            }

            public GetSupportedLanguages setUploadProtocol(String uploadProtocol) {
                return (GetSupportedLanguages)super.setUploadProtocol(uploadProtocol);
            }

            public String getParent() {
                return this.parent;
            }

            public GetSupportedLanguages setParent(String parent) {
                if (!Translate.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                }
                this.parent = parent;
                return this;
            }

            public String getDisplayLanguageCode() {
                return this.displayLanguageCode;
            }

            public GetSupportedLanguages setDisplayLanguageCode(String displayLanguageCode) {
                this.displayLanguageCode = displayLanguageCode;
                return this;
            }

            public String getModel() {
                return this.model;
            }

            public GetSupportedLanguages setModel(String model) {
                this.model = model;
                return this;
            }

            @Override
            public GetSupportedLanguages set(String parameterName, Object value) {
                return (GetSupportedLanguages)super.set(parameterName, value);
            }
        }

        public class DetectLanguage
        extends TranslateRequest<DetectLanguageResponse> {
            private static final String REST_PATH = "v3/{+parent}:detectLanguage";
            private final Pattern PARENT_PATTERN;
            @Key
            private String parent;

            protected DetectLanguage(String parent, DetectLanguageRequest content) {
                super(Translate.this, "POST", REST_PATH, (Object)content, DetectLanguageResponse.class);
                this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                if (!Translate.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                }
            }

            public DetectLanguage set$Xgafv(String $Xgafv) {
                return (DetectLanguage)super.set$Xgafv($Xgafv);
            }

            public DetectLanguage setAccessToken(String accessToken) {
                return (DetectLanguage)super.setAccessToken(accessToken);
            }

            public DetectLanguage setAlt(String alt) {
                return (DetectLanguage)super.setAlt(alt);
            }

            public DetectLanguage setCallback(String callback) {
                return (DetectLanguage)super.setCallback(callback);
            }

            public DetectLanguage setFields(String fields) {
                return (DetectLanguage)super.setFields(fields);
            }

            public DetectLanguage setKey(String key) {
                return (DetectLanguage)super.setKey(key);
            }

            public DetectLanguage setOauthToken(String oauthToken) {
                return (DetectLanguage)super.setOauthToken(oauthToken);
            }

            public DetectLanguage setPrettyPrint(Boolean prettyPrint) {
                return (DetectLanguage)super.setPrettyPrint(prettyPrint);
            }

            public DetectLanguage setQuotaUser(String quotaUser) {
                return (DetectLanguage)super.setQuotaUser(quotaUser);
            }

            public DetectLanguage setUploadType(String uploadType) {
                return (DetectLanguage)super.setUploadType(uploadType);
            }

            public DetectLanguage setUploadProtocol(String uploadProtocol) {
                return (DetectLanguage)super.setUploadProtocol(uploadProtocol);
            }

            public String getParent() {
                return this.parent;
            }

            public DetectLanguage setParent(String parent) {
                if (!Translate.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                }
                this.parent = parent;
                return this;
            }

            @Override
            public DetectLanguage set(String parameterName, Object value) {
                return (DetectLanguage)super.set(parameterName, value);
            }
        }
    }
}

