/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.vault.v1;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.vault.v1.VaultRequest;
import com.google.api.services.vault.v1.VaultRequestInitializer;
import com.google.api.services.vault.v1.model.AddHeldAccountsRequest;
import com.google.api.services.vault.v1.model.AddHeldAccountsResponse;
import com.google.api.services.vault.v1.model.AddMatterPermissionsRequest;
import com.google.api.services.vault.v1.model.CancelOperationRequest;
import com.google.api.services.vault.v1.model.CloseMatterRequest;
import com.google.api.services.vault.v1.model.CloseMatterResponse;
import com.google.api.services.vault.v1.model.CountArtifactsRequest;
import com.google.api.services.vault.v1.model.Empty;
import com.google.api.services.vault.v1.model.Export;
import com.google.api.services.vault.v1.model.HeldAccount;
import com.google.api.services.vault.v1.model.Hold;
import com.google.api.services.vault.v1.model.ListExportsResponse;
import com.google.api.services.vault.v1.model.ListHeldAccountsResponse;
import com.google.api.services.vault.v1.model.ListHoldsResponse;
import com.google.api.services.vault.v1.model.ListMattersResponse;
import com.google.api.services.vault.v1.model.ListOperationsResponse;
import com.google.api.services.vault.v1.model.ListSavedQueriesResponse;
import com.google.api.services.vault.v1.model.Matter;
import com.google.api.services.vault.v1.model.MatterPermission;
import com.google.api.services.vault.v1.model.Operation;
import com.google.api.services.vault.v1.model.RemoveHeldAccountsRequest;
import com.google.api.services.vault.v1.model.RemoveHeldAccountsResponse;
import com.google.api.services.vault.v1.model.RemoveMatterPermissionsRequest;
import com.google.api.services.vault.v1.model.ReopenMatterRequest;
import com.google.api.services.vault.v1.model.ReopenMatterResponse;
import com.google.api.services.vault.v1.model.SavedQuery;
import com.google.api.services.vault.v1.model.UndeleteMatterRequest;
import java.io.IOException;
import java.util.regex.Pattern;

public class Vault
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://vault.googleapis.com/";
    public static final String DEFAULT_MTLS_ROOT_URL = "https://vault.mtls.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://vault.googleapis.com/";

    public Vault(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    Vault(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Matters matters() {
        return new Matters();
    }

    public Operations operations() {
        return new Operations();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && (GoogleUtils.MINOR_VERSION >= 32 || GoogleUtils.MINOR_VERSION == 31 && GoogleUtils.BUGFIX_VERSION >= 1) || GoogleUtils.MAJOR_VERSION >= 2 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.31.1 of google-api-client to run version 2.0.0 of the Google Vault API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        private static String chooseEndpoint(HttpTransport transport) {
            String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
            String string = useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
            if ("always".equals(useMtlsEndpoint) || "auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls()) {
                return Vault.DEFAULT_MTLS_ROOT_URL;
            }
            return "https://vault.googleapis.com/";
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Builder.chooseEndpoint(transport), Vault.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Vault.DEFAULT_BATCH_PATH);
        }

        public Vault build() {
            return new Vault(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setVaultRequestInitializer(VaultRequestInitializer vaultRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)vaultRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Operations {
        public Cancel cancel(String name, CancelOperationRequest content) throws IOException {
            Cancel result = new Cancel(name, content);
            Vault.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(String name) throws IOException {
            Delete result = new Delete(name);
            Vault.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String name) throws IOException {
            Get result = new Get(name);
            Vault.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String name) throws IOException {
            List result = new List(name);
            Vault.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends VaultRequest<ListOperationsResponse> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;
            @Key
            private String filter;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;

            protected List(String name) {
                super(Vault.this, "GET", REST_PATH, null, ListOperationsResponse.class);
                this.NAME_PATTERN = Pattern.compile("^operations$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!Vault.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^operations$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public List setName(String name) {
                if (!Vault.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^operations$");
                }
                this.name = name;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends VaultRequest<Operation> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Get(String name) {
                super(Vault.this, "GET", REST_PATH, null, Operation.class);
                this.NAME_PATTERN = Pattern.compile("^operations/.*$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!Vault.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^operations/.*$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Get setName(String name) {
                if (!Vault.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^operations/.*$");
                }
                this.name = name;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends VaultRequest<Empty> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Delete(String name) {
                super(Vault.this, "DELETE", REST_PATH, null, Empty.class);
                this.NAME_PATTERN = Pattern.compile("^operations/.*$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!Vault.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^operations/.*$");
                }
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Delete setName(String name) {
                if (!Vault.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^operations/.*$");
                }
                this.name = name;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Cancel
        extends VaultRequest<Empty> {
            private static final String REST_PATH = "v1/{+name}:cancel";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Cancel(String name, CancelOperationRequest content) {
                super(Vault.this, "POST", REST_PATH, (Object)content, Empty.class);
                this.NAME_PATTERN = Pattern.compile("^operations/.*$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!Vault.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^operations/.*$");
                }
            }

            public Cancel set$Xgafv(String $Xgafv) {
                return (Cancel)super.set$Xgafv($Xgafv);
            }

            public Cancel setAccessToken(String accessToken) {
                return (Cancel)super.setAccessToken(accessToken);
            }

            public Cancel setAlt(String alt) {
                return (Cancel)super.setAlt(alt);
            }

            public Cancel setCallback(String callback) {
                return (Cancel)super.setCallback(callback);
            }

            public Cancel setFields(String fields) {
                return (Cancel)super.setFields(fields);
            }

            public Cancel setKey(String key) {
                return (Cancel)super.setKey(key);
            }

            public Cancel setOauthToken(String oauthToken) {
                return (Cancel)super.setOauthToken(oauthToken);
            }

            public Cancel setPrettyPrint(Boolean prettyPrint) {
                return (Cancel)super.setPrettyPrint(prettyPrint);
            }

            public Cancel setQuotaUser(String quotaUser) {
                return (Cancel)super.setQuotaUser(quotaUser);
            }

            public Cancel setUploadType(String uploadType) {
                return (Cancel)super.setUploadType(uploadType);
            }

            public Cancel setUploadProtocol(String uploadProtocol) {
                return (Cancel)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Cancel setName(String name) {
                if (!Vault.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^operations/.*$");
                }
                this.name = name;
                return this;
            }

            @Override
            public Cancel set(String parameterName, Object value) {
                return (Cancel)super.set(parameterName, value);
            }
        }
    }

    public class Matters {
        public AddPermissions addPermissions(String matterId, AddMatterPermissionsRequest content) throws IOException {
            AddPermissions result = new AddPermissions(matterId, content);
            Vault.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Close close(String matterId, CloseMatterRequest content) throws IOException {
            Close result = new Close(matterId, content);
            Vault.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Count count(String matterId, CountArtifactsRequest content) throws IOException {
            Count result = new Count(matterId, content);
            Vault.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Create create(Matter content) throws IOException {
            Create result = new Create(content);
            Vault.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(String matterId) throws IOException {
            Delete result = new Delete(matterId);
            Vault.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String matterId) throws IOException {
            Get result = new Get(matterId);
            Vault.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            Vault.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public RemovePermissions removePermissions(String matterId, RemoveMatterPermissionsRequest content) throws IOException {
            RemovePermissions result = new RemovePermissions(matterId, content);
            Vault.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Reopen reopen(String matterId, ReopenMatterRequest content) throws IOException {
            Reopen result = new Reopen(matterId, content);
            Vault.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Undelete undelete(String matterId, UndeleteMatterRequest content) throws IOException {
            Undelete result = new Undelete(matterId, content);
            Vault.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(String matterId, Matter content) throws IOException {
            Update result = new Update(matterId, content);
            Vault.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Exports exports() {
            return new Exports();
        }

        public Holds holds() {
            return new Holds();
        }

        public SavedQueries savedQueries() {
            return new SavedQueries();
        }

        public class SavedQueries {
            public Create create(String matterId, SavedQuery content) throws IOException {
                Create result = new Create(matterId, content);
                Vault.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delete delete(String matterId, String savedQueryId) throws IOException {
                Delete result = new Delete(matterId, savedQueryId);
                Vault.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String matterId, String savedQueryId) throws IOException {
                Get result = new Get(matterId, savedQueryId);
                Vault.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String matterId) throws IOException {
                List result = new List(matterId);
                Vault.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class List
            extends VaultRequest<ListSavedQueriesResponse> {
                private static final String REST_PATH = "v1/matters/{matterId}/savedQueries";
                @Key
                private String matterId;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String matterId) {
                    super(Vault.this, "GET", REST_PATH, null, ListSavedQueriesResponse.class);
                    this.matterId = (String)Preconditions.checkNotNull((Object)matterId, (Object)"Required parameter matterId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getMatterId() {
                    return this.matterId;
                }

                public List setMatterId(String matterId) {
                    this.matterId = matterId;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends VaultRequest<SavedQuery> {
                private static final String REST_PATH = "v1/matters/{matterId}/savedQueries/{savedQueryId}";
                @Key
                private String matterId;
                @Key
                private String savedQueryId;

                protected Get(String matterId, String savedQueryId) {
                    super(Vault.this, "GET", REST_PATH, null, SavedQuery.class);
                    this.matterId = (String)Preconditions.checkNotNull((Object)matterId, (Object)"Required parameter matterId must be specified.");
                    this.savedQueryId = (String)Preconditions.checkNotNull((Object)savedQueryId, (Object)"Required parameter savedQueryId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getMatterId() {
                    return this.matterId;
                }

                public Get setMatterId(String matterId) {
                    this.matterId = matterId;
                    return this;
                }

                public String getSavedQueryId() {
                    return this.savedQueryId;
                }

                public Get setSavedQueryId(String savedQueryId) {
                    this.savedQueryId = savedQueryId;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends VaultRequest<Empty> {
                private static final String REST_PATH = "v1/matters/{matterId}/savedQueries/{savedQueryId}";
                @Key
                private String matterId;
                @Key
                private String savedQueryId;

                protected Delete(String matterId, String savedQueryId) {
                    super(Vault.this, "DELETE", REST_PATH, null, Empty.class);
                    this.matterId = (String)Preconditions.checkNotNull((Object)matterId, (Object)"Required parameter matterId must be specified.");
                    this.savedQueryId = (String)Preconditions.checkNotNull((Object)savedQueryId, (Object)"Required parameter savedQueryId must be specified.");
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public String getMatterId() {
                    return this.matterId;
                }

                public Delete setMatterId(String matterId) {
                    this.matterId = matterId;
                    return this;
                }

                public String getSavedQueryId() {
                    return this.savedQueryId;
                }

                public Delete setSavedQueryId(String savedQueryId) {
                    this.savedQueryId = savedQueryId;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }

            public class Create
            extends VaultRequest<SavedQuery> {
                private static final String REST_PATH = "v1/matters/{matterId}/savedQueries";
                @Key
                private String matterId;

                protected Create(String matterId, SavedQuery content) {
                    super(Vault.this, "POST", REST_PATH, (Object)content, SavedQuery.class);
                    this.matterId = (String)Preconditions.checkNotNull((Object)matterId, (Object)"Required parameter matterId must be specified.");
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getMatterId() {
                    return this.matterId;
                }

                public Create setMatterId(String matterId) {
                    this.matterId = matterId;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class Holds {
            public AddHeldAccounts addHeldAccounts(String matterId, String holdId, AddHeldAccountsRequest content) throws IOException {
                AddHeldAccounts result = new AddHeldAccounts(matterId, holdId, content);
                Vault.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Create create(String matterId, Hold content) throws IOException {
                Create result = new Create(matterId, content);
                Vault.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delete delete(String matterId, String holdId) throws IOException {
                Delete result = new Delete(matterId, holdId);
                Vault.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String matterId, String holdId) throws IOException {
                Get result = new Get(matterId, holdId);
                Vault.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String matterId) throws IOException {
                List result = new List(matterId);
                Vault.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public RemoveHeldAccounts removeHeldAccounts(String matterId, String holdId, RemoveHeldAccountsRequest content) throws IOException {
                RemoveHeldAccounts result = new RemoveHeldAccounts(matterId, holdId, content);
                Vault.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Update update(String matterId, String holdId, Hold content) throws IOException {
                Update result = new Update(matterId, holdId, content);
                Vault.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Accounts accounts() {
                return new Accounts();
            }

            public class Accounts {
                public Create create(String matterId, String holdId, HeldAccount content) throws IOException {
                    Create result = new Create(matterId, holdId, content);
                    Vault.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Delete delete(String matterId, String holdId, String accountId) throws IOException {
                    Delete result = new Delete(matterId, holdId, accountId);
                    Vault.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String matterId, String holdId) throws IOException {
                    List result = new List(matterId, holdId);
                    Vault.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class List
                extends VaultRequest<ListHeldAccountsResponse> {
                    private static final String REST_PATH = "v1/matters/{matterId}/holds/{holdId}/accounts";
                    @Key
                    private String matterId;
                    @Key
                    private String holdId;

                    protected List(String matterId, String holdId) {
                        super(Vault.this, "GET", REST_PATH, null, ListHeldAccountsResponse.class);
                        this.matterId = (String)Preconditions.checkNotNull((Object)matterId, (Object)"Required parameter matterId must be specified.");
                        this.holdId = (String)Preconditions.checkNotNull((Object)holdId, (Object)"Required parameter holdId must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getMatterId() {
                        return this.matterId;
                    }

                    public List setMatterId(String matterId) {
                        this.matterId = matterId;
                        return this;
                    }

                    public String getHoldId() {
                        return this.holdId;
                    }

                    public List setHoldId(String holdId) {
                        this.holdId = holdId;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class Delete
                extends VaultRequest<Empty> {
                    private static final String REST_PATH = "v1/matters/{matterId}/holds/{holdId}/accounts/{accountId}";
                    @Key
                    private String matterId;
                    @Key
                    private String holdId;
                    @Key
                    private String accountId;

                    protected Delete(String matterId, String holdId, String accountId) {
                        super(Vault.this, "DELETE", REST_PATH, null, Empty.class);
                        this.matterId = (String)Preconditions.checkNotNull((Object)matterId, (Object)"Required parameter matterId must be specified.");
                        this.holdId = (String)Preconditions.checkNotNull((Object)holdId, (Object)"Required parameter holdId must be specified.");
                        this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    }

                    public Delete set$Xgafv(String $Xgafv) {
                        return (Delete)super.set$Xgafv($Xgafv);
                    }

                    public Delete setAccessToken(String accessToken) {
                        return (Delete)super.setAccessToken(accessToken);
                    }

                    public Delete setAlt(String alt) {
                        return (Delete)super.setAlt(alt);
                    }

                    public Delete setCallback(String callback) {
                        return (Delete)super.setCallback(callback);
                    }

                    public Delete setFields(String fields) {
                        return (Delete)super.setFields(fields);
                    }

                    public Delete setKey(String key) {
                        return (Delete)super.setKey(key);
                    }

                    public Delete setOauthToken(String oauthToken) {
                        return (Delete)super.setOauthToken(oauthToken);
                    }

                    public Delete setPrettyPrint(Boolean prettyPrint) {
                        return (Delete)super.setPrettyPrint(prettyPrint);
                    }

                    public Delete setQuotaUser(String quotaUser) {
                        return (Delete)super.setQuotaUser(quotaUser);
                    }

                    public Delete setUploadType(String uploadType) {
                        return (Delete)super.setUploadType(uploadType);
                    }

                    public Delete setUploadProtocol(String uploadProtocol) {
                        return (Delete)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getMatterId() {
                        return this.matterId;
                    }

                    public Delete setMatterId(String matterId) {
                        this.matterId = matterId;
                        return this;
                    }

                    public String getHoldId() {
                        return this.holdId;
                    }

                    public Delete setHoldId(String holdId) {
                        this.holdId = holdId;
                        return this;
                    }

                    public String getAccountId() {
                        return this.accountId;
                    }

                    public Delete setAccountId(String accountId) {
                        this.accountId = accountId;
                        return this;
                    }

                    @Override
                    public Delete set(String parameterName, Object value) {
                        return (Delete)super.set(parameterName, value);
                    }
                }

                public class Create
                extends VaultRequest<HeldAccount> {
                    private static final String REST_PATH = "v1/matters/{matterId}/holds/{holdId}/accounts";
                    @Key
                    private String matterId;
                    @Key
                    private String holdId;

                    protected Create(String matterId, String holdId, HeldAccount content) {
                        super(Vault.this, "POST", REST_PATH, (Object)content, HeldAccount.class);
                        this.matterId = (String)Preconditions.checkNotNull((Object)matterId, (Object)"Required parameter matterId must be specified.");
                        this.holdId = (String)Preconditions.checkNotNull((Object)holdId, (Object)"Required parameter holdId must be specified.");
                    }

                    public Create set$Xgafv(String $Xgafv) {
                        return (Create)super.set$Xgafv($Xgafv);
                    }

                    public Create setAccessToken(String accessToken) {
                        return (Create)super.setAccessToken(accessToken);
                    }

                    public Create setAlt(String alt) {
                        return (Create)super.setAlt(alt);
                    }

                    public Create setCallback(String callback) {
                        return (Create)super.setCallback(callback);
                    }

                    public Create setFields(String fields) {
                        return (Create)super.setFields(fields);
                    }

                    public Create setKey(String key) {
                        return (Create)super.setKey(key);
                    }

                    public Create setOauthToken(String oauthToken) {
                        return (Create)super.setOauthToken(oauthToken);
                    }

                    public Create setPrettyPrint(Boolean prettyPrint) {
                        return (Create)super.setPrettyPrint(prettyPrint);
                    }

                    public Create setQuotaUser(String quotaUser) {
                        return (Create)super.setQuotaUser(quotaUser);
                    }

                    public Create setUploadType(String uploadType) {
                        return (Create)super.setUploadType(uploadType);
                    }

                    public Create setUploadProtocol(String uploadProtocol) {
                        return (Create)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getMatterId() {
                        return this.matterId;
                    }

                    public Create setMatterId(String matterId) {
                        this.matterId = matterId;
                        return this;
                    }

                    public String getHoldId() {
                        return this.holdId;
                    }

                    public Create setHoldId(String holdId) {
                        this.holdId = holdId;
                        return this;
                    }

                    @Override
                    public Create set(String parameterName, Object value) {
                        return (Create)super.set(parameterName, value);
                    }
                }
            }

            public class Update
            extends VaultRequest<Hold> {
                private static final String REST_PATH = "v1/matters/{matterId}/holds/{holdId}";
                @Key
                private String matterId;
                @Key
                private String holdId;

                protected Update(String matterId, String holdId, Hold content) {
                    super(Vault.this, "PUT", REST_PATH, (Object)content, Hold.class);
                    this.matterId = (String)Preconditions.checkNotNull((Object)matterId, (Object)"Required parameter matterId must be specified.");
                    this.holdId = (String)Preconditions.checkNotNull((Object)holdId, (Object)"Required parameter holdId must be specified.");
                }

                public Update set$Xgafv(String $Xgafv) {
                    return (Update)super.set$Xgafv($Xgafv);
                }

                public Update setAccessToken(String accessToken) {
                    return (Update)super.setAccessToken(accessToken);
                }

                public Update setAlt(String alt) {
                    return (Update)super.setAlt(alt);
                }

                public Update setCallback(String callback) {
                    return (Update)super.setCallback(callback);
                }

                public Update setFields(String fields) {
                    return (Update)super.setFields(fields);
                }

                public Update setKey(String key) {
                    return (Update)super.setKey(key);
                }

                public Update setOauthToken(String oauthToken) {
                    return (Update)super.setOauthToken(oauthToken);
                }

                public Update setPrettyPrint(Boolean prettyPrint) {
                    return (Update)super.setPrettyPrint(prettyPrint);
                }

                public Update setQuotaUser(String quotaUser) {
                    return (Update)super.setQuotaUser(quotaUser);
                }

                public Update setUploadType(String uploadType) {
                    return (Update)super.setUploadType(uploadType);
                }

                public Update setUploadProtocol(String uploadProtocol) {
                    return (Update)super.setUploadProtocol(uploadProtocol);
                }

                public String getMatterId() {
                    return this.matterId;
                }

                public Update setMatterId(String matterId) {
                    this.matterId = matterId;
                    return this;
                }

                public String getHoldId() {
                    return this.holdId;
                }

                public Update setHoldId(String holdId) {
                    this.holdId = holdId;
                    return this;
                }

                @Override
                public Update set(String parameterName, Object value) {
                    return (Update)super.set(parameterName, value);
                }
            }

            public class RemoveHeldAccounts
            extends VaultRequest<RemoveHeldAccountsResponse> {
                private static final String REST_PATH = "v1/matters/{matterId}/holds/{holdId}:removeHeldAccounts";
                @Key
                private String matterId;
                @Key
                private String holdId;

                protected RemoveHeldAccounts(String matterId, String holdId, RemoveHeldAccountsRequest content) {
                    super(Vault.this, "POST", REST_PATH, (Object)content, RemoveHeldAccountsResponse.class);
                    this.matterId = (String)Preconditions.checkNotNull((Object)matterId, (Object)"Required parameter matterId must be specified.");
                    this.holdId = (String)Preconditions.checkNotNull((Object)holdId, (Object)"Required parameter holdId must be specified.");
                }

                public RemoveHeldAccounts set$Xgafv(String $Xgafv) {
                    return (RemoveHeldAccounts)super.set$Xgafv($Xgafv);
                }

                public RemoveHeldAccounts setAccessToken(String accessToken) {
                    return (RemoveHeldAccounts)super.setAccessToken(accessToken);
                }

                public RemoveHeldAccounts setAlt(String alt) {
                    return (RemoveHeldAccounts)super.setAlt(alt);
                }

                public RemoveHeldAccounts setCallback(String callback) {
                    return (RemoveHeldAccounts)super.setCallback(callback);
                }

                public RemoveHeldAccounts setFields(String fields) {
                    return (RemoveHeldAccounts)super.setFields(fields);
                }

                public RemoveHeldAccounts setKey(String key) {
                    return (RemoveHeldAccounts)super.setKey(key);
                }

                public RemoveHeldAccounts setOauthToken(String oauthToken) {
                    return (RemoveHeldAccounts)super.setOauthToken(oauthToken);
                }

                public RemoveHeldAccounts setPrettyPrint(Boolean prettyPrint) {
                    return (RemoveHeldAccounts)super.setPrettyPrint(prettyPrint);
                }

                public RemoveHeldAccounts setQuotaUser(String quotaUser) {
                    return (RemoveHeldAccounts)super.setQuotaUser(quotaUser);
                }

                public RemoveHeldAccounts setUploadType(String uploadType) {
                    return (RemoveHeldAccounts)super.setUploadType(uploadType);
                }

                public RemoveHeldAccounts setUploadProtocol(String uploadProtocol) {
                    return (RemoveHeldAccounts)super.setUploadProtocol(uploadProtocol);
                }

                public String getMatterId() {
                    return this.matterId;
                }

                public RemoveHeldAccounts setMatterId(String matterId) {
                    this.matterId = matterId;
                    return this;
                }

                public String getHoldId() {
                    return this.holdId;
                }

                public RemoveHeldAccounts setHoldId(String holdId) {
                    this.holdId = holdId;
                    return this;
                }

                @Override
                public RemoveHeldAccounts set(String parameterName, Object value) {
                    return (RemoveHeldAccounts)super.set(parameterName, value);
                }
            }

            public class List
            extends VaultRequest<ListHoldsResponse> {
                private static final String REST_PATH = "v1/matters/{matterId}/holds";
                @Key
                private String matterId;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;
                @Key
                private String view;

                protected List(String matterId) {
                    super(Vault.this, "GET", REST_PATH, null, ListHoldsResponse.class);
                    this.matterId = (String)Preconditions.checkNotNull((Object)matterId, (Object)"Required parameter matterId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getMatterId() {
                    return this.matterId;
                }

                public List setMatterId(String matterId) {
                    this.matterId = matterId;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                public String getView() {
                    return this.view;
                }

                public List setView(String view) {
                    this.view = view;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends VaultRequest<Hold> {
                private static final String REST_PATH = "v1/matters/{matterId}/holds/{holdId}";
                @Key
                private String matterId;
                @Key
                private String holdId;
                @Key
                private String view;

                protected Get(String matterId, String holdId) {
                    super(Vault.this, "GET", REST_PATH, null, Hold.class);
                    this.matterId = (String)Preconditions.checkNotNull((Object)matterId, (Object)"Required parameter matterId must be specified.");
                    this.holdId = (String)Preconditions.checkNotNull((Object)holdId, (Object)"Required parameter holdId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getMatterId() {
                    return this.matterId;
                }

                public Get setMatterId(String matterId) {
                    this.matterId = matterId;
                    return this;
                }

                public String getHoldId() {
                    return this.holdId;
                }

                public Get setHoldId(String holdId) {
                    this.holdId = holdId;
                    return this;
                }

                public String getView() {
                    return this.view;
                }

                public Get setView(String view) {
                    this.view = view;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends VaultRequest<Empty> {
                private static final String REST_PATH = "v1/matters/{matterId}/holds/{holdId}";
                @Key
                private String matterId;
                @Key
                private String holdId;

                protected Delete(String matterId, String holdId) {
                    super(Vault.this, "DELETE", REST_PATH, null, Empty.class);
                    this.matterId = (String)Preconditions.checkNotNull((Object)matterId, (Object)"Required parameter matterId must be specified.");
                    this.holdId = (String)Preconditions.checkNotNull((Object)holdId, (Object)"Required parameter holdId must be specified.");
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public String getMatterId() {
                    return this.matterId;
                }

                public Delete setMatterId(String matterId) {
                    this.matterId = matterId;
                    return this;
                }

                public String getHoldId() {
                    return this.holdId;
                }

                public Delete setHoldId(String holdId) {
                    this.holdId = holdId;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }

            public class Create
            extends VaultRequest<Hold> {
                private static final String REST_PATH = "v1/matters/{matterId}/holds";
                @Key
                private String matterId;

                protected Create(String matterId, Hold content) {
                    super(Vault.this, "POST", REST_PATH, (Object)content, Hold.class);
                    this.matterId = (String)Preconditions.checkNotNull((Object)matterId, (Object)"Required parameter matterId must be specified.");
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getMatterId() {
                    return this.matterId;
                }

                public Create setMatterId(String matterId) {
                    this.matterId = matterId;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }

            public class AddHeldAccounts
            extends VaultRequest<AddHeldAccountsResponse> {
                private static final String REST_PATH = "v1/matters/{matterId}/holds/{holdId}:addHeldAccounts";
                @Key
                private String matterId;
                @Key
                private String holdId;

                protected AddHeldAccounts(String matterId, String holdId, AddHeldAccountsRequest content) {
                    super(Vault.this, "POST", REST_PATH, (Object)content, AddHeldAccountsResponse.class);
                    this.matterId = (String)Preconditions.checkNotNull((Object)matterId, (Object)"Required parameter matterId must be specified.");
                    this.holdId = (String)Preconditions.checkNotNull((Object)holdId, (Object)"Required parameter holdId must be specified.");
                }

                public AddHeldAccounts set$Xgafv(String $Xgafv) {
                    return (AddHeldAccounts)super.set$Xgafv($Xgafv);
                }

                public AddHeldAccounts setAccessToken(String accessToken) {
                    return (AddHeldAccounts)super.setAccessToken(accessToken);
                }

                public AddHeldAccounts setAlt(String alt) {
                    return (AddHeldAccounts)super.setAlt(alt);
                }

                public AddHeldAccounts setCallback(String callback) {
                    return (AddHeldAccounts)super.setCallback(callback);
                }

                public AddHeldAccounts setFields(String fields) {
                    return (AddHeldAccounts)super.setFields(fields);
                }

                public AddHeldAccounts setKey(String key) {
                    return (AddHeldAccounts)super.setKey(key);
                }

                public AddHeldAccounts setOauthToken(String oauthToken) {
                    return (AddHeldAccounts)super.setOauthToken(oauthToken);
                }

                public AddHeldAccounts setPrettyPrint(Boolean prettyPrint) {
                    return (AddHeldAccounts)super.setPrettyPrint(prettyPrint);
                }

                public AddHeldAccounts setQuotaUser(String quotaUser) {
                    return (AddHeldAccounts)super.setQuotaUser(quotaUser);
                }

                public AddHeldAccounts setUploadType(String uploadType) {
                    return (AddHeldAccounts)super.setUploadType(uploadType);
                }

                public AddHeldAccounts setUploadProtocol(String uploadProtocol) {
                    return (AddHeldAccounts)super.setUploadProtocol(uploadProtocol);
                }

                public String getMatterId() {
                    return this.matterId;
                }

                public AddHeldAccounts setMatterId(String matterId) {
                    this.matterId = matterId;
                    return this;
                }

                public String getHoldId() {
                    return this.holdId;
                }

                public AddHeldAccounts setHoldId(String holdId) {
                    this.holdId = holdId;
                    return this;
                }

                @Override
                public AddHeldAccounts set(String parameterName, Object value) {
                    return (AddHeldAccounts)super.set(parameterName, value);
                }
            }
        }

        public class Exports {
            public Create create(String matterId, Export content) throws IOException {
                Create result = new Create(matterId, content);
                Vault.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delete delete(String matterId, String exportId) throws IOException {
                Delete result = new Delete(matterId, exportId);
                Vault.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String matterId, String exportId) throws IOException {
                Get result = new Get(matterId, exportId);
                Vault.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String matterId) throws IOException {
                List result = new List(matterId);
                Vault.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class List
            extends VaultRequest<ListExportsResponse> {
                private static final String REST_PATH = "v1/matters/{matterId}/exports";
                @Key
                private String matterId;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String matterId) {
                    super(Vault.this, "GET", REST_PATH, null, ListExportsResponse.class);
                    this.matterId = (String)Preconditions.checkNotNull((Object)matterId, (Object)"Required parameter matterId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getMatterId() {
                    return this.matterId;
                }

                public List setMatterId(String matterId) {
                    this.matterId = matterId;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends VaultRequest<Export> {
                private static final String REST_PATH = "v1/matters/{matterId}/exports/{exportId}";
                @Key
                private String matterId;
                @Key
                private String exportId;

                protected Get(String matterId, String exportId) {
                    super(Vault.this, "GET", REST_PATH, null, Export.class);
                    this.matterId = (String)Preconditions.checkNotNull((Object)matterId, (Object)"Required parameter matterId must be specified.");
                    this.exportId = (String)Preconditions.checkNotNull((Object)exportId, (Object)"Required parameter exportId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getMatterId() {
                    return this.matterId;
                }

                public Get setMatterId(String matterId) {
                    this.matterId = matterId;
                    return this;
                }

                public String getExportId() {
                    return this.exportId;
                }

                public Get setExportId(String exportId) {
                    this.exportId = exportId;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends VaultRequest<Empty> {
                private static final String REST_PATH = "v1/matters/{matterId}/exports/{exportId}";
                @Key
                private String matterId;
                @Key
                private String exportId;

                protected Delete(String matterId, String exportId) {
                    super(Vault.this, "DELETE", REST_PATH, null, Empty.class);
                    this.matterId = (String)Preconditions.checkNotNull((Object)matterId, (Object)"Required parameter matterId must be specified.");
                    this.exportId = (String)Preconditions.checkNotNull((Object)exportId, (Object)"Required parameter exportId must be specified.");
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public String getMatterId() {
                    return this.matterId;
                }

                public Delete setMatterId(String matterId) {
                    this.matterId = matterId;
                    return this;
                }

                public String getExportId() {
                    return this.exportId;
                }

                public Delete setExportId(String exportId) {
                    this.exportId = exportId;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }

            public class Create
            extends VaultRequest<Export> {
                private static final String REST_PATH = "v1/matters/{matterId}/exports";
                @Key
                private String matterId;

                protected Create(String matterId, Export content) {
                    super(Vault.this, "POST", REST_PATH, (Object)content, Export.class);
                    this.matterId = (String)Preconditions.checkNotNull((Object)matterId, (Object)"Required parameter matterId must be specified.");
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getMatterId() {
                    return this.matterId;
                }

                public Create setMatterId(String matterId) {
                    this.matterId = matterId;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class Update
        extends VaultRequest<Matter> {
            private static final String REST_PATH = "v1/matters/{matterId}";
            @Key
            private String matterId;

            protected Update(String matterId, Matter content) {
                super(Vault.this, "PUT", REST_PATH, (Object)content, Matter.class);
                this.matterId = (String)Preconditions.checkNotNull((Object)matterId, (Object)"Required parameter matterId must be specified.");
            }

            public Update set$Xgafv(String $Xgafv) {
                return (Update)super.set$Xgafv($Xgafv);
            }

            public Update setAccessToken(String accessToken) {
                return (Update)super.setAccessToken(accessToken);
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setCallback(String callback) {
                return (Update)super.setCallback(callback);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUploadType(String uploadType) {
                return (Update)super.setUploadType(uploadType);
            }

            public Update setUploadProtocol(String uploadProtocol) {
                return (Update)super.setUploadProtocol(uploadProtocol);
            }

            public String getMatterId() {
                return this.matterId;
            }

            public Update setMatterId(String matterId) {
                this.matterId = matterId;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class Undelete
        extends VaultRequest<Matter> {
            private static final String REST_PATH = "v1/matters/{matterId}:undelete";
            @Key
            private String matterId;

            protected Undelete(String matterId, UndeleteMatterRequest content) {
                super(Vault.this, "POST", REST_PATH, (Object)content, Matter.class);
                this.matterId = (String)Preconditions.checkNotNull((Object)matterId, (Object)"Required parameter matterId must be specified.");
            }

            public Undelete set$Xgafv(String $Xgafv) {
                return (Undelete)super.set$Xgafv($Xgafv);
            }

            public Undelete setAccessToken(String accessToken) {
                return (Undelete)super.setAccessToken(accessToken);
            }

            public Undelete setAlt(String alt) {
                return (Undelete)super.setAlt(alt);
            }

            public Undelete setCallback(String callback) {
                return (Undelete)super.setCallback(callback);
            }

            public Undelete setFields(String fields) {
                return (Undelete)super.setFields(fields);
            }

            public Undelete setKey(String key) {
                return (Undelete)super.setKey(key);
            }

            public Undelete setOauthToken(String oauthToken) {
                return (Undelete)super.setOauthToken(oauthToken);
            }

            public Undelete setPrettyPrint(Boolean prettyPrint) {
                return (Undelete)super.setPrettyPrint(prettyPrint);
            }

            public Undelete setQuotaUser(String quotaUser) {
                return (Undelete)super.setQuotaUser(quotaUser);
            }

            public Undelete setUploadType(String uploadType) {
                return (Undelete)super.setUploadType(uploadType);
            }

            public Undelete setUploadProtocol(String uploadProtocol) {
                return (Undelete)super.setUploadProtocol(uploadProtocol);
            }

            public String getMatterId() {
                return this.matterId;
            }

            public Undelete setMatterId(String matterId) {
                this.matterId = matterId;
                return this;
            }

            @Override
            public Undelete set(String parameterName, Object value) {
                return (Undelete)super.set(parameterName, value);
            }
        }

        public class Reopen
        extends VaultRequest<ReopenMatterResponse> {
            private static final String REST_PATH = "v1/matters/{matterId}:reopen";
            @Key
            private String matterId;

            protected Reopen(String matterId, ReopenMatterRequest content) {
                super(Vault.this, "POST", REST_PATH, (Object)content, ReopenMatterResponse.class);
                this.matterId = (String)Preconditions.checkNotNull((Object)matterId, (Object)"Required parameter matterId must be specified.");
            }

            public Reopen set$Xgafv(String $Xgafv) {
                return (Reopen)super.set$Xgafv($Xgafv);
            }

            public Reopen setAccessToken(String accessToken) {
                return (Reopen)super.setAccessToken(accessToken);
            }

            public Reopen setAlt(String alt) {
                return (Reopen)super.setAlt(alt);
            }

            public Reopen setCallback(String callback) {
                return (Reopen)super.setCallback(callback);
            }

            public Reopen setFields(String fields) {
                return (Reopen)super.setFields(fields);
            }

            public Reopen setKey(String key) {
                return (Reopen)super.setKey(key);
            }

            public Reopen setOauthToken(String oauthToken) {
                return (Reopen)super.setOauthToken(oauthToken);
            }

            public Reopen setPrettyPrint(Boolean prettyPrint) {
                return (Reopen)super.setPrettyPrint(prettyPrint);
            }

            public Reopen setQuotaUser(String quotaUser) {
                return (Reopen)super.setQuotaUser(quotaUser);
            }

            public Reopen setUploadType(String uploadType) {
                return (Reopen)super.setUploadType(uploadType);
            }

            public Reopen setUploadProtocol(String uploadProtocol) {
                return (Reopen)super.setUploadProtocol(uploadProtocol);
            }

            public String getMatterId() {
                return this.matterId;
            }

            public Reopen setMatterId(String matterId) {
                this.matterId = matterId;
                return this;
            }

            @Override
            public Reopen set(String parameterName, Object value) {
                return (Reopen)super.set(parameterName, value);
            }
        }

        public class RemovePermissions
        extends VaultRequest<Empty> {
            private static final String REST_PATH = "v1/matters/{matterId}:removePermissions";
            @Key
            private String matterId;

            protected RemovePermissions(String matterId, RemoveMatterPermissionsRequest content) {
                super(Vault.this, "POST", REST_PATH, (Object)content, Empty.class);
                this.matterId = (String)Preconditions.checkNotNull((Object)matterId, (Object)"Required parameter matterId must be specified.");
            }

            public RemovePermissions set$Xgafv(String $Xgafv) {
                return (RemovePermissions)super.set$Xgafv($Xgafv);
            }

            public RemovePermissions setAccessToken(String accessToken) {
                return (RemovePermissions)super.setAccessToken(accessToken);
            }

            public RemovePermissions setAlt(String alt) {
                return (RemovePermissions)super.setAlt(alt);
            }

            public RemovePermissions setCallback(String callback) {
                return (RemovePermissions)super.setCallback(callback);
            }

            public RemovePermissions setFields(String fields) {
                return (RemovePermissions)super.setFields(fields);
            }

            public RemovePermissions setKey(String key) {
                return (RemovePermissions)super.setKey(key);
            }

            public RemovePermissions setOauthToken(String oauthToken) {
                return (RemovePermissions)super.setOauthToken(oauthToken);
            }

            public RemovePermissions setPrettyPrint(Boolean prettyPrint) {
                return (RemovePermissions)super.setPrettyPrint(prettyPrint);
            }

            public RemovePermissions setQuotaUser(String quotaUser) {
                return (RemovePermissions)super.setQuotaUser(quotaUser);
            }

            public RemovePermissions setUploadType(String uploadType) {
                return (RemovePermissions)super.setUploadType(uploadType);
            }

            public RemovePermissions setUploadProtocol(String uploadProtocol) {
                return (RemovePermissions)super.setUploadProtocol(uploadProtocol);
            }

            public String getMatterId() {
                return this.matterId;
            }

            public RemovePermissions setMatterId(String matterId) {
                this.matterId = matterId;
                return this;
            }

            @Override
            public RemovePermissions set(String parameterName, Object value) {
                return (RemovePermissions)super.set(parameterName, value);
            }
        }

        public class List
        extends VaultRequest<ListMattersResponse> {
            private static final String REST_PATH = "v1/matters";
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;
            @Key
            private String state;
            @Key
            private String view;

            protected List() {
                super(Vault.this, "GET", REST_PATH, null, ListMattersResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getState() {
                return this.state;
            }

            public List setState(String state) {
                this.state = state;
                return this;
            }

            public String getView() {
                return this.view;
            }

            public List setView(String view) {
                this.view = view;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends VaultRequest<Matter> {
            private static final String REST_PATH = "v1/matters/{matterId}";
            @Key
            private String matterId;
            @Key
            private String view;

            protected Get(String matterId) {
                super(Vault.this, "GET", REST_PATH, null, Matter.class);
                this.matterId = (String)Preconditions.checkNotNull((Object)matterId, (Object)"Required parameter matterId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getMatterId() {
                return this.matterId;
            }

            public Get setMatterId(String matterId) {
                this.matterId = matterId;
                return this;
            }

            public String getView() {
                return this.view;
            }

            public Get setView(String view) {
                this.view = view;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends VaultRequest<Matter> {
            private static final String REST_PATH = "v1/matters/{matterId}";
            @Key
            private String matterId;

            protected Delete(String matterId) {
                super(Vault.this, "DELETE", REST_PATH, null, Matter.class);
                this.matterId = (String)Preconditions.checkNotNull((Object)matterId, (Object)"Required parameter matterId must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getMatterId() {
                return this.matterId;
            }

            public Delete setMatterId(String matterId) {
                this.matterId = matterId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Create
        extends VaultRequest<Matter> {
            private static final String REST_PATH = "v1/matters";

            protected Create(Matter content) {
                super(Vault.this, "POST", REST_PATH, (Object)content, Matter.class);
            }

            public Create set$Xgafv(String $Xgafv) {
                return (Create)super.set$Xgafv($Xgafv);
            }

            public Create setAccessToken(String accessToken) {
                return (Create)super.setAccessToken(accessToken);
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setCallback(String callback) {
                return (Create)super.setCallback(callback);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUploadType(String uploadType) {
                return (Create)super.setUploadType(uploadType);
            }

            public Create setUploadProtocol(String uploadProtocol) {
                return (Create)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }

        public class Count
        extends VaultRequest<Operation> {
            private static final String REST_PATH = "v1/matters/{matterId}:count";
            @Key
            private String matterId;

            protected Count(String matterId, CountArtifactsRequest content) {
                super(Vault.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.matterId = (String)Preconditions.checkNotNull((Object)matterId, (Object)"Required parameter matterId must be specified.");
            }

            public Count set$Xgafv(String $Xgafv) {
                return (Count)super.set$Xgafv($Xgafv);
            }

            public Count setAccessToken(String accessToken) {
                return (Count)super.setAccessToken(accessToken);
            }

            public Count setAlt(String alt) {
                return (Count)super.setAlt(alt);
            }

            public Count setCallback(String callback) {
                return (Count)super.setCallback(callback);
            }

            public Count setFields(String fields) {
                return (Count)super.setFields(fields);
            }

            public Count setKey(String key) {
                return (Count)super.setKey(key);
            }

            public Count setOauthToken(String oauthToken) {
                return (Count)super.setOauthToken(oauthToken);
            }

            public Count setPrettyPrint(Boolean prettyPrint) {
                return (Count)super.setPrettyPrint(prettyPrint);
            }

            public Count setQuotaUser(String quotaUser) {
                return (Count)super.setQuotaUser(quotaUser);
            }

            public Count setUploadType(String uploadType) {
                return (Count)super.setUploadType(uploadType);
            }

            public Count setUploadProtocol(String uploadProtocol) {
                return (Count)super.setUploadProtocol(uploadProtocol);
            }

            public String getMatterId() {
                return this.matterId;
            }

            public Count setMatterId(String matterId) {
                this.matterId = matterId;
                return this;
            }

            @Override
            public Count set(String parameterName, Object value) {
                return (Count)super.set(parameterName, value);
            }
        }

        public class Close
        extends VaultRequest<CloseMatterResponse> {
            private static final String REST_PATH = "v1/matters/{matterId}:close";
            @Key
            private String matterId;

            protected Close(String matterId, CloseMatterRequest content) {
                super(Vault.this, "POST", REST_PATH, (Object)content, CloseMatterResponse.class);
                this.matterId = (String)Preconditions.checkNotNull((Object)matterId, (Object)"Required parameter matterId must be specified.");
            }

            public Close set$Xgafv(String $Xgafv) {
                return (Close)super.set$Xgafv($Xgafv);
            }

            public Close setAccessToken(String accessToken) {
                return (Close)super.setAccessToken(accessToken);
            }

            public Close setAlt(String alt) {
                return (Close)super.setAlt(alt);
            }

            public Close setCallback(String callback) {
                return (Close)super.setCallback(callback);
            }

            public Close setFields(String fields) {
                return (Close)super.setFields(fields);
            }

            public Close setKey(String key) {
                return (Close)super.setKey(key);
            }

            public Close setOauthToken(String oauthToken) {
                return (Close)super.setOauthToken(oauthToken);
            }

            public Close setPrettyPrint(Boolean prettyPrint) {
                return (Close)super.setPrettyPrint(prettyPrint);
            }

            public Close setQuotaUser(String quotaUser) {
                return (Close)super.setQuotaUser(quotaUser);
            }

            public Close setUploadType(String uploadType) {
                return (Close)super.setUploadType(uploadType);
            }

            public Close setUploadProtocol(String uploadProtocol) {
                return (Close)super.setUploadProtocol(uploadProtocol);
            }

            public String getMatterId() {
                return this.matterId;
            }

            public Close setMatterId(String matterId) {
                this.matterId = matterId;
                return this;
            }

            @Override
            public Close set(String parameterName, Object value) {
                return (Close)super.set(parameterName, value);
            }
        }

        public class AddPermissions
        extends VaultRequest<MatterPermission> {
            private static final String REST_PATH = "v1/matters/{matterId}:addPermissions";
            @Key
            private String matterId;

            protected AddPermissions(String matterId, AddMatterPermissionsRequest content) {
                super(Vault.this, "POST", REST_PATH, (Object)content, MatterPermission.class);
                this.matterId = (String)Preconditions.checkNotNull((Object)matterId, (Object)"Required parameter matterId must be specified.");
            }

            public AddPermissions set$Xgafv(String $Xgafv) {
                return (AddPermissions)super.set$Xgafv($Xgafv);
            }

            public AddPermissions setAccessToken(String accessToken) {
                return (AddPermissions)super.setAccessToken(accessToken);
            }

            public AddPermissions setAlt(String alt) {
                return (AddPermissions)super.setAlt(alt);
            }

            public AddPermissions setCallback(String callback) {
                return (AddPermissions)super.setCallback(callback);
            }

            public AddPermissions setFields(String fields) {
                return (AddPermissions)super.setFields(fields);
            }

            public AddPermissions setKey(String key) {
                return (AddPermissions)super.setKey(key);
            }

            public AddPermissions setOauthToken(String oauthToken) {
                return (AddPermissions)super.setOauthToken(oauthToken);
            }

            public AddPermissions setPrettyPrint(Boolean prettyPrint) {
                return (AddPermissions)super.setPrettyPrint(prettyPrint);
            }

            public AddPermissions setQuotaUser(String quotaUser) {
                return (AddPermissions)super.setQuotaUser(quotaUser);
            }

            public AddPermissions setUploadType(String uploadType) {
                return (AddPermissions)super.setUploadType(uploadType);
            }

            public AddPermissions setUploadProtocol(String uploadProtocol) {
                return (AddPermissions)super.setUploadProtocol(uploadProtocol);
            }

            public String getMatterId() {
                return this.matterId;
            }

            public AddPermissions setMatterId(String matterId) {
                this.matterId = matterId;
                return this;
            }

            @Override
            public AddPermissions set(String parameterName, Object value) {
                return (AddPermissions)super.set(parameterName, value);
            }
        }
    }
}

