/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.vision.v1;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.vision.v1.VisionRequest;
import com.google.api.services.vision.v1.VisionRequestInitializer;
import com.google.api.services.vision.v1.model.AddProductToProductSetRequest;
import com.google.api.services.vision.v1.model.AsyncBatchAnnotateFilesRequest;
import com.google.api.services.vision.v1.model.AsyncBatchAnnotateImagesRequest;
import com.google.api.services.vision.v1.model.BatchAnnotateFilesRequest;
import com.google.api.services.vision.v1.model.BatchAnnotateFilesResponse;
import com.google.api.services.vision.v1.model.BatchAnnotateImagesRequest;
import com.google.api.services.vision.v1.model.BatchAnnotateImagesResponse;
import com.google.api.services.vision.v1.model.CancelOperationRequest;
import com.google.api.services.vision.v1.model.Empty;
import com.google.api.services.vision.v1.model.ImportProductSetsRequest;
import com.google.api.services.vision.v1.model.ListOperationsResponse;
import com.google.api.services.vision.v1.model.ListProductSetsResponse;
import com.google.api.services.vision.v1.model.ListProductsInProductSetResponse;
import com.google.api.services.vision.v1.model.ListProductsResponse;
import com.google.api.services.vision.v1.model.ListReferenceImagesResponse;
import com.google.api.services.vision.v1.model.Operation;
import com.google.api.services.vision.v1.model.Product;
import com.google.api.services.vision.v1.model.ProductSet;
import com.google.api.services.vision.v1.model.PurgeProductsRequest;
import com.google.api.services.vision.v1.model.ReferenceImage;
import com.google.api.services.vision.v1.model.RemoveProductFromProductSetRequest;
import java.io.IOException;
import java.util.regex.Pattern;

public class Vision
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://vision.googleapis.com/";
    public static final String DEFAULT_MTLS_ROOT_URL = "https://vision.mtls.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://vision.googleapis.com/";

    public Vision(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    Vision(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Files files() {
        return new Files();
    }

    public Images images() {
        return new Images();
    }

    public Locations locations() {
        return new Locations();
    }

    public Operations operations() {
        return new Operations();
    }

    public Projects projects() {
        return new Projects();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && (GoogleUtils.MINOR_VERSION >= 32 || GoogleUtils.MINOR_VERSION == 31 && GoogleUtils.BUGFIX_VERSION >= 1) || GoogleUtils.MAJOR_VERSION >= 2 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.31.1 of google-api-client to run version 2.0.0 of the Cloud Vision API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        private static String chooseEndpoint(HttpTransport transport) {
            String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
            String string = useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
            if ("always".equals(useMtlsEndpoint) || "auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls()) {
                return Vision.DEFAULT_MTLS_ROOT_URL;
            }
            return "https://vision.googleapis.com/";
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Builder.chooseEndpoint(transport), Vision.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Vision.DEFAULT_BATCH_PATH);
        }

        public Vision build() {
            return new Vision(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setVisionRequestInitializer(VisionRequestInitializer visionRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)visionRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Projects {
        public Files files() {
            return new Files();
        }

        public Images images() {
            return new Images();
        }

        public Locations locations() {
            return new Locations();
        }

        public Operations operations() {
            return new Operations();
        }

        public class Operations {
            public Get get(String name) throws IOException {
                Get result = new Get(name);
                Vision.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Get
            extends VisionRequest<Operation> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String name) {
                    super(Vision.this, "GET", REST_PATH, null, Operation.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/operations/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Vision.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/operations/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String name) {
                    if (!Vision.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/operations/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }
        }

        public class Locations {
            public Files files() {
                return new Files();
            }

            public Images images() {
                return new Images();
            }

            public Operations operations() {
                return new Operations();
            }

            public ProductSets productSets() {
                return new ProductSets();
            }

            public Products products() {
                return new Products();
            }

            public class Products {
                public Create create(String parent, Product content) throws IOException {
                    Create result = new Create(parent, content);
                    Vision.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Delete delete(String name) throws IOException {
                    Delete result = new Delete(name);
                    Vision.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(String name) throws IOException {
                    Get result = new Get(name);
                    Vision.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String parent) throws IOException {
                    List result = new List(parent);
                    Vision.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Patch patch(String name, Product content) throws IOException {
                    Patch result = new Patch(name, content);
                    Vision.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Purge purge(String parent, PurgeProductsRequest content) throws IOException {
                    Purge result = new Purge(parent, content);
                    Vision.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public ReferenceImages referenceImages() {
                    return new ReferenceImages();
                }

                public class ReferenceImages {
                    public Create create(String parent, ReferenceImage content) throws IOException {
                        Create result = new Create(parent, content);
                        Vision.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Delete delete(String name) throws IOException {
                        Delete result = new Delete(name);
                        Vision.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Get get(String name) throws IOException {
                        Get result = new Get(name);
                        Vision.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public List list(String parent) throws IOException {
                        List result = new List(parent);
                        Vision.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public class List
                    extends VisionRequest<ListReferenceImagesResponse> {
                        private static final String REST_PATH = "v1/{+parent}/referenceImages";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;
                        @Key
                        private Integer pageSize;
                        @Key
                        private String pageToken;

                        protected List(String parent) {
                            super(Vision.this, "GET", REST_PATH, null, ListReferenceImagesResponse.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/products/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                            if (!Vision.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/products/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public List set$Xgafv(String $Xgafv) {
                            return (List)super.set$Xgafv($Xgafv);
                        }

                        public List setAccessToken(String accessToken) {
                            return (List)super.setAccessToken(accessToken);
                        }

                        public List setAlt(String alt) {
                            return (List)super.setAlt(alt);
                        }

                        public List setCallback(String callback) {
                            return (List)super.setCallback(callback);
                        }

                        public List setFields(String fields) {
                            return (List)super.setFields(fields);
                        }

                        public List setKey(String key) {
                            return (List)super.setKey(key);
                        }

                        public List setOauthToken(String oauthToken) {
                            return (List)super.setOauthToken(oauthToken);
                        }

                        public List setPrettyPrint(Boolean prettyPrint) {
                            return (List)super.setPrettyPrint(prettyPrint);
                        }

                        public List setQuotaUser(String quotaUser) {
                            return (List)super.setQuotaUser(quotaUser);
                        }

                        public List setUploadType(String uploadType) {
                            return (List)super.setUploadType(uploadType);
                        }

                        public List setUploadProtocol(String uploadProtocol) {
                            return (List)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public List setParent(String parent) {
                            if (!Vision.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/products/[^/]+$");
                            }
                            this.parent = parent;
                            return this;
                        }

                        public Integer getPageSize() {
                            return this.pageSize;
                        }

                        public List setPageSize(Integer pageSize) {
                            this.pageSize = pageSize;
                            return this;
                        }

                        public String getPageToken() {
                            return this.pageToken;
                        }

                        public List setPageToken(String pageToken) {
                            this.pageToken = pageToken;
                            return this;
                        }

                        @Override
                        public List set(String parameterName, Object value) {
                            return (List)super.set(parameterName, value);
                        }
                    }

                    public class Get
                    extends VisionRequest<ReferenceImage> {
                        private static final String REST_PATH = "v1/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected Get(String name) {
                            super(Vision.this, "GET", REST_PATH, null, ReferenceImage.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/products/[^/]+/referenceImages/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!Vision.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/products/[^/]+/referenceImages/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public Get set$Xgafv(String $Xgafv) {
                            return (Get)super.set$Xgafv($Xgafv);
                        }

                        public Get setAccessToken(String accessToken) {
                            return (Get)super.setAccessToken(accessToken);
                        }

                        public Get setAlt(String alt) {
                            return (Get)super.setAlt(alt);
                        }

                        public Get setCallback(String callback) {
                            return (Get)super.setCallback(callback);
                        }

                        public Get setFields(String fields) {
                            return (Get)super.setFields(fields);
                        }

                        public Get setKey(String key) {
                            return (Get)super.setKey(key);
                        }

                        public Get setOauthToken(String oauthToken) {
                            return (Get)super.setOauthToken(oauthToken);
                        }

                        public Get setPrettyPrint(Boolean prettyPrint) {
                            return (Get)super.setPrettyPrint(prettyPrint);
                        }

                        public Get setQuotaUser(String quotaUser) {
                            return (Get)super.setQuotaUser(quotaUser);
                        }

                        public Get setUploadType(String uploadType) {
                            return (Get)super.setUploadType(uploadType);
                        }

                        public Get setUploadProtocol(String uploadProtocol) {
                            return (Get)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Get setName(String name) {
                            if (!Vision.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/products/[^/]+/referenceImages/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        @Override
                        public Get set(String parameterName, Object value) {
                            return (Get)super.set(parameterName, value);
                        }
                    }

                    public class Delete
                    extends VisionRequest<Empty> {
                        private static final String REST_PATH = "v1/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected Delete(String name) {
                            super(Vision.this, "DELETE", REST_PATH, null, Empty.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/products/[^/]+/referenceImages/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!Vision.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/products/[^/]+/referenceImages/[^/]+$");
                            }
                        }

                        public Delete set$Xgafv(String $Xgafv) {
                            return (Delete)super.set$Xgafv($Xgafv);
                        }

                        public Delete setAccessToken(String accessToken) {
                            return (Delete)super.setAccessToken(accessToken);
                        }

                        public Delete setAlt(String alt) {
                            return (Delete)super.setAlt(alt);
                        }

                        public Delete setCallback(String callback) {
                            return (Delete)super.setCallback(callback);
                        }

                        public Delete setFields(String fields) {
                            return (Delete)super.setFields(fields);
                        }

                        public Delete setKey(String key) {
                            return (Delete)super.setKey(key);
                        }

                        public Delete setOauthToken(String oauthToken) {
                            return (Delete)super.setOauthToken(oauthToken);
                        }

                        public Delete setPrettyPrint(Boolean prettyPrint) {
                            return (Delete)super.setPrettyPrint(prettyPrint);
                        }

                        public Delete setQuotaUser(String quotaUser) {
                            return (Delete)super.setQuotaUser(quotaUser);
                        }

                        public Delete setUploadType(String uploadType) {
                            return (Delete)super.setUploadType(uploadType);
                        }

                        public Delete setUploadProtocol(String uploadProtocol) {
                            return (Delete)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Delete setName(String name) {
                            if (!Vision.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/products/[^/]+/referenceImages/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        @Override
                        public Delete set(String parameterName, Object value) {
                            return (Delete)super.set(parameterName, value);
                        }
                    }

                    public class Create
                    extends VisionRequest<ReferenceImage> {
                        private static final String REST_PATH = "v1/{+parent}/referenceImages";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;
                        @Key
                        private String referenceImageId;

                        protected Create(String parent, ReferenceImage content) {
                            super(Vision.this, "POST", REST_PATH, (Object)content, ReferenceImage.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/products/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                            if (!Vision.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/products/[^/]+$");
                            }
                        }

                        public Create set$Xgafv(String $Xgafv) {
                            return (Create)super.set$Xgafv($Xgafv);
                        }

                        public Create setAccessToken(String accessToken) {
                            return (Create)super.setAccessToken(accessToken);
                        }

                        public Create setAlt(String alt) {
                            return (Create)super.setAlt(alt);
                        }

                        public Create setCallback(String callback) {
                            return (Create)super.setCallback(callback);
                        }

                        public Create setFields(String fields) {
                            return (Create)super.setFields(fields);
                        }

                        public Create setKey(String key) {
                            return (Create)super.setKey(key);
                        }

                        public Create setOauthToken(String oauthToken) {
                            return (Create)super.setOauthToken(oauthToken);
                        }

                        public Create setPrettyPrint(Boolean prettyPrint) {
                            return (Create)super.setPrettyPrint(prettyPrint);
                        }

                        public Create setQuotaUser(String quotaUser) {
                            return (Create)super.setQuotaUser(quotaUser);
                        }

                        public Create setUploadType(String uploadType) {
                            return (Create)super.setUploadType(uploadType);
                        }

                        public Create setUploadProtocol(String uploadProtocol) {
                            return (Create)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public Create setParent(String parent) {
                            if (!Vision.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/products/[^/]+$");
                            }
                            this.parent = parent;
                            return this;
                        }

                        public String getReferenceImageId() {
                            return this.referenceImageId;
                        }

                        public Create setReferenceImageId(String referenceImageId) {
                            this.referenceImageId = referenceImageId;
                            return this;
                        }

                        @Override
                        public Create set(String parameterName, Object value) {
                            return (Create)super.set(parameterName, value);
                        }
                    }
                }

                public class Purge
                extends VisionRequest<Operation> {
                    private static final String REST_PATH = "v1/{+parent}/products:purge";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;

                    protected Purge(String parent, PurgeProductsRequest content) {
                        super(Vision.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public Purge set$Xgafv(String $Xgafv) {
                        return (Purge)super.set$Xgafv($Xgafv);
                    }

                    public Purge setAccessToken(String accessToken) {
                        return (Purge)super.setAccessToken(accessToken);
                    }

                    public Purge setAlt(String alt) {
                        return (Purge)super.setAlt(alt);
                    }

                    public Purge setCallback(String callback) {
                        return (Purge)super.setCallback(callback);
                    }

                    public Purge setFields(String fields) {
                        return (Purge)super.setFields(fields);
                    }

                    public Purge setKey(String key) {
                        return (Purge)super.setKey(key);
                    }

                    public Purge setOauthToken(String oauthToken) {
                        return (Purge)super.setOauthToken(oauthToken);
                    }

                    public Purge setPrettyPrint(Boolean prettyPrint) {
                        return (Purge)super.setPrettyPrint(prettyPrint);
                    }

                    public Purge setQuotaUser(String quotaUser) {
                        return (Purge)super.setQuotaUser(quotaUser);
                    }

                    public Purge setUploadType(String uploadType) {
                        return (Purge)super.setUploadType(uploadType);
                    }

                    public Purge setUploadProtocol(String uploadProtocol) {
                        return (Purge)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public Purge setParent(String parent) {
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    @Override
                    public Purge set(String parameterName, Object value) {
                        return (Purge)super.set(parameterName, value);
                    }
                }

                public class Patch
                extends VisionRequest<Product> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String updateMask;

                    protected Patch(String name, Product content) {
                        super(Vision.this, "PATCH", REST_PATH, (Object)content, Product.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/products/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/products/[^/]+$");
                        }
                    }

                    public Patch set$Xgafv(String $Xgafv) {
                        return (Patch)super.set$Xgafv($Xgafv);
                    }

                    public Patch setAccessToken(String accessToken) {
                        return (Patch)super.setAccessToken(accessToken);
                    }

                    public Patch setAlt(String alt) {
                        return (Patch)super.setAlt(alt);
                    }

                    public Patch setCallback(String callback) {
                        return (Patch)super.setCallback(callback);
                    }

                    public Patch setFields(String fields) {
                        return (Patch)super.setFields(fields);
                    }

                    public Patch setKey(String key) {
                        return (Patch)super.setKey(key);
                    }

                    public Patch setOauthToken(String oauthToken) {
                        return (Patch)super.setOauthToken(oauthToken);
                    }

                    public Patch setPrettyPrint(Boolean prettyPrint) {
                        return (Patch)super.setPrettyPrint(prettyPrint);
                    }

                    public Patch setQuotaUser(String quotaUser) {
                        return (Patch)super.setQuotaUser(quotaUser);
                    }

                    public Patch setUploadType(String uploadType) {
                        return (Patch)super.setUploadType(uploadType);
                    }

                    public Patch setUploadProtocol(String uploadProtocol) {
                        return (Patch)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Patch setName(String name) {
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/products/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    public String getUpdateMask() {
                        return this.updateMask;
                    }

                    public Patch setUpdateMask(String updateMask) {
                        this.updateMask = updateMask;
                        return this;
                    }

                    @Override
                    public Patch set(String parameterName, Object value) {
                        return (Patch)super.set(parameterName, value);
                    }
                }

                public class List
                extends VisionRequest<ListProductsResponse> {
                    private static final String REST_PATH = "v1/{+parent}/products";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected List(String parent) {
                        super(Vision.this, "GET", REST_PATH, null, ListProductsResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String parent) {
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class Get
                extends VisionRequest<Product> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Get(String name) {
                        super(Vision.this, "GET", REST_PATH, null, Product.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/products/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/products/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String name) {
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/products/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class Delete
                extends VisionRequest<Empty> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Delete(String name) {
                        super(Vision.this, "DELETE", REST_PATH, null, Empty.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/products/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/products/[^/]+$");
                        }
                    }

                    public Delete set$Xgafv(String $Xgafv) {
                        return (Delete)super.set$Xgafv($Xgafv);
                    }

                    public Delete setAccessToken(String accessToken) {
                        return (Delete)super.setAccessToken(accessToken);
                    }

                    public Delete setAlt(String alt) {
                        return (Delete)super.setAlt(alt);
                    }

                    public Delete setCallback(String callback) {
                        return (Delete)super.setCallback(callback);
                    }

                    public Delete setFields(String fields) {
                        return (Delete)super.setFields(fields);
                    }

                    public Delete setKey(String key) {
                        return (Delete)super.setKey(key);
                    }

                    public Delete setOauthToken(String oauthToken) {
                        return (Delete)super.setOauthToken(oauthToken);
                    }

                    public Delete setPrettyPrint(Boolean prettyPrint) {
                        return (Delete)super.setPrettyPrint(prettyPrint);
                    }

                    public Delete setQuotaUser(String quotaUser) {
                        return (Delete)super.setQuotaUser(quotaUser);
                    }

                    public Delete setUploadType(String uploadType) {
                        return (Delete)super.setUploadType(uploadType);
                    }

                    public Delete setUploadProtocol(String uploadProtocol) {
                        return (Delete)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Delete setName(String name) {
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/products/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Delete set(String parameterName, Object value) {
                        return (Delete)super.set(parameterName, value);
                    }
                }

                public class Create
                extends VisionRequest<Product> {
                    private static final String REST_PATH = "v1/{+parent}/products";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String productId;

                    protected Create(String parent, Product content) {
                        super(Vision.this, "POST", REST_PATH, (Object)content, Product.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public Create set$Xgafv(String $Xgafv) {
                        return (Create)super.set$Xgafv($Xgafv);
                    }

                    public Create setAccessToken(String accessToken) {
                        return (Create)super.setAccessToken(accessToken);
                    }

                    public Create setAlt(String alt) {
                        return (Create)super.setAlt(alt);
                    }

                    public Create setCallback(String callback) {
                        return (Create)super.setCallback(callback);
                    }

                    public Create setFields(String fields) {
                        return (Create)super.setFields(fields);
                    }

                    public Create setKey(String key) {
                        return (Create)super.setKey(key);
                    }

                    public Create setOauthToken(String oauthToken) {
                        return (Create)super.setOauthToken(oauthToken);
                    }

                    public Create setPrettyPrint(Boolean prettyPrint) {
                        return (Create)super.setPrettyPrint(prettyPrint);
                    }

                    public Create setQuotaUser(String quotaUser) {
                        return (Create)super.setQuotaUser(quotaUser);
                    }

                    public Create setUploadType(String uploadType) {
                        return (Create)super.setUploadType(uploadType);
                    }

                    public Create setUploadProtocol(String uploadProtocol) {
                        return (Create)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public Create setParent(String parent) {
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public String getProductId() {
                        return this.productId;
                    }

                    public Create setProductId(String productId) {
                        this.productId = productId;
                        return this;
                    }

                    @Override
                    public Create set(String parameterName, Object value) {
                        return (Create)super.set(parameterName, value);
                    }
                }
            }

            public class ProductSets {
                public AddProduct addProduct(String name, AddProductToProductSetRequest content) throws IOException {
                    AddProduct result = new AddProduct(name, content);
                    Vision.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Create create(String parent, ProductSet content) throws IOException {
                    Create result = new Create(parent, content);
                    Vision.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Delete delete(String name) throws IOException {
                    Delete result = new Delete(name);
                    Vision.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(String name) throws IOException {
                    Get result = new Get(name);
                    Vision.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public VisionImport visionImport(String parent, ImportProductSetsRequest content) throws IOException {
                    VisionImport result = new VisionImport(parent, content);
                    Vision.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String parent) throws IOException {
                    List result = new List(parent);
                    Vision.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Patch patch(String name, ProductSet content) throws IOException {
                    Patch result = new Patch(name, content);
                    Vision.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public RemoveProduct removeProduct(String name, RemoveProductFromProductSetRequest content) throws IOException {
                    RemoveProduct result = new RemoveProduct(name, content);
                    Vision.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Products products() {
                    return new Products();
                }

                public class Products {
                    public List list(String name) throws IOException {
                        List result = new List(name);
                        Vision.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public class List
                    extends VisionRequest<ListProductsInProductSetResponse> {
                        private static final String REST_PATH = "v1/{+name}/products";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;
                        @Key
                        private Integer pageSize;
                        @Key
                        private String pageToken;

                        protected List(String name) {
                            super(Vision.this, "GET", REST_PATH, null, ListProductsInProductSetResponse.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/productSets/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!Vision.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/productSets/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public List set$Xgafv(String $Xgafv) {
                            return (List)super.set$Xgafv($Xgafv);
                        }

                        public List setAccessToken(String accessToken) {
                            return (List)super.setAccessToken(accessToken);
                        }

                        public List setAlt(String alt) {
                            return (List)super.setAlt(alt);
                        }

                        public List setCallback(String callback) {
                            return (List)super.setCallback(callback);
                        }

                        public List setFields(String fields) {
                            return (List)super.setFields(fields);
                        }

                        public List setKey(String key) {
                            return (List)super.setKey(key);
                        }

                        public List setOauthToken(String oauthToken) {
                            return (List)super.setOauthToken(oauthToken);
                        }

                        public List setPrettyPrint(Boolean prettyPrint) {
                            return (List)super.setPrettyPrint(prettyPrint);
                        }

                        public List setQuotaUser(String quotaUser) {
                            return (List)super.setQuotaUser(quotaUser);
                        }

                        public List setUploadType(String uploadType) {
                            return (List)super.setUploadType(uploadType);
                        }

                        public List setUploadProtocol(String uploadProtocol) {
                            return (List)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public List setName(String name) {
                            if (!Vision.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/productSets/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        public Integer getPageSize() {
                            return this.pageSize;
                        }

                        public List setPageSize(Integer pageSize) {
                            this.pageSize = pageSize;
                            return this;
                        }

                        public String getPageToken() {
                            return this.pageToken;
                        }

                        public List setPageToken(String pageToken) {
                            this.pageToken = pageToken;
                            return this;
                        }

                        @Override
                        public List set(String parameterName, Object value) {
                            return (List)super.set(parameterName, value);
                        }
                    }
                }

                public class RemoveProduct
                extends VisionRequest<Empty> {
                    private static final String REST_PATH = "v1/{+name}:removeProduct";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected RemoveProduct(String name, RemoveProductFromProductSetRequest content) {
                        super(Vision.this, "POST", REST_PATH, (Object)content, Empty.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/productSets/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/productSets/[^/]+$");
                        }
                    }

                    public RemoveProduct set$Xgafv(String $Xgafv) {
                        return (RemoveProduct)super.set$Xgafv($Xgafv);
                    }

                    public RemoveProduct setAccessToken(String accessToken) {
                        return (RemoveProduct)super.setAccessToken(accessToken);
                    }

                    public RemoveProduct setAlt(String alt) {
                        return (RemoveProduct)super.setAlt(alt);
                    }

                    public RemoveProduct setCallback(String callback) {
                        return (RemoveProduct)super.setCallback(callback);
                    }

                    public RemoveProduct setFields(String fields) {
                        return (RemoveProduct)super.setFields(fields);
                    }

                    public RemoveProduct setKey(String key) {
                        return (RemoveProduct)super.setKey(key);
                    }

                    public RemoveProduct setOauthToken(String oauthToken) {
                        return (RemoveProduct)super.setOauthToken(oauthToken);
                    }

                    public RemoveProduct setPrettyPrint(Boolean prettyPrint) {
                        return (RemoveProduct)super.setPrettyPrint(prettyPrint);
                    }

                    public RemoveProduct setQuotaUser(String quotaUser) {
                        return (RemoveProduct)super.setQuotaUser(quotaUser);
                    }

                    public RemoveProduct setUploadType(String uploadType) {
                        return (RemoveProduct)super.setUploadType(uploadType);
                    }

                    public RemoveProduct setUploadProtocol(String uploadProtocol) {
                        return (RemoveProduct)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public RemoveProduct setName(String name) {
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/productSets/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public RemoveProduct set(String parameterName, Object value) {
                        return (RemoveProduct)super.set(parameterName, value);
                    }
                }

                public class Patch
                extends VisionRequest<ProductSet> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String updateMask;

                    protected Patch(String name, ProductSet content) {
                        super(Vision.this, "PATCH", REST_PATH, (Object)content, ProductSet.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/productSets/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/productSets/[^/]+$");
                        }
                    }

                    public Patch set$Xgafv(String $Xgafv) {
                        return (Patch)super.set$Xgafv($Xgafv);
                    }

                    public Patch setAccessToken(String accessToken) {
                        return (Patch)super.setAccessToken(accessToken);
                    }

                    public Patch setAlt(String alt) {
                        return (Patch)super.setAlt(alt);
                    }

                    public Patch setCallback(String callback) {
                        return (Patch)super.setCallback(callback);
                    }

                    public Patch setFields(String fields) {
                        return (Patch)super.setFields(fields);
                    }

                    public Patch setKey(String key) {
                        return (Patch)super.setKey(key);
                    }

                    public Patch setOauthToken(String oauthToken) {
                        return (Patch)super.setOauthToken(oauthToken);
                    }

                    public Patch setPrettyPrint(Boolean prettyPrint) {
                        return (Patch)super.setPrettyPrint(prettyPrint);
                    }

                    public Patch setQuotaUser(String quotaUser) {
                        return (Patch)super.setQuotaUser(quotaUser);
                    }

                    public Patch setUploadType(String uploadType) {
                        return (Patch)super.setUploadType(uploadType);
                    }

                    public Patch setUploadProtocol(String uploadProtocol) {
                        return (Patch)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Patch setName(String name) {
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/productSets/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    public String getUpdateMask() {
                        return this.updateMask;
                    }

                    public Patch setUpdateMask(String updateMask) {
                        this.updateMask = updateMask;
                        return this;
                    }

                    @Override
                    public Patch set(String parameterName, Object value) {
                        return (Patch)super.set(parameterName, value);
                    }
                }

                public class List
                extends VisionRequest<ListProductSetsResponse> {
                    private static final String REST_PATH = "v1/{+parent}/productSets";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected List(String parent) {
                        super(Vision.this, "GET", REST_PATH, null, ListProductSetsResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String parent) {
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class VisionImport
                extends VisionRequest<Operation> {
                    private static final String REST_PATH = "v1/{+parent}/productSets:import";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;

                    protected VisionImport(String parent, ImportProductSetsRequest content) {
                        super(Vision.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public VisionImport set$Xgafv(String $Xgafv) {
                        return (VisionImport)super.set$Xgafv($Xgafv);
                    }

                    public VisionImport setAccessToken(String accessToken) {
                        return (VisionImport)super.setAccessToken(accessToken);
                    }

                    public VisionImport setAlt(String alt) {
                        return (VisionImport)super.setAlt(alt);
                    }

                    public VisionImport setCallback(String callback) {
                        return (VisionImport)super.setCallback(callback);
                    }

                    public VisionImport setFields(String fields) {
                        return (VisionImport)super.setFields(fields);
                    }

                    public VisionImport setKey(String key) {
                        return (VisionImport)super.setKey(key);
                    }

                    public VisionImport setOauthToken(String oauthToken) {
                        return (VisionImport)super.setOauthToken(oauthToken);
                    }

                    public VisionImport setPrettyPrint(Boolean prettyPrint) {
                        return (VisionImport)super.setPrettyPrint(prettyPrint);
                    }

                    public VisionImport setQuotaUser(String quotaUser) {
                        return (VisionImport)super.setQuotaUser(quotaUser);
                    }

                    public VisionImport setUploadType(String uploadType) {
                        return (VisionImport)super.setUploadType(uploadType);
                    }

                    public VisionImport setUploadProtocol(String uploadProtocol) {
                        return (VisionImport)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public VisionImport setParent(String parent) {
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    @Override
                    public VisionImport set(String parameterName, Object value) {
                        return (VisionImport)super.set(parameterName, value);
                    }
                }

                public class Get
                extends VisionRequest<ProductSet> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Get(String name) {
                        super(Vision.this, "GET", REST_PATH, null, ProductSet.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/productSets/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/productSets/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String name) {
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/productSets/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class Delete
                extends VisionRequest<Empty> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Delete(String name) {
                        super(Vision.this, "DELETE", REST_PATH, null, Empty.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/productSets/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/productSets/[^/]+$");
                        }
                    }

                    public Delete set$Xgafv(String $Xgafv) {
                        return (Delete)super.set$Xgafv($Xgafv);
                    }

                    public Delete setAccessToken(String accessToken) {
                        return (Delete)super.setAccessToken(accessToken);
                    }

                    public Delete setAlt(String alt) {
                        return (Delete)super.setAlt(alt);
                    }

                    public Delete setCallback(String callback) {
                        return (Delete)super.setCallback(callback);
                    }

                    public Delete setFields(String fields) {
                        return (Delete)super.setFields(fields);
                    }

                    public Delete setKey(String key) {
                        return (Delete)super.setKey(key);
                    }

                    public Delete setOauthToken(String oauthToken) {
                        return (Delete)super.setOauthToken(oauthToken);
                    }

                    public Delete setPrettyPrint(Boolean prettyPrint) {
                        return (Delete)super.setPrettyPrint(prettyPrint);
                    }

                    public Delete setQuotaUser(String quotaUser) {
                        return (Delete)super.setQuotaUser(quotaUser);
                    }

                    public Delete setUploadType(String uploadType) {
                        return (Delete)super.setUploadType(uploadType);
                    }

                    public Delete setUploadProtocol(String uploadProtocol) {
                        return (Delete)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Delete setName(String name) {
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/productSets/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Delete set(String parameterName, Object value) {
                        return (Delete)super.set(parameterName, value);
                    }
                }

                public class Create
                extends VisionRequest<ProductSet> {
                    private static final String REST_PATH = "v1/{+parent}/productSets";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String productSetId;

                    protected Create(String parent, ProductSet content) {
                        super(Vision.this, "POST", REST_PATH, (Object)content, ProductSet.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public Create set$Xgafv(String $Xgafv) {
                        return (Create)super.set$Xgafv($Xgafv);
                    }

                    public Create setAccessToken(String accessToken) {
                        return (Create)super.setAccessToken(accessToken);
                    }

                    public Create setAlt(String alt) {
                        return (Create)super.setAlt(alt);
                    }

                    public Create setCallback(String callback) {
                        return (Create)super.setCallback(callback);
                    }

                    public Create setFields(String fields) {
                        return (Create)super.setFields(fields);
                    }

                    public Create setKey(String key) {
                        return (Create)super.setKey(key);
                    }

                    public Create setOauthToken(String oauthToken) {
                        return (Create)super.setOauthToken(oauthToken);
                    }

                    public Create setPrettyPrint(Boolean prettyPrint) {
                        return (Create)super.setPrettyPrint(prettyPrint);
                    }

                    public Create setQuotaUser(String quotaUser) {
                        return (Create)super.setQuotaUser(quotaUser);
                    }

                    public Create setUploadType(String uploadType) {
                        return (Create)super.setUploadType(uploadType);
                    }

                    public Create setUploadProtocol(String uploadProtocol) {
                        return (Create)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public Create setParent(String parent) {
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public String getProductSetId() {
                        return this.productSetId;
                    }

                    public Create setProductSetId(String productSetId) {
                        this.productSetId = productSetId;
                        return this;
                    }

                    @Override
                    public Create set(String parameterName, Object value) {
                        return (Create)super.set(parameterName, value);
                    }
                }

                public class AddProduct
                extends VisionRequest<Empty> {
                    private static final String REST_PATH = "v1/{+name}:addProduct";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected AddProduct(String name, AddProductToProductSetRequest content) {
                        super(Vision.this, "POST", REST_PATH, (Object)content, Empty.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/productSets/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/productSets/[^/]+$");
                        }
                    }

                    public AddProduct set$Xgafv(String $Xgafv) {
                        return (AddProduct)super.set$Xgafv($Xgafv);
                    }

                    public AddProduct setAccessToken(String accessToken) {
                        return (AddProduct)super.setAccessToken(accessToken);
                    }

                    public AddProduct setAlt(String alt) {
                        return (AddProduct)super.setAlt(alt);
                    }

                    public AddProduct setCallback(String callback) {
                        return (AddProduct)super.setCallback(callback);
                    }

                    public AddProduct setFields(String fields) {
                        return (AddProduct)super.setFields(fields);
                    }

                    public AddProduct setKey(String key) {
                        return (AddProduct)super.setKey(key);
                    }

                    public AddProduct setOauthToken(String oauthToken) {
                        return (AddProduct)super.setOauthToken(oauthToken);
                    }

                    public AddProduct setPrettyPrint(Boolean prettyPrint) {
                        return (AddProduct)super.setPrettyPrint(prettyPrint);
                    }

                    public AddProduct setQuotaUser(String quotaUser) {
                        return (AddProduct)super.setQuotaUser(quotaUser);
                    }

                    public AddProduct setUploadType(String uploadType) {
                        return (AddProduct)super.setUploadType(uploadType);
                    }

                    public AddProduct setUploadProtocol(String uploadProtocol) {
                        return (AddProduct)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public AddProduct setName(String name) {
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/productSets/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public AddProduct set(String parameterName, Object value) {
                        return (AddProduct)super.set(parameterName, value);
                    }
                }
            }

            public class Operations {
                public Get get(String name) throws IOException {
                    Get result = new Get(name);
                    Vision.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class Get
                extends VisionRequest<Operation> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Get(String name) {
                        super(Vision.this, "GET", REST_PATH, null, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String name) {
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }
            }

            public class Images {
                public Annotate annotate(String parent, BatchAnnotateImagesRequest content) throws IOException {
                    Annotate result = new Annotate(parent, content);
                    Vision.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public AsyncBatchAnnotate asyncBatchAnnotate(String parent, AsyncBatchAnnotateImagesRequest content) throws IOException {
                    AsyncBatchAnnotate result = new AsyncBatchAnnotate(parent, content);
                    Vision.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class AsyncBatchAnnotate
                extends VisionRequest<Operation> {
                    private static final String REST_PATH = "v1/{+parent}/images:asyncBatchAnnotate";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;

                    protected AsyncBatchAnnotate(String parent, AsyncBatchAnnotateImagesRequest content) {
                        super(Vision.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public AsyncBatchAnnotate set$Xgafv(String $Xgafv) {
                        return (AsyncBatchAnnotate)super.set$Xgafv($Xgafv);
                    }

                    public AsyncBatchAnnotate setAccessToken(String accessToken) {
                        return (AsyncBatchAnnotate)super.setAccessToken(accessToken);
                    }

                    public AsyncBatchAnnotate setAlt(String alt) {
                        return (AsyncBatchAnnotate)super.setAlt(alt);
                    }

                    public AsyncBatchAnnotate setCallback(String callback) {
                        return (AsyncBatchAnnotate)super.setCallback(callback);
                    }

                    public AsyncBatchAnnotate setFields(String fields) {
                        return (AsyncBatchAnnotate)super.setFields(fields);
                    }

                    public AsyncBatchAnnotate setKey(String key) {
                        return (AsyncBatchAnnotate)super.setKey(key);
                    }

                    public AsyncBatchAnnotate setOauthToken(String oauthToken) {
                        return (AsyncBatchAnnotate)super.setOauthToken(oauthToken);
                    }

                    public AsyncBatchAnnotate setPrettyPrint(Boolean prettyPrint) {
                        return (AsyncBatchAnnotate)super.setPrettyPrint(prettyPrint);
                    }

                    public AsyncBatchAnnotate setQuotaUser(String quotaUser) {
                        return (AsyncBatchAnnotate)super.setQuotaUser(quotaUser);
                    }

                    public AsyncBatchAnnotate setUploadType(String uploadType) {
                        return (AsyncBatchAnnotate)super.setUploadType(uploadType);
                    }

                    public AsyncBatchAnnotate setUploadProtocol(String uploadProtocol) {
                        return (AsyncBatchAnnotate)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public AsyncBatchAnnotate setParent(String parent) {
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    @Override
                    public AsyncBatchAnnotate set(String parameterName, Object value) {
                        return (AsyncBatchAnnotate)super.set(parameterName, value);
                    }
                }

                public class Annotate
                extends VisionRequest<BatchAnnotateImagesResponse> {
                    private static final String REST_PATH = "v1/{+parent}/images:annotate";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;

                    protected Annotate(String parent, BatchAnnotateImagesRequest content) {
                        super(Vision.this, "POST", REST_PATH, (Object)content, BatchAnnotateImagesResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public Annotate set$Xgafv(String $Xgafv) {
                        return (Annotate)super.set$Xgafv($Xgafv);
                    }

                    public Annotate setAccessToken(String accessToken) {
                        return (Annotate)super.setAccessToken(accessToken);
                    }

                    public Annotate setAlt(String alt) {
                        return (Annotate)super.setAlt(alt);
                    }

                    public Annotate setCallback(String callback) {
                        return (Annotate)super.setCallback(callback);
                    }

                    public Annotate setFields(String fields) {
                        return (Annotate)super.setFields(fields);
                    }

                    public Annotate setKey(String key) {
                        return (Annotate)super.setKey(key);
                    }

                    public Annotate setOauthToken(String oauthToken) {
                        return (Annotate)super.setOauthToken(oauthToken);
                    }

                    public Annotate setPrettyPrint(Boolean prettyPrint) {
                        return (Annotate)super.setPrettyPrint(prettyPrint);
                    }

                    public Annotate setQuotaUser(String quotaUser) {
                        return (Annotate)super.setQuotaUser(quotaUser);
                    }

                    public Annotate setUploadType(String uploadType) {
                        return (Annotate)super.setUploadType(uploadType);
                    }

                    public Annotate setUploadProtocol(String uploadProtocol) {
                        return (Annotate)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public Annotate setParent(String parent) {
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    @Override
                    public Annotate set(String parameterName, Object value) {
                        return (Annotate)super.set(parameterName, value);
                    }
                }
            }

            public class Files {
                public Annotate annotate(String parent, BatchAnnotateFilesRequest content) throws IOException {
                    Annotate result = new Annotate(parent, content);
                    Vision.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public AsyncBatchAnnotate asyncBatchAnnotate(String parent, AsyncBatchAnnotateFilesRequest content) throws IOException {
                    AsyncBatchAnnotate result = new AsyncBatchAnnotate(parent, content);
                    Vision.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class AsyncBatchAnnotate
                extends VisionRequest<Operation> {
                    private static final String REST_PATH = "v1/{+parent}/files:asyncBatchAnnotate";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;

                    protected AsyncBatchAnnotate(String parent, AsyncBatchAnnotateFilesRequest content) {
                        super(Vision.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public AsyncBatchAnnotate set$Xgafv(String $Xgafv) {
                        return (AsyncBatchAnnotate)super.set$Xgafv($Xgafv);
                    }

                    public AsyncBatchAnnotate setAccessToken(String accessToken) {
                        return (AsyncBatchAnnotate)super.setAccessToken(accessToken);
                    }

                    public AsyncBatchAnnotate setAlt(String alt) {
                        return (AsyncBatchAnnotate)super.setAlt(alt);
                    }

                    public AsyncBatchAnnotate setCallback(String callback) {
                        return (AsyncBatchAnnotate)super.setCallback(callback);
                    }

                    public AsyncBatchAnnotate setFields(String fields) {
                        return (AsyncBatchAnnotate)super.setFields(fields);
                    }

                    public AsyncBatchAnnotate setKey(String key) {
                        return (AsyncBatchAnnotate)super.setKey(key);
                    }

                    public AsyncBatchAnnotate setOauthToken(String oauthToken) {
                        return (AsyncBatchAnnotate)super.setOauthToken(oauthToken);
                    }

                    public AsyncBatchAnnotate setPrettyPrint(Boolean prettyPrint) {
                        return (AsyncBatchAnnotate)super.setPrettyPrint(prettyPrint);
                    }

                    public AsyncBatchAnnotate setQuotaUser(String quotaUser) {
                        return (AsyncBatchAnnotate)super.setQuotaUser(quotaUser);
                    }

                    public AsyncBatchAnnotate setUploadType(String uploadType) {
                        return (AsyncBatchAnnotate)super.setUploadType(uploadType);
                    }

                    public AsyncBatchAnnotate setUploadProtocol(String uploadProtocol) {
                        return (AsyncBatchAnnotate)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public AsyncBatchAnnotate setParent(String parent) {
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    @Override
                    public AsyncBatchAnnotate set(String parameterName, Object value) {
                        return (AsyncBatchAnnotate)super.set(parameterName, value);
                    }
                }

                public class Annotate
                extends VisionRequest<BatchAnnotateFilesResponse> {
                    private static final String REST_PATH = "v1/{+parent}/files:annotate";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;

                    protected Annotate(String parent, BatchAnnotateFilesRequest content) {
                        super(Vision.this, "POST", REST_PATH, (Object)content, BatchAnnotateFilesResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public Annotate set$Xgafv(String $Xgafv) {
                        return (Annotate)super.set$Xgafv($Xgafv);
                    }

                    public Annotate setAccessToken(String accessToken) {
                        return (Annotate)super.setAccessToken(accessToken);
                    }

                    public Annotate setAlt(String alt) {
                        return (Annotate)super.setAlt(alt);
                    }

                    public Annotate setCallback(String callback) {
                        return (Annotate)super.setCallback(callback);
                    }

                    public Annotate setFields(String fields) {
                        return (Annotate)super.setFields(fields);
                    }

                    public Annotate setKey(String key) {
                        return (Annotate)super.setKey(key);
                    }

                    public Annotate setOauthToken(String oauthToken) {
                        return (Annotate)super.setOauthToken(oauthToken);
                    }

                    public Annotate setPrettyPrint(Boolean prettyPrint) {
                        return (Annotate)super.setPrettyPrint(prettyPrint);
                    }

                    public Annotate setQuotaUser(String quotaUser) {
                        return (Annotate)super.setQuotaUser(quotaUser);
                    }

                    public Annotate setUploadType(String uploadType) {
                        return (Annotate)super.setUploadType(uploadType);
                    }

                    public Annotate setUploadProtocol(String uploadProtocol) {
                        return (Annotate)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public Annotate setParent(String parent) {
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    @Override
                    public Annotate set(String parameterName, Object value) {
                        return (Annotate)super.set(parameterName, value);
                    }
                }
            }
        }

        public class Images {
            public Annotate annotate(String parent, BatchAnnotateImagesRequest content) throws IOException {
                Annotate result = new Annotate(parent, content);
                Vision.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public AsyncBatchAnnotate asyncBatchAnnotate(String parent, AsyncBatchAnnotateImagesRequest content) throws IOException {
                AsyncBatchAnnotate result = new AsyncBatchAnnotate(parent, content);
                Vision.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class AsyncBatchAnnotate
            extends VisionRequest<Operation> {
                private static final String REST_PATH = "v1/{+parent}/images:asyncBatchAnnotate";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected AsyncBatchAnnotate(String parent, AsyncBatchAnnotateImagesRequest content) {
                    super(Vision.this, "POST", REST_PATH, (Object)content, Operation.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!Vision.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public AsyncBatchAnnotate set$Xgafv(String $Xgafv) {
                    return (AsyncBatchAnnotate)super.set$Xgafv($Xgafv);
                }

                public AsyncBatchAnnotate setAccessToken(String accessToken) {
                    return (AsyncBatchAnnotate)super.setAccessToken(accessToken);
                }

                public AsyncBatchAnnotate setAlt(String alt) {
                    return (AsyncBatchAnnotate)super.setAlt(alt);
                }

                public AsyncBatchAnnotate setCallback(String callback) {
                    return (AsyncBatchAnnotate)super.setCallback(callback);
                }

                public AsyncBatchAnnotate setFields(String fields) {
                    return (AsyncBatchAnnotate)super.setFields(fields);
                }

                public AsyncBatchAnnotate setKey(String key) {
                    return (AsyncBatchAnnotate)super.setKey(key);
                }

                public AsyncBatchAnnotate setOauthToken(String oauthToken) {
                    return (AsyncBatchAnnotate)super.setOauthToken(oauthToken);
                }

                public AsyncBatchAnnotate setPrettyPrint(Boolean prettyPrint) {
                    return (AsyncBatchAnnotate)super.setPrettyPrint(prettyPrint);
                }

                public AsyncBatchAnnotate setQuotaUser(String quotaUser) {
                    return (AsyncBatchAnnotate)super.setQuotaUser(quotaUser);
                }

                public AsyncBatchAnnotate setUploadType(String uploadType) {
                    return (AsyncBatchAnnotate)super.setUploadType(uploadType);
                }

                public AsyncBatchAnnotate setUploadProtocol(String uploadProtocol) {
                    return (AsyncBatchAnnotate)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public AsyncBatchAnnotate setParent(String parent) {
                    if (!Vision.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                @Override
                public AsyncBatchAnnotate set(String parameterName, Object value) {
                    return (AsyncBatchAnnotate)super.set(parameterName, value);
                }
            }

            public class Annotate
            extends VisionRequest<BatchAnnotateImagesResponse> {
                private static final String REST_PATH = "v1/{+parent}/images:annotate";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected Annotate(String parent, BatchAnnotateImagesRequest content) {
                    super(Vision.this, "POST", REST_PATH, (Object)content, BatchAnnotateImagesResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!Vision.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public Annotate set$Xgafv(String $Xgafv) {
                    return (Annotate)super.set$Xgafv($Xgafv);
                }

                public Annotate setAccessToken(String accessToken) {
                    return (Annotate)super.setAccessToken(accessToken);
                }

                public Annotate setAlt(String alt) {
                    return (Annotate)super.setAlt(alt);
                }

                public Annotate setCallback(String callback) {
                    return (Annotate)super.setCallback(callback);
                }

                public Annotate setFields(String fields) {
                    return (Annotate)super.setFields(fields);
                }

                public Annotate setKey(String key) {
                    return (Annotate)super.setKey(key);
                }

                public Annotate setOauthToken(String oauthToken) {
                    return (Annotate)super.setOauthToken(oauthToken);
                }

                public Annotate setPrettyPrint(Boolean prettyPrint) {
                    return (Annotate)super.setPrettyPrint(prettyPrint);
                }

                public Annotate setQuotaUser(String quotaUser) {
                    return (Annotate)super.setQuotaUser(quotaUser);
                }

                public Annotate setUploadType(String uploadType) {
                    return (Annotate)super.setUploadType(uploadType);
                }

                public Annotate setUploadProtocol(String uploadProtocol) {
                    return (Annotate)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public Annotate setParent(String parent) {
                    if (!Vision.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                @Override
                public Annotate set(String parameterName, Object value) {
                    return (Annotate)super.set(parameterName, value);
                }
            }
        }

        public class Files {
            public Annotate annotate(String parent, BatchAnnotateFilesRequest content) throws IOException {
                Annotate result = new Annotate(parent, content);
                Vision.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public AsyncBatchAnnotate asyncBatchAnnotate(String parent, AsyncBatchAnnotateFilesRequest content) throws IOException {
                AsyncBatchAnnotate result = new AsyncBatchAnnotate(parent, content);
                Vision.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class AsyncBatchAnnotate
            extends VisionRequest<Operation> {
                private static final String REST_PATH = "v1/{+parent}/files:asyncBatchAnnotate";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected AsyncBatchAnnotate(String parent, AsyncBatchAnnotateFilesRequest content) {
                    super(Vision.this, "POST", REST_PATH, (Object)content, Operation.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!Vision.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public AsyncBatchAnnotate set$Xgafv(String $Xgafv) {
                    return (AsyncBatchAnnotate)super.set$Xgafv($Xgafv);
                }

                public AsyncBatchAnnotate setAccessToken(String accessToken) {
                    return (AsyncBatchAnnotate)super.setAccessToken(accessToken);
                }

                public AsyncBatchAnnotate setAlt(String alt) {
                    return (AsyncBatchAnnotate)super.setAlt(alt);
                }

                public AsyncBatchAnnotate setCallback(String callback) {
                    return (AsyncBatchAnnotate)super.setCallback(callback);
                }

                public AsyncBatchAnnotate setFields(String fields) {
                    return (AsyncBatchAnnotate)super.setFields(fields);
                }

                public AsyncBatchAnnotate setKey(String key) {
                    return (AsyncBatchAnnotate)super.setKey(key);
                }

                public AsyncBatchAnnotate setOauthToken(String oauthToken) {
                    return (AsyncBatchAnnotate)super.setOauthToken(oauthToken);
                }

                public AsyncBatchAnnotate setPrettyPrint(Boolean prettyPrint) {
                    return (AsyncBatchAnnotate)super.setPrettyPrint(prettyPrint);
                }

                public AsyncBatchAnnotate setQuotaUser(String quotaUser) {
                    return (AsyncBatchAnnotate)super.setQuotaUser(quotaUser);
                }

                public AsyncBatchAnnotate setUploadType(String uploadType) {
                    return (AsyncBatchAnnotate)super.setUploadType(uploadType);
                }

                public AsyncBatchAnnotate setUploadProtocol(String uploadProtocol) {
                    return (AsyncBatchAnnotate)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public AsyncBatchAnnotate setParent(String parent) {
                    if (!Vision.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                @Override
                public AsyncBatchAnnotate set(String parameterName, Object value) {
                    return (AsyncBatchAnnotate)super.set(parameterName, value);
                }
            }

            public class Annotate
            extends VisionRequest<BatchAnnotateFilesResponse> {
                private static final String REST_PATH = "v1/{+parent}/files:annotate";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected Annotate(String parent, BatchAnnotateFilesRequest content) {
                    super(Vision.this, "POST", REST_PATH, (Object)content, BatchAnnotateFilesResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!Vision.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public Annotate set$Xgafv(String $Xgafv) {
                    return (Annotate)super.set$Xgafv($Xgafv);
                }

                public Annotate setAccessToken(String accessToken) {
                    return (Annotate)super.setAccessToken(accessToken);
                }

                public Annotate setAlt(String alt) {
                    return (Annotate)super.setAlt(alt);
                }

                public Annotate setCallback(String callback) {
                    return (Annotate)super.setCallback(callback);
                }

                public Annotate setFields(String fields) {
                    return (Annotate)super.setFields(fields);
                }

                public Annotate setKey(String key) {
                    return (Annotate)super.setKey(key);
                }

                public Annotate setOauthToken(String oauthToken) {
                    return (Annotate)super.setOauthToken(oauthToken);
                }

                public Annotate setPrettyPrint(Boolean prettyPrint) {
                    return (Annotate)super.setPrettyPrint(prettyPrint);
                }

                public Annotate setQuotaUser(String quotaUser) {
                    return (Annotate)super.setQuotaUser(quotaUser);
                }

                public Annotate setUploadType(String uploadType) {
                    return (Annotate)super.setUploadType(uploadType);
                }

                public Annotate setUploadProtocol(String uploadProtocol) {
                    return (Annotate)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public Annotate setParent(String parent) {
                    if (!Vision.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                @Override
                public Annotate set(String parameterName, Object value) {
                    return (Annotate)super.set(parameterName, value);
                }
            }
        }
    }

    public class Operations {
        public Cancel cancel(String name, CancelOperationRequest content) throws IOException {
            Cancel result = new Cancel(name, content);
            Vision.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(String name) throws IOException {
            Delete result = new Delete(name);
            Vision.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String name) throws IOException {
            Get result = new Get(name);
            Vision.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String name) throws IOException {
            List result = new List(name);
            Vision.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends VisionRequest<ListOperationsResponse> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;
            @Key
            private String filter;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;

            protected List(String name) {
                super(Vision.this, "GET", REST_PATH, null, ListOperationsResponse.class);
                this.NAME_PATTERN = Pattern.compile("^operations$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!Vision.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^operations$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public List setName(String name) {
                if (!Vision.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^operations$");
                }
                this.name = name;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends VisionRequest<Operation> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Get(String name) {
                super(Vision.this, "GET", REST_PATH, null, Operation.class);
                this.NAME_PATTERN = Pattern.compile("^operations/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!Vision.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^operations/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Get setName(String name) {
                if (!Vision.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^operations/[^/]+$");
                }
                this.name = name;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends VisionRequest<Empty> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Delete(String name) {
                super(Vision.this, "DELETE", REST_PATH, null, Empty.class);
                this.NAME_PATTERN = Pattern.compile("^operations/.*$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!Vision.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^operations/.*$");
                }
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Delete setName(String name) {
                if (!Vision.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^operations/.*$");
                }
                this.name = name;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Cancel
        extends VisionRequest<Empty> {
            private static final String REST_PATH = "v1/{+name}:cancel";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Cancel(String name, CancelOperationRequest content) {
                super(Vision.this, "POST", REST_PATH, (Object)content, Empty.class);
                this.NAME_PATTERN = Pattern.compile("^operations/.*$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!Vision.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^operations/.*$");
                }
            }

            public Cancel set$Xgafv(String $Xgafv) {
                return (Cancel)super.set$Xgafv($Xgafv);
            }

            public Cancel setAccessToken(String accessToken) {
                return (Cancel)super.setAccessToken(accessToken);
            }

            public Cancel setAlt(String alt) {
                return (Cancel)super.setAlt(alt);
            }

            public Cancel setCallback(String callback) {
                return (Cancel)super.setCallback(callback);
            }

            public Cancel setFields(String fields) {
                return (Cancel)super.setFields(fields);
            }

            public Cancel setKey(String key) {
                return (Cancel)super.setKey(key);
            }

            public Cancel setOauthToken(String oauthToken) {
                return (Cancel)super.setOauthToken(oauthToken);
            }

            public Cancel setPrettyPrint(Boolean prettyPrint) {
                return (Cancel)super.setPrettyPrint(prettyPrint);
            }

            public Cancel setQuotaUser(String quotaUser) {
                return (Cancel)super.setQuotaUser(quotaUser);
            }

            public Cancel setUploadType(String uploadType) {
                return (Cancel)super.setUploadType(uploadType);
            }

            public Cancel setUploadProtocol(String uploadProtocol) {
                return (Cancel)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Cancel setName(String name) {
                if (!Vision.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^operations/.*$");
                }
                this.name = name;
                return this;
            }

            @Override
            public Cancel set(String parameterName, Object value) {
                return (Cancel)super.set(parameterName, value);
            }
        }
    }

    public class Locations {
        public Operations operations() {
            return new Operations();
        }

        public class Operations {
            public Get get(String name) throws IOException {
                Get result = new Get(name);
                Vision.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Get
            extends VisionRequest<Operation> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String name) {
                    super(Vision.this, "GET", REST_PATH, null, Operation.class);
                    this.NAME_PATTERN = Pattern.compile("^locations/[^/]+/operations/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Vision.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^locations/[^/]+/operations/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String name) {
                    if (!Vision.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^locations/[^/]+/operations/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }
        }
    }

    public class Images {
        public Annotate annotate(BatchAnnotateImagesRequest content) throws IOException {
            Annotate result = new Annotate(content);
            Vision.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public AsyncBatchAnnotate asyncBatchAnnotate(AsyncBatchAnnotateImagesRequest content) throws IOException {
            AsyncBatchAnnotate result = new AsyncBatchAnnotate(content);
            Vision.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class AsyncBatchAnnotate
        extends VisionRequest<Operation> {
            private static final String REST_PATH = "v1/images:asyncBatchAnnotate";

            protected AsyncBatchAnnotate(AsyncBatchAnnotateImagesRequest content) {
                super(Vision.this, "POST", REST_PATH, (Object)content, Operation.class);
            }

            public AsyncBatchAnnotate set$Xgafv(String $Xgafv) {
                return (AsyncBatchAnnotate)super.set$Xgafv($Xgafv);
            }

            public AsyncBatchAnnotate setAccessToken(String accessToken) {
                return (AsyncBatchAnnotate)super.setAccessToken(accessToken);
            }

            public AsyncBatchAnnotate setAlt(String alt) {
                return (AsyncBatchAnnotate)super.setAlt(alt);
            }

            public AsyncBatchAnnotate setCallback(String callback) {
                return (AsyncBatchAnnotate)super.setCallback(callback);
            }

            public AsyncBatchAnnotate setFields(String fields) {
                return (AsyncBatchAnnotate)super.setFields(fields);
            }

            public AsyncBatchAnnotate setKey(String key) {
                return (AsyncBatchAnnotate)super.setKey(key);
            }

            public AsyncBatchAnnotate setOauthToken(String oauthToken) {
                return (AsyncBatchAnnotate)super.setOauthToken(oauthToken);
            }

            public AsyncBatchAnnotate setPrettyPrint(Boolean prettyPrint) {
                return (AsyncBatchAnnotate)super.setPrettyPrint(prettyPrint);
            }

            public AsyncBatchAnnotate setQuotaUser(String quotaUser) {
                return (AsyncBatchAnnotate)super.setQuotaUser(quotaUser);
            }

            public AsyncBatchAnnotate setUploadType(String uploadType) {
                return (AsyncBatchAnnotate)super.setUploadType(uploadType);
            }

            public AsyncBatchAnnotate setUploadProtocol(String uploadProtocol) {
                return (AsyncBatchAnnotate)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public AsyncBatchAnnotate set(String parameterName, Object value) {
                return (AsyncBatchAnnotate)super.set(parameterName, value);
            }
        }

        public class Annotate
        extends VisionRequest<BatchAnnotateImagesResponse> {
            private static final String REST_PATH = "v1/images:annotate";

            protected Annotate(BatchAnnotateImagesRequest content) {
                super(Vision.this, "POST", REST_PATH, (Object)content, BatchAnnotateImagesResponse.class);
            }

            public Annotate set$Xgafv(String $Xgafv) {
                return (Annotate)super.set$Xgafv($Xgafv);
            }

            public Annotate setAccessToken(String accessToken) {
                return (Annotate)super.setAccessToken(accessToken);
            }

            public Annotate setAlt(String alt) {
                return (Annotate)super.setAlt(alt);
            }

            public Annotate setCallback(String callback) {
                return (Annotate)super.setCallback(callback);
            }

            public Annotate setFields(String fields) {
                return (Annotate)super.setFields(fields);
            }

            public Annotate setKey(String key) {
                return (Annotate)super.setKey(key);
            }

            public Annotate setOauthToken(String oauthToken) {
                return (Annotate)super.setOauthToken(oauthToken);
            }

            public Annotate setPrettyPrint(Boolean prettyPrint) {
                return (Annotate)super.setPrettyPrint(prettyPrint);
            }

            public Annotate setQuotaUser(String quotaUser) {
                return (Annotate)super.setQuotaUser(quotaUser);
            }

            public Annotate setUploadType(String uploadType) {
                return (Annotate)super.setUploadType(uploadType);
            }

            public Annotate setUploadProtocol(String uploadProtocol) {
                return (Annotate)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Annotate set(String parameterName, Object value) {
                return (Annotate)super.set(parameterName, value);
            }
        }
    }

    public class Files {
        public Annotate annotate(BatchAnnotateFilesRequest content) throws IOException {
            Annotate result = new Annotate(content);
            Vision.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public AsyncBatchAnnotate asyncBatchAnnotate(AsyncBatchAnnotateFilesRequest content) throws IOException {
            AsyncBatchAnnotate result = new AsyncBatchAnnotate(content);
            Vision.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class AsyncBatchAnnotate
        extends VisionRequest<Operation> {
            private static final String REST_PATH = "v1/files:asyncBatchAnnotate";

            protected AsyncBatchAnnotate(AsyncBatchAnnotateFilesRequest content) {
                super(Vision.this, "POST", REST_PATH, (Object)content, Operation.class);
            }

            public AsyncBatchAnnotate set$Xgafv(String $Xgafv) {
                return (AsyncBatchAnnotate)super.set$Xgafv($Xgafv);
            }

            public AsyncBatchAnnotate setAccessToken(String accessToken) {
                return (AsyncBatchAnnotate)super.setAccessToken(accessToken);
            }

            public AsyncBatchAnnotate setAlt(String alt) {
                return (AsyncBatchAnnotate)super.setAlt(alt);
            }

            public AsyncBatchAnnotate setCallback(String callback) {
                return (AsyncBatchAnnotate)super.setCallback(callback);
            }

            public AsyncBatchAnnotate setFields(String fields) {
                return (AsyncBatchAnnotate)super.setFields(fields);
            }

            public AsyncBatchAnnotate setKey(String key) {
                return (AsyncBatchAnnotate)super.setKey(key);
            }

            public AsyncBatchAnnotate setOauthToken(String oauthToken) {
                return (AsyncBatchAnnotate)super.setOauthToken(oauthToken);
            }

            public AsyncBatchAnnotate setPrettyPrint(Boolean prettyPrint) {
                return (AsyncBatchAnnotate)super.setPrettyPrint(prettyPrint);
            }

            public AsyncBatchAnnotate setQuotaUser(String quotaUser) {
                return (AsyncBatchAnnotate)super.setQuotaUser(quotaUser);
            }

            public AsyncBatchAnnotate setUploadType(String uploadType) {
                return (AsyncBatchAnnotate)super.setUploadType(uploadType);
            }

            public AsyncBatchAnnotate setUploadProtocol(String uploadProtocol) {
                return (AsyncBatchAnnotate)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public AsyncBatchAnnotate set(String parameterName, Object value) {
                return (AsyncBatchAnnotate)super.set(parameterName, value);
            }
        }

        public class Annotate
        extends VisionRequest<BatchAnnotateFilesResponse> {
            private static final String REST_PATH = "v1/files:annotate";

            protected Annotate(BatchAnnotateFilesRequest content) {
                super(Vision.this, "POST", REST_PATH, (Object)content, BatchAnnotateFilesResponse.class);
            }

            public Annotate set$Xgafv(String $Xgafv) {
                return (Annotate)super.set$Xgafv($Xgafv);
            }

            public Annotate setAccessToken(String accessToken) {
                return (Annotate)super.setAccessToken(accessToken);
            }

            public Annotate setAlt(String alt) {
                return (Annotate)super.setAlt(alt);
            }

            public Annotate setCallback(String callback) {
                return (Annotate)super.setCallback(callback);
            }

            public Annotate setFields(String fields) {
                return (Annotate)super.setFields(fields);
            }

            public Annotate setKey(String key) {
                return (Annotate)super.setKey(key);
            }

            public Annotate setOauthToken(String oauthToken) {
                return (Annotate)super.setOauthToken(oauthToken);
            }

            public Annotate setPrettyPrint(Boolean prettyPrint) {
                return (Annotate)super.setPrettyPrint(prettyPrint);
            }

            public Annotate setQuotaUser(String quotaUser) {
                return (Annotate)super.setQuotaUser(quotaUser);
            }

            public Annotate setUploadType(String uploadType) {
                return (Annotate)super.setUploadType(uploadType);
            }

            public Annotate setUploadProtocol(String uploadProtocol) {
                return (Annotate)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Annotate set(String parameterName, Object value) {
                return (Annotate)super.set(parameterName, value);
            }
        }
    }
}

