/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-03-10 at 06:00:57 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.vision.v1;

/**
 * Service definition for Vision (v1).
 *
 * <p>
 * Integrates Google Vision features, including image labeling, face, logo, and landmark detection, optical character recognition (OCR), and detection of explicit content, into applications.
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://cloud.google.com/vision/" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link VisionRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class Vision extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 15,
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.15 of google-api-client to run version " +
        "1.25.0 of the Cloud Vision API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://vision.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "";

  /**
   * The default encoded batch path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.23
   */
  public static final String DEFAULT_BATCH_PATH = "batch";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public Vision(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  Vision(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the Files collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Vision vision = new Vision(...);}
   *   {@code Vision.Files.List request = vision.files().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Files files() {
    return new Files();
  }

  /**
   * The "files" collection of methods.
   */
  public class Files {

    /**
     * Service that performs image detection and annotation for a batch of files. Now only
     * "application/pdf", "image/tiff" and "image/gif" are supported.
     *
     * This service will extract at most 5 (customers can specify which 5 in AnnotateFileRequest.pages)
     * frames (gif) or pages (pdf or tiff) from each file provided and perform detection and annotation
     * for each image extracted.
     *
     * Create a request for the method "files.annotate".
     *
     * This request holds the parameters needed by the vision server.  After setting any optional
     * parameters, call the {@link Annotate#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.vision.v1.model.BatchAnnotateFilesRequest}
     * @return the request
     */
    public Annotate annotate(com.google.api.services.vision.v1.model.BatchAnnotateFilesRequest content) throws java.io.IOException {
      Annotate result = new Annotate(content);
      initialize(result);
      return result;
    }

    public class Annotate extends VisionRequest<com.google.api.services.vision.v1.model.BatchAnnotateFilesResponse> {

      private static final String REST_PATH = "v1/files:annotate";

      /**
       * Service that performs image detection and annotation for a batch of files. Now only
       * "application/pdf", "image/tiff" and "image/gif" are supported.
       *
       * This service will extract at most 5 (customers can specify which 5 in
       * AnnotateFileRequest.pages) frames (gif) or pages (pdf or tiff) from each file provided and
       * perform detection and annotation for each image extracted.
       *
       * Create a request for the method "files.annotate".
       *
       * This request holds the parameters needed by the the vision server.  After setting any optional
       * parameters, call the {@link Annotate#execute()} method to invoke the remote operation. <p>
       * {@link
       * Annotate#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.vision.v1.model.BatchAnnotateFilesRequest}
       * @since 1.13
       */
      protected Annotate(com.google.api.services.vision.v1.model.BatchAnnotateFilesRequest content) {
        super(Vision.this, "POST", REST_PATH, content, com.google.api.services.vision.v1.model.BatchAnnotateFilesResponse.class);
      }

      @Override
      public Annotate set$Xgafv(java.lang.String $Xgafv) {
        return (Annotate) super.set$Xgafv($Xgafv);
      }

      @Override
      public Annotate setAccessToken(java.lang.String accessToken) {
        return (Annotate) super.setAccessToken(accessToken);
      }

      @Override
      public Annotate setAlt(java.lang.String alt) {
        return (Annotate) super.setAlt(alt);
      }

      @Override
      public Annotate setCallback(java.lang.String callback) {
        return (Annotate) super.setCallback(callback);
      }

      @Override
      public Annotate setFields(java.lang.String fields) {
        return (Annotate) super.setFields(fields);
      }

      @Override
      public Annotate setKey(java.lang.String key) {
        return (Annotate) super.setKey(key);
      }

      @Override
      public Annotate setOauthToken(java.lang.String oauthToken) {
        return (Annotate) super.setOauthToken(oauthToken);
      }

      @Override
      public Annotate setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Annotate) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Annotate setQuotaUser(java.lang.String quotaUser) {
        return (Annotate) super.setQuotaUser(quotaUser);
      }

      @Override
      public Annotate setUploadType(java.lang.String uploadType) {
        return (Annotate) super.setUploadType(uploadType);
      }

      @Override
      public Annotate setUploadProtocol(java.lang.String uploadProtocol) {
        return (Annotate) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Annotate set(String parameterName, Object value) {
        return (Annotate) super.set(parameterName, value);
      }
    }
    /**
     * Run asynchronous image detection and annotation for a list of generic files, such as PDF files,
     * which may contain multiple pages and multiple images per page. Progress and results can be
     * retrieved through the `google.longrunning.Operations` interface. `Operation.metadata` contains
     * `OperationMetadata` (metadata). `Operation.response` contains `AsyncBatchAnnotateFilesResponse`
     * (results).
     *
     * Create a request for the method "files.asyncBatchAnnotate".
     *
     * This request holds the parameters needed by the vision server.  After setting any optional
     * parameters, call the {@link AsyncBatchAnnotate#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.vision.v1.model.AsyncBatchAnnotateFilesRequest}
     * @return the request
     */
    public AsyncBatchAnnotate asyncBatchAnnotate(com.google.api.services.vision.v1.model.AsyncBatchAnnotateFilesRequest content) throws java.io.IOException {
      AsyncBatchAnnotate result = new AsyncBatchAnnotate(content);
      initialize(result);
      return result;
    }

    public class AsyncBatchAnnotate extends VisionRequest<com.google.api.services.vision.v1.model.Operation> {

      private static final String REST_PATH = "v1/files:asyncBatchAnnotate";

      /**
       * Run asynchronous image detection and annotation for a list of generic files, such as PDF files,
       * which may contain multiple pages and multiple images per page. Progress and results can be
       * retrieved through the `google.longrunning.Operations` interface. `Operation.metadata` contains
       * `OperationMetadata` (metadata). `Operation.response` contains `AsyncBatchAnnotateFilesResponse`
       * (results).
       *
       * Create a request for the method "files.asyncBatchAnnotate".
       *
       * This request holds the parameters needed by the the vision server.  After setting any optional
       * parameters, call the {@link AsyncBatchAnnotate#execute()} method to invoke the remote
       * operation. <p> {@link AsyncBatchAnnotate#initialize(com.google.api.client.googleapis.services.A
       * bstractGoogleClientRequest)} must be called to initialize this instance immediately after
       * invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.vision.v1.model.AsyncBatchAnnotateFilesRequest}
       * @since 1.13
       */
      protected AsyncBatchAnnotate(com.google.api.services.vision.v1.model.AsyncBatchAnnotateFilesRequest content) {
        super(Vision.this, "POST", REST_PATH, content, com.google.api.services.vision.v1.model.Operation.class);
      }

      @Override
      public AsyncBatchAnnotate set$Xgafv(java.lang.String $Xgafv) {
        return (AsyncBatchAnnotate) super.set$Xgafv($Xgafv);
      }

      @Override
      public AsyncBatchAnnotate setAccessToken(java.lang.String accessToken) {
        return (AsyncBatchAnnotate) super.setAccessToken(accessToken);
      }

      @Override
      public AsyncBatchAnnotate setAlt(java.lang.String alt) {
        return (AsyncBatchAnnotate) super.setAlt(alt);
      }

      @Override
      public AsyncBatchAnnotate setCallback(java.lang.String callback) {
        return (AsyncBatchAnnotate) super.setCallback(callback);
      }

      @Override
      public AsyncBatchAnnotate setFields(java.lang.String fields) {
        return (AsyncBatchAnnotate) super.setFields(fields);
      }

      @Override
      public AsyncBatchAnnotate setKey(java.lang.String key) {
        return (AsyncBatchAnnotate) super.setKey(key);
      }

      @Override
      public AsyncBatchAnnotate setOauthToken(java.lang.String oauthToken) {
        return (AsyncBatchAnnotate) super.setOauthToken(oauthToken);
      }

      @Override
      public AsyncBatchAnnotate setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (AsyncBatchAnnotate) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AsyncBatchAnnotate setQuotaUser(java.lang.String quotaUser) {
        return (AsyncBatchAnnotate) super.setQuotaUser(quotaUser);
      }

      @Override
      public AsyncBatchAnnotate setUploadType(java.lang.String uploadType) {
        return (AsyncBatchAnnotate) super.setUploadType(uploadType);
      }

      @Override
      public AsyncBatchAnnotate setUploadProtocol(java.lang.String uploadProtocol) {
        return (AsyncBatchAnnotate) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public AsyncBatchAnnotate set(String parameterName, Object value) {
        return (AsyncBatchAnnotate) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Images collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Vision vision = new Vision(...);}
   *   {@code Vision.Images.List request = vision.images().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Images images() {
    return new Images();
  }

  /**
   * The "images" collection of methods.
   */
  public class Images {

    /**
     * Run image detection and annotation for a batch of images.
     *
     * Create a request for the method "images.annotate".
     *
     * This request holds the parameters needed by the vision server.  After setting any optional
     * parameters, call the {@link Annotate#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.vision.v1.model.BatchAnnotateImagesRequest}
     * @return the request
     */
    public Annotate annotate(com.google.api.services.vision.v1.model.BatchAnnotateImagesRequest content) throws java.io.IOException {
      Annotate result = new Annotate(content);
      initialize(result);
      return result;
    }

    public class Annotate extends VisionRequest<com.google.api.services.vision.v1.model.BatchAnnotateImagesResponse> {

      private static final String REST_PATH = "v1/images:annotate";

      /**
       * Run image detection and annotation for a batch of images.
       *
       * Create a request for the method "images.annotate".
       *
       * This request holds the parameters needed by the the vision server.  After setting any optional
       * parameters, call the {@link Annotate#execute()} method to invoke the remote operation. <p>
       * {@link
       * Annotate#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.vision.v1.model.BatchAnnotateImagesRequest}
       * @since 1.13
       */
      protected Annotate(com.google.api.services.vision.v1.model.BatchAnnotateImagesRequest content) {
        super(Vision.this, "POST", REST_PATH, content, com.google.api.services.vision.v1.model.BatchAnnotateImagesResponse.class);
      }

      @Override
      public Annotate set$Xgafv(java.lang.String $Xgafv) {
        return (Annotate) super.set$Xgafv($Xgafv);
      }

      @Override
      public Annotate setAccessToken(java.lang.String accessToken) {
        return (Annotate) super.setAccessToken(accessToken);
      }

      @Override
      public Annotate setAlt(java.lang.String alt) {
        return (Annotate) super.setAlt(alt);
      }

      @Override
      public Annotate setCallback(java.lang.String callback) {
        return (Annotate) super.setCallback(callback);
      }

      @Override
      public Annotate setFields(java.lang.String fields) {
        return (Annotate) super.setFields(fields);
      }

      @Override
      public Annotate setKey(java.lang.String key) {
        return (Annotate) super.setKey(key);
      }

      @Override
      public Annotate setOauthToken(java.lang.String oauthToken) {
        return (Annotate) super.setOauthToken(oauthToken);
      }

      @Override
      public Annotate setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Annotate) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Annotate setQuotaUser(java.lang.String quotaUser) {
        return (Annotate) super.setQuotaUser(quotaUser);
      }

      @Override
      public Annotate setUploadType(java.lang.String uploadType) {
        return (Annotate) super.setUploadType(uploadType);
      }

      @Override
      public Annotate setUploadProtocol(java.lang.String uploadProtocol) {
        return (Annotate) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Annotate set(String parameterName, Object value) {
        return (Annotate) super.set(parameterName, value);
      }
    }
    /**
     * Run asynchronous image detection and annotation for a list of images.
     *
     * Progress and results can be retrieved through the `google.longrunning.Operations` interface.
     * `Operation.metadata` contains `OperationMetadata` (metadata). `Operation.response` contains
     * `AsyncBatchAnnotateImagesResponse` (results).
     *
     * This service will write image annotation outputs to json files in customer GCS bucket, each json
     * file containing BatchAnnotateImagesResponse proto.
     *
     * Create a request for the method "images.asyncBatchAnnotate".
     *
     * This request holds the parameters needed by the vision server.  After setting any optional
     * parameters, call the {@link AsyncBatchAnnotate#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.vision.v1.model.AsyncBatchAnnotateImagesRequest}
     * @return the request
     */
    public AsyncBatchAnnotate asyncBatchAnnotate(com.google.api.services.vision.v1.model.AsyncBatchAnnotateImagesRequest content) throws java.io.IOException {
      AsyncBatchAnnotate result = new AsyncBatchAnnotate(content);
      initialize(result);
      return result;
    }

    public class AsyncBatchAnnotate extends VisionRequest<com.google.api.services.vision.v1.model.Operation> {

      private static final String REST_PATH = "v1/images:asyncBatchAnnotate";

      /**
       * Run asynchronous image detection and annotation for a list of images.
       *
       * Progress and results can be retrieved through the `google.longrunning.Operations` interface.
       * `Operation.metadata` contains `OperationMetadata` (metadata). `Operation.response` contains
       * `AsyncBatchAnnotateImagesResponse` (results).
       *
       * This service will write image annotation outputs to json files in customer GCS bucket, each
       * json file containing BatchAnnotateImagesResponse proto.
       *
       * Create a request for the method "images.asyncBatchAnnotate".
       *
       * This request holds the parameters needed by the the vision server.  After setting any optional
       * parameters, call the {@link AsyncBatchAnnotate#execute()} method to invoke the remote
       * operation. <p> {@link AsyncBatchAnnotate#initialize(com.google.api.client.googleapis.services.A
       * bstractGoogleClientRequest)} must be called to initialize this instance immediately after
       * invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.vision.v1.model.AsyncBatchAnnotateImagesRequest}
       * @since 1.13
       */
      protected AsyncBatchAnnotate(com.google.api.services.vision.v1.model.AsyncBatchAnnotateImagesRequest content) {
        super(Vision.this, "POST", REST_PATH, content, com.google.api.services.vision.v1.model.Operation.class);
      }

      @Override
      public AsyncBatchAnnotate set$Xgafv(java.lang.String $Xgafv) {
        return (AsyncBatchAnnotate) super.set$Xgafv($Xgafv);
      }

      @Override
      public AsyncBatchAnnotate setAccessToken(java.lang.String accessToken) {
        return (AsyncBatchAnnotate) super.setAccessToken(accessToken);
      }

      @Override
      public AsyncBatchAnnotate setAlt(java.lang.String alt) {
        return (AsyncBatchAnnotate) super.setAlt(alt);
      }

      @Override
      public AsyncBatchAnnotate setCallback(java.lang.String callback) {
        return (AsyncBatchAnnotate) super.setCallback(callback);
      }

      @Override
      public AsyncBatchAnnotate setFields(java.lang.String fields) {
        return (AsyncBatchAnnotate) super.setFields(fields);
      }

      @Override
      public AsyncBatchAnnotate setKey(java.lang.String key) {
        return (AsyncBatchAnnotate) super.setKey(key);
      }

      @Override
      public AsyncBatchAnnotate setOauthToken(java.lang.String oauthToken) {
        return (AsyncBatchAnnotate) super.setOauthToken(oauthToken);
      }

      @Override
      public AsyncBatchAnnotate setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (AsyncBatchAnnotate) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AsyncBatchAnnotate setQuotaUser(java.lang.String quotaUser) {
        return (AsyncBatchAnnotate) super.setQuotaUser(quotaUser);
      }

      @Override
      public AsyncBatchAnnotate setUploadType(java.lang.String uploadType) {
        return (AsyncBatchAnnotate) super.setUploadType(uploadType);
      }

      @Override
      public AsyncBatchAnnotate setUploadProtocol(java.lang.String uploadProtocol) {
        return (AsyncBatchAnnotate) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public AsyncBatchAnnotate set(String parameterName, Object value) {
        return (AsyncBatchAnnotate) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Locations collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Vision vision = new Vision(...);}
   *   {@code Vision.Locations.List request = vision.locations().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Locations locations() {
    return new Locations();
  }

  /**
   * The "locations" collection of methods.
   */
  public class Locations {

    /**
     * An accessor for creating requests from the Operations collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Vision vision = new Vision(...);}
     *   {@code Vision.Operations.List request = vision.operations().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Operations operations() {
      return new Operations();
    }

    /**
     * The "operations" collection of methods.
     */
    public class Operations {

      /**
       * Gets the latest state of a long-running operation.  Clients can use this method to poll the
       * operation result at intervals as recommended by the API service.
       *
       * Create a request for the method "operations.get".
       *
       * This request holds the parameters needed by the vision server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param name The name of the operation resource.
       * @return the request
       */
      public Get get(java.lang.String name) throws java.io.IOException {
        Get result = new Get(name);
        initialize(result);
        return result;
      }

      public class Get extends VisionRequest<com.google.api.services.vision.v1.model.Operation> {

        private static final String REST_PATH = "v1/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^locations/[^/]+/operations/[^/]+$");

        /**
         * Gets the latest state of a long-running operation.  Clients can use this method to poll the
         * operation result at intervals as recommended by the API service.
         *
         * Create a request for the method "operations.get".
         *
         * This request holds the parameters needed by the the vision server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
         * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name The name of the operation resource.
         * @since 1.13
         */
        protected Get(java.lang.String name) {
          super(Vision.this, "GET", REST_PATH, null, com.google.api.services.vision.v1.model.Operation.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^locations/[^/]+/operations/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get set$Xgafv(java.lang.String $Xgafv) {
          return (Get) super.set$Xgafv($Xgafv);
        }

        @Override
        public Get setAccessToken(java.lang.String accessToken) {
          return (Get) super.setAccessToken(accessToken);
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setCallback(java.lang.String callback) {
          return (Get) super.setCallback(callback);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUploadType(java.lang.String uploadType) {
          return (Get) super.setUploadType(uploadType);
        }

        @Override
        public Get setUploadProtocol(java.lang.String uploadProtocol) {
          return (Get) super.setUploadProtocol(uploadProtocol);
        }

        /** The name of the operation resource. */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The name of the operation resource.
         */
        public java.lang.String getName() {
          return name;
        }

        /** The name of the operation resource. */
        public Get setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^locations/[^/]+/operations/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }

    }
  }

  /**
   * An accessor for creating requests from the Operations collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Vision vision = new Vision(...);}
   *   {@code Vision.Operations.List request = vision.operations().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Operations operations() {
    return new Operations();
  }

  /**
   * The "operations" collection of methods.
   */
  public class Operations {

    /**
     * Starts asynchronous cancellation on a long-running operation.  The server makes a best effort to
     * cancel the operation, but success is not guaranteed.  If the server doesn't support this method,
     * it returns `google.rpc.Code.UNIMPLEMENTED`.  Clients can use Operations.GetOperation or other
     * methods to check whether the cancellation succeeded or whether the operation completed despite
     * cancellation. On successful cancellation, the operation is not deleted; instead, it becomes an
     * operation with an Operation.error value with a google.rpc.Status.code of 1, corresponding to
     * `Code.CANCELLED`.
     *
     * Create a request for the method "operations.cancel".
     *
     * This request holds the parameters needed by the vision server.  After setting any optional
     * parameters, call the {@link Cancel#execute()} method to invoke the remote operation.
     *
     * @param name The name of the operation resource to be cancelled.
     * @param content the {@link com.google.api.services.vision.v1.model.CancelOperationRequest}
     * @return the request
     */
    public Cancel cancel(java.lang.String name, com.google.api.services.vision.v1.model.CancelOperationRequest content) throws java.io.IOException {
      Cancel result = new Cancel(name, content);
      initialize(result);
      return result;
    }

    public class Cancel extends VisionRequest<com.google.api.services.vision.v1.model.Empty> {

      private static final String REST_PATH = "v1/{+name}:cancel";

      private final java.util.regex.Pattern NAME_PATTERN =
          java.util.regex.Pattern.compile("^operations/.*$");

      /**
       * Starts asynchronous cancellation on a long-running operation.  The server makes a best effort
       * to cancel the operation, but success is not guaranteed.  If the server doesn't support this
       * method, it returns `google.rpc.Code.UNIMPLEMENTED`.  Clients can use Operations.GetOperation or
       * other methods to check whether the cancellation succeeded or whether the operation completed
       * despite cancellation. On successful cancellation, the operation is not deleted; instead, it
       * becomes an operation with an Operation.error value with a google.rpc.Status.code of 1,
       * corresponding to `Code.CANCELLED`.
       *
       * Create a request for the method "operations.cancel".
       *
       * This request holds the parameters needed by the the vision server.  After setting any optional
       * parameters, call the {@link Cancel#execute()} method to invoke the remote operation. <p> {@link
       * Cancel#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param name The name of the operation resource to be cancelled.
       * @param content the {@link com.google.api.services.vision.v1.model.CancelOperationRequest}
       * @since 1.13
       */
      protected Cancel(java.lang.String name, com.google.api.services.vision.v1.model.CancelOperationRequest content) {
        super(Vision.this, "POST", REST_PATH, content, com.google.api.services.vision.v1.model.Empty.class);
        this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^operations/.*$");
        }
      }

      @Override
      public Cancel set$Xgafv(java.lang.String $Xgafv) {
        return (Cancel) super.set$Xgafv($Xgafv);
      }

      @Override
      public Cancel setAccessToken(java.lang.String accessToken) {
        return (Cancel) super.setAccessToken(accessToken);
      }

      @Override
      public Cancel setAlt(java.lang.String alt) {
        return (Cancel) super.setAlt(alt);
      }

      @Override
      public Cancel setCallback(java.lang.String callback) {
        return (Cancel) super.setCallback(callback);
      }

      @Override
      public Cancel setFields(java.lang.String fields) {
        return (Cancel) super.setFields(fields);
      }

      @Override
      public Cancel setKey(java.lang.String key) {
        return (Cancel) super.setKey(key);
      }

      @Override
      public Cancel setOauthToken(java.lang.String oauthToken) {
        return (Cancel) super.setOauthToken(oauthToken);
      }

      @Override
      public Cancel setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Cancel) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Cancel setQuotaUser(java.lang.String quotaUser) {
        return (Cancel) super.setQuotaUser(quotaUser);
      }

      @Override
      public Cancel setUploadType(java.lang.String uploadType) {
        return (Cancel) super.setUploadType(uploadType);
      }

      @Override
      public Cancel setUploadProtocol(java.lang.String uploadProtocol) {
        return (Cancel) super.setUploadProtocol(uploadProtocol);
      }

      /** The name of the operation resource to be cancelled. */
      @com.google.api.client.util.Key
      private java.lang.String name;

      /** The name of the operation resource to be cancelled.
       */
      public java.lang.String getName() {
        return name;
      }

      /** The name of the operation resource to be cancelled. */
      public Cancel setName(java.lang.String name) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^operations/.*$");
        }
        this.name = name;
        return this;
      }

      @Override
      public Cancel set(String parameterName, Object value) {
        return (Cancel) super.set(parameterName, value);
      }
    }
    /**
     * Deletes a long-running operation. This method indicates that the client is no longer interested
     * in the operation result. It does not cancel the operation. If the server doesn't support this
     * method, it returns `google.rpc.Code.UNIMPLEMENTED`.
     *
     * Create a request for the method "operations.delete".
     *
     * This request holds the parameters needed by the vision server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param name The name of the operation resource to be deleted.
     * @return the request
     */
    public Delete delete(java.lang.String name) throws java.io.IOException {
      Delete result = new Delete(name);
      initialize(result);
      return result;
    }

    public class Delete extends VisionRequest<com.google.api.services.vision.v1.model.Empty> {

      private static final String REST_PATH = "v1/{+name}";

      private final java.util.regex.Pattern NAME_PATTERN =
          java.util.regex.Pattern.compile("^operations/.*$");

      /**
       * Deletes a long-running operation. This method indicates that the client is no longer interested
       * in the operation result. It does not cancel the operation. If the server doesn't support this
       * method, it returns `google.rpc.Code.UNIMPLEMENTED`.
       *
       * Create a request for the method "operations.delete".
       *
       * This request holds the parameters needed by the the vision server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param name The name of the operation resource to be deleted.
       * @since 1.13
       */
      protected Delete(java.lang.String name) {
        super(Vision.this, "DELETE", REST_PATH, null, com.google.api.services.vision.v1.model.Empty.class);
        this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^operations/.*$");
        }
      }

      @Override
      public Delete set$Xgafv(java.lang.String $Xgafv) {
        return (Delete) super.set$Xgafv($Xgafv);
      }

      @Override
      public Delete setAccessToken(java.lang.String accessToken) {
        return (Delete) super.setAccessToken(accessToken);
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setCallback(java.lang.String callback) {
        return (Delete) super.setCallback(callback);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUploadType(java.lang.String uploadType) {
        return (Delete) super.setUploadType(uploadType);
      }

      @Override
      public Delete setUploadProtocol(java.lang.String uploadProtocol) {
        return (Delete) super.setUploadProtocol(uploadProtocol);
      }

      /** The name of the operation resource to be deleted. */
      @com.google.api.client.util.Key
      private java.lang.String name;

      /** The name of the operation resource to be deleted.
       */
      public java.lang.String getName() {
        return name;
      }

      /** The name of the operation resource to be deleted. */
      public Delete setName(java.lang.String name) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^operations/.*$");
        }
        this.name = name;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Gets the latest state of a long-running operation.  Clients can use this method to poll the
     * operation result at intervals as recommended by the API service.
     *
     * Create a request for the method "operations.get".
     *
     * This request holds the parameters needed by the vision server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param name The name of the operation resource.
     * @return the request
     */
    public Get get(java.lang.String name) throws java.io.IOException {
      Get result = new Get(name);
      initialize(result);
      return result;
    }

    public class Get extends VisionRequest<com.google.api.services.vision.v1.model.Operation> {

      private static final String REST_PATH = "v1/{+name}";

      private final java.util.regex.Pattern NAME_PATTERN =
          java.util.regex.Pattern.compile("^operations/[^/]+$");

      /**
       * Gets the latest state of a long-running operation.  Clients can use this method to poll the
       * operation result at intervals as recommended by the API service.
       *
       * Create a request for the method "operations.get".
       *
       * This request holds the parameters needed by the the vision server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param name The name of the operation resource.
       * @since 1.13
       */
      protected Get(java.lang.String name) {
        super(Vision.this, "GET", REST_PATH, null, com.google.api.services.vision.v1.model.Operation.class);
        this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^operations/[^/]+$");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      /** The name of the operation resource. */
      @com.google.api.client.util.Key
      private java.lang.String name;

      /** The name of the operation resource.
       */
      public java.lang.String getName() {
        return name;
      }

      /** The name of the operation resource. */
      public Get setName(java.lang.String name) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^operations/[^/]+$");
        }
        this.name = name;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Lists operations that match the specified filter in the request. If the server doesn't support
     * this method, it returns `UNIMPLEMENTED`.
     *
     * NOTE: the `name` binding allows API services to override the binding to use different resource
     * name schemes, such as `users/operations`. To override the binding, API services can add a binding
     * such as `"/v1/{name=users}/operations"` to their service configuration. For backwards
     * compatibility, the default name includes the operations collection id, however overriding users
     * must ensure the name binding is the parent resource, without the operations collection id.
     *
     * Create a request for the method "operations.list".
     *
     * This request holds the parameters needed by the vision server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param name The name of the operation's parent resource.
     * @return the request
     */
    public List list(java.lang.String name) throws java.io.IOException {
      List result = new List(name);
      initialize(result);
      return result;
    }

    public class List extends VisionRequest<com.google.api.services.vision.v1.model.ListOperationsResponse> {

      private static final String REST_PATH = "v1/{+name}";

      private final java.util.regex.Pattern NAME_PATTERN =
          java.util.regex.Pattern.compile("^operations$");

      /**
       * Lists operations that match the specified filter in the request. If the server doesn't support
       * this method, it returns `UNIMPLEMENTED`.
       *
       * NOTE: the `name` binding allows API services to override the binding to use different resource
       * name schemes, such as `users/operations`. To override the binding, API services can add a
       * binding such as `"/v1/{name=users}/operations"` to their service configuration. For backwards
       * compatibility, the default name includes the operations collection id, however overriding users
       * must ensure the name binding is the parent resource, without the operations collection id.
       *
       * Create a request for the method "operations.list".
       *
       * This request holds the parameters needed by the the vision server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param name The name of the operation's parent resource.
       * @since 1.13
       */
      protected List(java.lang.String name) {
        super(Vision.this, "GET", REST_PATH, null, com.google.api.services.vision.v1.model.ListOperationsResponse.class);
        this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^operations$");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /** The name of the operation's parent resource. */
      @com.google.api.client.util.Key
      private java.lang.String name;

      /** The name of the operation's parent resource.
       */
      public java.lang.String getName() {
        return name;
      }

      /** The name of the operation's parent resource. */
      public List setName(java.lang.String name) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^operations$");
        }
        this.name = name;
        return this;
      }

      /** The standard list filter. */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** The standard list filter.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /** The standard list filter. */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /** The standard list page token. */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The standard list page token.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /** The standard list page token. */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** The standard list page size. */
      @com.google.api.client.util.Key
      private java.lang.Integer pageSize;

      /** The standard list page size.
       */
      public java.lang.Integer getPageSize() {
        return pageSize;
      }

      /** The standard list page size. */
      public List setPageSize(java.lang.Integer pageSize) {
        this.pageSize = pageSize;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Projects collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Vision vision = new Vision(...);}
   *   {@code Vision.Projects.List request = vision.projects().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Projects projects() {
    return new Projects();
  }

  /**
   * The "projects" collection of methods.
   */
  public class Projects {

    /**
     * An accessor for creating requests from the Files collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Vision vision = new Vision(...);}
     *   {@code Vision.Files.List request = vision.files().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Files files() {
      return new Files();
    }

    /**
     * The "files" collection of methods.
     */
    public class Files {

      /**
       * Service that performs image detection and annotation for a batch of files. Now only
       * "application/pdf", "image/tiff" and "image/gif" are supported.
       *
       * This service will extract at most 5 (customers can specify which 5 in AnnotateFileRequest.pages)
       * frames (gif) or pages (pdf or tiff) from each file provided and perform detection and annotation
       * for each image extracted.
       *
       * Create a request for the method "files.annotate".
       *
       * This request holds the parameters needed by the vision server.  After setting any optional
       * parameters, call the {@link Annotate#execute()} method to invoke the remote operation.
       *
       * @param parent Optional. Target project and location to make a call.
      Format: `projects/{project-id}/locations
       *        /{location-id}`.
      If no parent is specified, a region will be chosen automatically.
       *        Supported location-ids:
          `us`: USA country only,
          `asia`: East asia areas, like
       *        Japan, Taiwan,
          `eu`: The European Union.
      Example: `projects/project-A/locations/eu`.
       * @param content the {@link com.google.api.services.vision.v1.model.BatchAnnotateFilesRequest}
       * @return the request
       */
      public Annotate annotate(java.lang.String parent, com.google.api.services.vision.v1.model.BatchAnnotateFilesRequest content) throws java.io.IOException {
        Annotate result = new Annotate(parent, content);
        initialize(result);
        return result;
      }

      public class Annotate extends VisionRequest<com.google.api.services.vision.v1.model.BatchAnnotateFilesResponse> {

        private static final String REST_PATH = "v1/{+parent}/files:annotate";

        private final java.util.regex.Pattern PARENT_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+$");

        /**
         * Service that performs image detection and annotation for a batch of files. Now only
         * "application/pdf", "image/tiff" and "image/gif" are supported.
         *
         * This service will extract at most 5 (customers can specify which 5 in
         * AnnotateFileRequest.pages) frames (gif) or pages (pdf or tiff) from each file provided and
         * perform detection and annotation for each image extracted.
         *
         * Create a request for the method "files.annotate".
         *
         * This request holds the parameters needed by the the vision server.  After setting any optional
         * parameters, call the {@link Annotate#execute()} method to invoke the remote operation. <p>
         * {@link
         * Annotate#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param parent Optional. Target project and location to make a call.
      Format: `projects/{project-id}/locations
       *        /{location-id}`.
      If no parent is specified, a region will be chosen automatically.
       *        Supported location-ids:
          `us`: USA country only,
          `asia`: East asia areas, like
       *        Japan, Taiwan,
          `eu`: The European Union.
      Example: `projects/project-A/locations/eu`.
         * @param content the {@link com.google.api.services.vision.v1.model.BatchAnnotateFilesRequest}
         * @since 1.13
         */
        protected Annotate(java.lang.String parent, com.google.api.services.vision.v1.model.BatchAnnotateFilesRequest content) {
          super(Vision.this, "POST", REST_PATH, content, com.google.api.services.vision.v1.model.BatchAnnotateFilesResponse.class);
          this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^projects/[^/]+$");
          }
        }

        @Override
        public Annotate set$Xgafv(java.lang.String $Xgafv) {
          return (Annotate) super.set$Xgafv($Xgafv);
        }

        @Override
        public Annotate setAccessToken(java.lang.String accessToken) {
          return (Annotate) super.setAccessToken(accessToken);
        }

        @Override
        public Annotate setAlt(java.lang.String alt) {
          return (Annotate) super.setAlt(alt);
        }

        @Override
        public Annotate setCallback(java.lang.String callback) {
          return (Annotate) super.setCallback(callback);
        }

        @Override
        public Annotate setFields(java.lang.String fields) {
          return (Annotate) super.setFields(fields);
        }

        @Override
        public Annotate setKey(java.lang.String key) {
          return (Annotate) super.setKey(key);
        }

        @Override
        public Annotate setOauthToken(java.lang.String oauthToken) {
          return (Annotate) super.setOauthToken(oauthToken);
        }

        @Override
        public Annotate setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Annotate) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Annotate setQuotaUser(java.lang.String quotaUser) {
          return (Annotate) super.setQuotaUser(quotaUser);
        }

        @Override
        public Annotate setUploadType(java.lang.String uploadType) {
          return (Annotate) super.setUploadType(uploadType);
        }

        @Override
        public Annotate setUploadProtocol(java.lang.String uploadProtocol) {
          return (Annotate) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Optional. Target project and location to make a call.
         *
         * Format: `projects/{project-id}/locations/{location-id}`.
         *
         * If no parent is specified, a region will be chosen automatically.
         *
         * Supported location-ids: `us`: USA country only, `asia`: East asia areas, like Japan,
         * Taiwan, `eu`: The European Union.
         *
         * Example: `projects/project-A/locations/eu`.
         */
        @com.google.api.client.util.Key
        private java.lang.String parent;

        /** Optional. Target project and location to make a call.

       Format: `projects/{project-id}/locations/{location-id}`.

       If no parent is specified, a region will be chosen automatically.

       Supported location-ids: `us`: USA country only, `asia`: East asia areas, like Japan, Taiwan, `eu`:
       The European Union.

       Example: `projects/project-A/locations/eu`.
         */
        public java.lang.String getParent() {
          return parent;
        }

        /**
         * Optional. Target project and location to make a call.
         *
         * Format: `projects/{project-id}/locations/{location-id}`.
         *
         * If no parent is specified, a region will be chosen automatically.
         *
         * Supported location-ids: `us`: USA country only, `asia`: East asia areas, like Japan,
         * Taiwan, `eu`: The European Union.
         *
         * Example: `projects/project-A/locations/eu`.
         */
        public Annotate setParent(java.lang.String parent) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^projects/[^/]+$");
          }
          this.parent = parent;
          return this;
        }

        @Override
        public Annotate set(String parameterName, Object value) {
          return (Annotate) super.set(parameterName, value);
        }
      }
      /**
       * Run asynchronous image detection and annotation for a list of generic files, such as PDF files,
       * which may contain multiple pages and multiple images per page. Progress and results can be
       * retrieved through the `google.longrunning.Operations` interface. `Operation.metadata` contains
       * `OperationMetadata` (metadata). `Operation.response` contains `AsyncBatchAnnotateFilesResponse`
       * (results).
       *
       * Create a request for the method "files.asyncBatchAnnotate".
       *
       * This request holds the parameters needed by the vision server.  After setting any optional
       * parameters, call the {@link AsyncBatchAnnotate#execute()} method to invoke the remote operation.
       *
       * @param parent Optional. Target project and location to make a call.
      Format: `projects/{project-id}/locations
       *        /{location-id}`.
      If no parent is specified, a region will be chosen automatically.
       *        Supported location-ids:
          `us`: USA country only,
          `asia`: East asia areas, like
       *        Japan, Taiwan,
          `eu`: The European Union.
      Example: `projects/project-A/locations/eu`.
       * @param content the {@link com.google.api.services.vision.v1.model.AsyncBatchAnnotateFilesRequest}
       * @return the request
       */
      public AsyncBatchAnnotate asyncBatchAnnotate(java.lang.String parent, com.google.api.services.vision.v1.model.AsyncBatchAnnotateFilesRequest content) throws java.io.IOException {
        AsyncBatchAnnotate result = new AsyncBatchAnnotate(parent, content);
        initialize(result);
        return result;
      }

      public class AsyncBatchAnnotate extends VisionRequest<com.google.api.services.vision.v1.model.Operation> {

        private static final String REST_PATH = "v1/{+parent}/files:asyncBatchAnnotate";

        private final java.util.regex.Pattern PARENT_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+$");

        /**
         * Run asynchronous image detection and annotation for a list of generic files, such as PDF files,
         * which may contain multiple pages and multiple images per page. Progress and results can be
         * retrieved through the `google.longrunning.Operations` interface. `Operation.metadata` contains
         * `OperationMetadata` (metadata). `Operation.response` contains `AsyncBatchAnnotateFilesResponse`
         * (results).
         *
         * Create a request for the method "files.asyncBatchAnnotate".
         *
         * This request holds the parameters needed by the the vision server.  After setting any optional
         * parameters, call the {@link AsyncBatchAnnotate#execute()} method to invoke the remote
         * operation. <p> {@link AsyncBatchAnnotate#initialize(com.google.api.client.googleapis.services.A
         * bstractGoogleClientRequest)} must be called to initialize this instance immediately after
         * invoking the constructor. </p>
         *
         * @param parent Optional. Target project and location to make a call.
      Format: `projects/{project-id}/locations
       *        /{location-id}`.
      If no parent is specified, a region will be chosen automatically.
       *        Supported location-ids:
          `us`: USA country only,
          `asia`: East asia areas, like
       *        Japan, Taiwan,
          `eu`: The European Union.
      Example: `projects/project-A/locations/eu`.
         * @param content the {@link com.google.api.services.vision.v1.model.AsyncBatchAnnotateFilesRequest}
         * @since 1.13
         */
        protected AsyncBatchAnnotate(java.lang.String parent, com.google.api.services.vision.v1.model.AsyncBatchAnnotateFilesRequest content) {
          super(Vision.this, "POST", REST_PATH, content, com.google.api.services.vision.v1.model.Operation.class);
          this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^projects/[^/]+$");
          }
        }

        @Override
        public AsyncBatchAnnotate set$Xgafv(java.lang.String $Xgafv) {
          return (AsyncBatchAnnotate) super.set$Xgafv($Xgafv);
        }

        @Override
        public AsyncBatchAnnotate setAccessToken(java.lang.String accessToken) {
          return (AsyncBatchAnnotate) super.setAccessToken(accessToken);
        }

        @Override
        public AsyncBatchAnnotate setAlt(java.lang.String alt) {
          return (AsyncBatchAnnotate) super.setAlt(alt);
        }

        @Override
        public AsyncBatchAnnotate setCallback(java.lang.String callback) {
          return (AsyncBatchAnnotate) super.setCallback(callback);
        }

        @Override
        public AsyncBatchAnnotate setFields(java.lang.String fields) {
          return (AsyncBatchAnnotate) super.setFields(fields);
        }

        @Override
        public AsyncBatchAnnotate setKey(java.lang.String key) {
          return (AsyncBatchAnnotate) super.setKey(key);
        }

        @Override
        public AsyncBatchAnnotate setOauthToken(java.lang.String oauthToken) {
          return (AsyncBatchAnnotate) super.setOauthToken(oauthToken);
        }

        @Override
        public AsyncBatchAnnotate setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (AsyncBatchAnnotate) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public AsyncBatchAnnotate setQuotaUser(java.lang.String quotaUser) {
          return (AsyncBatchAnnotate) super.setQuotaUser(quotaUser);
        }

        @Override
        public AsyncBatchAnnotate setUploadType(java.lang.String uploadType) {
          return (AsyncBatchAnnotate) super.setUploadType(uploadType);
        }

        @Override
        public AsyncBatchAnnotate setUploadProtocol(java.lang.String uploadProtocol) {
          return (AsyncBatchAnnotate) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Optional. Target project and location to make a call.
         *
         * Format: `projects/{project-id}/locations/{location-id}`.
         *
         * If no parent is specified, a region will be chosen automatically.
         *
         * Supported location-ids: `us`: USA country only, `asia`: East asia areas, like Japan,
         * Taiwan, `eu`: The European Union.
         *
         * Example: `projects/project-A/locations/eu`.
         */
        @com.google.api.client.util.Key
        private java.lang.String parent;

        /** Optional. Target project and location to make a call.

       Format: `projects/{project-id}/locations/{location-id}`.

       If no parent is specified, a region will be chosen automatically.

       Supported location-ids: `us`: USA country only, `asia`: East asia areas, like Japan, Taiwan, `eu`:
       The European Union.

       Example: `projects/project-A/locations/eu`.
         */
        public java.lang.String getParent() {
          return parent;
        }

        /**
         * Optional. Target project and location to make a call.
         *
         * Format: `projects/{project-id}/locations/{location-id}`.
         *
         * If no parent is specified, a region will be chosen automatically.
         *
         * Supported location-ids: `us`: USA country only, `asia`: East asia areas, like Japan,
         * Taiwan, `eu`: The European Union.
         *
         * Example: `projects/project-A/locations/eu`.
         */
        public AsyncBatchAnnotate setParent(java.lang.String parent) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^projects/[^/]+$");
          }
          this.parent = parent;
          return this;
        }

        @Override
        public AsyncBatchAnnotate set(String parameterName, Object value) {
          return (AsyncBatchAnnotate) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the Images collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Vision vision = new Vision(...);}
     *   {@code Vision.Images.List request = vision.images().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Images images() {
      return new Images();
    }

    /**
     * The "images" collection of methods.
     */
    public class Images {

      /**
       * Run image detection and annotation for a batch of images.
       *
       * Create a request for the method "images.annotate".
       *
       * This request holds the parameters needed by the vision server.  After setting any optional
       * parameters, call the {@link Annotate#execute()} method to invoke the remote operation.
       *
       * @param parent Optional. Target project and location to make a call.
      Format: `projects/{project-id}/locations
       *        /{location-id}`.
      If no parent is specified, a region will be chosen automatically.
       *        Supported location-ids:
          `us`: USA country only,
          `asia`: East asia areas, like
       *        Japan, Taiwan,
          `eu`: The European Union.
      Example: `projects/project-A/locations/eu`.
       * @param content the {@link com.google.api.services.vision.v1.model.BatchAnnotateImagesRequest}
       * @return the request
       */
      public Annotate annotate(java.lang.String parent, com.google.api.services.vision.v1.model.BatchAnnotateImagesRequest content) throws java.io.IOException {
        Annotate result = new Annotate(parent, content);
        initialize(result);
        return result;
      }

      public class Annotate extends VisionRequest<com.google.api.services.vision.v1.model.BatchAnnotateImagesResponse> {

        private static final String REST_PATH = "v1/{+parent}/images:annotate";

        private final java.util.regex.Pattern PARENT_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+$");

        /**
         * Run image detection and annotation for a batch of images.
         *
         * Create a request for the method "images.annotate".
         *
         * This request holds the parameters needed by the the vision server.  After setting any optional
         * parameters, call the {@link Annotate#execute()} method to invoke the remote operation. <p>
         * {@link
         * Annotate#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param parent Optional. Target project and location to make a call.
      Format: `projects/{project-id}/locations
       *        /{location-id}`.
      If no parent is specified, a region will be chosen automatically.
       *        Supported location-ids:
          `us`: USA country only,
          `asia`: East asia areas, like
       *        Japan, Taiwan,
          `eu`: The European Union.
      Example: `projects/project-A/locations/eu`.
         * @param content the {@link com.google.api.services.vision.v1.model.BatchAnnotateImagesRequest}
         * @since 1.13
         */
        protected Annotate(java.lang.String parent, com.google.api.services.vision.v1.model.BatchAnnotateImagesRequest content) {
          super(Vision.this, "POST", REST_PATH, content, com.google.api.services.vision.v1.model.BatchAnnotateImagesResponse.class);
          this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^projects/[^/]+$");
          }
        }

        @Override
        public Annotate set$Xgafv(java.lang.String $Xgafv) {
          return (Annotate) super.set$Xgafv($Xgafv);
        }

        @Override
        public Annotate setAccessToken(java.lang.String accessToken) {
          return (Annotate) super.setAccessToken(accessToken);
        }

        @Override
        public Annotate setAlt(java.lang.String alt) {
          return (Annotate) super.setAlt(alt);
        }

        @Override
        public Annotate setCallback(java.lang.String callback) {
          return (Annotate) super.setCallback(callback);
        }

        @Override
        public Annotate setFields(java.lang.String fields) {
          return (Annotate) super.setFields(fields);
        }

        @Override
        public Annotate setKey(java.lang.String key) {
          return (Annotate) super.setKey(key);
        }

        @Override
        public Annotate setOauthToken(java.lang.String oauthToken) {
          return (Annotate) super.setOauthToken(oauthToken);
        }

        @Override
        public Annotate setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Annotate) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Annotate setQuotaUser(java.lang.String quotaUser) {
          return (Annotate) super.setQuotaUser(quotaUser);
        }

        @Override
        public Annotate setUploadType(java.lang.String uploadType) {
          return (Annotate) super.setUploadType(uploadType);
        }

        @Override
        public Annotate setUploadProtocol(java.lang.String uploadProtocol) {
          return (Annotate) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Optional. Target project and location to make a call.
         *
         * Format: `projects/{project-id}/locations/{location-id}`.
         *
         * If no parent is specified, a region will be chosen automatically.
         *
         * Supported location-ids: `us`: USA country only, `asia`: East asia areas, like Japan,
         * Taiwan, `eu`: The European Union.
         *
         * Example: `projects/project-A/locations/eu`.
         */
        @com.google.api.client.util.Key
        private java.lang.String parent;

        /** Optional. Target project and location to make a call.

       Format: `projects/{project-id}/locations/{location-id}`.

       If no parent is specified, a region will be chosen automatically.

       Supported location-ids: `us`: USA country only, `asia`: East asia areas, like Japan, Taiwan, `eu`:
       The European Union.

       Example: `projects/project-A/locations/eu`.
         */
        public java.lang.String getParent() {
          return parent;
        }

        /**
         * Optional. Target project and location to make a call.
         *
         * Format: `projects/{project-id}/locations/{location-id}`.
         *
         * If no parent is specified, a region will be chosen automatically.
         *
         * Supported location-ids: `us`: USA country only, `asia`: East asia areas, like Japan,
         * Taiwan, `eu`: The European Union.
         *
         * Example: `projects/project-A/locations/eu`.
         */
        public Annotate setParent(java.lang.String parent) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^projects/[^/]+$");
          }
          this.parent = parent;
          return this;
        }

        @Override
        public Annotate set(String parameterName, Object value) {
          return (Annotate) super.set(parameterName, value);
        }
      }
      /**
       * Run asynchronous image detection and annotation for a list of images.
       *
       * Progress and results can be retrieved through the `google.longrunning.Operations` interface.
       * `Operation.metadata` contains `OperationMetadata` (metadata). `Operation.response` contains
       * `AsyncBatchAnnotateImagesResponse` (results).
       *
       * This service will write image annotation outputs to json files in customer GCS bucket, each json
       * file containing BatchAnnotateImagesResponse proto.
       *
       * Create a request for the method "images.asyncBatchAnnotate".
       *
       * This request holds the parameters needed by the vision server.  After setting any optional
       * parameters, call the {@link AsyncBatchAnnotate#execute()} method to invoke the remote operation.
       *
       * @param parent Optional. Target project and location to make a call.
      Format: `projects/{project-id}/locations
       *        /{location-id}`.
      If no parent is specified, a region will be chosen automatically.
       *        Supported location-ids:
          `us`: USA country only,
          `asia`: East asia areas, like
       *        Japan, Taiwan,
          `eu`: The European Union.
      Example: `projects/project-A/locations/eu`.
       * @param content the {@link com.google.api.services.vision.v1.model.AsyncBatchAnnotateImagesRequest}
       * @return the request
       */
      public AsyncBatchAnnotate asyncBatchAnnotate(java.lang.String parent, com.google.api.services.vision.v1.model.AsyncBatchAnnotateImagesRequest content) throws java.io.IOException {
        AsyncBatchAnnotate result = new AsyncBatchAnnotate(parent, content);
        initialize(result);
        return result;
      }

      public class AsyncBatchAnnotate extends VisionRequest<com.google.api.services.vision.v1.model.Operation> {

        private static final String REST_PATH = "v1/{+parent}/images:asyncBatchAnnotate";

        private final java.util.regex.Pattern PARENT_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+$");

        /**
         * Run asynchronous image detection and annotation for a list of images.
         *
         * Progress and results can be retrieved through the `google.longrunning.Operations` interface.
         * `Operation.metadata` contains `OperationMetadata` (metadata). `Operation.response` contains
         * `AsyncBatchAnnotateImagesResponse` (results).
         *
         * This service will write image annotation outputs to json files in customer GCS bucket, each
         * json file containing BatchAnnotateImagesResponse proto.
         *
         * Create a request for the method "images.asyncBatchAnnotate".
         *
         * This request holds the parameters needed by the the vision server.  After setting any optional
         * parameters, call the {@link AsyncBatchAnnotate#execute()} method to invoke the remote
         * operation. <p> {@link AsyncBatchAnnotate#initialize(com.google.api.client.googleapis.services.A
         * bstractGoogleClientRequest)} must be called to initialize this instance immediately after
         * invoking the constructor. </p>
         *
         * @param parent Optional. Target project and location to make a call.
      Format: `projects/{project-id}/locations
       *        /{location-id}`.
      If no parent is specified, a region will be chosen automatically.
       *        Supported location-ids:
          `us`: USA country only,
          `asia`: East asia areas, like
       *        Japan, Taiwan,
          `eu`: The European Union.
      Example: `projects/project-A/locations/eu`.
         * @param content the {@link com.google.api.services.vision.v1.model.AsyncBatchAnnotateImagesRequest}
         * @since 1.13
         */
        protected AsyncBatchAnnotate(java.lang.String parent, com.google.api.services.vision.v1.model.AsyncBatchAnnotateImagesRequest content) {
          super(Vision.this, "POST", REST_PATH, content, com.google.api.services.vision.v1.model.Operation.class);
          this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^projects/[^/]+$");
          }
        }

        @Override
        public AsyncBatchAnnotate set$Xgafv(java.lang.String $Xgafv) {
          return (AsyncBatchAnnotate) super.set$Xgafv($Xgafv);
        }

        @Override
        public AsyncBatchAnnotate setAccessToken(java.lang.String accessToken) {
          return (AsyncBatchAnnotate) super.setAccessToken(accessToken);
        }

        @Override
        public AsyncBatchAnnotate setAlt(java.lang.String alt) {
          return (AsyncBatchAnnotate) super.setAlt(alt);
        }

        @Override
        public AsyncBatchAnnotate setCallback(java.lang.String callback) {
          return (AsyncBatchAnnotate) super.setCallback(callback);
        }

        @Override
        public AsyncBatchAnnotate setFields(java.lang.String fields) {
          return (AsyncBatchAnnotate) super.setFields(fields);
        }

        @Override
        public AsyncBatchAnnotate setKey(java.lang.String key) {
          return (AsyncBatchAnnotate) super.setKey(key);
        }

        @Override
        public AsyncBatchAnnotate setOauthToken(java.lang.String oauthToken) {
          return (AsyncBatchAnnotate) super.setOauthToken(oauthToken);
        }

        @Override
        public AsyncBatchAnnotate setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (AsyncBatchAnnotate) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public AsyncBatchAnnotate setQuotaUser(java.lang.String quotaUser) {
          return (AsyncBatchAnnotate) super.setQuotaUser(quotaUser);
        }

        @Override
        public AsyncBatchAnnotate setUploadType(java.lang.String uploadType) {
          return (AsyncBatchAnnotate) super.setUploadType(uploadType);
        }

        @Override
        public AsyncBatchAnnotate setUploadProtocol(java.lang.String uploadProtocol) {
          return (AsyncBatchAnnotate) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Optional. Target project and location to make a call.
         *
         * Format: `projects/{project-id}/locations/{location-id}`.
         *
         * If no parent is specified, a region will be chosen automatically.
         *
         * Supported location-ids: `us`: USA country only, `asia`: East asia areas, like Japan,
         * Taiwan, `eu`: The European Union.
         *
         * Example: `projects/project-A/locations/eu`.
         */
        @com.google.api.client.util.Key
        private java.lang.String parent;

        /** Optional. Target project and location to make a call.

       Format: `projects/{project-id}/locations/{location-id}`.

       If no parent is specified, a region will be chosen automatically.

       Supported location-ids: `us`: USA country only, `asia`: East asia areas, like Japan, Taiwan, `eu`:
       The European Union.

       Example: `projects/project-A/locations/eu`.
         */
        public java.lang.String getParent() {
          return parent;
        }

        /**
         * Optional. Target project and location to make a call.
         *
         * Format: `projects/{project-id}/locations/{location-id}`.
         *
         * If no parent is specified, a region will be chosen automatically.
         *
         * Supported location-ids: `us`: USA country only, `asia`: East asia areas, like Japan,
         * Taiwan, `eu`: The European Union.
         *
         * Example: `projects/project-A/locations/eu`.
         */
        public AsyncBatchAnnotate setParent(java.lang.String parent) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^projects/[^/]+$");
          }
          this.parent = parent;
          return this;
        }

        @Override
        public AsyncBatchAnnotate set(String parameterName, Object value) {
          return (AsyncBatchAnnotate) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the Locations collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Vision vision = new Vision(...);}
     *   {@code Vision.Locations.List request = vision.locations().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Locations locations() {
      return new Locations();
    }

    /**
     * The "locations" collection of methods.
     */
    public class Locations {

      /**
       * An accessor for creating requests from the Files collection.
       *
       * <p>The typical use is:</p>
       * <pre>
       *   {@code Vision vision = new Vision(...);}
       *   {@code Vision.Files.List request = vision.files().list(parameters ...)}
       * </pre>
       *
       * @return the resource collection
       */
      public Files files() {
        return new Files();
      }

      /**
       * The "files" collection of methods.
       */
      public class Files {

        /**
         * Service that performs image detection and annotation for a batch of files. Now only
         * "application/pdf", "image/tiff" and "image/gif" are supported.
         *
         * This service will extract at most 5 (customers can specify which 5 in AnnotateFileRequest.pages)
         * frames (gif) or pages (pdf or tiff) from each file provided and perform detection and annotation
         * for each image extracted.
         *
         * Create a request for the method "files.annotate".
         *
         * This request holds the parameters needed by the vision server.  After setting any optional
         * parameters, call the {@link Annotate#execute()} method to invoke the remote operation.
         *
         * @param parent Optional. Target project and location to make a call.
        Format: `projects/{project-id}/locations
         *        /{location-id}`.
        If no parent is specified, a region will be chosen automatically.
         *        Supported location-ids:
            `us`: USA country only,
            `asia`: East asia areas, like
         *        Japan, Taiwan,
            `eu`: The European Union.
        Example: `projects/project-A/locations/eu`.
         * @param content the {@link com.google.api.services.vision.v1.model.BatchAnnotateFilesRequest}
         * @return the request
         */
        public Annotate annotate(java.lang.String parent, com.google.api.services.vision.v1.model.BatchAnnotateFilesRequest content) throws java.io.IOException {
          Annotate result = new Annotate(parent, content);
          initialize(result);
          return result;
        }

        public class Annotate extends VisionRequest<com.google.api.services.vision.v1.model.BatchAnnotateFilesResponse> {

          private static final String REST_PATH = "v1/{+parent}/files:annotate";

          private final java.util.regex.Pattern PARENT_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+$");

          /**
           * Service that performs image detection and annotation for a batch of files. Now only
           * "application/pdf", "image/tiff" and "image/gif" are supported.
           *
           * This service will extract at most 5 (customers can specify which 5 in
           * AnnotateFileRequest.pages) frames (gif) or pages (pdf or tiff) from each file provided and
           * perform detection and annotation for each image extracted.
           *
           * Create a request for the method "files.annotate".
           *
           * This request holds the parameters needed by the the vision server.  After setting any optional
           * parameters, call the {@link Annotate#execute()} method to invoke the remote operation. <p>
           * {@link
           * Annotate#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param parent Optional. Target project and location to make a call.
        Format: `projects/{project-id}/locations
         *        /{location-id}`.
        If no parent is specified, a region will be chosen automatically.
         *        Supported location-ids:
            `us`: USA country only,
            `asia`: East asia areas, like
         *        Japan, Taiwan,
            `eu`: The European Union.
        Example: `projects/project-A/locations/eu`.
           * @param content the {@link com.google.api.services.vision.v1.model.BatchAnnotateFilesRequest}
           * @since 1.13
           */
          protected Annotate(java.lang.String parent, com.google.api.services.vision.v1.model.BatchAnnotateFilesRequest content) {
            super(Vision.this, "POST", REST_PATH, content, com.google.api.services.vision.v1.model.BatchAnnotateFilesResponse.class);
            this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
          }

          @Override
          public Annotate set$Xgafv(java.lang.String $Xgafv) {
            return (Annotate) super.set$Xgafv($Xgafv);
          }

          @Override
          public Annotate setAccessToken(java.lang.String accessToken) {
            return (Annotate) super.setAccessToken(accessToken);
          }

          @Override
          public Annotate setAlt(java.lang.String alt) {
            return (Annotate) super.setAlt(alt);
          }

          @Override
          public Annotate setCallback(java.lang.String callback) {
            return (Annotate) super.setCallback(callback);
          }

          @Override
          public Annotate setFields(java.lang.String fields) {
            return (Annotate) super.setFields(fields);
          }

          @Override
          public Annotate setKey(java.lang.String key) {
            return (Annotate) super.setKey(key);
          }

          @Override
          public Annotate setOauthToken(java.lang.String oauthToken) {
            return (Annotate) super.setOauthToken(oauthToken);
          }

          @Override
          public Annotate setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Annotate) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Annotate setQuotaUser(java.lang.String quotaUser) {
            return (Annotate) super.setQuotaUser(quotaUser);
          }

          @Override
          public Annotate setUploadType(java.lang.String uploadType) {
            return (Annotate) super.setUploadType(uploadType);
          }

          @Override
          public Annotate setUploadProtocol(java.lang.String uploadProtocol) {
            return (Annotate) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Optional. Target project and location to make a call.
           *
           * Format: `projects/{project-id}/locations/{location-id}`.
           *
           * If no parent is specified, a region will be chosen automatically.
           *
           * Supported location-ids: `us`: USA country only, `asia`: East asia areas, like Japan,
           * Taiwan, `eu`: The European Union.
           *
           * Example: `projects/project-A/locations/eu`.
           */
          @com.google.api.client.util.Key
          private java.lang.String parent;

          /** Optional. Target project and location to make a call.

         Format: `projects/{project-id}/locations/{location-id}`.

         If no parent is specified, a region will be chosen automatically.

         Supported location-ids: `us`: USA country only, `asia`: East asia areas, like Japan, Taiwan, `eu`:
         The European Union.

         Example: `projects/project-A/locations/eu`.
           */
          public java.lang.String getParent() {
            return parent;
          }

          /**
           * Optional. Target project and location to make a call.
           *
           * Format: `projects/{project-id}/locations/{location-id}`.
           *
           * If no parent is specified, a region will be chosen automatically.
           *
           * Supported location-ids: `us`: USA country only, `asia`: East asia areas, like Japan,
           * Taiwan, `eu`: The European Union.
           *
           * Example: `projects/project-A/locations/eu`.
           */
          public Annotate setParent(java.lang.String parent) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
            this.parent = parent;
            return this;
          }

          @Override
          public Annotate set(String parameterName, Object value) {
            return (Annotate) super.set(parameterName, value);
          }
        }
        /**
         * Run asynchronous image detection and annotation for a list of generic files, such as PDF files,
         * which may contain multiple pages and multiple images per page. Progress and results can be
         * retrieved through the `google.longrunning.Operations` interface. `Operation.metadata` contains
         * `OperationMetadata` (metadata). `Operation.response` contains `AsyncBatchAnnotateFilesResponse`
         * (results).
         *
         * Create a request for the method "files.asyncBatchAnnotate".
         *
         * This request holds the parameters needed by the vision server.  After setting any optional
         * parameters, call the {@link AsyncBatchAnnotate#execute()} method to invoke the remote operation.
         *
         * @param parent Optional. Target project and location to make a call.
        Format: `projects/{project-id}/locations
         *        /{location-id}`.
        If no parent is specified, a region will be chosen automatically.
         *        Supported location-ids:
            `us`: USA country only,
            `asia`: East asia areas, like
         *        Japan, Taiwan,
            `eu`: The European Union.
        Example: `projects/project-A/locations/eu`.
         * @param content the {@link com.google.api.services.vision.v1.model.AsyncBatchAnnotateFilesRequest}
         * @return the request
         */
        public AsyncBatchAnnotate asyncBatchAnnotate(java.lang.String parent, com.google.api.services.vision.v1.model.AsyncBatchAnnotateFilesRequest content) throws java.io.IOException {
          AsyncBatchAnnotate result = new AsyncBatchAnnotate(parent, content);
          initialize(result);
          return result;
        }

        public class AsyncBatchAnnotate extends VisionRequest<com.google.api.services.vision.v1.model.Operation> {

          private static final String REST_PATH = "v1/{+parent}/files:asyncBatchAnnotate";

          private final java.util.regex.Pattern PARENT_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+$");

          /**
           * Run asynchronous image detection and annotation for a list of generic files, such as PDF files,
           * which may contain multiple pages and multiple images per page. Progress and results can be
           * retrieved through the `google.longrunning.Operations` interface. `Operation.metadata` contains
           * `OperationMetadata` (metadata). `Operation.response` contains `AsyncBatchAnnotateFilesResponse`
           * (results).
           *
           * Create a request for the method "files.asyncBatchAnnotate".
           *
           * This request holds the parameters needed by the the vision server.  After setting any optional
           * parameters, call the {@link AsyncBatchAnnotate#execute()} method to invoke the remote
           * operation. <p> {@link AsyncBatchAnnotate#initialize(com.google.api.client.googleapis.services.A
           * bstractGoogleClientRequest)} must be called to initialize this instance immediately after
           * invoking the constructor. </p>
           *
           * @param parent Optional. Target project and location to make a call.
        Format: `projects/{project-id}/locations
         *        /{location-id}`.
        If no parent is specified, a region will be chosen automatically.
         *        Supported location-ids:
            `us`: USA country only,
            `asia`: East asia areas, like
         *        Japan, Taiwan,
            `eu`: The European Union.
        Example: `projects/project-A/locations/eu`.
           * @param content the {@link com.google.api.services.vision.v1.model.AsyncBatchAnnotateFilesRequest}
           * @since 1.13
           */
          protected AsyncBatchAnnotate(java.lang.String parent, com.google.api.services.vision.v1.model.AsyncBatchAnnotateFilesRequest content) {
            super(Vision.this, "POST", REST_PATH, content, com.google.api.services.vision.v1.model.Operation.class);
            this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
          }

          @Override
          public AsyncBatchAnnotate set$Xgafv(java.lang.String $Xgafv) {
            return (AsyncBatchAnnotate) super.set$Xgafv($Xgafv);
          }

          @Override
          public AsyncBatchAnnotate setAccessToken(java.lang.String accessToken) {
            return (AsyncBatchAnnotate) super.setAccessToken(accessToken);
          }

          @Override
          public AsyncBatchAnnotate setAlt(java.lang.String alt) {
            return (AsyncBatchAnnotate) super.setAlt(alt);
          }

          @Override
          public AsyncBatchAnnotate setCallback(java.lang.String callback) {
            return (AsyncBatchAnnotate) super.setCallback(callback);
          }

          @Override
          public AsyncBatchAnnotate setFields(java.lang.String fields) {
            return (AsyncBatchAnnotate) super.setFields(fields);
          }

          @Override
          public AsyncBatchAnnotate setKey(java.lang.String key) {
            return (AsyncBatchAnnotate) super.setKey(key);
          }

          @Override
          public AsyncBatchAnnotate setOauthToken(java.lang.String oauthToken) {
            return (AsyncBatchAnnotate) super.setOauthToken(oauthToken);
          }

          @Override
          public AsyncBatchAnnotate setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (AsyncBatchAnnotate) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public AsyncBatchAnnotate setQuotaUser(java.lang.String quotaUser) {
            return (AsyncBatchAnnotate) super.setQuotaUser(quotaUser);
          }

          @Override
          public AsyncBatchAnnotate setUploadType(java.lang.String uploadType) {
            return (AsyncBatchAnnotate) super.setUploadType(uploadType);
          }

          @Override
          public AsyncBatchAnnotate setUploadProtocol(java.lang.String uploadProtocol) {
            return (AsyncBatchAnnotate) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Optional. Target project and location to make a call.
           *
           * Format: `projects/{project-id}/locations/{location-id}`.
           *
           * If no parent is specified, a region will be chosen automatically.
           *
           * Supported location-ids: `us`: USA country only, `asia`: East asia areas, like Japan,
           * Taiwan, `eu`: The European Union.
           *
           * Example: `projects/project-A/locations/eu`.
           */
          @com.google.api.client.util.Key
          private java.lang.String parent;

          /** Optional. Target project and location to make a call.

         Format: `projects/{project-id}/locations/{location-id}`.

         If no parent is specified, a region will be chosen automatically.

         Supported location-ids: `us`: USA country only, `asia`: East asia areas, like Japan, Taiwan, `eu`:
         The European Union.

         Example: `projects/project-A/locations/eu`.
           */
          public java.lang.String getParent() {
            return parent;
          }

          /**
           * Optional. Target project and location to make a call.
           *
           * Format: `projects/{project-id}/locations/{location-id}`.
           *
           * If no parent is specified, a region will be chosen automatically.
           *
           * Supported location-ids: `us`: USA country only, `asia`: East asia areas, like Japan,
           * Taiwan, `eu`: The European Union.
           *
           * Example: `projects/project-A/locations/eu`.
           */
          public AsyncBatchAnnotate setParent(java.lang.String parent) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
            this.parent = parent;
            return this;
          }

          @Override
          public AsyncBatchAnnotate set(String parameterName, Object value) {
            return (AsyncBatchAnnotate) super.set(parameterName, value);
          }
        }

      }
      /**
       * An accessor for creating requests from the Images collection.
       *
       * <p>The typical use is:</p>
       * <pre>
       *   {@code Vision vision = new Vision(...);}
       *   {@code Vision.Images.List request = vision.images().list(parameters ...)}
       * </pre>
       *
       * @return the resource collection
       */
      public Images images() {
        return new Images();
      }

      /**
       * The "images" collection of methods.
       */
      public class Images {

        /**
         * Run image detection and annotation for a batch of images.
         *
         * Create a request for the method "images.annotate".
         *
         * This request holds the parameters needed by the vision server.  After setting any optional
         * parameters, call the {@link Annotate#execute()} method to invoke the remote operation.
         *
         * @param parent Optional. Target project and location to make a call.
        Format: `projects/{project-id}/locations
         *        /{location-id}`.
        If no parent is specified, a region will be chosen automatically.
         *        Supported location-ids:
            `us`: USA country only,
            `asia`: East asia areas, like
         *        Japan, Taiwan,
            `eu`: The European Union.
        Example: `projects/project-A/locations/eu`.
         * @param content the {@link com.google.api.services.vision.v1.model.BatchAnnotateImagesRequest}
         * @return the request
         */
        public Annotate annotate(java.lang.String parent, com.google.api.services.vision.v1.model.BatchAnnotateImagesRequest content) throws java.io.IOException {
          Annotate result = new Annotate(parent, content);
          initialize(result);
          return result;
        }

        public class Annotate extends VisionRequest<com.google.api.services.vision.v1.model.BatchAnnotateImagesResponse> {

          private static final String REST_PATH = "v1/{+parent}/images:annotate";

          private final java.util.regex.Pattern PARENT_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+$");

          /**
           * Run image detection and annotation for a batch of images.
           *
           * Create a request for the method "images.annotate".
           *
           * This request holds the parameters needed by the the vision server.  After setting any optional
           * parameters, call the {@link Annotate#execute()} method to invoke the remote operation. <p>
           * {@link
           * Annotate#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param parent Optional. Target project and location to make a call.
        Format: `projects/{project-id}/locations
         *        /{location-id}`.
        If no parent is specified, a region will be chosen automatically.
         *        Supported location-ids:
            `us`: USA country only,
            `asia`: East asia areas, like
         *        Japan, Taiwan,
            `eu`: The European Union.
        Example: `projects/project-A/locations/eu`.
           * @param content the {@link com.google.api.services.vision.v1.model.BatchAnnotateImagesRequest}
           * @since 1.13
           */
          protected Annotate(java.lang.String parent, com.google.api.services.vision.v1.model.BatchAnnotateImagesRequest content) {
            super(Vision.this, "POST", REST_PATH, content, com.google.api.services.vision.v1.model.BatchAnnotateImagesResponse.class);
            this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
          }

          @Override
          public Annotate set$Xgafv(java.lang.String $Xgafv) {
            return (Annotate) super.set$Xgafv($Xgafv);
          }

          @Override
          public Annotate setAccessToken(java.lang.String accessToken) {
            return (Annotate) super.setAccessToken(accessToken);
          }

          @Override
          public Annotate setAlt(java.lang.String alt) {
            return (Annotate) super.setAlt(alt);
          }

          @Override
          public Annotate setCallback(java.lang.String callback) {
            return (Annotate) super.setCallback(callback);
          }

          @Override
          public Annotate setFields(java.lang.String fields) {
            return (Annotate) super.setFields(fields);
          }

          @Override
          public Annotate setKey(java.lang.String key) {
            return (Annotate) super.setKey(key);
          }

          @Override
          public Annotate setOauthToken(java.lang.String oauthToken) {
            return (Annotate) super.setOauthToken(oauthToken);
          }

          @Override
          public Annotate setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Annotate) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Annotate setQuotaUser(java.lang.String quotaUser) {
            return (Annotate) super.setQuotaUser(quotaUser);
          }

          @Override
          public Annotate setUploadType(java.lang.String uploadType) {
            return (Annotate) super.setUploadType(uploadType);
          }

          @Override
          public Annotate setUploadProtocol(java.lang.String uploadProtocol) {
            return (Annotate) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Optional. Target project and location to make a call.
           *
           * Format: `projects/{project-id}/locations/{location-id}`.
           *
           * If no parent is specified, a region will be chosen automatically.
           *
           * Supported location-ids: `us`: USA country only, `asia`: East asia areas, like Japan,
           * Taiwan, `eu`: The European Union.
           *
           * Example: `projects/project-A/locations/eu`.
           */
          @com.google.api.client.util.Key
          private java.lang.String parent;

          /** Optional. Target project and location to make a call.

         Format: `projects/{project-id}/locations/{location-id}`.

         If no parent is specified, a region will be chosen automatically.

         Supported location-ids: `us`: USA country only, `asia`: East asia areas, like Japan, Taiwan, `eu`:
         The European Union.

         Example: `projects/project-A/locations/eu`.
           */
          public java.lang.String getParent() {
            return parent;
          }

          /**
           * Optional. Target project and location to make a call.
           *
           * Format: `projects/{project-id}/locations/{location-id}`.
           *
           * If no parent is specified, a region will be chosen automatically.
           *
           * Supported location-ids: `us`: USA country only, `asia`: East asia areas, like Japan,
           * Taiwan, `eu`: The European Union.
           *
           * Example: `projects/project-A/locations/eu`.
           */
          public Annotate setParent(java.lang.String parent) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
            this.parent = parent;
            return this;
          }

          @Override
          public Annotate set(String parameterName, Object value) {
            return (Annotate) super.set(parameterName, value);
          }
        }
        /**
         * Run asynchronous image detection and annotation for a list of images.
         *
         * Progress and results can be retrieved through the `google.longrunning.Operations` interface.
         * `Operation.metadata` contains `OperationMetadata` (metadata). `Operation.response` contains
         * `AsyncBatchAnnotateImagesResponse` (results).
         *
         * This service will write image annotation outputs to json files in customer GCS bucket, each json
         * file containing BatchAnnotateImagesResponse proto.
         *
         * Create a request for the method "images.asyncBatchAnnotate".
         *
         * This request holds the parameters needed by the vision server.  After setting any optional
         * parameters, call the {@link AsyncBatchAnnotate#execute()} method to invoke the remote operation.
         *
         * @param parent Optional. Target project and location to make a call.
        Format: `projects/{project-id}/locations
         *        /{location-id}`.
        If no parent is specified, a region will be chosen automatically.
         *        Supported location-ids:
            `us`: USA country only,
            `asia`: East asia areas, like
         *        Japan, Taiwan,
            `eu`: The European Union.
        Example: `projects/project-A/locations/eu`.
         * @param content the {@link com.google.api.services.vision.v1.model.AsyncBatchAnnotateImagesRequest}
         * @return the request
         */
        public AsyncBatchAnnotate asyncBatchAnnotate(java.lang.String parent, com.google.api.services.vision.v1.model.AsyncBatchAnnotateImagesRequest content) throws java.io.IOException {
          AsyncBatchAnnotate result = new AsyncBatchAnnotate(parent, content);
          initialize(result);
          return result;
        }

        public class AsyncBatchAnnotate extends VisionRequest<com.google.api.services.vision.v1.model.Operation> {

          private static final String REST_PATH = "v1/{+parent}/images:asyncBatchAnnotate";

          private final java.util.regex.Pattern PARENT_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+$");

          /**
           * Run asynchronous image detection and annotation for a list of images.
           *
           * Progress and results can be retrieved through the `google.longrunning.Operations` interface.
           * `Operation.metadata` contains `OperationMetadata` (metadata). `Operation.response` contains
           * `AsyncBatchAnnotateImagesResponse` (results).
           *
           * This service will write image annotation outputs to json files in customer GCS bucket, each
           * json file containing BatchAnnotateImagesResponse proto.
           *
           * Create a request for the method "images.asyncBatchAnnotate".
           *
           * This request holds the parameters needed by the the vision server.  After setting any optional
           * parameters, call the {@link AsyncBatchAnnotate#execute()} method to invoke the remote
           * operation. <p> {@link AsyncBatchAnnotate#initialize(com.google.api.client.googleapis.services.A
           * bstractGoogleClientRequest)} must be called to initialize this instance immediately after
           * invoking the constructor. </p>
           *
           * @param parent Optional. Target project and location to make a call.
        Format: `projects/{project-id}/locations
         *        /{location-id}`.
        If no parent is specified, a region will be chosen automatically.
         *        Supported location-ids:
            `us`: USA country only,
            `asia`: East asia areas, like
         *        Japan, Taiwan,
            `eu`: The European Union.
        Example: `projects/project-A/locations/eu`.
           * @param content the {@link com.google.api.services.vision.v1.model.AsyncBatchAnnotateImagesRequest}
           * @since 1.13
           */
          protected AsyncBatchAnnotate(java.lang.String parent, com.google.api.services.vision.v1.model.AsyncBatchAnnotateImagesRequest content) {
            super(Vision.this, "POST", REST_PATH, content, com.google.api.services.vision.v1.model.Operation.class);
            this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
          }

          @Override
          public AsyncBatchAnnotate set$Xgafv(java.lang.String $Xgafv) {
            return (AsyncBatchAnnotate) super.set$Xgafv($Xgafv);
          }

          @Override
          public AsyncBatchAnnotate setAccessToken(java.lang.String accessToken) {
            return (AsyncBatchAnnotate) super.setAccessToken(accessToken);
          }

          @Override
          public AsyncBatchAnnotate setAlt(java.lang.String alt) {
            return (AsyncBatchAnnotate) super.setAlt(alt);
          }

          @Override
          public AsyncBatchAnnotate setCallback(java.lang.String callback) {
            return (AsyncBatchAnnotate) super.setCallback(callback);
          }

          @Override
          public AsyncBatchAnnotate setFields(java.lang.String fields) {
            return (AsyncBatchAnnotate) super.setFields(fields);
          }

          @Override
          public AsyncBatchAnnotate setKey(java.lang.String key) {
            return (AsyncBatchAnnotate) super.setKey(key);
          }

          @Override
          public AsyncBatchAnnotate setOauthToken(java.lang.String oauthToken) {
            return (AsyncBatchAnnotate) super.setOauthToken(oauthToken);
          }

          @Override
          public AsyncBatchAnnotate setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (AsyncBatchAnnotate) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public AsyncBatchAnnotate setQuotaUser(java.lang.String quotaUser) {
            return (AsyncBatchAnnotate) super.setQuotaUser(quotaUser);
          }

          @Override
          public AsyncBatchAnnotate setUploadType(java.lang.String uploadType) {
            return (AsyncBatchAnnotate) super.setUploadType(uploadType);
          }

          @Override
          public AsyncBatchAnnotate setUploadProtocol(java.lang.String uploadProtocol) {
            return (AsyncBatchAnnotate) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Optional. Target project and location to make a call.
           *
           * Format: `projects/{project-id}/locations/{location-id}`.
           *
           * If no parent is specified, a region will be chosen automatically.
           *
           * Supported location-ids: `us`: USA country only, `asia`: East asia areas, like Japan,
           * Taiwan, `eu`: The European Union.
           *
           * Example: `projects/project-A/locations/eu`.
           */
          @com.google.api.client.util.Key
          private java.lang.String parent;

          /** Optional. Target project and location to make a call.

         Format: `projects/{project-id}/locations/{location-id}`.

         If no parent is specified, a region will be chosen automatically.

         Supported location-ids: `us`: USA country only, `asia`: East asia areas, like Japan, Taiwan, `eu`:
         The European Union.

         Example: `projects/project-A/locations/eu`.
           */
          public java.lang.String getParent() {
            return parent;
          }

          /**
           * Optional. Target project and location to make a call.
           *
           * Format: `projects/{project-id}/locations/{location-id}`.
           *
           * If no parent is specified, a region will be chosen automatically.
           *
           * Supported location-ids: `us`: USA country only, `asia`: East asia areas, like Japan,
           * Taiwan, `eu`: The European Union.
           *
           * Example: `projects/project-A/locations/eu`.
           */
          public AsyncBatchAnnotate setParent(java.lang.String parent) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
            this.parent = parent;
            return this;
          }

          @Override
          public AsyncBatchAnnotate set(String parameterName, Object value) {
            return (AsyncBatchAnnotate) super.set(parameterName, value);
          }
        }

      }
      /**
       * An accessor for creating requests from the Operations collection.
       *
       * <p>The typical use is:</p>
       * <pre>
       *   {@code Vision vision = new Vision(...);}
       *   {@code Vision.Operations.List request = vision.operations().list(parameters ...)}
       * </pre>
       *
       * @return the resource collection
       */
      public Operations operations() {
        return new Operations();
      }

      /**
       * The "operations" collection of methods.
       */
      public class Operations {

        /**
         * Gets the latest state of a long-running operation.  Clients can use this method to poll the
         * operation result at intervals as recommended by the API service.
         *
         * Create a request for the method "operations.get".
         *
         * This request holds the parameters needed by the vision server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation.
         *
         * @param name The name of the operation resource.
         * @return the request
         */
        public Get get(java.lang.String name) throws java.io.IOException {
          Get result = new Get(name);
          initialize(result);
          return result;
        }

        public class Get extends VisionRequest<com.google.api.services.vision.v1.model.Operation> {

          private static final String REST_PATH = "v1/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/operations/[^/]+$");

          /**
           * Gets the latest state of a long-running operation.  Clients can use this method to poll the
           * operation result at intervals as recommended by the API service.
           *
           * Create a request for the method "operations.get".
           *
           * This request holds the parameters needed by the the vision server.  After setting any optional
           * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
           * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
           * called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name The name of the operation resource.
           * @since 1.13
           */
          protected Get(java.lang.String name) {
            super(Vision.this, "GET", REST_PATH, null, com.google.api.services.vision.v1.model.Operation.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public Get set$Xgafv(java.lang.String $Xgafv) {
            return (Get) super.set$Xgafv($Xgafv);
          }

          @Override
          public Get setAccessToken(java.lang.String accessToken) {
            return (Get) super.setAccessToken(accessToken);
          }

          @Override
          public Get setAlt(java.lang.String alt) {
            return (Get) super.setAlt(alt);
          }

          @Override
          public Get setCallback(java.lang.String callback) {
            return (Get) super.setCallback(callback);
          }

          @Override
          public Get setFields(java.lang.String fields) {
            return (Get) super.setFields(fields);
          }

          @Override
          public Get setKey(java.lang.String key) {
            return (Get) super.setKey(key);
          }

          @Override
          public Get setOauthToken(java.lang.String oauthToken) {
            return (Get) super.setOauthToken(oauthToken);
          }

          @Override
          public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Get) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Get setQuotaUser(java.lang.String quotaUser) {
            return (Get) super.setQuotaUser(quotaUser);
          }

          @Override
          public Get setUploadType(java.lang.String uploadType) {
            return (Get) super.setUploadType(uploadType);
          }

          @Override
          public Get setUploadProtocol(java.lang.String uploadProtocol) {
            return (Get) super.setUploadProtocol(uploadProtocol);
          }

          /** The name of the operation resource. */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** The name of the operation resource.
           */
          public java.lang.String getName() {
            return name;
          }

          /** The name of the operation resource. */
          public Get setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Get set(String parameterName, Object value) {
            return (Get) super.set(parameterName, value);
          }
        }

      }
      /**
       * An accessor for creating requests from the ProductSets collection.
       *
       * <p>The typical use is:</p>
       * <pre>
       *   {@code Vision vision = new Vision(...);}
       *   {@code Vision.ProductSets.List request = vision.productSets().list(parameters ...)}
       * </pre>
       *
       * @return the resource collection
       */
      public ProductSets productSets() {
        return new ProductSets();
      }

      /**
       * The "productSets" collection of methods.
       */
      public class ProductSets {

        /**
         * Adds a Product to the specified ProductSet. If the Product is already present, no change is made.
         *
         * One Product can be added to at most 100 ProductSets.
         *
         * Possible errors:
         *
         * * Returns NOT_FOUND if the Product or the ProductSet doesn't exist.
         *
         * Create a request for the method "productSets.addProduct".
         *
         * This request holds the parameters needed by the vision server.  After setting any optional
         * parameters, call the {@link AddProduct#execute()} method to invoke the remote operation.
         *
         * @param name Required. The resource name for the ProductSet to modify.
        Format is:
         *        `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`
         * @param content the {@link com.google.api.services.vision.v1.model.AddProductToProductSetRequest}
         * @return the request
         */
        public AddProduct addProduct(java.lang.String name, com.google.api.services.vision.v1.model.AddProductToProductSetRequest content) throws java.io.IOException {
          AddProduct result = new AddProduct(name, content);
          initialize(result);
          return result;
        }

        public class AddProduct extends VisionRequest<com.google.api.services.vision.v1.model.Empty> {

          private static final String REST_PATH = "v1/{+name}:addProduct";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/productSets/[^/]+$");

          /**
           * Adds a Product to the specified ProductSet. If the Product is already present, no change is
           * made.
           *
           * One Product can be added to at most 100 ProductSets.
           *
           * Possible errors:
           *
           * * Returns NOT_FOUND if the Product or the ProductSet doesn't exist.
           *
           * Create a request for the method "productSets.addProduct".
           *
           * This request holds the parameters needed by the the vision server.  After setting any optional
           * parameters, call the {@link AddProduct#execute()} method to invoke the remote operation. <p>
           * {@link
           * AddProduct#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name Required. The resource name for the ProductSet to modify.
        Format is:
         *        `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`
           * @param content the {@link com.google.api.services.vision.v1.model.AddProductToProductSetRequest}
           * @since 1.13
           */
          protected AddProduct(java.lang.String name, com.google.api.services.vision.v1.model.AddProductToProductSetRequest content) {
            super(Vision.this, "POST", REST_PATH, content, com.google.api.services.vision.v1.model.Empty.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/productSets/[^/]+$");
            }
          }

          @Override
          public AddProduct set$Xgafv(java.lang.String $Xgafv) {
            return (AddProduct) super.set$Xgafv($Xgafv);
          }

          @Override
          public AddProduct setAccessToken(java.lang.String accessToken) {
            return (AddProduct) super.setAccessToken(accessToken);
          }

          @Override
          public AddProduct setAlt(java.lang.String alt) {
            return (AddProduct) super.setAlt(alt);
          }

          @Override
          public AddProduct setCallback(java.lang.String callback) {
            return (AddProduct) super.setCallback(callback);
          }

          @Override
          public AddProduct setFields(java.lang.String fields) {
            return (AddProduct) super.setFields(fields);
          }

          @Override
          public AddProduct setKey(java.lang.String key) {
            return (AddProduct) super.setKey(key);
          }

          @Override
          public AddProduct setOauthToken(java.lang.String oauthToken) {
            return (AddProduct) super.setOauthToken(oauthToken);
          }

          @Override
          public AddProduct setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (AddProduct) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public AddProduct setQuotaUser(java.lang.String quotaUser) {
            return (AddProduct) super.setQuotaUser(quotaUser);
          }

          @Override
          public AddProduct setUploadType(java.lang.String uploadType) {
            return (AddProduct) super.setUploadType(uploadType);
          }

          @Override
          public AddProduct setUploadProtocol(java.lang.String uploadProtocol) {
            return (AddProduct) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. The resource name for the ProductSet to modify.
           *
           * Format is: `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Required. The resource name for the ProductSet to modify.

         Format is: `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * Required. The resource name for the ProductSet to modify.
           *
           * Format is: `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`
           */
          public AddProduct setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/productSets/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public AddProduct set(String parameterName, Object value) {
            return (AddProduct) super.set(parameterName, value);
          }
        }
        /**
         * Creates and returns a new ProductSet resource.
         *
         * Possible errors:
         *
         * * Returns INVALID_ARGUMENT if display_name is missing, or is longer than   4096 characters.
         *
         * Create a request for the method "productSets.create".
         *
         * This request holds the parameters needed by the vision server.  After setting any optional
         * parameters, call the {@link Create#execute()} method to invoke the remote operation.
         *
         * @param parent Required. The project in which the ProductSet should be created.
        Format is
         *        `projects/PROJECT_ID/locations/LOC_ID`.
         * @param content the {@link com.google.api.services.vision.v1.model.ProductSet}
         * @return the request
         */
        public Create create(java.lang.String parent, com.google.api.services.vision.v1.model.ProductSet content) throws java.io.IOException {
          Create result = new Create(parent, content);
          initialize(result);
          return result;
        }

        public class Create extends VisionRequest<com.google.api.services.vision.v1.model.ProductSet> {

          private static final String REST_PATH = "v1/{+parent}/productSets";

          private final java.util.regex.Pattern PARENT_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+$");

          /**
           * Creates and returns a new ProductSet resource.
           *
           * Possible errors:
           *
           * * Returns INVALID_ARGUMENT if display_name is missing, or is longer than   4096 characters.
           *
           * Create a request for the method "productSets.create".
           *
           * This request holds the parameters needed by the the vision server.  After setting any optional
           * parameters, call the {@link Create#execute()} method to invoke the remote operation. <p> {@link
           * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param parent Required. The project in which the ProductSet should be created.
        Format is
         *        `projects/PROJECT_ID/locations/LOC_ID`.
           * @param content the {@link com.google.api.services.vision.v1.model.ProductSet}
           * @since 1.13
           */
          protected Create(java.lang.String parent, com.google.api.services.vision.v1.model.ProductSet content) {
            super(Vision.this, "POST", REST_PATH, content, com.google.api.services.vision.v1.model.ProductSet.class);
            this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
          }

          @Override
          public Create set$Xgafv(java.lang.String $Xgafv) {
            return (Create) super.set$Xgafv($Xgafv);
          }

          @Override
          public Create setAccessToken(java.lang.String accessToken) {
            return (Create) super.setAccessToken(accessToken);
          }

          @Override
          public Create setAlt(java.lang.String alt) {
            return (Create) super.setAlt(alt);
          }

          @Override
          public Create setCallback(java.lang.String callback) {
            return (Create) super.setCallback(callback);
          }

          @Override
          public Create setFields(java.lang.String fields) {
            return (Create) super.setFields(fields);
          }

          @Override
          public Create setKey(java.lang.String key) {
            return (Create) super.setKey(key);
          }

          @Override
          public Create setOauthToken(java.lang.String oauthToken) {
            return (Create) super.setOauthToken(oauthToken);
          }

          @Override
          public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Create) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Create setQuotaUser(java.lang.String quotaUser) {
            return (Create) super.setQuotaUser(quotaUser);
          }

          @Override
          public Create setUploadType(java.lang.String uploadType) {
            return (Create) super.setUploadType(uploadType);
          }

          @Override
          public Create setUploadProtocol(java.lang.String uploadProtocol) {
            return (Create) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. The project in which the ProductSet should be created.
           *
           * Format is `projects/PROJECT_ID/locations/LOC_ID`.
           */
          @com.google.api.client.util.Key
          private java.lang.String parent;

          /** Required. The project in which the ProductSet should be created.

         Format is `projects/PROJECT_ID/locations/LOC_ID`.
           */
          public java.lang.String getParent() {
            return parent;
          }

          /**
           * Required. The project in which the ProductSet should be created.
           *
           * Format is `projects/PROJECT_ID/locations/LOC_ID`.
           */
          public Create setParent(java.lang.String parent) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
            this.parent = parent;
            return this;
          }

          /**
           * A user-supplied resource id for this ProductSet. If set, the server will attempt to use
           * this value as the resource id. If it is already in use, an error is returned with code
           * ALREADY_EXISTS. Must be at most 128 characters long. It cannot contain the character
           * `/`.
           */
          @com.google.api.client.util.Key
          private java.lang.String productSetId;

          /** A user-supplied resource id for this ProductSet. If set, the server will attempt to use this value
         as the resource id. If it is already in use, an error is returned with code ALREADY_EXISTS. Must be
         at most 128 characters long. It cannot contain the character `/`.
           */
          public java.lang.String getProductSetId() {
            return productSetId;
          }

          /**
           * A user-supplied resource id for this ProductSet. If set, the server will attempt to use
           * this value as the resource id. If it is already in use, an error is returned with code
           * ALREADY_EXISTS. Must be at most 128 characters long. It cannot contain the character
           * `/`.
           */
          public Create setProductSetId(java.lang.String productSetId) {
            this.productSetId = productSetId;
            return this;
          }

          @Override
          public Create set(String parameterName, Object value) {
            return (Create) super.set(parameterName, value);
          }
        }
        /**
         * Permanently deletes a ProductSet. Products and ReferenceImages in the ProductSet are not deleted.
         *
         * The actual image files are not deleted from Google Cloud Storage.
         *
         * Create a request for the method "productSets.delete".
         *
         * This request holds the parameters needed by the vision server.  After setting any optional
         * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
         *
         * @param name Required. Resource name of the ProductSet to delete.
        Format is:
         *        `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`
         * @return the request
         */
        public Delete delete(java.lang.String name) throws java.io.IOException {
          Delete result = new Delete(name);
          initialize(result);
          return result;
        }

        public class Delete extends VisionRequest<com.google.api.services.vision.v1.model.Empty> {

          private static final String REST_PATH = "v1/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/productSets/[^/]+$");

          /**
           * Permanently deletes a ProductSet. Products and ReferenceImages in the ProductSet are not
           * deleted.
           *
           * The actual image files are not deleted from Google Cloud Storage.
           *
           * Create a request for the method "productSets.delete".
           *
           * This request holds the parameters needed by the the vision server.  After setting any optional
           * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
           * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name Required. Resource name of the ProductSet to delete.
        Format is:
         *        `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`
           * @since 1.13
           */
          protected Delete(java.lang.String name) {
            super(Vision.this, "DELETE", REST_PATH, null, com.google.api.services.vision.v1.model.Empty.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/productSets/[^/]+$");
            }
          }

          @Override
          public Delete set$Xgafv(java.lang.String $Xgafv) {
            return (Delete) super.set$Xgafv($Xgafv);
          }

          @Override
          public Delete setAccessToken(java.lang.String accessToken) {
            return (Delete) super.setAccessToken(accessToken);
          }

          @Override
          public Delete setAlt(java.lang.String alt) {
            return (Delete) super.setAlt(alt);
          }

          @Override
          public Delete setCallback(java.lang.String callback) {
            return (Delete) super.setCallback(callback);
          }

          @Override
          public Delete setFields(java.lang.String fields) {
            return (Delete) super.setFields(fields);
          }

          @Override
          public Delete setKey(java.lang.String key) {
            return (Delete) super.setKey(key);
          }

          @Override
          public Delete setOauthToken(java.lang.String oauthToken) {
            return (Delete) super.setOauthToken(oauthToken);
          }

          @Override
          public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Delete) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Delete setQuotaUser(java.lang.String quotaUser) {
            return (Delete) super.setQuotaUser(quotaUser);
          }

          @Override
          public Delete setUploadType(java.lang.String uploadType) {
            return (Delete) super.setUploadType(uploadType);
          }

          @Override
          public Delete setUploadProtocol(java.lang.String uploadProtocol) {
            return (Delete) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. Resource name of the ProductSet to delete.
           *
           * Format is: `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Required. Resource name of the ProductSet to delete.

         Format is: `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * Required. Resource name of the ProductSet to delete.
           *
           * Format is: `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`
           */
          public Delete setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/productSets/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Delete set(String parameterName, Object value) {
            return (Delete) super.set(parameterName, value);
          }
        }
        /**
         * Gets information associated with a ProductSet.
         *
         * Possible errors:
         *
         * * Returns NOT_FOUND if the ProductSet does not exist.
         *
         * Create a request for the method "productSets.get".
         *
         * This request holds the parameters needed by the vision server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation.
         *
         * @param name Required. Resource name of the ProductSet to get.
        Format is:
         *        `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`
         * @return the request
         */
        public Get get(java.lang.String name) throws java.io.IOException {
          Get result = new Get(name);
          initialize(result);
          return result;
        }

        public class Get extends VisionRequest<com.google.api.services.vision.v1.model.ProductSet> {

          private static final String REST_PATH = "v1/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/productSets/[^/]+$");

          /**
           * Gets information associated with a ProductSet.
           *
           * Possible errors:
           *
           * * Returns NOT_FOUND if the ProductSet does not exist.
           *
           * Create a request for the method "productSets.get".
           *
           * This request holds the parameters needed by the the vision server.  After setting any optional
           * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
           * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
           * called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name Required. Resource name of the ProductSet to get.
        Format is:
         *        `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`
           * @since 1.13
           */
          protected Get(java.lang.String name) {
            super(Vision.this, "GET", REST_PATH, null, com.google.api.services.vision.v1.model.ProductSet.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/productSets/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public Get set$Xgafv(java.lang.String $Xgafv) {
            return (Get) super.set$Xgafv($Xgafv);
          }

          @Override
          public Get setAccessToken(java.lang.String accessToken) {
            return (Get) super.setAccessToken(accessToken);
          }

          @Override
          public Get setAlt(java.lang.String alt) {
            return (Get) super.setAlt(alt);
          }

          @Override
          public Get setCallback(java.lang.String callback) {
            return (Get) super.setCallback(callback);
          }

          @Override
          public Get setFields(java.lang.String fields) {
            return (Get) super.setFields(fields);
          }

          @Override
          public Get setKey(java.lang.String key) {
            return (Get) super.setKey(key);
          }

          @Override
          public Get setOauthToken(java.lang.String oauthToken) {
            return (Get) super.setOauthToken(oauthToken);
          }

          @Override
          public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Get) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Get setQuotaUser(java.lang.String quotaUser) {
            return (Get) super.setQuotaUser(quotaUser);
          }

          @Override
          public Get setUploadType(java.lang.String uploadType) {
            return (Get) super.setUploadType(uploadType);
          }

          @Override
          public Get setUploadProtocol(java.lang.String uploadProtocol) {
            return (Get) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. Resource name of the ProductSet to get.
           *
           * Format is: `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Required. Resource name of the ProductSet to get.

         Format is: `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * Required. Resource name of the ProductSet to get.
           *
           * Format is: `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`
           */
          public Get setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/productSets/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Get set(String parameterName, Object value) {
            return (Get) super.set(parameterName, value);
          }
        }
        /**
         * Asynchronous API that imports a list of reference images to specified product sets based on a
         * list of image information.
         *
         * The google.longrunning.Operation API can be used to keep track of the progress and results of the
         * request. `Operation.metadata` contains `BatchOperationMetadata`. (progress) `Operation.response`
         * contains `ImportProductSetsResponse`. (results)
         *
         * The input source of this method is a csv file on Google Cloud Storage. For the format of the csv
         * file please see ImportProductSetsGcsSource.csv_file_uri.
         *
         * Create a request for the method "productSets.import".
         *
         * This request holds the parameters needed by the vision server.  After setting any optional
         * parameters, call the {@link VisionImport#execute()} method to invoke the remote operation.
         *
         * @param parent Required. The project in which the ProductSets should be imported.
        Format is
         *        `projects/PROJECT_ID/locations/LOC_ID`.
         * @param content the {@link com.google.api.services.vision.v1.model.ImportProductSetsRequest}
         * @return the request
         */
        public VisionImport visionImport(java.lang.String parent, com.google.api.services.vision.v1.model.ImportProductSetsRequest content) throws java.io.IOException {
          VisionImport result = new VisionImport(parent, content);
          initialize(result);
          return result;
        }

        public class VisionImport extends VisionRequest<com.google.api.services.vision.v1.model.Operation> {

          private static final String REST_PATH = "v1/{+parent}/productSets:import";

          private final java.util.regex.Pattern PARENT_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+$");

          /**
           * Asynchronous API that imports a list of reference images to specified product sets based on a
           * list of image information.
           *
           * The google.longrunning.Operation API can be used to keep track of the progress and results of
           * the request. `Operation.metadata` contains `BatchOperationMetadata`. (progress)
           * `Operation.response` contains `ImportProductSetsResponse`. (results)
           *
           * The input source of this method is a csv file on Google Cloud Storage. For the format of the
           * csv file please see ImportProductSetsGcsSource.csv_file_uri.
           *
           * Create a request for the method "productSets.import".
           *
           * This request holds the parameters needed by the the vision server.  After setting any optional
           * parameters, call the {@link VisionImport#execute()} method to invoke the remote operation. <p>
           * {@link
           * VisionImport#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param parent Required. The project in which the ProductSets should be imported.
        Format is
         *        `projects/PROJECT_ID/locations/LOC_ID`.
           * @param content the {@link com.google.api.services.vision.v1.model.ImportProductSetsRequest}
           * @since 1.13
           */
          protected VisionImport(java.lang.String parent, com.google.api.services.vision.v1.model.ImportProductSetsRequest content) {
            super(Vision.this, "POST", REST_PATH, content, com.google.api.services.vision.v1.model.Operation.class);
            this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
          }

          @Override
          public VisionImport set$Xgafv(java.lang.String $Xgafv) {
            return (VisionImport) super.set$Xgafv($Xgafv);
          }

          @Override
          public VisionImport setAccessToken(java.lang.String accessToken) {
            return (VisionImport) super.setAccessToken(accessToken);
          }

          @Override
          public VisionImport setAlt(java.lang.String alt) {
            return (VisionImport) super.setAlt(alt);
          }

          @Override
          public VisionImport setCallback(java.lang.String callback) {
            return (VisionImport) super.setCallback(callback);
          }

          @Override
          public VisionImport setFields(java.lang.String fields) {
            return (VisionImport) super.setFields(fields);
          }

          @Override
          public VisionImport setKey(java.lang.String key) {
            return (VisionImport) super.setKey(key);
          }

          @Override
          public VisionImport setOauthToken(java.lang.String oauthToken) {
            return (VisionImport) super.setOauthToken(oauthToken);
          }

          @Override
          public VisionImport setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (VisionImport) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public VisionImport setQuotaUser(java.lang.String quotaUser) {
            return (VisionImport) super.setQuotaUser(quotaUser);
          }

          @Override
          public VisionImport setUploadType(java.lang.String uploadType) {
            return (VisionImport) super.setUploadType(uploadType);
          }

          @Override
          public VisionImport setUploadProtocol(java.lang.String uploadProtocol) {
            return (VisionImport) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. The project in which the ProductSets should be imported.
           *
           * Format is `projects/PROJECT_ID/locations/LOC_ID`.
           */
          @com.google.api.client.util.Key
          private java.lang.String parent;

          /** Required. The project in which the ProductSets should be imported.

         Format is `projects/PROJECT_ID/locations/LOC_ID`.
           */
          public java.lang.String getParent() {
            return parent;
          }

          /**
           * Required. The project in which the ProductSets should be imported.
           *
           * Format is `projects/PROJECT_ID/locations/LOC_ID`.
           */
          public VisionImport setParent(java.lang.String parent) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
            this.parent = parent;
            return this;
          }

          @Override
          public VisionImport set(String parameterName, Object value) {
            return (VisionImport) super.set(parameterName, value);
          }
        }
        /**
         * Lists ProductSets in an unspecified order.
         *
         * Possible errors:
         *
         * * Returns INVALID_ARGUMENT if page_size is greater than 100, or less   than 1.
         *
         * Create a request for the method "productSets.list".
         *
         * This request holds the parameters needed by the vision server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation.
         *
         * @param parent Required. The project from which ProductSets should be listed.
        Format is
         *        `projects/PROJECT_ID/locations/LOC_ID`.
         * @return the request
         */
        public List list(java.lang.String parent) throws java.io.IOException {
          List result = new List(parent);
          initialize(result);
          return result;
        }

        public class List extends VisionRequest<com.google.api.services.vision.v1.model.ListProductSetsResponse> {

          private static final String REST_PATH = "v1/{+parent}/productSets";

          private final java.util.regex.Pattern PARENT_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+$");

          /**
           * Lists ProductSets in an unspecified order.
           *
           * Possible errors:
           *
           * * Returns INVALID_ARGUMENT if page_size is greater than 100, or less   than 1.
           *
           * Create a request for the method "productSets.list".
           *
           * This request holds the parameters needed by the the vision server.  After setting any optional
           * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
           * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
           * called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param parent Required. The project from which ProductSets should be listed.
        Format is
         *        `projects/PROJECT_ID/locations/LOC_ID`.
           * @since 1.13
           */
          protected List(java.lang.String parent) {
            super(Vision.this, "GET", REST_PATH, null, com.google.api.services.vision.v1.model.ListProductSetsResponse.class);
            this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public List set$Xgafv(java.lang.String $Xgafv) {
            return (List) super.set$Xgafv($Xgafv);
          }

          @Override
          public List setAccessToken(java.lang.String accessToken) {
            return (List) super.setAccessToken(accessToken);
          }

          @Override
          public List setAlt(java.lang.String alt) {
            return (List) super.setAlt(alt);
          }

          @Override
          public List setCallback(java.lang.String callback) {
            return (List) super.setCallback(callback);
          }

          @Override
          public List setFields(java.lang.String fields) {
            return (List) super.setFields(fields);
          }

          @Override
          public List setKey(java.lang.String key) {
            return (List) super.setKey(key);
          }

          @Override
          public List setOauthToken(java.lang.String oauthToken) {
            return (List) super.setOauthToken(oauthToken);
          }

          @Override
          public List setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (List) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public List setQuotaUser(java.lang.String quotaUser) {
            return (List) super.setQuotaUser(quotaUser);
          }

          @Override
          public List setUploadType(java.lang.String uploadType) {
            return (List) super.setUploadType(uploadType);
          }

          @Override
          public List setUploadProtocol(java.lang.String uploadProtocol) {
            return (List) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. The project from which ProductSets should be listed.
           *
           * Format is `projects/PROJECT_ID/locations/LOC_ID`.
           */
          @com.google.api.client.util.Key
          private java.lang.String parent;

          /** Required. The project from which ProductSets should be listed.

         Format is `projects/PROJECT_ID/locations/LOC_ID`.
           */
          public java.lang.String getParent() {
            return parent;
          }

          /**
           * Required. The project from which ProductSets should be listed.
           *
           * Format is `projects/PROJECT_ID/locations/LOC_ID`.
           */
          public List setParent(java.lang.String parent) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
            this.parent = parent;
            return this;
          }

          /** The next_page_token returned from a previous List request, if any. */
          @com.google.api.client.util.Key
          private java.lang.String pageToken;

          /** The next_page_token returned from a previous List request, if any.
           */
          public java.lang.String getPageToken() {
            return pageToken;
          }

          /** The next_page_token returned from a previous List request, if any. */
          public List setPageToken(java.lang.String pageToken) {
            this.pageToken = pageToken;
            return this;
          }

          /** The maximum number of items to return. Default 10, maximum 100. */
          @com.google.api.client.util.Key
          private java.lang.Integer pageSize;

          /** The maximum number of items to return. Default 10, maximum 100.
           */
          public java.lang.Integer getPageSize() {
            return pageSize;
          }

          /** The maximum number of items to return. Default 10, maximum 100. */
          public List setPageSize(java.lang.Integer pageSize) {
            this.pageSize = pageSize;
            return this;
          }

          @Override
          public List set(String parameterName, Object value) {
            return (List) super.set(parameterName, value);
          }
        }
        /**
         * Makes changes to a ProductSet resource. Only display_name can be updated currently.
         *
         * Possible errors:
         *
         * * Returns NOT_FOUND if the ProductSet does not exist. * Returns INVALID_ARGUMENT if display_name
         * is present in update_mask but   missing from the request or longer than 4096 characters.
         *
         * Create a request for the method "productSets.patch".
         *
         * This request holds the parameters needed by the vision server.  After setting any optional
         * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
         *
         * @param name The resource name of the ProductSet.
        Format is:
         *        `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`.
        This field is ignored
         *        when creating a ProductSet.
         * @param content the {@link com.google.api.services.vision.v1.model.ProductSet}
         * @return the request
         */
        public Patch patch(java.lang.String name, com.google.api.services.vision.v1.model.ProductSet content) throws java.io.IOException {
          Patch result = new Patch(name, content);
          initialize(result);
          return result;
        }

        public class Patch extends VisionRequest<com.google.api.services.vision.v1.model.ProductSet> {

          private static final String REST_PATH = "v1/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/productSets/[^/]+$");

          /**
           * Makes changes to a ProductSet resource. Only display_name can be updated currently.
           *
           * Possible errors:
           *
           * * Returns NOT_FOUND if the ProductSet does not exist. * Returns INVALID_ARGUMENT if
           * display_name is present in update_mask but   missing from the request or longer than 4096
           * characters.
           *
           * Create a request for the method "productSets.patch".
           *
           * This request holds the parameters needed by the the vision server.  After setting any optional
           * parameters, call the {@link Patch#execute()} method to invoke the remote operation. <p> {@link
           * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name The resource name of the ProductSet.
        Format is:
         *        `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`.
        This field is ignored
         *        when creating a ProductSet.
           * @param content the {@link com.google.api.services.vision.v1.model.ProductSet}
           * @since 1.13
           */
          protected Patch(java.lang.String name, com.google.api.services.vision.v1.model.ProductSet content) {
            super(Vision.this, "PATCH", REST_PATH, content, com.google.api.services.vision.v1.model.ProductSet.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/productSets/[^/]+$");
            }
          }

          @Override
          public Patch set$Xgafv(java.lang.String $Xgafv) {
            return (Patch) super.set$Xgafv($Xgafv);
          }

          @Override
          public Patch setAccessToken(java.lang.String accessToken) {
            return (Patch) super.setAccessToken(accessToken);
          }

          @Override
          public Patch setAlt(java.lang.String alt) {
            return (Patch) super.setAlt(alt);
          }

          @Override
          public Patch setCallback(java.lang.String callback) {
            return (Patch) super.setCallback(callback);
          }

          @Override
          public Patch setFields(java.lang.String fields) {
            return (Patch) super.setFields(fields);
          }

          @Override
          public Patch setKey(java.lang.String key) {
            return (Patch) super.setKey(key);
          }

          @Override
          public Patch setOauthToken(java.lang.String oauthToken) {
            return (Patch) super.setOauthToken(oauthToken);
          }

          @Override
          public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Patch) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Patch setQuotaUser(java.lang.String quotaUser) {
            return (Patch) super.setQuotaUser(quotaUser);
          }

          @Override
          public Patch setUploadType(java.lang.String uploadType) {
            return (Patch) super.setUploadType(uploadType);
          }

          @Override
          public Patch setUploadProtocol(java.lang.String uploadProtocol) {
            return (Patch) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * The resource name of the ProductSet.
           *
           * Format is: `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`.
           *
           * This field is ignored when creating a ProductSet.
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** The resource name of the ProductSet.

         Format is: `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`.

         This field is ignored when creating a ProductSet.
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * The resource name of the ProductSet.
           *
           * Format is: `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`.
           *
           * This field is ignored when creating a ProductSet.
           */
          public Patch setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/productSets/[^/]+$");
            }
            this.name = name;
            return this;
          }

          /**
           * The FieldMask that specifies which fields to update. If update_mask isn't specified,
           * all mutable fields are to be updated. Valid mask path is `display_name`.
           */
          @com.google.api.client.util.Key
          private String updateMask;

          /** The FieldMask that specifies which fields to update. If update_mask isn't specified, all mutable
         fields are to be updated. Valid mask path is `display_name`.
           */
          public String getUpdateMask() {
            return updateMask;
          }

          /**
           * The FieldMask that specifies which fields to update. If update_mask isn't specified,
           * all mutable fields are to be updated. Valid mask path is `display_name`.
           */
          public Patch setUpdateMask(String updateMask) {
            this.updateMask = updateMask;
            return this;
          }

          @Override
          public Patch set(String parameterName, Object value) {
            return (Patch) super.set(parameterName, value);
          }
        }
        /**
         * Removes a Product from the specified ProductSet.
         *
         * Create a request for the method "productSets.removeProduct".
         *
         * This request holds the parameters needed by the vision server.  After setting any optional
         * parameters, call the {@link RemoveProduct#execute()} method to invoke the remote operation.
         *
         * @param name Required. The resource name for the ProductSet to modify.
        Format is:
         *        `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`
         * @param content the {@link com.google.api.services.vision.v1.model.RemoveProductFromProductSetRequest}
         * @return the request
         */
        public RemoveProduct removeProduct(java.lang.String name, com.google.api.services.vision.v1.model.RemoveProductFromProductSetRequest content) throws java.io.IOException {
          RemoveProduct result = new RemoveProduct(name, content);
          initialize(result);
          return result;
        }

        public class RemoveProduct extends VisionRequest<com.google.api.services.vision.v1.model.Empty> {

          private static final String REST_PATH = "v1/{+name}:removeProduct";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/productSets/[^/]+$");

          /**
           * Removes a Product from the specified ProductSet.
           *
           * Create a request for the method "productSets.removeProduct".
           *
           * This request holds the parameters needed by the the vision server.  After setting any optional
           * parameters, call the {@link RemoveProduct#execute()} method to invoke the remote operation. <p>
           * {@link RemoveProduct#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientR
           * equest)} must be called to initialize this instance immediately after invoking the constructor.
           * </p>
           *
           * @param name Required. The resource name for the ProductSet to modify.
        Format is:
         *        `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`
           * @param content the {@link com.google.api.services.vision.v1.model.RemoveProductFromProductSetRequest}
           * @since 1.13
           */
          protected RemoveProduct(java.lang.String name, com.google.api.services.vision.v1.model.RemoveProductFromProductSetRequest content) {
            super(Vision.this, "POST", REST_PATH, content, com.google.api.services.vision.v1.model.Empty.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/productSets/[^/]+$");
            }
          }

          @Override
          public RemoveProduct set$Xgafv(java.lang.String $Xgafv) {
            return (RemoveProduct) super.set$Xgafv($Xgafv);
          }

          @Override
          public RemoveProduct setAccessToken(java.lang.String accessToken) {
            return (RemoveProduct) super.setAccessToken(accessToken);
          }

          @Override
          public RemoveProduct setAlt(java.lang.String alt) {
            return (RemoveProduct) super.setAlt(alt);
          }

          @Override
          public RemoveProduct setCallback(java.lang.String callback) {
            return (RemoveProduct) super.setCallback(callback);
          }

          @Override
          public RemoveProduct setFields(java.lang.String fields) {
            return (RemoveProduct) super.setFields(fields);
          }

          @Override
          public RemoveProduct setKey(java.lang.String key) {
            return (RemoveProduct) super.setKey(key);
          }

          @Override
          public RemoveProduct setOauthToken(java.lang.String oauthToken) {
            return (RemoveProduct) super.setOauthToken(oauthToken);
          }

          @Override
          public RemoveProduct setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (RemoveProduct) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public RemoveProduct setQuotaUser(java.lang.String quotaUser) {
            return (RemoveProduct) super.setQuotaUser(quotaUser);
          }

          @Override
          public RemoveProduct setUploadType(java.lang.String uploadType) {
            return (RemoveProduct) super.setUploadType(uploadType);
          }

          @Override
          public RemoveProduct setUploadProtocol(java.lang.String uploadProtocol) {
            return (RemoveProduct) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. The resource name for the ProductSet to modify.
           *
           * Format is: `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Required. The resource name for the ProductSet to modify.

         Format is: `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * Required. The resource name for the ProductSet to modify.
           *
           * Format is: `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`
           */
          public RemoveProduct setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/productSets/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public RemoveProduct set(String parameterName, Object value) {
            return (RemoveProduct) super.set(parameterName, value);
          }
        }

        /**
         * An accessor for creating requests from the Products collection.
         *
         * <p>The typical use is:</p>
         * <pre>
         *   {@code Vision vision = new Vision(...);}
         *   {@code Vision.Products.List request = vision.products().list(parameters ...)}
         * </pre>
         *
         * @return the resource collection
         */
        public Products products() {
          return new Products();
        }

        /**
         * The "products" collection of methods.
         */
        public class Products {

          /**
           * Lists the Products in a ProductSet, in an unspecified order. If the ProductSet does not exist,
           * the products field of the response will be empty.
           *
           * Possible errors:
           *
           * * Returns INVALID_ARGUMENT if page_size is greater than 100 or less than 1.
           *
           * Create a request for the method "products.list".
           *
           * This request holds the parameters needed by the vision server.  After setting any optional
           * parameters, call the {@link List#execute()} method to invoke the remote operation.
           *
           * @param name Required. The ProductSet resource for which to retrieve Products.
          Format is:
           *        `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`
           * @return the request
           */
          public List list(java.lang.String name) throws java.io.IOException {
            List result = new List(name);
            initialize(result);
            return result;
          }

          public class List extends VisionRequest<com.google.api.services.vision.v1.model.ListProductsInProductSetResponse> {

            private static final String REST_PATH = "v1/{+name}/products";

            private final java.util.regex.Pattern NAME_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/productSets/[^/]+$");

            /**
             * Lists the Products in a ProductSet, in an unspecified order. If the ProductSet does not exist,
             * the products field of the response will be empty.
             *
             * Possible errors:
             *
             * * Returns INVALID_ARGUMENT if page_size is greater than 100 or less than 1.
             *
             * Create a request for the method "products.list".
             *
             * This request holds the parameters needed by the the vision server.  After setting any optional
             * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
             * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
             * called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param name Required. The ProductSet resource for which to retrieve Products.
          Format is:
           *        `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`
             * @since 1.13
             */
            protected List(java.lang.String name) {
              super(Vision.this, "GET", REST_PATH, null, com.google.api.services.vision.v1.model.ListProductsInProductSetResponse.class);
              this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/productSets/[^/]+$");
              }
            }

            @Override
            public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
              return super.executeUsingHead();
            }

            @Override
            public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
              return super.buildHttpRequestUsingHead();
            }

            @Override
            public List set$Xgafv(java.lang.String $Xgafv) {
              return (List) super.set$Xgafv($Xgafv);
            }

            @Override
            public List setAccessToken(java.lang.String accessToken) {
              return (List) super.setAccessToken(accessToken);
            }

            @Override
            public List setAlt(java.lang.String alt) {
              return (List) super.setAlt(alt);
            }

            @Override
            public List setCallback(java.lang.String callback) {
              return (List) super.setCallback(callback);
            }

            @Override
            public List setFields(java.lang.String fields) {
              return (List) super.setFields(fields);
            }

            @Override
            public List setKey(java.lang.String key) {
              return (List) super.setKey(key);
            }

            @Override
            public List setOauthToken(java.lang.String oauthToken) {
              return (List) super.setOauthToken(oauthToken);
            }

            @Override
            public List setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (List) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public List setQuotaUser(java.lang.String quotaUser) {
              return (List) super.setQuotaUser(quotaUser);
            }

            @Override
            public List setUploadType(java.lang.String uploadType) {
              return (List) super.setUploadType(uploadType);
            }

            @Override
            public List setUploadProtocol(java.lang.String uploadProtocol) {
              return (List) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * Required. The ProductSet resource for which to retrieve Products.
             *
             * Format is: `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`
             */
            @com.google.api.client.util.Key
            private java.lang.String name;

            /** Required. The ProductSet resource for which to retrieve Products.

           Format is: `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`
             */
            public java.lang.String getName() {
              return name;
            }

            /**
             * Required. The ProductSet resource for which to retrieve Products.
             *
             * Format is: `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`
             */
            public List setName(java.lang.String name) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/productSets/[^/]+$");
              }
              this.name = name;
              return this;
            }

            /** The next_page_token returned from a previous List request, if any. */
            @com.google.api.client.util.Key
            private java.lang.String pageToken;

            /** The next_page_token returned from a previous List request, if any.
             */
            public java.lang.String getPageToken() {
              return pageToken;
            }

            /** The next_page_token returned from a previous List request, if any. */
            public List setPageToken(java.lang.String pageToken) {
              this.pageToken = pageToken;
              return this;
            }

            /** The maximum number of items to return. Default 10, maximum 100. */
            @com.google.api.client.util.Key
            private java.lang.Integer pageSize;

            /** The maximum number of items to return. Default 10, maximum 100.
             */
            public java.lang.Integer getPageSize() {
              return pageSize;
            }

            /** The maximum number of items to return. Default 10, maximum 100. */
            public List setPageSize(java.lang.Integer pageSize) {
              this.pageSize = pageSize;
              return this;
            }

            @Override
            public List set(String parameterName, Object value) {
              return (List) super.set(parameterName, value);
            }
          }

        }
      }
      /**
       * An accessor for creating requests from the Products collection.
       *
       * <p>The typical use is:</p>
       * <pre>
       *   {@code Vision vision = new Vision(...);}
       *   {@code Vision.Products.List request = vision.products().list(parameters ...)}
       * </pre>
       *
       * @return the resource collection
       */
      public Products products() {
        return new Products();
      }

      /**
       * The "products" collection of methods.
       */
      public class Products {

        /**
         * Creates and returns a new product resource.
         *
         * Possible errors:
         *
         * * Returns INVALID_ARGUMENT if display_name is missing or longer than 4096   characters. * Returns
         * INVALID_ARGUMENT if description is longer than 4096 characters. * Returns INVALID_ARGUMENT if
         * product_category is missing or invalid.
         *
         * Create a request for the method "products.create".
         *
         * This request holds the parameters needed by the vision server.  After setting any optional
         * parameters, call the {@link Create#execute()} method to invoke the remote operation.
         *
         * @param parent Required. The project in which the Product should be created.
        Format is
         *        `projects/PROJECT_ID/locations/LOC_ID`.
         * @param content the {@link com.google.api.services.vision.v1.model.Product}
         * @return the request
         */
        public Create create(java.lang.String parent, com.google.api.services.vision.v1.model.Product content) throws java.io.IOException {
          Create result = new Create(parent, content);
          initialize(result);
          return result;
        }

        public class Create extends VisionRequest<com.google.api.services.vision.v1.model.Product> {

          private static final String REST_PATH = "v1/{+parent}/products";

          private final java.util.regex.Pattern PARENT_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+$");

          /**
           * Creates and returns a new product resource.
           *
           * Possible errors:
           *
           * * Returns INVALID_ARGUMENT if display_name is missing or longer than 4096   characters. *
           * Returns INVALID_ARGUMENT if description is longer than 4096 characters. * Returns
           * INVALID_ARGUMENT if product_category is missing or invalid.
           *
           * Create a request for the method "products.create".
           *
           * This request holds the parameters needed by the the vision server.  After setting any optional
           * parameters, call the {@link Create#execute()} method to invoke the remote operation. <p> {@link
           * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param parent Required. The project in which the Product should be created.
        Format is
         *        `projects/PROJECT_ID/locations/LOC_ID`.
           * @param content the {@link com.google.api.services.vision.v1.model.Product}
           * @since 1.13
           */
          protected Create(java.lang.String parent, com.google.api.services.vision.v1.model.Product content) {
            super(Vision.this, "POST", REST_PATH, content, com.google.api.services.vision.v1.model.Product.class);
            this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
          }

          @Override
          public Create set$Xgafv(java.lang.String $Xgafv) {
            return (Create) super.set$Xgafv($Xgafv);
          }

          @Override
          public Create setAccessToken(java.lang.String accessToken) {
            return (Create) super.setAccessToken(accessToken);
          }

          @Override
          public Create setAlt(java.lang.String alt) {
            return (Create) super.setAlt(alt);
          }

          @Override
          public Create setCallback(java.lang.String callback) {
            return (Create) super.setCallback(callback);
          }

          @Override
          public Create setFields(java.lang.String fields) {
            return (Create) super.setFields(fields);
          }

          @Override
          public Create setKey(java.lang.String key) {
            return (Create) super.setKey(key);
          }

          @Override
          public Create setOauthToken(java.lang.String oauthToken) {
            return (Create) super.setOauthToken(oauthToken);
          }

          @Override
          public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Create) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Create setQuotaUser(java.lang.String quotaUser) {
            return (Create) super.setQuotaUser(quotaUser);
          }

          @Override
          public Create setUploadType(java.lang.String uploadType) {
            return (Create) super.setUploadType(uploadType);
          }

          @Override
          public Create setUploadProtocol(java.lang.String uploadProtocol) {
            return (Create) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. The project in which the Product should be created.
           *
           * Format is `projects/PROJECT_ID/locations/LOC_ID`.
           */
          @com.google.api.client.util.Key
          private java.lang.String parent;

          /** Required. The project in which the Product should be created.

         Format is `projects/PROJECT_ID/locations/LOC_ID`.
           */
          public java.lang.String getParent() {
            return parent;
          }

          /**
           * Required. The project in which the Product should be created.
           *
           * Format is `projects/PROJECT_ID/locations/LOC_ID`.
           */
          public Create setParent(java.lang.String parent) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
            this.parent = parent;
            return this;
          }

          /**
           * A user-supplied resource id for this Product. If set, the server will attempt to use
           * this value as the resource id. If it is already in use, an error is returned with code
           * ALREADY_EXISTS. Must be at most 128 characters long. It cannot contain the character
           * `/`.
           */
          @com.google.api.client.util.Key
          private java.lang.String productId;

          /** A user-supplied resource id for this Product. If set, the server will attempt to use this value as
         the resource id. If it is already in use, an error is returned with code ALREADY_EXISTS. Must be at
         most 128 characters long. It cannot contain the character `/`.
           */
          public java.lang.String getProductId() {
            return productId;
          }

          /**
           * A user-supplied resource id for this Product. If set, the server will attempt to use
           * this value as the resource id. If it is already in use, an error is returned with code
           * ALREADY_EXISTS. Must be at most 128 characters long. It cannot contain the character
           * `/`.
           */
          public Create setProductId(java.lang.String productId) {
            this.productId = productId;
            return this;
          }

          @Override
          public Create set(String parameterName, Object value) {
            return (Create) super.set(parameterName, value);
          }
        }
        /**
         * Permanently deletes a product and its reference images.
         *
         * Metadata of the product and all its images will be deleted right away, but search queries against
         * ProductSets containing the product may still work until all related caches are refreshed.
         *
         * Create a request for the method "products.delete".
         *
         * This request holds the parameters needed by the vision server.  After setting any optional
         * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
         *
         * @param name Required. Resource name of product to delete.
        Format is:
         *        `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`
         * @return the request
         */
        public Delete delete(java.lang.String name) throws java.io.IOException {
          Delete result = new Delete(name);
          initialize(result);
          return result;
        }

        public class Delete extends VisionRequest<com.google.api.services.vision.v1.model.Empty> {

          private static final String REST_PATH = "v1/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/products/[^/]+$");

          /**
           * Permanently deletes a product and its reference images.
           *
           * Metadata of the product and all its images will be deleted right away, but search queries
           * against ProductSets containing the product may still work until all related caches are
           * refreshed.
           *
           * Create a request for the method "products.delete".
           *
           * This request holds the parameters needed by the the vision server.  After setting any optional
           * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
           * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name Required. Resource name of product to delete.
        Format is:
         *        `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`
           * @since 1.13
           */
          protected Delete(java.lang.String name) {
            super(Vision.this, "DELETE", REST_PATH, null, com.google.api.services.vision.v1.model.Empty.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/products/[^/]+$");
            }
          }

          @Override
          public Delete set$Xgafv(java.lang.String $Xgafv) {
            return (Delete) super.set$Xgafv($Xgafv);
          }

          @Override
          public Delete setAccessToken(java.lang.String accessToken) {
            return (Delete) super.setAccessToken(accessToken);
          }

          @Override
          public Delete setAlt(java.lang.String alt) {
            return (Delete) super.setAlt(alt);
          }

          @Override
          public Delete setCallback(java.lang.String callback) {
            return (Delete) super.setCallback(callback);
          }

          @Override
          public Delete setFields(java.lang.String fields) {
            return (Delete) super.setFields(fields);
          }

          @Override
          public Delete setKey(java.lang.String key) {
            return (Delete) super.setKey(key);
          }

          @Override
          public Delete setOauthToken(java.lang.String oauthToken) {
            return (Delete) super.setOauthToken(oauthToken);
          }

          @Override
          public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Delete) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Delete setQuotaUser(java.lang.String quotaUser) {
            return (Delete) super.setQuotaUser(quotaUser);
          }

          @Override
          public Delete setUploadType(java.lang.String uploadType) {
            return (Delete) super.setUploadType(uploadType);
          }

          @Override
          public Delete setUploadProtocol(java.lang.String uploadProtocol) {
            return (Delete) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. Resource name of product to delete.
           *
           * Format is: `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Required. Resource name of product to delete.

         Format is: `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * Required. Resource name of product to delete.
           *
           * Format is: `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`
           */
          public Delete setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/products/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Delete set(String parameterName, Object value) {
            return (Delete) super.set(parameterName, value);
          }
        }
        /**
         * Gets information associated with a Product.
         *
         * Possible errors:
         *
         * * Returns NOT_FOUND if the Product does not exist.
         *
         * Create a request for the method "products.get".
         *
         * This request holds the parameters needed by the vision server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation.
         *
         * @param name Required. Resource name of the Product to get.
        Format is:
         *        `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`
         * @return the request
         */
        public Get get(java.lang.String name) throws java.io.IOException {
          Get result = new Get(name);
          initialize(result);
          return result;
        }

        public class Get extends VisionRequest<com.google.api.services.vision.v1.model.Product> {

          private static final String REST_PATH = "v1/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/products/[^/]+$");

          /**
           * Gets information associated with a Product.
           *
           * Possible errors:
           *
           * * Returns NOT_FOUND if the Product does not exist.
           *
           * Create a request for the method "products.get".
           *
           * This request holds the parameters needed by the the vision server.  After setting any optional
           * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
           * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
           * called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name Required. Resource name of the Product to get.
        Format is:
         *        `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`
           * @since 1.13
           */
          protected Get(java.lang.String name) {
            super(Vision.this, "GET", REST_PATH, null, com.google.api.services.vision.v1.model.Product.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/products/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public Get set$Xgafv(java.lang.String $Xgafv) {
            return (Get) super.set$Xgafv($Xgafv);
          }

          @Override
          public Get setAccessToken(java.lang.String accessToken) {
            return (Get) super.setAccessToken(accessToken);
          }

          @Override
          public Get setAlt(java.lang.String alt) {
            return (Get) super.setAlt(alt);
          }

          @Override
          public Get setCallback(java.lang.String callback) {
            return (Get) super.setCallback(callback);
          }

          @Override
          public Get setFields(java.lang.String fields) {
            return (Get) super.setFields(fields);
          }

          @Override
          public Get setKey(java.lang.String key) {
            return (Get) super.setKey(key);
          }

          @Override
          public Get setOauthToken(java.lang.String oauthToken) {
            return (Get) super.setOauthToken(oauthToken);
          }

          @Override
          public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Get) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Get setQuotaUser(java.lang.String quotaUser) {
            return (Get) super.setQuotaUser(quotaUser);
          }

          @Override
          public Get setUploadType(java.lang.String uploadType) {
            return (Get) super.setUploadType(uploadType);
          }

          @Override
          public Get setUploadProtocol(java.lang.String uploadProtocol) {
            return (Get) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. Resource name of the Product to get.
           *
           * Format is: `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Required. Resource name of the Product to get.

         Format is: `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * Required. Resource name of the Product to get.
           *
           * Format is: `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`
           */
          public Get setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/products/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Get set(String parameterName, Object value) {
            return (Get) super.set(parameterName, value);
          }
        }
        /**
         * Lists products in an unspecified order.
         *
         * Possible errors:
         *
         * * Returns INVALID_ARGUMENT if page_size is greater than 100 or less than 1.
         *
         * Create a request for the method "products.list".
         *
         * This request holds the parameters needed by the vision server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation.
         *
         * @param parent Required. The project OR ProductSet from which Products should be listed.
        Format:
         *        `projects/PROJECT_ID/locations/LOC_ID`
         * @return the request
         */
        public List list(java.lang.String parent) throws java.io.IOException {
          List result = new List(parent);
          initialize(result);
          return result;
        }

        public class List extends VisionRequest<com.google.api.services.vision.v1.model.ListProductsResponse> {

          private static final String REST_PATH = "v1/{+parent}/products";

          private final java.util.regex.Pattern PARENT_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+$");

          /**
           * Lists products in an unspecified order.
           *
           * Possible errors:
           *
           * * Returns INVALID_ARGUMENT if page_size is greater than 100 or less than 1.
           *
           * Create a request for the method "products.list".
           *
           * This request holds the parameters needed by the the vision server.  After setting any optional
           * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
           * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
           * called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param parent Required. The project OR ProductSet from which Products should be listed.
        Format:
         *        `projects/PROJECT_ID/locations/LOC_ID`
           * @since 1.13
           */
          protected List(java.lang.String parent) {
            super(Vision.this, "GET", REST_PATH, null, com.google.api.services.vision.v1.model.ListProductsResponse.class);
            this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public List set$Xgafv(java.lang.String $Xgafv) {
            return (List) super.set$Xgafv($Xgafv);
          }

          @Override
          public List setAccessToken(java.lang.String accessToken) {
            return (List) super.setAccessToken(accessToken);
          }

          @Override
          public List setAlt(java.lang.String alt) {
            return (List) super.setAlt(alt);
          }

          @Override
          public List setCallback(java.lang.String callback) {
            return (List) super.setCallback(callback);
          }

          @Override
          public List setFields(java.lang.String fields) {
            return (List) super.setFields(fields);
          }

          @Override
          public List setKey(java.lang.String key) {
            return (List) super.setKey(key);
          }

          @Override
          public List setOauthToken(java.lang.String oauthToken) {
            return (List) super.setOauthToken(oauthToken);
          }

          @Override
          public List setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (List) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public List setQuotaUser(java.lang.String quotaUser) {
            return (List) super.setQuotaUser(quotaUser);
          }

          @Override
          public List setUploadType(java.lang.String uploadType) {
            return (List) super.setUploadType(uploadType);
          }

          @Override
          public List setUploadProtocol(java.lang.String uploadProtocol) {
            return (List) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. The project OR ProductSet from which Products should be listed.
           *
           * Format: `projects/PROJECT_ID/locations/LOC_ID`
           */
          @com.google.api.client.util.Key
          private java.lang.String parent;

          /** Required. The project OR ProductSet from which Products should be listed.

         Format: `projects/PROJECT_ID/locations/LOC_ID`
           */
          public java.lang.String getParent() {
            return parent;
          }

          /**
           * Required. The project OR ProductSet from which Products should be listed.
           *
           * Format: `projects/PROJECT_ID/locations/LOC_ID`
           */
          public List setParent(java.lang.String parent) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
            this.parent = parent;
            return this;
          }

          /** The next_page_token returned from a previous List request, if any. */
          @com.google.api.client.util.Key
          private java.lang.String pageToken;

          /** The next_page_token returned from a previous List request, if any.
           */
          public java.lang.String getPageToken() {
            return pageToken;
          }

          /** The next_page_token returned from a previous List request, if any. */
          public List setPageToken(java.lang.String pageToken) {
            this.pageToken = pageToken;
            return this;
          }

          /** The maximum number of items to return. Default 10, maximum 100. */
          @com.google.api.client.util.Key
          private java.lang.Integer pageSize;

          /** The maximum number of items to return. Default 10, maximum 100.
           */
          public java.lang.Integer getPageSize() {
            return pageSize;
          }

          /** The maximum number of items to return. Default 10, maximum 100. */
          public List setPageSize(java.lang.Integer pageSize) {
            this.pageSize = pageSize;
            return this;
          }

          @Override
          public List set(String parameterName, Object value) {
            return (List) super.set(parameterName, value);
          }
        }
        /**
         * Makes changes to a Product resource. Only the `display_name`, `description`, and `labels` fields
         * can be updated right now.
         *
         * If labels are updated, the change will not be reflected in queries until the next index time.
         *
         * Possible errors:
         *
         * * Returns NOT_FOUND if the Product does not exist. * Returns INVALID_ARGUMENT if display_name is
         * present in update_mask but is   missing from the request or longer than 4096 characters. *
         * Returns INVALID_ARGUMENT if description is present in update_mask but is   longer than 4096
         * characters. * Returns INVALID_ARGUMENT if product_category is present in update_mask.
         *
         * Create a request for the method "products.patch".
         *
         * This request holds the parameters needed by the vision server.  After setting any optional
         * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
         *
         * @param name The resource name of the product.
        Format is:
         *        `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`.
        This field is ignored when
         *        creating a product.
         * @param content the {@link com.google.api.services.vision.v1.model.Product}
         * @return the request
         */
        public Patch patch(java.lang.String name, com.google.api.services.vision.v1.model.Product content) throws java.io.IOException {
          Patch result = new Patch(name, content);
          initialize(result);
          return result;
        }

        public class Patch extends VisionRequest<com.google.api.services.vision.v1.model.Product> {

          private static final String REST_PATH = "v1/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/products/[^/]+$");

          /**
           * Makes changes to a Product resource. Only the `display_name`, `description`, and `labels`
           * fields can be updated right now.
           *
           * If labels are updated, the change will not be reflected in queries until the next index time.
           *
           * Possible errors:
           *
           * * Returns NOT_FOUND if the Product does not exist. * Returns INVALID_ARGUMENT if display_name
           * is present in update_mask but is   missing from the request or longer than 4096 characters. *
           * Returns INVALID_ARGUMENT if description is present in update_mask but is   longer than 4096
           * characters. * Returns INVALID_ARGUMENT if product_category is present in update_mask.
           *
           * Create a request for the method "products.patch".
           *
           * This request holds the parameters needed by the the vision server.  After setting any optional
           * parameters, call the {@link Patch#execute()} method to invoke the remote operation. <p> {@link
           * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name The resource name of the product.
        Format is:
         *        `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`.
        This field is ignored when
         *        creating a product.
           * @param content the {@link com.google.api.services.vision.v1.model.Product}
           * @since 1.13
           */
          protected Patch(java.lang.String name, com.google.api.services.vision.v1.model.Product content) {
            super(Vision.this, "PATCH", REST_PATH, content, com.google.api.services.vision.v1.model.Product.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/products/[^/]+$");
            }
          }

          @Override
          public Patch set$Xgafv(java.lang.String $Xgafv) {
            return (Patch) super.set$Xgafv($Xgafv);
          }

          @Override
          public Patch setAccessToken(java.lang.String accessToken) {
            return (Patch) super.setAccessToken(accessToken);
          }

          @Override
          public Patch setAlt(java.lang.String alt) {
            return (Patch) super.setAlt(alt);
          }

          @Override
          public Patch setCallback(java.lang.String callback) {
            return (Patch) super.setCallback(callback);
          }

          @Override
          public Patch setFields(java.lang.String fields) {
            return (Patch) super.setFields(fields);
          }

          @Override
          public Patch setKey(java.lang.String key) {
            return (Patch) super.setKey(key);
          }

          @Override
          public Patch setOauthToken(java.lang.String oauthToken) {
            return (Patch) super.setOauthToken(oauthToken);
          }

          @Override
          public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Patch) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Patch setQuotaUser(java.lang.String quotaUser) {
            return (Patch) super.setQuotaUser(quotaUser);
          }

          @Override
          public Patch setUploadType(java.lang.String uploadType) {
            return (Patch) super.setUploadType(uploadType);
          }

          @Override
          public Patch setUploadProtocol(java.lang.String uploadProtocol) {
            return (Patch) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * The resource name of the product.
           *
           * Format is: `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`.
           *
           * This field is ignored when creating a product.
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** The resource name of the product.

         Format is: `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`.

         This field is ignored when creating a product.
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * The resource name of the product.
           *
           * Format is: `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`.
           *
           * This field is ignored when creating a product.
           */
          public Patch setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/products/[^/]+$");
            }
            this.name = name;
            return this;
          }

          /**
           * The FieldMask that specifies which fields to update. If update_mask isn't specified,
           * all mutable fields are to be updated. Valid mask paths include `product_labels`,
           * `display_name`, and `description`.
           */
          @com.google.api.client.util.Key
          private String updateMask;

          /** The FieldMask that specifies which fields to update. If update_mask isn't specified, all mutable
         fields are to be updated. Valid mask paths include `product_labels`, `display_name`, and
         `description`.
           */
          public String getUpdateMask() {
            return updateMask;
          }

          /**
           * The FieldMask that specifies which fields to update. If update_mask isn't specified,
           * all mutable fields are to be updated. Valid mask paths include `product_labels`,
           * `display_name`, and `description`.
           */
          public Patch setUpdateMask(String updateMask) {
            this.updateMask = updateMask;
            return this;
          }

          @Override
          public Patch set(String parameterName, Object value) {
            return (Patch) super.set(parameterName, value);
          }
        }
        /**
         * Asynchronous API to delete all Products in a ProductSet or all Products that are in no
         * ProductSet.
         *
         * If a Product is a member of the specified ProductSet in addition to other ProductSets, the
         * Product will still be deleted.
         *
         * It is recommended to not delete the specified ProductSet until after this operation has
         * completed. It is also recommended to not add any of the Products involved in the batch delete to
         * a new ProductSet while this operation is running because those Products may still end up deleted.
         *
         * It's not possible to undo the PurgeProducts operation. Therefore, it is recommended to keep the
         * csv files used in ImportProductSets (if that was how you originally built the Product Set) before
         * starting PurgeProducts, in case you need to re-import the data after deletion.
         *
         * If the plan is to purge all of the Products from a ProductSet and then re-use the empty
         * ProductSet to re-import new Products into the empty ProductSet, you must wait until the
         * PurgeProducts operation has finished for that ProductSet.
         *
         * The google.longrunning.Operation API can be used to keep track of the progress and results of the
         * request. `Operation.metadata` contains `BatchOperationMetadata`. (progress)
         *
         * Create a request for the method "products.purge".
         *
         * This request holds the parameters needed by the vision server.  After setting any optional
         * parameters, call the {@link Purge#execute()} method to invoke the remote operation.
         *
         * @param parent Required. The project and location in which the Products should be deleted.
        Format is
         *        `projects/PROJECT_ID/locations/LOC_ID`.
         * @param content the {@link com.google.api.services.vision.v1.model.PurgeProductsRequest}
         * @return the request
         */
        public Purge purge(java.lang.String parent, com.google.api.services.vision.v1.model.PurgeProductsRequest content) throws java.io.IOException {
          Purge result = new Purge(parent, content);
          initialize(result);
          return result;
        }

        public class Purge extends VisionRequest<com.google.api.services.vision.v1.model.Operation> {

          private static final String REST_PATH = "v1/{+parent}/products:purge";

          private final java.util.regex.Pattern PARENT_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+$");

          /**
           * Asynchronous API to delete all Products in a ProductSet or all Products that are in no
           * ProductSet.
           *
           * If a Product is a member of the specified ProductSet in addition to other ProductSets, the
           * Product will still be deleted.
           *
           * It is recommended to not delete the specified ProductSet until after this operation has
           * completed. It is also recommended to not add any of the Products involved in the batch delete
           * to a new ProductSet while this operation is running because those Products may still end up
           * deleted.
           *
           * It's not possible to undo the PurgeProducts operation. Therefore, it is recommended to keep the
           * csv files used in ImportProductSets (if that was how you originally built the Product Set)
           * before starting PurgeProducts, in case you need to re-import the data after deletion.
           *
           * If the plan is to purge all of the Products from a ProductSet and then re-use the empty
           * ProductSet to re-import new Products into the empty ProductSet, you must wait until the
           * PurgeProducts operation has finished for that ProductSet.
           *
           * The google.longrunning.Operation API can be used to keep track of the progress and results of
           * the request. `Operation.metadata` contains `BatchOperationMetadata`. (progress)
           *
           * Create a request for the method "products.purge".
           *
           * This request holds the parameters needed by the the vision server.  After setting any optional
           * parameters, call the {@link Purge#execute()} method to invoke the remote operation. <p> {@link
           * Purge#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param parent Required. The project and location in which the Products should be deleted.
        Format is
         *        `projects/PROJECT_ID/locations/LOC_ID`.
           * @param content the {@link com.google.api.services.vision.v1.model.PurgeProductsRequest}
           * @since 1.13
           */
          protected Purge(java.lang.String parent, com.google.api.services.vision.v1.model.PurgeProductsRequest content) {
            super(Vision.this, "POST", REST_PATH, content, com.google.api.services.vision.v1.model.Operation.class);
            this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
          }

          @Override
          public Purge set$Xgafv(java.lang.String $Xgafv) {
            return (Purge) super.set$Xgafv($Xgafv);
          }

          @Override
          public Purge setAccessToken(java.lang.String accessToken) {
            return (Purge) super.setAccessToken(accessToken);
          }

          @Override
          public Purge setAlt(java.lang.String alt) {
            return (Purge) super.setAlt(alt);
          }

          @Override
          public Purge setCallback(java.lang.String callback) {
            return (Purge) super.setCallback(callback);
          }

          @Override
          public Purge setFields(java.lang.String fields) {
            return (Purge) super.setFields(fields);
          }

          @Override
          public Purge setKey(java.lang.String key) {
            return (Purge) super.setKey(key);
          }

          @Override
          public Purge setOauthToken(java.lang.String oauthToken) {
            return (Purge) super.setOauthToken(oauthToken);
          }

          @Override
          public Purge setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Purge) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Purge setQuotaUser(java.lang.String quotaUser) {
            return (Purge) super.setQuotaUser(quotaUser);
          }

          @Override
          public Purge setUploadType(java.lang.String uploadType) {
            return (Purge) super.setUploadType(uploadType);
          }

          @Override
          public Purge setUploadProtocol(java.lang.String uploadProtocol) {
            return (Purge) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. The project and location in which the Products should be deleted.
           *
           * Format is `projects/PROJECT_ID/locations/LOC_ID`.
           */
          @com.google.api.client.util.Key
          private java.lang.String parent;

          /** Required. The project and location in which the Products should be deleted.

         Format is `projects/PROJECT_ID/locations/LOC_ID`.
           */
          public java.lang.String getParent() {
            return parent;
          }

          /**
           * Required. The project and location in which the Products should be deleted.
           *
           * Format is `projects/PROJECT_ID/locations/LOC_ID`.
           */
          public Purge setParent(java.lang.String parent) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
            this.parent = parent;
            return this;
          }

          @Override
          public Purge set(String parameterName, Object value) {
            return (Purge) super.set(parameterName, value);
          }
        }

        /**
         * An accessor for creating requests from the ReferenceImages collection.
         *
         * <p>The typical use is:</p>
         * <pre>
         *   {@code Vision vision = new Vision(...);}
         *   {@code Vision.ReferenceImages.List request = vision.referenceImages().list(parameters ...)}
         * </pre>
         *
         * @return the resource collection
         */
        public ReferenceImages referenceImages() {
          return new ReferenceImages();
        }

        /**
         * The "referenceImages" collection of methods.
         */
        public class ReferenceImages {

          /**
           * Creates and returns a new ReferenceImage resource.
           *
           * The `bounding_poly` field is optional. If `bounding_poly` is not specified, the system will try
           * to detect regions of interest in the image that are compatible with the product_category on the
           * parent product. If it is specified, detection is ALWAYS skipped. The system converts polygons
           * into non-rotated rectangles.
           *
           * Note that the pipeline will resize the image if the image resolution is too large to process
           * (above 50MP).
           *
           * Possible errors:
           *
           * * Returns INVALID_ARGUMENT if the image_uri is missing or longer than 4096   characters. *
           * Returns INVALID_ARGUMENT if the product does not exist. * Returns INVALID_ARGUMENT if
           * bounding_poly is not provided, and nothing   compatible with the parent product's
           * product_category is detected. * Returns INVALID_ARGUMENT if bounding_poly contains more than 10
           * polygons.
           *
           * Create a request for the method "referenceImages.create".
           *
           * This request holds the parameters needed by the vision server.  After setting any optional
           * parameters, call the {@link Create#execute()} method to invoke the remote operation.
           *
           * @param parent Required. Resource name of the product in which to create the reference image.
          Format is
           *        `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`.
           * @param content the {@link com.google.api.services.vision.v1.model.ReferenceImage}
           * @return the request
           */
          public Create create(java.lang.String parent, com.google.api.services.vision.v1.model.ReferenceImage content) throws java.io.IOException {
            Create result = new Create(parent, content);
            initialize(result);
            return result;
          }

          public class Create extends VisionRequest<com.google.api.services.vision.v1.model.ReferenceImage> {

            private static final String REST_PATH = "v1/{+parent}/referenceImages";

            private final java.util.regex.Pattern PARENT_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/products/[^/]+$");

            /**
             * Creates and returns a new ReferenceImage resource.
             *
             * The `bounding_poly` field is optional. If `bounding_poly` is not specified, the system will try
             * to detect regions of interest in the image that are compatible with the product_category on the
             * parent product. If it is specified, detection is ALWAYS skipped. The system converts polygons
             * into non-rotated rectangles.
             *
             * Note that the pipeline will resize the image if the image resolution is too large to process
             * (above 50MP).
             *
             * Possible errors:
             *
             * * Returns INVALID_ARGUMENT if the image_uri is missing or longer than 4096   characters. *
             * Returns INVALID_ARGUMENT if the product does not exist. * Returns INVALID_ARGUMENT if
             * bounding_poly is not provided, and nothing   compatible with the parent product's
             * product_category is detected. * Returns INVALID_ARGUMENT if bounding_poly contains more than 10
             * polygons.
             *
             * Create a request for the method "referenceImages.create".
             *
             * This request holds the parameters needed by the the vision server.  After setting any optional
             * parameters, call the {@link Create#execute()} method to invoke the remote operation. <p> {@link
             * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
             * be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param parent Required. Resource name of the product in which to create the reference image.
          Format is
           *        `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`.
             * @param content the {@link com.google.api.services.vision.v1.model.ReferenceImage}
             * @since 1.13
             */
            protected Create(java.lang.String parent, com.google.api.services.vision.v1.model.ReferenceImage content) {
              super(Vision.this, "POST", REST_PATH, content, com.google.api.services.vision.v1.model.ReferenceImage.class);
              this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                    "Parameter parent must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/products/[^/]+$");
              }
            }

            @Override
            public Create set$Xgafv(java.lang.String $Xgafv) {
              return (Create) super.set$Xgafv($Xgafv);
            }

            @Override
            public Create setAccessToken(java.lang.String accessToken) {
              return (Create) super.setAccessToken(accessToken);
            }

            @Override
            public Create setAlt(java.lang.String alt) {
              return (Create) super.setAlt(alt);
            }

            @Override
            public Create setCallback(java.lang.String callback) {
              return (Create) super.setCallback(callback);
            }

            @Override
            public Create setFields(java.lang.String fields) {
              return (Create) super.setFields(fields);
            }

            @Override
            public Create setKey(java.lang.String key) {
              return (Create) super.setKey(key);
            }

            @Override
            public Create setOauthToken(java.lang.String oauthToken) {
              return (Create) super.setOauthToken(oauthToken);
            }

            @Override
            public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (Create) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public Create setQuotaUser(java.lang.String quotaUser) {
              return (Create) super.setQuotaUser(quotaUser);
            }

            @Override
            public Create setUploadType(java.lang.String uploadType) {
              return (Create) super.setUploadType(uploadType);
            }

            @Override
            public Create setUploadProtocol(java.lang.String uploadProtocol) {
              return (Create) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * Required. Resource name of the product in which to create the reference image.
             *
             * Format is `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`.
             */
            @com.google.api.client.util.Key
            private java.lang.String parent;

            /** Required. Resource name of the product in which to create the reference image.

           Format is `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`.
             */
            public java.lang.String getParent() {
              return parent;
            }

            /**
             * Required. Resource name of the product in which to create the reference image.
             *
             * Format is `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`.
             */
            public Create setParent(java.lang.String parent) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                    "Parameter parent must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/products/[^/]+$");
              }
              this.parent = parent;
              return this;
            }

            /**
             * A user-supplied resource id for the ReferenceImage to be added. If set, the server
             * will attempt to use this value as the resource id. If it is already in use, an error
             * is returned with code ALREADY_EXISTS. Must be at most 128 characters long. It cannot
             * contain the character `/`.
             */
            @com.google.api.client.util.Key
            private java.lang.String referenceImageId;

            /** A user-supplied resource id for the ReferenceImage to be added. If set, the server will attempt to
           use this value as the resource id. If it is already in use, an error is returned with code
           ALREADY_EXISTS. Must be at most 128 characters long. It cannot contain the character `/`.
             */
            public java.lang.String getReferenceImageId() {
              return referenceImageId;
            }

            /**
             * A user-supplied resource id for the ReferenceImage to be added. If set, the server
             * will attempt to use this value as the resource id. If it is already in use, an error
             * is returned with code ALREADY_EXISTS. Must be at most 128 characters long. It cannot
             * contain the character `/`.
             */
            public Create setReferenceImageId(java.lang.String referenceImageId) {
              this.referenceImageId = referenceImageId;
              return this;
            }

            @Override
            public Create set(String parameterName, Object value) {
              return (Create) super.set(parameterName, value);
            }
          }
          /**
           * Permanently deletes a reference image.
           *
           * The image metadata will be deleted right away, but search queries against ProductSets containing
           * the image may still work until all related caches are refreshed.
           *
           * The actual image files are not deleted from Google Cloud Storage.
           *
           * Create a request for the method "referenceImages.delete".
           *
           * This request holds the parameters needed by the vision server.  After setting any optional
           * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
           *
           * @param name Required. The resource name of the reference image to delete.
          Format is:
           *        `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID/referenceImages/IMAGE_ID`
           * @return the request
           */
          public Delete delete(java.lang.String name) throws java.io.IOException {
            Delete result = new Delete(name);
            initialize(result);
            return result;
          }

          public class Delete extends VisionRequest<com.google.api.services.vision.v1.model.Empty> {

            private static final String REST_PATH = "v1/{+name}";

            private final java.util.regex.Pattern NAME_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/products/[^/]+/referenceImages/[^/]+$");

            /**
             * Permanently deletes a reference image.
             *
             * The image metadata will be deleted right away, but search queries against ProductSets
             * containing the image may still work until all related caches are refreshed.
             *
             * The actual image files are not deleted from Google Cloud Storage.
             *
             * Create a request for the method "referenceImages.delete".
             *
             * This request holds the parameters needed by the the vision server.  After setting any optional
             * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
             * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
             * be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param name Required. The resource name of the reference image to delete.
          Format is:
           *        `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID/referenceImages/IMAGE_ID`
             * @since 1.13
             */
            protected Delete(java.lang.String name) {
              super(Vision.this, "DELETE", REST_PATH, null, com.google.api.services.vision.v1.model.Empty.class);
              this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/products/[^/]+/referenceImages/[^/]+$");
              }
            }

            @Override
            public Delete set$Xgafv(java.lang.String $Xgafv) {
              return (Delete) super.set$Xgafv($Xgafv);
            }

            @Override
            public Delete setAccessToken(java.lang.String accessToken) {
              return (Delete) super.setAccessToken(accessToken);
            }

            @Override
            public Delete setAlt(java.lang.String alt) {
              return (Delete) super.setAlt(alt);
            }

            @Override
            public Delete setCallback(java.lang.String callback) {
              return (Delete) super.setCallback(callback);
            }

            @Override
            public Delete setFields(java.lang.String fields) {
              return (Delete) super.setFields(fields);
            }

            @Override
            public Delete setKey(java.lang.String key) {
              return (Delete) super.setKey(key);
            }

            @Override
            public Delete setOauthToken(java.lang.String oauthToken) {
              return (Delete) super.setOauthToken(oauthToken);
            }

            @Override
            public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (Delete) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public Delete setQuotaUser(java.lang.String quotaUser) {
              return (Delete) super.setQuotaUser(quotaUser);
            }

            @Override
            public Delete setUploadType(java.lang.String uploadType) {
              return (Delete) super.setUploadType(uploadType);
            }

            @Override
            public Delete setUploadProtocol(java.lang.String uploadProtocol) {
              return (Delete) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * Required. The resource name of the reference image to delete.
             *
             * Format is:
             *
             * `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID/referenceImages/IMAGE_ID`
             */
            @com.google.api.client.util.Key
            private java.lang.String name;

            /** Required. The resource name of the reference image to delete.

           Format is:

           `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID/referenceImages/IMAGE_ID`
             */
            public java.lang.String getName() {
              return name;
            }

            /**
             * Required. The resource name of the reference image to delete.
             *
             * Format is:
             *
             * `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID/referenceImages/IMAGE_ID`
             */
            public Delete setName(java.lang.String name) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/products/[^/]+/referenceImages/[^/]+$");
              }
              this.name = name;
              return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
              return (Delete) super.set(parameterName, value);
            }
          }
          /**
           * Gets information associated with a ReferenceImage.
           *
           * Possible errors:
           *
           * * Returns NOT_FOUND if the specified image does not exist.
           *
           * Create a request for the method "referenceImages.get".
           *
           * This request holds the parameters needed by the vision server.  After setting any optional
           * parameters, call the {@link Get#execute()} method to invoke the remote operation.
           *
           * @param name Required. The resource name of the ReferenceImage to get.
          Format is:
           *        `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID/referenceImages/IMAGE_ID`.
           * @return the request
           */
          public Get get(java.lang.String name) throws java.io.IOException {
            Get result = new Get(name);
            initialize(result);
            return result;
          }

          public class Get extends VisionRequest<com.google.api.services.vision.v1.model.ReferenceImage> {

            private static final String REST_PATH = "v1/{+name}";

            private final java.util.regex.Pattern NAME_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/products/[^/]+/referenceImages/[^/]+$");

            /**
             * Gets information associated with a ReferenceImage.
             *
             * Possible errors:
             *
             * * Returns NOT_FOUND if the specified image does not exist.
             *
             * Create a request for the method "referenceImages.get".
             *
             * This request holds the parameters needed by the the vision server.  After setting any optional
             * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
             * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
             * called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param name Required. The resource name of the ReferenceImage to get.
          Format is:
           *        `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID/referenceImages/IMAGE_ID`.
             * @since 1.13
             */
            protected Get(java.lang.String name) {
              super(Vision.this, "GET", REST_PATH, null, com.google.api.services.vision.v1.model.ReferenceImage.class);
              this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/products/[^/]+/referenceImages/[^/]+$");
              }
            }

            @Override
            public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
              return super.executeUsingHead();
            }

            @Override
            public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
              return super.buildHttpRequestUsingHead();
            }

            @Override
            public Get set$Xgafv(java.lang.String $Xgafv) {
              return (Get) super.set$Xgafv($Xgafv);
            }

            @Override
            public Get setAccessToken(java.lang.String accessToken) {
              return (Get) super.setAccessToken(accessToken);
            }

            @Override
            public Get setAlt(java.lang.String alt) {
              return (Get) super.setAlt(alt);
            }

            @Override
            public Get setCallback(java.lang.String callback) {
              return (Get) super.setCallback(callback);
            }

            @Override
            public Get setFields(java.lang.String fields) {
              return (Get) super.setFields(fields);
            }

            @Override
            public Get setKey(java.lang.String key) {
              return (Get) super.setKey(key);
            }

            @Override
            public Get setOauthToken(java.lang.String oauthToken) {
              return (Get) super.setOauthToken(oauthToken);
            }

            @Override
            public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (Get) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public Get setQuotaUser(java.lang.String quotaUser) {
              return (Get) super.setQuotaUser(quotaUser);
            }

            @Override
            public Get setUploadType(java.lang.String uploadType) {
              return (Get) super.setUploadType(uploadType);
            }

            @Override
            public Get setUploadProtocol(java.lang.String uploadProtocol) {
              return (Get) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * Required. The resource name of the ReferenceImage to get.
             *
             * Format is:
             *
             * `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID/referenceImages/IMAGE_ID`.
             */
            @com.google.api.client.util.Key
            private java.lang.String name;

            /** Required. The resource name of the ReferenceImage to get.

           Format is:

           `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID/referenceImages/IMAGE_ID`.
             */
            public java.lang.String getName() {
              return name;
            }

            /**
             * Required. The resource name of the ReferenceImage to get.
             *
             * Format is:
             *
             * `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID/referenceImages/IMAGE_ID`.
             */
            public Get setName(java.lang.String name) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/products/[^/]+/referenceImages/[^/]+$");
              }
              this.name = name;
              return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
              return (Get) super.set(parameterName, value);
            }
          }
          /**
           * Lists reference images.
           *
           * Possible errors:
           *
           * * Returns NOT_FOUND if the parent product does not exist. * Returns INVALID_ARGUMENT if the
           * page_size is greater than 100, or less   than 1.
           *
           * Create a request for the method "referenceImages.list".
           *
           * This request holds the parameters needed by the vision server.  After setting any optional
           * parameters, call the {@link List#execute()} method to invoke the remote operation.
           *
           * @param parent Required. Resource name of the product containing the reference images.
          Format is
           *        `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`.
           * @return the request
           */
          public List list(java.lang.String parent) throws java.io.IOException {
            List result = new List(parent);
            initialize(result);
            return result;
          }

          public class List extends VisionRequest<com.google.api.services.vision.v1.model.ListReferenceImagesResponse> {

            private static final String REST_PATH = "v1/{+parent}/referenceImages";

            private final java.util.regex.Pattern PARENT_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/products/[^/]+$");

            /**
             * Lists reference images.
             *
             * Possible errors:
             *
             * * Returns NOT_FOUND if the parent product does not exist. * Returns INVALID_ARGUMENT if the
             * page_size is greater than 100, or less   than 1.
             *
             * Create a request for the method "referenceImages.list".
             *
             * This request holds the parameters needed by the the vision server.  After setting any optional
             * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
             * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
             * called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param parent Required. Resource name of the product containing the reference images.
          Format is
           *        `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`.
             * @since 1.13
             */
            protected List(java.lang.String parent) {
              super(Vision.this, "GET", REST_PATH, null, com.google.api.services.vision.v1.model.ListReferenceImagesResponse.class);
              this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                    "Parameter parent must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/products/[^/]+$");
              }
            }

            @Override
            public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
              return super.executeUsingHead();
            }

            @Override
            public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
              return super.buildHttpRequestUsingHead();
            }

            @Override
            public List set$Xgafv(java.lang.String $Xgafv) {
              return (List) super.set$Xgafv($Xgafv);
            }

            @Override
            public List setAccessToken(java.lang.String accessToken) {
              return (List) super.setAccessToken(accessToken);
            }

            @Override
            public List setAlt(java.lang.String alt) {
              return (List) super.setAlt(alt);
            }

            @Override
            public List setCallback(java.lang.String callback) {
              return (List) super.setCallback(callback);
            }

            @Override
            public List setFields(java.lang.String fields) {
              return (List) super.setFields(fields);
            }

            @Override
            public List setKey(java.lang.String key) {
              return (List) super.setKey(key);
            }

            @Override
            public List setOauthToken(java.lang.String oauthToken) {
              return (List) super.setOauthToken(oauthToken);
            }

            @Override
            public List setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (List) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public List setQuotaUser(java.lang.String quotaUser) {
              return (List) super.setQuotaUser(quotaUser);
            }

            @Override
            public List setUploadType(java.lang.String uploadType) {
              return (List) super.setUploadType(uploadType);
            }

            @Override
            public List setUploadProtocol(java.lang.String uploadProtocol) {
              return (List) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * Required. Resource name of the product containing the reference images.
             *
             * Format is `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`.
             */
            @com.google.api.client.util.Key
            private java.lang.String parent;

            /** Required. Resource name of the product containing the reference images.

           Format is `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`.
             */
            public java.lang.String getParent() {
              return parent;
            }

            /**
             * Required. Resource name of the product containing the reference images.
             *
             * Format is `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`.
             */
            public List setParent(java.lang.String parent) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                    "Parameter parent must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/products/[^/]+$");
              }
              this.parent = parent;
              return this;
            }

            /**
             * A token identifying a page of results to be returned. This is the value of
             * `nextPageToken` returned in a previous reference image list request.
             *
             * Defaults to the first page if not specified.
             */
            @com.google.api.client.util.Key
            private java.lang.String pageToken;

            /** A token identifying a page of results to be returned. This is the value of `nextPageToken` returned
           in a previous reference image list request.

           Defaults to the first page if not specified.
             */
            public java.lang.String getPageToken() {
              return pageToken;
            }

            /**
             * A token identifying a page of results to be returned. This is the value of
             * `nextPageToken` returned in a previous reference image list request.
             *
             * Defaults to the first page if not specified.
             */
            public List setPageToken(java.lang.String pageToken) {
              this.pageToken = pageToken;
              return this;
            }

            /** The maximum number of items to return. Default 10, maximum 100. */
            @com.google.api.client.util.Key
            private java.lang.Integer pageSize;

            /** The maximum number of items to return. Default 10, maximum 100.
             */
            public java.lang.Integer getPageSize() {
              return pageSize;
            }

            /** The maximum number of items to return. Default 10, maximum 100. */
            public List setPageSize(java.lang.Integer pageSize) {
              this.pageSize = pageSize;
              return this;
            }

            @Override
            public List set(String parameterName, Object value) {
              return (List) super.set(parameterName, value);
            }
          }

        }
      }
    }
    /**
     * An accessor for creating requests from the Operations collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Vision vision = new Vision(...);}
     *   {@code Vision.Operations.List request = vision.operations().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Operations operations() {
      return new Operations();
    }

    /**
     * The "operations" collection of methods.
     */
    public class Operations {

      /**
       * Gets the latest state of a long-running operation.  Clients can use this method to poll the
       * operation result at intervals as recommended by the API service.
       *
       * Create a request for the method "operations.get".
       *
       * This request holds the parameters needed by the vision server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param name The name of the operation resource.
       * @return the request
       */
      public Get get(java.lang.String name) throws java.io.IOException {
        Get result = new Get(name);
        initialize(result);
        return result;
      }

      public class Get extends VisionRequest<com.google.api.services.vision.v1.model.Operation> {

        private static final String REST_PATH = "v1/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/operations/[^/]+$");

        /**
         * Gets the latest state of a long-running operation.  Clients can use this method to poll the
         * operation result at intervals as recommended by the API service.
         *
         * Create a request for the method "operations.get".
         *
         * This request holds the parameters needed by the the vision server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
         * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name The name of the operation resource.
         * @since 1.13
         */
        protected Get(java.lang.String name) {
          super(Vision.this, "GET", REST_PATH, null, com.google.api.services.vision.v1.model.Operation.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/operations/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get set$Xgafv(java.lang.String $Xgafv) {
          return (Get) super.set$Xgafv($Xgafv);
        }

        @Override
        public Get setAccessToken(java.lang.String accessToken) {
          return (Get) super.setAccessToken(accessToken);
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setCallback(java.lang.String callback) {
          return (Get) super.setCallback(callback);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUploadType(java.lang.String uploadType) {
          return (Get) super.setUploadType(uploadType);
        }

        @Override
        public Get setUploadProtocol(java.lang.String uploadProtocol) {
          return (Get) super.setUploadProtocol(uploadProtocol);
        }

        /** The name of the operation resource. */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The name of the operation resource.
         */
        public java.lang.String getName() {
          return name;
        }

        /** The name of the operation resource. */
        public Get setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/operations/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }

    }
  }

  /**
   * Builder for {@link Vision}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient.Builder {

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport, which should normally be:
     *        <ul>
     *        <li>Google App Engine:
     *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
     *        <li>Android: {@code newCompatibleTransport} from
     *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
     *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
     *        </li>
     *        </ul>
     * @param jsonFactory JSON factory, which may be:
     *        <ul>
     *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
     *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
     *        <li>Android Honeycomb or higher:
     *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
     *        </ul>
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          DEFAULT_ROOT_URL,
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
      setBatchPath(DEFAULT_BATCH_PATH);
    }

    /** Builds a new instance of {@link Vision}. */
    @Override
    public Vision build() {
      return new Vision(this);
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setBatchPath(String batchPath) {
      return (Builder) super.setBatchPath(batchPath);
    }

    @Override
    public Builder setHttpRequestInitializer(com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    @Override
    public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
      return (Builder) super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
    }

    @Override
    public Builder setSuppressAllChecks(boolean suppressAllChecks) {
      return (Builder) super.setSuppressAllChecks(suppressAllChecks);
    }

    /**
     * Set the {@link VisionRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setVisionRequestInitializer(
        VisionRequestInitializer visionRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(visionRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        com.google.api.client.googleapis.services.GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
