/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-03-10 at 06:00:57 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.vision.v1.model;

/**
 * A request to annotate one single file, e.g. a PDF, TIFF or GIF file.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Vision API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AnnotateFileRequest extends com.google.api.client.json.GenericJson {

  /**
   * Required. Requested features.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Feature> features;

  /**
   * Additional context that may accompany the image(s) in the file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ImageContext imageContext;

  /**
   * Required. Information about the input file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private InputConfig inputConfig;

  /**
   * Pages of the file to perform image annotation.
   *
   * Pages starts from 1, we assume the first page of the file is page 1. At most 5 pages are
   * supported per request. Pages can be negative.
   *
   * Page 1 means the first page. Page 2 means the second page. Page -1 means the last page. Page -2
   * means the second to the last page.
   *
   * If the file is GIF instead of PDF or TIFF, page refers to GIF frames.
   *
   * If this field is empty, by default the service performs image annotation for the first 5 pages
   * of the file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.Integer> pages;

  /**
   * Required. Requested features.
   * @return value or {@code null} for none
   */
  public java.util.List<Feature> getFeatures() {
    return features;
  }

  /**
   * Required. Requested features.
   * @param features features or {@code null} for none
   */
  public AnnotateFileRequest setFeatures(java.util.List<Feature> features) {
    this.features = features;
    return this;
  }

  /**
   * Additional context that may accompany the image(s) in the file.
   * @return value or {@code null} for none
   */
  public ImageContext getImageContext() {
    return imageContext;
  }

  /**
   * Additional context that may accompany the image(s) in the file.
   * @param imageContext imageContext or {@code null} for none
   */
  public AnnotateFileRequest setImageContext(ImageContext imageContext) {
    this.imageContext = imageContext;
    return this;
  }

  /**
   * Required. Information about the input file.
   * @return value or {@code null} for none
   */
  public InputConfig getInputConfig() {
    return inputConfig;
  }

  /**
   * Required. Information about the input file.
   * @param inputConfig inputConfig or {@code null} for none
   */
  public AnnotateFileRequest setInputConfig(InputConfig inputConfig) {
    this.inputConfig = inputConfig;
    return this;
  }

  /**
   * Pages of the file to perform image annotation.
   *
   * Pages starts from 1, we assume the first page of the file is page 1. At most 5 pages are
   * supported per request. Pages can be negative.
   *
   * Page 1 means the first page. Page 2 means the second page. Page -1 means the last page. Page -2
   * means the second to the last page.
   *
   * If the file is GIF instead of PDF or TIFF, page refers to GIF frames.
   *
   * If this field is empty, by default the service performs image annotation for the first 5 pages
   * of the file.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.Integer> getPages() {
    return pages;
  }

  /**
   * Pages of the file to perform image annotation.
   *
   * Pages starts from 1, we assume the first page of the file is page 1. At most 5 pages are
   * supported per request. Pages can be negative.
   *
   * Page 1 means the first page. Page 2 means the second page. Page -1 means the last page. Page -2
   * means the second to the last page.
   *
   * If the file is GIF instead of PDF or TIFF, page refers to GIF frames.
   *
   * If this field is empty, by default the service performs image annotation for the first 5 pages
   * of the file.
   * @param pages pages or {@code null} for none
   */
  public AnnotateFileRequest setPages(java.util.List<java.lang.Integer> pages) {
    this.pages = pages;
    return this;
  }

  @Override
  public AnnotateFileRequest set(String fieldName, Object value) {
    return (AnnotateFileRequest) super.set(fieldName, value);
  }

  @Override
  public AnnotateFileRequest clone() {
    return (AnnotateFileRequest) super.clone();
  }

}
