/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-03-10 at 06:00:57 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.vision.v1.model;

/**
 * An offline file annotation request.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Vision API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AsyncAnnotateFileRequest extends com.google.api.client.json.GenericJson {

  /**
   * Required. Requested features.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Feature> features;

  static {
    // hack to force ProGuard to consider Feature used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Feature.class);
  }

  /**
   * Additional context that may accompany the image(s) in the file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ImageContext imageContext;

  /**
   * Required. Information about the input file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private InputConfig inputConfig;

  /**
   * Required. The desired output location and metadata (e.g. format).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private OutputConfig outputConfig;

  /**
   * Required. Requested features.
   * @return value or {@code null} for none
   */
  public java.util.List<Feature> getFeatures() {
    return features;
  }

  /**
   * Required. Requested features.
   * @param features features or {@code null} for none
   */
  public AsyncAnnotateFileRequest setFeatures(java.util.List<Feature> features) {
    this.features = features;
    return this;
  }

  /**
   * Additional context that may accompany the image(s) in the file.
   * @return value or {@code null} for none
   */
  public ImageContext getImageContext() {
    return imageContext;
  }

  /**
   * Additional context that may accompany the image(s) in the file.
   * @param imageContext imageContext or {@code null} for none
   */
  public AsyncAnnotateFileRequest setImageContext(ImageContext imageContext) {
    this.imageContext = imageContext;
    return this;
  }

  /**
   * Required. Information about the input file.
   * @return value or {@code null} for none
   */
  public InputConfig getInputConfig() {
    return inputConfig;
  }

  /**
   * Required. Information about the input file.
   * @param inputConfig inputConfig or {@code null} for none
   */
  public AsyncAnnotateFileRequest setInputConfig(InputConfig inputConfig) {
    this.inputConfig = inputConfig;
    return this;
  }

  /**
   * Required. The desired output location and metadata (e.g. format).
   * @return value or {@code null} for none
   */
  public OutputConfig getOutputConfig() {
    return outputConfig;
  }

  /**
   * Required. The desired output location and metadata (e.g. format).
   * @param outputConfig outputConfig or {@code null} for none
   */
  public AsyncAnnotateFileRequest setOutputConfig(OutputConfig outputConfig) {
    this.outputConfig = outputConfig;
    return this;
  }

  @Override
  public AsyncAnnotateFileRequest set(String fieldName, Object value) {
    return (AsyncAnnotateFileRequest) super.set(fieldName, value);
  }

  @Override
  public AsyncAnnotateFileRequest clone() {
    return (AsyncAnnotateFileRequest) super.clone();
  }

}
