/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-03-10 at 06:00:57 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.vision.v1.model;

/**
 * The type of Google Cloud Vision API detection to perform, and the maximum number of results to
 * return for that type. Multiple `Feature` objects can be specified in the `features` list.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Vision API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Feature extends com.google.api.client.json.GenericJson {

  /**
   * Maximum number of results of this type. Does not apply to `TEXT_DETECTION`,
   * `DOCUMENT_TEXT_DETECTION`, or `CROP_HINTS`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer maxResults;

  /**
   * Model to use for the feature. Supported values: "builtin/stable" (the default if unset) and
   * "builtin/latest".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String model;

  /**
   * The feature type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * Maximum number of results of this type. Does not apply to `TEXT_DETECTION`,
   * `DOCUMENT_TEXT_DETECTION`, or `CROP_HINTS`.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMaxResults() {
    return maxResults;
  }

  /**
   * Maximum number of results of this type. Does not apply to `TEXT_DETECTION`,
   * `DOCUMENT_TEXT_DETECTION`, or `CROP_HINTS`.
   * @param maxResults maxResults or {@code null} for none
   */
  public Feature setMaxResults(java.lang.Integer maxResults) {
    this.maxResults = maxResults;
    return this;
  }

  /**
   * Model to use for the feature. Supported values: "builtin/stable" (the default if unset) and
   * "builtin/latest".
   * @return value or {@code null} for none
   */
  public java.lang.String getModel() {
    return model;
  }

  /**
   * Model to use for the feature. Supported values: "builtin/stable" (the default if unset) and
   * "builtin/latest".
   * @param model model or {@code null} for none
   */
  public Feature setModel(java.lang.String model) {
    this.model = model;
    return this;
  }

  /**
   * The feature type.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * The feature type.
   * @param type type or {@code null} for none
   */
  public Feature setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public Feature set(String fieldName, Object value) {
    return (Feature) super.set(fieldName, value);
  }

  @Override
  public Feature clone() {
    return (Feature) super.clone();
  }

}
