/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-03-10 at 06:00:57 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.vision.v1.model;

/**
 * Request message for the `PurgeProducts` method.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Vision API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PurgeProductsRequest extends com.google.api.client.json.GenericJson {

  /**
   * If delete_orphan_products is true, all Products that are not in any ProductSet will be deleted.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean deleteOrphanProducts;

  /**
   * The default value is false. Override this value to true to actually perform the purge.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean force;

  /**
   * Specify which ProductSet contains the Products to be deleted.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ProductSetPurgeConfig productSetPurgeConfig;

  /**
   * If delete_orphan_products is true, all Products that are not in any ProductSet will be deleted.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getDeleteOrphanProducts() {
    return deleteOrphanProducts;
  }

  /**
   * If delete_orphan_products is true, all Products that are not in any ProductSet will be deleted.
   * @param deleteOrphanProducts deleteOrphanProducts or {@code null} for none
   */
  public PurgeProductsRequest setDeleteOrphanProducts(java.lang.Boolean deleteOrphanProducts) {
    this.deleteOrphanProducts = deleteOrphanProducts;
    return this;
  }

  /**
   * The default value is false. Override this value to true to actually perform the purge.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getForce() {
    return force;
  }

  /**
   * The default value is false. Override this value to true to actually perform the purge.
   * @param force force or {@code null} for none
   */
  public PurgeProductsRequest setForce(java.lang.Boolean force) {
    this.force = force;
    return this;
  }

  /**
   * Specify which ProductSet contains the Products to be deleted.
   * @return value or {@code null} for none
   */
  public ProductSetPurgeConfig getProductSetPurgeConfig() {
    return productSetPurgeConfig;
  }

  /**
   * Specify which ProductSet contains the Products to be deleted.
   * @param productSetPurgeConfig productSetPurgeConfig or {@code null} for none
   */
  public PurgeProductsRequest setProductSetPurgeConfig(ProductSetPurgeConfig productSetPurgeConfig) {
    this.productSetPurgeConfig = productSetPurgeConfig;
    return this;
  }

  @Override
  public PurgeProductsRequest set(String fieldName, Object value) {
    return (PurgeProductsRequest) super.set(fieldName, value);
  }

  @Override
  public PurgeProductsRequest clone() {
    return (PurgeProductsRequest) super.clone();
  }

}
