/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.webmasters.model;

/**
 * Contains permission level information about a Search Console site. For more information, see
 * Permissions in Search Console.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Search Console API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class WmxSite extends com.google.api.client.json.GenericJson {

  /**
   * The user's permission level for the site.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String permissionLevel;

  /**
   * The URL of the site.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String siteUrl;

  /**
   * The user's permission level for the site.
   * @return value or {@code null} for none
   */
  public java.lang.String getPermissionLevel() {
    return permissionLevel;
  }

  /**
   * The user's permission level for the site.
   * @param permissionLevel permissionLevel or {@code null} for none
   */
  public WmxSite setPermissionLevel(java.lang.String permissionLevel) {
    this.permissionLevel = permissionLevel;
    return this;
  }

  /**
   * The URL of the site.
   * @return value or {@code null} for none
   */
  public java.lang.String getSiteUrl() {
    return siteUrl;
  }

  /**
   * The URL of the site.
   * @param siteUrl siteUrl or {@code null} for none
   */
  public WmxSite setSiteUrl(java.lang.String siteUrl) {
    this.siteUrl = siteUrl;
    return this;
  }

  @Override
  public WmxSite set(String fieldName, Object value) {
    return (WmxSite) super.set(fieldName, value);
  }

  @Override
  public WmxSite clone() {
    return (WmxSite) super.clone();
  }

}
