/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2014-07-22 21:53:01 UTC)
 * on 2014-10-09 at 03:30:26 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.youtube;

/**
 * Service definition for YouTube (v3).
 *
 * <p>
 * Programmatic access to YouTube features.
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://developers.google.com/youtube/v3" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link YouTubeRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class YouTube extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 15,
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.15 of google-api-client to run version " +
        "1.19.0 of the YouTube Data API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "youtube/v3/";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public YouTube(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  YouTube(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the Activities collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.Activities.List request = youtube.activities().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Activities activities() {
    return new Activities();
  }

  /**
   * The "activities" collection of methods.
   */
  public class Activities {

    /**
     * Posts a bulletin for a specific channel. (The user submitting the request must be authorized to
     * act on the channel's behalf.)
     *
     * Note: Even though an activity resource can contain information about actions like a user rating a
     * video or marking a video as a favorite, you need to use other API methods to generate those
     * activity resources. For example, you would use the API's videos.rate() method to rate a video and
     * the playlistItems.insert() method to mark a video as a favorite.
     *
     * Create a request for the method "activities.insert".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
    The
     *        part names that you can include in the parameter value are snippet and contentDetails.
     * @param content the {@link com.google.api.services.youtube.model.Activity}
     * @return the request
     */
    public Insert insert(java.lang.String part, com.google.api.services.youtube.model.Activity content) throws java.io.IOException {
      Insert result = new Insert(part, content);
      initialize(result);
      return result;
    }

    public class Insert extends YouTubeRequest<com.google.api.services.youtube.model.Activity> {

      private static final String REST_PATH = "activities";

      /**
       * Posts a bulletin for a specific channel. (The user submitting the request must be authorized to
       * act on the channel's behalf.)
       *
       * Note: Even though an activity resource can contain information about actions like a user rating
       * a video or marking a video as a favorite, you need to use other API methods to generate those
       * activity resources. For example, you would use the API's videos.rate() method to rate a video
       * and the playlistItems.insert() method to mark a video as a favorite.
       *
       * Create a request for the method "activities.insert".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
    The
     *        part names that you can include in the parameter value are snippet and contentDetails.
       * @param content the {@link com.google.api.services.youtube.model.Activity}
       * @since 1.13
       */
      protected Insert(java.lang.String part, com.google.api.services.youtube.model.Activity content) {
        super(YouTube.this, "POST", REST_PATH, content, com.google.api.services.youtube.model.Activity.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /**
       * The part parameter serves two purposes in this operation. It identifies the properties that
       * the write operation will set as well as the properties that the API response will include.
       *
       * The part names that you can include in the parameter value are snippet and contentDetails.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter serves two purposes in this operation. It identifies the properties that the
     write operation will set as well as the properties that the API response will include.

     The part names that you can include in the parameter value are snippet and contentDetails.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter serves two purposes in this operation. It identifies the properties that
       * the write operation will set as well as the properties that the API response will include.
       *
       * The part names that you can include in the parameter value are snippet and contentDetails.
       */
      public Insert setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Returns a list of channel activity events that match the request criteria. For example, you can
     * retrieve events associated with a particular channel, events associated with the user's
     * subscriptions and Google+ friends, or the YouTube home page feed, which is customized for each
     * user.
     *
     * Create a request for the method "activities.list".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter specifies a comma-separated list of one or more activity resource properties that
     *        the API response will include. The part names that you can include in the parameter value
     *        are id, snippet, and contentDetails.
    If the parameter identifies a property that contains
     *        child properties, the child properties will be included in the response. For example, in a
     *        activity resource, the snippet property contains other properties that identify the type
     *        of activity, a display title for the activity, and so forth. If you set part=snippet, the
     *        API response will also contain all of those nested properties.
     * @return the request
     */
    public List list(java.lang.String part) throws java.io.IOException {
      List result = new List(part);
      initialize(result);
      return result;
    }

    public class List extends YouTubeRequest<com.google.api.services.youtube.model.ActivityListResponse> {

      private static final String REST_PATH = "activities";

      /**
       * Returns a list of channel activity events that match the request criteria. For example, you can
       * retrieve events associated with a particular channel, events associated with the user's
       * subscriptions and Google+ friends, or the YouTube home page feed, which is customized for each
       * user.
       *
       * Create a request for the method "activities.list".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter specifies a comma-separated list of one or more activity resource properties that
     *        the API response will include. The part names that you can include in the parameter value
     *        are id, snippet, and contentDetails.
    If the parameter identifies a property that contains
     *        child properties, the child properties will be included in the response. For example, in a
     *        activity resource, the snippet property contains other properties that identify the type
     *        of activity, a display title for the activity, and so forth. If you set part=snippet, the
     *        API response will also contain all of those nested properties.
       * @since 1.13
       */
      protected List(java.lang.String part) {
        super(YouTube.this, "GET", REST_PATH, null, com.google.api.services.youtube.model.ActivityListResponse.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /**
       * The part parameter specifies a comma-separated list of one or more activity resource
       * properties that the API response will include. The part names that you can include in the
       * parameter value are id, snippet, and contentDetails.
       *
       * If the parameter identifies a property that contains child properties, the child properties
       * will be included in the response. For example, in a activity resource, the snippet property
       * contains other properties that identify the type of activity, a display title for the
       * activity, and so forth. If you set part=snippet, the API response will also contain all of
       * those nested properties.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter specifies a comma-separated list of one or more activity resource properties
     that the API response will include. The part names that you can include in the parameter value are
     id, snippet, and contentDetails.

     If the parameter identifies a property that contains child properties, the child properties will be
     included in the response. For example, in a activity resource, the snippet property contains other
     properties that identify the type of activity, a display title for the activity, and so forth. If
     you set part=snippet, the API response will also contain all of those nested properties.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter specifies a comma-separated list of one or more activity resource
       * properties that the API response will include. The part names that you can include in the
       * parameter value are id, snippet, and contentDetails.
       *
       * If the parameter identifies a property that contains child properties, the child properties
       * will be included in the response. For example, in a activity resource, the snippet property
       * contains other properties that identify the type of activity, a display title for the
       * activity, and so forth. If you set part=snippet, the API response will also contain all of
       * those nested properties.
       */
      public List setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      /**
       * The regionCode parameter instructs the API to return results for the specified country. The
       * parameter value is an ISO 3166-1 alpha-2 country code. YouTube uses this value when the
       * authorized user's previous activity on YouTube does not provide enough information to
       * generate the activity feed.
       */
      @com.google.api.client.util.Key
      private java.lang.String regionCode;

      /** The regionCode parameter instructs the API to return results for the specified country. The
     parameter value is an ISO 3166-1 alpha-2 country code. YouTube uses this value when the authorized
     user's previous activity on YouTube does not provide enough information to generate the activity
     feed.
       */
      public java.lang.String getRegionCode() {
        return regionCode;
      }

      /**
       * The regionCode parameter instructs the API to return results for the specified country. The
       * parameter value is an ISO 3166-1 alpha-2 country code. YouTube uses this value when the
       * authorized user's previous activity on YouTube does not provide enough information to
       * generate the activity feed.
       */
      public List setRegionCode(java.lang.String regionCode) {
        this.regionCode = regionCode;
        return this;
      }

      /**
       * The publishedBefore parameter specifies the date and time before which an activity must
       * have occurred for that activity to be included in the API response. If the parameter value
       * specifies a day, but not a time, then any activities that occurred that day will be
       * excluded from the result set. The value is specified in ISO 8601 (YYYY-MM-DDThh:mm:ss.sZ)
       * format.
       */
      @com.google.api.client.util.Key
      private com.google.api.client.util.DateTime publishedBefore;

      /** The publishedBefore parameter specifies the date and time before which an activity must have
     occurred for that activity to be included in the API response. If the parameter value specifies a
     day, but not a time, then any activities that occurred that day will be excluded from the result
     set. The value is specified in ISO 8601 (YYYY-MM-DDThh:mm:ss.sZ) format.
       */
      public com.google.api.client.util.DateTime getPublishedBefore() {
        return publishedBefore;
      }

      /**
       * The publishedBefore parameter specifies the date and time before which an activity must
       * have occurred for that activity to be included in the API response. If the parameter value
       * specifies a day, but not a time, then any activities that occurred that day will be
       * excluded from the result set. The value is specified in ISO 8601 (YYYY-MM-DDThh:mm:ss.sZ)
       * format.
       */
      public List setPublishedBefore(com.google.api.client.util.DateTime publishedBefore) {
        this.publishedBefore = publishedBefore;
        return this;
      }

      /**
       * The channelId parameter specifies a unique YouTube channel ID. The API will then return a
       * list of that channel's activities.
       */
      @com.google.api.client.util.Key
      private java.lang.String channelId;

      /** The channelId parameter specifies a unique YouTube channel ID. The API will then return a list of
     that channel's activities.
       */
      public java.lang.String getChannelId() {
        return channelId;
      }

      /**
       * The channelId parameter specifies a unique YouTube channel ID. The API will then return a
       * list of that channel's activities.
       */
      public List setChannelId(java.lang.String channelId) {
        this.channelId = channelId;
        return this;
      }

      /**
       * Set this parameter's value to true to retrieve a feed of the authenticated user's
       * activities.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean mine;

      /** Set this parameter's value to true to retrieve a feed of the authenticated user's activities.
       */
      public java.lang.Boolean getMine() {
        return mine;
      }

      /**
       * Set this parameter's value to true to retrieve a feed of the authenticated user's
       * activities.
       */
      public List setMine(java.lang.Boolean mine) {
        this.mine = mine;
        return this;
      }

      /**
       * The maxResults parameter specifies the maximum number of items that should be returned in
       * the result set.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maxResults parameter specifies the maximum number of items that should be returned in the
     result set. [default: 5] [minimum: 0] [maximum: 50]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maxResults parameter specifies the maximum number of items that should be returned in
       * the result set.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * The pageToken parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The pageToken parameter identifies a specific page in the result set that should be returned. In an
     API response, the nextPageToken and prevPageToken properties identify other pages that could be
     retrieved.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * The pageToken parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Set this parameter's value to true to retrieve the activity feed that displays on the
       * YouTube home page for the currently authenticated user.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean home;

      /** Set this parameter's value to true to retrieve the activity feed that displays on the YouTube home
     page for the currently authenticated user.
       */
      public java.lang.Boolean getHome() {
        return home;
      }

      /**
       * Set this parameter's value to true to retrieve the activity feed that displays on the
       * YouTube home page for the currently authenticated user.
       */
      public List setHome(java.lang.Boolean home) {
        this.home = home;
        return this;
      }

      /**
       * The publishedAfter parameter specifies the earliest date and time that an activity could
       * have occurred for that activity to be included in the API response. If the parameter value
       * specifies a day, but not a time, then any activities that occurred that day will be
       * included in the result set. The value is specified in ISO 8601 (YYYY-MM-DDThh:mm:ss.sZ)
       * format.
       */
      @com.google.api.client.util.Key
      private com.google.api.client.util.DateTime publishedAfter;

      /** The publishedAfter parameter specifies the earliest date and time that an activity could have
     occurred for that activity to be included in the API response. If the parameter value specifies a
     day, but not a time, then any activities that occurred that day will be included in the result set.
     The value is specified in ISO 8601 (YYYY-MM-DDThh:mm:ss.sZ) format.
       */
      public com.google.api.client.util.DateTime getPublishedAfter() {
        return publishedAfter;
      }

      /**
       * The publishedAfter parameter specifies the earliest date and time that an activity could
       * have occurred for that activity to be included in the API response. If the parameter value
       * specifies a day, but not a time, then any activities that occurred that day will be
       * included in the result set. The value is specified in ISO 8601 (YYYY-MM-DDThh:mm:ss.sZ)
       * format.
       */
      public List setPublishedAfter(com.google.api.client.util.DateTime publishedAfter) {
        this.publishedAfter = publishedAfter;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the ChannelBanners collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.ChannelBanners.List request = youtube.channelBanners().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public ChannelBanners channelBanners() {
    return new ChannelBanners();
  }

  /**
   * The "channelBanners" collection of methods.
   */
  public class ChannelBanners {

    /**
     * Uploads a channel banner image to YouTube. This method represents the first two steps in a three-
     * step process to update the banner image for a channel:
     *
     * - Call the channelBanners.insert method to upload the binary image data to YouTube. The image
     * must have a 16:9 aspect ratio and be at least 2120x1192 pixels. - Extract the url property's
     * value from the response that the API returns for step 1. - Call the channels.update method to
     * update the channel's branding settings. Set the brandingSettings.image.bannerExternalUrl
     * property's value to the URL obtained in step 2.
     *
     * Create a request for the method "channelBanners.insert".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.youtube.model.ChannelBannerResource}
     * @return the request
     */
    public Insert insert(com.google.api.services.youtube.model.ChannelBannerResource content) throws java.io.IOException {
      Insert result = new Insert(content);
      initialize(result);
      return result;
    }

    /**
     * Uploads a channel banner image to YouTube. This method represents the first two steps in a three-
     * step process to update the banner image for a channel:
     *
     * - Call the channelBanners.insert method to upload the binary image data to YouTube. The image
     * must have a 16:9 aspect ratio and be at least 2120x1192 pixels. - Extract the url property's
     * value from the response that the API returns for step 1. - Call the channels.update method to
     * update the channel's branding settings. Set the brandingSettings.image.bannerExternalUrl
     * property's value to the URL obtained in step 2.
     *
     * Create a request for the method "channelBanners.insert".
     *
     * This request holds the parameters needed by the the youtube server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * <p>
     * This method should be used for uploading media content.
     * </p>
     *
     *
     * @param content the {@link com.google.api.services.youtube.model.ChannelBannerResource} media metadata or {@code null} if none
     * @param mediaContent The media HTTP content or {@code null} if none.
     * @return the request
     * @throws java.io.IOException if the initialization of the request fails
     */
    public Insert insert(com.google.api.services.youtube.model.ChannelBannerResource content,
        com.google.api.client.http.AbstractInputStreamContent mediaContent) throws java.io.IOException {
      Insert result = new Insert(content, mediaContent);
      initialize(result);
      return result;
    }

    public class Insert extends YouTubeRequest<com.google.api.services.youtube.model.ChannelBannerResource> {

      private static final String REST_PATH = "channelBanners/insert";

      /**
       * Uploads a channel banner image to YouTube. This method represents the first two steps in a
       * three-step process to update the banner image for a channel:
       *
       * - Call the channelBanners.insert method to upload the binary image data to YouTube. The image
       * must have a 16:9 aspect ratio and be at least 2120x1192 pixels. - Extract the url property's
       * value from the response that the API returns for step 1. - Call the channels.update method to
       * update the channel's branding settings. Set the brandingSettings.image.bannerExternalUrl
       * property's value to the URL obtained in step 2.
       *
       * Create a request for the method "channelBanners.insert".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.youtube.model.ChannelBannerResource}
       * @since 1.13
       */
      protected Insert(com.google.api.services.youtube.model.ChannelBannerResource content) {
        super(YouTube.this, "POST", REST_PATH, content, com.google.api.services.youtube.model.ChannelBannerResource.class);
      }

      /**
       * Uploads a channel banner image to YouTube. This method represents the first two steps in a
       * three-step process to update the banner image for a channel:
       *
       * - Call the channelBanners.insert method to upload the binary image data to YouTube. The image
       * must have a 16:9 aspect ratio and be at least 2120x1192 pixels. - Extract the url property's
       * value from the response that the API returns for step 1. - Call the channels.update method to
       * update the channel's branding settings. Set the brandingSettings.image.bannerExternalUrl
       * property's value to the URL obtained in step 2.
       *
       * Create a request for the method "channelBanners.insert".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * <p>
       * This constructor should be used for uploading media content.
       * </p>
       *
       *
       * @param content the {@link com.google.api.services.youtube.model.ChannelBannerResource} media metadata or {@code null} if none
       * @param mediaContent The media HTTP content or {@code null} if none.
       * @since 1.13
       */
      protected Insert(com.google.api.services.youtube.model.ChannelBannerResource content,
          com.google.api.client.http.AbstractInputStreamContent mediaContent) {
        super(YouTube.this, "POST", "/upload/" + getServicePath() + REST_PATH, content, com.google.api.services.youtube.model.ChannelBannerResource.class);
        initializeMediaUpload(mediaContent);
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The CMS account that the user authenticates with must be linked to the specified YouTube content
     owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public Insert setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the ChannelSections collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.ChannelSections.List request = youtube.channelSections().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public ChannelSections channelSections() {
    return new ChannelSections();
  }

  /**
   * The "channelSections" collection of methods.
   */
  public class ChannelSections {

    /**
     * Deletes a channelSection.
     *
     * Create a request for the method "channelSections.delete".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param id The id parameter specifies the YouTube channelSection ID for the resource that is being deleted. In
     *        a channelSection resource, the id property specifies the YouTube channelSection ID.
     * @return the request
     */
    public Delete delete(java.lang.String id) throws java.io.IOException {
      Delete result = new Delete(id);
      initialize(result);
      return result;
    }

    public class Delete extends YouTubeRequest<Void> {

      private static final String REST_PATH = "channelSections";

      /**
       * Deletes a channelSection.
       *
       * Create a request for the method "channelSections.delete".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param id The id parameter specifies the YouTube channelSection ID for the resource that is being deleted. In
     *        a channelSection resource, the id property specifies the YouTube channelSection ID.
       * @since 1.13
       */
      protected Delete(java.lang.String id) {
        super(YouTube.this, "DELETE", REST_PATH, null, Void.class);
        this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /**
       * The id parameter specifies the YouTube channelSection ID for the resource that is being
       * deleted. In a channelSection resource, the id property specifies the YouTube channelSection
       * ID.
       */
      @com.google.api.client.util.Key
      private java.lang.String id;

      /** The id parameter specifies the YouTube channelSection ID for the resource that is being deleted. In
     a channelSection resource, the id property specifies the YouTube channelSection ID.
       */
      public java.lang.String getId() {
        return id;
      }

      /**
       * The id parameter specifies the YouTube channelSection ID for the resource that is being
       * deleted. In a channelSection resource, the id property specifies the YouTube channelSection
       * ID.
       */
      public Delete setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Adds a channelSection for the authenticated user's channel.
     *
     * Create a request for the method "channelSections.insert".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
    The
     *        part names that you can include in the parameter value are snippet and contentDetails.
     * @param content the {@link com.google.api.services.youtube.model.ChannelSection}
     * @return the request
     */
    public Insert insert(java.lang.String part, com.google.api.services.youtube.model.ChannelSection content) throws java.io.IOException {
      Insert result = new Insert(part, content);
      initialize(result);
      return result;
    }

    public class Insert extends YouTubeRequest<com.google.api.services.youtube.model.ChannelSection> {

      private static final String REST_PATH = "channelSections";

      /**
       * Adds a channelSection for the authenticated user's channel.
       *
       * Create a request for the method "channelSections.insert".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
    The
     *        part names that you can include in the parameter value are snippet and contentDetails.
       * @param content the {@link com.google.api.services.youtube.model.ChannelSection}
       * @since 1.13
       */
      protected Insert(java.lang.String part, com.google.api.services.youtube.model.ChannelSection content) {
        super(YouTube.this, "POST", REST_PATH, content, com.google.api.services.youtube.model.ChannelSection.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /**
       * The part parameter serves two purposes in this operation. It identifies the properties that
       * the write operation will set as well as the properties that the API response will include.
       *
       * The part names that you can include in the parameter value are snippet and contentDetails.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter serves two purposes in this operation. It identifies the properties that the
     write operation will set as well as the properties that the API response will include.

     The part names that you can include in the parameter value are snippet and contentDetails.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter serves two purposes in this operation. It identifies the properties that
       * the write operation will set as well as the properties that the API response will include.
       *
       * The part names that you can include in the parameter value are snippet and contentDetails.
       */
      public Insert setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      /**
       * This parameter can only be used in a properly authorized request. Note: This parameter is
       * intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel
       * to which a video is being added. This parameter is required when a request specifies a
       * value for the onBehalfOfContentOwner parameter, and it can only be used in conjunction with
       * that parameter. In addition, the request must be authorized using a CMS account that is
       * linked to the content owner that the onBehalfOfContentOwner parameter specifies. Finally,
       * the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be linked
       * to the content owner that the onBehalfOfContentOwner parameter specifies.
       *
       * This parameter is intended for YouTube content partners that own and manage many different
       * YouTube channels. It allows content owners to authenticate once and perform actions on
       * behalf of the channel specified in the parameter value, without having to provide
       * authentication credentials for each separate channel.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwnerChannel;

      /** This parameter can only be used in a properly authorized request. Note: This parameter is intended
     exclusively for YouTube content partners.

     The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel to
     which a video is being added. This parameter is required when a request specifies a value for the
     onBehalfOfContentOwner parameter, and it can only be used in conjunction with that parameter. In
     addition, the request must be authorized using a CMS account that is linked to the content owner
     that the onBehalfOfContentOwner parameter specifies. Finally, the channel that the
     onBehalfOfContentOwnerChannel parameter value specifies must be linked to the content owner that
     the onBehalfOfContentOwner parameter specifies.

     This parameter is intended for YouTube content partners that own and manage many different YouTube
     channels. It allows content owners to authenticate once and perform actions on behalf of the
     channel specified in the parameter value, without having to provide authentication credentials for
     each separate channel.
       */
      public java.lang.String getOnBehalfOfContentOwnerChannel() {
        return onBehalfOfContentOwnerChannel;
      }

      /**
       * This parameter can only be used in a properly authorized request. Note: This parameter is
       * intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel
       * to which a video is being added. This parameter is required when a request specifies a
       * value for the onBehalfOfContentOwner parameter, and it can only be used in conjunction with
       * that parameter. In addition, the request must be authorized using a CMS account that is
       * linked to the content owner that the onBehalfOfContentOwner parameter specifies. Finally,
       * the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be linked
       * to the content owner that the onBehalfOfContentOwner parameter specifies.
       *
       * This parameter is intended for YouTube content partners that own and manage many different
       * YouTube channels. It allows content owners to authenticate once and perform actions on
       * behalf of the channel specified in the parameter value, without having to provide
       * authentication credentials for each separate channel.
       */
      public Insert setOnBehalfOfContentOwnerChannel(java.lang.String onBehalfOfContentOwnerChannel) {
        this.onBehalfOfContentOwnerChannel = onBehalfOfContentOwnerChannel;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The CMS account that the user authenticates with must be linked to the specified YouTube content
     owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public Insert setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Returns channelSection resources that match the API request criteria.
     *
     * Create a request for the method "channelSections.list".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter specifies a comma-separated list of one or more channelSection resource
     *        properties that the API response will include. The part names that you can include in the
     *        parameter value are id, snippet, and contentDetails.
    If the parameter identifies a
     *        property that contains child properties, the child properties will be included in the
     *        response. For example, in a channelSection resource, the snippet property contains other
     *        properties, such as a display title for the channelSection. If you set part=snippet, the
     *        API response will also contain all of those nested properties.
     * @return the request
     */
    public List list(java.lang.String part) throws java.io.IOException {
      List result = new List(part);
      initialize(result);
      return result;
    }

    public class List extends YouTubeRequest<com.google.api.services.youtube.model.ChannelSectionListResponse> {

      private static final String REST_PATH = "channelSections";

      /**
       * Returns channelSection resources that match the API request criteria.
       *
       * Create a request for the method "channelSections.list".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter specifies a comma-separated list of one or more channelSection resource
     *        properties that the API response will include. The part names that you can include in the
     *        parameter value are id, snippet, and contentDetails.
    If the parameter identifies a
     *        property that contains child properties, the child properties will be included in the
     *        response. For example, in a channelSection resource, the snippet property contains other
     *        properties, such as a display title for the channelSection. If you set part=snippet, the
     *        API response will also contain all of those nested properties.
       * @since 1.13
       */
      protected List(java.lang.String part) {
        super(YouTube.this, "GET", REST_PATH, null, com.google.api.services.youtube.model.ChannelSectionListResponse.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /**
       * The part parameter specifies a comma-separated list of one or more channelSection resource
       * properties that the API response will include. The part names that you can include in the
       * parameter value are id, snippet, and contentDetails.
       *
       * If the parameter identifies a property that contains child properties, the child properties
       * will be included in the response. For example, in a channelSection resource, the snippet
       * property contains other properties, such as a display title for the channelSection. If you
       * set part=snippet, the API response will also contain all of those nested properties.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter specifies a comma-separated list of one or more channelSection resource
     properties that the API response will include. The part names that you can include in the parameter
     value are id, snippet, and contentDetails.

     If the parameter identifies a property that contains child properties, the child properties will be
     included in the response. For example, in a channelSection resource, the snippet property contains
     other properties, such as a display title for the channelSection. If you set part=snippet, the API
     response will also contain all of those nested properties.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter specifies a comma-separated list of one or more channelSection resource
       * properties that the API response will include. The part names that you can include in the
       * parameter value are id, snippet, and contentDetails.
       *
       * If the parameter identifies a property that contains child properties, the child properties
       * will be included in the response. For example, in a channelSection resource, the snippet
       * property contains other properties, such as a display title for the channelSection. If you
       * set part=snippet, the API response will also contain all of those nested properties.
       */
      public List setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The CMS account that the user authenticates with must be linked to the specified YouTube content
     owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public List setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      /**
       * The channelId parameter specifies a YouTube channel ID. The API will only return that
       * channel's channelSections.
       */
      @com.google.api.client.util.Key
      private java.lang.String channelId;

      /** The channelId parameter specifies a YouTube channel ID. The API will only return that channel's
     channelSections.
       */
      public java.lang.String getChannelId() {
        return channelId;
      }

      /**
       * The channelId parameter specifies a YouTube channel ID. The API will only return that
       * channel's channelSections.
       */
      public List setChannelId(java.lang.String channelId) {
        this.channelId = channelId;
        return this;
      }

      /**
       * The id parameter specifies a comma-separated list of the YouTube channelSection ID(s) for
       * the resource(s) that are being retrieved. In a channelSection resource, the id property
       * specifies the YouTube channelSection ID.
       */
      @com.google.api.client.util.Key
      private java.lang.String id;

      /** The id parameter specifies a comma-separated list of the YouTube channelSection ID(s) for the
     resource(s) that are being retrieved. In a channelSection resource, the id property specifies the
     YouTube channelSection ID.
       */
      public java.lang.String getId() {
        return id;
      }

      /**
       * The id parameter specifies a comma-separated list of the YouTube channelSection ID(s) for
       * the resource(s) that are being retrieved. In a channelSection resource, the id property
       * specifies the YouTube channelSection ID.
       */
      public List setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      /**
       * Set this parameter's value to true to retrieve a feed of the authenticated user's
       * channelSections.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean mine;

      /** Set this parameter's value to true to retrieve a feed of the authenticated user's channelSections.
       */
      public java.lang.Boolean getMine() {
        return mine;
      }

      /**
       * Set this parameter's value to true to retrieve a feed of the authenticated user's
       * channelSections.
       */
      public List setMine(java.lang.Boolean mine) {
        this.mine = mine;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Update a channelSection.
     *
     * Create a request for the method "channelSections.update".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
    The
     *        part names that you can include in the parameter value are snippet and contentDetails.
     * @param content the {@link com.google.api.services.youtube.model.ChannelSection}
     * @return the request
     */
    public Update update(java.lang.String part, com.google.api.services.youtube.model.ChannelSection content) throws java.io.IOException {
      Update result = new Update(part, content);
      initialize(result);
      return result;
    }

    public class Update extends YouTubeRequest<com.google.api.services.youtube.model.ChannelSection> {

      private static final String REST_PATH = "channelSections";

      /**
       * Update a channelSection.
       *
       * Create a request for the method "channelSections.update".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
    The
     *        part names that you can include in the parameter value are snippet and contentDetails.
       * @param content the {@link com.google.api.services.youtube.model.ChannelSection}
       * @since 1.13
       */
      protected Update(java.lang.String part, com.google.api.services.youtube.model.ChannelSection content) {
        super(YouTube.this, "PUT", REST_PATH, content, com.google.api.services.youtube.model.ChannelSection.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /**
       * The part parameter serves two purposes in this operation. It identifies the properties that
       * the write operation will set as well as the properties that the API response will include.
       *
       * The part names that you can include in the parameter value are snippet and contentDetails.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter serves two purposes in this operation. It identifies the properties that the
     write operation will set as well as the properties that the API response will include.

     The part names that you can include in the parameter value are snippet and contentDetails.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter serves two purposes in this operation. It identifies the properties that
       * the write operation will set as well as the properties that the API response will include.
       *
       * The part names that you can include in the parameter value are snippet and contentDetails.
       */
      public Update setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Channels collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.Channels.List request = youtube.channels().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Channels channels() {
    return new Channels();
  }

  /**
   * The "channels" collection of methods.
   */
  public class Channels {

    /**
     * Returns a collection of zero or more channel resources that match the request criteria.
     *
     * Create a request for the method "channels.list".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter specifies a comma-separated list of one or more channel resource properties that
     *        the API response will include. The part names that you can include in the parameter value
     *        are id, snippet, contentDetails, statistics, topicDetails, and invideoPromotion.
    If the
     *        parameter identifies a property that contains child properties, the child properties will
     *        be included in the response. For example, in a channel resource, the contentDetails
     *        property contains other properties, such as the uploads properties. As such, if you set
     *        part=contentDetails, the API response will also contain all of those nested properties.
     * @return the request
     */
    public List list(java.lang.String part) throws java.io.IOException {
      List result = new List(part);
      initialize(result);
      return result;
    }

    public class List extends YouTubeRequest<com.google.api.services.youtube.model.ChannelListResponse> {

      private static final String REST_PATH = "channels";

      /**
       * Returns a collection of zero or more channel resources that match the request criteria.
       *
       * Create a request for the method "channels.list".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter specifies a comma-separated list of one or more channel resource properties that
     *        the API response will include. The part names that you can include in the parameter value
     *        are id, snippet, contentDetails, statistics, topicDetails, and invideoPromotion.
    If the
     *        parameter identifies a property that contains child properties, the child properties will
     *        be included in the response. For example, in a channel resource, the contentDetails
     *        property contains other properties, such as the uploads properties. As such, if you set
     *        part=contentDetails, the API response will also contain all of those nested properties.
       * @since 1.13
       */
      protected List(java.lang.String part) {
        super(YouTube.this, "GET", REST_PATH, null, com.google.api.services.youtube.model.ChannelListResponse.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /**
       * The part parameter specifies a comma-separated list of one or more channel resource
       * properties that the API response will include. The part names that you can include in the
       * parameter value are id, snippet, contentDetails, statistics, topicDetails, and
       * invideoPromotion.
       *
       * If the parameter identifies a property that contains child properties, the child properties
       * will be included in the response. For example, in a channel resource, the contentDetails
       * property contains other properties, such as the uploads properties. As such, if you set
       * part=contentDetails, the API response will also contain all of those nested properties.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter specifies a comma-separated list of one or more channel resource properties that
     the API response will include. The part names that you can include in the parameter value are id,
     snippet, contentDetails, statistics, topicDetails, and invideoPromotion.

     If the parameter identifies a property that contains child properties, the child properties will be
     included in the response. For example, in a channel resource, the contentDetails property contains
     other properties, such as the uploads properties. As such, if you set part=contentDetails, the API
     response will also contain all of those nested properties.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter specifies a comma-separated list of one or more channel resource
       * properties that the API response will include. The part names that you can include in the
       * parameter value are id, snippet, contentDetails, statistics, topicDetails, and
       * invideoPromotion.
       *
       * If the parameter identifies a property that contains child properties, the child properties
       * will be included in the response. For example, in a channel resource, the contentDetails
       * property contains other properties, such as the uploads properties. As such, if you set
       * part=contentDetails, the API response will also contain all of those nested properties.
       */
      public List setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      /**
       * Set this parameter's value to true to instruct the API to only return channels managed by
       * the content owner that the onBehalfOfContentOwner parameter specifies. The user must be
       * authenticated as a CMS account linked to the specified content owner and
       * onBehalfOfContentOwner must be provided.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean managedByMe;

      /** Set this parameter's value to true to instruct the API to only return channels managed by the
     content owner that the onBehalfOfContentOwner parameter specifies. The user must be authenticated
     as a CMS account linked to the specified content owner and onBehalfOfContentOwner must be provided.
       */
      public java.lang.Boolean getManagedByMe() {
        return managedByMe;
      }

      /**
       * Set this parameter's value to true to instruct the API to only return channels managed by
       * the content owner that the onBehalfOfContentOwner parameter specifies. The user must be
       * authenticated as a CMS account linked to the specified content owner and
       * onBehalfOfContentOwner must be provided.
       */
      public List setManagedByMe(java.lang.Boolean managedByMe) {
        this.managedByMe = managedByMe;
        return this;
      }

      /**
       * The onBehalfOfContentOwner parameter indicates that the authenticated user is acting on
       * behalf of the content owner specified in the parameter value. This parameter is intended
       * for YouTube content partners that own and manage many different YouTube channels. It allows
       * content owners to authenticate once and get access to all their video and channel data,
       * without having to provide authentication credentials for each individual channel. The
       * actual CMS account that the user authenticates with needs to be linked to the specified
       * YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** The onBehalfOfContentOwner parameter indicates that the authenticated user is acting on behalf of
     the content owner specified in the parameter value. This parameter is intended for YouTube content
     partners that own and manage many different YouTube channels. It allows content owners to
     authenticate once and get access to all their video and channel data, without having to provide
     authentication credentials for each individual channel. The actual CMS account that the user
     authenticates with needs to be linked to the specified YouTube content owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * The onBehalfOfContentOwner parameter indicates that the authenticated user is acting on
       * behalf of the content owner specified in the parameter value. This parameter is intended
       * for YouTube content partners that own and manage many different YouTube channels. It allows
       * content owners to authenticate once and get access to all their video and channel data,
       * without having to provide authentication credentials for each individual channel. The
       * actual CMS account that the user authenticates with needs to be linked to the specified
       * YouTube content owner.
       */
      public List setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      /**
       * The forUsername parameter specifies a YouTube username, thereby requesting the channel
       * associated with that username.
       */
      @com.google.api.client.util.Key
      private java.lang.String forUsername;

      /** The forUsername parameter specifies a YouTube username, thereby requesting the channel associated
     with that username.
       */
      public java.lang.String getForUsername() {
        return forUsername;
      }

      /**
       * The forUsername parameter specifies a YouTube username, thereby requesting the channel
       * associated with that username.
       */
      public List setForUsername(java.lang.String forUsername) {
        this.forUsername = forUsername;
        return this;
      }

      /**
       * Set this parameter's value to true to instruct the API to only return channels owned by the
       * authenticated user.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean mine;

      /** Set this parameter's value to true to instruct the API to only return channels owned by the
     authenticated user.
       */
      public java.lang.Boolean getMine() {
        return mine;
      }

      /**
       * Set this parameter's value to true to instruct the API to only return channels owned by the
       * authenticated user.
       */
      public List setMine(java.lang.Boolean mine) {
        this.mine = mine;
        return this;
      }

      /**
       * The maxResults parameter specifies the maximum number of items that should be returned in
       * the result set.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maxResults parameter specifies the maximum number of items that should be returned in the
     result set. [default: 5] [minimum: 0] [maximum: 50]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maxResults parameter specifies the maximum number of items that should be returned in
       * the result set.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * The id parameter specifies a comma-separated list of the YouTube channel ID(s) for the
       * resource(s) that are being retrieved. In a channel resource, the id property specifies the
       * channel's YouTube channel ID.
       */
      @com.google.api.client.util.Key
      private java.lang.String id;

      /** The id parameter specifies a comma-separated list of the YouTube channel ID(s) for the resource(s)
     that are being retrieved. In a channel resource, the id property specifies the channel's YouTube
     channel ID.
       */
      public java.lang.String getId() {
        return id;
      }

      /**
       * The id parameter specifies a comma-separated list of the YouTube channel ID(s) for the
       * resource(s) that are being retrieved. In a channel resource, the id property specifies the
       * channel's YouTube channel ID.
       */
      public List setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      /**
       * The pageToken parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The pageToken parameter identifies a specific page in the result set that should be returned. In an
     API response, the nextPageToken and prevPageToken properties identify other pages that could be
     retrieved.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * The pageToken parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Set this parameter's value to true to retrieve a list of channels that subscribed to the
       * authenticated user's channel.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean mySubscribers;

      /** Set this parameter's value to true to retrieve a list of channels that subscribed to the
     authenticated user's channel.
       */
      public java.lang.Boolean getMySubscribers() {
        return mySubscribers;
      }

      /**
       * Set this parameter's value to true to retrieve a list of channels that subscribed to the
       * authenticated user's channel.
       */
      public List setMySubscribers(java.lang.Boolean mySubscribers) {
        this.mySubscribers = mySubscribers;
        return this;
      }

      /**
       * The categoryId parameter specifies a YouTube guide category, thereby requesting YouTube
       * channels associated with that category.
       */
      @com.google.api.client.util.Key
      private java.lang.String categoryId;

      /** The categoryId parameter specifies a YouTube guide category, thereby requesting YouTube channels
     associated with that category.
       */
      public java.lang.String getCategoryId() {
        return categoryId;
      }

      /**
       * The categoryId parameter specifies a YouTube guide category, thereby requesting YouTube
       * channels associated with that category.
       */
      public List setCategoryId(java.lang.String categoryId) {
        this.categoryId = categoryId;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates a channel's metadata.
     *
     * Create a request for the method "channels.update".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
    The
     *        part names that you can include in the parameter value are id and invideoPromotion.
    Note
     *        that this method will override the existing values for all of the mutable properties that
     *        are contained in any parts that the parameter value specifies.
     * @param content the {@link com.google.api.services.youtube.model.Channel}
     * @return the request
     */
    public Update update(java.lang.String part, com.google.api.services.youtube.model.Channel content) throws java.io.IOException {
      Update result = new Update(part, content);
      initialize(result);
      return result;
    }

    public class Update extends YouTubeRequest<com.google.api.services.youtube.model.Channel> {

      private static final String REST_PATH = "channels";

      /**
       * Updates a channel's metadata.
       *
       * Create a request for the method "channels.update".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
    The
     *        part names that you can include in the parameter value are id and invideoPromotion.
    Note
     *        that this method will override the existing values for all of the mutable properties that
     *        are contained in any parts that the parameter value specifies.
       * @param content the {@link com.google.api.services.youtube.model.Channel}
       * @since 1.13
       */
      protected Update(java.lang.String part, com.google.api.services.youtube.model.Channel content) {
        super(YouTube.this, "PUT", REST_PATH, content, com.google.api.services.youtube.model.Channel.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /**
       * The part parameter serves two purposes in this operation. It identifies the properties that
       * the write operation will set as well as the properties that the API response will include.
       *
       * The part names that you can include in the parameter value are id and invideoPromotion.
       *
       * Note that this method will override the existing values for all of the mutable properties
       * that are contained in any parts that the parameter value specifies.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter serves two purposes in this operation. It identifies the properties that the
     write operation will set as well as the properties that the API response will include.

     The part names that you can include in the parameter value are id and invideoPromotion.

     Note that this method will override the existing values for all of the mutable properties that are
     contained in any parts that the parameter value specifies.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter serves two purposes in this operation. It identifies the properties that
       * the write operation will set as well as the properties that the API response will include.
       *
       * The part names that you can include in the parameter value are id and invideoPromotion.
       *
       * Note that this method will override the existing values for all of the mutable properties
       * that are contained in any parts that the parameter value specifies.
       */
      public Update setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      /**
       * The onBehalfOfContentOwner parameter indicates that the authenticated user is acting on
       * behalf of the content owner specified in the parameter value. This parameter is intended
       * for YouTube content partners that own and manage many different YouTube channels. It allows
       * content owners to authenticate once and get access to all their video and channel data,
       * without having to provide authentication credentials for each individual channel. The
       * actual CMS account that the user authenticates with needs to be linked to the specified
       * YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** The onBehalfOfContentOwner parameter indicates that the authenticated user is acting on behalf of
     the content owner specified in the parameter value. This parameter is intended for YouTube content
     partners that own and manage many different YouTube channels. It allows content owners to
     authenticate once and get access to all their video and channel data, without having to provide
     authentication credentials for each individual channel. The actual CMS account that the user
     authenticates with needs to be linked to the specified YouTube content owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * The onBehalfOfContentOwner parameter indicates that the authenticated user is acting on
       * behalf of the content owner specified in the parameter value. This parameter is intended
       * for YouTube content partners that own and manage many different YouTube channels. It allows
       * content owners to authenticate once and get access to all their video and channel data,
       * without having to provide authentication credentials for each individual channel. The
       * actual CMS account that the user authenticates with needs to be linked to the specified
       * YouTube content owner.
       */
      public Update setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the GuideCategories collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.GuideCategories.List request = youtube.guideCategories().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public GuideCategories guideCategories() {
    return new GuideCategories();
  }

  /**
   * The "guideCategories" collection of methods.
   */
  public class GuideCategories {

    /**
     * Returns a list of categories that can be associated with YouTube channels.
     *
     * Create a request for the method "guideCategories.list".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter specifies a comma-separated list of one or more guideCategory resource properties
     *        that the API response will include. The part names that you can include in the parameter
     *        value are id and snippet.
    If the parameter identifies a property that contains child
     *        properties, the child properties will be included in the response. For example, in a
     *        guideCategory resource, the snippet property contains other properties, such as the
     *        category's title. If you set part=snippet, the API response will also contain all of those
     *        nested properties.
     * @return the request
     */
    public List list(java.lang.String part) throws java.io.IOException {
      List result = new List(part);
      initialize(result);
      return result;
    }

    public class List extends YouTubeRequest<com.google.api.services.youtube.model.GuideCategoryListResponse> {

      private static final String REST_PATH = "guideCategories";

      /**
       * Returns a list of categories that can be associated with YouTube channels.
       *
       * Create a request for the method "guideCategories.list".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter specifies a comma-separated list of one or more guideCategory resource properties
     *        that the API response will include. The part names that you can include in the parameter
     *        value are id and snippet.
    If the parameter identifies a property that contains child
     *        properties, the child properties will be included in the response. For example, in a
     *        guideCategory resource, the snippet property contains other properties, such as the
     *        category's title. If you set part=snippet, the API response will also contain all of those
     *        nested properties.
       * @since 1.13
       */
      protected List(java.lang.String part) {
        super(YouTube.this, "GET", REST_PATH, null, com.google.api.services.youtube.model.GuideCategoryListResponse.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /**
       * The part parameter specifies a comma-separated list of one or more guideCategory resource
       * properties that the API response will include. The part names that you can include in the
       * parameter value are id and snippet.
       *
       * If the parameter identifies a property that contains child properties, the child properties
       * will be included in the response. For example, in a guideCategory resource, the snippet
       * property contains other properties, such as the category's title. If you set part=snippet,
       * the API response will also contain all of those nested properties.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter specifies a comma-separated list of one or more guideCategory resource
     properties that the API response will include. The part names that you can include in the parameter
     value are id and snippet.

     If the parameter identifies a property that contains child properties, the child properties will be
     included in the response. For example, in a guideCategory resource, the snippet property contains
     other properties, such as the category's title. If you set part=snippet, the API response will also
     contain all of those nested properties.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter specifies a comma-separated list of one or more guideCategory resource
       * properties that the API response will include. The part names that you can include in the
       * parameter value are id and snippet.
       *
       * If the parameter identifies a property that contains child properties, the child properties
       * will be included in the response. For example, in a guideCategory resource, the snippet
       * property contains other properties, such as the category's title. If you set part=snippet,
       * the API response will also contain all of those nested properties.
       */
      public List setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      /**
       * The regionCode parameter instructs the API to return the list of guide categories available
       * in the specified country. The parameter value is an ISO 3166-1 alpha-2 country code.
       */
      @com.google.api.client.util.Key
      private java.lang.String regionCode;

      /** The regionCode parameter instructs the API to return the list of guide categories available in the
     specified country. The parameter value is an ISO 3166-1 alpha-2 country code.
       */
      public java.lang.String getRegionCode() {
        return regionCode;
      }

      /**
       * The regionCode parameter instructs the API to return the list of guide categories available
       * in the specified country. The parameter value is an ISO 3166-1 alpha-2 country code.
       */
      public List setRegionCode(java.lang.String regionCode) {
        this.regionCode = regionCode;
        return this;
      }

      /**
       * The id parameter specifies a comma-separated list of the YouTube channel category ID(s) for
       * the resource(s) that are being retrieved. In a guideCategory resource, the id property
       * specifies the YouTube channel category ID.
       */
      @com.google.api.client.util.Key
      private java.lang.String id;

      /** The id parameter specifies a comma-separated list of the YouTube channel category ID(s) for the
     resource(s) that are being retrieved. In a guideCategory resource, the id property specifies the
     YouTube channel category ID.
       */
      public java.lang.String getId() {
        return id;
      }

      /**
       * The id parameter specifies a comma-separated list of the YouTube channel category ID(s) for
       * the resource(s) that are being retrieved. In a guideCategory resource, the id property
       * specifies the YouTube channel category ID.
       */
      public List setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      /**
       * The hl parameter specifies the language that will be used for text values in the API
       * response.
       */
      @com.google.api.client.util.Key
      private java.lang.String hl;

      /** The hl parameter specifies the language that will be used for text values in the API response.
     [default: en-US]
       */
      public java.lang.String getHl() {
        return hl;
      }

      /**
       * The hl parameter specifies the language that will be used for text values in the API
       * response.
       */
      public List setHl(java.lang.String hl) {
        this.hl = hl;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the I18nLanguages collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.I18nLanguages.List request = youtube.i18nLanguages().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public I18nLanguages i18nLanguages() {
    return new I18nLanguages();
  }

  /**
   * The "i18nLanguages" collection of methods.
   */
  public class I18nLanguages {

    /**
     * Returns a list of supported languages.
     *
     * Create a request for the method "i18nLanguages.list".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter specifies a comma-separated list of one or more i18nLanguage resource properties
     *        that the API response will include. The part names that you can include in the parameter
     *        value are id and snippet.
     * @return the request
     */
    public List list(java.lang.String part) throws java.io.IOException {
      List result = new List(part);
      initialize(result);
      return result;
    }

    public class List extends YouTubeRequest<com.google.api.services.youtube.model.I18nLanguageListResponse> {

      private static final String REST_PATH = "i18nLanguages";

      /**
       * Returns a list of supported languages.
       *
       * Create a request for the method "i18nLanguages.list".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter specifies a comma-separated list of one or more i18nLanguage resource properties
     *        that the API response will include. The part names that you can include in the parameter
     *        value are id and snippet.
       * @since 1.13
       */
      protected List(java.lang.String part) {
        super(YouTube.this, "GET", REST_PATH, null, com.google.api.services.youtube.model.I18nLanguageListResponse.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /**
       * The part parameter specifies a comma-separated list of one or more i18nLanguage resource
       * properties that the API response will include. The part names that you can include in the
       * parameter value are id and snippet.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter specifies a comma-separated list of one or more i18nLanguage resource properties
     that the API response will include. The part names that you can include in the parameter value are
     id and snippet.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter specifies a comma-separated list of one or more i18nLanguage resource
       * properties that the API response will include. The part names that you can include in the
       * parameter value are id and snippet.
       */
      public List setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      /**
       * The hl parameter specifies the language that should be used for text values in the API
       * response.
       */
      @com.google.api.client.util.Key
      private java.lang.String hl;

      /** The hl parameter specifies the language that should be used for text values in the API response.
     [default: en_US]
       */
      public java.lang.String getHl() {
        return hl;
      }

      /**
       * The hl parameter specifies the language that should be used for text values in the API
       * response.
       */
      public List setHl(java.lang.String hl) {
        this.hl = hl;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the I18nRegions collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.I18nRegions.List request = youtube.i18nRegions().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public I18nRegions i18nRegions() {
    return new I18nRegions();
  }

  /**
   * The "i18nRegions" collection of methods.
   */
  public class I18nRegions {

    /**
     * Returns a list of supported regions.
     *
     * Create a request for the method "i18nRegions.list".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter specifies a comma-separated list of one or more i18nRegion resource properties
     *        that the API response will include. The part names that you can include in the parameter
     *        value are id and snippet.
     * @return the request
     */
    public List list(java.lang.String part) throws java.io.IOException {
      List result = new List(part);
      initialize(result);
      return result;
    }

    public class List extends YouTubeRequest<com.google.api.services.youtube.model.I18nRegionListResponse> {

      private static final String REST_PATH = "i18nRegions";

      /**
       * Returns a list of supported regions.
       *
       * Create a request for the method "i18nRegions.list".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter specifies a comma-separated list of one or more i18nRegion resource properties
     *        that the API response will include. The part names that you can include in the parameter
     *        value are id and snippet.
       * @since 1.13
       */
      protected List(java.lang.String part) {
        super(YouTube.this, "GET", REST_PATH, null, com.google.api.services.youtube.model.I18nRegionListResponse.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /**
       * The part parameter specifies a comma-separated list of one or more i18nRegion resource
       * properties that the API response will include. The part names that you can include in the
       * parameter value are id and snippet.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter specifies a comma-separated list of one or more i18nRegion resource properties
     that the API response will include. The part names that you can include in the parameter value are
     id and snippet.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter specifies a comma-separated list of one or more i18nRegion resource
       * properties that the API response will include. The part names that you can include in the
       * parameter value are id and snippet.
       */
      public List setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      /**
       * The hl parameter specifies the language that should be used for text values in the API
       * response.
       */
      @com.google.api.client.util.Key
      private java.lang.String hl;

      /** The hl parameter specifies the language that should be used for text values in the API response.
     [default: en_US]
       */
      public java.lang.String getHl() {
        return hl;
      }

      /**
       * The hl parameter specifies the language that should be used for text values in the API
       * response.
       */
      public List setHl(java.lang.String hl) {
        this.hl = hl;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the LiveBroadcasts collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.LiveBroadcasts.List request = youtube.liveBroadcasts().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public LiveBroadcasts liveBroadcasts() {
    return new LiveBroadcasts();
  }

  /**
   * The "liveBroadcasts" collection of methods.
   */
  public class LiveBroadcasts {

    /**
     * Binds a YouTube broadcast to a stream or removes an existing binding between a broadcast and a
     * stream. A broadcast can only be bound to one video stream.
     *
     * Create a request for the method "liveBroadcasts.bind".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Bind#execute()} method to invoke the remote operation.
     *
     * @param id The id parameter specifies the unique ID of the broadcast that is being bound to a video stream.
     * @param part The part parameter specifies a comma-separated list of one or more liveBroadcast resource properties
     *        that the API response will include. The part names that you can include in the parameter
     *        value are id, snippet, contentDetails, and status.
     * @return the request
     */
    public Bind bind(java.lang.String id, java.lang.String part) throws java.io.IOException {
      Bind result = new Bind(id, part);
      initialize(result);
      return result;
    }

    public class Bind extends YouTubeRequest<com.google.api.services.youtube.model.LiveBroadcast> {

      private static final String REST_PATH = "liveBroadcasts/bind";

      /**
       * Binds a YouTube broadcast to a stream or removes an existing binding between a broadcast and a
       * stream. A broadcast can only be bound to one video stream.
       *
       * Create a request for the method "liveBroadcasts.bind".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Bind#execute()} method to invoke the remote operation. <p> {@link
       * Bind#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param id The id parameter specifies the unique ID of the broadcast that is being bound to a video stream.
       * @param part The part parameter specifies a comma-separated list of one or more liveBroadcast resource properties
     *        that the API response will include. The part names that you can include in the parameter
     *        value are id, snippet, contentDetails, and status.
       * @since 1.13
       */
      protected Bind(java.lang.String id, java.lang.String part) {
        super(YouTube.this, "POST", REST_PATH, null, com.google.api.services.youtube.model.LiveBroadcast.class);
        this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public Bind setAlt(java.lang.String alt) {
        return (Bind) super.setAlt(alt);
      }

      @Override
      public Bind setFields(java.lang.String fields) {
        return (Bind) super.setFields(fields);
      }

      @Override
      public Bind setKey(java.lang.String key) {
        return (Bind) super.setKey(key);
      }

      @Override
      public Bind setOauthToken(java.lang.String oauthToken) {
        return (Bind) super.setOauthToken(oauthToken);
      }

      @Override
      public Bind setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Bind) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Bind setQuotaUser(java.lang.String quotaUser) {
        return (Bind) super.setQuotaUser(quotaUser);
      }

      @Override
      public Bind setUserIp(java.lang.String userIp) {
        return (Bind) super.setUserIp(userIp);
      }

      /**
       * The id parameter specifies the unique ID of the broadcast that is being bound to a video
       * stream.
       */
      @com.google.api.client.util.Key
      private java.lang.String id;

      /** The id parameter specifies the unique ID of the broadcast that is being bound to a video stream.
       */
      public java.lang.String getId() {
        return id;
      }

      /**
       * The id parameter specifies the unique ID of the broadcast that is being bound to a video
       * stream.
       */
      public Bind setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      /**
       * The part parameter specifies a comma-separated list of one or more liveBroadcast resource
       * properties that the API response will include. The part names that you can include in the
       * parameter value are id, snippet, contentDetails, and status.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter specifies a comma-separated list of one or more liveBroadcast resource
     properties that the API response will include. The part names that you can include in the parameter
     value are id, snippet, contentDetails, and status.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter specifies a comma-separated list of one or more liveBroadcast resource
       * properties that the API response will include. The part names that you can include in the
       * parameter value are id, snippet, contentDetails, and status.
       */
      public Bind setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      /**
       * This parameter can only be used in a properly authorized request. Note: This parameter is
       * intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel
       * to which a video is being added. This parameter is required when a request specifies a
       * value for the onBehalfOfContentOwner parameter, and it can only be used in conjunction with
       * that parameter. In addition, the request must be authorized using a CMS account that is
       * linked to the content owner that the onBehalfOfContentOwner parameter specifies. Finally,
       * the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be linked
       * to the content owner that the onBehalfOfContentOwner parameter specifies.
       *
       * This parameter is intended for YouTube content partners that own and manage many different
       * YouTube channels. It allows content owners to authenticate once and perform actions on
       * behalf of the channel specified in the parameter value, without having to provide
       * authentication credentials for each separate channel.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwnerChannel;

      /** This parameter can only be used in a properly authorized request. Note: This parameter is intended
     exclusively for YouTube content partners.

     The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel to
     which a video is being added. This parameter is required when a request specifies a value for the
     onBehalfOfContentOwner parameter, and it can only be used in conjunction with that parameter. In
     addition, the request must be authorized using a CMS account that is linked to the content owner
     that the onBehalfOfContentOwner parameter specifies. Finally, the channel that the
     onBehalfOfContentOwnerChannel parameter value specifies must be linked to the content owner that
     the onBehalfOfContentOwner parameter specifies.

     This parameter is intended for YouTube content partners that own and manage many different YouTube
     channels. It allows content owners to authenticate once and perform actions on behalf of the
     channel specified in the parameter value, without having to provide authentication credentials for
     each separate channel.
       */
      public java.lang.String getOnBehalfOfContentOwnerChannel() {
        return onBehalfOfContentOwnerChannel;
      }

      /**
       * This parameter can only be used in a properly authorized request. Note: This parameter is
       * intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel
       * to which a video is being added. This parameter is required when a request specifies a
       * value for the onBehalfOfContentOwner parameter, and it can only be used in conjunction with
       * that parameter. In addition, the request must be authorized using a CMS account that is
       * linked to the content owner that the onBehalfOfContentOwner parameter specifies. Finally,
       * the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be linked
       * to the content owner that the onBehalfOfContentOwner parameter specifies.
       *
       * This parameter is intended for YouTube content partners that own and manage many different
       * YouTube channels. It allows content owners to authenticate once and perform actions on
       * behalf of the channel specified in the parameter value, without having to provide
       * authentication credentials for each separate channel.
       */
      public Bind setOnBehalfOfContentOwnerChannel(java.lang.String onBehalfOfContentOwnerChannel) {
        this.onBehalfOfContentOwnerChannel = onBehalfOfContentOwnerChannel;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The CMS account that the user authenticates with must be linked to the specified YouTube content
     owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public Bind setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      /**
       * The streamId parameter specifies the unique ID of the video stream that is being bound to a
       * broadcast. If this parameter is omitted, the API will remove any existing binding between
       * the broadcast and a video stream.
       */
      @com.google.api.client.util.Key
      private java.lang.String streamId;

      /** The streamId parameter specifies the unique ID of the video stream that is being bound to a
     broadcast. If this parameter is omitted, the API will remove any existing binding between the
     broadcast and a video stream.
       */
      public java.lang.String getStreamId() {
        return streamId;
      }

      /**
       * The streamId parameter specifies the unique ID of the video stream that is being bound to a
       * broadcast. If this parameter is omitted, the API will remove any existing binding between
       * the broadcast and a video stream.
       */
      public Bind setStreamId(java.lang.String streamId) {
        this.streamId = streamId;
        return this;
      }

      @Override
      public Bind set(String parameterName, Object value) {
        return (Bind) super.set(parameterName, value);
      }
    }
    /**
     * Controls the settings for a slate that can be displayed in the broadcast stream.
     *
     * Create a request for the method "liveBroadcasts.control".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Control#execute()} method to invoke the remote operation.
     *
     * @param id The id parameter specifies the YouTube live broadcast ID that uniquely identifies the broadcast in
     *        which the slate is being updated.
     * @param part The part parameter specifies a comma-separated list of one or more liveBroadcast resource properties
     *        that the API response will include. The part names that you can include in the parameter
     *        value are id, snippet, contentDetails, and status.
     * @return the request
     */
    public Control control(java.lang.String id, java.lang.String part) throws java.io.IOException {
      Control result = new Control(id, part);
      initialize(result);
      return result;
    }

    public class Control extends YouTubeRequest<com.google.api.services.youtube.model.LiveBroadcast> {

      private static final String REST_PATH = "liveBroadcasts/control";

      /**
       * Controls the settings for a slate that can be displayed in the broadcast stream.
       *
       * Create a request for the method "liveBroadcasts.control".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Control#execute()} method to invoke the remote operation. <p>
       * {@link
       * Control#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param id The id parameter specifies the YouTube live broadcast ID that uniquely identifies the broadcast in
     *        which the slate is being updated.
       * @param part The part parameter specifies a comma-separated list of one or more liveBroadcast resource properties
     *        that the API response will include. The part names that you can include in the parameter
     *        value are id, snippet, contentDetails, and status.
       * @since 1.13
       */
      protected Control(java.lang.String id, java.lang.String part) {
        super(YouTube.this, "POST", REST_PATH, null, com.google.api.services.youtube.model.LiveBroadcast.class);
        this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public Control setAlt(java.lang.String alt) {
        return (Control) super.setAlt(alt);
      }

      @Override
      public Control setFields(java.lang.String fields) {
        return (Control) super.setFields(fields);
      }

      @Override
      public Control setKey(java.lang.String key) {
        return (Control) super.setKey(key);
      }

      @Override
      public Control setOauthToken(java.lang.String oauthToken) {
        return (Control) super.setOauthToken(oauthToken);
      }

      @Override
      public Control setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Control) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Control setQuotaUser(java.lang.String quotaUser) {
        return (Control) super.setQuotaUser(quotaUser);
      }

      @Override
      public Control setUserIp(java.lang.String userIp) {
        return (Control) super.setUserIp(userIp);
      }

      /**
       * The id parameter specifies the YouTube live broadcast ID that uniquely identifies the
       * broadcast in which the slate is being updated.
       */
      @com.google.api.client.util.Key
      private java.lang.String id;

      /** The id parameter specifies the YouTube live broadcast ID that uniquely identifies the broadcast in
     which the slate is being updated.
       */
      public java.lang.String getId() {
        return id;
      }

      /**
       * The id parameter specifies the YouTube live broadcast ID that uniquely identifies the
       * broadcast in which the slate is being updated.
       */
      public Control setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      /**
       * The part parameter specifies a comma-separated list of one or more liveBroadcast resource
       * properties that the API response will include. The part names that you can include in the
       * parameter value are id, snippet, contentDetails, and status.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter specifies a comma-separated list of one or more liveBroadcast resource
     properties that the API response will include. The part names that you can include in the parameter
     value are id, snippet, contentDetails, and status.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter specifies a comma-separated list of one or more liveBroadcast resource
       * properties that the API response will include. The part names that you can include in the
       * parameter value are id, snippet, contentDetails, and status.
       */
      public Control setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The CMS account that the user authenticates with must be linked to the specified YouTube content
     owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public Control setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      /** The displaySlate parameter specifies whether the slate is being enabled or disabled. */
      @com.google.api.client.util.Key
      private java.lang.Boolean displaySlate;

      /** The displaySlate parameter specifies whether the slate is being enabled or disabled.
       */
      public java.lang.Boolean getDisplaySlate() {
        return displaySlate;
      }

      /** The displaySlate parameter specifies whether the slate is being enabled or disabled. */
      public Control setDisplaySlate(java.lang.Boolean displaySlate) {
        this.displaySlate = displaySlate;
        return this;
      }

      /**
       * This parameter can only be used in a properly authorized request. Note: This parameter is
       * intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel
       * to which a video is being added. This parameter is required when a request specifies a
       * value for the onBehalfOfContentOwner parameter, and it can only be used in conjunction with
       * that parameter. In addition, the request must be authorized using a CMS account that is
       * linked to the content owner that the onBehalfOfContentOwner parameter specifies. Finally,
       * the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be linked
       * to the content owner that the onBehalfOfContentOwner parameter specifies.
       *
       * This parameter is intended for YouTube content partners that own and manage many different
       * YouTube channels. It allows content owners to authenticate once and perform actions on
       * behalf of the channel specified in the parameter value, without having to provide
       * authentication credentials for each separate channel.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwnerChannel;

      /** This parameter can only be used in a properly authorized request. Note: This parameter is intended
     exclusively for YouTube content partners.

     The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel to
     which a video is being added. This parameter is required when a request specifies a value for the
     onBehalfOfContentOwner parameter, and it can only be used in conjunction with that parameter. In
     addition, the request must be authorized using a CMS account that is linked to the content owner
     that the onBehalfOfContentOwner parameter specifies. Finally, the channel that the
     onBehalfOfContentOwnerChannel parameter value specifies must be linked to the content owner that
     the onBehalfOfContentOwner parameter specifies.

     This parameter is intended for YouTube content partners that own and manage many different YouTube
     channels. It allows content owners to authenticate once and perform actions on behalf of the
     channel specified in the parameter value, without having to provide authentication credentials for
     each separate channel.
       */
      public java.lang.String getOnBehalfOfContentOwnerChannel() {
        return onBehalfOfContentOwnerChannel;
      }

      /**
       * This parameter can only be used in a properly authorized request. Note: This parameter is
       * intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel
       * to which a video is being added. This parameter is required when a request specifies a
       * value for the onBehalfOfContentOwner parameter, and it can only be used in conjunction with
       * that parameter. In addition, the request must be authorized using a CMS account that is
       * linked to the content owner that the onBehalfOfContentOwner parameter specifies. Finally,
       * the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be linked
       * to the content owner that the onBehalfOfContentOwner parameter specifies.
       *
       * This parameter is intended for YouTube content partners that own and manage many different
       * YouTube channels. It allows content owners to authenticate once and perform actions on
       * behalf of the channel specified in the parameter value, without having to provide
       * authentication credentials for each separate channel.
       */
      public Control setOnBehalfOfContentOwnerChannel(java.lang.String onBehalfOfContentOwnerChannel) {
        this.onBehalfOfContentOwnerChannel = onBehalfOfContentOwnerChannel;
        return this;
      }

      /**
       * The offsetTimeMs parameter specifies a positive time offset when the specified slate change
       * will occur. The value is measured in milliseconds from the beginning of the broadcast's
       * monitor stream, which is the time that the testing phase for the broadcast began. Even
       * though it is specified in milliseconds, the value is actually an approximation, and YouTube
       * completes the requested action as closely as possible to that time.
       *
       * If you do not specify a value for this parameter, then YouTube performs the action as soon
       * as possible. See the Getting started guide for more details.
       *
       * Important: You should only specify a value for this parameter if your broadcast stream is
       * delayed.
       */
      @com.google.api.client.util.Key
      private java.math.BigInteger offsetTimeMs;

      /** The offsetTimeMs parameter specifies a positive time offset when the specified slate change will
     occur. The value is measured in milliseconds from the beginning of the broadcast's monitor stream,
     which is the time that the testing phase for the broadcast began. Even though it is specified in
     milliseconds, the value is actually an approximation, and YouTube completes the requested action as
     closely as possible to that time.

     If you do not specify a value for this parameter, then YouTube performs the action as soon as
     possible. See the Getting started guide for more details.

     Important: You should only specify a value for this parameter if your broadcast stream is delayed.
       */
      public java.math.BigInteger getOffsetTimeMs() {
        return offsetTimeMs;
      }

      /**
       * The offsetTimeMs parameter specifies a positive time offset when the specified slate change
       * will occur. The value is measured in milliseconds from the beginning of the broadcast's
       * monitor stream, which is the time that the testing phase for the broadcast began. Even
       * though it is specified in milliseconds, the value is actually an approximation, and YouTube
       * completes the requested action as closely as possible to that time.
       *
       * If you do not specify a value for this parameter, then YouTube performs the action as soon
       * as possible. See the Getting started guide for more details.
       *
       * Important: You should only specify a value for this parameter if your broadcast stream is
       * delayed.
       */
      public Control setOffsetTimeMs(java.math.BigInteger offsetTimeMs) {
        this.offsetTimeMs = offsetTimeMs;
        return this;
      }

      /**
       * The walltime parameter specifies the wall clock time at which the specified slate change
       * will occur. The value is specified in ISO 8601 (YYYY-MM-DDThh:mm:ss.sssZ) format.
       */
      @com.google.api.client.util.Key
      private com.google.api.client.util.DateTime walltime;

      /** The walltime parameter specifies the wall clock time at which the specified slate change will
     occur. The value is specified in ISO 8601 (YYYY-MM-DDThh:mm:ss.sssZ) format.
       */
      public com.google.api.client.util.DateTime getWalltime() {
        return walltime;
      }

      /**
       * The walltime parameter specifies the wall clock time at which the specified slate change
       * will occur. The value is specified in ISO 8601 (YYYY-MM-DDThh:mm:ss.sssZ) format.
       */
      public Control setWalltime(com.google.api.client.util.DateTime walltime) {
        this.walltime = walltime;
        return this;
      }

      @Override
      public Control set(String parameterName, Object value) {
        return (Control) super.set(parameterName, value);
      }
    }
    /**
     * Deletes a broadcast.
     *
     * Create a request for the method "liveBroadcasts.delete".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param id The id parameter specifies the YouTube live broadcast ID for the resource that is being deleted.
     * @return the request
     */
    public Delete delete(java.lang.String id) throws java.io.IOException {
      Delete result = new Delete(id);
      initialize(result);
      return result;
    }

    public class Delete extends YouTubeRequest<Void> {

      private static final String REST_PATH = "liveBroadcasts";

      /**
       * Deletes a broadcast.
       *
       * Create a request for the method "liveBroadcasts.delete".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param id The id parameter specifies the YouTube live broadcast ID for the resource that is being deleted.
       * @since 1.13
       */
      protected Delete(java.lang.String id) {
        super(YouTube.this, "DELETE", REST_PATH, null, Void.class);
        this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /**
       * The id parameter specifies the YouTube live broadcast ID for the resource that is being
       * deleted.
       */
      @com.google.api.client.util.Key
      private java.lang.String id;

      /** The id parameter specifies the YouTube live broadcast ID for the resource that is being deleted.
       */
      public java.lang.String getId() {
        return id;
      }

      /**
       * The id parameter specifies the YouTube live broadcast ID for the resource that is being
       * deleted.
       */
      public Delete setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      /**
       * This parameter can only be used in a properly authorized request. Note: This parameter is
       * intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel
       * to which a video is being added. This parameter is required when a request specifies a
       * value for the onBehalfOfContentOwner parameter, and it can only be used in conjunction with
       * that parameter. In addition, the request must be authorized using a CMS account that is
       * linked to the content owner that the onBehalfOfContentOwner parameter specifies. Finally,
       * the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be linked
       * to the content owner that the onBehalfOfContentOwner parameter specifies.
       *
       * This parameter is intended for YouTube content partners that own and manage many different
       * YouTube channels. It allows content owners to authenticate once and perform actions on
       * behalf of the channel specified in the parameter value, without having to provide
       * authentication credentials for each separate channel.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwnerChannel;

      /** This parameter can only be used in a properly authorized request. Note: This parameter is intended
     exclusively for YouTube content partners.

     The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel to
     which a video is being added. This parameter is required when a request specifies a value for the
     onBehalfOfContentOwner parameter, and it can only be used in conjunction with that parameter. In
     addition, the request must be authorized using a CMS account that is linked to the content owner
     that the onBehalfOfContentOwner parameter specifies. Finally, the channel that the
     onBehalfOfContentOwnerChannel parameter value specifies must be linked to the content owner that
     the onBehalfOfContentOwner parameter specifies.

     This parameter is intended for YouTube content partners that own and manage many different YouTube
     channels. It allows content owners to authenticate once and perform actions on behalf of the
     channel specified in the parameter value, without having to provide authentication credentials for
     each separate channel.
       */
      public java.lang.String getOnBehalfOfContentOwnerChannel() {
        return onBehalfOfContentOwnerChannel;
      }

      /**
       * This parameter can only be used in a properly authorized request. Note: This parameter is
       * intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel
       * to which a video is being added. This parameter is required when a request specifies a
       * value for the onBehalfOfContentOwner parameter, and it can only be used in conjunction with
       * that parameter. In addition, the request must be authorized using a CMS account that is
       * linked to the content owner that the onBehalfOfContentOwner parameter specifies. Finally,
       * the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be linked
       * to the content owner that the onBehalfOfContentOwner parameter specifies.
       *
       * This parameter is intended for YouTube content partners that own and manage many different
       * YouTube channels. It allows content owners to authenticate once and perform actions on
       * behalf of the channel specified in the parameter value, without having to provide
       * authentication credentials for each separate channel.
       */
      public Delete setOnBehalfOfContentOwnerChannel(java.lang.String onBehalfOfContentOwnerChannel) {
        this.onBehalfOfContentOwnerChannel = onBehalfOfContentOwnerChannel;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The CMS account that the user authenticates with must be linked to the specified YouTube content
     owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public Delete setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Creates a broadcast.
     *
     * Create a request for the method "liveBroadcasts.insert".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
    The
     *        part properties that you can include in the parameter value are id, snippet,
     *        contentDetails, and status.
     * @param content the {@link com.google.api.services.youtube.model.LiveBroadcast}
     * @return the request
     */
    public Insert insert(java.lang.String part, com.google.api.services.youtube.model.LiveBroadcast content) throws java.io.IOException {
      Insert result = new Insert(part, content);
      initialize(result);
      return result;
    }

    public class Insert extends YouTubeRequest<com.google.api.services.youtube.model.LiveBroadcast> {

      private static final String REST_PATH = "liveBroadcasts";

      /**
       * Creates a broadcast.
       *
       * Create a request for the method "liveBroadcasts.insert".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
    The
     *        part properties that you can include in the parameter value are id, snippet,
     *        contentDetails, and status.
       * @param content the {@link com.google.api.services.youtube.model.LiveBroadcast}
       * @since 1.13
       */
      protected Insert(java.lang.String part, com.google.api.services.youtube.model.LiveBroadcast content) {
        super(YouTube.this, "POST", REST_PATH, content, com.google.api.services.youtube.model.LiveBroadcast.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /**
       * The part parameter serves two purposes in this operation. It identifies the properties that
       * the write operation will set as well as the properties that the API response will include.
       *
       * The part properties that you can include in the parameter value are id, snippet,
       * contentDetails, and status.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter serves two purposes in this operation. It identifies the properties that the
     write operation will set as well as the properties that the API response will include.

     The part properties that you can include in the parameter value are id, snippet, contentDetails,
     and status.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter serves two purposes in this operation. It identifies the properties that
       * the write operation will set as well as the properties that the API response will include.
       *
       * The part properties that you can include in the parameter value are id, snippet,
       * contentDetails, and status.
       */
      public Insert setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      /**
       * This parameter can only be used in a properly authorized request. Note: This parameter is
       * intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel
       * to which a video is being added. This parameter is required when a request specifies a
       * value for the onBehalfOfContentOwner parameter, and it can only be used in conjunction with
       * that parameter. In addition, the request must be authorized using a CMS account that is
       * linked to the content owner that the onBehalfOfContentOwner parameter specifies. Finally,
       * the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be linked
       * to the content owner that the onBehalfOfContentOwner parameter specifies.
       *
       * This parameter is intended for YouTube content partners that own and manage many different
       * YouTube channels. It allows content owners to authenticate once and perform actions on
       * behalf of the channel specified in the parameter value, without having to provide
       * authentication credentials for each separate channel.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwnerChannel;

      /** This parameter can only be used in a properly authorized request. Note: This parameter is intended
     exclusively for YouTube content partners.

     The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel to
     which a video is being added. This parameter is required when a request specifies a value for the
     onBehalfOfContentOwner parameter, and it can only be used in conjunction with that parameter. In
     addition, the request must be authorized using a CMS account that is linked to the content owner
     that the onBehalfOfContentOwner parameter specifies. Finally, the channel that the
     onBehalfOfContentOwnerChannel parameter value specifies must be linked to the content owner that
     the onBehalfOfContentOwner parameter specifies.

     This parameter is intended for YouTube content partners that own and manage many different YouTube
     channels. It allows content owners to authenticate once and perform actions on behalf of the
     channel specified in the parameter value, without having to provide authentication credentials for
     each separate channel.
       */
      public java.lang.String getOnBehalfOfContentOwnerChannel() {
        return onBehalfOfContentOwnerChannel;
      }

      /**
       * This parameter can only be used in a properly authorized request. Note: This parameter is
       * intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel
       * to which a video is being added. This parameter is required when a request specifies a
       * value for the onBehalfOfContentOwner parameter, and it can only be used in conjunction with
       * that parameter. In addition, the request must be authorized using a CMS account that is
       * linked to the content owner that the onBehalfOfContentOwner parameter specifies. Finally,
       * the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be linked
       * to the content owner that the onBehalfOfContentOwner parameter specifies.
       *
       * This parameter is intended for YouTube content partners that own and manage many different
       * YouTube channels. It allows content owners to authenticate once and perform actions on
       * behalf of the channel specified in the parameter value, without having to provide
       * authentication credentials for each separate channel.
       */
      public Insert setOnBehalfOfContentOwnerChannel(java.lang.String onBehalfOfContentOwnerChannel) {
        this.onBehalfOfContentOwnerChannel = onBehalfOfContentOwnerChannel;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The CMS account that the user authenticates with must be linked to the specified YouTube content
     owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public Insert setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Returns a list of YouTube broadcasts that match the API request parameters.
     *
     * Create a request for the method "liveBroadcasts.list".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter specifies a comma-separated list of one or more liveBroadcast resource properties
     *        that the API response will include. The part names that you can include in the parameter
     *        value are id, snippet, contentDetails, and status.
     * @return the request
     */
    public List list(java.lang.String part) throws java.io.IOException {
      List result = new List(part);
      initialize(result);
      return result;
    }

    public class List extends YouTubeRequest<com.google.api.services.youtube.model.LiveBroadcastListResponse> {

      private static final String REST_PATH = "liveBroadcasts";

      /**
       * Returns a list of YouTube broadcasts that match the API request parameters.
       *
       * Create a request for the method "liveBroadcasts.list".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter specifies a comma-separated list of one or more liveBroadcast resource properties
     *        that the API response will include. The part names that you can include in the parameter
     *        value are id, snippet, contentDetails, and status.
       * @since 1.13
       */
      protected List(java.lang.String part) {
        super(YouTube.this, "GET", REST_PATH, null, com.google.api.services.youtube.model.LiveBroadcastListResponse.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /**
       * The part parameter specifies a comma-separated list of one or more liveBroadcast resource
       * properties that the API response will include. The part names that you can include in the
       * parameter value are id, snippet, contentDetails, and status.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter specifies a comma-separated list of one or more liveBroadcast resource
     properties that the API response will include. The part names that you can include in the parameter
     value are id, snippet, contentDetails, and status.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter specifies a comma-separated list of one or more liveBroadcast resource
       * properties that the API response will include. The part names that you can include in the
       * parameter value are id, snippet, contentDetails, and status.
       */
      public List setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      /**
       * The broadcastStatus parameter filters the API response to only include broadcasts with the
       * specified status.
       */
      @com.google.api.client.util.Key
      private java.lang.String broadcastStatus;

      /** The broadcastStatus parameter filters the API response to only include broadcasts with the
     specified status.
       */
      public java.lang.String getBroadcastStatus() {
        return broadcastStatus;
      }

      /**
       * The broadcastStatus parameter filters the API response to only include broadcasts with the
       * specified status.
       */
      public List setBroadcastStatus(java.lang.String broadcastStatus) {
        this.broadcastStatus = broadcastStatus;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The CMS account that the user authenticates with must be linked to the specified YouTube content
     owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public List setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      /**
       * This parameter can only be used in a properly authorized request. Note: This parameter is
       * intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel
       * to which a video is being added. This parameter is required when a request specifies a
       * value for the onBehalfOfContentOwner parameter, and it can only be used in conjunction with
       * that parameter. In addition, the request must be authorized using a CMS account that is
       * linked to the content owner that the onBehalfOfContentOwner parameter specifies. Finally,
       * the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be linked
       * to the content owner that the onBehalfOfContentOwner parameter specifies.
       *
       * This parameter is intended for YouTube content partners that own and manage many different
       * YouTube channels. It allows content owners to authenticate once and perform actions on
       * behalf of the channel specified in the parameter value, without having to provide
       * authentication credentials for each separate channel.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwnerChannel;

      /** This parameter can only be used in a properly authorized request. Note: This parameter is intended
     exclusively for YouTube content partners.

     The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel to
     which a video is being added. This parameter is required when a request specifies a value for the
     onBehalfOfContentOwner parameter, and it can only be used in conjunction with that parameter. In
     addition, the request must be authorized using a CMS account that is linked to the content owner
     that the onBehalfOfContentOwner parameter specifies. Finally, the channel that the
     onBehalfOfContentOwnerChannel parameter value specifies must be linked to the content owner that
     the onBehalfOfContentOwner parameter specifies.

     This parameter is intended for YouTube content partners that own and manage many different YouTube
     channels. It allows content owners to authenticate once and perform actions on behalf of the
     channel specified in the parameter value, without having to provide authentication credentials for
     each separate channel.
       */
      public java.lang.String getOnBehalfOfContentOwnerChannel() {
        return onBehalfOfContentOwnerChannel;
      }

      /**
       * This parameter can only be used in a properly authorized request. Note: This parameter is
       * intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel
       * to which a video is being added. This parameter is required when a request specifies a
       * value for the onBehalfOfContentOwner parameter, and it can only be used in conjunction with
       * that parameter. In addition, the request must be authorized using a CMS account that is
       * linked to the content owner that the onBehalfOfContentOwner parameter specifies. Finally,
       * the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be linked
       * to the content owner that the onBehalfOfContentOwner parameter specifies.
       *
       * This parameter is intended for YouTube content partners that own and manage many different
       * YouTube channels. It allows content owners to authenticate once and perform actions on
       * behalf of the channel specified in the parameter value, without having to provide
       * authentication credentials for each separate channel.
       */
      public List setOnBehalfOfContentOwnerChannel(java.lang.String onBehalfOfContentOwnerChannel) {
        this.onBehalfOfContentOwnerChannel = onBehalfOfContentOwnerChannel;
        return this;
      }

      /**
       * The mine parameter can be used to instruct the API to only return broadcasts owned by the
       * authenticated user. Set the parameter value to true to only retrieve your own broadcasts.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean mine;

      /** The mine parameter can be used to instruct the API to only return broadcasts owned by the
     authenticated user. Set the parameter value to true to only retrieve your own broadcasts.
       */
      public java.lang.Boolean getMine() {
        return mine;
      }

      /**
       * The mine parameter can be used to instruct the API to only return broadcasts owned by the
       * authenticated user. Set the parameter value to true to only retrieve your own broadcasts.
       */
      public List setMine(java.lang.Boolean mine) {
        this.mine = mine;
        return this;
      }

      /**
       * The maxResults parameter specifies the maximum number of items that should be returned in
       * the result set.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maxResults parameter specifies the maximum number of items that should be returned in the
     result set. [default: 5] [minimum: 0] [maximum: 50]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maxResults parameter specifies the maximum number of items that should be returned in
       * the result set.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * The pageToken parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The pageToken parameter identifies a specific page in the result set that should be returned. In an
     API response, the nextPageToken and prevPageToken properties identify other pages that could be
     retrieved.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * The pageToken parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * The id parameter specifies a comma-separated list of YouTube broadcast IDs that identify
       * the broadcasts being retrieved. In a liveBroadcast resource, the id property specifies the
       * broadcast's ID.
       */
      @com.google.api.client.util.Key
      private java.lang.String id;

      /** The id parameter specifies a comma-separated list of YouTube broadcast IDs that identify the
     broadcasts being retrieved. In a liveBroadcast resource, the id property specifies the broadcast's
     ID.
       */
      public java.lang.String getId() {
        return id;
      }

      /**
       * The id parameter specifies a comma-separated list of YouTube broadcast IDs that identify
       * the broadcasts being retrieved. In a liveBroadcast resource, the id property specifies the
       * broadcast's ID.
       */
      public List setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Changes the status of a YouTube live broadcast and initiates any processes associated with the
     * new status. For example, when you transition a broadcast's status to testing, YouTube starts to
     * transmit video to that broadcast's monitor stream. Before calling this method, you should confirm
     * that the value of the status.streamStatus property for the stream bound to your broadcast is
     * active.
     *
     * Create a request for the method "liveBroadcasts.transition".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Transition#execute()} method to invoke the remote operation.
     *
     * @param broadcastStatus The broadcastStatus parameter identifies the state to which the broadcast is changing. Note that to
     *        transition a broadcast to either the testing or live state, the status.streamStatus must
     *        be active for the stream that the broadcast is bound to.
     * @param id The id parameter specifies the unique ID of the broadcast that is transitioning to another status.
     * @param part The part parameter specifies a comma-separated list of one or more liveBroadcast resource properties
     *        that the API response will include. The part names that you can include in the parameter
     *        value are id, snippet, contentDetails, and status.
     * @return the request
     */
    public Transition transition(java.lang.String broadcastStatus, java.lang.String id, java.lang.String part) throws java.io.IOException {
      Transition result = new Transition(broadcastStatus, id, part);
      initialize(result);
      return result;
    }

    public class Transition extends YouTubeRequest<com.google.api.services.youtube.model.LiveBroadcast> {

      private static final String REST_PATH = "liveBroadcasts/transition";

      /**
       * Changes the status of a YouTube live broadcast and initiates any processes associated with the
       * new status. For example, when you transition a broadcast's status to testing, YouTube starts to
       * transmit video to that broadcast's monitor stream. Before calling this method, you should
       * confirm that the value of the status.streamStatus property for the stream bound to your
       * broadcast is active.
       *
       * Create a request for the method "liveBroadcasts.transition".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Transition#execute()} method to invoke the remote operation. <p>
       * {@link
       * Transition#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param broadcastStatus The broadcastStatus parameter identifies the state to which the broadcast is changing. Note that to
     *        transition a broadcast to either the testing or live state, the status.streamStatus must
     *        be active for the stream that the broadcast is bound to.
       * @param id The id parameter specifies the unique ID of the broadcast that is transitioning to another status.
       * @param part The part parameter specifies a comma-separated list of one or more liveBroadcast resource properties
     *        that the API response will include. The part names that you can include in the parameter
     *        value are id, snippet, contentDetails, and status.
       * @since 1.13
       */
      protected Transition(java.lang.String broadcastStatus, java.lang.String id, java.lang.String part) {
        super(YouTube.this, "POST", REST_PATH, null, com.google.api.services.youtube.model.LiveBroadcast.class);
        this.broadcastStatus = com.google.api.client.util.Preconditions.checkNotNull(broadcastStatus, "Required parameter broadcastStatus must be specified.");
        this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public Transition setAlt(java.lang.String alt) {
        return (Transition) super.setAlt(alt);
      }

      @Override
      public Transition setFields(java.lang.String fields) {
        return (Transition) super.setFields(fields);
      }

      @Override
      public Transition setKey(java.lang.String key) {
        return (Transition) super.setKey(key);
      }

      @Override
      public Transition setOauthToken(java.lang.String oauthToken) {
        return (Transition) super.setOauthToken(oauthToken);
      }

      @Override
      public Transition setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Transition) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Transition setQuotaUser(java.lang.String quotaUser) {
        return (Transition) super.setQuotaUser(quotaUser);
      }

      @Override
      public Transition setUserIp(java.lang.String userIp) {
        return (Transition) super.setUserIp(userIp);
      }

      /**
       * The broadcastStatus parameter identifies the state to which the broadcast is changing. Note
       * that to transition a broadcast to either the testing or live state, the status.streamStatus
       * must be active for the stream that the broadcast is bound to.
       */
      @com.google.api.client.util.Key
      private java.lang.String broadcastStatus;

      /** The broadcastStatus parameter identifies the state to which the broadcast is changing. Note that to
     transition a broadcast to either the testing or live state, the status.streamStatus must be active
     for the stream that the broadcast is bound to.
       */
      public java.lang.String getBroadcastStatus() {
        return broadcastStatus;
      }

      /**
       * The broadcastStatus parameter identifies the state to which the broadcast is changing. Note
       * that to transition a broadcast to either the testing or live state, the status.streamStatus
       * must be active for the stream that the broadcast is bound to.
       */
      public Transition setBroadcastStatus(java.lang.String broadcastStatus) {
        this.broadcastStatus = broadcastStatus;
        return this;
      }

      /**
       * The id parameter specifies the unique ID of the broadcast that is transitioning to another
       * status.
       */
      @com.google.api.client.util.Key
      private java.lang.String id;

      /** The id parameter specifies the unique ID of the broadcast that is transitioning to another status.
       */
      public java.lang.String getId() {
        return id;
      }

      /**
       * The id parameter specifies the unique ID of the broadcast that is transitioning to another
       * status.
       */
      public Transition setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      /**
       * The part parameter specifies a comma-separated list of one or more liveBroadcast resource
       * properties that the API response will include. The part names that you can include in the
       * parameter value are id, snippet, contentDetails, and status.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter specifies a comma-separated list of one or more liveBroadcast resource
     properties that the API response will include. The part names that you can include in the parameter
     value are id, snippet, contentDetails, and status.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter specifies a comma-separated list of one or more liveBroadcast resource
       * properties that the API response will include. The part names that you can include in the
       * parameter value are id, snippet, contentDetails, and status.
       */
      public Transition setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      /**
       * This parameter can only be used in a properly authorized request. Note: This parameter is
       * intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel
       * to which a video is being added. This parameter is required when a request specifies a
       * value for the onBehalfOfContentOwner parameter, and it can only be used in conjunction with
       * that parameter. In addition, the request must be authorized using a CMS account that is
       * linked to the content owner that the onBehalfOfContentOwner parameter specifies. Finally,
       * the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be linked
       * to the content owner that the onBehalfOfContentOwner parameter specifies.
       *
       * This parameter is intended for YouTube content partners that own and manage many different
       * YouTube channels. It allows content owners to authenticate once and perform actions on
       * behalf of the channel specified in the parameter value, without having to provide
       * authentication credentials for each separate channel.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwnerChannel;

      /** This parameter can only be used in a properly authorized request. Note: This parameter is intended
     exclusively for YouTube content partners.

     The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel to
     which a video is being added. This parameter is required when a request specifies a value for the
     onBehalfOfContentOwner parameter, and it can only be used in conjunction with that parameter. In
     addition, the request must be authorized using a CMS account that is linked to the content owner
     that the onBehalfOfContentOwner parameter specifies. Finally, the channel that the
     onBehalfOfContentOwnerChannel parameter value specifies must be linked to the content owner that
     the onBehalfOfContentOwner parameter specifies.

     This parameter is intended for YouTube content partners that own and manage many different YouTube
     channels. It allows content owners to authenticate once and perform actions on behalf of the
     channel specified in the parameter value, without having to provide authentication credentials for
     each separate channel.
       */
      public java.lang.String getOnBehalfOfContentOwnerChannel() {
        return onBehalfOfContentOwnerChannel;
      }

      /**
       * This parameter can only be used in a properly authorized request. Note: This parameter is
       * intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel
       * to which a video is being added. This parameter is required when a request specifies a
       * value for the onBehalfOfContentOwner parameter, and it can only be used in conjunction with
       * that parameter. In addition, the request must be authorized using a CMS account that is
       * linked to the content owner that the onBehalfOfContentOwner parameter specifies. Finally,
       * the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be linked
       * to the content owner that the onBehalfOfContentOwner parameter specifies.
       *
       * This parameter is intended for YouTube content partners that own and manage many different
       * YouTube channels. It allows content owners to authenticate once and perform actions on
       * behalf of the channel specified in the parameter value, without having to provide
       * authentication credentials for each separate channel.
       */
      public Transition setOnBehalfOfContentOwnerChannel(java.lang.String onBehalfOfContentOwnerChannel) {
        this.onBehalfOfContentOwnerChannel = onBehalfOfContentOwnerChannel;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The CMS account that the user authenticates with must be linked to the specified YouTube content
     owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public Transition setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      @Override
      public Transition set(String parameterName, Object value) {
        return (Transition) super.set(parameterName, value);
      }
    }
    /**
     * Updates a broadcast. For example, you could modify the broadcast settings defined in the
     * liveBroadcast resource's contentDetails object.
     *
     * Create a request for the method "liveBroadcasts.update".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
    The
     *        part properties that you can include in the parameter value are id, snippet,
     *        contentDetails, and status.
    Note that this method will override the existing values for
     *        all of the mutable properties that are contained in any parts that the parameter value
     *        specifies. For example, a broadcast's privacy status is defined in the status part. As
     *        such, if your request is updating a private or unlisted broadcast, and the request's part
     *        parameter value includes the status part, the broadcast's privacy setting will be updated
     *        to whatever value the request body specifies. If the request body does not specify a
     *        value, the existing privacy setting will be removed and the broadcast will revert to the
     *        default privacy setting.
     * @param content the {@link com.google.api.services.youtube.model.LiveBroadcast}
     * @return the request
     */
    public Update update(java.lang.String part, com.google.api.services.youtube.model.LiveBroadcast content) throws java.io.IOException {
      Update result = new Update(part, content);
      initialize(result);
      return result;
    }

    public class Update extends YouTubeRequest<com.google.api.services.youtube.model.LiveBroadcast> {

      private static final String REST_PATH = "liveBroadcasts";

      /**
       * Updates a broadcast. For example, you could modify the broadcast settings defined in the
       * liveBroadcast resource's contentDetails object.
       *
       * Create a request for the method "liveBroadcasts.update".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
    The
     *        part properties that you can include in the parameter value are id, snippet,
     *        contentDetails, and status.
    Note that this method will override the existing values for
     *        all of the mutable properties that are contained in any parts that the parameter value
     *        specifies. For example, a broadcast's privacy status is defined in the status part. As
     *        such, if your request is updating a private or unlisted broadcast, and the request's part
     *        parameter value includes the status part, the broadcast's privacy setting will be updated
     *        to whatever value the request body specifies. If the request body does not specify a
     *        value, the existing privacy setting will be removed and the broadcast will revert to the
     *        default privacy setting.
       * @param content the {@link com.google.api.services.youtube.model.LiveBroadcast}
       * @since 1.13
       */
      protected Update(java.lang.String part, com.google.api.services.youtube.model.LiveBroadcast content) {
        super(YouTube.this, "PUT", REST_PATH, content, com.google.api.services.youtube.model.LiveBroadcast.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
        checkRequiredParameter(content, "content");
        checkRequiredParameter(content.getId(), "LiveBroadcast.getId()");
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /**
       * The part parameter serves two purposes in this operation. It identifies the properties that
       * the write operation will set as well as the properties that the API response will include.
       *
       * The part properties that you can include in the parameter value are id, snippet,
       * contentDetails, and status.
       *
       * Note that this method will override the existing values for all of the mutable properties
       * that are contained in any parts that the parameter value specifies. For example, a
       * broadcast's privacy status is defined in the status part. As such, if your request is
       * updating a private or unlisted broadcast, and the request's part parameter value includes
       * the status part, the broadcast's privacy setting will be updated to whatever value the
       * request body specifies. If the request body does not specify a value, the existing privacy
       * setting will be removed and the broadcast will revert to the default privacy setting.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter serves two purposes in this operation. It identifies the properties that the
     write operation will set as well as the properties that the API response will include.

     The part properties that you can include in the parameter value are id, snippet, contentDetails,
     and status.

     Note that this method will override the existing values for all of the mutable properties that are
     contained in any parts that the parameter value specifies. For example, a broadcast's privacy
     status is defined in the status part. As such, if your request is updating a private or unlisted
     broadcast, and the request's part parameter value includes the status part, the broadcast's privacy
     setting will be updated to whatever value the request body specifies. If the request body does not
     specify a value, the existing privacy setting will be removed and the broadcast will revert to the
     default privacy setting.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter serves two purposes in this operation. It identifies the properties that
       * the write operation will set as well as the properties that the API response will include.
       *
       * The part properties that you can include in the parameter value are id, snippet,
       * contentDetails, and status.
       *
       * Note that this method will override the existing values for all of the mutable properties
       * that are contained in any parts that the parameter value specifies. For example, a
       * broadcast's privacy status is defined in the status part. As such, if your request is
       * updating a private or unlisted broadcast, and the request's part parameter value includes
       * the status part, the broadcast's privacy setting will be updated to whatever value the
       * request body specifies. If the request body does not specify a value, the existing privacy
       * setting will be removed and the broadcast will revert to the default privacy setting.
       */
      public Update setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      /**
       * This parameter can only be used in a properly authorized request. Note: This parameter is
       * intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel
       * to which a video is being added. This parameter is required when a request specifies a
       * value for the onBehalfOfContentOwner parameter, and it can only be used in conjunction with
       * that parameter. In addition, the request must be authorized using a CMS account that is
       * linked to the content owner that the onBehalfOfContentOwner parameter specifies. Finally,
       * the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be linked
       * to the content owner that the onBehalfOfContentOwner parameter specifies.
       *
       * This parameter is intended for YouTube content partners that own and manage many different
       * YouTube channels. It allows content owners to authenticate once and perform actions on
       * behalf of the channel specified in the parameter value, without having to provide
       * authentication credentials for each separate channel.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwnerChannel;

      /** This parameter can only be used in a properly authorized request. Note: This parameter is intended
     exclusively for YouTube content partners.

     The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel to
     which a video is being added. This parameter is required when a request specifies a value for the
     onBehalfOfContentOwner parameter, and it can only be used in conjunction with that parameter. In
     addition, the request must be authorized using a CMS account that is linked to the content owner
     that the onBehalfOfContentOwner parameter specifies. Finally, the channel that the
     onBehalfOfContentOwnerChannel parameter value specifies must be linked to the content owner that
     the onBehalfOfContentOwner parameter specifies.

     This parameter is intended for YouTube content partners that own and manage many different YouTube
     channels. It allows content owners to authenticate once and perform actions on behalf of the
     channel specified in the parameter value, without having to provide authentication credentials for
     each separate channel.
       */
      public java.lang.String getOnBehalfOfContentOwnerChannel() {
        return onBehalfOfContentOwnerChannel;
      }

      /**
       * This parameter can only be used in a properly authorized request. Note: This parameter is
       * intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel
       * to which a video is being added. This parameter is required when a request specifies a
       * value for the onBehalfOfContentOwner parameter, and it can only be used in conjunction with
       * that parameter. In addition, the request must be authorized using a CMS account that is
       * linked to the content owner that the onBehalfOfContentOwner parameter specifies. Finally,
       * the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be linked
       * to the content owner that the onBehalfOfContentOwner parameter specifies.
       *
       * This parameter is intended for YouTube content partners that own and manage many different
       * YouTube channels. It allows content owners to authenticate once and perform actions on
       * behalf of the channel specified in the parameter value, without having to provide
       * authentication credentials for each separate channel.
       */
      public Update setOnBehalfOfContentOwnerChannel(java.lang.String onBehalfOfContentOwnerChannel) {
        this.onBehalfOfContentOwnerChannel = onBehalfOfContentOwnerChannel;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The CMS account that the user authenticates with must be linked to the specified YouTube content
     owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public Update setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the LiveStreams collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.LiveStreams.List request = youtube.liveStreams().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public LiveStreams liveStreams() {
    return new LiveStreams();
  }

  /**
   * The "liveStreams" collection of methods.
   */
  public class LiveStreams {

    /**
     * Deletes a video stream.
     *
     * Create a request for the method "liveStreams.delete".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param id The id parameter specifies the YouTube live stream ID for the resource that is being deleted.
     * @return the request
     */
    public Delete delete(java.lang.String id) throws java.io.IOException {
      Delete result = new Delete(id);
      initialize(result);
      return result;
    }

    public class Delete extends YouTubeRequest<Void> {

      private static final String REST_PATH = "liveStreams";

      /**
       * Deletes a video stream.
       *
       * Create a request for the method "liveStreams.delete".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param id The id parameter specifies the YouTube live stream ID for the resource that is being deleted.
       * @since 1.13
       */
      protected Delete(java.lang.String id) {
        super(YouTube.this, "DELETE", REST_PATH, null, Void.class);
        this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /**
       * The id parameter specifies the YouTube live stream ID for the resource that is being
       * deleted.
       */
      @com.google.api.client.util.Key
      private java.lang.String id;

      /** The id parameter specifies the YouTube live stream ID for the resource that is being deleted.
       */
      public java.lang.String getId() {
        return id;
      }

      /**
       * The id parameter specifies the YouTube live stream ID for the resource that is being
       * deleted.
       */
      public Delete setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      /**
       * This parameter can only be used in a properly authorized request. Note: This parameter is
       * intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel
       * to which a video is being added. This parameter is required when a request specifies a
       * value for the onBehalfOfContentOwner parameter, and it can only be used in conjunction with
       * that parameter. In addition, the request must be authorized using a CMS account that is
       * linked to the content owner that the onBehalfOfContentOwner parameter specifies. Finally,
       * the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be linked
       * to the content owner that the onBehalfOfContentOwner parameter specifies.
       *
       * This parameter is intended for YouTube content partners that own and manage many different
       * YouTube channels. It allows content owners to authenticate once and perform actions on
       * behalf of the channel specified in the parameter value, without having to provide
       * authentication credentials for each separate channel.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwnerChannel;

      /** This parameter can only be used in a properly authorized request. Note: This parameter is intended
     exclusively for YouTube content partners.

     The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel to
     which a video is being added. This parameter is required when a request specifies a value for the
     onBehalfOfContentOwner parameter, and it can only be used in conjunction with that parameter. In
     addition, the request must be authorized using a CMS account that is linked to the content owner
     that the onBehalfOfContentOwner parameter specifies. Finally, the channel that the
     onBehalfOfContentOwnerChannel parameter value specifies must be linked to the content owner that
     the onBehalfOfContentOwner parameter specifies.

     This parameter is intended for YouTube content partners that own and manage many different YouTube
     channels. It allows content owners to authenticate once and perform actions on behalf of the
     channel specified in the parameter value, without having to provide authentication credentials for
     each separate channel.
       */
      public java.lang.String getOnBehalfOfContentOwnerChannel() {
        return onBehalfOfContentOwnerChannel;
      }

      /**
       * This parameter can only be used in a properly authorized request. Note: This parameter is
       * intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel
       * to which a video is being added. This parameter is required when a request specifies a
       * value for the onBehalfOfContentOwner parameter, and it can only be used in conjunction with
       * that parameter. In addition, the request must be authorized using a CMS account that is
       * linked to the content owner that the onBehalfOfContentOwner parameter specifies. Finally,
       * the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be linked
       * to the content owner that the onBehalfOfContentOwner parameter specifies.
       *
       * This parameter is intended for YouTube content partners that own and manage many different
       * YouTube channels. It allows content owners to authenticate once and perform actions on
       * behalf of the channel specified in the parameter value, without having to provide
       * authentication credentials for each separate channel.
       */
      public Delete setOnBehalfOfContentOwnerChannel(java.lang.String onBehalfOfContentOwnerChannel) {
        this.onBehalfOfContentOwnerChannel = onBehalfOfContentOwnerChannel;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The CMS account that the user authenticates with must be linked to the specified YouTube content
     owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public Delete setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Creates a video stream. The stream enables you to send your video to YouTube, which can then
     * broadcast the video to your audience.
     *
     * Create a request for the method "liveStreams.insert".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
    The
     *        part properties that you can include in the parameter value are id, snippet, cdn, and
     *        status.
     * @param content the {@link com.google.api.services.youtube.model.LiveStream}
     * @return the request
     */
    public Insert insert(java.lang.String part, com.google.api.services.youtube.model.LiveStream content) throws java.io.IOException {
      Insert result = new Insert(part, content);
      initialize(result);
      return result;
    }

    public class Insert extends YouTubeRequest<com.google.api.services.youtube.model.LiveStream> {

      private static final String REST_PATH = "liveStreams";

      /**
       * Creates a video stream. The stream enables you to send your video to YouTube, which can then
       * broadcast the video to your audience.
       *
       * Create a request for the method "liveStreams.insert".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
    The
     *        part properties that you can include in the parameter value are id, snippet, cdn, and
     *        status.
       * @param content the {@link com.google.api.services.youtube.model.LiveStream}
       * @since 1.13
       */
      protected Insert(java.lang.String part, com.google.api.services.youtube.model.LiveStream content) {
        super(YouTube.this, "POST", REST_PATH, content, com.google.api.services.youtube.model.LiveStream.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /**
       * The part parameter serves two purposes in this operation. It identifies the properties that
       * the write operation will set as well as the properties that the API response will include.
       *
       * The part properties that you can include in the parameter value are id, snippet, cdn, and
       * status.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter serves two purposes in this operation. It identifies the properties that the
     write operation will set as well as the properties that the API response will include.

     The part properties that you can include in the parameter value are id, snippet, cdn, and status.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter serves two purposes in this operation. It identifies the properties that
       * the write operation will set as well as the properties that the API response will include.
       *
       * The part properties that you can include in the parameter value are id, snippet, cdn, and
       * status.
       */
      public Insert setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      /**
       * This parameter can only be used in a properly authorized request. Note: This parameter is
       * intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel
       * to which a video is being added. This parameter is required when a request specifies a
       * value for the onBehalfOfContentOwner parameter, and it can only be used in conjunction with
       * that parameter. In addition, the request must be authorized using a CMS account that is
       * linked to the content owner that the onBehalfOfContentOwner parameter specifies. Finally,
       * the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be linked
       * to the content owner that the onBehalfOfContentOwner parameter specifies.
       *
       * This parameter is intended for YouTube content partners that own and manage many different
       * YouTube channels. It allows content owners to authenticate once and perform actions on
       * behalf of the channel specified in the parameter value, without having to provide
       * authentication credentials for each separate channel.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwnerChannel;

      /** This parameter can only be used in a properly authorized request. Note: This parameter is intended
     exclusively for YouTube content partners.

     The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel to
     which a video is being added. This parameter is required when a request specifies a value for the
     onBehalfOfContentOwner parameter, and it can only be used in conjunction with that parameter. In
     addition, the request must be authorized using a CMS account that is linked to the content owner
     that the onBehalfOfContentOwner parameter specifies. Finally, the channel that the
     onBehalfOfContentOwnerChannel parameter value specifies must be linked to the content owner that
     the onBehalfOfContentOwner parameter specifies.

     This parameter is intended for YouTube content partners that own and manage many different YouTube
     channels. It allows content owners to authenticate once and perform actions on behalf of the
     channel specified in the parameter value, without having to provide authentication credentials for
     each separate channel.
       */
      public java.lang.String getOnBehalfOfContentOwnerChannel() {
        return onBehalfOfContentOwnerChannel;
      }

      /**
       * This parameter can only be used in a properly authorized request. Note: This parameter is
       * intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel
       * to which a video is being added. This parameter is required when a request specifies a
       * value for the onBehalfOfContentOwner parameter, and it can only be used in conjunction with
       * that parameter. In addition, the request must be authorized using a CMS account that is
       * linked to the content owner that the onBehalfOfContentOwner parameter specifies. Finally,
       * the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be linked
       * to the content owner that the onBehalfOfContentOwner parameter specifies.
       *
       * This parameter is intended for YouTube content partners that own and manage many different
       * YouTube channels. It allows content owners to authenticate once and perform actions on
       * behalf of the channel specified in the parameter value, without having to provide
       * authentication credentials for each separate channel.
       */
      public Insert setOnBehalfOfContentOwnerChannel(java.lang.String onBehalfOfContentOwnerChannel) {
        this.onBehalfOfContentOwnerChannel = onBehalfOfContentOwnerChannel;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The CMS account that the user authenticates with must be linked to the specified YouTube content
     owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public Insert setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Returns a list of video streams that match the API request parameters.
     *
     * Create a request for the method "liveStreams.list".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter specifies a comma-separated list of one or more liveStream resource properties
     *        that the API response will include. The part names that you can include in the parameter
     *        value are id, snippet, cdn, and status.
     * @return the request
     */
    public List list(java.lang.String part) throws java.io.IOException {
      List result = new List(part);
      initialize(result);
      return result;
    }

    public class List extends YouTubeRequest<com.google.api.services.youtube.model.LiveStreamListResponse> {

      private static final String REST_PATH = "liveStreams";

      /**
       * Returns a list of video streams that match the API request parameters.
       *
       * Create a request for the method "liveStreams.list".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter specifies a comma-separated list of one or more liveStream resource properties
     *        that the API response will include. The part names that you can include in the parameter
     *        value are id, snippet, cdn, and status.
       * @since 1.13
       */
      protected List(java.lang.String part) {
        super(YouTube.this, "GET", REST_PATH, null, com.google.api.services.youtube.model.LiveStreamListResponse.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /**
       * The part parameter specifies a comma-separated list of one or more liveStream resource
       * properties that the API response will include. The part names that you can include in the
       * parameter value are id, snippet, cdn, and status.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter specifies a comma-separated list of one or more liveStream resource properties
     that the API response will include. The part names that you can include in the parameter value are
     id, snippet, cdn, and status.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter specifies a comma-separated list of one or more liveStream resource
       * properties that the API response will include. The part names that you can include in the
       * parameter value are id, snippet, cdn, and status.
       */
      public List setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The CMS account that the user authenticates with must be linked to the specified YouTube content
     owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public List setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      /**
       * This parameter can only be used in a properly authorized request. Note: This parameter is
       * intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel
       * to which a video is being added. This parameter is required when a request specifies a
       * value for the onBehalfOfContentOwner parameter, and it can only be used in conjunction with
       * that parameter. In addition, the request must be authorized using a CMS account that is
       * linked to the content owner that the onBehalfOfContentOwner parameter specifies. Finally,
       * the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be linked
       * to the content owner that the onBehalfOfContentOwner parameter specifies.
       *
       * This parameter is intended for YouTube content partners that own and manage many different
       * YouTube channels. It allows content owners to authenticate once and perform actions on
       * behalf of the channel specified in the parameter value, without having to provide
       * authentication credentials for each separate channel.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwnerChannel;

      /** This parameter can only be used in a properly authorized request. Note: This parameter is intended
     exclusively for YouTube content partners.

     The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel to
     which a video is being added. This parameter is required when a request specifies a value for the
     onBehalfOfContentOwner parameter, and it can only be used in conjunction with that parameter. In
     addition, the request must be authorized using a CMS account that is linked to the content owner
     that the onBehalfOfContentOwner parameter specifies. Finally, the channel that the
     onBehalfOfContentOwnerChannel parameter value specifies must be linked to the content owner that
     the onBehalfOfContentOwner parameter specifies.

     This parameter is intended for YouTube content partners that own and manage many different YouTube
     channels. It allows content owners to authenticate once and perform actions on behalf of the
     channel specified in the parameter value, without having to provide authentication credentials for
     each separate channel.
       */
      public java.lang.String getOnBehalfOfContentOwnerChannel() {
        return onBehalfOfContentOwnerChannel;
      }

      /**
       * This parameter can only be used in a properly authorized request. Note: This parameter is
       * intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel
       * to which a video is being added. This parameter is required when a request specifies a
       * value for the onBehalfOfContentOwner parameter, and it can only be used in conjunction with
       * that parameter. In addition, the request must be authorized using a CMS account that is
       * linked to the content owner that the onBehalfOfContentOwner parameter specifies. Finally,
       * the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be linked
       * to the content owner that the onBehalfOfContentOwner parameter specifies.
       *
       * This parameter is intended for YouTube content partners that own and manage many different
       * YouTube channels. It allows content owners to authenticate once and perform actions on
       * behalf of the channel specified in the parameter value, without having to provide
       * authentication credentials for each separate channel.
       */
      public List setOnBehalfOfContentOwnerChannel(java.lang.String onBehalfOfContentOwnerChannel) {
        this.onBehalfOfContentOwnerChannel = onBehalfOfContentOwnerChannel;
        return this;
      }

      /**
       * The mine parameter can be used to instruct the API to only return streams owned by the
       * authenticated user. Set the parameter value to true to only retrieve your own streams.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean mine;

      /** The mine parameter can be used to instruct the API to only return streams owned by the
     authenticated user. Set the parameter value to true to only retrieve your own streams.
       */
      public java.lang.Boolean getMine() {
        return mine;
      }

      /**
       * The mine parameter can be used to instruct the API to only return streams owned by the
       * authenticated user. Set the parameter value to true to only retrieve your own streams.
       */
      public List setMine(java.lang.Boolean mine) {
        this.mine = mine;
        return this;
      }

      /**
       * The maxResults parameter specifies the maximum number of items that should be returned in
       * the result set. Acceptable values are 0 to 50, inclusive. The default value is 5.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maxResults parameter specifies the maximum number of items that should be returned in the
     result set. Acceptable values are 0 to 50, inclusive. The default value is 5. [default: 5]
     [minimum: 0] [maximum: 50]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maxResults parameter specifies the maximum number of items that should be returned in
       * the result set. Acceptable values are 0 to 50, inclusive. The default value is 5.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * The pageToken parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The pageToken parameter identifies a specific page in the result set that should be returned. In an
     API response, the nextPageToken and prevPageToken properties identify other pages that could be
     retrieved.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * The pageToken parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * The id parameter specifies a comma-separated list of YouTube stream IDs that identify the
       * streams being retrieved. In a liveStream resource, the id property specifies the stream's
       * ID.
       */
      @com.google.api.client.util.Key
      private java.lang.String id;

      /** The id parameter specifies a comma-separated list of YouTube stream IDs that identify the streams
     being retrieved. In a liveStream resource, the id property specifies the stream's ID.
       */
      public java.lang.String getId() {
        return id;
      }

      /**
       * The id parameter specifies a comma-separated list of YouTube stream IDs that identify the
       * streams being retrieved. In a liveStream resource, the id property specifies the stream's
       * ID.
       */
      public List setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates a video stream. If the properties that you want to change cannot be updated, then you
     * need to create a new stream with the proper settings.
     *
     * Create a request for the method "liveStreams.update".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
    The
     *        part properties that you can include in the parameter value are id, snippet, cdn, and
     *        status.
    Note that this method will override the existing values for all of the mutable
     *        properties that are contained in any parts that the parameter value specifies. If the
     *        request body does not specify a value for a mutable property, the existing value for that
     *        property will be removed.
     * @param content the {@link com.google.api.services.youtube.model.LiveStream}
     * @return the request
     */
    public Update update(java.lang.String part, com.google.api.services.youtube.model.LiveStream content) throws java.io.IOException {
      Update result = new Update(part, content);
      initialize(result);
      return result;
    }

    public class Update extends YouTubeRequest<com.google.api.services.youtube.model.LiveStream> {

      private static final String REST_PATH = "liveStreams";

      /**
       * Updates a video stream. If the properties that you want to change cannot be updated, then you
       * need to create a new stream with the proper settings.
       *
       * Create a request for the method "liveStreams.update".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
    The
     *        part properties that you can include in the parameter value are id, snippet, cdn, and
     *        status.
    Note that this method will override the existing values for all of the mutable
     *        properties that are contained in any parts that the parameter value specifies. If the
     *        request body does not specify a value for a mutable property, the existing value for that
     *        property will be removed.
       * @param content the {@link com.google.api.services.youtube.model.LiveStream}
       * @since 1.13
       */
      protected Update(java.lang.String part, com.google.api.services.youtube.model.LiveStream content) {
        super(YouTube.this, "PUT", REST_PATH, content, com.google.api.services.youtube.model.LiveStream.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
        checkRequiredParameter(content, "content");
        checkRequiredParameter(content.getId(), "LiveStream.getId()");
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /**
       * The part parameter serves two purposes in this operation. It identifies the properties that
       * the write operation will set as well as the properties that the API response will include.
       *
       * The part properties that you can include in the parameter value are id, snippet, cdn, and
       * status.
       *
       * Note that this method will override the existing values for all of the mutable properties
       * that are contained in any parts that the parameter value specifies. If the request body
       * does not specify a value for a mutable property, the existing value for that property will
       * be removed.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter serves two purposes in this operation. It identifies the properties that the
     write operation will set as well as the properties that the API response will include.

     The part properties that you can include in the parameter value are id, snippet, cdn, and status.

     Note that this method will override the existing values for all of the mutable properties that are
     contained in any parts that the parameter value specifies. If the request body does not specify a
     value for a mutable property, the existing value for that property will be removed.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter serves two purposes in this operation. It identifies the properties that
       * the write operation will set as well as the properties that the API response will include.
       *
       * The part properties that you can include in the parameter value are id, snippet, cdn, and
       * status.
       *
       * Note that this method will override the existing values for all of the mutable properties
       * that are contained in any parts that the parameter value specifies. If the request body
       * does not specify a value for a mutable property, the existing value for that property will
       * be removed.
       */
      public Update setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      /**
       * This parameter can only be used in a properly authorized request. Note: This parameter is
       * intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel
       * to which a video is being added. This parameter is required when a request specifies a
       * value for the onBehalfOfContentOwner parameter, and it can only be used in conjunction with
       * that parameter. In addition, the request must be authorized using a CMS account that is
       * linked to the content owner that the onBehalfOfContentOwner parameter specifies. Finally,
       * the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be linked
       * to the content owner that the onBehalfOfContentOwner parameter specifies.
       *
       * This parameter is intended for YouTube content partners that own and manage many different
       * YouTube channels. It allows content owners to authenticate once and perform actions on
       * behalf of the channel specified in the parameter value, without having to provide
       * authentication credentials for each separate channel.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwnerChannel;

      /** This parameter can only be used in a properly authorized request. Note: This parameter is intended
     exclusively for YouTube content partners.

     The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel to
     which a video is being added. This parameter is required when a request specifies a value for the
     onBehalfOfContentOwner parameter, and it can only be used in conjunction with that parameter. In
     addition, the request must be authorized using a CMS account that is linked to the content owner
     that the onBehalfOfContentOwner parameter specifies. Finally, the channel that the
     onBehalfOfContentOwnerChannel parameter value specifies must be linked to the content owner that
     the onBehalfOfContentOwner parameter specifies.

     This parameter is intended for YouTube content partners that own and manage many different YouTube
     channels. It allows content owners to authenticate once and perform actions on behalf of the
     channel specified in the parameter value, without having to provide authentication credentials for
     each separate channel.
       */
      public java.lang.String getOnBehalfOfContentOwnerChannel() {
        return onBehalfOfContentOwnerChannel;
      }

      /**
       * This parameter can only be used in a properly authorized request. Note: This parameter is
       * intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel
       * to which a video is being added. This parameter is required when a request specifies a
       * value for the onBehalfOfContentOwner parameter, and it can only be used in conjunction with
       * that parameter. In addition, the request must be authorized using a CMS account that is
       * linked to the content owner that the onBehalfOfContentOwner parameter specifies. Finally,
       * the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be linked
       * to the content owner that the onBehalfOfContentOwner parameter specifies.
       *
       * This parameter is intended for YouTube content partners that own and manage many different
       * YouTube channels. It allows content owners to authenticate once and perform actions on
       * behalf of the channel specified in the parameter value, without having to provide
       * authentication credentials for each separate channel.
       */
      public Update setOnBehalfOfContentOwnerChannel(java.lang.String onBehalfOfContentOwnerChannel) {
        this.onBehalfOfContentOwnerChannel = onBehalfOfContentOwnerChannel;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The CMS account that the user authenticates with must be linked to the specified YouTube content
     owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public Update setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the PlaylistItems collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.PlaylistItems.List request = youtube.playlistItems().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public PlaylistItems playlistItems() {
    return new PlaylistItems();
  }

  /**
   * The "playlistItems" collection of methods.
   */
  public class PlaylistItems {

    /**
     * Deletes a playlist item.
     *
     * Create a request for the method "playlistItems.delete".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param id The id parameter specifies the YouTube playlist item ID for the playlist item that is being deleted.
     *        In a playlistItem resource, the id property specifies the playlist item's ID.
     * @return the request
     */
    public Delete delete(java.lang.String id) throws java.io.IOException {
      Delete result = new Delete(id);
      initialize(result);
      return result;
    }

    public class Delete extends YouTubeRequest<Void> {

      private static final String REST_PATH = "playlistItems";

      /**
       * Deletes a playlist item.
       *
       * Create a request for the method "playlistItems.delete".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param id The id parameter specifies the YouTube playlist item ID for the playlist item that is being deleted.
     *        In a playlistItem resource, the id property specifies the playlist item's ID.
       * @since 1.13
       */
      protected Delete(java.lang.String id) {
        super(YouTube.this, "DELETE", REST_PATH, null, Void.class);
        this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /**
       * The id parameter specifies the YouTube playlist item ID for the playlist item that is being
       * deleted. In a playlistItem resource, the id property specifies the playlist item's ID.
       */
      @com.google.api.client.util.Key
      private java.lang.String id;

      /** The id parameter specifies the YouTube playlist item ID for the playlist item that is being
     deleted. In a playlistItem resource, the id property specifies the playlist item's ID.
       */
      public java.lang.String getId() {
        return id;
      }

      /**
       * The id parameter specifies the YouTube playlist item ID for the playlist item that is being
       * deleted. In a playlistItem resource, the id property specifies the playlist item's ID.
       */
      public Delete setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Adds a resource to a playlist.
     *
     * Create a request for the method "playlistItems.insert".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
    The
     *        part names that you can include in the parameter value are snippet, contentDetails, and
     *        status.
     * @param content the {@link com.google.api.services.youtube.model.PlaylistItem}
     * @return the request
     */
    public Insert insert(java.lang.String part, com.google.api.services.youtube.model.PlaylistItem content) throws java.io.IOException {
      Insert result = new Insert(part, content);
      initialize(result);
      return result;
    }

    public class Insert extends YouTubeRequest<com.google.api.services.youtube.model.PlaylistItem> {

      private static final String REST_PATH = "playlistItems";

      /**
       * Adds a resource to a playlist.
       *
       * Create a request for the method "playlistItems.insert".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
    The
     *        part names that you can include in the parameter value are snippet, contentDetails, and
     *        status.
       * @param content the {@link com.google.api.services.youtube.model.PlaylistItem}
       * @since 1.13
       */
      protected Insert(java.lang.String part, com.google.api.services.youtube.model.PlaylistItem content) {
        super(YouTube.this, "POST", REST_PATH, content, com.google.api.services.youtube.model.PlaylistItem.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /**
       * The part parameter serves two purposes in this operation. It identifies the properties that
       * the write operation will set as well as the properties that the API response will include.
       *
       * The part names that you can include in the parameter value are snippet, contentDetails, and
       * status.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter serves two purposes in this operation. It identifies the properties that the
     write operation will set as well as the properties that the API response will include.

     The part names that you can include in the parameter value are snippet, contentDetails, and status.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter serves two purposes in this operation. It identifies the properties that
       * the write operation will set as well as the properties that the API response will include.
       *
       * The part names that you can include in the parameter value are snippet, contentDetails, and
       * status.
       */
      public Insert setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The CMS account that the user authenticates with must be linked to the specified YouTube content
     owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public Insert setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Returns a collection of playlist items that match the API request parameters. You can retrieve
     * all of the playlist items in a specified playlist or retrieve one or more playlist items by their
     * unique IDs.
     *
     * Create a request for the method "playlistItems.list".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter specifies a comma-separated list of one or more playlistItem resource properties
     *        that the API response will include. The part names that you can include in the parameter
     *        value are id, snippet, contentDetails, and status.
    If the parameter identifies a property
     *        that contains child properties, the child properties will be included in the response. For
     *        example, in a playlistItem resource, the snippet property contains numerous fields,
     *        including the title, description, position, and resourceId properties. As such, if you set
     *        part=snippet, the API response will contain all of those properties.
     * @return the request
     */
    public List list(java.lang.String part) throws java.io.IOException {
      List result = new List(part);
      initialize(result);
      return result;
    }

    public class List extends YouTubeRequest<com.google.api.services.youtube.model.PlaylistItemListResponse> {

      private static final String REST_PATH = "playlistItems";

      /**
       * Returns a collection of playlist items that match the API request parameters. You can retrieve
       * all of the playlist items in a specified playlist or retrieve one or more playlist items by
       * their unique IDs.
       *
       * Create a request for the method "playlistItems.list".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter specifies a comma-separated list of one or more playlistItem resource properties
     *        that the API response will include. The part names that you can include in the parameter
     *        value are id, snippet, contentDetails, and status.
    If the parameter identifies a property
     *        that contains child properties, the child properties will be included in the response. For
     *        example, in a playlistItem resource, the snippet property contains numerous fields,
     *        including the title, description, position, and resourceId properties. As such, if you set
     *        part=snippet, the API response will contain all of those properties.
       * @since 1.13
       */
      protected List(java.lang.String part) {
        super(YouTube.this, "GET", REST_PATH, null, com.google.api.services.youtube.model.PlaylistItemListResponse.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /**
       * The part parameter specifies a comma-separated list of one or more playlistItem resource
       * properties that the API response will include. The part names that you can include in the
       * parameter value are id, snippet, contentDetails, and status.
       *
       * If the parameter identifies a property that contains child properties, the child properties
       * will be included in the response. For example, in a playlistItem resource, the snippet
       * property contains numerous fields, including the title, description, position, and
       * resourceId properties. As such, if you set part=snippet, the API response will contain all
       * of those properties.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter specifies a comma-separated list of one or more playlistItem resource properties
     that the API response will include. The part names that you can include in the parameter value are
     id, snippet, contentDetails, and status.

     If the parameter identifies a property that contains child properties, the child properties will be
     included in the response. For example, in a playlistItem resource, the snippet property contains
     numerous fields, including the title, description, position, and resourceId properties. As such, if
     you set part=snippet, the API response will contain all of those properties.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter specifies a comma-separated list of one or more playlistItem resource
       * properties that the API response will include. The part names that you can include in the
       * parameter value are id, snippet, contentDetails, and status.
       *
       * If the parameter identifies a property that contains child properties, the child properties
       * will be included in the response. For example, in a playlistItem resource, the snippet
       * property contains numerous fields, including the title, description, position, and
       * resourceId properties. As such, if you set part=snippet, the API response will contain all
       * of those properties.
       */
      public List setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The CMS account that the user authenticates with must be linked to the specified YouTube content
     owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public List setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      /**
       * The playlistId parameter specifies the unique ID of the playlist for which you want to
       * retrieve playlist items. Note that even though this is an optional parameter, every request
       * to retrieve playlist items must specify a value for either the id parameter or the
       * playlistId parameter.
       */
      @com.google.api.client.util.Key
      private java.lang.String playlistId;

      /** The playlistId parameter specifies the unique ID of the playlist for which you want to retrieve
     playlist items. Note that even though this is an optional parameter, every request to retrieve
     playlist items must specify a value for either the id parameter or the playlistId parameter.
       */
      public java.lang.String getPlaylistId() {
        return playlistId;
      }

      /**
       * The playlistId parameter specifies the unique ID of the playlist for which you want to
       * retrieve playlist items. Note that even though this is an optional parameter, every request
       * to retrieve playlist items must specify a value for either the id parameter or the
       * playlistId parameter.
       */
      public List setPlaylistId(java.lang.String playlistId) {
        this.playlistId = playlistId;
        return this;
      }

      /**
       * The videoId parameter specifies that the request should return only the playlist items that
       * contain the specified video.
       */
      @com.google.api.client.util.Key
      private java.lang.String videoId;

      /** The videoId parameter specifies that the request should return only the playlist items that contain
     the specified video.
       */
      public java.lang.String getVideoId() {
        return videoId;
      }

      /**
       * The videoId parameter specifies that the request should return only the playlist items that
       * contain the specified video.
       */
      public List setVideoId(java.lang.String videoId) {
        this.videoId = videoId;
        return this;
      }

      /**
       * The maxResults parameter specifies the maximum number of items that should be returned in
       * the result set.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maxResults parameter specifies the maximum number of items that should be returned in the
     result set. [default: 5] [minimum: 0] [maximum: 50]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maxResults parameter specifies the maximum number of items that should be returned in
       * the result set.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * The pageToken parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The pageToken parameter identifies a specific page in the result set that should be returned. In an
     API response, the nextPageToken and prevPageToken properties identify other pages that could be
     retrieved.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * The pageToken parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * The id parameter specifies a comma-separated list of one or more unique playlist item IDs.
       */
      @com.google.api.client.util.Key
      private java.lang.String id;

      /** The id parameter specifies a comma-separated list of one or more unique playlist item IDs.
       */
      public java.lang.String getId() {
        return id;
      }

      /**
       * The id parameter specifies a comma-separated list of one or more unique playlist item IDs.
       */
      public List setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Modifies a playlist item. For example, you could update the item's position in the playlist.
     *
     * Create a request for the method "playlistItems.update".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
    The
     *        part names that you can include in the parameter value are snippet, contentDetails, and
     *        status.
    Note that this method will override the existing values for all of the mutable
     *        properties that are contained in any parts that the parameter value specifies. For
     *        example, a playlist item can specify a start time and end time, which identify the times
     *        portion of the video that should play when users watch the video in the playlist. If your
     *        request is updating a playlist item that sets these values, and the request's part
     *        parameter value includes the contentDetails part, the playlist item's start and end times
     *        will be updated to whatever value the request body specifies. If the request body does not
     *        specify values, the existing start and end times will be removed and replaced with the
     *        default settings.
     * @param content the {@link com.google.api.services.youtube.model.PlaylistItem}
     * @return the request
     */
    public Update update(java.lang.String part, com.google.api.services.youtube.model.PlaylistItem content) throws java.io.IOException {
      Update result = new Update(part, content);
      initialize(result);
      return result;
    }

    public class Update extends YouTubeRequest<com.google.api.services.youtube.model.PlaylistItem> {

      private static final String REST_PATH = "playlistItems";

      /**
       * Modifies a playlist item. For example, you could update the item's position in the playlist.
       *
       * Create a request for the method "playlistItems.update".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
    The
     *        part names that you can include in the parameter value are snippet, contentDetails, and
     *        status.
    Note that this method will override the existing values for all of the mutable
     *        properties that are contained in any parts that the parameter value specifies. For
     *        example, a playlist item can specify a start time and end time, which identify the times
     *        portion of the video that should play when users watch the video in the playlist. If your
     *        request is updating a playlist item that sets these values, and the request's part
     *        parameter value includes the contentDetails part, the playlist item's start and end times
     *        will be updated to whatever value the request body specifies. If the request body does not
     *        specify values, the existing start and end times will be removed and replaced with the
     *        default settings.
       * @param content the {@link com.google.api.services.youtube.model.PlaylistItem}
       * @since 1.13
       */
      protected Update(java.lang.String part, com.google.api.services.youtube.model.PlaylistItem content) {
        super(YouTube.this, "PUT", REST_PATH, content, com.google.api.services.youtube.model.PlaylistItem.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /**
       * The part parameter serves two purposes in this operation. It identifies the properties that
       * the write operation will set as well as the properties that the API response will include.
       *
       * The part names that you can include in the parameter value are snippet, contentDetails, and
       * status.
       *
       * Note that this method will override the existing values for all of the mutable properties
       * that are contained in any parts that the parameter value specifies. For example, a playlist
       * item can specify a start time and end time, which identify the times portion of the video
       * that should play when users watch the video in the playlist. If your request is updating a
       * playlist item that sets these values, and the request's part parameter value includes the
       * contentDetails part, the playlist item's start and end times will be updated to whatever
       * value the request body specifies. If the request body does not specify values, the existing
       * start and end times will be removed and replaced with the default settings.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter serves two purposes in this operation. It identifies the properties that the
     write operation will set as well as the properties that the API response will include.

     The part names that you can include in the parameter value are snippet, contentDetails, and status.

     Note that this method will override the existing values for all of the mutable properties that are
     contained in any parts that the parameter value specifies. For example, a playlist item can specify
     a start time and end time, which identify the times portion of the video that should play when
     users watch the video in the playlist. If your request is updating a playlist item that sets these
     values, and the request's part parameter value includes the contentDetails part, the playlist
     item's start and end times will be updated to whatever value the request body specifies. If the
     request body does not specify values, the existing start and end times will be removed and replaced
     with the default settings.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter serves two purposes in this operation. It identifies the properties that
       * the write operation will set as well as the properties that the API response will include.
       *
       * The part names that you can include in the parameter value are snippet, contentDetails, and
       * status.
       *
       * Note that this method will override the existing values for all of the mutable properties
       * that are contained in any parts that the parameter value specifies. For example, a playlist
       * item can specify a start time and end time, which identify the times portion of the video
       * that should play when users watch the video in the playlist. If your request is updating a
       * playlist item that sets these values, and the request's part parameter value includes the
       * contentDetails part, the playlist item's start and end times will be updated to whatever
       * value the request body specifies. If the request body does not specify values, the existing
       * start and end times will be removed and replaced with the default settings.
       */
      public Update setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Playlists collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.Playlists.List request = youtube.playlists().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Playlists playlists() {
    return new Playlists();
  }

  /**
   * The "playlists" collection of methods.
   */
  public class Playlists {

    /**
     * Deletes a playlist.
     *
     * Create a request for the method "playlists.delete".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param id The id parameter specifies the YouTube playlist ID for the playlist that is being deleted. In a
     *        playlist resource, the id property specifies the playlist's ID.
     * @return the request
     */
    public Delete delete(java.lang.String id) throws java.io.IOException {
      Delete result = new Delete(id);
      initialize(result);
      return result;
    }

    public class Delete extends YouTubeRequest<Void> {

      private static final String REST_PATH = "playlists";

      /**
       * Deletes a playlist.
       *
       * Create a request for the method "playlists.delete".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param id The id parameter specifies the YouTube playlist ID for the playlist that is being deleted. In a
     *        playlist resource, the id property specifies the playlist's ID.
       * @since 1.13
       */
      protected Delete(java.lang.String id) {
        super(YouTube.this, "DELETE", REST_PATH, null, Void.class);
        this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /**
       * The id parameter specifies the YouTube playlist ID for the playlist that is being deleted.
       * In a playlist resource, the id property specifies the playlist's ID.
       */
      @com.google.api.client.util.Key
      private java.lang.String id;

      /** The id parameter specifies the YouTube playlist ID for the playlist that is being deleted. In a
     playlist resource, the id property specifies the playlist's ID.
       */
      public java.lang.String getId() {
        return id;
      }

      /**
       * The id parameter specifies the YouTube playlist ID for the playlist that is being deleted.
       * In a playlist resource, the id property specifies the playlist's ID.
       */
      public Delete setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The CMS account that the user authenticates with must be linked to the specified YouTube content
     owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public Delete setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Creates a playlist.
     *
     * Create a request for the method "playlists.insert".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
    The
     *        part names that you can include in the parameter value are snippet and status.
     * @param content the {@link com.google.api.services.youtube.model.Playlist}
     * @return the request
     */
    public Insert insert(java.lang.String part, com.google.api.services.youtube.model.Playlist content) throws java.io.IOException {
      Insert result = new Insert(part, content);
      initialize(result);
      return result;
    }

    public class Insert extends YouTubeRequest<com.google.api.services.youtube.model.Playlist> {

      private static final String REST_PATH = "playlists";

      /**
       * Creates a playlist.
       *
       * Create a request for the method "playlists.insert".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
    The
     *        part names that you can include in the parameter value are snippet and status.
       * @param content the {@link com.google.api.services.youtube.model.Playlist}
       * @since 1.13
       */
      protected Insert(java.lang.String part, com.google.api.services.youtube.model.Playlist content) {
        super(YouTube.this, "POST", REST_PATH, content, com.google.api.services.youtube.model.Playlist.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /**
       * The part parameter serves two purposes in this operation. It identifies the properties that
       * the write operation will set as well as the properties that the API response will include.
       *
       * The part names that you can include in the parameter value are snippet and status.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter serves two purposes in this operation. It identifies the properties that the
     write operation will set as well as the properties that the API response will include.

     The part names that you can include in the parameter value are snippet and status.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter serves two purposes in this operation. It identifies the properties that
       * the write operation will set as well as the properties that the API response will include.
       *
       * The part names that you can include in the parameter value are snippet and status.
       */
      public Insert setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      /**
       * This parameter can only be used in a properly authorized request. Note: This parameter is
       * intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel
       * to which a video is being added. This parameter is required when a request specifies a
       * value for the onBehalfOfContentOwner parameter, and it can only be used in conjunction with
       * that parameter. In addition, the request must be authorized using a CMS account that is
       * linked to the content owner that the onBehalfOfContentOwner parameter specifies. Finally,
       * the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be linked
       * to the content owner that the onBehalfOfContentOwner parameter specifies.
       *
       * This parameter is intended for YouTube content partners that own and manage many different
       * YouTube channels. It allows content owners to authenticate once and perform actions on
       * behalf of the channel specified in the parameter value, without having to provide
       * authentication credentials for each separate channel.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwnerChannel;

      /** This parameter can only be used in a properly authorized request. Note: This parameter is intended
     exclusively for YouTube content partners.

     The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel to
     which a video is being added. This parameter is required when a request specifies a value for the
     onBehalfOfContentOwner parameter, and it can only be used in conjunction with that parameter. In
     addition, the request must be authorized using a CMS account that is linked to the content owner
     that the onBehalfOfContentOwner parameter specifies. Finally, the channel that the
     onBehalfOfContentOwnerChannel parameter value specifies must be linked to the content owner that
     the onBehalfOfContentOwner parameter specifies.

     This parameter is intended for YouTube content partners that own and manage many different YouTube
     channels. It allows content owners to authenticate once and perform actions on behalf of the
     channel specified in the parameter value, without having to provide authentication credentials for
     each separate channel.
       */
      public java.lang.String getOnBehalfOfContentOwnerChannel() {
        return onBehalfOfContentOwnerChannel;
      }

      /**
       * This parameter can only be used in a properly authorized request. Note: This parameter is
       * intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel
       * to which a video is being added. This parameter is required when a request specifies a
       * value for the onBehalfOfContentOwner parameter, and it can only be used in conjunction with
       * that parameter. In addition, the request must be authorized using a CMS account that is
       * linked to the content owner that the onBehalfOfContentOwner parameter specifies. Finally,
       * the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be linked
       * to the content owner that the onBehalfOfContentOwner parameter specifies.
       *
       * This parameter is intended for YouTube content partners that own and manage many different
       * YouTube channels. It allows content owners to authenticate once and perform actions on
       * behalf of the channel specified in the parameter value, without having to provide
       * authentication credentials for each separate channel.
       */
      public Insert setOnBehalfOfContentOwnerChannel(java.lang.String onBehalfOfContentOwnerChannel) {
        this.onBehalfOfContentOwnerChannel = onBehalfOfContentOwnerChannel;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The CMS account that the user authenticates with must be linked to the specified YouTube content
     owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public Insert setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Returns a collection of playlists that match the API request parameters. For example, you can
     * retrieve all playlists that the authenticated user owns, or you can retrieve one or more
     * playlists by their unique IDs.
     *
     * Create a request for the method "playlists.list".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter specifies a comma-separated list of one or more playlist resource properties that
     *        the API response will include. The part names that you can include in the parameter value
     *        are id, snippet, status, and contentDetails.
    If the parameter identifies a property that
     *        contains child properties, the child properties will be included in the response. For
     *        example, in a playlist resource, the snippet property contains properties like author,
     *        title, description, tags, and timeCreated. As such, if you set part=snippet, the API
     *        response will contain all of those properties.
     * @return the request
     */
    public List list(java.lang.String part) throws java.io.IOException {
      List result = new List(part);
      initialize(result);
      return result;
    }

    public class List extends YouTubeRequest<com.google.api.services.youtube.model.PlaylistListResponse> {

      private static final String REST_PATH = "playlists";

      /**
       * Returns a collection of playlists that match the API request parameters. For example, you can
       * retrieve all playlists that the authenticated user owns, or you can retrieve one or more
       * playlists by their unique IDs.
       *
       * Create a request for the method "playlists.list".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter specifies a comma-separated list of one or more playlist resource properties that
     *        the API response will include. The part names that you can include in the parameter value
     *        are id, snippet, status, and contentDetails.
    If the parameter identifies a property that
     *        contains child properties, the child properties will be included in the response. For
     *        example, in a playlist resource, the snippet property contains properties like author,
     *        title, description, tags, and timeCreated. As such, if you set part=snippet, the API
     *        response will contain all of those properties.
       * @since 1.13
       */
      protected List(java.lang.String part) {
        super(YouTube.this, "GET", REST_PATH, null, com.google.api.services.youtube.model.PlaylistListResponse.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /**
       * The part parameter specifies a comma-separated list of one or more playlist resource
       * properties that the API response will include. The part names that you can include in the
       * parameter value are id, snippet, status, and contentDetails.
       *
       * If the parameter identifies a property that contains child properties, the child properties
       * will be included in the response. For example, in a playlist resource, the snippet property
       * contains properties like author, title, description, tags, and timeCreated. As such, if you
       * set part=snippet, the API response will contain all of those properties.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter specifies a comma-separated list of one or more playlist resource properties
     that the API response will include. The part names that you can include in the parameter value are
     id, snippet, status, and contentDetails.

     If the parameter identifies a property that contains child properties, the child properties will be
     included in the response. For example, in a playlist resource, the snippet property contains
     properties like author, title, description, tags, and timeCreated. As such, if you set
     part=snippet, the API response will contain all of those properties.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter specifies a comma-separated list of one or more playlist resource
       * properties that the API response will include. The part names that you can include in the
       * parameter value are id, snippet, status, and contentDetails.
       *
       * If the parameter identifies a property that contains child properties, the child properties
       * will be included in the response. For example, in a playlist resource, the snippet property
       * contains properties like author, title, description, tags, and timeCreated. As such, if you
       * set part=snippet, the API response will contain all of those properties.
       */
      public List setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The CMS account that the user authenticates with must be linked to the specified YouTube content
     owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public List setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      /**
       * This parameter can only be used in a properly authorized request. Note: This parameter is
       * intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel
       * to which a video is being added. This parameter is required when a request specifies a
       * value for the onBehalfOfContentOwner parameter, and it can only be used in conjunction with
       * that parameter. In addition, the request must be authorized using a CMS account that is
       * linked to the content owner that the onBehalfOfContentOwner parameter specifies. Finally,
       * the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be linked
       * to the content owner that the onBehalfOfContentOwner parameter specifies.
       *
       * This parameter is intended for YouTube content partners that own and manage many different
       * YouTube channels. It allows content owners to authenticate once and perform actions on
       * behalf of the channel specified in the parameter value, without having to provide
       * authentication credentials for each separate channel.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwnerChannel;

      /** This parameter can only be used in a properly authorized request. Note: This parameter is intended
     exclusively for YouTube content partners.

     The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel to
     which a video is being added. This parameter is required when a request specifies a value for the
     onBehalfOfContentOwner parameter, and it can only be used in conjunction with that parameter. In
     addition, the request must be authorized using a CMS account that is linked to the content owner
     that the onBehalfOfContentOwner parameter specifies. Finally, the channel that the
     onBehalfOfContentOwnerChannel parameter value specifies must be linked to the content owner that
     the onBehalfOfContentOwner parameter specifies.

     This parameter is intended for YouTube content partners that own and manage many different YouTube
     channels. It allows content owners to authenticate once and perform actions on behalf of the
     channel specified in the parameter value, without having to provide authentication credentials for
     each separate channel.
       */
      public java.lang.String getOnBehalfOfContentOwnerChannel() {
        return onBehalfOfContentOwnerChannel;
      }

      /**
       * This parameter can only be used in a properly authorized request. Note: This parameter is
       * intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel
       * to which a video is being added. This parameter is required when a request specifies a
       * value for the onBehalfOfContentOwner parameter, and it can only be used in conjunction with
       * that parameter. In addition, the request must be authorized using a CMS account that is
       * linked to the content owner that the onBehalfOfContentOwner parameter specifies. Finally,
       * the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be linked
       * to the content owner that the onBehalfOfContentOwner parameter specifies.
       *
       * This parameter is intended for YouTube content partners that own and manage many different
       * YouTube channels. It allows content owners to authenticate once and perform actions on
       * behalf of the channel specified in the parameter value, without having to provide
       * authentication credentials for each separate channel.
       */
      public List setOnBehalfOfContentOwnerChannel(java.lang.String onBehalfOfContentOwnerChannel) {
        this.onBehalfOfContentOwnerChannel = onBehalfOfContentOwnerChannel;
        return this;
      }

      /**
       * This value indicates that the API should only return the specified channel's playlists.
       */
      @com.google.api.client.util.Key
      private java.lang.String channelId;

      /** This value indicates that the API should only return the specified channel's playlists.
       */
      public java.lang.String getChannelId() {
        return channelId;
      }

      /**
       * This value indicates that the API should only return the specified channel's playlists.
       */
      public List setChannelId(java.lang.String channelId) {
        this.channelId = channelId;
        return this;
      }

      /**
       * Set this parameter's value to true to instruct the API to only return playlists owned by
       * the authenticated user.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean mine;

      /** Set this parameter's value to true to instruct the API to only return playlists owned by the
     authenticated user.
       */
      public java.lang.Boolean getMine() {
        return mine;
      }

      /**
       * Set this parameter's value to true to instruct the API to only return playlists owned by
       * the authenticated user.
       */
      public List setMine(java.lang.Boolean mine) {
        this.mine = mine;
        return this;
      }

      /**
       * The maxResults parameter specifies the maximum number of items that should be returned in
       * the result set.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maxResults parameter specifies the maximum number of items that should be returned in the
     result set. [default: 5] [minimum: 0] [maximum: 50]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maxResults parameter specifies the maximum number of items that should be returned in
       * the result set.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * The pageToken parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The pageToken parameter identifies a specific page in the result set that should be returned. In an
     API response, the nextPageToken and prevPageToken properties identify other pages that could be
     retrieved.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * The pageToken parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * The id parameter specifies a comma-separated list of the YouTube playlist ID(s) for the
       * resource(s) that are being retrieved. In a playlist resource, the id property specifies the
       * playlist's YouTube playlist ID.
       */
      @com.google.api.client.util.Key
      private java.lang.String id;

      /** The id parameter specifies a comma-separated list of the YouTube playlist ID(s) for the resource(s)
     that are being retrieved. In a playlist resource, the id property specifies the playlist's YouTube
     playlist ID.
       */
      public java.lang.String getId() {
        return id;
      }

      /**
       * The id parameter specifies a comma-separated list of the YouTube playlist ID(s) for the
       * resource(s) that are being retrieved. In a playlist resource, the id property specifies the
       * playlist's YouTube playlist ID.
       */
      public List setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Modifies a playlist. For example, you could change a playlist's title, description, or privacy
     * status.
     *
     * Create a request for the method "playlists.update".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
    The
     *        part names that you can include in the parameter value are snippet and status.
    Note that
     *        this method will override the existing values for all of the mutable properties that are
     *        contained in any parts that the parameter value specifies. For example, a playlist's
     *        privacy setting is contained in the status part. As such, if your request is updating a
     *        private playlist, and the request's part parameter value includes the status part, the
     *        playlist's privacy setting will be updated to whatever value the request body specifies.
     *        If the request body does not specify a value, the existing privacy setting will be removed
     *        and the playlist will revert to the default privacy setting.
     * @param content the {@link com.google.api.services.youtube.model.Playlist}
     * @return the request
     */
    public Update update(java.lang.String part, com.google.api.services.youtube.model.Playlist content) throws java.io.IOException {
      Update result = new Update(part, content);
      initialize(result);
      return result;
    }

    public class Update extends YouTubeRequest<com.google.api.services.youtube.model.Playlist> {

      private static final String REST_PATH = "playlists";

      /**
       * Modifies a playlist. For example, you could change a playlist's title, description, or privacy
       * status.
       *
       * Create a request for the method "playlists.update".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
    The
     *        part names that you can include in the parameter value are snippet and status.
    Note that
     *        this method will override the existing values for all of the mutable properties that are
     *        contained in any parts that the parameter value specifies. For example, a playlist's
     *        privacy setting is contained in the status part. As such, if your request is updating a
     *        private playlist, and the request's part parameter value includes the status part, the
     *        playlist's privacy setting will be updated to whatever value the request body specifies.
     *        If the request body does not specify a value, the existing privacy setting will be removed
     *        and the playlist will revert to the default privacy setting.
       * @param content the {@link com.google.api.services.youtube.model.Playlist}
       * @since 1.13
       */
      protected Update(java.lang.String part, com.google.api.services.youtube.model.Playlist content) {
        super(YouTube.this, "PUT", REST_PATH, content, com.google.api.services.youtube.model.Playlist.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /**
       * The part parameter serves two purposes in this operation. It identifies the properties that
       * the write operation will set as well as the properties that the API response will include.
       *
       * The part names that you can include in the parameter value are snippet and status.
       *
       * Note that this method will override the existing values for all of the mutable properties
       * that are contained in any parts that the parameter value specifies. For example, a
       * playlist's privacy setting is contained in the status part. As such, if your request is
       * updating a private playlist, and the request's part parameter value includes the status
       * part, the playlist's privacy setting will be updated to whatever value the request body
       * specifies. If the request body does not specify a value, the existing privacy setting will
       * be removed and the playlist will revert to the default privacy setting.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter serves two purposes in this operation. It identifies the properties that the
     write operation will set as well as the properties that the API response will include.

     The part names that you can include in the parameter value are snippet and status.

     Note that this method will override the existing values for all of the mutable properties that are
     contained in any parts that the parameter value specifies. For example, a playlist's privacy
     setting is contained in the status part. As such, if your request is updating a private playlist,
     and the request's part parameter value includes the status part, the playlist's privacy setting
     will be updated to whatever value the request body specifies. If the request body does not specify
     a value, the existing privacy setting will be removed and the playlist will revert to the default
     privacy setting.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter serves two purposes in this operation. It identifies the properties that
       * the write operation will set as well as the properties that the API response will include.
       *
       * The part names that you can include in the parameter value are snippet and status.
       *
       * Note that this method will override the existing values for all of the mutable properties
       * that are contained in any parts that the parameter value specifies. For example, a
       * playlist's privacy setting is contained in the status part. As such, if your request is
       * updating a private playlist, and the request's part parameter value includes the status
       * part, the playlist's privacy setting will be updated to whatever value the request body
       * specifies. If the request body does not specify a value, the existing privacy setting will
       * be removed and the playlist will revert to the default privacy setting.
       */
      public Update setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The CMS account that the user authenticates with must be linked to the specified YouTube content
     owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public Update setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Search collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.Search.List request = youtube.search().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Search search() {
    return new Search();
  }

  /**
   * The "search" collection of methods.
   */
  public class Search {

    /**
     * Returns a collection of search results that match the query parameters specified in the API
     * request. By default, a search result set identifies matching video, channel, and playlist
     * resources, but you can also configure queries to only retrieve a specific type of resource.
     *
     * Create a request for the method "search.list".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter specifies a comma-separated list of one or more search resource properties that
     *        the API response will include. The part names that you can include in the parameter value
     *        are id and snippet.
    If the parameter identifies a property that contains child properties,
     *        the child properties will be included in the response. For example, in a search result,
     *        the snippet property contains other properties that identify the result's title,
     *        description, and so forth. If you set part=snippet, the API response will also contain all
     *        of those nested properties.
     * @return the request
     */
    public List list(java.lang.String part) throws java.io.IOException {
      List result = new List(part);
      initialize(result);
      return result;
    }

    public class List extends YouTubeRequest<com.google.api.services.youtube.model.SearchListResponse> {

      private static final String REST_PATH = "search";

      /**
       * Returns a collection of search results that match the query parameters specified in the API
       * request. By default, a search result set identifies matching video, channel, and playlist
       * resources, but you can also configure queries to only retrieve a specific type of resource.
       *
       * Create a request for the method "search.list".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter specifies a comma-separated list of one or more search resource properties that
     *        the API response will include. The part names that you can include in the parameter value
     *        are id and snippet.
    If the parameter identifies a property that contains child properties,
     *        the child properties will be included in the response. For example, in a search result,
     *        the snippet property contains other properties that identify the result's title,
     *        description, and so forth. If you set part=snippet, the API response will also contain all
     *        of those nested properties.
       * @since 1.13
       */
      protected List(java.lang.String part) {
        super(YouTube.this, "GET", REST_PATH, null, com.google.api.services.youtube.model.SearchListResponse.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /**
       * The part parameter specifies a comma-separated list of one or more search resource
       * properties that the API response will include. The part names that you can include in the
       * parameter value are id and snippet.
       *
       * If the parameter identifies a property that contains child properties, the child properties
       * will be included in the response. For example, in a search result, the snippet property
       * contains other properties that identify the result's title, description, and so forth. If
       * you set part=snippet, the API response will also contain all of those nested properties.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter specifies a comma-separated list of one or more search resource properties that
     the API response will include. The part names that you can include in the parameter value are id
     and snippet.

     If the parameter identifies a property that contains child properties, the child properties will be
     included in the response. For example, in a search result, the snippet property contains other
     properties that identify the result's title, description, and so forth. If you set part=snippet,
     the API response will also contain all of those nested properties.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter specifies a comma-separated list of one or more search resource
       * properties that the API response will include. The part names that you can include in the
       * parameter value are id and snippet.
       *
       * If the parameter identifies a property that contains child properties, the child properties
       * will be included in the response. For example, in a search result, the snippet property
       * contains other properties that identify the result's title, description, and so forth. If
       * you set part=snippet, the API response will also contain all of those nested properties.
       */
      public List setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      /** The eventType parameter restricts a search to broadcast events. */
      @com.google.api.client.util.Key
      private java.lang.String eventType;

      /** The eventType parameter restricts a search to broadcast events.
       */
      public java.lang.String getEventType() {
        return eventType;
      }

      /** The eventType parameter restricts a search to broadcast events. */
      public List setEventType(java.lang.String eventType) {
        this.eventType = eventType;
        return this;
      }

      /**
       * The channelId parameter indicates that the API response should only contain resources
       * created by the channel
       */
      @com.google.api.client.util.Key
      private java.lang.String channelId;

      /** The channelId parameter indicates that the API response should only contain resources created by
     the channel
       */
      public java.lang.String getChannelId() {
        return channelId;
      }

      /**
       * The channelId parameter indicates that the API response should only contain resources
       * created by the channel
       */
      public List setChannelId(java.lang.String channelId) {
        this.channelId = channelId;
        return this;
      }

      /**
       * The videoSyndicated parameter lets you to restrict a search to only videos that can be
       * played outside youtube.com.
       */
      @com.google.api.client.util.Key
      private java.lang.String videoSyndicated;

      /** The videoSyndicated parameter lets you to restrict a search to only videos that can be played
     outside youtube.com.
       */
      public java.lang.String getVideoSyndicated() {
        return videoSyndicated;
      }

      /**
       * The videoSyndicated parameter lets you to restrict a search to only videos that can be
       * played outside youtube.com.
       */
      public List setVideoSyndicated(java.lang.String videoSyndicated) {
        this.videoSyndicated = videoSyndicated;
        return this;
      }

      /** The channelType parameter lets you restrict a search to a particular type of channel. */
      @com.google.api.client.util.Key
      private java.lang.String channelType;

      /** The channelType parameter lets you restrict a search to a particular type of channel.
       */
      public java.lang.String getChannelType() {
        return channelType;
      }

      /** The channelType parameter lets you restrict a search to a particular type of channel. */
      public List setChannelType(java.lang.String channelType) {
        this.channelType = channelType;
        return this;
      }

      /**
       * The videoCaption parameter indicates whether the API should filter video search results
       * based on whether they have captions.
       */
      @com.google.api.client.util.Key
      private java.lang.String videoCaption;

      /** The videoCaption parameter indicates whether the API should filter video search results based on
     whether they have captions.
       */
      public java.lang.String getVideoCaption() {
        return videoCaption;
      }

      /**
       * The videoCaption parameter indicates whether the API should filter video search results
       * based on whether they have captions.
       */
      public List setVideoCaption(java.lang.String videoCaption) {
        this.videoCaption = videoCaption;
        return this;
      }

      /**
       * The publishedAfter parameter indicates that the API response should only contain resources
       * created after the specified time. The value is an RFC 3339 formatted date-time value
       * (1970-01-01T00:00:00Z).
       */
      @com.google.api.client.util.Key
      private com.google.api.client.util.DateTime publishedAfter;

      /** The publishedAfter parameter indicates that the API response should only contain resources created
     after the specified time. The value is an RFC 3339 formatted date-time value
     (1970-01-01T00:00:00Z).
       */
      public com.google.api.client.util.DateTime getPublishedAfter() {
        return publishedAfter;
      }

      /**
       * The publishedAfter parameter indicates that the API response should only contain resources
       * created after the specified time. The value is an RFC 3339 formatted date-time value
       * (1970-01-01T00:00:00Z).
       */
      public List setPublishedAfter(com.google.api.client.util.DateTime publishedAfter) {
        this.publishedAfter = publishedAfter;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The CMS account that the user authenticates with must be linked to the specified YouTube content
     owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public List setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      /**
       * The pageToken parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The pageToken parameter identifies a specific page in the result set that should be returned. In an
     API response, the nextPageToken and prevPageToken properties identify other pages that could be
     retrieved.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * The pageToken parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The forContentOwner parameter restricts the search to only retrieve resources owned by the
       * content owner specified by the onBehalfOfContentOwner parameter. The user must be
       * authenticated using a CMS account linked to the specified content owner and
       * onBehalfOfContentOwner must be provided.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean forContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The forContentOwner parameter restricts the search to only retrieve resources owned by the content
     owner specified by the onBehalfOfContentOwner parameter. The user must be authenticated using a CMS
     account linked to the specified content owner and onBehalfOfContentOwner must be provided.
       */
      public java.lang.Boolean getForContentOwner() {
        return forContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The forContentOwner parameter restricts the search to only retrieve resources owned by the
       * content owner specified by the onBehalfOfContentOwner parameter. The user must be
       * authenticated using a CMS account linked to the specified content owner and
       * onBehalfOfContentOwner must be provided.
       */
      public List setForContentOwner(java.lang.Boolean forContentOwner) {
        this.forContentOwner = forContentOwner;
        return this;
      }

      /**
       * The regionCode parameter instructs the API to return search results for the specified
       * country. The parameter value is an ISO 3166-1 alpha-2 country code.
       */
      @com.google.api.client.util.Key
      private java.lang.String regionCode;

      /** The regionCode parameter instructs the API to return search results for the specified country. The
     parameter value is an ISO 3166-1 alpha-2 country code.
       */
      public java.lang.String getRegionCode() {
        return regionCode;
      }

      /**
       * The regionCode parameter instructs the API to return search results for the specified
       * country. The parameter value is an ISO 3166-1 alpha-2 country code.
       */
      public List setRegionCode(java.lang.String regionCode) {
        this.regionCode = regionCode;
        return this;
      }

      /**
       * The location parameter restricts a search to videos that have a geographical location
       * specified in their metadata. The value is a string that specifies geographic
       * latitude/longitude coordinates e.g. (37.42307,-122.08427)
       */
      @com.google.api.client.util.Key
      private java.lang.String location;

      /** The location parameter restricts a search to videos that have a geographical location specified in
     their metadata. The value is a string that specifies geographic latitude/longitude coordinates e.g.
     (37.42307,-122.08427)
       */
      public java.lang.String getLocation() {
        return location;
      }

      /**
       * The location parameter restricts a search to videos that have a geographical location
       * specified in their metadata. The value is a string that specifies geographic
       * latitude/longitude coordinates e.g. (37.42307,-122.08427)
       */
      public List setLocation(java.lang.String location) {
        this.location = location;
        return this;
      }

      /**
       * The locationRadius, in conjunction with the location parameter, defines a geographic area.
       * If the geographic coordinates associated with a video fall within that area, then the video
       * may be included in search results. This parameter value must be a floating point number
       * followed by a measurement unit. Valid measurement units are m, km, ft, and mi. For example,
       * valid parameter values include 1500m, 5km, 10000ft, and 0.75mi. The API does not support
       * locationRadius parameter values larger than 1000 kilometers.
       */
      @com.google.api.client.util.Key
      private java.lang.String locationRadius;

      /** The locationRadius, in conjunction with the location parameter, defines a geographic area. If the
     geographic coordinates associated with a video fall within that area, then the video may be
     included in search results. This parameter value must be a floating point number followed by a
     measurement unit. Valid measurement units are m, km, ft, and mi. For example, valid parameter
     values include 1500m, 5km, 10000ft, and 0.75mi. The API does not support locationRadius parameter
     values larger than 1000 kilometers.
       */
      public java.lang.String getLocationRadius() {
        return locationRadius;
      }

      /**
       * The locationRadius, in conjunction with the location parameter, defines a geographic area.
       * If the geographic coordinates associated with a video fall within that area, then the video
       * may be included in search results. This parameter value must be a floating point number
       * followed by a measurement unit. Valid measurement units are m, km, ft, and mi. For example,
       * valid parameter values include 1500m, 5km, 10000ft, and 0.75mi. The API does not support
       * locationRadius parameter values larger than 1000 kilometers.
       */
      public List setLocationRadius(java.lang.String locationRadius) {
        this.locationRadius = locationRadius;
        return this;
      }

      /** The videoType parameter lets you restrict a search to a particular type of videos. */
      @com.google.api.client.util.Key
      private java.lang.String videoType;

      /** The videoType parameter lets you restrict a search to a particular type of videos.
       */
      public java.lang.String getVideoType() {
        return videoType;
      }

      /** The videoType parameter lets you restrict a search to a particular type of videos. */
      public List setVideoType(java.lang.String videoType) {
        this.videoType = videoType;
        return this;
      }

      /**
       * The type parameter restricts a search query to only retrieve a particular type of resource.
       * The value is a comma-separated list of resource types.
       */
      @com.google.api.client.util.Key
      private java.lang.String type;

      /** The type parameter restricts a search query to only retrieve a particular type of resource. The
     value is a comma-separated list of resource types. [default: video,channel,playlist]
       */
      public java.lang.String getType() {
        return type;
      }

      /**
       * The type parameter restricts a search query to only retrieve a particular type of resource.
       * The value is a comma-separated list of resource types.
       */
      public List setType(java.lang.String type) {
        this.type = type;
        return this;
      }

      /**
       * The topicId parameter indicates that the API response should only contain resources
       * associated with the specified topic. The value identifies a Freebase topic ID.
       */
      @com.google.api.client.util.Key
      private java.lang.String topicId;

      /** The topicId parameter indicates that the API response should only contain resources associated with
     the specified topic. The value identifies a Freebase topic ID.
       */
      public java.lang.String getTopicId() {
        return topicId;
      }

      /**
       * The topicId parameter indicates that the API response should only contain resources
       * associated with the specified topic. The value identifies a Freebase topic ID.
       */
      public List setTopicId(java.lang.String topicId) {
        this.topicId = topicId;
        return this;
      }

      /**
       * The publishedBefore parameter indicates that the API response should only contain resources
       * created before the specified time. The value is an RFC 3339 formatted date-time value
       * (1970-01-01T00:00:00Z).
       */
      @com.google.api.client.util.Key
      private com.google.api.client.util.DateTime publishedBefore;

      /** The publishedBefore parameter indicates that the API response should only contain resources created
     before the specified time. The value is an RFC 3339 formatted date-time value
     (1970-01-01T00:00:00Z).
       */
      public com.google.api.client.util.DateTime getPublishedBefore() {
        return publishedBefore;
      }

      /**
       * The publishedBefore parameter indicates that the API response should only contain resources
       * created before the specified time. The value is an RFC 3339 formatted date-time value
       * (1970-01-01T00:00:00Z).
       */
      public List setPublishedBefore(com.google.api.client.util.DateTime publishedBefore) {
        this.publishedBefore = publishedBefore;
        return this;
      }

      /**
       * The videoDimension parameter lets you restrict a search to only retrieve 2D or 3D videos.
       */
      @com.google.api.client.util.Key
      private java.lang.String videoDimension;

      /** The videoDimension parameter lets you restrict a search to only retrieve 2D or 3D videos.
       */
      public java.lang.String getVideoDimension() {
        return videoDimension;
      }

      /**
       * The videoDimension parameter lets you restrict a search to only retrieve 2D or 3D videos.
       */
      public List setVideoDimension(java.lang.String videoDimension) {
        this.videoDimension = videoDimension;
        return this;
      }

      /**
       * The videoLicense parameter filters search results to only include videos with a particular
       * license. YouTube lets video uploaders choose to attach either the Creative Commons license
       * or the standard YouTube license to each of their videos.
       */
      @com.google.api.client.util.Key
      private java.lang.String videoLicense;

      /** The videoLicense parameter filters search results to only include videos with a particular license.
     YouTube lets video uploaders choose to attach either the Creative Commons license or the standard
     YouTube license to each of their videos.
       */
      public java.lang.String getVideoLicense() {
        return videoLicense;
      }

      /**
       * The videoLicense parameter filters search results to only include videos with a particular
       * license. YouTube lets video uploaders choose to attach either the Creative Commons license
       * or the standard YouTube license to each of their videos.
       */
      public List setVideoLicense(java.lang.String videoLicense) {
        this.videoLicense = videoLicense;
        return this;
      }

      /**
       * The maxResults parameter specifies the maximum number of items that should be returned in
       * the result set.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maxResults parameter specifies the maximum number of items that should be returned in the
     result set. [default: 5] [minimum: 0] [maximum: 50]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maxResults parameter specifies the maximum number of items that should be returned in
       * the result set.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * The relatedToVideoId parameter retrieves a list of videos that are related to the video
       * that the parameter value identifies. The parameter value must be set to a YouTube video ID
       * and, if you are using this parameter, the type parameter must be set to video.
       */
      @com.google.api.client.util.Key
      private java.lang.String relatedToVideoId;

      /** The relatedToVideoId parameter retrieves a list of videos that are related to the video that the
     parameter value identifies. The parameter value must be set to a YouTube video ID and, if you are
     using this parameter, the type parameter must be set to video.
       */
      public java.lang.String getRelatedToVideoId() {
        return relatedToVideoId;
      }

      /**
       * The relatedToVideoId parameter retrieves a list of videos that are related to the video
       * that the parameter value identifies. The parameter value must be set to a YouTube video ID
       * and, if you are using this parameter, the type parameter must be set to video.
       */
      public List setRelatedToVideoId(java.lang.String relatedToVideoId) {
        this.relatedToVideoId = relatedToVideoId;
        return this;
      }

      /**
       * The videoDefinition parameter lets you restrict a search to only include either high
       * definition (HD) or standard definition (SD) videos. HD videos are available for playback in
       * at least 720p, though higher resolutions, like 1080p, might also be available.
       */
      @com.google.api.client.util.Key
      private java.lang.String videoDefinition;

      /** The videoDefinition parameter lets you restrict a search to only include either high definition
     (HD) or standard definition (SD) videos. HD videos are available for playback in at least 720p,
     though higher resolutions, like 1080p, might also be available.
       */
      public java.lang.String getVideoDefinition() {
        return videoDefinition;
      }

      /**
       * The videoDefinition parameter lets you restrict a search to only include either high
       * definition (HD) or standard definition (SD) videos. HD videos are available for playback in
       * at least 720p, though higher resolutions, like 1080p, might also be available.
       */
      public List setVideoDefinition(java.lang.String videoDefinition) {
        this.videoDefinition = videoDefinition;
        return this;
      }

      /** The videoDuration parameter filters video search results based on their duration. */
      @com.google.api.client.util.Key
      private java.lang.String videoDuration;

      /** The videoDuration parameter filters video search results based on their duration.
       */
      public java.lang.String getVideoDuration() {
        return videoDuration;
      }

      /** The videoDuration parameter filters video search results based on their duration. */
      public List setVideoDuration(java.lang.String videoDuration) {
        this.videoDuration = videoDuration;
        return this;
      }

      /**
       * The forMine parameter restricts the search to only retrieve videos owned by the
       * authenticated user. If you set this parameter to true, then the type parameter's value must
       * also be set to video.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean forMine;

      /** The forMine parameter restricts the search to only retrieve videos owned by the authenticated user.
     If you set this parameter to true, then the type parameter's value must also be set to video.
       */
      public java.lang.Boolean getForMine() {
        return forMine;
      }

      /**
       * The forMine parameter restricts the search to only retrieve videos owned by the
       * authenticated user. If you set this parameter to true, then the type parameter's value must
       * also be set to video.
       */
      public List setForMine(java.lang.Boolean forMine) {
        this.forMine = forMine;
        return this;
      }

      /** The q parameter specifies the query term to search for. */
      @com.google.api.client.util.Key
      private java.lang.String q;

      /** The q parameter specifies the query term to search for.
       */
      public java.lang.String getQ() {
        return q;
      }

      /** The q parameter specifies the query term to search for. */
      public List setQ(java.lang.String q) {
        this.q = q;
        return this;
      }

      /**
       * The safeSearch parameter indicates whether the search results should include restricted
       * content as well as standard content.
       */
      @com.google.api.client.util.Key
      private java.lang.String safeSearch;

      /** The safeSearch parameter indicates whether the search results should include restricted content as
     well as standard content.
       */
      public java.lang.String getSafeSearch() {
        return safeSearch;
      }

      /**
       * The safeSearch parameter indicates whether the search results should include restricted
       * content as well as standard content.
       */
      public List setSafeSearch(java.lang.String safeSearch) {
        this.safeSearch = safeSearch;
        return this;
      }

      /**
       * The videoEmbeddable parameter lets you to restrict a search to only videos that can be
       * embedded into a webpage.
       */
      @com.google.api.client.util.Key
      private java.lang.String videoEmbeddable;

      /** The videoEmbeddable parameter lets you to restrict a search to only videos that can be embedded
     into a webpage.
       */
      public java.lang.String getVideoEmbeddable() {
        return videoEmbeddable;
      }

      /**
       * The videoEmbeddable parameter lets you to restrict a search to only videos that can be
       * embedded into a webpage.
       */
      public List setVideoEmbeddable(java.lang.String videoEmbeddable) {
        this.videoEmbeddable = videoEmbeddable;
        return this;
      }

      /** The videoCategoryId parameter filters video search results based on their category. */
      @com.google.api.client.util.Key
      private java.lang.String videoCategoryId;

      /** The videoCategoryId parameter filters video search results based on their category.
       */
      public java.lang.String getVideoCategoryId() {
        return videoCategoryId;
      }

      /** The videoCategoryId parameter filters video search results based on their category. */
      public List setVideoCategoryId(java.lang.String videoCategoryId) {
        this.videoCategoryId = videoCategoryId;
        return this;
      }

      /**
       * The order parameter specifies the method that will be used to order resources in the API
       * response.
       */
      @com.google.api.client.util.Key
      private java.lang.String order;

      /** The order parameter specifies the method that will be used to order resources in the API response.
     [default: SEARCH_SORT_RELEVANCE]
       */
      public java.lang.String getOrder() {
        return order;
      }

      /**
       * The order parameter specifies the method that will be used to order resources in the API
       * response.
       */
      public List setOrder(java.lang.String order) {
        this.order = order;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Subscriptions collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.Subscriptions.List request = youtube.subscriptions().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Subscriptions subscriptions() {
    return new Subscriptions();
  }

  /**
   * The "subscriptions" collection of methods.
   */
  public class Subscriptions {

    /**
     * Deletes a subscription.
     *
     * Create a request for the method "subscriptions.delete".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param id The id parameter specifies the YouTube subscription ID for the resource that is being deleted. In a
     *        subscription resource, the id property specifies the YouTube subscription ID.
     * @return the request
     */
    public Delete delete(java.lang.String id) throws java.io.IOException {
      Delete result = new Delete(id);
      initialize(result);
      return result;
    }

    public class Delete extends YouTubeRequest<Void> {

      private static final String REST_PATH = "subscriptions";

      /**
       * Deletes a subscription.
       *
       * Create a request for the method "subscriptions.delete".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param id The id parameter specifies the YouTube subscription ID for the resource that is being deleted. In a
     *        subscription resource, the id property specifies the YouTube subscription ID.
       * @since 1.13
       */
      protected Delete(java.lang.String id) {
        super(YouTube.this, "DELETE", REST_PATH, null, Void.class);
        this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /**
       * The id parameter specifies the YouTube subscription ID for the resource that is being
       * deleted. In a subscription resource, the id property specifies the YouTube subscription ID.
       */
      @com.google.api.client.util.Key
      private java.lang.String id;

      /** The id parameter specifies the YouTube subscription ID for the resource that is being deleted. In a
     subscription resource, the id property specifies the YouTube subscription ID.
       */
      public java.lang.String getId() {
        return id;
      }

      /**
       * The id parameter specifies the YouTube subscription ID for the resource that is being
       * deleted. In a subscription resource, the id property specifies the YouTube subscription ID.
       */
      public Delete setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Adds a subscription for the authenticated user's channel.
     *
     * Create a request for the method "subscriptions.insert".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
    The
     *        part names that you can include in the parameter value are snippet and contentDetails.
     * @param content the {@link com.google.api.services.youtube.model.Subscription}
     * @return the request
     */
    public Insert insert(java.lang.String part, com.google.api.services.youtube.model.Subscription content) throws java.io.IOException {
      Insert result = new Insert(part, content);
      initialize(result);
      return result;
    }

    public class Insert extends YouTubeRequest<com.google.api.services.youtube.model.Subscription> {

      private static final String REST_PATH = "subscriptions";

      /**
       * Adds a subscription for the authenticated user's channel.
       *
       * Create a request for the method "subscriptions.insert".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
    The
     *        part names that you can include in the parameter value are snippet and contentDetails.
       * @param content the {@link com.google.api.services.youtube.model.Subscription}
       * @since 1.13
       */
      protected Insert(java.lang.String part, com.google.api.services.youtube.model.Subscription content) {
        super(YouTube.this, "POST", REST_PATH, content, com.google.api.services.youtube.model.Subscription.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /**
       * The part parameter serves two purposes in this operation. It identifies the properties that
       * the write operation will set as well as the properties that the API response will include.
       *
       * The part names that you can include in the parameter value are snippet and contentDetails.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter serves two purposes in this operation. It identifies the properties that the
     write operation will set as well as the properties that the API response will include.

     The part names that you can include in the parameter value are snippet and contentDetails.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter serves two purposes in this operation. It identifies the properties that
       * the write operation will set as well as the properties that the API response will include.
       *
       * The part names that you can include in the parameter value are snippet and contentDetails.
       */
      public Insert setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Returns subscription resources that match the API request criteria.
     *
     * Create a request for the method "subscriptions.list".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter specifies a comma-separated list of one or more subscription resource properties
     *        that the API response will include. The part names that you can include in the parameter
     *        value are id, snippet, and contentDetails.
    If the parameter identifies a property that
     *        contains child properties, the child properties will be included in the response. For
     *        example, in a subscription resource, the snippet property contains other properties, such
     *        as a display title for the subscription. If you set part=snippet, the API response will
     *        also contain all of those nested properties.
     * @return the request
     */
    public List list(java.lang.String part) throws java.io.IOException {
      List result = new List(part);
      initialize(result);
      return result;
    }

    public class List extends YouTubeRequest<com.google.api.services.youtube.model.SubscriptionListResponse> {

      private static final String REST_PATH = "subscriptions";

      /**
       * Returns subscription resources that match the API request criteria.
       *
       * Create a request for the method "subscriptions.list".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter specifies a comma-separated list of one or more subscription resource properties
     *        that the API response will include. The part names that you can include in the parameter
     *        value are id, snippet, and contentDetails.
    If the parameter identifies a property that
     *        contains child properties, the child properties will be included in the response. For
     *        example, in a subscription resource, the snippet property contains other properties, such
     *        as a display title for the subscription. If you set part=snippet, the API response will
     *        also contain all of those nested properties.
       * @since 1.13
       */
      protected List(java.lang.String part) {
        super(YouTube.this, "GET", REST_PATH, null, com.google.api.services.youtube.model.SubscriptionListResponse.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /**
       * The part parameter specifies a comma-separated list of one or more subscription resource
       * properties that the API response will include. The part names that you can include in the
       * parameter value are id, snippet, and contentDetails.
       *
       * If the parameter identifies a property that contains child properties, the child properties
       * will be included in the response. For example, in a subscription resource, the snippet
       * property contains other properties, such as a display title for the subscription. If you
       * set part=snippet, the API response will also contain all of those nested properties.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter specifies a comma-separated list of one or more subscription resource properties
     that the API response will include. The part names that you can include in the parameter value are
     id, snippet, and contentDetails.

     If the parameter identifies a property that contains child properties, the child properties will be
     included in the response. For example, in a subscription resource, the snippet property contains
     other properties, such as a display title for the subscription. If you set part=snippet, the API
     response will also contain all of those nested properties.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter specifies a comma-separated list of one or more subscription resource
       * properties that the API response will include. The part names that you can include in the
       * parameter value are id, snippet, and contentDetails.
       *
       * If the parameter identifies a property that contains child properties, the child properties
       * will be included in the response. For example, in a subscription resource, the snippet
       * property contains other properties, such as a display title for the subscription. If you
       * set part=snippet, the API response will also contain all of those nested properties.
       */
      public List setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The CMS account that the user authenticates with must be linked to the specified YouTube content
     owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public List setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      /**
       * This parameter can only be used in a properly authorized request. Note: This parameter is
       * intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel
       * to which a video is being added. This parameter is required when a request specifies a
       * value for the onBehalfOfContentOwner parameter, and it can only be used in conjunction with
       * that parameter. In addition, the request must be authorized using a CMS account that is
       * linked to the content owner that the onBehalfOfContentOwner parameter specifies. Finally,
       * the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be linked
       * to the content owner that the onBehalfOfContentOwner parameter specifies.
       *
       * This parameter is intended for YouTube content partners that own and manage many different
       * YouTube channels. It allows content owners to authenticate once and perform actions on
       * behalf of the channel specified in the parameter value, without having to provide
       * authentication credentials for each separate channel.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwnerChannel;

      /** This parameter can only be used in a properly authorized request. Note: This parameter is intended
     exclusively for YouTube content partners.

     The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel to
     which a video is being added. This parameter is required when a request specifies a value for the
     onBehalfOfContentOwner parameter, and it can only be used in conjunction with that parameter. In
     addition, the request must be authorized using a CMS account that is linked to the content owner
     that the onBehalfOfContentOwner parameter specifies. Finally, the channel that the
     onBehalfOfContentOwnerChannel parameter value specifies must be linked to the content owner that
     the onBehalfOfContentOwner parameter specifies.

     This parameter is intended for YouTube content partners that own and manage many different YouTube
     channels. It allows content owners to authenticate once and perform actions on behalf of the
     channel specified in the parameter value, without having to provide authentication credentials for
     each separate channel.
       */
      public java.lang.String getOnBehalfOfContentOwnerChannel() {
        return onBehalfOfContentOwnerChannel;
      }

      /**
       * This parameter can only be used in a properly authorized request. Note: This parameter is
       * intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel
       * to which a video is being added. This parameter is required when a request specifies a
       * value for the onBehalfOfContentOwner parameter, and it can only be used in conjunction with
       * that parameter. In addition, the request must be authorized using a CMS account that is
       * linked to the content owner that the onBehalfOfContentOwner parameter specifies. Finally,
       * the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be linked
       * to the content owner that the onBehalfOfContentOwner parameter specifies.
       *
       * This parameter is intended for YouTube content partners that own and manage many different
       * YouTube channels. It allows content owners to authenticate once and perform actions on
       * behalf of the channel specified in the parameter value, without having to provide
       * authentication credentials for each separate channel.
       */
      public List setOnBehalfOfContentOwnerChannel(java.lang.String onBehalfOfContentOwnerChannel) {
        this.onBehalfOfContentOwnerChannel = onBehalfOfContentOwnerChannel;
        return this;
      }

      /**
       * The channelId parameter specifies a YouTube channel ID. The API will only return that
       * channel's subscriptions.
       */
      @com.google.api.client.util.Key
      private java.lang.String channelId;

      /** The channelId parameter specifies a YouTube channel ID. The API will only return that channel's
     subscriptions.
       */
      public java.lang.String getChannelId() {
        return channelId;
      }

      /**
       * The channelId parameter specifies a YouTube channel ID. The API will only return that
       * channel's subscriptions.
       */
      public List setChannelId(java.lang.String channelId) {
        this.channelId = channelId;
        return this;
      }

      /**
       * Set this parameter's value to true to retrieve a feed of the authenticated user's
       * subscriptions.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean mine;

      /** Set this parameter's value to true to retrieve a feed of the authenticated user's subscriptions.
       */
      public java.lang.Boolean getMine() {
        return mine;
      }

      /**
       * Set this parameter's value to true to retrieve a feed of the authenticated user's
       * subscriptions.
       */
      public List setMine(java.lang.Boolean mine) {
        this.mine = mine;
        return this;
      }

      /**
       * The maxResults parameter specifies the maximum number of items that should be returned in
       * the result set.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maxResults parameter specifies the maximum number of items that should be returned in the
     result set. [default: 5] [minimum: 0] [maximum: 50]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maxResults parameter specifies the maximum number of items that should be returned in
       * the result set.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * The forChannelId parameter specifies a comma-separated list of channel IDs. The API
       * response will then only contain subscriptions matching those channels.
       */
      @com.google.api.client.util.Key
      private java.lang.String forChannelId;

      /** The forChannelId parameter specifies a comma-separated list of channel IDs. The API response will
     then only contain subscriptions matching those channels.
       */
      public java.lang.String getForChannelId() {
        return forChannelId;
      }

      /**
       * The forChannelId parameter specifies a comma-separated list of channel IDs. The API
       * response will then only contain subscriptions matching those channels.
       */
      public List setForChannelId(java.lang.String forChannelId) {
        this.forChannelId = forChannelId;
        return this;
      }

      /**
       * The pageToken parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The pageToken parameter identifies a specific page in the result set that should be returned. In an
     API response, the nextPageToken and prevPageToken properties identify other pages that could be
     retrieved.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * The pageToken parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Set this parameter's value to true to retrieve a feed of the subscribers of the
       * authenticated user.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean mySubscribers;

      /** Set this parameter's value to true to retrieve a feed of the subscribers of the authenticated user.
       */
      public java.lang.Boolean getMySubscribers() {
        return mySubscribers;
      }

      /**
       * Set this parameter's value to true to retrieve a feed of the subscribers of the
       * authenticated user.
       */
      public List setMySubscribers(java.lang.Boolean mySubscribers) {
        this.mySubscribers = mySubscribers;
        return this;
      }

      /**
       * The order parameter specifies the method that will be used to sort resources in the API
       * response.
       */
      @com.google.api.client.util.Key
      private java.lang.String order;

      /** The order parameter specifies the method that will be used to sort resources in the API response.
     [default: SUBSCRIPTION_ORDER_RELEVANCE]
       */
      public java.lang.String getOrder() {
        return order;
      }

      /**
       * The order parameter specifies the method that will be used to sort resources in the API
       * response.
       */
      public List setOrder(java.lang.String order) {
        this.order = order;
        return this;
      }

      /**
       * The id parameter specifies a comma-separated list of the YouTube subscription ID(s) for the
       * resource(s) that are being retrieved. In a subscription resource, the id property specifies
       * the YouTube subscription ID.
       */
      @com.google.api.client.util.Key
      private java.lang.String id;

      /** The id parameter specifies a comma-separated list of the YouTube subscription ID(s) for the
     resource(s) that are being retrieved. In a subscription resource, the id property specifies the
     YouTube subscription ID.
       */
      public java.lang.String getId() {
        return id;
      }

      /**
       * The id parameter specifies a comma-separated list of the YouTube subscription ID(s) for the
       * resource(s) that are being retrieved. In a subscription resource, the id property specifies
       * the YouTube subscription ID.
       */
      public List setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Thumbnails collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.Thumbnails.List request = youtube.thumbnails().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Thumbnails thumbnails() {
    return new Thumbnails();
  }

  /**
   * The "thumbnails" collection of methods.
   */
  public class Thumbnails {

    /**
     * Uploads a custom video thumbnail to YouTube and sets it for a video.
     *
     * Create a request for the method "thumbnails.set".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Set#execute()} method to invoke the remote operation.
     *
     * @param videoId The videoId parameter specifies a YouTube video ID for which the custom video thumbnail is being
     *        provided.
     * @return the request
     */
    public Set set(java.lang.String videoId) throws java.io.IOException {
      Set result = new Set(videoId);
      initialize(result);
      return result;
    }

    /**
     * Uploads a custom video thumbnail to YouTube and sets it for a video.
     *
     * Create a request for the method "thumbnails.set".
     *
     * This request holds the parameters needed by the the youtube server.  After setting any optional
     * parameters, call the {@link Set#execute()} method to invoke the remote operation.
     *
     * <p>
     * This method should be used for uploading media content.
     * </p>
     *
     * @param videoId The videoId parameter specifies a YouTube video ID for which the custom video thumbnail is being
     *        provided.
     * @param mediaContent The media HTTP content or {@code null} if none.
     * @return the request
     * @throws java.io.IOException if the initialization of the request fails
     */
    public Set set(java.lang.String videoId,
        com.google.api.client.http.AbstractInputStreamContent mediaContent) throws java.io.IOException {
      Set result = new Set(videoId, mediaContent);
      initialize(result);
      return result;
    }

    public class Set extends YouTubeRequest<com.google.api.services.youtube.model.ThumbnailSetResponse> {

      private static final String REST_PATH = "thumbnails/set";

      /**
       * Uploads a custom video thumbnail to YouTube and sets it for a video.
       *
       * Create a request for the method "thumbnails.set".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Set#execute()} method to invoke the remote operation. <p> {@link
       * Set#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param videoId The videoId parameter specifies a YouTube video ID for which the custom video thumbnail is being
     *        provided.
       * @since 1.13
       */
      protected Set(java.lang.String videoId) {
        super(YouTube.this, "POST", REST_PATH, null, com.google.api.services.youtube.model.ThumbnailSetResponse.class);
        this.videoId = com.google.api.client.util.Preconditions.checkNotNull(videoId, "Required parameter videoId must be specified.");
      }

      /**
       * Uploads a custom video thumbnail to YouTube and sets it for a video.
       *
       * Create a request for the method "thumbnails.set".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Set#execute()} method to invoke the remote operation. <p> {@link
       * Set#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * <p>
       * This constructor should be used for uploading media content.
       * </p>
       *
       * @param videoId The videoId parameter specifies a YouTube video ID for which the custom video thumbnail is being
     *        provided.
       * @param mediaContent The media HTTP content or {@code null} if none.
       * @since 1.13
       */
      protected Set(java.lang.String videoId,
          com.google.api.client.http.AbstractInputStreamContent mediaContent) {
        super(YouTube.this, "POST", "/upload/" + getServicePath() + REST_PATH, null, com.google.api.services.youtube.model.ThumbnailSetResponse.class);
        this.videoId = com.google.api.client.util.Preconditions.checkNotNull(videoId, "Required parameter videoId must be specified.");
        initializeMediaUpload(mediaContent);
      }

      @Override
      public Set setAlt(java.lang.String alt) {
        return (Set) super.setAlt(alt);
      }

      @Override
      public Set setFields(java.lang.String fields) {
        return (Set) super.setFields(fields);
      }

      @Override
      public Set setKey(java.lang.String key) {
        return (Set) super.setKey(key);
      }

      @Override
      public Set setOauthToken(java.lang.String oauthToken) {
        return (Set) super.setOauthToken(oauthToken);
      }

      @Override
      public Set setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Set) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Set setQuotaUser(java.lang.String quotaUser) {
        return (Set) super.setQuotaUser(quotaUser);
      }

      @Override
      public Set setUserIp(java.lang.String userIp) {
        return (Set) super.setUserIp(userIp);
      }

      /**
       * The videoId parameter specifies a YouTube video ID for which the custom video thumbnail is
       * being provided.
       */
      @com.google.api.client.util.Key
      private java.lang.String videoId;

      /** The videoId parameter specifies a YouTube video ID for which the custom video thumbnail is being
     provided.
       */
      public java.lang.String getVideoId() {
        return videoId;
      }

      /**
       * The videoId parameter specifies a YouTube video ID for which the custom video thumbnail is
       * being provided.
       */
      public Set setVideoId(java.lang.String videoId) {
        this.videoId = videoId;
        return this;
      }

      /**
       * The onBehalfOfContentOwner parameter indicates that the authenticated user is acting on
       * behalf of the content owner specified in the parameter value. This parameter is intended
       * for YouTube content partners that own and manage many different YouTube channels. It allows
       * content owners to authenticate once and get access to all their video and channel data,
       * without having to provide authentication credentials for each individual channel. The
       * actual CMS account that the user authenticates with needs to be linked to the specified
       * YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** The onBehalfOfContentOwner parameter indicates that the authenticated user is acting on behalf of
     the content owner specified in the parameter value. This parameter is intended for YouTube content
     partners that own and manage many different YouTube channels. It allows content owners to
     authenticate once and get access to all their video and channel data, without having to provide
     authentication credentials for each individual channel. The actual CMS account that the user
     authenticates with needs to be linked to the specified YouTube content owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * The onBehalfOfContentOwner parameter indicates that the authenticated user is acting on
       * behalf of the content owner specified in the parameter value. This parameter is intended
       * for YouTube content partners that own and manage many different YouTube channels. It allows
       * content owners to authenticate once and get access to all their video and channel data,
       * without having to provide authentication credentials for each individual channel. The
       * actual CMS account that the user authenticates with needs to be linked to the specified
       * YouTube content owner.
       */
      public Set setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      @Override
      public Set set(String parameterName, Object value) {
        return (Set) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the VideoCategories collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.VideoCategories.List request = youtube.videoCategories().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public VideoCategories videoCategories() {
    return new VideoCategories();
  }

  /**
   * The "videoCategories" collection of methods.
   */
  public class VideoCategories {

    /**
     * Returns a list of categories that can be associated with YouTube videos.
     *
     * Create a request for the method "videoCategories.list".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter specifies the videoCategory resource parts that the API response will include.
     *        Supported values are id and snippet.
     * @return the request
     */
    public List list(java.lang.String part) throws java.io.IOException {
      List result = new List(part);
      initialize(result);
      return result;
    }

    public class List extends YouTubeRequest<com.google.api.services.youtube.model.VideoCategoryListResponse> {

      private static final String REST_PATH = "videoCategories";

      /**
       * Returns a list of categories that can be associated with YouTube videos.
       *
       * Create a request for the method "videoCategories.list".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter specifies the videoCategory resource parts that the API response will include.
     *        Supported values are id and snippet.
       * @since 1.13
       */
      protected List(java.lang.String part) {
        super(YouTube.this, "GET", REST_PATH, null, com.google.api.services.youtube.model.VideoCategoryListResponse.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /**
       * The part parameter specifies the videoCategory resource parts that the API response will
       * include. Supported values are id and snippet.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter specifies the videoCategory resource parts that the API response will include.
     Supported values are id and snippet.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter specifies the videoCategory resource parts that the API response will
       * include. Supported values are id and snippet.
       */
      public List setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      /**
       * The regionCode parameter instructs the API to return the list of video categories available
       * in the specified country. The parameter value is an ISO 3166-1 alpha-2 country code.
       */
      @com.google.api.client.util.Key
      private java.lang.String regionCode;

      /** The regionCode parameter instructs the API to return the list of video categories available in the
     specified country. The parameter value is an ISO 3166-1 alpha-2 country code.
       */
      public java.lang.String getRegionCode() {
        return regionCode;
      }

      /**
       * The regionCode parameter instructs the API to return the list of video categories available
       * in the specified country. The parameter value is an ISO 3166-1 alpha-2 country code.
       */
      public List setRegionCode(java.lang.String regionCode) {
        this.regionCode = regionCode;
        return this;
      }

      /**
       * The id parameter specifies a comma-separated list of video category IDs for the resources
       * that you are retrieving.
       */
      @com.google.api.client.util.Key
      private java.lang.String id;

      /** The id parameter specifies a comma-separated list of video category IDs for the resources that you
     are retrieving.
       */
      public java.lang.String getId() {
        return id;
      }

      /**
       * The id parameter specifies a comma-separated list of video category IDs for the resources
       * that you are retrieving.
       */
      public List setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      /**
       * The hl parameter specifies the language that should be used for text values in the API
       * response.
       */
      @com.google.api.client.util.Key
      private java.lang.String hl;

      /** The hl parameter specifies the language that should be used for text values in the API response.
     [default: en_US]
       */
      public java.lang.String getHl() {
        return hl;
      }

      /**
       * The hl parameter specifies the language that should be used for text values in the API
       * response.
       */
      public List setHl(java.lang.String hl) {
        this.hl = hl;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Videos collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.Videos.List request = youtube.videos().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Videos videos() {
    return new Videos();
  }

  /**
   * The "videos" collection of methods.
   */
  public class Videos {

    /**
     * Deletes a YouTube video.
     *
     * Create a request for the method "videos.delete".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param id The id parameter specifies the YouTube video ID for the resource that is being deleted. In a video
     *        resource, the id property specifies the video's ID.
     * @return the request
     */
    public Delete delete(java.lang.String id) throws java.io.IOException {
      Delete result = new Delete(id);
      initialize(result);
      return result;
    }

    public class Delete extends YouTubeRequest<Void> {

      private static final String REST_PATH = "videos";

      /**
       * Deletes a YouTube video.
       *
       * Create a request for the method "videos.delete".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param id The id parameter specifies the YouTube video ID for the resource that is being deleted. In a video
     *        resource, the id property specifies the video's ID.
       * @since 1.13
       */
      protected Delete(java.lang.String id) {
        super(YouTube.this, "DELETE", REST_PATH, null, Void.class);
        this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /**
       * The id parameter specifies the YouTube video ID for the resource that is being deleted. In
       * a video resource, the id property specifies the video's ID.
       */
      @com.google.api.client.util.Key
      private java.lang.String id;

      /** The id parameter specifies the YouTube video ID for the resource that is being deleted. In a video
     resource, the id property specifies the video's ID.
       */
      public java.lang.String getId() {
        return id;
      }

      /**
       * The id parameter specifies the YouTube video ID for the resource that is being deleted. In
       * a video resource, the id property specifies the video's ID.
       */
      public Delete setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The actual CMS account that the user authenticates
       * with must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The actual CMS account that the user authenticates with must be linked to the specified YouTube
     content owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The actual CMS account that the user authenticates
       * with must be linked to the specified YouTube content owner.
       */
      public Delete setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the ratings that the authorized user gave to a list of specified videos.
     *
     * Create a request for the method "videos.getRating".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link GetRating#execute()} method to invoke the remote operation.
     *
     * @param id The id parameter specifies a comma-separated list of the YouTube video ID(s) for the resource(s) for
     *        which you are retrieving rating data. In a video resource, the id property specifies the
     *        video's ID.
     * @return the request
     */
    public GetRating getRating(java.lang.String id) throws java.io.IOException {
      GetRating result = new GetRating(id);
      initialize(result);
      return result;
    }

    public class GetRating extends YouTubeRequest<com.google.api.services.youtube.model.VideoGetRatingResponse> {

      private static final String REST_PATH = "videos/getRating";

      /**
       * Retrieves the ratings that the authorized user gave to a list of specified videos.
       *
       * Create a request for the method "videos.getRating".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link GetRating#execute()} method to invoke the remote operation. <p>
       * {@link
       * GetRating#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param id The id parameter specifies a comma-separated list of the YouTube video ID(s) for the resource(s) for
     *        which you are retrieving rating data. In a video resource, the id property specifies the
     *        video's ID.
       * @since 1.13
       */
      protected GetRating(java.lang.String id) {
        super(YouTube.this, "GET", REST_PATH, null, com.google.api.services.youtube.model.VideoGetRatingResponse.class);
        this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public GetRating setAlt(java.lang.String alt) {
        return (GetRating) super.setAlt(alt);
      }

      @Override
      public GetRating setFields(java.lang.String fields) {
        return (GetRating) super.setFields(fields);
      }

      @Override
      public GetRating setKey(java.lang.String key) {
        return (GetRating) super.setKey(key);
      }

      @Override
      public GetRating setOauthToken(java.lang.String oauthToken) {
        return (GetRating) super.setOauthToken(oauthToken);
      }

      @Override
      public GetRating setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (GetRating) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public GetRating setQuotaUser(java.lang.String quotaUser) {
        return (GetRating) super.setQuotaUser(quotaUser);
      }

      @Override
      public GetRating setUserIp(java.lang.String userIp) {
        return (GetRating) super.setUserIp(userIp);
      }

      /**
       * The id parameter specifies a comma-separated list of the YouTube video ID(s) for the
       * resource(s) for which you are retrieving rating data. In a video resource, the id property
       * specifies the video's ID.
       */
      @com.google.api.client.util.Key
      private java.lang.String id;

      /** The id parameter specifies a comma-separated list of the YouTube video ID(s) for the resource(s)
     for which you are retrieving rating data. In a video resource, the id property specifies the
     video's ID.
       */
      public java.lang.String getId() {
        return id;
      }

      /**
       * The id parameter specifies a comma-separated list of the YouTube video ID(s) for the
       * resource(s) for which you are retrieving rating data. In a video resource, the id property
       * specifies the video's ID.
       */
      public GetRating setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The CMS account that the user authenticates with must be linked to the specified YouTube content
     owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public GetRating setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      @Override
      public GetRating set(String parameterName, Object value) {
        return (GetRating) super.set(parameterName, value);
      }
    }
    /**
     * Uploads a video to YouTube and optionally sets the video's metadata.
     *
     * Create a request for the method "videos.insert".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
    The
     *        part names that you can include in the parameter value are snippet, contentDetails,
     *        fileDetails, liveStreamingDetails, player, processingDetails, recordingDetails,
     *        statistics, status, suggestions, and topicDetails. However, not all of those parts contain
     *        properties that can be set when setting or updating a video's metadata. For example, the
     *        statistics object encapsulates statistics that YouTube calculates for a video and does not
     *        contain values that you can set or modify. If the parameter value specifies a part that
     *        does not contain mutable values, that part will still be included in the API response.
     * @param content the {@link com.google.api.services.youtube.model.Video}
     * @return the request
     */
    public Insert insert(java.lang.String part, com.google.api.services.youtube.model.Video content) throws java.io.IOException {
      Insert result = new Insert(part, content);
      initialize(result);
      return result;
    }

    /**
     * Uploads a video to YouTube and optionally sets the video's metadata.
     *
     * Create a request for the method "videos.insert".
     *
     * This request holds the parameters needed by the the youtube server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * <p>
     * This method should be used for uploading media content.
     * </p>
     *
     * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
    The
     *        part names that you can include in the parameter value are snippet, contentDetails,
     *        fileDetails, liveStreamingDetails, player, processingDetails, recordingDetails,
     *        statistics, status, suggestions, and topicDetails. However, not all of those parts contain
     *        properties that can be set when setting or updating a video's metadata. For example, the
     *        statistics object encapsulates statistics that YouTube calculates for a video and does not
     *        contain values that you can set or modify. If the parameter value specifies a part that
     *        does not contain mutable values, that part will still be included in the API response.
     * @param content the {@link com.google.api.services.youtube.model.Video} media metadata or {@code null} if none
     * @param mediaContent The media HTTP content or {@code null} if none.
     * @return the request
     * @throws java.io.IOException if the initialization of the request fails
     */
    public Insert insert(java.lang.String part, com.google.api.services.youtube.model.Video content,
        com.google.api.client.http.AbstractInputStreamContent mediaContent) throws java.io.IOException {
      Insert result = new Insert(part, content, mediaContent);
      initialize(result);
      return result;
    }

    public class Insert extends YouTubeRequest<com.google.api.services.youtube.model.Video> {

      private static final String REST_PATH = "videos";

      /**
       * Uploads a video to YouTube and optionally sets the video's metadata.
       *
       * Create a request for the method "videos.insert".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
    The
     *        part names that you can include in the parameter value are snippet, contentDetails,
     *        fileDetails, liveStreamingDetails, player, processingDetails, recordingDetails,
     *        statistics, status, suggestions, and topicDetails. However, not all of those parts contain
     *        properties that can be set when setting or updating a video's metadata. For example, the
     *        statistics object encapsulates statistics that YouTube calculates for a video and does not
     *        contain values that you can set or modify. If the parameter value specifies a part that
     *        does not contain mutable values, that part will still be included in the API response.
       * @param content the {@link com.google.api.services.youtube.model.Video}
       * @since 1.13
       */
      protected Insert(java.lang.String part, com.google.api.services.youtube.model.Video content) {
        super(YouTube.this, "POST", REST_PATH, content, com.google.api.services.youtube.model.Video.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      /**
       * Uploads a video to YouTube and optionally sets the video's metadata.
       *
       * Create a request for the method "videos.insert".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * <p>
       * This constructor should be used for uploading media content.
       * </p>
       *
       * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
    The
     *        part names that you can include in the parameter value are snippet, contentDetails,
     *        fileDetails, liveStreamingDetails, player, processingDetails, recordingDetails,
     *        statistics, status, suggestions, and topicDetails. However, not all of those parts contain
     *        properties that can be set when setting or updating a video's metadata. For example, the
     *        statistics object encapsulates statistics that YouTube calculates for a video and does not
     *        contain values that you can set or modify. If the parameter value specifies a part that
     *        does not contain mutable values, that part will still be included in the API response.
       * @param content the {@link com.google.api.services.youtube.model.Video} media metadata or {@code null} if none
       * @param mediaContent The media HTTP content or {@code null} if none.
       * @since 1.13
       */
      protected Insert(java.lang.String part, com.google.api.services.youtube.model.Video content,
          com.google.api.client.http.AbstractInputStreamContent mediaContent) {
        super(YouTube.this, "POST", "/upload/" + getServicePath() + REST_PATH, content, com.google.api.services.youtube.model.Video.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
        initializeMediaUpload(mediaContent);
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /**
       * The part parameter serves two purposes in this operation. It identifies the properties that
       * the write operation will set as well as the properties that the API response will include.
       *
       * The part names that you can include in the parameter value are snippet, contentDetails,
       * fileDetails, liveStreamingDetails, player, processingDetails, recordingDetails, statistics,
       * status, suggestions, and topicDetails. However, not all of those parts contain properties
       * that can be set when setting or updating a video's metadata. For example, the statistics
       * object encapsulates statistics that YouTube calculates for a video and does not contain
       * values that you can set or modify. If the parameter value specifies a part that does not
       * contain mutable values, that part will still be included in the API response.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter serves two purposes in this operation. It identifies the properties that the
     write operation will set as well as the properties that the API response will include.

     The part names that you can include in the parameter value are snippet, contentDetails,
     fileDetails, liveStreamingDetails, player, processingDetails, recordingDetails, statistics, status,
     suggestions, and topicDetails. However, not all of those parts contain properties that can be set
     when setting or updating a video's metadata. For example, the statistics object encapsulates
     statistics that YouTube calculates for a video and does not contain values that you can set or
     modify. If the parameter value specifies a part that does not contain mutable values, that part
     will still be included in the API response.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter serves two purposes in this operation. It identifies the properties that
       * the write operation will set as well as the properties that the API response will include.
       *
       * The part names that you can include in the parameter value are snippet, contentDetails,
       * fileDetails, liveStreamingDetails, player, processingDetails, recordingDetails, statistics,
       * status, suggestions, and topicDetails. However, not all of those parts contain properties
       * that can be set when setting or updating a video's metadata. For example, the statistics
       * object encapsulates statistics that YouTube calculates for a video and does not contain
       * values that you can set or modify. If the parameter value specifies a part that does not
       * contain mutable values, that part will still be included in the API response.
       */
      public Insert setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The CMS account that the user authenticates with must be linked to the specified YouTube content
     owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public Insert setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      /**
       * The stabilize parameter indicates whether YouTube should adjust the video to remove shaky
       * camera motions.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean stabilize;

      /** The stabilize parameter indicates whether YouTube should adjust the video to remove shaky camera
     motions.
       */
      public java.lang.Boolean getStabilize() {
        return stabilize;
      }

      /**
       * The stabilize parameter indicates whether YouTube should adjust the video to remove shaky
       * camera motions.
       */
      public Insert setStabilize(java.lang.Boolean stabilize) {
        this.stabilize = stabilize;
        return this;
      }

      /**
       * This parameter can only be used in a properly authorized request. Note: This parameter is
       * intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel
       * to which a video is being added. This parameter is required when a request specifies a
       * value for the onBehalfOfContentOwner parameter, and it can only be used in conjunction with
       * that parameter. In addition, the request must be authorized using a CMS account that is
       * linked to the content owner that the onBehalfOfContentOwner parameter specifies. Finally,
       * the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be linked
       * to the content owner that the onBehalfOfContentOwner parameter specifies.
       *
       * This parameter is intended for YouTube content partners that own and manage many different
       * YouTube channels. It allows content owners to authenticate once and perform actions on
       * behalf of the channel specified in the parameter value, without having to provide
       * authentication credentials for each separate channel.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwnerChannel;

      /** This parameter can only be used in a properly authorized request. Note: This parameter is intended
     exclusively for YouTube content partners.

     The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel to
     which a video is being added. This parameter is required when a request specifies a value for the
     onBehalfOfContentOwner parameter, and it can only be used in conjunction with that parameter. In
     addition, the request must be authorized using a CMS account that is linked to the content owner
     that the onBehalfOfContentOwner parameter specifies. Finally, the channel that the
     onBehalfOfContentOwnerChannel parameter value specifies must be linked to the content owner that
     the onBehalfOfContentOwner parameter specifies.

     This parameter is intended for YouTube content partners that own and manage many different YouTube
     channels. It allows content owners to authenticate once and perform actions on behalf of the
     channel specified in the parameter value, without having to provide authentication credentials for
     each separate channel.
       */
      public java.lang.String getOnBehalfOfContentOwnerChannel() {
        return onBehalfOfContentOwnerChannel;
      }

      /**
       * This parameter can only be used in a properly authorized request. Note: This parameter is
       * intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel
       * to which a video is being added. This parameter is required when a request specifies a
       * value for the onBehalfOfContentOwner parameter, and it can only be used in conjunction with
       * that parameter. In addition, the request must be authorized using a CMS account that is
       * linked to the content owner that the onBehalfOfContentOwner parameter specifies. Finally,
       * the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be linked
       * to the content owner that the onBehalfOfContentOwner parameter specifies.
       *
       * This parameter is intended for YouTube content partners that own and manage many different
       * YouTube channels. It allows content owners to authenticate once and perform actions on
       * behalf of the channel specified in the parameter value, without having to provide
       * authentication credentials for each separate channel.
       */
      public Insert setOnBehalfOfContentOwnerChannel(java.lang.String onBehalfOfContentOwnerChannel) {
        this.onBehalfOfContentOwnerChannel = onBehalfOfContentOwnerChannel;
        return this;
      }

      /**
       * The notifySubscribers parameter indicates whether YouTube should send notification to
       * subscribers about the inserted video.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean notifySubscribers;

      /** The notifySubscribers parameter indicates whether YouTube should send notification to subscribers
     about the inserted video. [default: true]
       */
      public java.lang.Boolean getNotifySubscribers() {
        return notifySubscribers;
      }

      /**
       * The notifySubscribers parameter indicates whether YouTube should send notification to
       * subscribers about the inserted video.
       */
      public Insert setNotifySubscribers(java.lang.Boolean notifySubscribers) {
        this.notifySubscribers = notifySubscribers;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * The notifySubscribers parameter indicates whether YouTube should send notification to subscribers
     about the inserted video.
       * </p>
       */
      public boolean isNotifySubscribers() {
        if (notifySubscribers == null || notifySubscribers == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return true;
        }
        return notifySubscribers;
      }

      /**
       * The autoLevels parameter indicates whether YouTube should automatically enhance the video's
       * lighting and color.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean autoLevels;

      /** The autoLevels parameter indicates whether YouTube should automatically enhance the video's
     lighting and color.
       */
      public java.lang.Boolean getAutoLevels() {
        return autoLevels;
      }

      /**
       * The autoLevels parameter indicates whether YouTube should automatically enhance the video's
       * lighting and color.
       */
      public Insert setAutoLevels(java.lang.Boolean autoLevels) {
        this.autoLevels = autoLevels;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Returns a list of videos that match the API request parameters.
     *
     * Create a request for the method "videos.list".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter specifies a comma-separated list of one or more video resource properties that
     *        the API response will include. The part names that you can include in the parameter value
     *        are id, snippet, contentDetails, fileDetails, liveStreamingDetails, player,
     *        processingDetails, recordingDetails, statistics, status, suggestions, and topicDetails.
    If
     *        the parameter identifies a property that contains child properties, the child properties
     *        will be included in the response. For example, in a video resource, the snippet property
     *        contains the channelId, title, description, tags, and categoryId properties. As such, if
     *        you set part=snippet, the API response will contain all of those properties.
     * @return the request
     */
    public List list(java.lang.String part) throws java.io.IOException {
      List result = new List(part);
      initialize(result);
      return result;
    }

    public class List extends YouTubeRequest<com.google.api.services.youtube.model.VideoListResponse> {

      private static final String REST_PATH = "videos";

      /**
       * Returns a list of videos that match the API request parameters.
       *
       * Create a request for the method "videos.list".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter specifies a comma-separated list of one or more video resource properties that
     *        the API response will include. The part names that you can include in the parameter value
     *        are id, snippet, contentDetails, fileDetails, liveStreamingDetails, player,
     *        processingDetails, recordingDetails, statistics, status, suggestions, and topicDetails.
    If
     *        the parameter identifies a property that contains child properties, the child properties
     *        will be included in the response. For example, in a video resource, the snippet property
     *        contains the channelId, title, description, tags, and categoryId properties. As such, if
     *        you set part=snippet, the API response will contain all of those properties.
       * @since 1.13
       */
      protected List(java.lang.String part) {
        super(YouTube.this, "GET", REST_PATH, null, com.google.api.services.youtube.model.VideoListResponse.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /**
       * The part parameter specifies a comma-separated list of one or more video resource
       * properties that the API response will include. The part names that you can include in the
       * parameter value are id, snippet, contentDetails, fileDetails, liveStreamingDetails, player,
       * processingDetails, recordingDetails, statistics, status, suggestions, and topicDetails.
       *
       * If the parameter identifies a property that contains child properties, the child properties
       * will be included in the response. For example, in a video resource, the snippet property
       * contains the channelId, title, description, tags, and categoryId properties. As such, if
       * you set part=snippet, the API response will contain all of those properties.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter specifies a comma-separated list of one or more video resource properties that
     the API response will include. The part names that you can include in the parameter value are id,
     snippet, contentDetails, fileDetails, liveStreamingDetails, player, processingDetails,
     recordingDetails, statistics, status, suggestions, and topicDetails.

     If the parameter identifies a property that contains child properties, the child properties will be
     included in the response. For example, in a video resource, the snippet property contains the
     channelId, title, description, tags, and categoryId properties. As such, if you set part=snippet,
     the API response will contain all of those properties.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter specifies a comma-separated list of one or more video resource
       * properties that the API response will include. The part names that you can include in the
       * parameter value are id, snippet, contentDetails, fileDetails, liveStreamingDetails, player,
       * processingDetails, recordingDetails, statistics, status, suggestions, and topicDetails.
       *
       * If the parameter identifies a property that contains child properties, the child properties
       * will be included in the response. For example, in a video resource, the snippet property
       * contains the channelId, title, description, tags, and categoryId properties. As such, if
       * you set part=snippet, the API response will contain all of those properties.
       */
      public List setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The CMS account that the user authenticates with must be linked to the specified YouTube content
     owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public List setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      /**
       * The regionCode parameter instructs the API to select a video chart available in the
       * specified region. This parameter can only be used in conjunction with the chart parameter.
       * The parameter value is an ISO 3166-1 alpha-2 country code.
       */
      @com.google.api.client.util.Key
      private java.lang.String regionCode;

      /** The regionCode parameter instructs the API to select a video chart available in the specified
     region. This parameter can only be used in conjunction with the chart parameter. The parameter
     value is an ISO 3166-1 alpha-2 country code.
       */
      public java.lang.String getRegionCode() {
        return regionCode;
      }

      /**
       * The regionCode parameter instructs the API to select a video chart available in the
       * specified region. This parameter can only be used in conjunction with the chart parameter.
       * The parameter value is an ISO 3166-1 alpha-2 country code.
       */
      public List setRegionCode(java.lang.String regionCode) {
        this.regionCode = regionCode;
        return this;
      }

      /** DEPRECATED */
      @com.google.api.client.util.Key
      private java.lang.String locale;

      /** DEPRECATED
       */
      public java.lang.String getLocale() {
        return locale;
      }

      /** DEPRECATED */
      public List setLocale(java.lang.String locale) {
        this.locale = locale;
        return this;
      }

      /**
       * The videoCategoryId parameter identifies the video category for which the chart should be
       * retrieved. This parameter can only be used in conjunction with the chart parameter. By
       * default, charts are not restricted to a particular category.
       */
      @com.google.api.client.util.Key
      private java.lang.String videoCategoryId;

      /** The videoCategoryId parameter identifies the video category for which the chart should be
     retrieved. This parameter can only be used in conjunction with the chart parameter. By default,
     charts are not restricted to a particular category. [default: 0]
       */
      public java.lang.String getVideoCategoryId() {
        return videoCategoryId;
      }

      /**
       * The videoCategoryId parameter identifies the video category for which the chart should be
       * retrieved. This parameter can only be used in conjunction with the chart parameter. By
       * default, charts are not restricted to a particular category.
       */
      public List setVideoCategoryId(java.lang.String videoCategoryId) {
        this.videoCategoryId = videoCategoryId;
        return this;
      }

      /** The chart parameter identifies the chart that you want to retrieve. */
      @com.google.api.client.util.Key
      private java.lang.String chart;

      /** The chart parameter identifies the chart that you want to retrieve.
       */
      public java.lang.String getChart() {
        return chart;
      }

      /** The chart parameter identifies the chart that you want to retrieve. */
      public List setChart(java.lang.String chart) {
        this.chart = chart;
        return this;
      }

      /**
       * The maxResults parameter specifies the maximum number of items that should be returned in
       * the result set.
       *
       * Note: This parameter is supported for use in conjunction with the myRating parameter, but
       * it is not supported for use in conjunction with the id parameter.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maxResults parameter specifies the maximum number of items that should be returned in the
     result set.

     Note: This parameter is supported for use in conjunction with the myRating parameter, but it is not
     supported for use in conjunction with the id parameter. [default: 5] [minimum: 1] [maximum: 50]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maxResults parameter specifies the maximum number of items that should be returned in
       * the result set.
       *
       * Note: This parameter is supported for use in conjunction with the myRating parameter, but
       * it is not supported for use in conjunction with the id parameter.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * The pageToken parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved.
       *
       * Note: This parameter is supported for use in conjunction with the myRating parameter, but
       * it is not supported for use in conjunction with the id parameter.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The pageToken parameter identifies a specific page in the result set that should be returned. In an
     API response, the nextPageToken and prevPageToken properties identify other pages that could be
     retrieved.

     Note: This parameter is supported for use in conjunction with the myRating parameter, but it is not
     supported for use in conjunction with the id parameter.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * The pageToken parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved.
       *
       * Note: This parameter is supported for use in conjunction with the myRating parameter, but
       * it is not supported for use in conjunction with the id parameter.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Set this parameter's value to like or dislike to instruct the API to only return videos
       * liked or disliked by the authenticated user.
       */
      @com.google.api.client.util.Key
      private java.lang.String myRating;

      /** Set this parameter's value to like or dislike to instruct the API to only return videos liked or
     disliked by the authenticated user.
       */
      public java.lang.String getMyRating() {
        return myRating;
      }

      /**
       * Set this parameter's value to like or dislike to instruct the API to only return videos
       * liked or disliked by the authenticated user.
       */
      public List setMyRating(java.lang.String myRating) {
        this.myRating = myRating;
        return this;
      }

      /**
       * The id parameter specifies a comma-separated list of the YouTube video ID(s) for the
       * resource(s) that are being retrieved. In a video resource, the id property specifies the
       * video's ID.
       */
      @com.google.api.client.util.Key
      private java.lang.String id;

      /** The id parameter specifies a comma-separated list of the YouTube video ID(s) for the resource(s)
     that are being retrieved. In a video resource, the id property specifies the video's ID.
       */
      public java.lang.String getId() {
        return id;
      }

      /**
       * The id parameter specifies a comma-separated list of the YouTube video ID(s) for the
       * resource(s) that are being retrieved. In a video resource, the id property specifies the
       * video's ID.
       */
      public List setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Add a like or dislike rating to a video or remove a rating from a video.
     *
     * Create a request for the method "videos.rate".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Rate#execute()} method to invoke the remote operation.
     *
     * @param id The id parameter specifies the YouTube video ID of the video that is being rated or having its
     *        rating removed.
     * @param rating Specifies the rating to record.
     * @return the request
     */
    public Rate rate(java.lang.String id, java.lang.String rating) throws java.io.IOException {
      Rate result = new Rate(id, rating);
      initialize(result);
      return result;
    }

    public class Rate extends YouTubeRequest<Void> {

      private static final String REST_PATH = "videos/rate";

      /**
       * Add a like or dislike rating to a video or remove a rating from a video.
       *
       * Create a request for the method "videos.rate".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Rate#execute()} method to invoke the remote operation. <p> {@link
       * Rate#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param id The id parameter specifies the YouTube video ID of the video that is being rated or having its
     *        rating removed.
       * @param rating Specifies the rating to record.
       * @since 1.13
       */
      protected Rate(java.lang.String id, java.lang.String rating) {
        super(YouTube.this, "POST", REST_PATH, null, Void.class);
        this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
        this.rating = com.google.api.client.util.Preconditions.checkNotNull(rating, "Required parameter rating must be specified.");
      }

      @Override
      public Rate setAlt(java.lang.String alt) {
        return (Rate) super.setAlt(alt);
      }

      @Override
      public Rate setFields(java.lang.String fields) {
        return (Rate) super.setFields(fields);
      }

      @Override
      public Rate setKey(java.lang.String key) {
        return (Rate) super.setKey(key);
      }

      @Override
      public Rate setOauthToken(java.lang.String oauthToken) {
        return (Rate) super.setOauthToken(oauthToken);
      }

      @Override
      public Rate setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Rate) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Rate setQuotaUser(java.lang.String quotaUser) {
        return (Rate) super.setQuotaUser(quotaUser);
      }

      @Override
      public Rate setUserIp(java.lang.String userIp) {
        return (Rate) super.setUserIp(userIp);
      }

      /**
       * The id parameter specifies the YouTube video ID of the video that is being rated or having
       * its rating removed.
       */
      @com.google.api.client.util.Key
      private java.lang.String id;

      /** The id parameter specifies the YouTube video ID of the video that is being rated or having its
     rating removed.
       */
      public java.lang.String getId() {
        return id;
      }

      /**
       * The id parameter specifies the YouTube video ID of the video that is being rated or having
       * its rating removed.
       */
      public Rate setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      /** Specifies the rating to record. */
      @com.google.api.client.util.Key
      private java.lang.String rating;

      /** Specifies the rating to record.
       */
      public java.lang.String getRating() {
        return rating;
      }

      /** Specifies the rating to record. */
      public Rate setRating(java.lang.String rating) {
        this.rating = rating;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The CMS account that the user authenticates with must be linked to the specified YouTube content
     owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public Rate setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      @Override
      public Rate set(String parameterName, Object value) {
        return (Rate) super.set(parameterName, value);
      }
    }
    /**
     * Updates a video's metadata.
     *
     * Create a request for the method "videos.update".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
    The
     *        part names that you can include in the parameter value are snippet, contentDetails,
     *        fileDetails, liveStreamingDetails, player, processingDetails, recordingDetails,
     *        statistics, status, suggestions, and topicDetails.
    Note that this method will override the
     *        existing values for all of the mutable properties that are contained in any parts that the
     *        parameter value specifies. For example, a video's privacy setting is contained in the
     *        status part. As such, if your request is updating a private video, and the request's part
     *        parameter value includes the status part, the video's privacy setting will be updated to
     *        whatever value the request body specifies. If the request body does not specify a value,
     *        the existing privacy setting will be removed and the video will revert to the default
     *        privacy setting.
    In addition, not all of those parts contain properties that can be set
     *        when setting or updating a video's metadata. For example, the statistics object
     *        encapsulates statistics that YouTube calculates for a video and does not contain values
     *        that you can set or modify. If the parameter value specifies a part that does not contain
     *        mutable values, that part will still be included in the API response.
     * @param content the {@link com.google.api.services.youtube.model.Video}
     * @return the request
     */
    public Update update(java.lang.String part, com.google.api.services.youtube.model.Video content) throws java.io.IOException {
      Update result = new Update(part, content);
      initialize(result);
      return result;
    }

    public class Update extends YouTubeRequest<com.google.api.services.youtube.model.Video> {

      private static final String REST_PATH = "videos";

      /**
       * Updates a video's metadata.
       *
       * Create a request for the method "videos.update".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
    The
     *        part names that you can include in the parameter value are snippet, contentDetails,
     *        fileDetails, liveStreamingDetails, player, processingDetails, recordingDetails,
     *        statistics, status, suggestions, and topicDetails.
    Note that this method will override the
     *        existing values for all of the mutable properties that are contained in any parts that the
     *        parameter value specifies. For example, a video's privacy setting is contained in the
     *        status part. As such, if your request is updating a private video, and the request's part
     *        parameter value includes the status part, the video's privacy setting will be updated to
     *        whatever value the request body specifies. If the request body does not specify a value,
     *        the existing privacy setting will be removed and the video will revert to the default
     *        privacy setting.
    In addition, not all of those parts contain properties that can be set
     *        when setting or updating a video's metadata. For example, the statistics object
     *        encapsulates statistics that YouTube calculates for a video and does not contain values
     *        that you can set or modify. If the parameter value specifies a part that does not contain
     *        mutable values, that part will still be included in the API response.
       * @param content the {@link com.google.api.services.youtube.model.Video}
       * @since 1.13
       */
      protected Update(java.lang.String part, com.google.api.services.youtube.model.Video content) {
        super(YouTube.this, "PUT", REST_PATH, content, com.google.api.services.youtube.model.Video.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
        checkRequiredParameter(content, "content");
        checkRequiredParameter(content.getId(), "Video.getId()");
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /**
       * The part parameter serves two purposes in this operation. It identifies the properties that
       * the write operation will set as well as the properties that the API response will include.
       *
       * The part names that you can include in the parameter value are snippet, contentDetails,
       * fileDetails, liveStreamingDetails, player, processingDetails, recordingDetails, statistics,
       * status, suggestions, and topicDetails.
       *
       * Note that this method will override the existing values for all of the mutable properties
       * that are contained in any parts that the parameter value specifies. For example, a video's
       * privacy setting is contained in the status part. As such, if your request is updating a
       * private video, and the request's part parameter value includes the status part, the video's
       * privacy setting will be updated to whatever value the request body specifies. If the
       * request body does not specify a value, the existing privacy setting will be removed and the
       * video will revert to the default privacy setting.
       *
       * In addition, not all of those parts contain properties that can be set when setting or
       * updating a video's metadata. For example, the statistics object encapsulates statistics
       * that YouTube calculates for a video and does not contain values that you can set or modify.
       * If the parameter value specifies a part that does not contain mutable values, that part
       * will still be included in the API response.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter serves two purposes in this operation. It identifies the properties that the
     write operation will set as well as the properties that the API response will include.

     The part names that you can include in the parameter value are snippet, contentDetails,
     fileDetails, liveStreamingDetails, player, processingDetails, recordingDetails, statistics, status,
     suggestions, and topicDetails.

     Note that this method will override the existing values for all of the mutable properties that are
     contained in any parts that the parameter value specifies. For example, a video's privacy setting
     is contained in the status part. As such, if your request is updating a private video, and the
     request's part parameter value includes the status part, the video's privacy setting will be
     updated to whatever value the request body specifies. If the request body does not specify a value,
     the existing privacy setting will be removed and the video will revert to the default privacy
     setting.

     In addition, not all of those parts contain properties that can be set when setting or updating a
     video's metadata. For example, the statistics object encapsulates statistics that YouTube
     calculates for a video and does not contain values that you can set or modify. If the parameter
     value specifies a part that does not contain mutable values, that part will still be included in
     the API response.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter serves two purposes in this operation. It identifies the properties that
       * the write operation will set as well as the properties that the API response will include.
       *
       * The part names that you can include in the parameter value are snippet, contentDetails,
       * fileDetails, liveStreamingDetails, player, processingDetails, recordingDetails, statistics,
       * status, suggestions, and topicDetails.
       *
       * Note that this method will override the existing values for all of the mutable properties
       * that are contained in any parts that the parameter value specifies. For example, a video's
       * privacy setting is contained in the status part. As such, if your request is updating a
       * private video, and the request's part parameter value includes the status part, the video's
       * privacy setting will be updated to whatever value the request body specifies. If the
       * request body does not specify a value, the existing privacy setting will be removed and the
       * video will revert to the default privacy setting.
       *
       * In addition, not all of those parts contain properties that can be set when setting or
       * updating a video's metadata. For example, the statistics object encapsulates statistics
       * that YouTube calculates for a video and does not contain values that you can set or modify.
       * If the parameter value specifies a part that does not contain mutable values, that part
       * will still be included in the API response.
       */
      public Update setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The actual CMS account that the user authenticates
       * with must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The actual CMS account that the user authenticates with must be linked to the specified YouTube
     content owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The actual CMS account that the user authenticates
       * with must be linked to the specified YouTube content owner.
       */
      public Update setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Watermarks collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.Watermarks.List request = youtube.watermarks().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Watermarks watermarks() {
    return new Watermarks();
  }

  /**
   * The "watermarks" collection of methods.
   */
  public class Watermarks {

    /**
     * Uploads a watermark image to YouTube and sets it for a channel.
     *
     * Create a request for the method "watermarks.set".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Set#execute()} method to invoke the remote operation.
     *
     * @param channelId The channelId parameter specifies a YouTube channel ID for which the watermark is being provided.
     * @param content the {@link com.google.api.services.youtube.model.InvideoBranding}
     * @return the request
     */
    public Set set(java.lang.String channelId, com.google.api.services.youtube.model.InvideoBranding content) throws java.io.IOException {
      Set result = new Set(channelId, content);
      initialize(result);
      return result;
    }

    /**
     * Uploads a watermark image to YouTube and sets it for a channel.
     *
     * Create a request for the method "watermarks.set".
     *
     * This request holds the parameters needed by the the youtube server.  After setting any optional
     * parameters, call the {@link Set#execute()} method to invoke the remote operation.
     *
     * <p>
     * This method should be used for uploading media content.
     * </p>
     *
     * @param channelId The channelId parameter specifies a YouTube channel ID for which the watermark is being provided.
     * @param content the {@link com.google.api.services.youtube.model.InvideoBranding} media metadata or {@code null} if none
     * @param mediaContent The media HTTP content or {@code null} if none.
     * @return the request
     * @throws java.io.IOException if the initialization of the request fails
     */
    public Set set(java.lang.String channelId, com.google.api.services.youtube.model.InvideoBranding content,
        com.google.api.client.http.AbstractInputStreamContent mediaContent) throws java.io.IOException {
      Set result = new Set(channelId, content, mediaContent);
      initialize(result);
      return result;
    }

    public class Set extends YouTubeRequest<Void> {

      private static final String REST_PATH = "watermarks/set";

      /**
       * Uploads a watermark image to YouTube and sets it for a channel.
       *
       * Create a request for the method "watermarks.set".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Set#execute()} method to invoke the remote operation. <p> {@link
       * Set#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param channelId The channelId parameter specifies a YouTube channel ID for which the watermark is being provided.
       * @param content the {@link com.google.api.services.youtube.model.InvideoBranding}
       * @since 1.13
       */
      protected Set(java.lang.String channelId, com.google.api.services.youtube.model.InvideoBranding content) {
        super(YouTube.this, "POST", REST_PATH, content, Void.class);
        this.channelId = com.google.api.client.util.Preconditions.checkNotNull(channelId, "Required parameter channelId must be specified.");
      }

      /**
       * Uploads a watermark image to YouTube and sets it for a channel.
       *
       * Create a request for the method "watermarks.set".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Set#execute()} method to invoke the remote operation. <p> {@link
       * Set#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * <p>
       * This constructor should be used for uploading media content.
       * </p>
       *
       * @param channelId The channelId parameter specifies a YouTube channel ID for which the watermark is being provided.
       * @param content the {@link com.google.api.services.youtube.model.InvideoBranding} media metadata or {@code null} if none
       * @param mediaContent The media HTTP content or {@code null} if none.
       * @since 1.13
       */
      protected Set(java.lang.String channelId, com.google.api.services.youtube.model.InvideoBranding content,
          com.google.api.client.http.AbstractInputStreamContent mediaContent) {
        super(YouTube.this, "POST", "/upload/" + getServicePath() + REST_PATH, content, Void.class);
        this.channelId = com.google.api.client.util.Preconditions.checkNotNull(channelId, "Required parameter channelId must be specified.");
        initializeMediaUpload(mediaContent);
      }

      @Override
      public Set setAlt(java.lang.String alt) {
        return (Set) super.setAlt(alt);
      }

      @Override
      public Set setFields(java.lang.String fields) {
        return (Set) super.setFields(fields);
      }

      @Override
      public Set setKey(java.lang.String key) {
        return (Set) super.setKey(key);
      }

      @Override
      public Set setOauthToken(java.lang.String oauthToken) {
        return (Set) super.setOauthToken(oauthToken);
      }

      @Override
      public Set setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Set) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Set setQuotaUser(java.lang.String quotaUser) {
        return (Set) super.setQuotaUser(quotaUser);
      }

      @Override
      public Set setUserIp(java.lang.String userIp) {
        return (Set) super.setUserIp(userIp);
      }

      /**
       * The channelId parameter specifies a YouTube channel ID for which the watermark is being
       * provided.
       */
      @com.google.api.client.util.Key
      private java.lang.String channelId;

      /** The channelId parameter specifies a YouTube channel ID for which the watermark is being provided.
       */
      public java.lang.String getChannelId() {
        return channelId;
      }

      /**
       * The channelId parameter specifies a YouTube channel ID for which the watermark is being
       * provided.
       */
      public Set setChannelId(java.lang.String channelId) {
        this.channelId = channelId;
        return this;
      }

      /**
       * The onBehalfOfContentOwner parameter indicates that the authenticated user is acting on
       * behalf of the content owner specified in the parameter value. This parameter is intended
       * for YouTube content partners that own and manage many different YouTube channels. It allows
       * content owners to authenticate once and get access to all their video and channel data,
       * without having to provide authentication credentials for each individual channel. The
       * actual CMS account that the user authenticates with needs to be linked to the specified
       * YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** The onBehalfOfContentOwner parameter indicates that the authenticated user is acting on behalf of
     the content owner specified in the parameter value. This parameter is intended for YouTube content
     partners that own and manage many different YouTube channels. It allows content owners to
     authenticate once and get access to all their video and channel data, without having to provide
     authentication credentials for each individual channel. The actual CMS account that the user
     authenticates with needs to be linked to the specified YouTube content owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * The onBehalfOfContentOwner parameter indicates that the authenticated user is acting on
       * behalf of the content owner specified in the parameter value. This parameter is intended
       * for YouTube content partners that own and manage many different YouTube channels. It allows
       * content owners to authenticate once and get access to all their video and channel data,
       * without having to provide authentication credentials for each individual channel. The
       * actual CMS account that the user authenticates with needs to be linked to the specified
       * YouTube content owner.
       */
      public Set setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      @Override
      public Set set(String parameterName, Object value) {
        return (Set) super.set(parameterName, value);
      }
    }
    /**
     * Deletes a watermark.
     *
     * Create a request for the method "watermarks.unset".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Unset#execute()} method to invoke the remote operation.
     *
     * @param channelId The channelId parameter specifies a YouTube channel ID for which the watermark is being unset.
     * @return the request
     */
    public Unset unset(java.lang.String channelId) throws java.io.IOException {
      Unset result = new Unset(channelId);
      initialize(result);
      return result;
    }

    public class Unset extends YouTubeRequest<Void> {

      private static final String REST_PATH = "watermarks/unset";

      /**
       * Deletes a watermark.
       *
       * Create a request for the method "watermarks.unset".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Unset#execute()} method to invoke the remote operation. <p> {@link
       * Unset#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param channelId The channelId parameter specifies a YouTube channel ID for which the watermark is being unset.
       * @since 1.13
       */
      protected Unset(java.lang.String channelId) {
        super(YouTube.this, "POST", REST_PATH, null, Void.class);
        this.channelId = com.google.api.client.util.Preconditions.checkNotNull(channelId, "Required parameter channelId must be specified.");
      }

      @Override
      public Unset setAlt(java.lang.String alt) {
        return (Unset) super.setAlt(alt);
      }

      @Override
      public Unset setFields(java.lang.String fields) {
        return (Unset) super.setFields(fields);
      }

      @Override
      public Unset setKey(java.lang.String key) {
        return (Unset) super.setKey(key);
      }

      @Override
      public Unset setOauthToken(java.lang.String oauthToken) {
        return (Unset) super.setOauthToken(oauthToken);
      }

      @Override
      public Unset setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Unset) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Unset setQuotaUser(java.lang.String quotaUser) {
        return (Unset) super.setQuotaUser(quotaUser);
      }

      @Override
      public Unset setUserIp(java.lang.String userIp) {
        return (Unset) super.setUserIp(userIp);
      }

      /**
       * The channelId parameter specifies a YouTube channel ID for which the watermark is being
       * unset.
       */
      @com.google.api.client.util.Key
      private java.lang.String channelId;

      /** The channelId parameter specifies a YouTube channel ID for which the watermark is being unset.
       */
      public java.lang.String getChannelId() {
        return channelId;
      }

      /**
       * The channelId parameter specifies a YouTube channel ID for which the watermark is being
       * unset.
       */
      public Unset setChannelId(java.lang.String channelId) {
        this.channelId = channelId;
        return this;
      }

      /**
       * The onBehalfOfContentOwner parameter indicates that the authenticated user is acting on
       * behalf of the content owner specified in the parameter value. This parameter is intended
       * for YouTube content partners that own and manage many different YouTube channels. It allows
       * content owners to authenticate once and get access to all their video and channel data,
       * without having to provide authentication credentials for each individual channel. The
       * actual CMS account that the user authenticates with needs to be linked to the specified
       * YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** The onBehalfOfContentOwner parameter indicates that the authenticated user is acting on behalf of
     the content owner specified in the parameter value. This parameter is intended for YouTube content
     partners that own and manage many different YouTube channels. It allows content owners to
     authenticate once and get access to all their video and channel data, without having to provide
     authentication credentials for each individual channel. The actual CMS account that the user
     authenticates with needs to be linked to the specified YouTube content owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * The onBehalfOfContentOwner parameter indicates that the authenticated user is acting on
       * behalf of the content owner specified in the parameter value. This parameter is intended
       * for YouTube content partners that own and manage many different YouTube channels. It allows
       * content owners to authenticate once and get access to all their video and channel data,
       * without having to provide authentication credentials for each individual channel. The
       * actual CMS account that the user authenticates with needs to be linked to the specified
       * YouTube content owner.
       */
      public Unset setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      @Override
      public Unset set(String parameterName, Object value) {
        return (Unset) super.set(parameterName, value);
      }
    }

  }

  /**
   * Builder for {@link YouTube}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient.Builder {

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport, which should normally be:
     *        <ul>
     *        <li>Google App Engine:
     *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
     *        <li>Android: {@code newCompatibleTransport} from
     *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
     *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
     *        </li>
     *        </ul>
     * @param jsonFactory JSON factory, which may be:
     *        <ul>
     *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
     *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
     *        <li>Android Honeycomb or higher:
     *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
     *        </ul>
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          DEFAULT_ROOT_URL,
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
    }

    /** Builds a new instance of {@link YouTube}. */
    @Override
    public YouTube build() {
      return new YouTube(this);
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setHttpRequestInitializer(com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    @Override
    public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
      return (Builder) super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
    }

    @Override
    public Builder setSuppressAllChecks(boolean suppressAllChecks) {
      return (Builder) super.setSuppressAllChecks(suppressAllChecks);
    }

    /**
     * Set the {@link YouTubeRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setYouTubeRequestInitializer(
        YouTubeRequestInitializer youtubeRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(youtubeRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        com.google.api.client.googleapis.services.GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
